<?php

namespace App\Http\Controllers\Ad;

use App\Http\Controllers\Controller;
use App\Http\Resources\Ads\CategoryVariantListResource;
use App\Http\Resources\Ads\EditResource;
use App\Http\Resources\Ads\ListResource;
use App\Http\Resources\Ads\UserListResource;
use App\Http\Resources\City\CityListResource;
use App\Models\Ads\Ads;
use App\Models\Ads\AdsGallery;
use App\Models\Ads\AdsPrices;
use App\Models\Ads\AdsVariants;
use App\Models\CategoryVariants;
use App\Models\User;
use App\Models\Variant\VariantOptions;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Imagick;
use ImagickDraw;
use Turkey\Cities\Models\City;
use Turkey\Cities\Models\County;

class AdsController extends Controller
{
    public function index(Request $request): JsonResponse
    {
        $perPage = $request->perPage ?? 10;

        $ads = Ads::orderBy('id', 'DESC')->paginate($perPage);

        return response()->json([
            'pagination' => $ads,
            'collection' => ListResource::collection($ads)
        ]);
    }

    public function pendings(Request $request): JsonResponse
    {
        $perPage = $request->perPage ?? 10;

        $ads = Ads::orderBy('id', 'DESC')->where('status', 0)->paginate($perPage);

        return response()->json([
            'pagination' => $ads,
            'collection' => ListResource::collection($ads)
        ]);
    }

    /** Kullanıcı Listesi */
    public function userList(): JsonResponse
    {
        $users = User::all();
        return response()->json(UserListResource::collection($users));
    }

    /** Şehir Listesi */
    public function cityList(): JsonResponse
    {
        $city = City::all();
        return response()->json(CityListResource::collection($city));
    }

    /** İlçe Listesi */
    public function districtList(Request $request): JsonResponse
    {
        $district = County::where('city_id', $request->id)->get();
        return response()->json(CityListResource::collection($district));
    }

    /** Kategori Varyantları */
    public function categoryVariants(Request $request): JsonResponse
    {
        $category = CategoryVariants::where('category_id', $request->id)->get();
        return response()->json(CategoryVariantListResource::collection($category));
    }

    /** İlan Ekle */
    public function store(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'price' => 'required',
            'category' => 'required',
            'user' => 'required',
            'city' => 'required',
            'district' => 'required',
            'description' => 'required',
            'imagesList' => 'required',
            'status' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $ad = new Ads();
        $ad->title = $request->title;
        $ad->price = $request->price;
        $ad->category_id = $request->category;
        $ad->user_id = $request->user;
        $ad->city = $request->city;
        $ad->district = $request->district;
        $ad->description = $request->description;
        $ad->slug = Str::slug($request->title.'-'.rand(111111, 9999999));
        $ad->status = $request->status;
        $ad->save();

        $ad->ad_no = 'ILN' . str_pad($ad->id, 10, '0', STR_PAD_LEFT);
        $ad->save();

        /** İlan Fotoğrafları Yükleme */
        if ($request->imagesList) {
            $files = [];

            foreach ($request->file('imagesList') as $file) {
                $type = $file->extension();
                $name = time() . rand(1111111111,999999999999999) . '.' . $type;

                $galleryPath = storage_path('app/public/uploads/ad/gallery/' . $ad->slug . '/');
                if (!file_exists($galleryPath)) mkdir($galleryPath, 0777, true);

                // Geçici olarak kaydet
                $tempPath = $file->store('temp');
                $fullPath = storage_path('app/' . $tempPath);

                // Imagick nesnesi
                $img = new \Imagick($fullPath);
                $width = $img->getImageWidth();
                $height = $img->getImageHeight();

                /*** WATERMARK ***/
                $draw = new \ImagickDraw();
                $draw->setFont(public_path('fonts/arial.ttf'));
                $watermarkFontSize = min($width, $height) * 0.10;
                $draw->setFontSize($watermarkFontSize);
                $draw->setFillColor(new \ImagickPixel('rgba(255,255,255,0.15)'));
                $draw->setGravity(\Imagick::GRAVITY_CENTER);
                $draw->rotate(45);
                $img->annotateImage($draw, 0, 0, 0, 'talepvar.com.tr');

                /*** İLAN NUMARASI (beyaz kutu + siyah Arial 12px) ***/
                $fontSize = 12;
                $padding = 4;
                $text = '#' . $ad->ad_no;

                $drawMetrics = new \ImagickDraw();
                $drawMetrics->setFont(public_path('fonts/arial.ttf'));
                $drawMetrics->setFontSize($fontSize);
                $metrics = $img->queryFontMetrics($drawMetrics, $text);
                $bgWidth = $metrics['textWidth'] + $padding * 2;
                $bgHeight = $metrics['textHeight'] + $padding * 2;

                $drawBg = new \ImagickDraw();
                $drawBg->setFillColor(new \ImagickPixel('white'));
                $drawBg->rectangle(0, 0, $bgWidth, $bgHeight);
                $img->drawImage($drawBg);

                $drawText = new \ImagickDraw();
                $drawText->setFont(public_path('fonts/arial.ttf'));
                $drawText->setFontSize($fontSize);
                $drawText->setFillColor(new \ImagickPixel('black'));
                $img->annotateImage($drawText, $padding, $fontSize + $padding, 0, $text);

                // Orijinal kaydet
                $img->writeImage($galleryPath . $name);

                /*** THUMBNAIL 300x300 ***/
                $thumb = new \Imagick($fullPath);
                $thumb->cropThumbnailImage(300, 300);
                $thumbName = 'thumb_' . $name;
                $thumb->writeImage($galleryPath . $thumbName);

                $files[] = [
                    'name' => $name,
                    'path' => 'uploads/ad/gallery/' . $ad->slug . '/' . $name,
                    'thumb' => 'uploads/ad/gallery/' . $ad->slug . '/' . $thumbName,
                    'type' => $type
                ];

                unlink($fullPath);
            }

            foreach ($files as $file) {
                $mediaGallery = new AdsGallery();
                $mediaGallery->ads_id = $ad->id;
                $mediaGallery->showcase = 0;
                $mediaGallery->path = $file['path'];
                $mediaGallery->thumb = $file['thumb'];
                $mediaGallery->save();
            }
        }

        /** İlan Fiyatı (Geçmiş Kontrolü İçin) */
        $price = new AdsPrices();
        $price->ads_id = $ad->id;
        $price->price = $request->price;
        $price->save();

        /** İlan Varyantları */
        $varyantOne = array_filter(json_decode($request->variantOne));
        $varyantTwo = array_filter(json_decode($request->variantTwo));
        $varyantThree = array_filter(json_decode($request->variantThree));

        if($varyantOne){
            foreach ($varyantOne as $one){
                $variantGetOne = VariantOptions::find($one);
                $adsVariantOne = new AdsVariants();
                $adsVariantOne->ads_id = $ad->id;
                $adsVariantOne->variant_id = $variantGetOne->variant_id;
                $adsVariantOne->variant_option_id = $variantGetOne->id;
                $adsVariantOne->variant_option = $variantGetOne->name;
                $adsVariantOne->save();
            }
        }

        if($varyantTwo){
            foreach ($varyantTwo as $two){
                $variantGetTwo = VariantOptions::find($two);
                $adsVariantTwo = new AdsVariants();
                $adsVariantTwo->ads_id = $ad->id;
                $adsVariantTwo->variant_id = $variantGetTwo->variant_id;
                $adsVariantTwo->variant_option_id = $variantGetTwo->id;
                $adsVariantTwo->variant_option = $variantGetTwo->name;
                $adsVariantTwo->save();
            }
        }

        if($varyantThree){
            foreach ($varyantThree as $key => $three){
                $adsVariantThree = new AdsVariants();
                $adsVariantThree->ads_id = $ad->id;
                $adsVariantThree->variant_id = $key;
                $adsVariantThree->variant_option_id = null;
                $adsVariantThree->variant_option = $three;
                $adsVariantThree->save();
            }
        }

        return response()->json([
            'status' => 'Success',
            'message' => 'İlan Başarılı Şekilde Eklendi'
        ]);


    }

    public function edit(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $ad = Ads::find($request->id);
        return response()->json(new EditResource($ad));
    }

    /** İlan Güncelle */
    public function update(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required',
            'title' => 'required',
            'price' => 'required',
            'category' => 'required',
            'user' => 'required',
            'city' => 'required',
            'district' => 'required',
            'description' => 'required',
            'status' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $ad = Ads::find($request->id);
        if (!$ad) {
            return response()->json([
                'status' => 'Error',
                'message' => 'İlan Bulunamadı'
            ], 400);
        }
        $ad->title = $request->title;
        $ad->price = $request->price;
        $ad->category_id = $request->category;
        $ad->user_id = $request->user;
        $ad->city = $request->city;
        $ad->district = $request->district;
        $ad->description = $request->description;
        $ad->status = $request->status;
        $ad->save();

        /** İlan Fotoğrafları Yükleme */
        if ($request->imagesList) {
            $files = [];

            foreach ($request->file('imagesList') as $file) {
                $type = $file->extension();
                $name = time() . rand(1111111111,999999999999999) . '.' . $type;

                $galleryPath = storage_path('app/public/uploads/ad/gallery/' . $ad->slug . '/');
                if (!file_exists($galleryPath)) mkdir($galleryPath, 0777, true);

                // Geçici olarak kaydet
                $tempPath = $file->store('temp');
                $fullPath = storage_path('app/' . $tempPath);

                // Imagick nesnesi
                $img = new Imagick($fullPath);
                $width = $img->getImageWidth();
                $height = $img->getImageHeight();

                /*** WATERMARK ***/
                $draw = new ImagickDraw();
                $draw->setFont(public_path('fonts/arial.ttf'));
                $watermarkFontSize = min($width, $height) * 0.10;
                $draw->setFontSize($watermarkFontSize);
                $draw->setFillColor(new \ImagickPixel('rgba(255,255,255,0.15)'));
                $draw->setGravity(\Imagick::GRAVITY_CENTER);
                $draw->rotate(45);
                $img->annotateImage($draw, 0, 0, 0, 'talepvar.com.tr');

                /*** İLAN NUMARASI (beyaz kutu + siyah Arial 12px) ***/
                $fontSize = 12;
                $padding = 4;
                $text = '#' . $ad->id;

                $drawMetrics = new ImagickDraw();
                $drawMetrics->setFont(public_path('fonts/arial.ttf'));
                $drawMetrics->setFontSize($fontSize);
                $metrics = $img->queryFontMetrics($drawMetrics, $text);
                $bgWidth = $metrics['textWidth'] + $padding * 2;
                $bgHeight = $metrics['textHeight'] + $padding * 2;

                $drawBg = new ImagickDraw();
                $drawBg->setFillColor(new \ImagickPixel('white'));
                $drawBg->rectangle(0, 0, $bgWidth, $bgHeight);
                $img->drawImage($drawBg);

                $drawText = new ImagickDraw();
                $drawText->setFont(public_path('fonts/arial.ttf'));
                $drawText->setFontSize($fontSize);
                $drawText->setFillColor(new \ImagickPixel('black'));
                $img->annotateImage($drawText, $padding, $fontSize + $padding, 0, $text);

                // Orijinal kaydet
                $img->writeImage($galleryPath . $name);

                /*** THUMBNAIL 300x300 ***/
                $thumb = new Imagick($fullPath);
                $thumb->cropThumbnailImage(300, 300);
                $thumbName = 'thumb_' . $name;
                $thumb->writeImage($galleryPath . $thumbName);

                $files[] = [
                    'name' => $name,
                    'path' => 'uploads/ad/gallery/' . $ad->slug . '/' . $name,
                    'thumb' => 'uploads/ad/gallery/' . $ad->slug . '/' . $thumbName,
                    'type' => $type
                ];

                unlink($fullPath);
            }

            foreach ($files as $file) {
                $mediaGallery = new AdsGallery();
                $mediaGallery->ads_id = $ad->id;
                $mediaGallery->showcase = 0;
                $mediaGallery->path = $file['path'];
                $mediaGallery->thumb = $file['thumb'];
                $mediaGallery->save();
            }
        }

        /** İlan Fiyatı (Geçmiş Kontrolü İçin) */
        $price = new AdsPrices();
        $price->ads_id = $ad->id;
        $price->price = $request->price;
        $price->save();

        /** İlan Varyantları */
        $varyantOne = array_filter(json_decode($request->variantOne));
        $varyantTwo = array_filter(json_decode($request->variantTwo));
        $varyantThree = array_filter(json_decode($request->variantThree));

        $ad->variants()->delete();

        if($varyantOne){
            foreach ($varyantOne as $one){
                $variantGetOne = VariantOptions::find($one);
                $adsVariantOne = new AdsVariants();
                $adsVariantOne->ads_id = $ad->id;
                $adsVariantOne->variant_id = $variantGetOne->variant_id;
                $adsVariantOne->variant_option_id = $variantGetOne->id;
                $adsVariantOne->variant_option = $variantGetOne->name;
                $adsVariantOne->save();
            }
        }

        if($varyantTwo){
            foreach ($varyantTwo as $two){
                $variantGetTwo = VariantOptions::find($two);
                $adsVariantTwo = new AdsVariants();
                $adsVariantTwo->ads_id = $ad->id;
                $adsVariantTwo->variant_id = $variantGetTwo->variant_id;
                $adsVariantTwo->variant_option_id = $variantGetTwo->id;
                $adsVariantTwo->variant_option = $variantGetTwo->name;
                $adsVariantTwo->save();
            }
        }

        if($varyantThree){
            foreach ($varyantThree as $key => $three){
                $adsVariantThree = new AdsVariants();
                $adsVariantThree->ads_id = $ad->id;
                $adsVariantThree->variant_id = $key;
                $adsVariantThree->variant_option_id = null;
                $adsVariantThree->variant_option = $three;
                $adsVariantThree->save();
            }
        }

        return response()->json([
            'status' => 'Success',
            'message' => 'İlan Başarılı Şekilde Güncellendi'
        ]);


    }

    public function approveOrReject(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required',
            'status' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $ad = Ads::find($request->id);
        if (!$ad) {
            return response()->json([
                'status' => 'Error',
                'message' => 'İlan Bulunamadı'
            ], 400);
        }
        $ad->status = $request->status;
        $ad->cancel_message = $request->cancelMessage ? $request->cancelMessage : null;
        $ad->save();

        return response()->json([
            'status' => 'Success',
            'message' => $request->status === "1" ? 'İlan başarılı şekilde yayınlandı.' : 'İlan yayın için reddedildi'
        ]);


    }

    public function galleryShowcase(Request $request): JsonResponse
    {
        $gallery = AdsGallery::find($request->id);
        if (!$gallery){
            return response()->json([
                'status' => 'Error',
                'message' => 'Fotoğraf Bulunamadı!'
            ], 400);
        }
        if ($request->status !== "1" && $request->status !== "0"){
            return response()->json([
                'status' => 'Error',
                'message' => 'Lütfen Yapılan İşlemin Doğruluğundan Emin Olun!'
            ], 400);
        }
        $gallery->showcase = $request->status;
        $gallery->save();

        return response()->json([
            'status' => 'Success',
            'message' => $request->status === 1 ? 'Fotoğraf Vitrin Fotoğrafı Olarak Değiştirildi.' : 'Fotoğraf Vitrin Fotoğrafından Kaldırıldı.'
        ], 200);
    }
    public function galleryDestroy(Request $request): JsonResponse
    {
        $gallery = AdsGallery::find($request->id);
        if (!$gallery){
            return response()->json([
                'status' => 'Error',
                'message' => 'Fotoğraf Bulunamadı!'
            ], 400);
        }
        if (Storage::disk('public')->exists($gallery->path)) {
            Storage::disk('public')->delete($gallery->path);
        }
        $gallery->delete();

        return response()->json([
            'status' => 'Success',
            'message' => 'Fotoğraf Silindi'
        ], 200);
    }

    public function destroy(Request $request){
        $validator = Validator::make($request->all(), [
            'id' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $ad = Ads::find($request->id);
        if (!$ad) {
            return response()->json([
                'status' => 'Error',
                'message' => 'İlan Bulunamadı'
            ], 400);
        }

        /** Galeri Sil */
        if ($ad->gallery){
            foreach ($ad->gallery as $gallery){
                if (Storage::disk('public')->exists($gallery->path)) {
                    Storage::disk('public')->delete($gallery->path);
                }
                $gallery->delete();
            }
        }

        $ad->prices()->delete();
        $ad->variants()->delete();
        $ad->delete();

        return response()->json([
            'status' => 'Success',
            'message' => 'İlan Başarılı Şekilde Silindi'
        ]);

    }
}
