<?php

namespace App\Http\Controllers;

use App\Http\Resources\Ads\ApiAdViewResource;
use App\Http\Resources\Ads\CategoryVariantListResource;
use App\Http\Resources\Ads\EditResource;
use App\Http\Resources\Api\AdsListResource;
use App\Http\Resources\Api\CategoryViewCatListResource;
use App\Http\Resources\Api\HomeCategoriesListResource;
use App\Http\Resources\Api\MyAdsListResource;
use App\Http\Resources\Api\MyDemandsListResource;
use App\Http\Resources\Category\PopulerCategoriesResource;
use App\Http\Resources\City\CityListResource;
use App\Http\Resources\Demands\ApiDemandViewResource;
use App\Http\Resources\Demands\DemandsListResource;
use App\Http\Resources\Doping\AdsDopingResource;
use App\Http\Resources\Doping\DopingListResource;
use App\Http\Resources\Doping\DopingResource;
use App\Http\Resources\Help\ApiFavoritesListResource;
use App\Http\Resources\Help\ApiListResource;
use App\Http\Resources\Help\ApiOptionsListResource;
use App\Http\Resources\Message\MessageDetailResource;
use App\Http\Resources\Message\MessagesResource;
use App\Http\Resources\NotificationListResource;
use App\Http\Resources\Pages\PagesDetailResource;
use App\Http\Resources\Pages\PagesListResource;
use App\Http\Resources\Settings\HomeSetting;
use App\Http\Resources\User\UserProfileDetailResource;
use App\Models\Ads\Ads;
use App\Models\Ads\AdsDoping;
use App\Models\Ads\AdsGallery;
use App\Models\Ads\AdsPrices;
use App\Models\Ads\AdsVariants;
use App\Models\AuctionBids;
use App\Models\Categories;
use App\Models\CategoryVariants;
use App\Models\Contacts;
use App\Models\Demands\Demands;
use App\Models\DopingPackages;
use App\Models\Favorites;
use App\Models\Helps;
use App\Models\Message\MessageDetails;
use App\Models\Message\Messages;
use App\Models\Notification;
use App\Models\Pages;
use App\Models\Settings\HomeSettings;
use App\Models\User;
use App\Models\Variant\VariantOptions;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Imagick;
use ImagickDraw;
use ImagickDrawException;
use ImagickException;
use ImagickPixel;
use SoapClient;
use Turkey\Cities\Models\City;
use Turkey\Cities\Models\County;

class ApiController extends Controller
{
    public function newPostDetail(): JsonResponse
    {
        $data = [];
        /** Kategoriler */
        $categories = Categories::where('status', 1)->orderBy('id', 'ASC')->get()->toTree();
        $categoryArr = $categories->map($recursive = function ($item) use (&$recursive) {
            $map = [
                'id' => $item->id,
                'label' => $item->name,
                "opened" => false,
                'icon' => $item->icon,
            ];

            if ($item->children->isNotEmpty()) {
                $map['children'] = $item->children->map($recursive);
            }

            return $map;
        });
        $data['categories'] = $categoryArr;

        /** Şehir Listesi */
        $city = City::all();
        $data['city'] = CityListResource::collection($city);

        return response()->json($data);
    }

    /** İlçe Listesi */
    public function districtList(Request $request): JsonResponse
    {
        $district = County::where('city_id', $request->id)->get();
        return response()->json(CityListResource::collection($district));
    }

    /** Kategori Varyantları */
    public function categoryVariants(Request $request): JsonResponse
    {
        $category = CategoryVariants::where('category_id', $request->id)->where('variant_type', 1)
            ->get();

        return response()->json(CategoryVariantListResource::collection($category));
    }

    public function categoryDemandVariants(Request $request): JsonResponse
    {
        $category = CategoryVariants::where('category_id', $request->id)->where('variant_type', 2)
            ->get();

        return response()->json(CategoryVariantListResource::collection($category));
    }

    /** Kategori Detay Varyantları */
    public function categoryViewVariants(Request $request): JsonResponse
    {
        $categoryId = Categories::whereSlug($request->slug)->first();
        $category = CategoryVariants::where('category_id', $categoryId->id)
            ->get();

        return response()->json(CategoryVariantListResource::collection($category));
    }

    /** İlan Ekle
     * @throws ImagickException|ImagickDrawException
     */
    public function adCreate(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'type' => 'required',
            'title' => 'required',
            'price' => 'required',
            'category' => 'required',
            'city' => 'required',
            'district' => 'required',
            'description' => 'required',
            'imagesList' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()->first()
            ], 400);
        }

        if ($request->imagesList) {
            if (count($request->file('imagesList')) < 4) {
                return response()->json([
                    'status' => 'Error',
                    'message' => 'İlan fotoğrafı minimum 4 adet olmalıdır. Lütfen fotoğraf yükleyip tekrar deneyin.'
                ], 400);
            }
        }
        $ad = new Ads();
        $ad->title = $request->title;
        $ad->price = $request->price;
        $ad->category_id = $request->category;
        $ad->user_id = auth('sanctum')->id();
        $ad->city = $request->city;
        $ad->district = $request->district;
        $ad->description = $request->description;
        $ad->slug = Str::slug($request->title . '-' . rand(111111, 9999999));
        $ad->status = 0;
        $ad->type = $request->type;
        if ($request->type === "1") {
            $ad->starting_price = $request->startPrice;
            $ad->minimum_increase = $request->minimumIncrease;
            $ad->start_date = $request->startDate;
            $ad->end_date = $request->endDate;
        }
        $ad->save();
        $ad->ad_no = 'ILN' . str_pad($ad->id, 10, '0', STR_PAD_LEFT);
        $ad->save();


        /** İlan Fotoğrafları Yükleme */
        if ($request->imagesList) {
            $files = [];

            foreach ($request->file('imagesList') as $key => $file) {
                $type = $file->extension();
                $name = time() . rand(1111111111, 999999999999999) . '.' . $type;

                $galleryPath = storage_path('app/public/uploads/ad/gallery/' . $ad->slug . '/');
                if (!file_exists($galleryPath)) mkdir($galleryPath, 0777, true);

                // Geçici olarak kaydet
                $tempPath = $file->store('temp');
                $fullPath = storage_path('app/' . $tempPath);

                // Imagick nesnesi
                $img = new \Imagick($fullPath);

                // Fotoğraf boyutlarını al
                $width = $img->getImageWidth();
                $height = $img->getImageHeight();

                /*** WATERMARK ***/
                $draw = new \ImagickDraw();
                $draw->setFont(public_path('fonts/arial.ttf'));

                $watermarkFontSize = min($width, $height) * 0.10;
                $draw->setFontSize($watermarkFontSize);
                $draw->setFillColor(new \ImagickPixel('rgba(255,255,255,0.15)'));
                $draw->setGravity(\Imagick::GRAVITY_CENTER);
                $draw->rotate(45);
                $img->annotateImage($draw, 0, 0, 0, 'talepvar.com.tr');

                /*** İLAN NUMARASI (beyaz kutu + siyah Arial 12px) ***/
                $fontSize = 12;
                $padding = 4;
                $text = '#' . $ad->ad_no;

                // Metin boyutu için Imagick ölçüm
                $drawMetrics = new \ImagickDraw();
                $drawMetrics->setFont(public_path('fonts/arial.ttf'));
                $drawMetrics->setFontSize($fontSize);
                $metrics = $img->queryFontMetrics($drawMetrics, $text);
                $bgWidth = $metrics['textWidth'] + $padding * 2;
                $bgHeight = $metrics['textHeight'] + $padding * 2;

                // Beyaz arka plan
                $drawBg = new \ImagickDraw();
                $drawBg->setFillColor(new \ImagickPixel('white'));
                $drawBg->rectangle(0, 0, $bgWidth, $bgHeight);
                $img->drawImage($drawBg);

                // Siyah metin
                $drawText = new \ImagickDraw();
                $drawText->setFont(public_path('fonts/arial.ttf'));
                $drawText->setFontSize($fontSize);
                $drawText->setFillColor(new \ImagickPixel('black'));
                $img->annotateImage($drawText, $padding, $fontSize + $padding, 0, $text);

                // Orijinal kaydet
                $img->writeImage($galleryPath . $name);

                /*** THUMBNAIL 300x300 ***/
                $thumb = new \Imagick($fullPath);
                $thumb->cropThumbnailImage(300, 300);
                $thumbName = 'thumb_' . $name;
                $thumb->writeImage($galleryPath . $thumbName);

                // Dosya dizisi
                $files[] = [
                    'name' => $name,
                    'path' => 'uploads/ad/gallery/' . $ad->slug . '/' . $name,
                    'thumb' => 'uploads/ad/gallery/' . $ad->slug . '/' . $thumbName,
                    'type' => $type
                ];

                // Geçici dosyayı sil
                unlink($fullPath);
            }

            // DB kaydı
            foreach ($files as $key => $file) {
                $showcase = $key === 0 ? 1 : 0;
                $mediaGallery = new AdsGallery();
                $mediaGallery->ads_id = $ad->id;
                $mediaGallery->showcase = $showcase;
                $mediaGallery->path = $file['path'];
                $mediaGallery->thumb = $file['thumb'];
                $mediaGallery->save();
            }
        }

        /** İlan Fiyatı (Geçmiş Kontrolü İçin) */
        $price = new AdsPrices();
        $price->ads_id = $ad->id;
        $price->price = $request->price;
        $price->status = 0;
        $price->save();

        /** İlan Varyantları */
        $varyantOne = array_filter(json_decode($request->variantOne));
        $varyantTwo = array_filter(json_decode($request->variantTwo));
        $varyantThree = array_filter(json_decode($request->variantThree));

        if ($varyantOne) {
            foreach ($varyantOne as $one) {
                $variantGetOne = VariantOptions::find($one);
                $adsVariantOne = new AdsVariants();
                $adsVariantOne->ads_id = $ad->id;
                $adsVariantOne->variant_id = $variantGetOne->variant_id;
                $adsVariantOne->variant_option_id = $variantGetOne->id;
                $adsVariantOne->variant_option = $variantGetOne->name;
                $adsVariantOne->save();
            }
        }

        if ($varyantTwo) {
            foreach ($varyantTwo as $two) {
                $variantGetTwo = VariantOptions::find($two);
                $adsVariantTwo = new AdsVariants();
                $adsVariantTwo->ads_id = $ad->id;
                $adsVariantTwo->variant_id = $variantGetTwo->variant_id;
                $adsVariantTwo->variant_option_id = $variantGetTwo->id;
                $adsVariantTwo->variant_option = $variantGetTwo->name;
                $adsVariantTwo->save();
            }
        }

        if ($varyantThree) {
            foreach ($varyantThree as $key => $three) {
                $adsVariantThree = new AdsVariants();
                $adsVariantThree->ads_id = $ad->id;
                $adsVariantThree->variant_id = $key;
                $adsVariantThree->variant_option_id = null;
                $adsVariantThree->variant_option = $three;
                $adsVariantThree->save();
            }
        }

        return response()->json([
            'status' => 'Success',
            'message' => 'İlan Başarılı Şekilde Paylaşıldı'
        ]);

    }

    /** Taleplerim */
    public function myDemands(Request $request): JsonResponse
    {

        $perPage = $request->perPage ?? 10;

        $demands = Demands::where('user_id', auth('sanctum')->id())->orderBy('id', 'DESC')->paginate($perPage);

        return response()->json([
            'pagination' => $demands,
            'collection' => MyDemandsListResource::collection($demands)
        ]);
    }

    /** İlanlarım */
    public function myAds(Request $request): JsonResponse
    {
        \Log::info('myAds API çağrısı yapıldı');
        
        $userId = auth('sanctum')->id();
        \Log::info('Auth user ID: ' . $userId);
        
        $perPage = $request->perPage ?? 10;
        \Log::info('Per page: ' . $perPage);

        $ads = Ads::where('user_id', $userId)->orderBy('id', 'DESC')->paginate($perPage);
        \Log::info('Bulunan ilan sayısı: ' . $ads->count());
        \Log::info('Toplam ilan sayısı: ' . $ads->total());
        
        // Tüm ilanları kontrol et (debug için)
        $allAds = Ads::where('user_id', $userId)->get();
        \Log::info('User için toplam ilan sayısı (pagination olmadan): ' . $allAds->count());
        
        // User'ın tüm ilanlarının ID'lerini logla
        $adIds = $allAds->pluck('id');
        \Log::info('User ilanlarının ID\'leri: ' . $adIds->toJson());

        return response()->json([
            'pagination' => $ads,
            'collection' => MyAdsListResource::collection($ads)
        ]);
    }

    /** Favori İlanlarım */
    public function myFavoriteAds(Request $request): JsonResponse
    {
        $userId = auth('sanctum')->id();
        $perPage = $request->perPage ?? 10;

        $ads = Ads::whereIn('id', function ($query) use ($userId) {
            $query->select('ad_id')
                ->from('favorites')
                ->where('user_id', $userId);
        })
            ->orderBy('id', 'DESC')
            ->paginate($perPage);

        return response()->json([
            'pagination' => $ads,
            'collection' => MyAdsListResource::collection($ads)
        ]);
    }

    /** İlan Düzenleme Detay */
    public function myAdEdit(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'slug' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $ad = Ads::where('slug', $request->slug)->where('user_id', auth('sanctum')->id())->first();
        if (!$ad) {
            return response()->json([
                'status' => 'error',
                'message' => 'İlan Bulunamadı'
            ], 400);
        }
        return response()->json(new EditResource($ad));
    }

    /** Talep Düzenleme Detay */
    public function myDemandEdit(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'slug' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $demand = Demands::where('slug', $request->slug)->where('user_id', auth('sanctum')->id())->first();
        if (!$demand) {
            return response()->json([
                'status' => 'error',
                'message' => 'Talep Bulunamadı'
            ], 400);
        }
        return response()->json(new \App\Http\Resources\Demands\EditResource($demand));
    }

    /** İlan Fotoğraf Silme */
    public function myAdGalleryDestroy(Request $request): JsonResponse
    {
        $gallery = AdsGallery::find($request->id);
        if (!$gallery) {
            return response()->json([
                'status' => 'Error',
                'message' => 'Fotoğraf Bulunamadı!'
            ], 400);
        }

        $ad = Ads::where('id', $gallery->ads_id)->where('user_id', auth('sanctum')->id())->get();
        if (!$ad) {
            return response()->json([
                'status' => 'Error',
                'message' => 'İzinsiz İşlem!'
            ], 400);
        }

        $galleries = AdsGallery::where('ads_id', $gallery->ads_id)->get();
        if (count($galleries) <= 4) {
            return response()->json([
                'status' => 'Error',
                'message' => 'İlan fotoğrafı minimum 4 adet olmalıdır. Lütfen fotoğraf yükleyip tekrar deneyin.'
            ], 400);
        }

        if (Storage::disk('public')->exists($gallery->path)) {
            Storage::disk('public')->delete($gallery->path);
        }

        if ($gallery->thumb && Storage::disk('public')->exists($gallery->thumb)) {
            Storage::disk('public')->delete($gallery->thumb);
        }

        if ($gallery->showcase === 1) {
            $galleries[0]->showcase = 1;
            $galleries[0]->save();
        }
        $gallery->delete();


        return response()->json([
            'status' => 'Success',
            'message' => 'Fotoğraf Silindi'
        ], 200);
    }

    /** İlan Fotoğraf Öne Çıkan */
    public function myAdGalleryShowcase(Request $request): JsonResponse
    {
        $gallery = AdsGallery::find($request->id);
        if (!$gallery) {
            return response()->json([
                'status' => 'Error',
                'message' => 'Fotoğraf Bulunamadı!'
            ], 400);
        }

        $ad = Ads::where('id', $gallery->ads_id)->where('user_id', auth('sanctum')->id())->get();
        if (!$ad) {
            return response()->json([
                'status' => 'Error',
                'message' => 'İzinsiz İşlem!'
            ], 400);
        }
        if ($request->status !== 1 && $request->status !== 0) {
            return response()->json([
                'status' => 'Error',
                'message' => 'Lütfen Yapılan İşlemin Doğruluğundan Emin Olun!'
            ], 400);
        }

        $galleries = AdsGallery::where('ads_id', $gallery->ads_id)->get();
        foreach ($galleries as $item) {
            $item->showcase = 0;
            $item->save();
        }

        $gallery->showcase = $request->status === 0 ? 1 : 0;
        $gallery->save();

        return response()->json([
            'status' => 'Success',
            'message' => $request->status === 0 ? 'Fotoğraf Öne Çıkarıldı.' : 'Fotoğraf Öne Çıkarılandan Kaldırıldı.'
        ], 200);
    }

    /** İlan Güncelleme */
    public function myAdUpdate(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'price' => 'required',
            'category' => 'required',
            'city' => 'required',
            'district' => 'required',
            'description' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $ad = Ads::where('slug', $request->slug)->where('user_id', auth('sanctum')->id())->first();
        if (!$ad) {
            return response()->json([
                'status' => 'Error',
                'message' => 'İlan Bulunamadı'
            ], 400);
        }
        $defaultPrice = $ad->price;
        $ad->title = $request->title;
        $ad->price = $request->price;
        $ad->category_id = $request->category;
        $ad->city = $request->city;
        $ad->district = $request->district;
        $ad->description = $request->description;
        $ad->status = 0;
        $ad->type = $request->type;
        if ($request->type === "1") {
            $ad->starting_price = $request->startPrice;
            $ad->minimum_increase = $request->minimumIncrease;
            $ad->start_date = Carbon::parse($request->startDate)->format('Y-m-d H:i:s');
            $ad->end_date = Carbon::parse($request->endDate)->format('Y-m-d H:i:s');
        }
        $ad->save();
        if (!$ad->ad_no) {
            $ad->ad_no = 'ILN' . str_pad($ad->id, 10, '0', STR_PAD_LEFT);
            $ad->save();
        }

        /** İlan Fotoğrafları Yükleme */
        if ($request->imagesList) {
            $files = [];

            foreach ($request->file('imagesList') as $file) {
                $type = $file->extension();
                $name = time() . rand(1111111111, 999999999999999) . '.' . $type;

                $galleryPath = storage_path('app/public/uploads/ad/gallery/' . $ad->slug . '/');
                if (!file_exists($galleryPath)) mkdir($galleryPath, 0777, true);

                // Geçici olarak kaydet
                $tempPath = $file->store('temp');
                $fullPath = storage_path('app/' . $tempPath);

                // Imagick nesnesi
                $img = new \Imagick($fullPath);
                $width = $img->getImageWidth();
                $height = $img->getImageHeight();

                /*** WATERMARK ***/
                $draw = new \ImagickDraw();
                $draw->setFont(public_path('fonts/arial.ttf'));
                $watermarkFontSize = min($width, $height) * 0.10;
                $draw->setFontSize($watermarkFontSize);
                $draw->setFillColor(new \ImagickPixel('rgba(255,255,255,0.15)'));
                $draw->setGravity(\Imagick::GRAVITY_CENTER);
                $draw->rotate(45);
                $img->annotateImage($draw, 0, 0, 0, 'talepvar.com.tr');

                /*** İLAN NUMARASI (beyaz kutu + siyah Arial 12px) ***/
                $fontSize = 12;
                $padding = 4;
                $text = '#' . $ad->ad_no;

                $drawMetrics = new \ImagickDraw();
                $drawMetrics->setFont(public_path('fonts/arial.ttf'));
                $drawMetrics->setFontSize($fontSize);
                $metrics = $img->queryFontMetrics($drawMetrics, $text);
                $bgWidth = $metrics['textWidth'] + $padding * 2;
                $bgHeight = $metrics['textHeight'] + $padding * 2;

                $drawBg = new \ImagickDraw();
                $drawBg->setFillColor(new \ImagickPixel('white'));
                $drawBg->rectangle(0, 0, $bgWidth, $bgHeight);
                $img->drawImage($drawBg);

                $drawText = new \ImagickDraw();
                $drawText->setFont(public_path('fonts/arial.ttf'));
                $drawText->setFontSize($fontSize);
                $drawText->setFillColor(new \ImagickPixel('black'));
                $img->annotateImage($drawText, $padding, $fontSize + $padding, 0, $text);

                // Orijinal kaydet
                $img->writeImage($galleryPath . $name);

                /*** THUMBNAIL 300x300 ***/
                $thumb = new \Imagick($fullPath);
                $thumb->cropThumbnailImage(300, 300);
                $thumbName = 'thumb_' . $name;
                $thumb->writeImage($galleryPath . $thumbName);

                $files[] = [
                    'name' => $name,
                    'path' => 'uploads/ad/gallery/' . $ad->slug . '/' . $name,
                    'thumb' => 'uploads/ad/gallery/' . $ad->slug . '/' . $thumbName,
                    'type' => $type
                ];

                unlink($fullPath);
            }

            foreach ($files as $file) {
                $mediaGallery = new AdsGallery();
                $mediaGallery->ads_id = $ad->id;
                $mediaGallery->showcase = 0;
                $mediaGallery->path = $file['path'];
                $mediaGallery->thumb = $file['thumb'];
                $mediaGallery->save();
            }
        }

        /** İlan Fiyatı (Geçmiş Kontrolü İçin) */
        if ($defaultPrice != $request->price) {
            $price = new AdsPrices();
            $price->ads_id = $ad->id;
            $price->price = $request->price;
            if ($defaultPrice > $request->price) {
                $price->status = 1;
            } else {
                $price->status = 2;
            }
            $price->save();
        }

        /** İlan Varyantları */
        $varyantOne = array_filter(json_decode($request->variantOne));
        $varyantTwo = array_filter(json_decode($request->variantTwo));
        $varyantThree = array_filter(json_decode($request->variantThree));

        $ad->variants()->delete();

        if ($varyantOne) {
            foreach ($varyantOne as $one) {
                $variantGetOne = VariantOptions::find($one);
                $adsVariantOne = new AdsVariants();
                $adsVariantOne->ads_id = $ad->id;
                $adsVariantOne->variant_id = $variantGetOne->variant_id;
                $adsVariantOne->variant_option_id = $variantGetOne->id;
                $adsVariantOne->variant_option = $variantGetOne->name;
                $adsVariantOne->save();
            }
        }

        if ($varyantTwo) {
            foreach ($varyantTwo as $two) {
                $variantGetTwo = VariantOptions::find($two);
                $adsVariantTwo = new AdsVariants();
                $adsVariantTwo->ads_id = $ad->id;
                $adsVariantTwo->variant_id = $variantGetTwo->variant_id;
                $adsVariantTwo->variant_option_id = $variantGetTwo->id;
                $adsVariantTwo->variant_option = $variantGetTwo->name;
                $adsVariantTwo->save();
            }
        }

        if ($varyantThree) {
            foreach ($varyantThree as $key => $three) {
                $adsVariantThree = new AdsVariants();
                $adsVariantThree->ads_id = $ad->id;
                $adsVariantThree->variant_id = $key;
                $adsVariantThree->variant_option_id = null;
                $adsVariantThree->variant_option = $three;
                $adsVariantThree->save();
            }
        }

        return response()->json([
            'status' => 'Success',
            'message' => 'İlan Başarılı Şekilde Güncellendi'
        ]);


    }

    public function myDemandUpdate(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'price' => 'required',
            'category' => 'required',
            'city' => 'required',
            'district' => 'required',
            'description' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $ad = Ads::where('slug', $request->slug)->where('user_id', auth('sanctum')->id())->first();
        if (!$ad) {
            return response()->json([
                'status' => 'Error',
                'message' => 'İlan Bulunamadı'
            ], 400);
        }
        $defaultPrice = $ad->price;
        $ad->title = $request->title;
        $ad->price = $request->price;
        $ad->category_id = $request->category;
        $ad->city = $request->city;
        $ad->district = $request->district;
        $ad->description = $request->description;
        $ad->status = 0;
        $ad->type = $request->type;
        if ($request->type === "1") {
            $ad->starting_price = $request->startPrice;
            $ad->minimum_increase = $request->minimumIncrease;
            $ad->start_date = Carbon::parse($request->startDate)->format('Y-m-d H:i:s');
            $ad->end_date = Carbon::parse($request->endDate)->format('Y-m-d H:i:s');
        }
        $ad->save();
        if (!$ad->ad_no) {
            $ad->ad_no = 'ILN' . str_pad($ad->id, 10, '0', STR_PAD_LEFT);
            $ad->save();
        }

        /** İlan Fotoğrafları Yükleme */
        if ($request->imagesList) {
            $files = [];

            foreach ($request->file('imagesList') as $file) {
                $type = $file->extension();
                $name = time() . rand(1111111111, 999999999999999) . '.' . $type;

                $galleryPath = storage_path('app/public/uploads/ad/gallery/' . $ad->slug . '/');
                if (!file_exists($galleryPath)) mkdir($galleryPath, 0777, true);

                // Geçici olarak kaydet
                $tempPath = $file->store('temp');
                $fullPath = storage_path('app/' . $tempPath);

                // Imagick nesnesi
                $img = new \Imagick($fullPath);
                $width = $img->getImageWidth();
                $height = $img->getImageHeight();

                /*** WATERMARK ***/
                $draw = new \ImagickDraw();
                $draw->setFont(public_path('fonts/arial.ttf'));
                $watermarkFontSize = min($width, $height) * 0.10;
                $draw->setFontSize($watermarkFontSize);
                $draw->setFillColor(new \ImagickPixel('rgba(255,255,255,0.15)'));
                $draw->setGravity(\Imagick::GRAVITY_CENTER);
                $draw->rotate(45);
                $img->annotateImage($draw, 0, 0, 0, 'talepvar.com.tr');

                /*** İLAN NUMARASI (beyaz kutu + siyah Arial 12px) ***/
                $fontSize = 12;
                $padding = 4;
                $text = '#' . $ad->ad_no;

                $drawMetrics = new \ImagickDraw();
                $drawMetrics->setFont(public_path('fonts/arial.ttf'));
                $drawMetrics->setFontSize($fontSize);
                $metrics = $img->queryFontMetrics($drawMetrics, $text);
                $bgWidth = $metrics['textWidth'] + $padding * 2;
                $bgHeight = $metrics['textHeight'] + $padding * 2;

                $drawBg = new \ImagickDraw();
                $drawBg->setFillColor(new \ImagickPixel('white'));
                $drawBg->rectangle(0, 0, $bgWidth, $bgHeight);
                $img->drawImage($drawBg);

                $drawText = new \ImagickDraw();
                $drawText->setFont(public_path('fonts/arial.ttf'));
                $drawText->setFontSize($fontSize);
                $drawText->setFillColor(new \ImagickPixel('black'));
                $img->annotateImage($drawText, $padding, $fontSize + $padding, 0, $text);

                // Orijinal kaydet
                $img->writeImage($galleryPath . $name);

                /*** THUMBNAIL 300x300 ***/
                $thumb = new \Imagick($fullPath);
                $thumb->cropThumbnailImage(300, 300);
                $thumbName = 'thumb_' . $name;
                $thumb->writeImage($galleryPath . $thumbName);

                $files[] = [
                    'name' => $name,
                    'path' => 'uploads/ad/gallery/' . $ad->slug . '/' . $name,
                    'thumb' => 'uploads/ad/gallery/' . $ad->slug . '/' . $thumbName,
                    'type' => $type
                ];

                unlink($fullPath);
            }

            foreach ($files as $file) {
                $mediaGallery = new AdsGallery();
                $mediaGallery->ads_id = $ad->id;
                $mediaGallery->showcase = 0;
                $mediaGallery->path = $file['path'];
                $mediaGallery->thumb = $file['thumb'];
                $mediaGallery->save();
            }
        }

        /** İlan Fiyatı (Geçmiş Kontrolü İçin) */
        if ($defaultPrice != $request->price) {
            $price = new AdsPrices();
            $price->ads_id = $ad->id;
            $price->price = $request->price;
            if ($defaultPrice > $request->price) {
                $price->status = 1;
            } else {
                $price->status = 2;
            }
            $price->save();
        }

        /** İlan Varyantları */
        $varyantOne = array_filter(json_decode($request->variantOne));
        $varyantTwo = array_filter(json_decode($request->variantTwo));
        $varyantThree = array_filter(json_decode($request->variantThree));

        $ad->variants()->delete();

        if ($varyantOne) {
            foreach ($varyantOne as $one) {
                $variantGetOne = VariantOptions::find($one);
                $adsVariantOne = new AdsVariants();
                $adsVariantOne->ads_id = $ad->id;
                $adsVariantOne->variant_id = $variantGetOne->variant_id;
                $adsVariantOne->variant_option_id = $variantGetOne->id;
                $adsVariantOne->variant_option = $variantGetOne->name;
                $adsVariantOne->save();
            }
        }

        if ($varyantTwo) {
            foreach ($varyantTwo as $two) {
                $variantGetTwo = VariantOptions::find($two);
                $adsVariantTwo = new AdsVariants();
                $adsVariantTwo->ads_id = $ad->id;
                $adsVariantTwo->variant_id = $variantGetTwo->variant_id;
                $adsVariantTwo->variant_option_id = $variantGetTwo->id;
                $adsVariantTwo->variant_option = $variantGetTwo->name;
                $adsVariantTwo->save();
            }
        }

        if ($varyantThree) {
            foreach ($varyantThree as $key => $three) {
                $adsVariantThree = new AdsVariants();
                $adsVariantThree->ads_id = $ad->id;
                $adsVariantThree->variant_id = $key;
                $adsVariantThree->variant_option_id = null;
                $adsVariantThree->variant_option = $three;
                $adsVariantThree->save();
            }
        }

        return response()->json([
            'status' => 'Success',
            'message' => 'İlan Başarılı Şekilde Güncellendi'
        ]);


    }

    /** İlan Detayı */
    public function adView(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'slug' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $ad = Ads::where('slug', $request->slug)->where('status', 1)->first();

        $message = Messages::where('ads_id', $ad->id)->where('sender_id', auth('sanctum')->id())->first();

        $userId = auth('sanctum')->id();

        $favorite = Favorites::where('user_id', $userId)
            ->where('ad_id', $ad->id)
            ->exists();

        $favoriteStatus = $favorite ? 1 : 0;

        return response()->json([
            'ad' => new ApiAdViewResource($ad),
            'message' => [
                'id' => $message ? $message->uniq : null,
                'check' => (bool)$message
            ],
            'favorite' => $favoriteStatus
        ]);
    }

    /** Talep Detayı */
    public function demandView(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'slug' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $demand = Demands::where('slug', $request->slug)->where('status', 1)->first();

        if(!$demand){
            return response()->json([
                'status' => 'Error',
                'message' => 'Talep Bulunamadı'
            ], 422);
        }

        $message = Messages::where('demand_id', $demand->id)->where('sender_id', auth('sanctum')->id())->first();

        return response()->json([
            'ad' => new ApiDemandViewResource($demand),
            'message' => [
                'id' => $message ? $message->uniq : null,
                'check' => (bool)$message
            ]
        ]);
    }

    /** Ana Sayfa Verileri */
    public function homeData(Request $request): JsonResponse
    {
        /** Ana Sayfa Ayarı Çek */
        $homeSetting = HomeSettings::where('id', 1)->first();

        /** İlanları Listele */
        $currentDateTime = Carbon::now();
        $ads = Ads::with(['dopings.dopingPackage', 'prices'])
            ->where('status', 1)
            ->limit(20);

        if ($request->city && City::find($request->city)) {
            $ads->where('city', $request->city);
        }

        $ads = $ads->get();

        // type=1 dopingi olan reklamları filtrele
        $adsWithType1Dopings = $ads->filter(function ($ad) {
            return $ad->dopings->where('dopingPackage.type', 1)->isNotEmpty();
        });

        // type=1 dopingi olmayan reklamlar
        $adsWithoutType1Dopings = $ads->filter(function ($ad) {
            return $ad->dopings->where('dopingPackage.type', 1)->isEmpty();
        });

        // type=1 dopingi olanları start_date'e göre sırala
        $sortedAds = $adsWithType1Dopings->sortByDesc(function ($ad) {
            return $ad->dopings->where('dopingPackage.type', 1)->first()->start_date ?? null;
        });

        // type=1 dopingi olmayanları sona ekle
        $sortedAds = $sortedAds->concat($adsWithoutType1Dopings);

        /** Kategorileri Listele */
        $categories = Categories::where('parent_id', null)
            ->where('status', 1)
            ->get();

        $now = Carbon::now('Europe/Istanbul');
        $urgentAds = Ads::with(['dopings.dopingPackage', 'prices'])
            ->where('status', 1)
            ->whereHas('dopings', function ($q) use ($now) {
                $q->whereHas('dopingPackage', function ($q2) {
                    $q2->where('type', 2);
                })
                    ->where('status', 1)
                    ->where('start_date', '<=', $now)
                    ->where('end_date', '>=', $now);
            })
            ->latest()
            ->take(4)
            ->get();

        $demands = Demands::where('status', 1)->latest()->limit(8)->get();

        return response()->json([
            'homeSetting' => $homeSetting ? new HomeSetting($homeSetting) : [],
            'categories' => HomeCategoriesListResource::collection($categories),
            'ads' => AdsListResource::collection($sortedAds),
            'urgents' => AdsListResource::collection($urgentAds),
            'demands' => DemandsListResource::collection($demands)
        ]);
    }


    /** Kategori Verileri */
    public function categoryAds(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'slug' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $catagory = Categories::whereSlug($request->slug)->first();
        if (!$catagory) {
            return response()->json([
                'status' => 'Error',
                'message' => 'Kategori Bulunamadı'
            ], 400);
        }

        /** Kategorileri Listele */
        $categories = Categories::ancestorsAndSelf($catagory->id);
        $categoriesIds = Categories::descendantsAndSelf($catagory->id);
        $catagoryArr = [];
        $categoryIds = [];
        $catagoryArr[] = [
            'label' => 'Ana Sayfa',
            'hideLabel' => false,
            'icon' => 'lucide:home',
            'to' => '/'
        ];
        foreach ($categories as $item) {
            $catagoryArr[] = [
                'label' => $item->name,
                'hideLabel' => false,
                'to' => '/category/' . $item->slug
            ];
        }
        foreach ($categoriesIds as $item) {
            $categoryIds[] = $item->id;
        }

        /** İlanları Listele */
        $currentDateTime = now();
        $perPage = $request->perPage ?? 9;
        $filterVariantThree = $request->filterVariantThree;
        $filterVariantTwo = $request->filterVariantTwo;
        $filterVariantOne = $request->filterVariantOne;
        $filterAdType = $request->filterAdType;

        $adsQuery = Ads::whereIn('category_id', $categoryIds)
            ->with(['dopings.dopingPackage', 'prices'])
            ->where('status', 1);

        if ($filterAdType !== null) {
            $adsQuery->where('type', $filterAdType);
        }

        /** Filtrelemeler -- Başlangıç -- */
        if ($filterVariantOne) {
            $adsQuery->whereHas('variants', function ($query) use ($filterVariantOne) {
                $query->whereNotNull('variant_option_id')
                    ->whereIn('variant_option_id', $filterVariantOne);
            });
        }

        if ($filterVariantTwo) {
            $adsQuery->whereHas('variants', function ($query) use ($filterVariantTwo) {
                $query->whereNotNull('variant_option_id')
                    ->whereIn('variant_option_id', $filterVariantTwo);
            });
        }

        if ($filterVariantThree) {
            $adsQuery->whereHas('variants', function ($query) use ($filterVariantThree) {
                $query->whereNotNull('variant_option')
                    ->whereIn('variant_option', $filterVariantThree);
            });
        }

        if ($request->city && City::find($request->city)) {
            $adsQuery->where('city', $request->city);
        }

        if ($request->filterMinPrice !== null) {
            $adsQuery->where('price', '>=', $request->filterMinPrice);
        }

        if ($request->filterMaxPrice !== null) {
            $adsQuery->where('price', '<=', $request->filterMaxPrice);
        }
        /** Filtrelemeler -- Bitiş -- */

        // Sayfalama
        $ads = $adsQuery->paginate($perPage);

        // type=1 dopingi olan reklamlar
        $adsWithType1Dopings = $ads->filter(function ($ad) use ($currentDateTime) {
            return $ad->dopings
                ->where('dopingPackage.type', 1)
                ->where('start_date', '<=', $currentDateTime)
                ->where('end_date', '>=', $currentDateTime)
                ->where('status', 1)
                ->isNotEmpty();
        });

        // type=1 dopingi olmayan reklamlar
        $adsWithoutType1Dopings = $ads->filter(function ($ad) use ($currentDateTime) {
            return $ad->dopings
                ->where('dopingPackage.type', 1)
                ->where('start_date', '<=', $currentDateTime)
                ->where('end_date', '>=', $currentDateTime)
                ->where('status', 1)
                ->isEmpty();
        });

        // type=1 dopingi olanları start_date'e göre sırala
        $sortedAds = $adsWithType1Dopings->sortByDesc(function ($ad) {
            return $ad->dopings
                ->where('dopingPackage.type', 1)
                ->first()
                ->start_date ?? null;
        });

        // type=1 dopingi olmayanları sona ekle
        $sortedAds = $sortedAds->concat($adsWithoutType1Dopings);

        // Pagination verilerini al
        $paginationData = $ads->toArray();
        unset($paginationData['data']);

        $categorie = Categories::where('parent_id', $catagory->id)->where('status', 1)->get();

        return response()->json([
            'breadcrumbs' => $catagoryArr,
            'ads' => AdsListResource::collection($sortedAds),
            'pagination' => $paginationData,
            'categories' => CategoryViewCatListResource::collection($categorie),
        ]);
    }

    /** Arama Yap */
    public function searchAds(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'query_text' => 'required|string|min:2',
            'min_price' => 'nullable|numeric|min:0',
            'max_price' => 'nullable|numeric|min:0',
            'ad_type'   => 'nullable|in:0,1', // 0=Normal, 1=Açık Arttırma
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $searchText = $request->query_text;
        $perPage = $request->perPage ?? 10;
        $currentDateTime = now();

        $adsQuery = Ads::with(['dopings.dopingPackage', 'prices'])
            ->where('status', 1)
            ->where(function ($q) use ($searchText) {
                $q->where('title', 'LIKE', "%{$searchText}%")
                    ->orWhere('ad_no', 'LIKE', "%{$searchText}%");
            });


        if ($request->filled('min_price')) {
            $adsQuery->where('price', '>=', $request->min_price);
        }
        if ($request->filled('max_price')) {
            $adsQuery->where('price', '<=', $request->max_price);
        }


        if (!is_null($request->ad_type)) {
            $adsQuery->where('type', $request->ad_type);
        }

        $ads = $adsQuery->paginate($perPage);


        $adsWithType1Dopings = $ads->filter(function ($ad) use ($currentDateTime) {
            return $ad->dopings
                ->where('dopingPackage.type', 1)
                ->where('start_date', '<=', $currentDateTime)
                ->where('end_date', '>=', $currentDateTime)
                ->where('status', 1)
                ->isNotEmpty();
        });


        $adsWithoutType1Dopings = $ads->filter(function ($ad) use ($currentDateTime) {
            return $ad->dopings
                ->where('dopingPackage.type', 1)
                ->where('start_date', '<=', $currentDateTime)
                ->where('end_date', '>=', $currentDateTime)
                ->where('status', 1)
                ->isEmpty();
        });


        $sortedAds = $adsWithType1Dopings->sortByDesc(function ($ad) {
            return $ad->dopings
                ->where('dopingPackage.type', 1)
                ->first()
                ->start_date ?? null;
        });


        $sortedAds = $sortedAds->concat($adsWithoutType1Dopings);


        $paginationData = $ads->toArray();
        unset($paginationData['data']);

        return response()->json([
            'ads' => AdsListResource::collection($sortedAds),
            'pagination' => $paginationData,
        ]);
    }

    public function searchAll(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'query_text' => 'required|string|min:2',
            'min_price'  => 'nullable|numeric|min:0',
            'max_price'  => 'nullable|numeric|min:0',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status'  => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $searchText = $request->query_text;
        $perPage    = $request->perPage ?? 10;
        $currentDateTime = now();

        /** ----------------
         *  Ads (İlanlar)
         * ---------------- */
        $adsQuery = Ads::with(['dopings.dopingPackage', 'prices'])
            ->where('status', 1)
            ->where(function ($q) use ($searchText) {
                $q->where('title', 'LIKE', "%{$searchText}%")
                    ->orWhere('ad_no', 'LIKE', "%{$searchText}%");
            });

        if ($request->filled('min_price')) {
            $adsQuery->where('price', '>=', $request->min_price);
        }
        if ($request->filled('max_price')) {
            $adsQuery->where('price', '<=', $request->max_price);
        }

        $ads = $adsQuery->paginate($perPage);

        // type=1 dopingi olanlar
        $adsWithType1Dopings = $ads->filter(function ($ad) use ($currentDateTime) {
            return $ad->dopings
                ->where('dopingPackage.type', 1)
                ->where('start_date', '<=', $currentDateTime)
                ->where('end_date', '>=', $currentDateTime)
                ->where('status', 1)
                ->isNotEmpty();
        });

        // type=1 dopingi olmayanlar
        $adsWithoutType1Dopings = $ads->filter(function ($ad) use ($currentDateTime) {
            return $ad->dopings
                ->where('dopingPackage.type', 1)
                ->where('start_date', '<=', $currentDateTime)
                ->where('end_date', '>=', $currentDateTime)
                ->where('status', 1)
                ->isEmpty();
        });

        // Önce dopingliler sonra diğerleri
        $sortedAds = $adsWithType1Dopings->sortByDesc(function ($ad) {
            return $ad->dopings
                ->where('dopingPackage.type', 1)
                ->first()
                ->start_date ?? null;
        })->concat($adsWithoutType1Dopings);

        $adsPagination = $ads->toArray();
        unset($adsPagination['data']);


        /** ----------------
         *  Demands (Talepler)
         * ---------------- */
        $demandsQuery = Demands::where('status', 1)
            ->where(function ($q) use ($searchText) {
                $q->where('title', 'LIKE', "%{$searchText}%")
                    ->orWhere('description', 'LIKE', "%{$searchText}%");
            });

        if ($request->filled('min_price')) {
            $demandsQuery->where('min_price', '>=', $request->min_price);
        }
        if ($request->filled('max_price')) {
            $demandsQuery->where('max_price', '<=', $request->max_price);
        }

        $demands = $demandsQuery->paginate($perPage);
        $demandsPagination = $demands->toArray();
        unset($demandsPagination['data']);


        /** ----------------
         *  Response
         * ---------------- */
        return response()->json([
            'ads' => [
                'data'       => AdsListResource::collection($sortedAds),
                'pagination' => $adsPagination,
            ],
            'demands' => [
                'data'       => DemandsListResource::collection($demands),
                'pagination' => $demandsPagination,
            ],
        ]);
    }


    /** Popüler Kategoriler */

    public function populerCategories(): JsonResponse
    {
        $categories = Categories::where('status', 1)->where('populer_status', 1)->get();
        return response()->json(PopulerCategoriesResource::collection($categories));
    }

    /** Acil Acil Verileri */
    public function urgentAds(Request $request): JsonResponse
    {
        /** İlanları Listele */
        $currentDateTime = now();
        $perPage = $request->perPage ?? 9;
        $filterVariantThree = $request->filterVariantThree;
        $filterVariantTwo = $request->filterVariantTwo;
        $filterVariantOne = $request->filterVariantOne;
        $filterAdType = $request->filterAdType;

        $adsQuery = Ads::with(['dopings.dopingPackage', 'prices'])
            ->where('status', 1)
            ->whereHas('dopings.dopingPackage', function ($q) use ($currentDateTime) {
                $q->where('type', 2) // sadece acil dopingi
                ->where('start_date', '<=', $currentDateTime)
                    ->where('end_date', '>=', $currentDateTime)
                    ->where('status', 1);
            });

        if ($filterAdType !== null) {
            $adsQuery->where('type', $filterAdType);
        }

        /** Filtrelemeler -- Başlangıç -- */
        if ($filterVariantOne) {
            $adsQuery->whereHas('variants', function ($query) use ($filterVariantOne) {
                $query->whereNotNull('variant_option_id')
                    ->whereIn('variant_option_id', $filterVariantOne);
            });
        }

        if ($filterVariantTwo) {
            $adsQuery->whereHas('variants', function ($query) use ($filterVariantTwo) {
                $query->whereNotNull('variant_option_id')
                    ->whereIn('variant_option_id', $filterVariantTwo);
            });
        }

        if ($filterVariantThree) {
            $adsQuery->whereHas('variants', function ($query) use ($filterVariantThree) {
                $query->whereNotNull('variant_option')
                    ->whereIn('variant_option', $filterVariantThree);
            });
        }

        if ($request->city && City::find($request->city)) {
            $adsQuery->where('city', $request->city);
        }

        if ($request->filterMinPrice !== null) {
            $adsQuery->where('price', '>=', $request->filterMinPrice);
        }

        if ($request->filterMaxPrice !== null) {
            $adsQuery->where('price', '<=', $request->filterMaxPrice);
        }
        /** Filtrelemeler -- Bitiş -- */

        // Sayfalama
        $ads = $adsQuery->paginate($perPage);

        // Pagination verilerini al
        $paginationData = $ads->toArray();
        unset($paginationData['data']);

        return response()->json([
            'breadcrumbs' => [],
            'ads' => AdsListResource::collection($ads),
            'pagination' => $paginationData,
        ]);
    }

    /** Talep Verileri */
    public function demands(Request $request): JsonResponse
    {
        $perPage = $request->perPage ?? 9;
        $demandsQuery = Demands::where('status', 1);

        $breadcrumbs = [];
        $categoriesList = [];

        /** Kategori filtreleme */
        if ($request->category) {
            $category = Categories::where('slug', $request->category)->first();

            if ($category) {
                // Hem kendisi hem alt kategorileri al
                $categoryIds = Categories::descendantsAndSelf($category->id)->pluck('id')->toArray();
                $demandsQuery->whereIn('category_id', $categoryIds);

                // Breadcrumbs oluştur
                $breadcrumbs[] = [
                    'label' => 'Ana Sayfa',
                    'hideLabel' => false,
                    'icon' => 'lucide:home',
                    'to' => '/',
                ];
                $ancestors = Categories::ancestorsAndSelf($category->id);
                foreach ($ancestors as $item) {
                    $breadcrumbs[] = [
                        'label' => $item->name,
                        'hideLabel' => false,
                        'to' => '/demands/' . $item->slug,
                    ];
                }

                // Alt kategoriler
                $categoriesList = Categories::where('parent_id', $category->id)
                    ->where('status', 1)
                    ->get();
            }
        } else {
            // Kategori seçilmediyse ana kategoriler
            $categoriesList = Categories::whereNull('parent_id')
                ->where('status', 1)
                ->get();
        }

        /** Variant filtreleri */
        if ($request->filterVariantOne) {
            $demandsQuery->whereHas('variants', function ($query) use ($request) {
                $query->whereIn('variant_option_id', $request->filterVariantOne);
            });
        }

        if ($request->filterVariantTwo) {
            $demandsQuery->whereHas('variants', function ($query) use ($request) {
                $query->whereIn('variant_option_id', $request->filterVariantTwo);
            });
        }

        if ($request->filterVariantThree) {
            $demandsQuery->whereHas('variants', function ($query) use ($request) {
                $query->whereIn('variant_option', $request->filterVariantThree);
            });
        }

        /** Şehir filtresi */
        if ($request->city && City::find($request->city)) {
            $demandsQuery->where('city', $request->city);
        }

        /** Fiyat filtreleri */
        if ($request->filterMinPrice !== null) {
            $demandsQuery->where('min_price', '>=', $request->filterMinPrice);
        }

        if ($request->filterMaxPrice !== null) {
            $demandsQuery->where('max_price', '<=', $request->filterMaxPrice);
        }

        // Sayfalama
        $demands = $demandsQuery->paginate($perPage);
        $paginationData = $demands->toArray();
        unset($paginationData['data']);

        return response()->json([
            'breadcrumbs' => $breadcrumbs,
            'demands' => DemandsListResource::collection($demands),
            'pagination' => $paginationData,
            'categories' => CategoryViewCatListResource::collection($categoriesList),
        ]);
    }


    /** Şehir - İlçe Seçimi */
    public function selectCity(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'city' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }
        $city = strtoupper($request->city);
        $city = City::where('name', $city)->first();
        if (!$city) {
            return response()->json([
                'status' => 'Error',
                'message' => 'Şehir Bulunamadı'
            ], 400);
        }

        return response()->json([
            'id' => $city->id,
            'name' => $this->ucwords_tr(strtolower($city->name))
        ]);
    }

    /** İlk Mesaj Gönder */
    public function firstMessageSend(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'slug' => 'required',
            'message' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $ad = Ads::where('slug', $request->slug)->where('status', 1)->first();
        if (!$ad) {
            return response()->json([
                'status' => 'Error',
                'message' => 'İlan Bulunamadı'
            ], 400);
        }

        $messageCheck = Messages::where('ads_id', $ad->id)->where('sender_id', auth('sanctum')->id())->first();
        if ($messageCheck) {
            return response()->json('/messages/' . $messageCheck->uniq);
        }

        $message = new Messages();
        $message->ads_id = $ad->id;
        $message->sender_id = auth('sanctum')->id();
        $message->recipient_id = $ad->user_id;
        $message->status = 1;
        $message->uniq = uniqid();
        $message->save();

        $messageDetail = new MessageDetails();
        $messageDetail->message_id = $message->id;
        $messageDetail->message = $request->message;
        $messageDetail->offer = null;
        $messageDetail->image = null;
        $messageDetail->type = 0;
        $messageDetail->save();

        $user = User::find(auth('sanctum')->id());

        $notification = new Notification();
        $notification->user_id = $ad->user_id;
        $notification->title = '<b>' . $user->name . '</b> size mesaj gönderdi.';
        $notification->type = 2;
        $notification->status = 1;
        $notification->url = '/messages/' . $message->uniq;
        $notification->save();


        return response()->json('/messages/' . $message->uniq);
    }

    public function firstDemandMessageSend(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'slug' => 'required',
            'message' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $demand = Demands::where('slug', $request->slug)->where('status', 1)->first();
        if (!$demand) {
            return response()->json([
                'status' => 'Error',
                'message' => 'Talep Bulunamadı'
            ], 400);
        }

        $messageCheck = Messages::where('demand_id', $demand->id)->where('sender_id', auth('sanctum')->id())->first();
        if ($messageCheck) {
            return response()->json('/messages/' . $messageCheck->uniq);
        }

        $message = new Messages();
        $message->demand_id = $demand->id;
        $message->sender_id = auth('sanctum')->id();
        $message->recipient_id = $demand->user_id;
        $message->status = 1;
        $message->uniq = uniqid();
        $message->save();

        $messageDetail = new MessageDetails();
        $messageDetail->message_id = $message->id;
        $messageDetail->message = $request->message;
        $messageDetail->offer = null;
        $messageDetail->image = null;
        $messageDetail->type = 0;
        $messageDetail->save();

        $user = User::find(auth('sanctum')->id());

        $notification = new Notification();
        $notification->user_id = $demand->user_id;
        $notification->title = '<b>' . $user->name . '</b> size mesaj gönderdi.';
        $notification->type = 2;
        $notification->status = 1;
        $notification->url = '/messages/' . $message->uniq;
        $notification->save();


        return response()->json('/messages/' . $message->uniq);
    }

    /** Fiyat Teklifi Gönder */
    public function offerMessageSend(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'slug' => 'required',
            'price' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }
        $ad = Ads::where('slug', $request->slug)->where('status', 1)->first();
        if (!$ad) {
            return response()->json([
                'status' => 'Error',
                'message' => 'İlan Bulunamadı'
            ], 400);
        }

        $messageCheck = Messages::where('ads_id', $ad->id)->where('sender_id', auth('sanctum')->id())->first();
        $messageDetail = new MessageDetails();
        $user = User::find(auth('sanctum')->id());
        $messageUrl = '';
        if ($messageCheck) {
            $messageUrl = '/messages/' . $messageCheck->uniq;
            $messageDetail->message_id = $messageCheck->id;
            $messageDetail->message = null;
            $messageDetail->offer = $request->price;
            $messageDetail->image = null;
            $messageDetail->type = 0;
            $messageDetail->save();


            $notification = new Notification();
            $notification->user_id = $ad->user_id;
            $notification->title = '<b>' . $user->name . '</b> size fiyat teklifi gönderdi.';
            $notification->type = 3;
            $notification->url = '/messages/' . $messageCheck->uniq;
            $notification->status = 1;
            $notification->save();
        } else {
            $message = new Messages();
            $message->ads_id = $ad->id;
            $message->sender_id = auth('sanctum')->id();
            $message->recipient_id = $ad->user_id;
            $message->status = 1;
            $message->uniq = uniqid();
            $message->save();

            $messageDetail->message_id = $message->id;
            $messageDetail->message = null;
            $messageDetail->offer = $request->price;
            $messageDetail->image = null;
            $messageDetail->type = 0;
            $messageDetail->save();
            $messageUrl = '/messages/' . $message->uniq;

            $notification = new Notification();
            $notification->user_id = $ad->user_id;
            $notification->title = '<b>' . $user->name . '</b> size fiyat teklifi gönderdi.';
            $notification->type = 3;
            $notification->url = '/messages/' . $message->uniq;
            $notification->status = 1;
            $notification->save();
        }


        return response()->json($messageUrl);
    }

    /** Açık Artırma Fiyat Teklifi */
    public function auctionBid(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'price_offer' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()->first()
            ], 400);
        }
        $ad = Ads::where('slug', $request->slug)->where('status', 1)->first();
        if (!$ad) {
            return response()->json([
                'status' => 'Error',
                'message' => 'İlan Bulunamadı'
            ], 400);
        }

        if ($ad->type != 1) {
            return response()->json([
                'status' => 'error',
                'message' => 'Bu ilana teklif verilemez.'
            ], 400);
        }

        $now = Carbon::now('Asia/Istanbul');
        if ($ad->start_date && $ad->start_date > $now) {
            return response()->json([
                'status' => 'error',
                'message' => 'Açık artırma henüz başlamadı.'
            ], 400);
        }

        if ($ad->end_date && $ad->end_date < $now) {
            return response()->json([
                'status' => 'error',
                'message' => 'Açık artırma sona erdi.'
            ], 400);
        }
        $price_offer = $request->price_offer;

        $lastBid = AuctionBids::where('ad_id', $ad->id)
            ->latest('id')
            ->first();

        if (!$lastBid) {
            $minRequired = $ad->starting_price + $ad->minimum_increase;

            if ($price_offer < $minRequired) {
                return response()->json([
                    'status' => 'error',
                    'message' => 'İlk teklif en az ' . number_format($minRequired, 2) . ' TL olmalı.'
                ], 400);
            }
        } else {
            $minRequired = $lastBid->amount + $ad->minimum_increase;

            if ($price_offer <= $lastBid->amount) {
                return response()->json([
                    'status' => 'error',
                    'message' => 'Teklif, son tekliften büyük olmalı.'
                ], 400);
            }

            if ($price_offer < $minRequired) {
                return response()->json([
                    'status' => 'error',
                    'message' => 'Teklif en az ' . number_format($ad->minimum_increase, 2) . ' TL artırılmalı.'
                ], 400);
            }
        }

        if ($lastBid && $lastBid->user_id === auth('sanctum')->id()) {
            return response()->json([
                'status' => 'error',
                'message' => 'Son teklifi zaten siz verdiniz. Üst üste teklif veremezsiniz.'
            ], 400);
        }

        $bidUser = User::find(auth('sanctum')->id());

        $newBid = new AuctionBids();
        $newBid->user_id = auth('sanctum')->id();
        $newBid->ad_id = $ad->id;
        $newBid->price_offer = $price_offer;
        $newBid->save();

        $notification = new Notification();
        $notification->user_id = $ad->user_id;
        $notification->title = '<b>' . $bidUser->name . '</b> açık artırma teklifi verdi.';
        $notification->type = 3;
        $notification->url = '/ad/' . $ad->slug;
        $notification->status = 1;
        $notification->save();


        return response()->json([
            'status' => 'success',
            'message' => 'Açık Artırma Teklifi Yapıldı'
        ]);
    }

    /** Açık Artırma Mesajı */

    public function auctionMessageSend(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'slug' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()->first()
            ], 400);
        }

        $ad = Ads::where('slug', $request->slug)
            ->where('status', 1)
            ->first();

        if (!$ad) {
            return response()->json([
                'status' => 'Error',
                'message' => 'İlan Bulunamadı'
            ], 400);
        }

        $now = Carbon::now('Asia/Istanbul');
        if (!$ad->end_date || $ad->end_date > $now) {
            return response()->json([
                'status' => 'Error',
                'message' => 'Açık artırma henüz bitmedi.'
            ], 400);
        }

        // Son teklifi alan kullanıcı kim?
        $lastBid = AuctionBids::where('ad_id', $ad->id)
            ->latest('id')
            ->first();

        if (!$lastBid || $lastBid->user_id !== auth('sanctum')->id()) {
            return response()->json([
                'status' => 'Error',
                'message' => 'Siz açık artırmayı kazanmadığınız için mesaj gönderemezsiniz.'
            ], 400);
        }


        $messageCheck = Messages::where('ads_id', $ad->id)
            ->where('sender_id', auth('sanctum')->id())
            ->first();

        $messageDetail = new MessageDetails();
        $user = User::find(auth('sanctum')->id());
        $messageUrl = '';

        $offerPrice = $lastBid->price_offer;

        if ($messageCheck) {
            $messageUrl = '/messages/' . $messageCheck->uniq;
        } else {
            $message = new Messages();
            $message->ads_id = $ad->id;
            $message->sender_id = auth('sanctum')->id();
            $message->recipient_id = $ad->user_id;
            $message->status = 1;
            $message->uniq = uniqid();
            $message->save();

            $messageDetail->message_id = $message->id;
            $messageDetail->message = 'Açık Artırma Teklifim Kazandı.';
            $messageDetail->offer = $offerPrice;
            $messageDetail->image = null;
            $messageDetail->type = 0;
            $messageDetail->save();
            $messageUrl = '/messages/' . $message->uniq;

            $notification = new Notification();
            $notification->user_id = $ad->user_id;
            $notification->title = '<b>' . $user->name . '</b> açık artırma teklifini kazandı size mesaj gönderdi.';
            $notification->type = 3;
            $notification->url = $messageUrl;
            $notification->status = 1;
            $notification->save();
        }

        return response()->json($messageUrl);
    }

    /** Mesaj Gönder */
    public function messageSend(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'uniq' => 'required',
            'message' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $message = Messages::where('uniq', $request->uniq)->where(function ($query) {
            $userId = auth('sanctum')->id();
            $query->where('sender_id', $userId)
                ->orWhere('recipient_id', $userId);
        })->first();
        $message->status = 1;
        $message->sender_status = $message->recipient_id === auth('sanctum')->id() ? 1 : 0;
        $message->recipient_status = $message->sender_id === auth('sanctum')->id() ? 1 : 0;
        $message->save();

        $messageDetail = new MessageDetails();
        $messageDetail->message_id = $message->id;
        $messageDetail->message = $request->message;
        $messageDetail->offer = $request->offer ? $request->offer : null;
        $messageDetail->image = null;
        $messageDetail->type = $message->sender_id === auth('sanctum')->id() ? 0 : 1;
        $messageDetail->save();

        return response()->json([
            'status' => 'success',
            'message' => 'Mesaj Gönderildi'
        ]);
    }

    /** Mesaj Detayları */
    public function messageDetail(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'uniq' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $userId = auth('sanctum')->id();
        $message = Messages::where('uniq', $request->uniq)->where(function ($query) use ($userId) {

            $query->where('sender_id', $userId)
                ->orWhere('recipient_id', $userId);
        })->first();

        if (!$message) {
            return response()->json([
                'status' => 'Error',
                'message' => 'Mesaj Bulunamadı!'
            ], 400);
        }

        if ($message->sender_id === $userId) {
            $message->sender_status = 0;
        } else {
            $message->recipient_status = 0;
        }
        $message->save();


        return response()->json(new MessageDetailResource($message));

    }

    /** Mesaj Durumu Kontrol */
    public function messageStatus(): JsonResponse
    {
        $userId = auth('sanctum')->id();
        $message = Messages::where(function ($query) use ($userId) {

            $query->where('sender_id', $userId)
                ->orWhere('recipient_id', $userId);
        })->first();
        if ($message->sender_id === $userId) {
            $status = $message->sender_status;
        } else {
            $status = $message->recipient_status;
        }

        $notification = Notification::where('user_id', $userId)->limit(6)->orderBy('id', 'desc')->get();
        $notification_status = Notification::where('user_id', $userId)->where('status', 1)->get();

        return response()->json([
            'message' => $status,
            'notification' => NotificationListResource::collection($notification),
            'notification_status' => count($notification_status),
        ]);
    }

    /** Tüm Bildirimler Okundu İşaretle */
    public function notificationStatusChange(): JsonResponse
    {
        $notification = Notification::where('user_id', auth('sanctum')->id())->where('status', 1)->get();
        foreach ($notification as $notif) {
            $notif->status = 0;
            $notif->save();
        }
        return response()->json([
            'status' => 'succsess',
            'message' => 'Tüm Bildirimler Okundu İşaretlendi'
        ]);
    }

    /** Profil Bilgi Düzenleme */
    public function profileEdit(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }
        $user = User::find(auth('sanctum')->id());
        if ($user->verified === 0) {
            if ($request->nvi) {
                try {
                    if (!$request->tc) {
                        return response()->json([
                            'status' => 'Hata',
                            'message' => 'TC Kimlik Numarasını Girdiğinizden Emin Olun!'
                        ], 400);
                    }
                    if (!$request->dgm) {
                        return response()->json([
                            'status' => 'Hata',
                            'message' => 'Doğum Tarihi Seçtiğinizden Emin Olun!'
                        ], 400);
                    }

                    $fullName = trim($request->name);
                    $parts = preg_split('/\s+/', $fullName, -1, PREG_SPLIT_NO_EMPTY);
                    if (count($parts) === 1) {
                        $firstName = $parts[0];
                        $lastName = $parts[0];
                    } else {
                        // Son kelime soyad
                        $lastName = array_pop($parts);
                        // Kalanlar ad
                        $firstName = implode(' ', $parts);
                    }

                    $tcknApi = new SoapClient("https://tckimlik.nvi.gov.tr/service/kpspublic.asmx?WSDL");

                    $params = [
                        'TCKimlikNo' => (float)$request->tc,
                        'Ad' => $this->mb_strtoupper_tr($firstName),
                        'Soyad' => $this->mb_strtoupper_tr($lastName),
                        'DogumYili' => (int)$request->dgm
                    ];


                    $response = $tcknApi->TCKimlikNoDogrula($params);

                    if ($response->TCKimlikNoDogrulaResult) {
                        $user = User::find(auth('sanctum')->id());
                        if ($request->phone) {
                            if ($request->phone !== $user->phone) {
                                $user->phone_verified = 0;
                                $user->phone_code = rand(111111, 999999);
                                $user->phone = $request->phone;
                            }
                        }
                        $user->name = mb_strtoupper($firstName, 'UTF-8') . '  ' . mb_strtoupper($lastName, 'UTF-8');
                        $user->tc_no = (float)$request->tc;
                        $user->dogum_tarihi = (int)$request->dgm;
                        $user->phone_visibility = $request->visibility;
                        $user->verified = 1;
                        $user->save();

                        return response()->json([
                            'status' => true,
                            'message' => 'Doğrulama başarılı.'
                        ]);
                    } else {
                        return response()->json([
                            'status' => false,
                            'message' => 'Doğrulama başarısız. Lütfen bilgilerinizin doğru olduğunu kontrol ediniz.'
                        ], 400);
                    }

                } catch (\Exception $e) {
                    return response()->json([
                        'status' => false,
                        'message' => 'Bir hata oluştu: ' . $e->getMessage()
                    ], 500);
                }
            }
        }

        if ($request->phone) {
            if ($request->phone !== $user->phone) {
                $user->phone_verified = 0;
                $user->phone_code = rand(111111, 999999);
                $user->phone = $request->phone;
            }
        }
        if ($user->verified === 0) {
            $user->name = $request->name;
        }
        $user->phone_visibility = $request->visibility;
        $user->save();

        if (env('NETGSM_STATUS') === 1 && $request->phone) {
            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://api.netgsm.com.tr/sms/send/get',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => array(
                    'usercode' => env('NETGSM_USER'),
                    'password' => env('NETGSM_PASSWORD'),
                    'gsmno' => $this->phoneClear($user->phone),
                    'message' => env('APP_NAME') . ' Doğrulama Kodunuz: ' . $user->phone_code,
                    'msgheader' => env('NETGSM_TITLE'),
                    'filter' => '0',
                    'appkey' => env('NETGSM_APPKEY'),
                    'dil' => 'TR')
            ));

            $response = curl_exec($curl);

            curl_close($curl);
        }

        return response()->json([
            'status' => 'success',
            'message' => 'Profil Bilgileri Güncellendi'
        ]);
    }

    /** Doping Listesi */
    public function dopingList(): JsonResponse
    {
        $dopings = DopingPackages::where('status', 1)->get();

        return response()->json(DopingListResource::collection($dopings));
    }

    /** Mesajlar */
    public function messages(): JsonResponse
    {
        \Log::info('🔍 DEBUG: Messages API called');
        
        $userId = auth('sanctum')->id();
        \Log::info('🔍 DEBUG: Authenticated User ID: ' . ($userId ?? 'NULL'));
        
        if (!$userId) {
            \Log::error('🔍 DEBUG: No authenticated user found');
            return response()->json([
                'status' => 'error',
                'message' => 'Unauthenticated'
            ], 401);
        }
        
        \Log::info('🔍 DEBUG: Building query for user ID: ' . $userId);
        
        $messages = Messages::where(function ($query) use ($userId) {
            $query->where('sender_id', $userId)
                ->orWhere('recipient_id', $userId);
        })->get();
        
        \Log::info('🔍 DEBUG: Query executed. Found messages count: ' . $messages->count());
        
        if ($messages->count() > 0) {
            \Log::info('🔍 DEBUG: Messages found: ' . json_encode($messages->pluck('id')->toArray()));
            foreach ($messages as $msg) {
                \Log::info('🔍 DEBUG: Message ID: ' . $msg->id . ', Sender: ' . $msg->sender_id . ', Recipient: ' . $msg->recipient_id . ', Created: ' . $msg->created_at);
            }
        }

        if ($messages->isEmpty()) {
            \Log::info('🔍 DEBUG: No messages found, returning empty array');
            return response()->json([]);
        }

        $result = MessagesResource::collection($messages);
        \Log::info('🔍 DEBUG: Returning ' . $messages->count() . ' messages as resource collection');
        
        return response()->json($result);
    }

    /** SMS Doğrula */
    public function smsVerified(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'code' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }
        $user = User::find(auth('sanctum')->id());
        if ($request->code == $user->phone_code) {
            $user->phone_verified = 1;
            $user->phone_code = null;
            $user->save();

            return response()->json([
                'status' => 'success',
                'message' => 'Doğrulama Başarılı'
            ]);
        } else {
            return response()->json([
                'status' => 'Error',
                'message' => 'Doğrulama Başarısız. Lütfen Tekrar Deneyin!'
            ], 400);
        }

    }

    /** Doping Kontrolü */
    public function dopingCheck(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }
        $currentDateTime = Carbon::now();
        $doping = AdsDoping::where('ads_id', $request->id)->where('start_date', '<=', $currentDateTime)->where('status', 1)
            ->where('end_date', '>=', $currentDateTime)
            ->orderBy('start_date', 'asc')->first();
        return response()->json(new AdsDopingResource($doping));

    }

    /** Iyzico */
    public function iyzico(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required',
            'ad' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $doping = DopingPackages::find($request->id);
        if (!$doping) {
            return response()->json([
                'status' => 'Error',
                'message' => 'Doping Bulunamadı!'
            ], 400);
        }

        $user = User::find(auth('sanctum')->id());
        $basketId = $doping->id . '-' . $request->ad;
        $ipAdress = $request->ip();
        $request = new \Iyzipay\Request\CreateCheckoutFormInitializeRequest();
        $request->setLocale(\Iyzipay\Model\Locale::TR);
        $request->setConversationId($doping->id);
        $request->setPrice($doping->price);
        $request->setPaidPrice($doping->price);
        $request->setCurrency(\Iyzipay\Model\Currency::TL);
        $request->setBasketId($basketId);
        $request->setPaymentGroup(\Iyzipay\Model\PaymentGroup::PRODUCT);
        $request->setCallbackUrl(url('api/v1/iyzicoPay'));
        $request->setEnabledInstallments(array(2, 3, 6, 9));

        $buyer = new \Iyzipay\Model\Buyer();
        $buyer->setId($doping->id);
        $buyer->setName($this->nameParse($user->name)['name']);
        $buyer->setSurname($this->nameParse($user->name)['surname']);
        $buyer->setGsmNumber($this->phoneClear($user->phone));
        $buyer->setEmail($user->email);
        $buyer->setIdentityNumber("74300864791");
        $buyer->setLastLoginDate("2015-10-05 12:43:35");
        $buyer->setRegistrationDate("2013-04-21 15:12:09");
        $buyer->setRegistrationAddress('Beşiktaş');
        $buyer->setIp($ipAdress);
        $buyer->setCity('İstanbul');
        $buyer->setCountry("Turkey");
        $buyer->setZipCode("34732");

        $request->setBuyer($buyer);
        $shippingAddress = new \Iyzipay\Model\Address();
        $shippingAddress->setContactName($user->name);
        $shippingAddress->setCity('İstanbul');
        $shippingAddress->setCountry("Turkey");
        $shippingAddress->setAddress('Beşiktaş');
        $shippingAddress->setZipCode("34742");
        $request->setShippingAddress($shippingAddress);

        $billingAddress = new \Iyzipay\Model\Address();
        $billingAddress->setContactName($user->name);
        $billingAddress->setCity('İstanbul');
        $billingAddress->setCountry("Turkey");
        $billingAddress->setAddress('Beşiktaş');
        $billingAddress->setZipCode("34742");
        $request->setBillingAddress($billingAddress);

        $basketItems = array();
        $firstBasketItem = new \Iyzipay\Model\BasketItem();
        $firstBasketItem->setId("BI101");
        $firstBasketItem->setName($doping->title);
        $firstBasketItem->setCategory1("Collectibles");
        $firstBasketItem->setCategory2("Accessories");
        $firstBasketItem->setItemType(\Iyzipay\Model\BasketItemType::PHYSICAL);
        $firstBasketItem->setPrice($doping->price);
        $basketItems[0] = $firstBasketItem;
        $request->setBasketItems($basketItems);

        $checkoutFormInitialize = \Iyzipay\Model\CheckoutFormInitialize::create($request, $this->config());
        $paymentinput = $checkoutFormInitialize->getCheckoutFormContent();
        return response()->json([
            'formData' => $paymentinput
        ]);
    }

    public function iyzicoPay(Request $request)
    {
        $token = $request->token;
        $result = new \Iyzipay\Request\RetrieveCheckoutFormRequest();
        $result->setLocale(\Iyzipay\Model\Locale::TR);
        $result->setToken($token);

        $checkoutForm = \Iyzipay\Model\CheckoutForm::retrieve($result, $this->config());
        if ($checkoutForm->getPaymentStatus() === 'SUCCESS') {
            $basketId = $checkoutForm->getBasketId();
            $exp = explode('-', $basketId);

            $dopingPackage = DopingPackages::find($exp[0]);
            $startDate = Carbon::now()->toDateTimeString();
            $endDate = Carbon::now()->addDays($dopingPackage->day)->toDateTimeString();

            $adsDoping = new AdsDoping();
            $adsDoping->ads_id = $exp[1];
            $adsDoping->doping_id = $dopingPackage->id;
            $adsDoping->start_date = $startDate;
            $adsDoping->end_date = $endDate;
            $adsDoping->price = $dopingPackage->price;
            $adsDoping->status = 1;
            $adsDoping->uniq = uniqid();
            $adsDoping->save();

            $url = env('FRONT_URL') . "/payment/completed";
            header("Location: " . $url);
            die();
        } else {
            return 'Ödeme Hatası!';
        }
    }

    /** İlan Durum Değiştirme */
    public function statusChange(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required',
            'status' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $ad = Ads::where('id', $request->id)->where('user_id', auth('sanctum')->id())->first();
        if ($request->status === 3) {
            $ad->status = 3;
        } else {
            $ad->status = 0;
        }
        $ad->save();

        return response()->json([
            'status' => 'success',
            'message' => 'İlan durumu değiştirildi'
        ], 200);
    }

    /** Talep Durum Değiştirme */
    public function statusDemandChange(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required',
            'status' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $ad = Demands::where('id', $request->id)->where('user_id', auth('sanctum')->id())->first();
        if ($request->status === 3) {
            $ad->status = 3;
        } else {
            $ad->status = 0;
        }
        $ad->save();

        return response()->json([
            'status' => 'success',
            'message' => 'Talep durumu değiştirildi'
        ], 200);
    }

    public function config()
    {
        $options = new \Iyzipay\Options();
        $options->setApiKey(env('IYZICO_APIKEY'));
        $options->setSecretKey(env('IYZICO_SECRET'));
        $options->setBaseUrl(env('IYZICO_BASEURL'));

        return $options;
    }

    function footerPages(): JsonResponse
    {
        $pages = Pages::where('status', 1)->where('type', 1)->get();

        return response()->json(PagesListResource::collection($pages));
    }

    function pageDetail(Request $request): JsonResponse
    {
        $page = Pages::where('slug', $request->slug)->first();
        if(!$page){
            return response()->json([
                'status' => 'error',
                'message' => 'Sayfa Bulunamadı'
            ], 422);
        }
        return response()->json(new PagesDetailResource($page));
    }

    public function userProfile(Request $request): JsonResponse
    {
        $user = User::where('uniq_id', $request->id)->first();
        
        if (!$user) {
            return response()->json([
                'status' => 'error',
                'message' => 'Kullanıcı Bulunamadı'
            ], 404);
        }

        $ads = $user->ads()
            ->where('status', 1)
            ->paginate($request->per_page ?? 12);

        $demands = $user->demands()
            ->where('status', 1)->get();

        return response()->json([
            'data' => new UserProfileDetailResource($user),
            'ads' => [
                'data' => $ads->items(),
                'last_page' => $ads->lastPage(),
                'current_page' => $ads->currentPage(),
                'total' => $ads->total()
            ],
            'demands' => $demands,
        ]);
    }

    public function myProfile(Request $request): JsonResponse
    {
        $user = User::find(auth('sanctum')->id());
        if (!$user) {
            return response()->json([
                'status' => 'error',
                'message' => 'Kullanıcı Bulunamadı'
            ], 422);
        }
        $ads = $user->ads()->where('status', 1)->get();

        return response()->json(AdsListResource::collection($ads));
    }

    public function addToFavorites(Request $request): JsonResponse
    {
        $userId = auth('sanctum')->id();
        $adId = $request->input('ad_id');

        $favorite = Favorites::where('user_id', $userId)
            ->where('ad_id', $adId)
            ->first();

        if ($favorite) {
            $favorite->delete();
            return response()->json([
                'status' => 'removed',
                'message' => 'Favorilerden Çıkarıldı'
            ]);
        } else {
            Favorites::create([
                'user_id' => $userId,
                'ad_id' => $adId,
            ]);

            return response()->json([
                'status' => 'added',
                'message' => 'Favorilere Eklendi'
            ]);
        }
    }

    /** İletişim Formu **/

    public function contactForm(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'full_name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'message' => 'required|string|max:1500',
            'type' => 'required|integer',
        ], [
            'full_name.required' => 'Ad Soyad alanı zorunludur.',
            'full_name.string' => 'Ad Soyad metin olmalıdır.',
            'full_name.max' => 'Ad Soyad en fazla 255 karakter olabilir.',

            'email.required' => 'E-posta alanı zorunludur.',
            'email.email' => 'Geçerli bir e-posta adresi giriniz.',
            'email.max' => 'E-posta en fazla 255 karakter olabilir.',

            'message.required' => 'Mesaj alanı zorunludur.',
            'message.string' => 'Mesaj metin olmalıdır.',
            'message.max' => 'Mesaj en fazla 1500 karakter olabilir.',

            'type.required' => 'Talep türü seçmek zorunludur.',
            'type.integer' => 'Talep türü geçerli bir sayı olmalıdır.',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()->first()
            ], 422);
        }

        $ip = $request->ip();
        $hasContact = Contacts::where('ip_address', $ip)
            ->where('created_at', '>=', now()->subDay()) // son 24 saat
            ->exists();

        if ($hasContact) {
            return response()->json([
                'status' => 'Error',
                'message' => 'Aynı IP adresinden günde yalnızca 1 kez destek mesajı gönderebilirsiniz.'
            ], 429);
        }


        Contacts::create([
            'full_name' => $request->full_name,
            'email' => $request->email,
            'message' => $request->message,
            'type' => $request->type,
            'ip_address' => $ip,
            'device' => $request->header('User-Agent'),
        ]);

        return response()->json([
            'success' => true,
            'message' => 'Mesajınız başarıyla gönderildi.'
        ]);
    }

    /** Yardım Merkezi */

    public function helps(Request $request): JsonResponse
    {
        $helps = Helps::all();
        return response()->json(ApiListResource::collection($helps));
    }

    public function favoriteHelps(Request $request): JsonResponse
    {
        $helps = Pages::where('sss_status', 1)->where('type', 3)->get();
        return response()->json(ApiFavoritesListResource::collection($helps));
    }

    /** Kategori Tree */
    function categoryTree(): JsonResponse
    {
        $categories = Categories::orderBy('id', 'ASC')->get()->toTree();

        $formatted = $categories->map($recursive = function ($item) use (&$recursive) {
            $map = [
                'id' => $item->id,
                'label' => $item->name,
                'url' => $item->slug,
                'opened' => false,
                'icon' => $item->icon,
            ];

            if ($item->children->isNotEmpty()) {
                $map['children'] = $item->children->map($recursive);
            }

            return $map;
        });

        return response()->json($formatted, 200);
    }

    private function ucwords_tr($str)
    {
        $str = mb_strtolower($str);
        return str_replace('i̇', 'i', ltrim(mb_convert_case(str_replace(array('i', 'I'), array('İ', 'ı'), $str), MB_CASE_TITLE, 'UTF-8')));
    }

    private function phoneClear($phone)
    {
        return preg_replace('/\D/', '', $phone);
    }

    private function nameParse($name)
    {
        $parts = explode(" ", $name);

        $data = [];
        // If there are 3 parts, the first part is the first name, the second part is the middle name, and the third part is the last name
        if (count($parts) == 3) {
            $firstName = $parts[0];
            $middleName = $parts[1];
            $lastName = $parts[2];
            $data['name'] = $firstName;
            $data['surname'] = $lastName;
            return $data;
        } // If there are 2 parts, the first part is the first name and the second part is the last name
        else if (count($parts) == 2) {
            $firstName = $parts[0];
            $lastName = $parts[1];
            $data['name'] = $firstName;
            $data['surname'] = $lastName;
            return $data;
        } // Otherwise, if the name is not in the correct format or empty, display an error message
        else {
            echo "Invalid name format";
            $data['name'] = 'İsim';
            $data['surname'] = 'Yok';
            return $data;
        }
    }

    private function mb_strtoupper_tr($string)
    {
        // Önce Türkçe küçük harfleri büyük harflere çeviriyoruz
        $search = ['i', 'ı', 'ğ', 'ü', 'ş', 'ö', 'ç'];
        $replace = ['İ', 'I', 'Ğ', 'Ü', 'Ş', 'Ö', 'Ç'];
        $string = str_replace($search, $replace, $string);

        // Sonra diğer harfleri büyük yapıyoruz
        $string = mb_strtoupper($string, 'UTF-8');

        return $string;
    }

    /** Premium Iyzico */
    public function premiumIyzico(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'package_id' => 'required|integer|in:1,2,3'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        // Premium paket bilgileri
        $packages = [
            1 => ['name' => 'Aylık Premium', 'price' => 49.99, 'duration' => 30],
            2 => ['name' => '3 Aylık Premium', 'price' => 129.99, 'duration' => 90],
            3 => ['name' => 'Yıllık Premium', 'price' => 399.99, 'duration' => 365]
        ];

        $package = $packages[$request->package_id];
        $user = User::find(auth('sanctum')->id());
        $basketId = 'premium-' . $request->package_id . '-' . $user->id;
        $ipAdress = $request->ip();
        
        $iyzicoRequest = new \Iyzipay\Request\CreateCheckoutFormInitializeRequest();
        $iyzicoRequest->setLocale(\Iyzipay\Model\Locale::TR);
        $iyzicoRequest->setConversationId($request->package_id);
        $iyzicoRequest->setPrice($package['price']);
        $iyzicoRequest->setPaidPrice($package['price']);
        $iyzicoRequest->setCurrency(\Iyzipay\Model\Currency::TL);
        $iyzicoRequest->setBasketId($basketId);
        $iyzicoRequest->setPaymentGroup(\Iyzipay\Model\PaymentGroup::PRODUCT);
        $iyzicoRequest->setCallbackUrl(url('api/v1/premiumIyzicoPay'));
        $iyzicoRequest->setEnabledInstallments(array(2, 3, 6, 9));

        $buyer = new \Iyzipay\Model\Buyer();
        $buyer->setId($user->id);
        $buyer->setName($this->nameParse($user->name)['name']);
        $buyer->setSurname($this->nameParse($user->name)['surname']);
        $buyer->setGsmNumber($this->phoneClear($user->phone));
        $buyer->setEmail($user->email);
        $buyer->setIdentityNumber("74300864791");
        $buyer->setLastLoginDate("2015-10-05 12:43:35");
        $buyer->setRegistrationDate("2013-04-21 15:12:09");
        $buyer->setRegistrationAddress('Beşiktaş');
        $buyer->setIp($ipAdress);
        $buyer->setCity('İstanbul');
        $buyer->setCountry("Turkey");
        $buyer->setZipCode("34732");

        $iyzicoRequest->setBuyer($buyer);
        $shippingAddress = new \Iyzipay\Model\Address();
        $shippingAddress->setContactName($user->name);
        $shippingAddress->setCity('İstanbul');
        $shippingAddress->setCountry("Turkey");
        $shippingAddress->setAddress('Beşiktaş');
        $shippingAddress->setZipCode("34742");
        $iyzicoRequest->setShippingAddress($shippingAddress);

        $billingAddress = new \Iyzipay\Model\Address();
        $billingAddress->setContactName($user->name);
        $billingAddress->setCity('İstanbul');
        $billingAddress->setCountry("Turkey");
        $billingAddress->setAddress('Beşiktaş');
        $billingAddress->setZipCode("34742");
        $iyzicoRequest->setBillingAddress($billingAddress);

        $basketItems = array();
        $firstBasketItem = new \Iyzipay\Model\BasketItem();
        $firstBasketItem->setId("PREMIUM" . $request->package_id);
        $firstBasketItem->setName($package['name']);
        $firstBasketItem->setCategory1("Subscription");
        $firstBasketItem->setCategory2("Premium");
        $firstBasketItem->setItemType(\Iyzipay\Model\BasketItemType::VIRTUAL);
        $firstBasketItem->setPrice($package['price']);
        $basketItems[0] = $firstBasketItem;
        $iyzicoRequest->setBasketItems($basketItems);

        $checkoutFormInitialize = \Iyzipay\Model\CheckoutFormInitialize::create($iyzicoRequest, $this->iyzicoConfig());
        $paymentinput = $checkoutFormInitialize->getCheckoutFormContent();
        return response()->json([
            'formData' => $paymentinput
        ]);
    }

    public function premiumIyzicoPay(Request $request)
    {
        $token = $request->token;
        $result = new \Iyzipay\Request\RetrieveCheckoutFormRequest();
        $result->setLocale(\Iyzipay\Model\Locale::TR);
        $result->setToken($token);

        $checkoutForm = \Iyzipay\Model\CheckoutForm::retrieve($result, $this->iyzicoConfig());
        if ($checkoutForm->getPaymentStatus() === 'SUCCESS') {
            $basketId = $checkoutForm->getBasketId();
            $exp = explode('-', $basketId);
            
            $packageId = $exp[1];
            $userId = $exp[2];
            
            // Premium paket bilgileri
            $packages = [
                1 => ['duration' => 30, 'price' => 49.99],
                2 => ['duration' => 90, 'price' => 129.99],
                3 => ['duration' => 365, 'price' => 399.99]
            ];
            
            $package = $packages[$packageId];
            $startDate = Carbon::now()->toDateTimeString();
            $endDate = Carbon::now()->addDays($package['duration'])->toDateTimeString();

            $userPremium = new \App\Models\UserPremium();
            $userPremium->user_id = $userId;
            $userPremium->package_id = $packageId;
            $userPremium->start_date = $startDate;
            $userPremium->end_date = $endDate;
            $userPremium->price = $package['price'];
            $userPremium->status = 1;
            $userPremium->payment_id = $checkoutForm->getPaymentId();
            $userPremium->save();

            $url = env('FRONT_URL') . "/payment/completed";
            header("Location: " . $url);
            die();
        } else {
            return 'Ödeme Hatası!';
        }
    }

    private function iyzicoConfig()
    {
        $config = new \Iyzipay\Options();
        $config->setApiKey(env('IYZICO_APIKEY'));
        $config->setSecretKey(env('IYZICO_SECRET'));
        $config->setBaseUrl(env('IYZICO_BASEURL'));
        return $config;
    }
}
