<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Resources\Complaint\ListResource;
use App\Models\Ads\Ads;
use App\Models\Complaints;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class ComplaintsController extends Controller
{
    public function index(Request $request): JsonResponse
    {
        $perPage = $request->perPage ?? 10;

        $pages = Complaints::orderBy('id', 'DESC')->paginate($perPage);

        return response()->json([
            'pagination' => $pages,
            'collection' => ListResource::collection($pages)
        ]);
    }

    public function destroy(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $pages =  Complaints::find($request->id);
        $pages->delete();

        return response()->json([
            'status' => 'Success',
            'message' => 'Şikayet Başarılı Şekilde Silindi'
        ]);
    }

    /** Bu bölüm API servisi ile bağlantılı */
    public function store(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'type' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()->first()
            ], 400);
        }

        if(!auth('sanctum')->id()){
            return response()->json([
                'status' => 'Error',
                'message' => 'Lütfen Giriş Yapın!'
            ], 400);
        }

        $ad = Ads::where('slug', $request->slug)->where('status', 1)->first();
        if (!$ad) {
            return response()->json([
                'status' => 'Error',
                'message' => 'İlan Bulunamadı'
            ], 400);
        }

        $ip = $request->ip();
        $userId = auth('sanctum')->id();

        $exists = Complaints::where('ad_id', $ad->id)
            ->where('ip_address', $ip)
            ->exists();

        if ($exists) {
            return response()->json([
                'status' => 'error',
                'message' => 'Bu ilanı daha önce şikayet ettiniz.'
            ], 400);
        }

        $complaint =  new Complaints();
        $complaint->ad_id = $ad->id;
        $complaint->user_id = $userId;
        $complaint->complaint_type = $request->type;
        $complaint->message = $request->message ?? null;
        $complaint->ip_address = $ip;
        $complaint->device = $request->header('User-Agent');
        $complaint->save();


        return response()->json([
            'status' => 'Success',
            'message' => 'Şikayetiniz iletilmiştir.'
        ]);
    }
}
