<?php

namespace App\Http\Controllers;

use App\Http\Resources\ComplaintDemands\ListResource;
use App\Models\Ads\Ads;
use App\Models\Complaints;
use App\Models\ComplaintsDemands;
use App\Models\Demands\Demands;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class ComplaintsDemandsController extends Controller
{
    public function index(Request $request): JsonResponse
    {
        $perPage = $request->perPage ?? 10;

        $pages = ComplaintsDemands::orderBy('id', 'DESC')->paginate($perPage);

        return response()->json([
            'pagination' => $pages,
            'collection' => ListResource::collection($pages)
        ]);
    }

    public function destroy(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $pages =  ComplaintsDemands::find($request->id);
        $pages->delete();

        return response()->json([
            'status' => 'Success',
            'message' => 'Şikayet Başarılı Şekilde Silindi'
        ]);
    }

    /** Bu bölüm API servisi ile bağlantılı */
    public function store(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'type' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()->first()
            ], 400);
        }

        if(!auth('sanctum')->id()){
            return response()->json([
                'status' => 'Error',
                'message' => 'Lütfen Giriş Yapın!'
            ], 400);
        }

        $demand = Demands::where('slug', $request->slug)->where('status', 1)->first();
        if (!$demand) {
            return response()->json([
                'status' => 'Error',
                'message' => 'Talep Bulunamadı'
            ], 400);
        }

        $ip = $request->ip();
        $userId = auth('sanctum')->id();

        $exists = ComplaintsDemands::where('demand_id', $demand->id)
            ->where('ip_address', $ip)
            ->exists();

        if ($exists) {
            return response()->json([
                'status' => 'error',
                'message' => 'Bu Talebi daha önce şikayet ettiniz.'
            ], 400);
        }

        $complaint =  new ComplaintsDemands();
        $complaint->demand_id = $demand->id;
        $complaint->user_id = $userId;
        $complaint->complaint_type = $request->type;
        $complaint->message = $request->message ?? null;
        $complaint->ip_address = $ip;
        $complaint->device = $request->header('User-Agent');
        $complaint->save();


        return response()->json([
            'status' => 'Success',
            'message' => 'Şikayetiniz iletilmiştir.'
        ]);
    }
}
