<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Resources\Help\ListResource;
use App\Http\Resources\Help\PageListResource;
use App\Http\Resources\Help\ViewResource;
use App\Models\HelpOptions;
use App\Models\Helps;
use App\Models\Pages;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class HelpController extends Controller
{

    public function index(Request $request): JsonResponse
    {
        $perPage = $request->perPage ?? 10;

        $helps = Helps::orderBy('id', 'DESC')->paginate($perPage);

        return response()->json([
            'pagination' => $helps,
            'collection' => ListResource::collection($helps)
        ]);
    }

    public function store(Request $request): JsonResponse
    {
        $newHelp = new Helps();
        $newHelp->title = $request->title;
        $newHelp->save();

        $pages = json_decode($request->pages);
        if ($pages) {
            foreach($pages as $page){
                $newHelpOption = new HelpOptions();
                $newHelpOption->help_id = $newHelp->id;
                $newHelpOption->page_id = $page;
                $newHelpOption->save();
            }
        }


        return response()->json([
            'status' => true,
            'message' => 'Yardım Konusu Eklendi.'
        ]);

    }

    public function view(Request $request): JsonResponse
    {
        $help = Helps::find($request->id);

        return response()->json(new ViewResource($help));
    }

    public function update(Request $request): JsonResponse
    {
        $newHelp = Helps::find($request->id);
        $newHelp->title = $request->title;
        $newHelp->save();

        $pages = json_decode($request->pages) ?? [];

        $existingPages = HelpOptions::where('help_id', $newHelp->id)->pluck('page_id')->toArray();

        $toDelete = array_diff($existingPages, $pages);
        if(!empty($toDelete)) {
            HelpOptions::where('help_id', $newHelp->id)
                ->whereIn('page_id', $toDelete)
                ->delete();
        }


        $toAdd = array_diff($pages, $existingPages);
        foreach($toAdd as $pageId) {
            HelpOptions::create([
                'help_id' => $newHelp->id,
                'page_id' => $pageId
            ]);
        }

        return response()->json([
            'status' => true,
            'message' => 'Yardım Konusu Güncellendi.'
        ]);
    }

    public function destroy(Request $request): JsonResponse
    {
        $help = Helps::find($request->id);

        if (!$help) {
            return response()->json([
                'status' => false,
                'message' => 'Yardım konusu bulunamadı.'
            ], 404);
        }

        HelpOptions::where('help_id', $help->id)->delete();
        $help->delete();

        return response()->json([
            'status' => true,
            'message' => 'Yardım konusu başarıyla silindi.'
        ]);
    }

    public function helpPages(): JsonResponse
    {
        $pages = Pages::orderBy('id', 'DESC')->where('type', 3)->get();
        return response()->json(PageListResource::collection($pages));
    }
}
