<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Resources\IncomingDemands\ListResource;
use App\Models\Demands\Demands;
use App\Models\IncomingDemands;
use App\Models\Notification;
use App\Models\User;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class IncomingDemandsController extends Controller
{
    public function index(Request $request): JsonResponse
    {

        $perPage = $request->perPage ?? 10;

        $incomingDemands = IncomingDemands::where('demand_user_id', auth('sanctum')->id())->orderBy('id', 'DESC')->paginate($perPage);

        return response()->json([
            'pagination' => $incomingDemands,
            'collection' => ListResource::collection($incomingDemands)
        ]);
    }

    public function store(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'slug' => 'required',
            'ad_id' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()->first()
            ], 400);
        }

        if(!auth('sanctum')->id()){
            return response()->json([
                'status' => 'Error',
                'message' => 'Lütfen Giriş Yapın!'
            ], 400);
        }

        $demand = Demands::where('slug', $request->slug)->where('status', 1)->first();
        if (!$demand) {
            return response()->json([
                'status' => 'Error',
                'message' => 'Talep Bulunamadı'
            ], 400);
        }

        $ip = $request->ip();
        $device = $request->header('User-Agent');

        $exists = IncomingDemands::where('demand_id', $demand->id)
            ->where('ip_address', $ip)
            ->exists();

        if ($exists) {
            return response()->json([
                'status' => 'error',
                'message' => 'Daha önce talepte bulundunuz!'
            ], 400);
        }

        $incomingDemand = new IncomingDemands();
        $incomingDemand->user_id = auth('sanctum')->id();
        $incomingDemand->demand_user_id = $demand->user_id;
        $incomingDemand->demand_id = $demand->id;
        $incomingDemand->ad_id = $request->ad_id;
        $incomingDemand->offer = $request->price ?? null;
        $incomingDemand->message = $request->message ?? null;
        $incomingDemand->ip_address = $ip;
        $incomingDemand->device = $device;
        $incomingDemand->save();

        $user = User::find(auth('sanctum')->id());
        $notification = new Notification();
        $notification->user_id = $demand->user_id;
        $notification->title = '<b>' . $user->name . '</b> talebiniz için yeni teklif yaptı.';
        $notification->type = 2;
        $notification->url = '/profile/my-incoming-demands';
        $notification->status = 1;
        $notification->save();

        return response()->json([
            'status' => 'Success',
            'message' => 'Talebiniz iletilmiştir.'
        ]);
    }
}
