<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Resources\Permissions\RolePermissionEditResource;
use App\Http\Resources\Permissions\RolePermissionResource;
use App\Http\Resources\Role\RolesResource;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class PermissionController extends Controller
{
    public function index(Request $request): JsonResponse
    {
        $perPage = $request->perPage ?? 10;
        $permissions = Permission::paginate($perPage);

        return response()->json([
            'message' => ('Fetched admin users'),
            'pagination' => $permissions,
            'collection' => RolesResource::collection($permissions)
        ]);
    }

    public function create(Request $request): JsonResponse
    {
        Permission::create([
            'name'  => $request->name,
            'tag'   => $request->title,
            'guard_name' => 'web'
        ]);
        $superadmin = Role::whereName('super-admin')->first();
        $superadmin->givePermissionTo([$request->name]);
        return response()->json([
            'status' => 'success',
            'message' => 'Yetki Başarılı Şekilde Eklendi',
        ]);
    }

    public function rolePermissionList(): JsonResponse
    {
        $permission = Permission::all();
        return response()->json([
            'permissions' => RolePermissionResource::collection($permission),
            'permissionAll' => $permission
        ]);
    }
    public function destroy(Permission $permission): JsonResponse
    {
        try {
            $superadmin = Role::whereName('super-admin')->first();
            $superadmin->revokePermissionTo([$permission->name]);
            $permission->delete();
            return response()->json([
                'status' => 'success',
                'message' => 'Yetki Başarılı Şekilde Silindi.',
            ]);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => 'error',
                'message' => $th->getMessage(),
            ]);
        }
    }

    public function edit(Request $request): JsonResponse
    {
        $permissions = Permission::find($request->id);

        return response()->json([
            'message' => ('Fetched admin users'),
            'permission' => $permissions
        ]);
    }

    public function update(Request $request, Permission $permission)
    {
        $superadmin = Role::whereName('super-admin')->first();
        $superadmin->revokePermissionTo([$permission->name]);
        $permission->update([
            'name'  => $request->name,
            'tag'   => $request->title
        ]);
        $superadmin->givePermissionTo([$permission->name]);

        return response()->json([
            'status' => 'success',
            'message' => 'Yetki Başarılı Şekilde Güncellendi.',
        ]);
    }
}
