<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Resources\Permissions\RolePermissionEditResource;
use App\Http\Resources\Role\AllRolesOptionResource;
use App\Http\Resources\Role\RolesResource;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;

class RoleController extends Controller
{

    public function __construct()
    {
        $this->middleware('role:super-admin');
    }

    public function index(Request $request): JsonResponse
    {
        $perPage = $request->perPage ?? 10;
        $roles = Role::paginate($perPage);

        return response()->json([
            'message' => ('Fetched admin users'),
            'pagination' => $roles,
            'collection' => RolesResource::collection($roles)
        ]);
    }

    public function create(Request $request){
        $role = Role::create(['guard_name' => 'web', 'name' => $request->name, 'tag' => $request->title]);
        if(count($request->permissions) > 0){
            foreach ($request->permissions as $perm){
                $role->givePermissionTo($perm);
            }
        }

        return response()->json([
            'status' => 'success',
            'message' => 'Rol Başarılı Şekilde Eklendi',
        ]);
    }

    public function edit(Request $request): JsonResponse
    {
        $role = Role::find($request->id);
        $permissions = Role::find($request->id)->getAllPermissions();

        return response()->json([
            'message' => ('Fetched admin users'),
            'role' => $role,
            'permissions' => RolePermissionEditResource::collection($permissions)
        ]);
    }

    public function update(Request $request, Role $role): JsonResponse
    {
        $role->update([
            'name' => $request->name,
            'tag' => $request->title
        ]);

        if(count($request->permissions) > 0){
            $role->syncPermissions($request->permissions);
        }

        return response()->json([
            'status' => 'success',
            'message' => 'Rol Başarılı Şekilde Güncellendi',
        ]);
    }
    public function destroy(Role $role): JsonResponse
    {
        try {
            $role->delete();
            return response()->json([
                'status' => 'success',
                'message' => 'Rol Başarılı Şekilde Silindi.',
            ]);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => 'error',
                'message' => $th->getMessage(),
            ]);
        }
    }
    public function allRolesOption(): JsonResponse
    {
        $roles = Role::all();
        return response()->json(AllRolesOptionResource::collection($roles));
    }
}
