<?php

namespace App\Http\Controllers\Settings;

use App\Http\Controllers\Controller;
use App\Http\Resources\Settings\HomeSetting;
use App\Models\Settings\HomeSettings;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class HomeSettingsController extends Controller
{
    public function index(): JsonResponse
    {
        $homeSetting = HomeSettings::where('id', 1)->first();
        return response()->json($homeSetting ? new HomeSetting($homeSetting) : []);
    }

    public function update(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'buttonText' => 'required',
            'buttonLink' => 'required',
            'status' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }
        $homeSetting = HomeSettings::where('id', 1)->first();
        if($homeSetting){
            $homeSetting->button_text = $request->buttonText;
            $homeSetting->button_link = $request->buttonLink;
            $homeSetting->status = $request->status;
            if($request->image){
                $name = time() . rand(1111111111, 999999999999999) . '.' . $request->image->extension();
                $request->image->storePubliclyAs('/public/uploads/homesetting', $name);
                $homeSetting->image = '/uploads/homesetting/'.$name;
            }
            $homeSetting->save();
        }else{
            $homeSetting = new HomeSettings();
            $homeSetting->button_text = $request->buttonText;
            $homeSetting->button_link = $request->buttonLink;
            $homeSetting->status = $request->status;
            if($request->image){
                $name = time() . rand(1111111111, 999999999999999) . '.' . $request->image->extension();
                $request->image->storePubliclyAs('/public/uploads/homesetting', $name);
                $homeSetting->image = '/uploads/homesetting/'.$name;
            }
            $homeSetting->save();
        }

        return response()->json([
            'status' => 'Success',
            'message' => 'Ana Sayfa Ayarı Güncellendi'
        ]);
    }
}
