<?php

namespace App\Http\Controllers;

use App\Http\Resources\Variant\EditResource;
use App\Http\Resources\Variant\ListResource;
use App\Models\Variant\VariantOptions;
use App\Models\Variant\Variants;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class VariantsController extends Controller
{
    public function index(Request $request): JsonResponse
    {
        $perPage = $request->perPage ?? 10;

        $variant = Variants::orderBy('id', 'DESC')->paginate($perPage);

        return response()->json([
            'pagination' => $variant,
            'collection' => ListResource::collection($variant)
        ]);
    }

    public function store(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'title' => 'required',
            'type' => 'required',
            'status' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        if($request->type !== "3" && count(json_decode($request->variant_options)) < 2){
            return response()->json([
                'status' => 'Error',
                'message' => 'Varyant Seçeneği En Az 2 Adet Eklenmeli'
            ], 402);
        }

        $variant = new Variants();
        $variant->name = $request->name;
        $variant->title = $request->title;
        $variant->type = $request->type;
        $variant->variant_type = $request->variant_type;
        $variant->status = $request->status;
        $variant->save();

        foreach (json_decode($request->variant_options) as $option){
            if($option !== "" && $request->type !== 3){
                $variantOptions = new VariantOptions();
                $variantOptions->variant_id = $variant->id;
                $variantOptions->name = $option;
                $variantOptions->save();
            }
        }

        return response()->json([
            'status' => 'Success',
            'message' => 'Variant Başarılı Şekilde Eklendi'
        ]);
    }

    public function edit(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $category = Variants::with('variantOptions')->find($request->id);
        return response()->json(new EditResource($category));
    }

    public function update(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'title' => 'required',
            'type' => 'required',
            'status' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        if($request->type !== "3" && count(json_decode($request->variant_options)) < 2){
            return response()->json([
                'status' => 'Error',
                'message' => 'Varyant Seçeneği En Az 2 Adet Eklenmeli'
            ], 402);
        }

        $variant = Variants::find($request->id);
        $variant->name = $request->name;
        $variant->title = $request->title;
        $variant->type = $request->type;
        $variant->variant_type = $request->variant_type;
        $variant->status = $request->status;
        $variant->save();

        if (count($variant->variantOptions) !== 0){
            $variant->variantOptions()->delete();
        }

        foreach (json_decode($request->variant_options) as $option){
            if($option !== "" && $request->type !== 3){
                $variantOptions = new VariantOptions();
                $variantOptions->variant_id = $variant->id;
                $variantOptions->name = $option;
                $variantOptions->save();
            }
        }

        return response()->json([
            'status' => 'Success',
            'message' => 'Variant Başarılı Şekilde Güncellendi'
        ]);
    }

    public function destroy(Request $request): JsonResponse
    {

        $validator = Validator::make($request->all(), [
            'id' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $variant =  Variants::find($request->id);
        $variant->variantOptions()->delete();
        $variant->delete();

        return response()->json([
            'status' => 'Success',
            'message' => 'Varyant Başarılı Şekilde Silindi'
        ]);
    }
}
