<?php

namespace App\Http\Resources\Ads;

use App\Models\Categories;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ApiAdViewResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $variantList = VariantListResource::collection($this->variants);
        $variants = [];

        foreach ($variantList as $value){
            $variants[] = [
                "name"    => $value->variant->name,
                "value" => $value->variant_option,
            ];
        }

        $categories = Categories::ancestorsAndSelf($this->category_id);
        $catagory = [];
        $catagory[] = [
            'label' => 'Ana Sayfa',
            'hideLabel' => false,
            'icon' => 'lucide:home',
            'to' => '/'
        ];
        foreach ($categories as $item){
            $catagory[] = [
                'label' => $item->name,
                'hideLabel' => false,
                'to' => '/category/'.$item->slug
            ];
        }

        $catagory[] = [
            'label' => $this->title,
            'hideLabel' => false
        ];

        return [
            'id' => $this->id,
            'category' => $catagory,
            'adNo' => $this->ad_no,
            'type' => $this->type,
            'startDate' => $this->start_date,
            'endDate' => $this->end_date,
            'startPrice' => $this->starting_price,
            'minimumIncrease' => $this->minimum_increase,
            'user' => [
                'id' => $this->user->id,
                'uniq_id' => $this->user->uniq_id,
                'name' => $this->user->name,
                'phone' => $this->user->phone_visibility && $this->user->phone_verified === 1 ? $this->user->phone : null,
                'verified' => $this->user->phone_verified,
            ],
            'title' => $this->title,
            'price' => $this->price,
            'city' => $this->cityRela->name,
            'district' => $this->districtRela->name,
            'description' => $this->description,
            'status' => $this->status,
            'gallery' => GalleryListResource::collection($this->gallery),
            'prices' => PriceListResource::collection($this->prices),
            'variants' => $variants,
            'createdDate' => $this->created_at->locale('tr')->translatedFormat('d F Y'),
            'auctions' => \App\Http\Resources\Auctions\ListResource::collection($this->auctions)
            //'cancelMessage' => $this->cancel_message,
        ];
    }
}
