<?php

namespace App\Http\Resources\Api;

use App\Http\Resources\Ads\GalleryListResource;
use App\Models\Message\Messages;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AdsListResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $message = Messages::where('ads_id', $this->id)->where('sender_id', auth('sanctum')->id())->first();
        $now = Carbon::now('Europe/Istanbul');
        $auctionStatus = 2; // varsayılan: başlamadı

        if ($this->type === 1) {
            if ($this->start_date && $this->end_date) {
                $start = Carbon::parse($this->start_date, 'Europe/Istanbul');
                $end = Carbon::parse($this->end_date, 'Europe/Istanbul');

                if ($now->lt($start)) {
                    $auctionStatus = 2; // başlamadı
                } elseif ($now->between($start, $end)) {
                    $auctionStatus = 1; // başladı
                } elseif ($now->gte($end)) {
                    $auctionStatus = 3; // bitti
                }
            }
        }

        // ✅ Featured (type=1 doping, tarihi geçerli ve status=1 olmalı)
        $featuredActive = $this->dopings
            ->where('dopingPackage.type', 1)
            ->filter(function ($doping) use ($now) {
                return $doping->status == 1 &&
                    $now->between(Carbon::parse($doping->start_date), Carbon::parse($doping->end_date));
            })
            ->count() > 0 ? 1 : 0;

        // ✅ Urgent (type=2 doping, tarihi geçerli ve status=1 olmalı)
        $urgentActive = $this->dopings
            ->where('dopingPackage.type', 2)
            ->filter(function ($doping) use ($now) {
                return $doping->status == 1 &&
                    $now->between(Carbon::parse($doping->start_date), Carbon::parse($doping->end_date));
            })
            ->count() > 0 ? 1 : 0;

        return [
            'id' => $this->id,
            'name' => $this->title,
            'type' => $this->type,
            'auctionStatus' => $auctionStatus,
            'price' => $this->price,
            'city' => $this->cityRela->name,
            'district' => $this->districtRela->name,
            'slug' => $this->slug,
            'images' => AdsListGalleryResource::collection($this->gallery->take(5)),
            'featured' => $featuredActive,
            'urgent'   => $urgentActive,
            'discount' => count($this->prices) > 0 ? $this->prices[0]->status : 0,
            'message' => [
                'id' => $message ? $message->uniq : null,
                'check' => (bool)$message
            ]
        ];
    }
}
