<?php

namespace App\Http\Resources\Demands;

use App\Http\Resources\Api\AdsListGalleryResource;
use App\Models\Message\Messages;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class DemandsListResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $message = Messages::where('demand_id', $this->id)->where('sender_id', auth('sanctum')->id())->first();

        return [
            'id' => $this->id,
            'name' => $this->title,
            'min_price' => $this->min_price,
            'max_price' => $this->max_price,
            'city' => $this->cityRela->name,
            'district' => $this->districtRela->name,
            'slug' => $this->slug,
            'message' => [
                'id' => $message ? $message->uniq : null,
                'check' => (bool)$message
            ]
        ];
    }
}
