<?php

namespace App\Http\Resources\Demands;

use App\Http\Resources\Ads\VariantListResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class EditResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $variantList = VariantListResource::collection($this->variants);
        $variantOne = [];
        $variantTwo = [];
        $variantThree = [];

        foreach ($variantList as $value){
            if ($value->variant->type === 1){
                $variantOne[] = [
                    "id"    => $value->variant_id,
                    "value" => $value->variant_option_id,
                ];
            }
            if ($value->variant->type === 2){
                $variantTwo[] = [
                    "id"    => $value->variant_id,
                    "value" => $value->variant_option_id,
                ];
            }
            if ($value->variant->type === 3){
                $variantThree[] = [
                    "id"    => $value->variant_id,
                    "value" => $value->variant_option,
                ];
            }
        }

        return [
            'id' => $this->id,
            'category' => $this->category_id,
            'user' => $this->user_id,
            'title' => $this->title,
            'min_price' => $this->min_price,
            'max_price' => $this->max_price,
            'city' => $this->city,
            'district' => $this->district,
            'description' => $this->description,
            'status' => $this->status,
            'variants' => VariantListResource::collection($this->variants),
            'variantOne' => $variantOne,
            'variantTwo' => $variantTwo,
            'variantThree' => $variantThree,
            'cancelMessage' => $this->cancel_message
        ];
    }
}
