<?php

namespace App\Http\Resources\Doping;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Carbon;

class AdsDopingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'start_date' => Carbon::parse($this->start_date)->locale('tr_TR')->isoFormat('LLL'),
            'end_date' => Carbon::parse($this->end_date)->locale('tr_TR')->isoFormat('LLL'),
            'price' => $this->price,
        ];
    }
}
