<?php

namespace App\Http\Resources\Message;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Carbon;

class MessageDetailListResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $created_at = Carbon::parse($this->created_at);

        Carbon::setLocale('tr');
        $formatted_date = $created_at->isoFormat('DD MMMM YYYY HH:mm');

        return [
            'id' => $this->id,
            'text' => $this->message,
            'offer' => $this->offer,
            'image' => $this->image,
            'type' => $this->type == 0 ? 'sent' : 'received',
            'time' => $formatted_date
        ];
    }
}
