<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Carbon;

class NotificationListResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        setlocale(LC_TIME, 'tr_TR.UTF-8');
        $date = Carbon::parse($this->created_at);
        $currentDate = Carbon::now();
        $diff = $date->diffInHours($currentDate);
        $created_at = '';
        if ($diff >= 24) {
            $created_at = $date->isoFormat('DD MMMM YYYY HH:mm', 'Do MMMM YYYY HH:mm'); // Example format: 18 March 2024 09:10
        } else {
            $created_at = $date->diffForHumans($currentDate);
        }

        return [
            'id' => $this->id,
            'title' => $this->title,
            'url' => $this->url,
            'type' => $this->type,
            'created' => $created_at,
            'status' => $this->status,
        ];
    }
}
