<?php

namespace App\Http\Resources\User;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CreditLogsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  Request  $request
     * @return array
     */
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'authorized_user' => $this->AuthorizedUser->name,
            'total_credit' => $this->total_credit,
            'available_credit' => $this->available_credit,
            'start_date' => $this->start_date ? $this->start_date : 'Belirtilmemiş',
            'end_date' => $this->end_date ? $this->end_date : 'Belirtilmemiş',
            'created_at' => $this->created_at
        ];
    }
}
