<?php

namespace App\Http\Resources\User;

use App\Http\Resources\Api\AdsListResource;
use App\Http\Resources\Api\MyAdsListResource;
use App\Http\Resources\Demands\DemandsListResource;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class UserProfileDetailResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'user' => [
                'id' => $this->id,
                'name' => $this->name,
                'phone' => $this->phone_visibility === 1 ? $this->phone_verified === 1 ? $this->phone : '' : '',
                'phone_verified' => $this->phone_verified,
                'verified' => $this->verified,
                'createdAt' => $this->when($this->created_at, function () {
                    $joined = $this->created_at;
                    $now    = Carbon::now();

                    $diff = $joined->diffAsCarbonInterval($now)->cascade();

                    // Burada sıfır olsa bile ekleyeceğiz
                    $result = [];
                    $result[] = $diff->y . ' yıl';
                    $result[] = $diff->m . ' ay';
                    $result[] = $diff->d . ' gün';

                    return implode(' ', $result);
                }),
            ],
            'ads' => [
                'list' => AdsListResource::collection($this->ads()->where('status', 1)->get()),
                'count' => $this->ads()->where('status', 1)->count(),
                'sales_count' => $this->ads()->where('status', 3)->count(),
                'favorites' => $this->favorites()->count(),
            ],
            'demands' => [
                'list' => DemandsListResource::collection($this->demands()->where('status', 1)->get()),
                'count' => $this->demands()->where('status', 1)->count()
            ]
        ];
    }
}
