<?php

namespace App\Http\Resources\Variant;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class EditResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $options = count($this->variantOptions) > 0 ? OptionsListResource::collection($this->variantOptions) : [''];

        return [
            'id' => $this->id,
            'name' => $this->name,
            'title' => $this->title,
            'type' => $this->type,
            'variantType' => $this->variant_type,
            'status' => $this->status,
            'options' => $options
        ];
    }
}
