<?php

namespace App\Models\Ads;

use App\Models\AuctionBids;
use App\Models\Categories;
use App\Models\Favorites;
use App\Models\Message\Messages;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Turkey\Cities\Models\City;
use Turkey\Cities\Models\County;

class Ads extends Model
{
    use HasFactory;
    protected $table = 'ads';

    public function category(): HasOne
    {
        return $this->hasOne(Categories::class,'id', 'category_id');
    }

    public function user(): HasOne
    {
        return $this->hasOne(User::class,'id', 'user_id');
    }

    public function messages(): HasMany
    {
        return $this->hasMany(Messages::class,'ads_id', 'id');
    }

    public function cityRela(): HasOne
    {
        return $this->hasOne(City::class, 'id', 'city');
    }

    public function districtRela(): HasOne
    {
        return $this->hasOne(County::class, 'id', 'district');
    }

    public function gallery(): HasMany
    {
        return $this->hasMany(AdsGallery::class, 'ads_id', 'id');
    }

    public function prices(): HasMany
    {
        return $this->hasMany(AdsPrices::class, 'ads_id', 'id')->orderBy('id', 'desc');;
    }

    public function variants(): HasMany
    {
        return $this->hasMany(AdsVariants::class, 'ads_id', 'id');
    }

    public function dopings(): HasMany
    {
        return $this->hasMany(AdsDoping::class, 'ads_id', 'id');
    }

    public function auctions(): HasMany
    {
        return $this->hasMany(AuctionBids::class, 'ad_id', 'id');
    }

    public function favorites(): HasMany
    {
        return $this->hasMany(Favorites::class, 'ads_id', 'id');
    }
}
