<?php

namespace App\Models\Ads;

use App\Models\DopingPackages;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class AdsDoping extends Model
{
    use HasFactory;

    protected $table = 'ads_doping';

    public function dopingPackage(): HasOne
    {
        return $this->hasOne(DopingPackages::class, 'id', 'doping_id');
    }

    public function ads(): HasOne
    {
        return $this->hasOne(Ads::class, 'id', 'ads_id');
    }
}
