<?php

namespace App\Models;

use App\Http\Controllers\CategoryController;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Kalnoy\Nestedset\NodeTrait;

class Categories extends Model
{
    use HasFactory, NodeTrait;
    protected $table = 'categories';

    public function parent(): BelongsTo
    {
        return $this->belongsTo(Categories::class, 'parent_id');
    }

    public function children(): HasMany
    {
        return $this->hasMany(Categories::class, 'parent_id');
    }

    public function variants(): HasMany
    {
        return $this->hasMany(CategoryVariants::class, 'category_id', 'id');
    }

    public function descendants()
    {
        return $this->children()->with('descendants');
    }

}
