<?php

namespace App\Models\Message;

use App\Models\Ads\Ads;
use App\Models\Demands\Demands;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class Messages extends Model
{
    use HasFactory;
    protected $table = 'messages';

    public function ad(): HasOne
    {
        return $this->hasOne(Ads::class, 'id', 'ads_id');
    }

    public function demand(): HasOne
    {
        return $this->hasOne(Demands::class, 'id', 'demand_id');
    }

    public function sender(): HasOne
    {
        return $this->hasOne(User::class, 'id', 'sender_id');
    }

    public function recipient(): HasOne
    {
        return $this->hasOne(User::class, 'id', 'recipient_id');
    }

    public function messageDetail(): HasMany
    {
        return $this->hasMany(MessageDetails::class, 'message_id', 'id');
    }
}
