<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PremiumPackage extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'duration',
        'price',
        'original_price',
        'description',
        'features',
        'popular',
        'color',
        'is_active',
        'sort_order'
    ];

    protected $casts = [
        'features' => 'array',
        'popular' => 'boolean',
        'is_active' => 'boolean',
        'price' => 'decimal:2',
        'original_price' => 'decimal:2'
    ];

    public function userPremiums()
    {
        return $this->hasMany(UserPremium::class, 'package_id');
    }

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function scopeOrdered($query)
    {
        return $query->orderBy('sort_order')->orderBy('id');
    }
}
