<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Sliders extends Model
{
    use SoftDeletes;

    protected $table = 'sliders';

    protected $fillable = [
        'title',
        'subtitle', 
        'description',
        'image',
        'button_text',
        'button_link',
        'order',
        'status',
        'created_by',
        'updated_by'
    ];

    protected $casts = [
        'status' => 'boolean',
        'order' => 'integer'
    ];

    protected $dates = ['deleted_at'];

    // Scope for active sliders
    public function scopeActive($query)
    {
        return $query->where('status', true);
    }

    // Scope for ordered sliders
    public function scopeOrdered($query)
    {
        return $query->orderBy('order', 'asc');
    }

    // Get creator user
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    // Get updater user
    public function updater()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }
}