<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class UserPremium extends Model
{
    use HasFactory;
    
    protected $table = 'user_premium';

    protected $fillable = [
        'user_id',
        'package_id',
        'price',
        'start_date',
        'end_date',
        'status',
        'uniq'
    ];

    protected $casts = [
        'start_date' => 'datetime',
        'end_date' => 'datetime',
        'price' => 'decimal:2'
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function package(): BelongsTo
    {
        return $this->belongsTo(PremiumPackage::class, 'package_id');
    }

    public function scopeActive($query)
    {
        return $query->where('status', 1)
                    ->where('end_date', '>', now());
    }

    public function scopeExpired($query)
    {
        return $query->where('end_date', '<=', now())
                    ->where('status', 1);
    }

    public function scopeCancelled($query)
    {
        return $query->where('status', 0);
    }

    public function getStatusTextAttribute()
    {
        if ($this->status == 0) {
            return 'cancelled';
        }
        
        if ($this->end_date <= now()) {
            return 'expired';
        }
        
        return 'active';
    }
}
