<?php

namespace App\Models\Variant;

use App\Models\CategoryVariants;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class Variants extends Model
{
    use HasFactory;

    protected $table = 'variants';

    public function variantOptions(): HasMany
    {
        return $this->hasMany(VariantOptions::class, 'variant_id', 'id');
    }

    public function categoryVariant(): HasOne
    {
        return $this->hasOne(CategoryVariants::class, 'variant_id', 'id');
    }
}
