<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('doping_packages', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->integer('day')->default(1);
            $table->float('price',9,2);
            $table->integer('type')->comment('1: Öne Çıkar - 2: Üste Taşı');
            $table->integer('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('doping_packages');
    }
};
