<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('demands', function (Blueprint $table) {
            $table->id();
            $table->integer('category_id');
            $table->integer('user_id');
            $table->string('title');
            $table->decimal('min_price', 15,2)->nullable();
            $table->decimal('max_price', 15,2)->nullable();
            $table->integer('city');
            $table->integer('district');
            $table->longText('description')->nullable();
            $table->string('slug');
            $table->integer('status');
            $table->string('demand_no')->nullable();
            $table->text('cancel_message')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('demands');
    }
};
