<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $permissions = [
            [
                'subject' => 'users',
                'actions' => ['create', 'read', 'update', 'delete'],
                'tags' => ['Kullanıcı Oluştur', 'Kullanıcı Görüntüle', 'Kullanıcı Güncelle', 'Kullanıcı Sil'],
            ],
            [
                'subject' => 'roles',
                'actions' => ['create', 'read', 'update', 'delete'],
                'tags' => ['Rol Oluştur', 'Rol Görüntüle', 'Rol Güncelle', 'Rol Sil'],
            ],
            [
                'subject' => 'permissions',
                'actions' => ['create', 'read', 'update', 'delete'],
                'tags' => ['Yetki Oluştur', 'Yetki Görüntüle', 'Yetki Güncelle', 'Yetki Sil'],
            ],
            [
                'subject' => 'blog',
                'actions' => ['create', 'read', 'update', 'delete'],
                'tags' => ['Blog Oluştur', 'Blog Görüntüle', 'Blog Güncelle', 'Blog Sil'],
            ],
            [
                'subject' => 'premium',
                'actions' => ['create', 'read', 'update', 'delete'],
                'tags' => ['Premium Oluştur', 'Premium Görüntüle', 'Premium Güncelle', 'Premium Sil'],
            ],
        ];

        foreach ($permissions as $keyone => $permission) {
            foreach ($permission['actions'] as $key => $action) {
                Permission::create([
                    'name' => $action . ' ' . $permission['subject'],
                    'title' => $permission['tags'][$key]
                ]);
            }
        }
    }
}
