<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\PremiumPackage;

class PremiumPackageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Frontend'deki statik premium paket verilerini database'e seed et
        $packages = [
            [
                'name' => 'Aylık Premium',
                'duration' => '1 Ay',
                'price' => 49.99,
                'original_price' => 59.99,
                'description' => 'Tüm premium özelliklere 1 ay boyunca erişim',
                'features' => [
                    'Sınırsız talep görüntüleme',
                    'Gelişmiş arama filtreleri',
                    'Öncelikli destek',
                    'Favori listelerinde sınırsız kayıt',
                    'Günlük trend raporları',
                    'E-posta bildirimleri'
                ],
                'popular' => false,
                'color' => 'primary',
                'is_active' => true,
                'sort_order' => 1
            ],
            [
                'name' => '3 Aylık Premium',
                'duration' => '3 Ay',
                'price' => 129.99,
                'original_price' => 179.97,
                'description' => 'En popüler seçenek! %28 tasarruf',
                'features' => [
                    'Aylık Premium tüm özellikler',
                    'VIP müşteri desteği',
                    'Özel kategori bildirimleri',
                    'Gelişmiş istatistikler',
                    'API erişimi (beta)',
                    'Özelleştirilebilir dashboard',
                    'Otomatik fiyat takibi'
                ],
                'popular' => true,
                'color' => 'success',
                'is_active' => true,
                'sort_order' => 2
            ],
            [
                'name' => 'Yıllık Premium',
                'duration' => '1 Yıl',
                'price' => 399.99,
                'original_price' => 719.88,
                'description' => 'En avantajlı seçenek! %44 tasarruf',
                'features' => [
                    '3 Aylık Premium tüm özellikler',
                    'Kişisel hesap yöneticisi',
                    'Özel pazarlama içerikleri',
                    'B2B özel araçlar',
                    'Sınırsız API kullanımı',
                    'Beyaz etiket çözümler',
                    'Öncelikli yeni özellik erişimi',
                    '7/24 telefon desteği'
                ],
                'popular' => false,
                'color' => 'warning',
                'is_active' => true,
                'sort_order' => 3
            ]
        ];

        foreach ($packages as $package) {
            PremiumPackage::firstOrCreate(
                ['name' => $package['name']],
                $package
            );
        }

        $this->command->info('✅ Premium paketleri başarıyla seed edildi!');
    }
}