<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Sliders;
use Carbon\Carbon;

class SliderSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Mevcut slider verilerini temizle
        Sliders::truncate();

        $sliders = [
            [
                'title' => 'Premium İlan Paketleriyle Öne Çıkın.',
                'subtitle' => 'Premium Hizmetler',
                'description' => 'Özel premium paketlerimizle ilanlarınızı öne çıkarın. Daha fazla görüntülenme ve hızlı satış imkanı için premium hizmetlerimizi keşfedin.',
                'image' => '/img/premium-slider.jpg',
                'button_text' => 'Premium Paketler',
                'button_link' => '/premium',
                'order' => 1,
                'status' => 1,
                'created_by' => 1,
                'updated_by' => 1,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'title' => 'İkinci El Alım Satım',
                'subtitle' => 'Güvenli Ticaret',
                'description' => 'En güvenli alım satım platformu ile ikinci el eşyalarınızı kolayca alın ve satın. Binlerce güvenilir kullanıcı arasında güvenle işlem yapın.',
                'image' => '/img/ads.jpg',
                'button_text' => 'Keşfet',
                'button_link' => '/category/ikinci-el',
                'order' => 2,
                'status' => 1,
                'created_by' => 1,
                'updated_by' => 1,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'title' => 'Araç Alım Satım',
                'subtitle' => 'Otomobil Dünyası',
                'description' => 'Hayalinizdeki aracı bulun veya aracınızı kolayca satın. Türkiye\'nin en kapsamlı araç pazarında binlerce seçenek sizi bekliyor.',
                'image' => '/img/ads.jpg',
                'button_text' => 'Araçlara Bak',
                'button_link' => '/category/vasita',
                'order' => 3,
                'status' => 1,
                'created_by' => 1,
                'updated_by' => 1,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'title' => 'Emlak İlanları',
                'subtitle' => 'Emlak Dünyası',
                'description' => 'Ev, işyeri ve arsa ilanları ile hayalinizdeki emlağa ulaşın. Konut, ticari ve arazi kategorilerinde binlerce ilan sizleri bekliyor.',
                'image' => '/img/ads.jpg',
                'button_text' => 'İncele',
                'button_link' => '/category/emlak',
                'order' => 4,
                'status' => 1,
                'created_by' => 1,
                'updated_by' => 1,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]
        ];

        foreach ($sliders as $slider) {
            Sliders::create($slider);
        }
    }
}