<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Role;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $users = [
            [
                'name' => 'Berkay Kara',
                'email' => 'admin@admin.com',
                'password' => 'Test1234*',
                'role' => 'super-admin',
            ],
            [
                'name' => 'Aycan Işık',
                'email' => 'member@member.com',
                'password' => 'Test1234*',
                'role' => 'member',
            ],
        ];

        foreach ($users as $user) {
            $u = User::create([
                'name' => $user['name'],
                'email' => $user['email'],
                'password' => Hash::make($user['password'])
            ]);

            $role = Role::where('name', $user['role'])->first();

            $u->assignRole($user['role']);
            $u->givePermissionTo($role->permissions);
        }
    }
}
