export { SVG } from './svg/index.js';
export { parseSVG, parseSVGSync } from './svg/parse.js';
export { parseSVGStyle, parseSVGStyleSync } from './svg/parse-style.js';
export { analyseSVGStructure } from './svg/analyse.js';
export { cleanupSVG } from './svg/cleanup.js';
export { removeBadAttributes } from './svg/cleanup/attribs.js';
export { checkBadTags } from './svg/cleanup/bad-tags.js';
export { cleanupRootStyle } from './svg/cleanup/root-style.js';
export { cleanupInlineStyle } from './svg/cleanup/inline-style.js';
export { cleanupSVGRoot } from './svg/cleanup/root-svg.js';
export { convertStyleToAttrs } from './svg/cleanup/svgo-style.js';
export { IconSet, blankIconSet } from './icon-set/index.js';
export { mergeIconSets } from './icon-set/merge.js';
export { addTagsToIconSet } from './icon-set/tags.js';
export { importFromFigma } from './import/figma/index.js';
export { importDirectory, importDirectorySync } from './import/directory.js';
export { downloadGitRepo } from './download/git/index.js';
export { getGitRepoHash } from './download/git/hash.js';
export { getGitRepoBranch } from './download/git/branch.js';
export { resetGitRepoContents } from './download/git/reset.js';
export { downloadGitHubRepo } from './download/github/index.js';
export { getGitHubRepoHash } from './download/github/hash.js';
export { downloadGitLabRepo } from './download/gitlab/index.js';
export { getGitLabRepoHash } from './download/gitlab/hash.js';
export { downloadNPMPackage } from './download/npm/index.js';
export { getNPMVersion, getPackageVersion } from './download/npm/version.js';
export { downloadPackage } from './download/index.js';
export { downloadFile } from './download/api/download.js';
export { isEmptyColor, parseColors, parseColorsSync } from './colors/parse.js';
export { validateColors, validateColorsSync } from './colors/validate.js';
export { detectIconSetPalette } from './colors/detect.js';
export { runSVGO } from './optimise/svgo.js';
export { deOptimisePaths } from './optimise/flags.js';
export { resetSVGOrigin } from './optimise/origin.js';
export { scaleSVG } from './optimise/scale.js';
export { cleanupGlobalStyle } from './optimise/global-style.js';
export { exportToDirectory } from './export/directory.js';
export { exportIconPackage } from './export/icon-package.js';
export { exportJSONPackage } from './export/json-package.js';
export { writeJSONFile } from './misc/write-json.js';
export { prepareDirectoryForExport } from './export/helpers/prepare.js';
export { scanDirectory, scanDirectorySync } from './misc/scan.js';
export { compareDirectories } from './misc/compare-dirs.js';
export { unzip } from './download/helpers/unzip.js';
export { untar } from './download/helpers/untar.js';
export { execAsync } from './misc/exec.js';
export { cleanupIconKeyword } from './misc/keyword.js';
export { bumpVersion } from './misc/bump-version.js';
export { sendAPIQuery } from './download/api/index.js';
import '@iconify/types';
import '@iconify/utils/lib/customisations/defaults';
import './misc/cheerio.js';
import './css/parser/types.js';
import './svg/analyse/types.js';
import './icon-set/types.js';
import '@iconify/utils/lib/icon-set/tree';
import './download/types/modified.js';
import './import/figma/types/options.js';
import './import/figma/types/nodes.js';
import './import/figma/types/api.js';
import './import/figma/types/result.js';
import './download/types/sources.js';
import './download/github/types.js';
import './download/gitlab/types.js';
import './download/npm/types.js';
import './download/api/types.js';
import '@iconify/utils/lib/colors/types';
import './colors/attribs.js';
import 'svgo';
import './export/helpers/custom-files.js';
import 'fs';
import 'child_process';
