/// <reference types="node" resolution-mode="require"/>
import type { Buffer } from 'node:buffer';
import type { ArrayLike, Class, Falsy, NodeStream, ObservableLike, Predicate, Primitive, TypedArray, WeakRef } from './types.js';
declare const objectTypeNames: readonly ["Function", "Generator", "AsyncGenerator", "GeneratorFunction", "AsyncGeneratorFunction", "AsyncFunction", "Observable", "Array", "Buffer", "Blob", "Object", "RegExp", "Date", "Error", "Map", "Set", "WeakMap", "WeakSet", "WeakRef", "ArrayBuffer", "SharedArrayBuffer", "DataView", "Promise", "URL", "FormData", "URLSearchParams", "HTMLElement", "NaN", "Int8Array", "Uint8Array", "Uint8ClampedArray", "Int16Array", "Uint16Array", "Int32Array", "Uint32Array", "Float32Array", "Float64Array", "BigInt64Array", "BigUint64Array"];
type ObjectTypeName = typeof objectTypeNames[number];
declare const primitiveTypeNames: readonly ["null", "undefined", "string", "number", "bigint", "boolean", "symbol"];
type PrimitiveTypeName = typeof primitiveTypeNames[number];
export type TypeName = ObjectTypeName | PrimitiveTypeName;
declare const assertionTypeDescriptions: readonly ["positive number", "negative number", "Class", "string with a number", "null or undefined", "Iterable", "AsyncIterable", "native Promise", "EnumCase", "string with a URL", "truthy", "falsy", "primitive", "integer", "plain object", "TypedArray", "array-like", "tuple-like", "Node.js Stream", "infinite number", "empty array", "non-empty array", "empty string", "empty string or whitespace", "non-empty string", "non-empty string and not whitespace", "empty object", "non-empty object", "empty set", "non-empty set", "empty map", "non-empty map", "PropertyKey", "even integer", "odd integer", "T", "in range", "predicate returns truthy for any value", "predicate returns truthy for all values", "valid length", "whitespace string", "Function", "Generator", "AsyncGenerator", "GeneratorFunction", "AsyncGeneratorFunction", "AsyncFunction", "Observable", "Array", "Buffer", "Blob", "Object", "RegExp", "Date", "Error", "Map", "Set", "WeakMap", "WeakSet", "WeakRef", "ArrayBuffer", "SharedArrayBuffer", "DataView", "Promise", "URL", "FormData", "URLSearchParams", "HTMLElement", "NaN", "Int8Array", "Uint8Array", "Uint8ClampedArray", "Int16Array", "Uint16Array", "Int32Array", "Uint32Array", "Float32Array", "Float64Array", "BigInt64Array", "BigUint64Array", "null", "undefined", "string", "number", "bigint", "boolean", "symbol"];
export type AssertionTypeDescription = typeof assertionTypeDescriptions[number];
declare function detect(value: unknown): TypeName;
declare const is: typeof detect & {
    all: typeof isAll;
    any: typeof isAny;
    array: typeof isArray;
    arrayBuffer: typeof isArrayBuffer;
    arrayLike: typeof isArrayLike;
    asyncFunction: typeof isAsyncFunction;
    asyncGenerator: typeof isAsyncGenerator;
    asyncGeneratorFunction: typeof isAsyncGeneratorFunction;
    asyncIterable: typeof isAsyncIterable;
    bigint: typeof isBigint;
    bigInt64Array: typeof isBigInt64Array;
    bigUint64Array: typeof isBigUint64Array;
    blob: typeof isBlob;
    boolean: typeof isBoolean;
    boundFunction: typeof isBoundFunction;
    buffer: typeof isBuffer;
    class: typeof isClass;
    /** @deprecated Renamed to `class`. */
    class_: typeof isClass;
    dataView: typeof isDataView;
    date: typeof isDate;
    detect: typeof detect;
    directInstanceOf: typeof isDirectInstanceOf;
    /** @deprecated Renamed to `htmlElement` */
    domElement: typeof isHtmlElement;
    emptyArray: typeof isEmptyArray;
    emptyMap: typeof isEmptyMap;
    emptyObject: typeof isEmptyObject;
    emptySet: typeof isEmptySet;
    emptyString: typeof isEmptyString;
    emptyStringOrWhitespace: typeof isEmptyStringOrWhitespace;
    enumCase: typeof isEnumCase;
    error: typeof isError;
    evenInteger: typeof isEvenInteger;
    falsy: typeof isFalsy;
    float32Array: typeof isFloat32Array;
    float64Array: typeof isFloat64Array;
    formData: typeof isFormData;
    function: typeof isFunction;
    /** @deprecated Renamed to `function`. */
    function_: typeof isFunction;
    generator: typeof isGenerator;
    generatorFunction: typeof isGeneratorFunction;
    htmlElement: typeof isHtmlElement;
    infinite: typeof isInfinite;
    inRange: typeof isInRange;
    int16Array: typeof isInt16Array;
    int32Array: typeof isInt32Array;
    int8Array: typeof isInt8Array;
    integer: typeof isInteger;
    iterable: typeof isIterable;
    map: typeof isMap;
    nan: typeof isNan;
    nativePromise: typeof isNativePromise;
    negativeNumber: typeof isNegativeNumber;
    nodeStream: typeof isNodeStream;
    nonEmptyArray: typeof isNonEmptyArray;
    nonEmptyMap: typeof isNonEmptyMap;
    nonEmptyObject: typeof isNonEmptyObject;
    nonEmptySet: typeof isNonEmptySet;
    nonEmptyString: typeof isNonEmptyString;
    nonEmptyStringAndNotWhitespace: typeof isNonEmptyStringAndNotWhitespace;
    null: typeof isNull;
    /** @deprecated Renamed to `null`. */
    null_: typeof isNull;
    nullOrUndefined: typeof isNullOrUndefined;
    number: typeof isNumber;
    numericString: typeof isNumericString;
    object: typeof isObject;
    observable: typeof isObservable;
    oddInteger: typeof isOddInteger;
    plainObject: typeof isPlainObject;
    positiveNumber: typeof isPositiveNumber;
    primitive: typeof isPrimitive;
    promise: typeof isPromise;
    propertyKey: typeof isPropertyKey;
    regExp: typeof isRegExp;
    safeInteger: typeof isSafeInteger;
    set: typeof isSet;
    sharedArrayBuffer: typeof isSharedArrayBuffer;
    string: typeof isString;
    symbol: typeof isSymbol;
    truthy: typeof isTruthy;
    tupleLike: typeof isTupleLike;
    typedArray: typeof isTypedArray;
    uint16Array: typeof isUint16Array;
    uint32Array: typeof isUint32Array;
    uint8Array: typeof isUint8Array;
    uint8ClampedArray: typeof isUint8ClampedArray;
    undefined: typeof isUndefined;
    urlInstance: typeof isUrlInstance;
    urlSearchParams: typeof isUrlSearchParams;
    urlString: typeof isUrlString;
    validLength: typeof isValidLength;
    weakMap: typeof isWeakMap;
    weakRef: typeof isWeakRef;
    weakSet: typeof isWeakSet;
    whitespaceString: typeof isWhitespaceString;
};
export declare function isAll(predicate: Predicate, ...values: unknown[]): boolean;
export declare function isAny(predicate: Predicate | Predicate[], ...values: unknown[]): boolean;
export declare function isArray<T = unknown>(value: unknown, assertion?: (value: T) => value is T): value is T[];
export declare function isArrayBuffer(value: unknown): value is ArrayBuffer;
export declare function isArrayLike<T = unknown>(value: unknown): value is ArrayLike<T>;
export declare function isAsyncFunction<T = unknown>(value: unknown): value is ((...args: any[]) => Promise<T>);
export declare function isAsyncGenerator(value: unknown): value is AsyncGenerator;
export declare function isAsyncGeneratorFunction(value: unknown): value is ((...args: any[]) => Promise<unknown>);
export declare function isAsyncIterable<T = unknown>(value: unknown): value is AsyncIterable<T>;
export declare function isBigint(value: unknown): value is bigint;
export declare function isBigInt64Array(value: unknown): value is BigInt64Array;
export declare function isBigUint64Array(value: unknown): value is BigUint64Array;
export declare function isBlob(value: unknown): value is Blob;
export declare function isBoolean(value: unknown): value is boolean;
export declare function isBoundFunction(value: unknown): value is Function;
export declare function isBuffer(value: unknown): value is Buffer;
export declare function isClass(value: unknown): value is Class;
export declare function isDataView(value: unknown): value is DataView;
export declare function isDate(value: unknown): value is Date;
export declare function isDirectInstanceOf<T>(instance: unknown, class_: Class<T>): instance is T;
export declare function isEmptyArray(value: unknown): value is never[];
export declare function isEmptyMap(value: unknown): value is Map<never, never>;
export declare function isEmptyObject<Key extends keyof any = string>(value: unknown): value is Record<Key, never>;
export declare function isEmptySet(value: unknown): value is Set<never>;
export declare function isEmptyString(value: unknown): value is '';
export declare function isEmptyStringOrWhitespace(value: unknown): value is string;
export declare function isEnumCase<T = unknown>(value: unknown, targetEnum: T): boolean;
export declare function isError(value: unknown): value is Error;
export declare function isEvenInteger(value: unknown): value is number;
export declare function isFalsy(value: unknown): value is Falsy;
export declare function isFloat32Array(value: unknown): value is Float32Array;
export declare function isFloat64Array(value: unknown): value is Float64Array;
export declare function isFormData(value: unknown): value is FormData;
export declare function isFunction(value: unknown): value is Function;
export declare function isGenerator(value: unknown): value is Generator;
export declare function isGeneratorFunction(value: unknown): value is GeneratorFunction;
export declare function isHtmlElement(value: unknown): value is HTMLElement;
export declare function isInfinite(value: unknown): value is number;
export declare function isInRange(value: number, range: number | [number, number]): value is number;
export declare function isInt16Array(value: unknown): value is Int16Array;
export declare function isInt32Array(value: unknown): value is Int32Array;
export declare function isInt8Array(value: unknown): value is Int8Array;
export declare function isInteger(value: unknown): value is number;
export declare function isIterable<T = unknown>(value: unknown): value is Iterable<T>;
export declare function isMap<Key = unknown, Value = unknown>(value: unknown): value is Map<Key, Value>;
export declare function isNan(value: unknown): boolean;
export declare function isNativePromise<T = unknown>(value: unknown): value is Promise<T>;
export declare function isNegativeNumber(value: unknown): value is number;
export declare function isNodeStream(value: unknown): value is NodeStream;
export declare function isNonEmptyArray<T = unknown, Item = unknown>(value: T | Item[]): value is [Item, ...Item[]];
export declare function isNonEmptyMap<Key = unknown, Value = unknown>(value: unknown): value is Map<Key, Value>;
export declare function isNonEmptyObject<Key extends keyof any = string, Value = unknown>(value: unknown): value is Record<Key, Value>;
export declare function isNonEmptySet<T = unknown>(value: unknown): value is Set<T>;
export declare function isNonEmptyString(value: unknown): value is string;
export declare function isNonEmptyStringAndNotWhitespace(value: unknown): value is string;
export declare function isNull(value: unknown): value is null;
export declare function isNullOrUndefined(value: unknown): value is null | undefined;
export declare function isNumber(value: unknown): value is number;
export declare function isNumericString(value: unknown): value is `${number}`;
export declare function isObject(value: unknown): value is object;
export declare function isObservable(value: unknown): value is ObservableLike;
export declare function isOddInteger(value: unknown): value is number;
export declare function isPlainObject<Value = unknown>(value: unknown): value is Record<PropertyKey, Value>;
export declare function isPositiveNumber(value: unknown): value is number;
export declare function isPrimitive(value: unknown): value is Primitive;
export declare function isPromise<T = unknown>(value: unknown): value is Promise<T>;
export declare function isPropertyKey(value: unknown): value is PropertyKey;
export declare function isRegExp(value: unknown): value is RegExp;
export declare function isSafeInteger(value: unknown): value is number;
export declare function isSet<T = unknown>(value: unknown): value is Set<T>;
export declare function isSharedArrayBuffer(value: unknown): value is SharedArrayBuffer;
export declare function isString(value: unknown): value is string;
export declare function isSymbol(value: unknown): value is symbol;
export declare function isTruthy<T>(value: T | Falsy): value is T;
type TypeGuard<T> = (value: unknown) => value is T;
type ResolveTypesOfTypeGuardsTuple<TypeGuardsOfT, ResultOfT extends unknown[] = []> = TypeGuardsOfT extends [TypeGuard<infer U>, ...infer TOthers] ? ResolveTypesOfTypeGuardsTuple<TOthers, [...ResultOfT, U]> : TypeGuardsOfT extends undefined[] ? ResultOfT : never;
export declare function isTupleLike<T extends Array<TypeGuard<unknown>>>(value: unknown, guards: [...T]): value is ResolveTypesOfTypeGuardsTuple<T>;
export declare function isTypedArray(value: unknown): value is TypedArray;
export declare function isUint16Array(value: unknown): value is Uint16Array;
export declare function isUint32Array(value: unknown): value is Uint32Array;
export declare function isUint8Array(value: unknown): value is Uint8Array;
export declare function isUint8ClampedArray(value: unknown): value is Uint8ClampedArray;
export declare function isUndefined(value: unknown): value is undefined;
export declare function isUrlInstance(value: unknown): value is URL;
export declare function isUrlSearchParams(value: unknown): value is URLSearchParams;
export declare function isUrlString(value: unknown): value is string;
export declare function isValidLength(value: unknown): value is number;
export declare function isWeakMap<Key extends object = object, Value = unknown>(value: unknown): value is WeakMap<Key, Value>;
export declare function isWeakRef(value: unknown): value is WeakRef<object>;
export declare function isWeakSet(value: unknown): value is WeakSet<object>;
export declare function isWhitespaceString(value: unknown): value is string;
type Assert = {
    undefined: (value: unknown) => asserts value is undefined;
    string: (value: unknown) => asserts value is string;
    number: (value: unknown) => asserts value is number;
    positiveNumber: (value: unknown) => asserts value is number;
    negativeNumber: (value: unknown) => asserts value is number;
    bigint: (value: unknown) => asserts value is bigint;
    function: (value: unknown) => asserts value is Function;
    /** @deprecated Renamed to `function`. */
    function_: (value: unknown) => asserts value is Function;
    null: (value: unknown) => asserts value is null;
    /** @deprecated Renamed to `null`. */
    null_: (value: unknown) => asserts value is null;
    class: (value: unknown) => asserts value is Class;
    /** @deprecated Renamed to `class`. */
    class_: (value: unknown) => asserts value is Class;
    boolean: (value: unknown) => asserts value is boolean;
    symbol: (value: unknown) => asserts value is symbol;
    numericString: (value: unknown) => asserts value is `${number}`;
    array: <T = unknown>(value: unknown, assertion?: (element: unknown) => asserts element is T) => asserts value is T[];
    buffer: (value: unknown) => asserts value is Buffer;
    blob: (value: unknown) => asserts value is Blob;
    nullOrUndefined: (value: unknown) => asserts value is null | undefined;
    object: <Key extends keyof any = string, Value = unknown>(value: unknown) => asserts value is Record<Key, Value>;
    iterable: <T = unknown>(value: unknown) => asserts value is Iterable<T>;
    asyncIterable: <T = unknown>(value: unknown) => asserts value is AsyncIterable<T>;
    generator: (value: unknown) => asserts value is Generator;
    asyncGenerator: (value: unknown) => asserts value is AsyncGenerator;
    nativePromise: <T = unknown>(value: unknown) => asserts value is Promise<T>;
    promise: <T = unknown>(value: unknown) => asserts value is Promise<T>;
    generatorFunction: (value: unknown) => asserts value is GeneratorFunction;
    asyncGeneratorFunction: (value: unknown) => asserts value is AsyncGeneratorFunction;
    asyncFunction: (value: unknown) => asserts value is Function;
    boundFunction: (value: unknown) => asserts value is Function;
    regExp: (value: unknown) => asserts value is RegExp;
    date: (value: unknown) => asserts value is Date;
    error: (value: unknown) => asserts value is Error;
    map: <Key = unknown, Value = unknown>(value: unknown) => asserts value is Map<Key, Value>;
    set: <T = unknown>(value: unknown) => asserts value is Set<T>;
    weakMap: <Key extends object = object, Value = unknown>(value: unknown) => asserts value is WeakMap<Key, Value>;
    weakSet: <T extends object = object>(value: unknown) => asserts value is WeakSet<T>;
    weakRef: <T extends object = object>(value: unknown) => asserts value is WeakRef<T>;
    int8Array: (value: unknown) => asserts value is Int8Array;
    uint8Array: (value: unknown) => asserts value is Uint8Array;
    uint8ClampedArray: (value: unknown) => asserts value is Uint8ClampedArray;
    int16Array: (value: unknown) => asserts value is Int16Array;
    uint16Array: (value: unknown) => asserts value is Uint16Array;
    int32Array: (value: unknown) => asserts value is Int32Array;
    uint32Array: (value: unknown) => asserts value is Uint32Array;
    float32Array: (value: unknown) => asserts value is Float32Array;
    float64Array: (value: unknown) => asserts value is Float64Array;
    bigInt64Array: (value: unknown) => asserts value is BigInt64Array;
    bigUint64Array: (value: unknown) => asserts value is BigUint64Array;
    arrayBuffer: (value: unknown) => asserts value is ArrayBuffer;
    sharedArrayBuffer: (value: unknown) => asserts value is SharedArrayBuffer;
    dataView: (value: unknown) => asserts value is DataView;
    enumCase: <T = unknown>(value: unknown, targetEnum: T) => asserts value is T[keyof T];
    urlInstance: (value: unknown) => asserts value is URL;
    urlString: (value: unknown) => asserts value is string;
    truthy: <T>(value: T | Falsy) => asserts value is T;
    falsy: (value: unknown) => asserts value is Falsy;
    nan: (value: unknown) => asserts value is number;
    primitive: (value: unknown) => asserts value is Primitive;
    integer: (value: unknown) => asserts value is number;
    safeInteger: (value: unknown) => asserts value is number;
    plainObject: <Value = unknown>(value: unknown) => asserts value is Record<PropertyKey, Value>;
    typedArray: (value: unknown) => asserts value is TypedArray;
    arrayLike: <T = unknown>(value: unknown) => asserts value is ArrayLike<T>;
    tupleLike: <T extends Array<TypeGuard<unknown>>>(value: unknown, guards: [...T]) => asserts value is ResolveTypesOfTypeGuardsTuple<T>;
    /** @deprecated Renamed to `htmlElement` */
    domElement: (value: unknown) => asserts value is HTMLElement;
    htmlElement: (value: unknown) => asserts value is HTMLElement;
    observable: (value: unknown) => asserts value is ObservableLike;
    nodeStream: (value: unknown) => asserts value is NodeStream;
    infinite: (value: unknown) => asserts value is number;
    emptyArray: (value: unknown) => asserts value is never[];
    nonEmptyArray: <T = unknown, Item = unknown>(value: T | Item[]) => asserts value is [Item, ...Item[]];
    emptyString: (value: unknown) => asserts value is '';
    emptyStringOrWhitespace: (value: unknown) => asserts value is string;
    nonEmptyString: (value: unknown) => asserts value is string;
    nonEmptyStringAndNotWhitespace: (value: unknown) => asserts value is string;
    emptyObject: <Key extends keyof any = string>(value: unknown) => asserts value is Record<Key, never>;
    nonEmptyObject: <Key extends keyof any = string, Value = unknown>(value: unknown) => asserts value is Record<Key, Value>;
    emptySet: (value: unknown) => asserts value is Set<never>;
    nonEmptySet: <T = unknown>(value: unknown) => asserts value is Set<T>;
    emptyMap: (value: unknown) => asserts value is Map<never, never>;
    nonEmptyMap: <Key = unknown, Value = unknown>(value: unknown) => asserts value is Map<Key, Value>;
    propertyKey: (value: unknown) => asserts value is PropertyKey;
    formData: (value: unknown) => asserts value is FormData;
    urlSearchParams: (value: unknown) => asserts value is URLSearchParams;
    validLength: (value: unknown) => asserts value is number;
    whitespaceString: (value: unknown) => asserts value is string;
    evenInteger: (value: number) => asserts value is number;
    oddInteger: (value: number) => asserts value is number;
    directInstanceOf: <T>(instance: unknown, class_: Class<T>) => asserts instance is T;
    inRange: (value: number, range: number | [number, number]) => asserts value is number;
    any: (predicate: Predicate | Predicate[], ...values: unknown[]) => void | never;
    all: (predicate: Predicate, ...values: unknown[]) => void | never;
};
export declare const assert: Assert;
export declare function assertAll(predicate: Predicate, ...values: unknown[]): void | never;
export declare function assertAny(predicate: Predicate | Predicate[], ...values: unknown[]): void | never;
export declare function assertArray<T = unknown>(value: unknown, assertion?: (element: unknown) => asserts element is T): asserts value is T[];
export declare function assertArrayBuffer(value: unknown): asserts value is ArrayBuffer;
export declare function assertArrayLike<T = unknown>(value: unknown): asserts value is ArrayLike<T>;
export declare function assertAsyncFunction(value: unknown): asserts value is Function;
export declare function assertAsyncGenerator(value: unknown): asserts value is AsyncGenerator;
export declare function assertAsyncGeneratorFunction(value: unknown): asserts value is AsyncGeneratorFunction;
export declare function assertAsyncIterable<T = unknown>(value: unknown): asserts value is AsyncIterable<T>;
export declare function assertBigint(value: unknown): asserts value is bigint;
export declare function assertBigInt64Array(value: unknown): asserts value is BigInt64Array;
export declare function assertBigUint64Array(value: unknown): asserts value is BigUint64Array;
export declare function assertBlob(value: unknown): asserts value is Blob;
export declare function assertBoolean(value: unknown): asserts value is boolean;
export declare function assertBoundFunction(value: unknown): asserts value is Function;
export declare function assertBuffer(value: unknown): asserts value is Buffer;
export declare function assertClass(value: unknown): asserts value is Class;
export declare function assertDataView(value: unknown): asserts value is DataView;
export declare function assertDate(value: unknown): asserts value is Date;
export declare function assertDirectInstanceOf<T>(instance: unknown, class_: Class<T>): asserts instance is T;
export declare function assertEmptyArray(value: unknown): asserts value is never[];
export declare function assertEmptyMap(value: unknown): asserts value is Map<never, never>;
export declare function assertEmptyObject<Key extends keyof any = string>(value: unknown): asserts value is Record<Key, never>;
export declare function assertEmptySet(value: unknown): asserts value is Set<never>;
export declare function assertEmptyString(value: unknown): asserts value is '';
export declare function assertEmptyStringOrWhitespace(value: unknown): asserts value is string;
export declare function assertEnumCase<T = unknown>(value: unknown, targetEnum: T): asserts value is T[keyof T];
export declare function assertError(value: unknown): asserts value is Error;
export declare function assertEvenInteger(value: number): asserts value is number;
export declare function assertFalsy(value: unknown): asserts value is Falsy;
export declare function assertFloat32Array(value: unknown): asserts value is Float32Array;
export declare function assertFloat64Array(value: unknown): asserts value is Float64Array;
export declare function assertFormData(value: unknown): asserts value is FormData;
export declare function assertFunction(value: unknown): asserts value is Function;
export declare function assertGenerator(value: unknown): asserts value is Generator;
export declare function assertGeneratorFunction(value: unknown): asserts value is GeneratorFunction;
export declare function assertHtmlElement(value: unknown): asserts value is HTMLElement;
export declare function assertInfinite(value: unknown): asserts value is number;
export declare function assertInRange(value: number, range: number | [number, number]): asserts value is number;
export declare function assertInt16Array(value: unknown): asserts value is Int16Array;
export declare function assertInt32Array(value: unknown): asserts value is Int32Array;
export declare function assertInt8Array(value: unknown): asserts value is Int8Array;
export declare function assertInteger(value: unknown): asserts value is number;
export declare function assertIterable<T = unknown>(value: unknown): asserts value is Iterable<T>;
export declare function assertMap<Key = unknown, Value = unknown>(value: unknown): asserts value is Map<Key, Value>;
export declare function assertNan(value: unknown): asserts value is number;
export declare function assertNativePromise<T = unknown>(value: unknown): asserts value is Promise<T>;
export declare function assertNegativeNumber(value: unknown): asserts value is number;
export declare function assertNodeStream(value: unknown): asserts value is NodeStream;
export declare function assertNonEmptyArray<T = unknown, Item = unknown>(value: T | Item[]): asserts value is [Item, ...Item[]];
export declare function assertNonEmptyMap<Key = unknown, Value = unknown>(value: unknown): asserts value is Map<Key, Value>;
export declare function assertNonEmptyObject<Key extends keyof any = string, Value = unknown>(value: unknown): asserts value is Record<Key, Value>;
export declare function assertNonEmptySet<T = unknown>(value: unknown): asserts value is Set<T>;
export declare function assertNonEmptyString(value: unknown): asserts value is string;
export declare function assertNonEmptyStringAndNotWhitespace(value: unknown): asserts value is string;
export declare function assertNull(value: unknown): asserts value is null;
export declare function assertNullOrUndefined(value: unknown): asserts value is null | undefined;
export declare function assertNumber(value: unknown): asserts value is number;
export declare function assertNumericString(value: unknown): asserts value is `${number}`;
export declare function assertObject(value: unknown): asserts value is object;
export declare function assertObservable(value: unknown): asserts value is ObservableLike;
export declare function assertOddInteger(value: number): asserts value is number;
export declare function assertPlainObject<Value = unknown>(value: unknown): asserts value is Record<PropertyKey, Value>;
export declare function assertPositiveNumber(value: unknown): asserts value is number;
export declare function assertPrimitive(value: unknown): asserts value is Primitive;
export declare function assertPromise<T = unknown>(value: unknown): asserts value is Promise<T>;
export declare function assertPropertyKey(value: unknown): asserts value is number;
export declare function assertRegExp(value: unknown): asserts value is RegExp;
export declare function assertSafeInteger(value: unknown): asserts value is number;
export declare function assertSet<T = unknown>(value: unknown): asserts value is Set<T>;
export declare function assertSharedArrayBuffer(value: unknown): asserts value is SharedArrayBuffer;
export declare function assertString(value: unknown): asserts value is string;
export declare function assertSymbol(value: unknown): asserts value is symbol;
export declare function assertTruthy<T>(value: T | Falsy): asserts value is T;
export declare function assertTupleLike<T extends Array<TypeGuard<unknown>>>(value: unknown, guards: [...T]): asserts value is ResolveTypesOfTypeGuardsTuple<T>;
export declare function assertTypedArray(value: unknown): asserts value is TypedArray;
export declare function assertUint16Array(value: unknown): asserts value is Uint16Array;
export declare function assertUint32Array(value: unknown): asserts value is Uint32Array;
export declare function assertUint8Array(value: unknown): asserts value is Uint8Array;
export declare function assertUint8ClampedArray(value: unknown): asserts value is Uint8ClampedArray;
export declare function assertUndefined(value: unknown): asserts value is undefined;
export declare function assertUrlInstance(value: unknown): asserts value is URL;
export declare function assertUrlSearchParams(value: unknown): asserts value is URLSearchParams;
export declare function assertUrlString(value: unknown): asserts value is string;
export declare function assertValidLength(value: unknown): asserts value is number;
export declare function assertWeakMap<Key extends object = object, Value = unknown>(value: unknown): asserts value is WeakMap<Key, Value>;
export declare function assertWeakRef<T extends object = object>(value: unknown): asserts value is WeakRef<T>;
export declare function assertWeakSet<T extends object = object>(value: unknown): asserts value is WeakSet<T>;
export declare function assertWhitespaceString(value: unknown): asserts value is string;
export default is;
export type { ArrayLike, Class, NodeStream, ObservableLike, Predicate, Primitive, TypedArray, } from './types.js';
