(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@tiptap/core')) :
  typeof define === 'function' && define.amd ? define(['exports', '@tiptap/core'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global["@tiptap/extension-text-align"] = {}, global.core));
})(this, (function (exports, core) { 'use strict';

  const TextAlign = core.Extension.create({
      name: 'textAlign',
      addOptions() {
          return {
              types: [],
              alignments: ['left', 'center', 'right', 'justify'],
              defaultAlignment: 'left',
          };
      },
      addGlobalAttributes() {
          return [
              {
                  types: this.options.types,
                  attributes: {
                      textAlign: {
                          default: this.options.defaultAlignment,
                          parseHTML: element => element.style.textAlign || this.options.defaultAlignment,
                          renderHTML: attributes => {
                              if (attributes.textAlign === this.options.defaultAlignment) {
                                  return {};
                              }
                              return { style: `text-align: ${attributes.textAlign}` };
                          },
                      },
                  },
              },
          ];
      },
      addCommands() {
          return {
              setTextAlign: (alignment) => ({ commands }) => {
                  if (!this.options.alignments.includes(alignment)) {
                      return false;
                  }
                  return this.options.types.every(type => commands.updateAttributes(type, { textAlign: alignment }));
              },
              unsetTextAlign: () => ({ commands }) => {
                  return this.options.types.every(type => commands.resetAttributes(type, 'textAlign'));
              },
          };
      },
      addKeyboardShortcuts() {
          return {
              'Mod-Shift-l': () => this.editor.commands.setTextAlign('left'),
              'Mod-Shift-e': () => this.editor.commands.setTextAlign('center'),
              'Mod-Shift-r': () => this.editor.commands.setTextAlign('right'),
              'Mod-Shift-j': () => this.editor.commands.setTextAlign('justify'),
          };
      },
  });

  exports.TextAlign = TextAlign;
  exports["default"] = TextAlign;

  Object.defineProperty(exports, '__esModule', { value: true });

}));
//# sourceMappingURL=index.umd.js.map
