import { Editor as CoreEditor, EditorOptions } from '@tiptap/core';
import { EditorState, Plugin, PluginKey } from '@tiptap/pm/state';
import { ComponentInternalInstance, ComponentPublicInstance } from 'vue';
import { VueRenderer } from './VueRenderer.js';
export declare type ContentComponent = ComponentInternalInstance & {
    ctx: ComponentPublicInstance;
};
export declare class Editor extends CoreEditor {
    private reactiveState;
    private reactiveExtensionStorage;
    vueRenderers: Map<string, VueRenderer>;
    contentComponent: ContentComponent | null;
    constructor(options?: Partial<EditorOptions>);
    get state(): EditorState;
    get storage(): Record<string, any>;
    /**
     * Register a ProseMirror plugin.
     */
    registerPlugin(plugin: Plugin, handlePlugins?: (newPlugin: Plugin, plugins: Plugin[]) => Plugin[]): void;
    /**
     * Unregister a ProseMirror plugin.
     */
    unregisterPlugin(nameOrPluginKey: string | PluginKey): void;
}
