"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.tsCodegen = void 0;
const reactivity_1 = require("@vue/reactivity");
const script_1 = require("../generators/script");
const template_1 = require("../generators/template");
const scriptRanges_1 = require("../parsers/scriptRanges");
const scriptSetupRanges_1 = require("../parsers/scriptSetupRanges");
const language_core_1 = require("@volar/language-core");
const muggle = __importStar(require("muggle-string"));
const templateFormatReg = /^\.template_format\.ts$/;
const templateStyleCssReg = /^\.template_style\.css$/;
exports.tsCodegen = new WeakMap();
const plugin = (ctx) => {
    return {
        version: 1,
        requiredCompilerOptions: [
            'noPropertyAccessFromIndexSignature',
            'exactOptionalPropertyTypes',
        ],
        getEmbeddedFileNames(fileName, sfc) {
            const tsx = useTsx(fileName, sfc);
            const fileNames = [];
            if (['js', 'ts', 'jsx', 'tsx'].includes(tsx.lang.value)) {
                fileNames.push(fileName + '.' + tsx.lang.value);
            }
            if (sfc.template) {
                fileNames.push(fileName + '.template_format.ts');
                fileNames.push(fileName + '.template_style.css');
            }
            return fileNames;
        },
        resolveEmbeddedFile(fileName, sfc, embeddedFile) {
            const _tsx = useTsx(fileName, sfc);
            const suffix = embeddedFile.fileName.replace(fileName, '');
            if (suffix === '.' + _tsx.lang.value) {
                embeddedFile.kind = language_core_1.FileKind.TypeScriptHostFile;
                embeddedFile.capabilities = {
                    ...language_core_1.FileCapabilities.full,
                    foldingRange: false,
                    documentFormatting: false,
                    documentSymbol: false,
                };
                const tsx = _tsx.generatedScript.value;
                if (tsx) {
                    const [content, contentStacks] = ctx.codegenStack ? muggle.track([...tsx.codes], [...tsx.codeStacks]) : [[...tsx.codes], [...tsx.codeStacks]];
                    embeddedFile.content = content;
                    embeddedFile.contentStacks = contentStacks;
                    embeddedFile.mirrorBehaviorMappings = [...tsx.mirrorBehaviorMappings];
                }
            }
            else if (suffix.match(templateFormatReg)) {
                embeddedFile.parentFileName = fileName + '.template.' + sfc.template?.lang;
                embeddedFile.kind = language_core_1.FileKind.TextFile;
                embeddedFile.capabilities = {
                    ...language_core_1.FileCapabilities.full,
                    diagnostic: false,
                    foldingRange: false,
                    codeAction: false,
                    inlayHint: false,
                };
                if (_tsx.generatedTemplate.value) {
                    const [content, contentStacks] = ctx.codegenStack ? muggle.track([..._tsx.generatedTemplate.value.formatCodes], [..._tsx.generatedTemplate.value.formatCodeStacks]) : [[..._tsx.generatedTemplate.value.formatCodes], [..._tsx.generatedTemplate.value.formatCodeStacks]];
                    embeddedFile.content = content;
                    embeddedFile.contentStacks = contentStacks;
                }
                for (const style of sfc.styles) {
                    embeddedFile.content.push('\n\n');
                    for (const cssVar of style.cssVars) {
                        embeddedFile.content.push('(');
                        embeddedFile.content.push([
                            cssVar.text,
                            style.name,
                            cssVar.offset,
                            {},
                        ]);
                        embeddedFile.content.push(');\n');
                    }
                }
            }
            else if (suffix.match(templateStyleCssReg)) {
                embeddedFile.parentFileName = fileName + '.template.' + sfc.template?.lang;
                if (_tsx.generatedTemplate.value) {
                    const [content, contentStacks] = ctx.codegenStack ? muggle.track([..._tsx.generatedTemplate.value.cssCodes], [..._tsx.generatedTemplate.value.cssCodeStacks]) : [[..._tsx.generatedTemplate.value.cssCodes], [..._tsx.generatedTemplate.value.cssCodeStacks]];
                    embeddedFile.content = content;
                    embeddedFile.contentStacks = contentStacks;
                }
                // for color pickers support
                embeddedFile.capabilities.documentSymbol = true;
            }
        },
    };
    function useTsx(fileName, sfc) {
        if (!exports.tsCodegen.has(sfc)) {
            exports.tsCodegen.set(sfc, createTsx(fileName, sfc, ctx));
        }
        return exports.tsCodegen.get(sfc);
    }
};
exports.default = plugin;
function createTsx(fileName, _sfc, { vueCompilerOptions, compilerOptions, codegenStack, modules }) {
    const ts = modules.typescript;
    const lang = (0, reactivity_1.computed)(() => {
        return !_sfc.script && !_sfc.scriptSetup ? 'ts'
            : _sfc.scriptSetup && _sfc.scriptSetup.lang !== 'js' ? _sfc.scriptSetup.lang
                : _sfc.script && _sfc.script.lang !== 'js' ? _sfc.script.lang
                    : 'js';
    });
    const scriptRanges = (0, reactivity_1.computed)(() => _sfc.scriptAst
        ? (0, scriptRanges_1.parseScriptRanges)(ts, _sfc.scriptAst, !!_sfc.scriptSetup, false)
        : undefined);
    const scriptSetupRanges = (0, reactivity_1.computed)(() => _sfc.scriptSetupAst
        ? (0, scriptSetupRanges_1.parseScriptSetupRanges)(ts, _sfc.scriptSetupAst, vueCompilerOptions)
        : undefined);
    const generatedTemplate = (0, reactivity_1.computed)(() => {
        if (!_sfc.templateAst)
            return;
        return (0, template_1.generate)(ts, compilerOptions, vueCompilerOptions, _sfc.template?.content ?? '', _sfc.template?.lang ?? 'html', _sfc, hasScriptSetupSlots.value, slotsAssignName.value, propsAssignName.value, codegenStack);
    });
    //#region remove when https://github.com/vuejs/core/pull/5912 merged
    const hasScriptSetupSlots = (0, reactivity_1.shallowRef)(false);
    const slotsAssignName = (0, reactivity_1.shallowRef)();
    const propsAssignName = (0, reactivity_1.shallowRef)();
    //#endregion
    const generatedScript = (0, reactivity_1.computed)(() => {
        hasScriptSetupSlots.value = !!scriptSetupRanges.value?.slots.define;
        slotsAssignName.value = scriptSetupRanges.value?.slots.name;
        propsAssignName.value = scriptSetupRanges.value?.props.name;
        return (0, script_1.generate)(ts, fileName, _sfc, lang.value, scriptRanges.value, scriptSetupRanges.value, generatedTemplate.value, compilerOptions, vueCompilerOptions, codegenStack);
    });
    return {
        scriptRanges,
        scriptSetupRanges,
        lang,
        generatedScript,
        generatedTemplate,
    };
}
//# sourceMappingURL=vue-tsx.js.map