import { get } from '../utils/object.js';
import { Syntax } from './Enum.js';
const CompositionFunctionValue = {
    data: [
        'ref',
        '$ref',
        'shallowRef',
        '$shallowRef',
    ],
    computed: [
        'computed',
        '$computed',
    ],
    events: [],
    methods: [],
    props: [],
};
const CompositionFunction = {
    data: [
        'reactive',
        'readonly',
        'shallowReactive',
        'shallowReadonly',
        'triggerRef',
        'toRaw',
        'markRaw',
        'unref',
    ],
    computed: [
        'computed',
        '$computed',
    ],
    events: [],
    methods: [],
    props: [],
};
const ToRefComposition = {
    fname: 'toRef',
    feature: 'data',
    parseEntryValue(node, context) {
        if (node.arguments.length > 1) {
            const sourceNode = node.arguments.at(0);
            const keyNode = node.arguments.at(1);
            const path = context.getValue(keyNode);
            if (sourceNode.type === Syntax.Identifier && sourceNode.name in context.scope) {
                const ref = context.scope[sourceNode.name];
                if (!('$ns' in ref)) {
                    const value = get(ref.value.rawObject, path.value);
                    return value;
                }
            }
        }
        return undefined;
    },
};
const DefaultComposition = [
    ...Object.entries(CompositionFunctionValue)
        .map(([feature, fns]) => fns.map((fname) => ({
        fname,
        valueIndex: 0,
        typeParameterIndex: 0,
        identifierSuffixes: ['value'],
        feature,
    }))).flat(),
    ...Object.entries(CompositionFunction)
        .map(([feature, fns]) => fns.map((fname) => ({
        fname,
        valueIndex: 0,
        typeParameterIndex: 0,
        feature,
    }))).flat(),
    {
        fname: 'useAttrs',
        feature: 'data',
        valueIndex: 0,
        typeParameterIndex: 0,
        ignoreVariableIdentifier: true,
    },
    {
        fname: 'useSlots',
        feature: 'data',
        valueIndex: 0,
        typeParameterIndex: 0,
        ignoreVariableIdentifier: true,
    },
    {
        fname: 'defineProps',
        feature: 'props',
        valueIndex: 0,
        typeParameterIndex: 0,
        valueCanBeUndefined: true,
        ignoreVariableIdentifier: false,
    },
    {
        fname: 'defineEmits',
        feature: 'events',
        valueIndex: 0,
        typeParameterIndex: 0,
        valueCanBeUndefined: true,
        ignoreVariableIdentifier: false,
    },
    {
        fname: 'effectScope',
        feature: 'data',
        valueCanBeUndefined: true,
        ignoreVariableIdentifier: true,
    },
    ToRefComposition,
    { ...ToRefComposition, fname: '$toRef' },
];
export class Composition {
    constructor(composition = {}) {
        this.items = [
            ...Composition.parse(composition),
            ...DefaultComposition,
        ];
    }
    static parse(composition) {
        return Object.entries(composition)
            .map(([feature, compositions]) => {
            return compositions.map((composition) => Object.freeze({ ...composition, feature }));
        })
            .flat();
    }
    createAlias(fname, aliasName) {
        const compositions = this.getDeclarations(fname);
        for (const composition of compositions.reverse()) {
            this.items.unshift(Object.freeze({ ...composition, fname: aliasName }));
        }
    }
    unshift(composition) {
        this.items.unshift(...Composition.parse(composition));
    }
    push(composition) {
        this.items.push(...Composition.parse(composition));
    }
    getDeclarations(fname) {
        const foundFeatures = [];
        return this.items
            .filter((item) => {
            if (item.fname === fname && !foundFeatures.includes(item.feature)) {
                foundFeatures.push(item.feature);
                return true;
            }
            return false;
        });
    }
    get(fname, features) {
        return this.items.find((item) => item.fname === fname && features.includes(item.feature));
    }
}
//# sourceMappingURL=Composition.js.map