import { AbstractLiteralParser } from './AbstractLiteralParser.js';
import { NameEntry } from '../entity/NameEntry.js';
import { Type } from '../lib/Enum.js';
export class NameParser extends AbstractLiteralParser {
    parseObjectProperty(node) {
        const ref = this.getValue(node.value);
        const name = ref.type === Type.string ? ref.value : '';
        const entry = new NameEntry(name);
        this.emit(entry);
    }
}
//# sourceMappingURL=NameParser.js.map