/*!
 * ApexCharts v5.3.3
 * (c) 2018-2025 ApexCharts
 */
(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
  typeof define === 'function' && define.amd ? define(factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.ApexCharts = factory());
})(this, (function () { 'use strict';

  function _arrayLikeToArray(r, a) {
    (null == a || a > r.length) && (a = r.length);
    for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e];
    return n;
  }
  function _arrayWithHoles(r) {
    if (Array.isArray(r)) return r;
  }
  function _arrayWithoutHoles(r) {
    if (Array.isArray(r)) return _arrayLikeToArray(r);
  }
  function _assertThisInitialized(e) {
    if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    return e;
  }
  function _classCallCheck(a, n) {
    if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function");
  }
  function _defineProperties(e, r) {
    for (var t = 0; t < r.length; t++) {
      var o = r[t];
      o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o);
    }
  }
  function _createClass(e, r, t) {
    return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", {
      writable: !1
    }), e;
  }
  function _createForOfIteratorHelper(r, e) {
    var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"];
    if (!t) {
      if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) {
        t && (r = t);
        var n = 0,
          F = function () {};
        return {
          s: F,
          n: function () {
            return n >= r.length ? {
              done: !0
            } : {
              done: !1,
              value: r[n++]
            };
          },
          e: function (r) {
            throw r;
          },
          f: F
        };
      }
      throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }
    var o,
      a = !0,
      u = !1;
    return {
      s: function () {
        t = t.call(r);
      },
      n: function () {
        var r = t.next();
        return a = r.done, r;
      },
      e: function (r) {
        u = !0, o = r;
      },
      f: function () {
        try {
          a || null == t.return || t.return();
        } finally {
          if (u) throw o;
        }
      }
    };
  }
  function _createSuper(t) {
    var r = _isNativeReflectConstruct();
    return function () {
      var e,
        o = _getPrototypeOf(t);
      if (r) {
        var s = _getPrototypeOf(this).constructor;
        e = Reflect.construct(o, arguments, s);
      } else e = o.apply(this, arguments);
      return _possibleConstructorReturn(this, e);
    };
  }
  function _defineProperty(e, r, t) {
    return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, {
      value: t,
      enumerable: !0,
      configurable: !0,
      writable: !0
    }) : e[r] = t, e;
  }
  function _getPrototypeOf(t) {
    return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) {
      return t.__proto__ || Object.getPrototypeOf(t);
    }, _getPrototypeOf(t);
  }
  function _inherits(t, e) {
    if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function");
    t.prototype = Object.create(e && e.prototype, {
      constructor: {
        value: t,
        writable: !0,
        configurable: !0
      }
    }), Object.defineProperty(t, "prototype", {
      writable: !1
    }), e && _setPrototypeOf(t, e);
  }
  function _isNativeReflectConstruct() {
    try {
      var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {}));
    } catch (t) {}
    return (_isNativeReflectConstruct = function () {
      return !!t;
    })();
  }
  function _iterableToArray(r) {
    if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r);
  }
  function _iterableToArrayLimit(r, l) {
    var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"];
    if (null != t) {
      var e,
        n,
        i,
        u,
        a = [],
        f = !0,
        o = !1;
      try {
        if (i = (t = t.call(r)).next, 0 === l) {
          if (Object(t) !== t) return;
          f = !1;
        } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0);
      } catch (r) {
        o = !0, n = r;
      } finally {
        try {
          if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return;
        } finally {
          if (o) throw n;
        }
      }
      return a;
    }
  }
  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  function ownKeys(e, r) {
    var t = Object.keys(e);
    if (Object.getOwnPropertySymbols) {
      var o = Object.getOwnPropertySymbols(e);
      r && (o = o.filter(function (r) {
        return Object.getOwnPropertyDescriptor(e, r).enumerable;
      })), t.push.apply(t, o);
    }
    return t;
  }
  function _objectSpread2(e) {
    for (var r = 1; r < arguments.length; r++) {
      var t = null != arguments[r] ? arguments[r] : {};
      r % 2 ? ownKeys(Object(t), !0).forEach(function (r) {
        _defineProperty(e, r, t[r]);
      }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) {
        Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r));
      });
    }
    return e;
  }
  function _possibleConstructorReturn(t, e) {
    if (e && ("object" == typeof e || "function" == typeof e)) return e;
    if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined");
    return _assertThisInitialized(t);
  }
  function _setPrototypeOf(t, e) {
    return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) {
      return t.__proto__ = e, t;
    }, _setPrototypeOf(t, e);
  }
  function _slicedToArray(r, e) {
    return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest();
  }
  function _toConsumableArray(r) {
    return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread();
  }
  function _toPrimitive(t, r) {
    if ("object" != typeof t || !t) return t;
    var e = t[Symbol.toPrimitive];
    if (void 0 !== e) {
      var i = e.call(t, r || "default");
      if ("object" != typeof i) return i;
      throw new TypeError("@@toPrimitive must return a primitive value.");
    }
    return ("string" === r ? String : Number)(t);
  }
  function _toPropertyKey(t) {
    var i = _toPrimitive(t, "string");
    return "symbol" == typeof i ? i : i + "";
  }
  function _typeof(o) {
    "@babel/helpers - typeof";

    return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) {
      return typeof o;
    } : function (o) {
      return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o;
    }, _typeof(o);
  }
  function _unsupportedIterableToArray(r, a) {
    if (r) {
      if ("string" == typeof r) return _arrayLikeToArray(r, a);
      var t = {}.toString.call(r).slice(8, -1);
      return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0;
    }
  }

  /*
   ** Generic functions which are not dependent on ApexCharts
   */
  var Utils$1 = /*#__PURE__*/function () {
    function Utils() {
      _classCallCheck(this, Utils);
    }
    _createClass(Utils, [{
      key: "shadeRGBColor",
      value: function shadeRGBColor(percent, color) {
        var f = color.split(','),
          t = percent < 0 ? 0 : 255,
          p = percent < 0 ? percent * -1 : percent,
          R = parseInt(f[0].slice(4), 10),
          G = parseInt(f[1], 10),
          B = parseInt(f[2], 10);
        return 'rgb(' + (Math.round((t - R) * p) + R) + ',' + (Math.round((t - G) * p) + G) + ',' + (Math.round((t - B) * p) + B) + ')';
      }
    }, {
      key: "shadeHexColor",
      value: function shadeHexColor(percent, color) {
        var f = parseInt(color.slice(1), 16),
          t = percent < 0 ? 0 : 255,
          p = percent < 0 ? percent * -1 : percent,
          R = f >> 16,
          G = f >> 8 & 0x00ff,
          B = f & 0x0000ff;
        return '#' + (0x1000000 + (Math.round((t - R) * p) + R) * 0x10000 + (Math.round((t - G) * p) + G) * 0x100 + (Math.round((t - B) * p) + B)).toString(16).slice(1);
      }

      // beautiful color shading blending code
      // http://stackoverflow.com/questions/5560248/programmatically-lighten-or-darken-a-hex-color-or-rgb-and-blend-colors
    }, {
      key: "shadeColor",
      value: function shadeColor(p, color) {
        if (Utils.isColorHex(color)) {
          return this.shadeHexColor(p, color);
        } else {
          return this.shadeRGBColor(p, color);
        }
      }
    }], [{
      key: "bind",
      value: function bind(fn, me) {
        return function () {
          return fn.apply(me, arguments);
        };
      }
    }, {
      key: "isObject",
      value: function isObject(item) {
        return item && _typeof(item) === 'object' && !Array.isArray(item) && item != null;
      }

      // Type checking that works across different window objects
    }, {
      key: "is",
      value: function is(type, val) {
        return Object.prototype.toString.call(val) === '[object ' + type + ']';
      }
    }, {
      key: "isSafari",
      value: function isSafari() {
        return /^((?!chrome|android).)*safari/i.test(navigator.userAgent);
      }
    }, {
      key: "listToArray",
      value: function listToArray(list) {
        var i,
          array = [];
        for (i = 0; i < list.length; i++) {
          array[i] = list[i];
        }
        return array;
      }

      // to extend defaults with user options
      // credit: http://stackoverflow.com/questions/27936772/deep-object-merging-in-es6-es7#answer-34749873
    }, {
      key: "extend",
      value: function extend(target, source) {
        var _this = this;
        if (typeof Object.assign !== 'function') {
          (function () {
            Object.assign = function (target) {

              // We must check against these specific cases.
              if (target === undefined || target === null) {
                throw new TypeError('Cannot convert undefined or null to object');
              }
              var output = Object(target);
              for (var index = 1; index < arguments.length; index++) {
                var _source = arguments[index];
                if (_source !== undefined && _source !== null) {
                  for (var nextKey in _source) {
                    if (_source.hasOwnProperty(nextKey)) {
                      output[nextKey] = _source[nextKey];
                    }
                  }
                }
              }
              return output;
            };
          })();
        }
        var output = Object.assign({}, target);
        if (this.isObject(target) && this.isObject(source)) {
          Object.keys(source).forEach(function (key) {
            if (_this.isObject(source[key])) {
              if (!(key in target)) {
                Object.assign(output, _defineProperty({}, key, source[key]));
              } else {
                output[key] = _this.extend(target[key], source[key]);
              }
            } else {
              Object.assign(output, _defineProperty({}, key, source[key]));
            }
          });
        }
        return output;
      }
    }, {
      key: "extendArray",
      value: function extendArray(arrToExtend, resultArr) {
        var extendedArr = [];
        arrToExtend.map(function (item) {
          extendedArr.push(Utils.extend(resultArr, item));
        });
        arrToExtend = extendedArr;
        return arrToExtend;
      }

      // If month counter exceeds 12, it starts again from 1
    }, {
      key: "monthMod",
      value: function monthMod(month) {
        return month % 12;
      }
    }, {
      key: "clone",
      value: function clone(source) {
        var visited = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : new WeakMap();
        if (source === null || _typeof(source) !== 'object') {
          return source;
        }
        if (visited.has(source)) {
          return visited.get(source);
        }
        var cloneResult;
        if (Array.isArray(source)) {
          cloneResult = [];
          visited.set(source, cloneResult);
          for (var i = 0; i < source.length; i++) {
            cloneResult[i] = this.clone(source[i], visited);
          }
        } else if (source instanceof Date) {
          cloneResult = new Date(source.getTime());
        } else {
          cloneResult = {};
          visited.set(source, cloneResult);
          for (var prop in source) {
            if (source.hasOwnProperty(prop)) {
              cloneResult[prop] = this.clone(source[prop], visited);
            }
          }
        }
        return cloneResult;
      }
    }, {
      key: "log10",
      value: function log10(x) {
        return Math.log(x) / Math.LN10;
      }
    }, {
      key: "roundToBase10",
      value: function roundToBase10(x) {
        return Math.pow(10, Math.floor(Math.log10(x)));
      }
    }, {
      key: "roundToBase",
      value: function roundToBase(x, base) {
        return Math.pow(base, Math.floor(Math.log(x) / Math.log(base)));
      }
    }, {
      key: "parseNumber",
      value: function parseNumber(val) {
        if (typeof val === 'number' || val === null) return val;
        return parseFloat(val);
      }
    }, {
      key: "stripNumber",
      value: function stripNumber(num) {
        var precision = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 2;
        return Number.isInteger(num) ? num : parseFloat(num.toPrecision(precision));
      }
    }, {
      key: "randomId",
      value: function randomId() {
        return (Math.random() + 1).toString(36).substring(4);
      }
    }, {
      key: "noExponents",
      value: function noExponents(num) {
        // Check if the number contains 'e' (exponential notation)
        if (num.toString().includes('e')) {
          return Math.round(num); // Round the number
        }
        return num; // Return as-is if no exponential notation
      }
    }, {
      key: "elementExists",
      value: function elementExists(element) {
        if (!element || !element.isConnected) {
          return false;
        }
        return true;
      }
    }, {
      key: "getDimensions",
      value: function getDimensions(el) {
        var computedStyle = getComputedStyle(el, null);
        var elementHeight = el.clientHeight;
        var elementWidth = el.clientWidth;
        elementHeight -= parseFloat(computedStyle.paddingTop) + parseFloat(computedStyle.paddingBottom);
        elementWidth -= parseFloat(computedStyle.paddingLeft) + parseFloat(computedStyle.paddingRight);
        return [elementWidth, elementHeight];
      }
    }, {
      key: "getBoundingClientRect",
      value: function getBoundingClientRect(element) {
        var rect = element.getBoundingClientRect();
        return {
          top: rect.top,
          right: rect.right,
          bottom: rect.bottom,
          left: rect.left,
          width: element.clientWidth,
          height: element.clientHeight,
          x: rect.left,
          y: rect.top
        };
      }
    }, {
      key: "getLargestStringFromArr",
      value: function getLargestStringFromArr(arr) {
        return arr.reduce(function (a, b) {
          if (Array.isArray(b)) {
            b = b.reduce(function (aa, bb) {
              return aa.length > bb.length ? aa : bb;
            });
          }
          return a.length > b.length ? a : b;
        }, 0);
      }

      // http://stackoverflow.com/questions/5623838/rgb-to-hex-and-hex-to-rgb#answer-12342275
    }, {
      key: "hexToRgba",
      value: function hexToRgba() {
        var hex = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '#999999';
        var opacity = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0.6;
        if (hex.substring(0, 1) !== '#') {
          hex = '#999999';
        }
        var h = hex.replace('#', '');
        h = h.match(new RegExp('(.{' + h.length / 3 + '})', 'g'));
        for (var i = 0; i < h.length; i++) {
          h[i] = parseInt(h[i].length === 1 ? h[i] + h[i] : h[i], 16);
        }
        if (typeof opacity !== 'undefined') h.push(opacity);
        return 'rgba(' + h.join(',') + ')';
      }
    }, {
      key: "getOpacityFromRGBA",
      value: function getOpacityFromRGBA(rgba) {
        return parseFloat(rgba.replace(/^.*,(.+)\)/, '$1'));
      }
    }, {
      key: "rgb2hex",
      value: function rgb2hex(rgb) {
        rgb = rgb.match(/^rgba?[\s+]?\([\s+]?(\d+)[\s+]?,[\s+]?(\d+)[\s+]?,[\s+]?(\d+)[\s+]?/i);
        return rgb && rgb.length === 4 ? '#' + ('0' + parseInt(rgb[1], 10).toString(16)).slice(-2) + ('0' + parseInt(rgb[2], 10).toString(16)).slice(-2) + ('0' + parseInt(rgb[3], 10).toString(16)).slice(-2) : '';
      }
    }, {
      key: "isColorHex",
      value: function isColorHex(color) {
        return /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)|(^#[0-9A-F]{8}$)/i.test(color);
      }
    }, {
      key: "getPolygonPos",
      value: function getPolygonPos(size, dataPointsLen) {
        var dotsArray = [];
        var angle = Math.PI * 2 / dataPointsLen;
        for (var i = 0; i < dataPointsLen; i++) {
          var curPos = {};
          curPos.x = size * Math.sin(i * angle);
          curPos.y = -size * Math.cos(i * angle);
          dotsArray.push(curPos);
        }
        return dotsArray;
      }
    }, {
      key: "polarToCartesian",
      value: function polarToCartesian(centerX, centerY, radius, angleInDegrees) {
        var angleInRadians = (angleInDegrees - 90) * Math.PI / 180.0;
        return {
          x: centerX + radius * Math.cos(angleInRadians),
          y: centerY + radius * Math.sin(angleInRadians)
        };
      }
    }, {
      key: "escapeString",
      value: function escapeString(str) {
        var escapeWith = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'x';
        var newStr = str.toString().slice();
        newStr = newStr.replace(/[` ~!@#$%^&*()|+\=?;:'",.<>{}[\]\\/]/gi, escapeWith);
        return newStr;
      }
    }, {
      key: "negToZero",
      value: function negToZero(val) {
        return val < 0 ? 0 : val;
      }
    }, {
      key: "moveIndexInArray",
      value: function moveIndexInArray(arr, old_index, new_index) {
        if (new_index >= arr.length) {
          var k = new_index - arr.length + 1;
          while (k--) {
            arr.push(undefined);
          }
        }
        arr.splice(new_index, 0, arr.splice(old_index, 1)[0]);
        return arr;
      }
    }, {
      key: "extractNumber",
      value: function extractNumber(s) {
        return parseFloat(s.replace(/[^\d.]*/g, ''));
      }
    }, {
      key: "findAncestor",
      value: function findAncestor(el, cls) {
        while ((el = el.parentElement) && !el.classList.contains(cls)) {
        }
        return el;
      }
    }, {
      key: "setELstyles",
      value: function setELstyles(el, styles) {
        for (var key in styles) {
          if (styles.hasOwnProperty(key)) {
            el.style.key = styles[key];
          }
        }
      }
      // prevents JS prevision errors when adding
    }, {
      key: "preciseAddition",
      value: function preciseAddition(a, b) {
        var aDecimals = (String(a).split('.')[1] || '').length;
        var bDecimals = (String(b).split('.')[1] || '').length;
        var factor = Math.pow(10, Math.max(aDecimals, bDecimals));
        return (Math.round(a * factor) + Math.round(b * factor)) / factor;
      }
    }, {
      key: "isNumber",
      value: function isNumber(value) {
        return !isNaN(value) && parseFloat(Number(value)) === value && !isNaN(parseInt(value, 10));
      }
    }, {
      key: "isFloat",
      value: function isFloat(n) {
        return Number(n) === n && n % 1 !== 0;
      }
    }, {
      key: "isMsEdge",
      value: function isMsEdge() {
        var ua = window.navigator.userAgent;
        var edge = ua.indexOf('Edge/');
        if (edge > 0) {
          // Edge (IE 12+) => return version number
          return parseInt(ua.substring(edge + 5, ua.indexOf('.', edge)), 10);
        }

        // other browser
        return false;
      }
      //
      // Find the Greatest Common Divisor of two numbers
      //
    }, {
      key: "getGCD",
      value: function getGCD(a, b) {
        var p = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 7;
        var big = Math.pow(10, p - Math.floor(Math.log10(Math.max(a, b))));
        a = Math.round(Math.abs(a) * big);
        b = Math.round(Math.abs(b) * big);
        while (b) {
          var t = b;
          b = a % b;
          a = t;
        }
        return a / big;
      }
    }, {
      key: "getPrimeFactors",
      value: function getPrimeFactors(n) {
        var factors = [];
        var divisor = 2;
        while (n >= 2) {
          if (n % divisor == 0) {
            factors.push(divisor);
            n = n / divisor;
          } else {
            divisor++;
          }
        }
        return factors;
      }
    }, {
      key: "mod",
      value: function mod(a, b) {
        var p = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 7;
        var big = Math.pow(10, p - Math.floor(Math.log10(Math.max(a, b))));
        a = Math.round(Math.abs(a) * big);
        b = Math.round(Math.abs(b) * big);
        return a % b / big;
      }
    }]);
    return Utils;
  }();

  /**
   * ApexCharts Animation Class.
   *
   * @module Animations
   **/
  var Animations = /*#__PURE__*/function () {
    function Animations(ctx) {
      _classCallCheck(this, Animations);
      this.ctx = ctx;
      this.w = ctx.w;
    }
    _createClass(Animations, [{
      key: "animateLine",
      value: function animateLine(el, from, to, speed) {
        el.attr(from).animate(speed).attr(to);
      }

      /*
       ** Animate radius of a circle element
       */
    }, {
      key: "animateMarker",
      value: function animateMarker(el, speed, easing, cb) {
        el.attr({
          opacity: 0
        }).animate(speed).attr({
          opacity: 1
        }).after(function () {
          cb();
        });
      }

      /*
       ** Animate rect properties
       */
    }, {
      key: "animateRect",
      value: function animateRect(el, from, to, speed, fn) {
        el.attr(from).animate(speed).attr(to).after(function () {
          return fn();
        });
      }
    }, {
      key: "animatePathsGradually",
      value: function animatePathsGradually(params) {
        var el = params.el,
          realIndex = params.realIndex,
          j = params.j,
          fill = params.fill,
          pathFrom = params.pathFrom,
          pathTo = params.pathTo,
          speed = params.speed,
          delay = params.delay;
        var me = this;
        var w = this.w;
        var delayFactor = 0;
        if (w.config.chart.animations.animateGradually.enabled) {
          delayFactor = w.config.chart.animations.animateGradually.delay;
        }
        if (w.config.chart.animations.dynamicAnimation.enabled && w.globals.dataChanged && w.config.chart.type !== 'bar') {
          // disabled due to this bug - https://github.com/apexcharts/vue-apexcharts/issues/75
          delayFactor = 0;
        }
        me.morphSVG(el, realIndex, j, w.config.chart.type === 'line' && !w.globals.comboCharts ? 'stroke' : fill, pathFrom, pathTo, speed, delay * delayFactor);
      }
    }, {
      key: "showDelayedElements",
      value: function showDelayedElements() {
        this.w.globals.delayedElements.forEach(function (d) {
          var ele = d.el;
          ele.classList.remove('apexcharts-element-hidden');
          ele.classList.add('apexcharts-hidden-element-shown');
        });
      }
    }, {
      key: "animationCompleted",
      value: function animationCompleted(el) {
        var w = this.w;
        if (w.globals.animationEnded) return;
        w.globals.animationEnded = true;
        this.showDelayedElements();
        if (typeof w.config.chart.events.animationEnd === 'function') {
          w.config.chart.events.animationEnd(this.ctx, {
            el: el,
            w: w
          });
        }
      }

      // SVG.js animation for morphing one path to another
    }, {
      key: "morphSVG",
      value: function morphSVG(el, realIndex, j, fill, pathFrom, pathTo, speed, delay) {
        var _this = this;
        var w = this.w;
        if (!pathFrom) {
          pathFrom = el.attr('pathFrom');
        }
        if (!pathTo) {
          pathTo = el.attr('pathTo');
        }
        var disableAnimationForCorrupPath = function disableAnimationForCorrupPath(path) {
          if (w.config.chart.type === 'radar') {
            // radar chart drops the path to bottom and hence a corrup path looks ugly
            // therefore, disable animation for such a case
            speed = 1;
          }
          return "M 0 ".concat(w.globals.gridHeight);
        };
        if (!pathFrom || pathFrom.indexOf('undefined') > -1 || pathFrom.indexOf('NaN') > -1) {
          pathFrom = disableAnimationForCorrupPath();
        }
        if (!pathTo.trim() || pathTo.indexOf('undefined') > -1 || pathTo.indexOf('NaN') > -1) {
          pathTo = disableAnimationForCorrupPath();
        }
        if (!w.globals.shouldAnimate) {
          speed = 1;
        }
        el.plot(pathFrom).animate(1, delay).plot(pathFrom).animate(speed, delay).plot(pathTo).after(function () {
          // a flag to indicate that the original mount function can return true now as animation finished here
          if (Utils$1.isNumber(j)) {
            if (j === w.globals.series[w.globals.maxValsInArrayIndex].length - 2 && w.globals.shouldAnimate) {
              _this.animationCompleted(el);
            }
          } else if (fill !== 'none' && w.globals.shouldAnimate) {
            if (!w.globals.comboCharts && realIndex === w.globals.series.length - 1 || w.globals.comboCharts) {
              _this.animationCompleted(el);
            }
          }
          _this.showDelayedElements();
        });
      }
    }]);
    return Animations;
  }();

  const methods$1 = {};
  const names = [];

  function registerMethods(name, m) {
    if (Array.isArray(name)) {
      for (const _name of name) {
        registerMethods(_name, m);
      }
      return
    }

    if (typeof name === 'object') {
      for (const _name in name) {
        registerMethods(_name, name[_name]);
      }
      return
    }

    addMethodNames(Object.getOwnPropertyNames(m));
    methods$1[name] = Object.assign(methods$1[name] || {}, m);
  }

  function getMethodsFor(name) {
    return methods$1[name] || {}
  }

  function getMethodNames() {
    return [...new Set(names)]
  }

  function addMethodNames(_names) {
    names.push(..._names);
  }

  // Map function
  function map(array, block) {
    let i;
    const il = array.length;
    const result = [];

    for (i = 0; i < il; i++) {
      result.push(block(array[i]));
    }

    return result
  }

  // Filter function
  function filter(array, block) {
    let i;
    const il = array.length;
    const result = [];

    for (i = 0; i < il; i++) {
      if (block(array[i])) {
        result.push(array[i]);
      }
    }

    return result
  }

  // Degrees to radians
  function radians(d) {
    return ((d % 360) * Math.PI) / 180
  }

  // Convert camel cased string to dash separated
  function unCamelCase(s) {
    return s.replace(/([A-Z])/g, function (m, g) {
      return '-' + g.toLowerCase()
    })
  }

  // Capitalize first letter of a string
  function capitalize(s) {
    return s.charAt(0).toUpperCase() + s.slice(1)
  }

  // Calculate proportional width and height values when necessary
  function proportionalSize(element, width, height, box) {
    if (width == null || height == null) {
      box = box || element.bbox();

      if (width == null) {
        width = (box.width / box.height) * height;
      } else if (height == null) {
        height = (box.height / box.width) * width;
      }
    }

    return {
      width: width,
      height: height
    }
  }

  /**
   * This function adds support for string origins.
   * It searches for an origin in o.origin o.ox and o.originX.
   * This way, origin: {x: 'center', y: 50} can be passed as well as ox: 'center', oy: 50
   **/
  function getOrigin(o, element) {
    const origin = o.origin;
    // First check if origin is in ox or originX
    let ox = o.ox != null ? o.ox : o.originX != null ? o.originX : 'center';
    let oy = o.oy != null ? o.oy : o.originY != null ? o.originY : 'center';

    // Then check if origin was used and overwrite in that case
    if (origin != null) {
  [ox, oy] = Array.isArray(origin)
        ? origin
        : typeof origin === 'object'
          ? [origin.x, origin.y]
          : [origin, origin];
    }

    // Make sure to only call bbox when actually needed
    const condX = typeof ox === 'string';
    const condY = typeof oy === 'string';
    if (condX || condY) {
      const { height, width, x, y } = element.bbox();

      // And only overwrite if string was passed for this specific axis
      if (condX) {
        ox = ox.includes('left')
          ? x
          : ox.includes('right')
            ? x + width
            : x + width / 2;
      }

      if (condY) {
        oy = oy.includes('top')
          ? y
          : oy.includes('bottom')
            ? y + height
            : y + height / 2;
      }
    }

    // Return the origin as it is if it wasn't a string
    return [ox, oy]
  }

  const descriptiveElements = new Set(['desc', 'metadata', 'title']);
  const isDescriptive = (element) =>
    descriptiveElements.has(element.nodeName);

  const writeDataToDom = (element, data, defaults = {}) => {
    const cloned = { ...data };

    for (const key in cloned) {
      if (cloned[key].valueOf() === defaults[key]) {
        delete cloned[key];
      }
    }

    if (Object.keys(cloned).length) {
      element.node.setAttribute('data-svgjs', JSON.stringify(cloned)); // see #428
    } else {
      element.node.removeAttribute('data-svgjs');
      element.node.removeAttribute('svgjs:data');
    }
  };

  // Default namespaces
  const svg = 'http://www.w3.org/2000/svg';
  const html = 'http://www.w3.org/1999/xhtml';
  const xmlns = 'http://www.w3.org/2000/xmlns/';
  const xlink = 'http://www.w3.org/1999/xlink';

  const globals = {
    window: typeof window === 'undefined' ? null : window,
    document: typeof document === 'undefined' ? null : document
  };

  function getWindow() {
    return globals.window
  }

  let Base$1 = class Base {
    // constructor (node/*, {extensions = []} */) {
    //   // this.tags = []
    //   //
    //   // for (let extension of extensions) {
    //   //   extension.setup.call(this, node)
    //   //   this.tags.push(extension.name)
    //   // }
    // }
  };

  const elements = {};
  const root = '___SYMBOL___ROOT___';

  // Method for element creation
  function create(name, ns = svg) {
    // create element
    return globals.document.createElementNS(ns, name)
  }

  function makeInstance(element, isHTML = false) {
    if (element instanceof Base$1) return element

    if (typeof element === 'object') {
      return adopter(element)
    }

    if (element == null) {
      return new elements[root]()
    }

    if (typeof element === 'string' && element.charAt(0) !== '<') {
      return adopter(globals.document.querySelector(element))
    }

    // Make sure, that HTML elements are created with the correct namespace
    const wrapper = isHTML ? globals.document.createElement('div') : create('svg');
    wrapper.innerHTML = element;

    // We can use firstChild here because we know,
    // that the first char is < and thus an element
    element = adopter(wrapper.firstChild);

    // make sure, that element doesn't have its wrapper attached
    wrapper.removeChild(wrapper.firstChild);
    return element
  }

  function nodeOrNew(name, node) {
    return node &&
      (node instanceof globals.window.Node ||
        (node.ownerDocument &&
          node instanceof node.ownerDocument.defaultView.Node))
      ? node
      : create(name)
  }

  // Adopt existing svg elements
  function adopt(node) {
    // check for presence of node
    if (!node) return null

    // make sure a node isn't already adopted
    if (node.instance instanceof Base$1) return node.instance

    if (node.nodeName === '#document-fragment') {
      return new elements.Fragment(node)
    }

    // initialize variables
    let className = capitalize(node.nodeName || 'Dom');

    // Make sure that gradients are adopted correctly
    if (className === 'LinearGradient' || className === 'RadialGradient') {
      className = 'Gradient';

      // Fallback to Dom if element is not known
    } else if (!elements[className]) {
      className = 'Dom';
    }

    return new elements[className](node)
  }

  let adopter = adopt;

  function register(element, name = element.name, asRoot = false) {
    elements[name] = element;
    if (asRoot) elements[root] = element;

    addMethodNames(Object.getOwnPropertyNames(element.prototype));

    return element
  }

  function getClass(name) {
    return elements[name]
  }

  // Element id sequence
  let did = 1000;

  // Get next named element id
  function eid(name) {
    return 'Svgjs' + capitalize(name) + did++
  }

  // Deep new id assignment
  function assignNewId(node) {
    // do the same for SVG child nodes as well
    for (let i = node.children.length - 1; i >= 0; i--) {
      assignNewId(node.children[i]);
    }

    if (node.id) {
      node.id = eid(node.nodeName);
      return node
    }

    return node
  }

  // Method for extending objects
  function extend(modules, methods) {
    let key, i;

    modules = Array.isArray(modules) ? modules : [modules];

    for (i = modules.length - 1; i >= 0; i--) {
      for (key in methods) {
        modules[i].prototype[key] = methods[key];
      }
    }
  }

  function wrapWithAttrCheck(fn) {
    return function (...args) {
      const o = args[args.length - 1];

      if (o && o.constructor === Object && !(o instanceof Array)) {
        return fn.apply(this, args.slice(0, -1)).attr(o)
      } else {
        return fn.apply(this, args)
      }
    }
  }

  // Get all siblings, including myself
  function siblings() {
    return this.parent().children()
  }

  // Get the current position siblings
  function position() {
    return this.parent().index(this)
  }

  // Get the next element (will return null if there is none)
  function next() {
    return this.siblings()[this.position() + 1]
  }

  // Get the next element (will return null if there is none)
  function prev() {
    return this.siblings()[this.position() - 1]
  }

  // Send given element one step forward
  function forward() {
    const i = this.position();
    const p = this.parent();

    // move node one step forward
    p.add(this.remove(), i + 1);

    return this
  }

  // Send given element one step backward
  function backward() {
    const i = this.position();
    const p = this.parent();

    p.add(this.remove(), i ? i - 1 : 0);

    return this
  }

  // Send given element all the way to the front
  function front() {
    const p = this.parent();

    // Move node forward
    p.add(this.remove());

    return this
  }

  // Send given element all the way to the back
  function back() {
    const p = this.parent();

    // Move node back
    p.add(this.remove(), 0);

    return this
  }

  // Inserts a given element before the targeted element
  function before(element) {
    element = makeInstance(element);
    element.remove();

    const i = this.position();

    this.parent().add(element, i);

    return this
  }

  // Inserts a given element after the targeted element
  function after(element) {
    element = makeInstance(element);
    element.remove();

    const i = this.position();

    this.parent().add(element, i + 1);

    return this
  }

  function insertBefore(element) {
    element = makeInstance(element);
    element.before(this);
    return this
  }

  function insertAfter(element) {
    element = makeInstance(element);
    element.after(this);
    return this
  }

  registerMethods('Dom', {
    siblings,
    position,
    next,
    prev,
    forward,
    backward,
    front,
    back,
    before,
    after,
    insertBefore,
    insertAfter
  });

  // Parse unit value
  const numberAndUnit =
    /^([+-]?(\d+(\.\d*)?|\.\d+)(e[+-]?\d+)?)([a-z%]*)$/i;

  // Parse hex value
  const hex = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i;

  // Parse rgb value
  const rgb = /rgb\((\d+),(\d+),(\d+)\)/;

  // Parse reference id
  const reference = /(#[a-z_][a-z0-9\-_]*)/i;

  // splits a transformation chain
  const transforms = /\)\s*,?\s*/;

  // Whitespace
  const whitespace = /\s/g;

  // Test hex value
  const isHex = /^#[a-f0-9]{3}$|^#[a-f0-9]{6}$/i;

  // Test rgb value
  const isRgb = /^rgb\(/;

  // Test for blank string
  const isBlank = /^(\s+)?$/;

  // Test for numeric string
  const isNumber = /^[+-]?(\d+(\.\d*)?|\.\d+)(e[+-]?\d+)?$/i;

  // Test for image url
  const isImage = /\.(jpg|jpeg|png|gif|svg)(\?[^=]+.*)?/i;

  // split at whitespace and comma
  const delimiter = /[\s,]+/;

  // Test for path letter
  const isPathLetter = /[MLHVCSQTAZ]/i;

  // Return array of classes on the node
  function classes() {
    const attr = this.attr('class');
    return attr == null ? [] : attr.trim().split(delimiter)
  }

  // Return true if class exists on the node, false otherwise
  function hasClass(name) {
    return this.classes().indexOf(name) !== -1
  }

  // Add class to the node
  function addClass(name) {
    if (!this.hasClass(name)) {
      const array = this.classes();
      array.push(name);
      this.attr('class', array.join(' '));
    }

    return this
  }

  // Remove class from the node
  function removeClass(name) {
    if (this.hasClass(name)) {
      this.attr(
        'class',
        this.classes()
          .filter(function (c) {
            return c !== name
          })
          .join(' ')
      );
    }

    return this
  }

  // Toggle the presence of a class on the node
  function toggleClass(name) {
    return this.hasClass(name) ? this.removeClass(name) : this.addClass(name)
  }

  registerMethods('Dom', {
    classes,
    hasClass,
    addClass,
    removeClass,
    toggleClass
  });

  // Dynamic style generator
  function css(style, val) {
    const ret = {};
    if (arguments.length === 0) {
      // get full style as object
      this.node.style.cssText
        .split(/\s*;\s*/)
        .filter(function (el) {
          return !!el.length
        })
        .forEach(function (el) {
          const t = el.split(/\s*:\s*/);
          ret[t[0]] = t[1];
        });
      return ret
    }

    if (arguments.length < 2) {
      // get style properties as array
      if (Array.isArray(style)) {
        for (const name of style) {
          const cased = name;
          ret[name] = this.node.style.getPropertyValue(cased);
        }
        return ret
      }

      // get style for property
      if (typeof style === 'string') {
        return this.node.style.getPropertyValue(style)
      }

      // set styles in object
      if (typeof style === 'object') {
        for (const name in style) {
          // set empty string if null/undefined/'' was given
          this.node.style.setProperty(
            name,
            style[name] == null || isBlank.test(style[name]) ? '' : style[name]
          );
        }
      }
    }

    // set style for property
    if (arguments.length === 2) {
      this.node.style.setProperty(
        style,
        val == null || isBlank.test(val) ? '' : val
      );
    }

    return this
  }

  // Show element
  function show() {
    return this.css('display', '')
  }

  // Hide element
  function hide() {
    return this.css('display', 'none')
  }

  // Is element visible?
  function visible() {
    return this.css('display') !== 'none'
  }

  registerMethods('Dom', {
    css,
    show,
    hide,
    visible
  });

  // Store data values on svg nodes
  function data(a, v, r) {
    if (a == null) {
      // get an object of attributes
      return this.data(
        map(
          filter(
            this.node.attributes,
            (el) => el.nodeName.indexOf('data-') === 0
          ),
          (el) => el.nodeName.slice(5)
        )
      )
    } else if (a instanceof Array) {
      const data = {};
      for (const key of a) {
        data[key] = this.data(key);
      }
      return data
    } else if (typeof a === 'object') {
      for (v in a) {
        this.data(v, a[v]);
      }
    } else if (arguments.length < 2) {
      try {
        return JSON.parse(this.attr('data-' + a))
      } catch (e) {
        return this.attr('data-' + a)
      }
    } else {
      this.attr(
        'data-' + a,
        v === null
          ? null
          : r === true || typeof v === 'string' || typeof v === 'number'
            ? v
            : JSON.stringify(v)
      );
    }

    return this
  }

  registerMethods('Dom', { data });

  // Remember arbitrary data
  function remember(k, v) {
    // remember every item in an object individually
    if (typeof arguments[0] === 'object') {
      for (const key in k) {
        this.remember(key, k[key]);
      }
    } else if (arguments.length === 1) {
      // retrieve memory
      return this.memory()[k]
    } else {
      // store memory
      this.memory()[k] = v;
    }

    return this
  }

  // Erase a given memory
  function forget() {
    if (arguments.length === 0) {
      this._memory = {};
    } else {
      for (let i = arguments.length - 1; i >= 0; i--) {
        delete this.memory()[arguments[i]];
      }
    }
    return this
  }

  // This triggers creation of a new hidden class which is not performant
  // However, this function is not rarely used so it will not happen frequently
  // Return local memory object
  function memory() {
    return (this._memory = this._memory || {})
  }

  registerMethods('Dom', { remember, forget, memory });

  function sixDigitHex(hex) {
    return hex.length === 4
      ? [
          '#',
          hex.substring(1, 2),
          hex.substring(1, 2),
          hex.substring(2, 3),
          hex.substring(2, 3),
          hex.substring(3, 4),
          hex.substring(3, 4)
        ].join('')
      : hex
  }

  function componentHex(component) {
    const integer = Math.round(component);
    const bounded = Math.max(0, Math.min(255, integer));
    const hex = bounded.toString(16);
    return hex.length === 1 ? '0' + hex : hex
  }

  function is(object, space) {
    for (let i = space.length; i--; ) {
      if (object[space[i]] == null) {
        return false
      }
    }
    return true
  }

  function getParameters(a, b) {
    const params = is(a, 'rgb')
      ? { _a: a.r, _b: a.g, _c: a.b, _d: 0, space: 'rgb' }
      : is(a, 'xyz')
        ? { _a: a.x, _b: a.y, _c: a.z, _d: 0, space: 'xyz' }
        : is(a, 'hsl')
          ? { _a: a.h, _b: a.s, _c: a.l, _d: 0, space: 'hsl' }
          : is(a, 'lab')
            ? { _a: a.l, _b: a.a, _c: a.b, _d: 0, space: 'lab' }
            : is(a, 'lch')
              ? { _a: a.l, _b: a.c, _c: a.h, _d: 0, space: 'lch' }
              : is(a, 'cmyk')
                ? { _a: a.c, _b: a.m, _c: a.y, _d: a.k, space: 'cmyk' }
                : { _a: 0, _b: 0, _c: 0, space: 'rgb' };

    params.space = b || params.space;
    return params
  }

  function cieSpace(space) {
    if (space === 'lab' || space === 'xyz' || space === 'lch') {
      return true
    } else {
      return false
    }
  }

  function hueToRgb(p, q, t) {
    if (t < 0) t += 1;
    if (t > 1) t -= 1;
    if (t < 1 / 6) return p + (q - p) * 6 * t
    if (t < 1 / 2) return q
    if (t < 2 / 3) return p + (q - p) * (2 / 3 - t) * 6
    return p
  }

  class Color {
    constructor(...inputs) {
      this.init(...inputs);
    }

    // Test if given value is a color
    static isColor(color) {
      return (
        color && (color instanceof Color || this.isRgb(color) || this.test(color))
      )
    }

    // Test if given value is an rgb object
    static isRgb(color) {
      return (
        color &&
        typeof color.r === 'number' &&
        typeof color.g === 'number' &&
        typeof color.b === 'number'
      )
    }

    /*
    Generating random colors
    */
    static random(mode = 'vibrant', t) {
      // Get the math modules
      const { random, round, sin, PI: pi } = Math;

      // Run the correct generator
      if (mode === 'vibrant') {
        const l = (81 - 57) * random() + 57;
        const c = (83 - 45) * random() + 45;
        const h = 360 * random();
        const color = new Color(l, c, h, 'lch');
        return color
      } else if (mode === 'sine') {
        t = t == null ? random() : t;
        const r = round(80 * sin((2 * pi * t) / 0.5 + 0.01) + 150);
        const g = round(50 * sin((2 * pi * t) / 0.5 + 4.6) + 200);
        const b = round(100 * sin((2 * pi * t) / 0.5 + 2.3) + 150);
        const color = new Color(r, g, b);
        return color
      } else if (mode === 'pastel') {
        const l = (94 - 86) * random() + 86;
        const c = (26 - 9) * random() + 9;
        const h = 360 * random();
        const color = new Color(l, c, h, 'lch');
        return color
      } else if (mode === 'dark') {
        const l = 10 + 10 * random();
        const c = (125 - 75) * random() + 86;
        const h = 360 * random();
        const color = new Color(l, c, h, 'lch');
        return color
      } else if (mode === 'rgb') {
        const r = 255 * random();
        const g = 255 * random();
        const b = 255 * random();
        const color = new Color(r, g, b);
        return color
      } else if (mode === 'lab') {
        const l = 100 * random();
        const a = 256 * random() - 128;
        const b = 256 * random() - 128;
        const color = new Color(l, a, b, 'lab');
        return color
      } else if (mode === 'grey') {
        const grey = 255 * random();
        const color = new Color(grey, grey, grey);
        return color
      } else {
        throw new Error('Unsupported random color mode')
      }
    }

    // Test if given value is a color string
    static test(color) {
      return typeof color === 'string' && (isHex.test(color) || isRgb.test(color))
    }

    cmyk() {
      // Get the rgb values for the current color
      const { _a, _b, _c } = this.rgb();
      const [r, g, b] = [_a, _b, _c].map((v) => v / 255);

      // Get the cmyk values in an unbounded format
      const k = Math.min(1 - r, 1 - g, 1 - b);

      if (k === 1) {
        // Catch the black case
        return new Color(0, 0, 0, 1, 'cmyk')
      }

      const c = (1 - r - k) / (1 - k);
      const m = (1 - g - k) / (1 - k);
      const y = (1 - b - k) / (1 - k);

      // Construct the new color
      const color = new Color(c, m, y, k, 'cmyk');
      return color
    }

    hsl() {
      // Get the rgb values
      const { _a, _b, _c } = this.rgb();
      const [r, g, b] = [_a, _b, _c].map((v) => v / 255);

      // Find the maximum and minimum values to get the lightness
      const max = Math.max(r, g, b);
      const min = Math.min(r, g, b);
      const l = (max + min) / 2;

      // If the r, g, v values are identical then we are grey
      const isGrey = max === min;

      // Calculate the hue and saturation
      const delta = max - min;
      const s = isGrey
        ? 0
        : l > 0.5
          ? delta / (2 - max - min)
          : delta / (max + min);
      const h = isGrey
        ? 0
        : max === r
          ? ((g - b) / delta + (g < b ? 6 : 0)) / 6
          : max === g
            ? ((b - r) / delta + 2) / 6
            : max === b
              ? ((r - g) / delta + 4) / 6
              : 0;

      // Construct and return the new color
      const color = new Color(360 * h, 100 * s, 100 * l, 'hsl');
      return color
    }

    init(a = 0, b = 0, c = 0, d = 0, space = 'rgb') {
      // This catches the case when a falsy value is passed like ''
      a = !a ? 0 : a;

      // Reset all values in case the init function is rerun with new color space
      if (this.space) {
        for (const component in this.space) {
          delete this[this.space[component]];
        }
      }

      if (typeof a === 'number') {
        // Allow for the case that we don't need d...
        space = typeof d === 'string' ? d : space;
        d = typeof d === 'string' ? 0 : d;

        // Assign the values straight to the color
        Object.assign(this, { _a: a, _b: b, _c: c, _d: d, space });
        // If the user gave us an array, make the color from it
      } else if (a instanceof Array) {
        this.space = b || (typeof a[3] === 'string' ? a[3] : a[4]) || 'rgb';
        Object.assign(this, { _a: a[0], _b: a[1], _c: a[2], _d: a[3] || 0 });
      } else if (a instanceof Object) {
        // Set the object up and assign its values directly
        const values = getParameters(a, b);
        Object.assign(this, values);
      } else if (typeof a === 'string') {
        if (isRgb.test(a)) {
          const noWhitespace = a.replace(whitespace, '');
          const [_a, _b, _c] = rgb
            .exec(noWhitespace)
            .slice(1, 4)
            .map((v) => parseInt(v));
          Object.assign(this, { _a, _b, _c, _d: 0, space: 'rgb' });
        } else if (isHex.test(a)) {
          const hexParse = (v) => parseInt(v, 16);
          const [, _a, _b, _c] = hex.exec(sixDigitHex(a)).map(hexParse);
          Object.assign(this, { _a, _b, _c, _d: 0, space: 'rgb' });
        } else throw Error("Unsupported string format, can't construct Color")
      }

      // Now add the components as a convenience
      const { _a, _b, _c, _d } = this;
      const components =
        this.space === 'rgb'
          ? { r: _a, g: _b, b: _c }
          : this.space === 'xyz'
            ? { x: _a, y: _b, z: _c }
            : this.space === 'hsl'
              ? { h: _a, s: _b, l: _c }
              : this.space === 'lab'
                ? { l: _a, a: _b, b: _c }
                : this.space === 'lch'
                  ? { l: _a, c: _b, h: _c }
                  : this.space === 'cmyk'
                    ? { c: _a, m: _b, y: _c, k: _d }
                    : {};
      Object.assign(this, components);
    }

    lab() {
      // Get the xyz color
      const { x, y, z } = this.xyz();

      // Get the lab components
      const l = 116 * y - 16;
      const a = 500 * (x - y);
      const b = 200 * (y - z);

      // Construct and return a new color
      const color = new Color(l, a, b, 'lab');
      return color
    }

    lch() {
      // Get the lab color directly
      const { l, a, b } = this.lab();

      // Get the chromaticity and the hue using polar coordinates
      const c = Math.sqrt(a ** 2 + b ** 2);
      let h = (180 * Math.atan2(b, a)) / Math.PI;
      if (h < 0) {
        h *= -1;
        h = 360 - h;
      }

      // Make a new color and return it
      const color = new Color(l, c, h, 'lch');
      return color
    }
    /*
    Conversion Methods
    */

    rgb() {
      if (this.space === 'rgb') {
        return this
      } else if (cieSpace(this.space)) {
        // Convert to the xyz color space
        let { x, y, z } = this;
        if (this.space === 'lab' || this.space === 'lch') {
          // Get the values in the lab space
          let { l, a, b } = this;
          if (this.space === 'lch') {
            const { c, h } = this;
            const dToR = Math.PI / 180;
            a = c * Math.cos(dToR * h);
            b = c * Math.sin(dToR * h);
          }

          // Undo the nonlinear function
          const yL = (l + 16) / 116;
          const xL = a / 500 + yL;
          const zL = yL - b / 200;

          // Get the xyz values
          const ct = 16 / 116;
          const mx = 0.008856;
          const nm = 7.787;
          x = 0.95047 * (xL ** 3 > mx ? xL ** 3 : (xL - ct) / nm);
          y = 1.0 * (yL ** 3 > mx ? yL ** 3 : (yL - ct) / nm);
          z = 1.08883 * (zL ** 3 > mx ? zL ** 3 : (zL - ct) / nm);
        }

        // Convert xyz to unbounded rgb values
        const rU = x * 3.2406 + y * -1.5372 + z * -0.4986;
        const gU = x * -0.9689 + y * 1.8758 + z * 0.0415;
        const bU = x * 0.0557 + y * -0.204 + z * 1.057;

        // Convert the values to true rgb values
        const pow = Math.pow;
        const bd = 0.0031308;
        const r = rU > bd ? 1.055 * pow(rU, 1 / 2.4) - 0.055 : 12.92 * rU;
        const g = gU > bd ? 1.055 * pow(gU, 1 / 2.4) - 0.055 : 12.92 * gU;
        const b = bU > bd ? 1.055 * pow(bU, 1 / 2.4) - 0.055 : 12.92 * bU;

        // Make and return the color
        const color = new Color(255 * r, 255 * g, 255 * b);
        return color
      } else if (this.space === 'hsl') {
        // https://bgrins.github.io/TinyColor/docs/tinycolor.html
        // Get the current hsl values
        let { h, s, l } = this;
        h /= 360;
        s /= 100;
        l /= 100;

        // If we are grey, then just make the color directly
        if (s === 0) {
          l *= 255;
          const color = new Color(l, l, l);
          return color
        }

        // TODO I have no idea what this does :D If you figure it out, tell me!
        const q = l < 0.5 ? l * (1 + s) : l + s - l * s;
        const p = 2 * l - q;

        // Get the rgb values
        const r = 255 * hueToRgb(p, q, h + 1 / 3);
        const g = 255 * hueToRgb(p, q, h);
        const b = 255 * hueToRgb(p, q, h - 1 / 3);

        // Make a new color
        const color = new Color(r, g, b);
        return color
      } else if (this.space === 'cmyk') {
        // https://gist.github.com/felipesabino/5066336
        // Get the normalised cmyk values
        const { c, m, y, k } = this;

        // Get the rgb values
        const r = 255 * (1 - Math.min(1, c * (1 - k) + k));
        const g = 255 * (1 - Math.min(1, m * (1 - k) + k));
        const b = 255 * (1 - Math.min(1, y * (1 - k) + k));

        // Form the color and return it
        const color = new Color(r, g, b);
        return color
      } else {
        return this
      }
    }

    toArray() {
      const { _a, _b, _c, _d, space } = this;
      return [_a, _b, _c, _d, space]
    }

    toHex() {
      const [r, g, b] = this._clamped().map(componentHex);
      return `#${r}${g}${b}`
    }

    toRgb() {
      const [rV, gV, bV] = this._clamped();
      const string = `rgb(${rV},${gV},${bV})`;
      return string
    }

    toString() {
      return this.toHex()
    }

    xyz() {
      // Normalise the red, green and blue values
      const { _a: r255, _b: g255, _c: b255 } = this.rgb();
      const [r, g, b] = [r255, g255, b255].map((v) => v / 255);

      // Convert to the lab rgb space
      const rL = r > 0.04045 ? Math.pow((r + 0.055) / 1.055, 2.4) : r / 12.92;
      const gL = g > 0.04045 ? Math.pow((g + 0.055) / 1.055, 2.4) : g / 12.92;
      const bL = b > 0.04045 ? Math.pow((b + 0.055) / 1.055, 2.4) : b / 12.92;

      // Convert to the xyz color space without bounding the values
      const xU = (rL * 0.4124 + gL * 0.3576 + bL * 0.1805) / 0.95047;
      const yU = (rL * 0.2126 + gL * 0.7152 + bL * 0.0722) / 1.0;
      const zU = (rL * 0.0193 + gL * 0.1192 + bL * 0.9505) / 1.08883;

      // Get the proper xyz values by applying the bounding
      const x = xU > 0.008856 ? Math.pow(xU, 1 / 3) : 7.787 * xU + 16 / 116;
      const y = yU > 0.008856 ? Math.pow(yU, 1 / 3) : 7.787 * yU + 16 / 116;
      const z = zU > 0.008856 ? Math.pow(zU, 1 / 3) : 7.787 * zU + 16 / 116;

      // Make and return the color
      const color = new Color(x, y, z, 'xyz');
      return color
    }

    /*
    Input and Output methods
    */

    _clamped() {
      const { _a, _b, _c } = this.rgb();
      const { max, min, round } = Math;
      const format = (v) => max(0, min(round(v), 255));
      return [_a, _b, _c].map(format)
    }

    /*
    Constructing colors
    */
  }

  class Point {
    // Initialize
    constructor(...args) {
      this.init(...args);
    }

    // Clone point
    clone() {
      return new Point(this)
    }

    init(x, y) {
      const base = { x: 0, y: 0 };

      // ensure source as object
      const source = Array.isArray(x)
        ? { x: x[0], y: x[1] }
        : typeof x === 'object'
          ? { x: x.x, y: x.y }
          : { x: x, y: y };

      // merge source
      this.x = source.x == null ? base.x : source.x;
      this.y = source.y == null ? base.y : source.y;

      return this
    }

    toArray() {
      return [this.x, this.y]
    }

    transform(m) {
      return this.clone().transformO(m)
    }

    // Transform point with matrix
    transformO(m) {
      if (!Matrix.isMatrixLike(m)) {
        m = new Matrix(m);
      }

      const { x, y } = this;

      // Perform the matrix multiplication
      this.x = m.a * x + m.c * y + m.e;
      this.y = m.b * x + m.d * y + m.f;

      return this
    }
  }

  function point(x, y) {
    return new Point(x, y).transformO(this.screenCTM().inverseO())
  }

  function closeEnough(a, b, threshold) {
    return Math.abs(b - a) < (threshold || 1e-6)
  }

  class Matrix {
    constructor(...args) {
      this.init(...args);
    }

    static formatTransforms(o) {
      // Get all of the parameters required to form the matrix
      const flipBoth = o.flip === 'both' || o.flip === true;
      const flipX = o.flip && (flipBoth || o.flip === 'x') ? -1 : 1;
      const flipY = o.flip && (flipBoth || o.flip === 'y') ? -1 : 1;
      const skewX =
        o.skew && o.skew.length
          ? o.skew[0]
          : isFinite(o.skew)
            ? o.skew
            : isFinite(o.skewX)
              ? o.skewX
              : 0;
      const skewY =
        o.skew && o.skew.length
          ? o.skew[1]
          : isFinite(o.skew)
            ? o.skew
            : isFinite(o.skewY)
              ? o.skewY
              : 0;
      const scaleX =
        o.scale && o.scale.length
          ? o.scale[0] * flipX
          : isFinite(o.scale)
            ? o.scale * flipX
            : isFinite(o.scaleX)
              ? o.scaleX * flipX
              : flipX;
      const scaleY =
        o.scale && o.scale.length
          ? o.scale[1] * flipY
          : isFinite(o.scale)
            ? o.scale * flipY
            : isFinite(o.scaleY)
              ? o.scaleY * flipY
              : flipY;
      const shear = o.shear || 0;
      const theta = o.rotate || o.theta || 0;
      const origin = new Point(
        o.origin || o.around || o.ox || o.originX,
        o.oy || o.originY
      );
      const ox = origin.x;
      const oy = origin.y;
      // We need Point to be invalid if nothing was passed because we cannot default to 0 here. That is why NaN
      const position = new Point(
        o.position || o.px || o.positionX || NaN,
        o.py || o.positionY || NaN
      );
      const px = position.x;
      const py = position.y;
      const translate = new Point(
        o.translate || o.tx || o.translateX,
        o.ty || o.translateY
      );
      const tx = translate.x;
      const ty = translate.y;
      const relative = new Point(
        o.relative || o.rx || o.relativeX,
        o.ry || o.relativeY
      );
      const rx = relative.x;
      const ry = relative.y;

      // Populate all of the values
      return {
        scaleX,
        scaleY,
        skewX,
        skewY,
        shear,
        theta,
        rx,
        ry,
        tx,
        ty,
        ox,
        oy,
        px,
        py
      }
    }

    static fromArray(a) {
      return { a: a[0], b: a[1], c: a[2], d: a[3], e: a[4], f: a[5] }
    }

    static isMatrixLike(o) {
      return (
        o.a != null ||
        o.b != null ||
        o.c != null ||
        o.d != null ||
        o.e != null ||
        o.f != null
      )
    }

    // left matrix, right matrix, target matrix which is overwritten
    static matrixMultiply(l, r, o) {
      // Work out the product directly
      const a = l.a * r.a + l.c * r.b;
      const b = l.b * r.a + l.d * r.b;
      const c = l.a * r.c + l.c * r.d;
      const d = l.b * r.c + l.d * r.d;
      const e = l.e + l.a * r.e + l.c * r.f;
      const f = l.f + l.b * r.e + l.d * r.f;

      // make sure to use local variables because l/r and o could be the same
      o.a = a;
      o.b = b;
      o.c = c;
      o.d = d;
      o.e = e;
      o.f = f;

      return o
    }

    around(cx, cy, matrix) {
      return this.clone().aroundO(cx, cy, matrix)
    }

    // Transform around a center point
    aroundO(cx, cy, matrix) {
      const dx = cx || 0;
      const dy = cy || 0;
      return this.translateO(-dx, -dy).lmultiplyO(matrix).translateO(dx, dy)
    }

    // Clones this matrix
    clone() {
      return new Matrix(this)
    }

    // Decomposes this matrix into its affine parameters
    decompose(cx = 0, cy = 0) {
      // Get the parameters from the matrix
      const a = this.a;
      const b = this.b;
      const c = this.c;
      const d = this.d;
      const e = this.e;
      const f = this.f;

      // Figure out if the winding direction is clockwise or counterclockwise
      const determinant = a * d - b * c;
      const ccw = determinant > 0 ? 1 : -1;

      // Since we only shear in x, we can use the x basis to get the x scale
      // and the rotation of the resulting matrix
      const sx = ccw * Math.sqrt(a * a + b * b);
      const thetaRad = Math.atan2(ccw * b, ccw * a);
      const theta = (180 / Math.PI) * thetaRad;
      const ct = Math.cos(thetaRad);
      const st = Math.sin(thetaRad);

      // We can then solve the y basis vector simultaneously to get the other
      // two affine parameters directly from these parameters
      const lam = (a * c + b * d) / determinant;
      const sy = (c * sx) / (lam * a - b) || (d * sx) / (lam * b + a);

      // Use the translations
      const tx = e - cx + cx * ct * sx + cy * (lam * ct * sx - st * sy);
      const ty = f - cy + cx * st * sx + cy * (lam * st * sx + ct * sy);

      // Construct the decomposition and return it
      return {
        // Return the affine parameters
        scaleX: sx,
        scaleY: sy,
        shear: lam,
        rotate: theta,
        translateX: tx,
        translateY: ty,
        originX: cx,
        originY: cy,

        // Return the matrix parameters
        a: this.a,
        b: this.b,
        c: this.c,
        d: this.d,
        e: this.e,
        f: this.f
      }
    }

    // Check if two matrices are equal
    equals(other) {
      if (other === this) return true
      const comp = new Matrix(other);
      return (
        closeEnough(this.a, comp.a) &&
        closeEnough(this.b, comp.b) &&
        closeEnough(this.c, comp.c) &&
        closeEnough(this.d, comp.d) &&
        closeEnough(this.e, comp.e) &&
        closeEnough(this.f, comp.f)
      )
    }

    // Flip matrix on x or y, at a given offset
    flip(axis, around) {
      return this.clone().flipO(axis, around)
    }

    flipO(axis, around) {
      return axis === 'x'
        ? this.scaleO(-1, 1, around, 0)
        : axis === 'y'
          ? this.scaleO(1, -1, 0, around)
          : this.scaleO(-1, -1, axis, around || axis) // Define an x, y flip point
    }

    // Initialize
    init(source) {
      const base = Matrix.fromArray([1, 0, 0, 1, 0, 0]);

      // ensure source as object
      source =
        source instanceof Element$1
          ? source.matrixify()
          : typeof source === 'string'
            ? Matrix.fromArray(source.split(delimiter).map(parseFloat))
            : Array.isArray(source)
              ? Matrix.fromArray(source)
              : typeof source === 'object' && Matrix.isMatrixLike(source)
                ? source
                : typeof source === 'object'
                  ? new Matrix().transform(source)
                  : arguments.length === 6
                    ? Matrix.fromArray([].slice.call(arguments))
                    : base;

      // Merge the source matrix with the base matrix
      this.a = source.a != null ? source.a : base.a;
      this.b = source.b != null ? source.b : base.b;
      this.c = source.c != null ? source.c : base.c;
      this.d = source.d != null ? source.d : base.d;
      this.e = source.e != null ? source.e : base.e;
      this.f = source.f != null ? source.f : base.f;

      return this
    }

    inverse() {
      return this.clone().inverseO()
    }

    // Inverses matrix
    inverseO() {
      // Get the current parameters out of the matrix
      const a = this.a;
      const b = this.b;
      const c = this.c;
      const d = this.d;
      const e = this.e;
      const f = this.f;

      // Invert the 2x2 matrix in the top left
      const det = a * d - b * c;
      if (!det) throw new Error('Cannot invert ' + this)

      // Calculate the top 2x2 matrix
      const na = d / det;
      const nb = -b / det;
      const nc = -c / det;
      const nd = a / det;

      // Apply the inverted matrix to the top right
      const ne = -(na * e + nc * f);
      const nf = -(nb * e + nd * f);

      // Construct the inverted matrix
      this.a = na;
      this.b = nb;
      this.c = nc;
      this.d = nd;
      this.e = ne;
      this.f = nf;

      return this
    }

    lmultiply(matrix) {
      return this.clone().lmultiplyO(matrix)
    }

    lmultiplyO(matrix) {
      const r = this;
      const l = matrix instanceof Matrix ? matrix : new Matrix(matrix);

      return Matrix.matrixMultiply(l, r, this)
    }

    // Left multiplies by the given matrix
    multiply(matrix) {
      return this.clone().multiplyO(matrix)
    }

    multiplyO(matrix) {
      // Get the matrices
      const l = this;
      const r = matrix instanceof Matrix ? matrix : new Matrix(matrix);

      return Matrix.matrixMultiply(l, r, this)
    }

    // Rotate matrix
    rotate(r, cx, cy) {
      return this.clone().rotateO(r, cx, cy)
    }

    rotateO(r, cx = 0, cy = 0) {
      // Convert degrees to radians
      r = radians(r);

      const cos = Math.cos(r);
      const sin = Math.sin(r);

      const { a, b, c, d, e, f } = this;

      this.a = a * cos - b * sin;
      this.b = b * cos + a * sin;
      this.c = c * cos - d * sin;
      this.d = d * cos + c * sin;
      this.e = e * cos - f * sin + cy * sin - cx * cos + cx;
      this.f = f * cos + e * sin - cx * sin - cy * cos + cy;

      return this
    }

    // Scale matrix
    scale() {
      return this.clone().scaleO(...arguments)
    }

    scaleO(x, y = x, cx = 0, cy = 0) {
      // Support uniform scaling
      if (arguments.length === 3) {
        cy = cx;
        cx = y;
        y = x;
      }

      const { a, b, c, d, e, f } = this;

      this.a = a * x;
      this.b = b * y;
      this.c = c * x;
      this.d = d * y;
      this.e = e * x - cx * x + cx;
      this.f = f * y - cy * y + cy;

      return this
    }

    // Shear matrix
    shear(a, cx, cy) {
      return this.clone().shearO(a, cx, cy)
    }

    // eslint-disable-next-line no-unused-vars
    shearO(lx, cx = 0, cy = 0) {
      const { a, b, c, d, e, f } = this;

      this.a = a + b * lx;
      this.c = c + d * lx;
      this.e = e + f * lx - cy * lx;

      return this
    }

    // Skew Matrix
    skew() {
      return this.clone().skewO(...arguments)
    }

    skewO(x, y = x, cx = 0, cy = 0) {
      // support uniformal skew
      if (arguments.length === 3) {
        cy = cx;
        cx = y;
        y = x;
      }

      // Convert degrees to radians
      x = radians(x);
      y = radians(y);

      const lx = Math.tan(x);
      const ly = Math.tan(y);

      const { a, b, c, d, e, f } = this;

      this.a = a + b * lx;
      this.b = b + a * ly;
      this.c = c + d * lx;
      this.d = d + c * ly;
      this.e = e + f * lx - cy * lx;
      this.f = f + e * ly - cx * ly;

      return this
    }

    // SkewX
    skewX(x, cx, cy) {
      return this.skew(x, 0, cx, cy)
    }

    // SkewY
    skewY(y, cx, cy) {
      return this.skew(0, y, cx, cy)
    }

    toArray() {
      return [this.a, this.b, this.c, this.d, this.e, this.f]
    }

    // Convert matrix to string
    toString() {
      return (
        'matrix(' +
        this.a +
        ',' +
        this.b +
        ',' +
        this.c +
        ',' +
        this.d +
        ',' +
        this.e +
        ',' +
        this.f +
        ')'
      )
    }

    // Transform a matrix into another matrix by manipulating the space
    transform(o) {
      // Check if o is a matrix and then left multiply it directly
      if (Matrix.isMatrixLike(o)) {
        const matrix = new Matrix(o);
        return matrix.multiplyO(this)
      }

      // Get the proposed transformations and the current transformations
      const t = Matrix.formatTransforms(o);
      const current = this;
      const { x: ox, y: oy } = new Point(t.ox, t.oy).transform(current);

      // Construct the resulting matrix
      const transformer = new Matrix()
        .translateO(t.rx, t.ry)
        .lmultiplyO(current)
        .translateO(-ox, -oy)
        .scaleO(t.scaleX, t.scaleY)
        .skewO(t.skewX, t.skewY)
        .shearO(t.shear)
        .rotateO(t.theta)
        .translateO(ox, oy);

      // If we want the origin at a particular place, we force it there
      if (isFinite(t.px) || isFinite(t.py)) {
        const origin = new Point(ox, oy).transform(transformer);
        // TODO: Replace t.px with isFinite(t.px)
        // Doesn't work because t.px is also 0 if it wasn't passed
        const dx = isFinite(t.px) ? t.px - origin.x : 0;
        const dy = isFinite(t.py) ? t.py - origin.y : 0;
        transformer.translateO(dx, dy);
      }

      // Translate now after positioning
      transformer.translateO(t.tx, t.ty);
      return transformer
    }

    // Translate matrix
    translate(x, y) {
      return this.clone().translateO(x, y)
    }

    translateO(x, y) {
      this.e += x || 0;
      this.f += y || 0;
      return this
    }

    valueOf() {
      return {
        a: this.a,
        b: this.b,
        c: this.c,
        d: this.d,
        e: this.e,
        f: this.f
      }
    }
  }

  function ctm() {
    return new Matrix(this.node.getCTM())
  }

  function screenCTM() {
    try {
      /* https://bugzilla.mozilla.org/show_bug.cgi?id=1344537
         This is needed because FF does not return the transformation matrix
         for the inner coordinate system when getScreenCTM() is called on nested svgs.
         However all other Browsers do that */
      if (typeof this.isRoot === 'function' && !this.isRoot()) {
        const rect = this.rect(1, 1);
        const m = rect.node.getScreenCTM();
        rect.remove();
        return new Matrix(m)
      }
      return new Matrix(this.node.getScreenCTM())
    } catch (e) {
      console.warn(
        `Cannot get CTM from SVG node ${this.node.nodeName}. Is the element rendered?`
      );
      return new Matrix()
    }
  }

  register(Matrix, 'Matrix');

  function parser() {
    // Reuse cached element if possible
    if (!parser.nodes) {
      const svg = makeInstance().size(2, 0);
      svg.node.style.cssText = [
        'opacity: 0',
        'position: absolute',
        'left: -100%',
        'top: -100%',
        'overflow: hidden'
      ].join(';');

      svg.attr('focusable', 'false');
      svg.attr('aria-hidden', 'true');

      const path = svg.path().node;

      parser.nodes = { svg, path };
    }

    if (!parser.nodes.svg.node.parentNode) {
      const b = globals.document.body || globals.document.documentElement;
      parser.nodes.svg.addTo(b);
    }

    return parser.nodes
  }

  function isNulledBox(box) {
    return !box.width && !box.height && !box.x && !box.y
  }

  function domContains(node) {
    return (
      node === globals.document ||
      (
        globals.document.documentElement.contains ||
        function (node) {
          // This is IE - it does not support contains() for top-level SVGs
          while (node.parentNode) {
            node = node.parentNode;
          }
          return node === globals.document
        }
      ).call(globals.document.documentElement, node)
    )
  }

  class Box {
    constructor(...args) {
      this.init(...args);
    }

    addOffset() {
      // offset by window scroll position, because getBoundingClientRect changes when window is scrolled
      this.x += globals.window.pageXOffset;
      this.y += globals.window.pageYOffset;
      return new Box(this)
    }

    init(source) {
      const base = [0, 0, 0, 0];
      source =
        typeof source === 'string'
          ? source.split(delimiter).map(parseFloat)
          : Array.isArray(source)
            ? source
            : typeof source === 'object'
              ? [
                  source.left != null ? source.left : source.x,
                  source.top != null ? source.top : source.y,
                  source.width,
                  source.height
                ]
              : arguments.length === 4
                ? [].slice.call(arguments)
                : base;

      this.x = source[0] || 0;
      this.y = source[1] || 0;
      this.width = this.w = source[2] || 0;
      this.height = this.h = source[3] || 0;

      // Add more bounding box properties
      this.x2 = this.x + this.w;
      this.y2 = this.y + this.h;
      this.cx = this.x + this.w / 2;
      this.cy = this.y + this.h / 2;

      return this
    }

    isNulled() {
      return isNulledBox(this)
    }

    // Merge rect box with another, return a new instance
    merge(box) {
      const x = Math.min(this.x, box.x);
      const y = Math.min(this.y, box.y);
      const width = Math.max(this.x + this.width, box.x + box.width) - x;
      const height = Math.max(this.y + this.height, box.y + box.height) - y;

      return new Box(x, y, width, height)
    }

    toArray() {
      return [this.x, this.y, this.width, this.height]
    }

    toString() {
      return this.x + ' ' + this.y + ' ' + this.width + ' ' + this.height
    }

    transform(m) {
      if (!(m instanceof Matrix)) {
        m = new Matrix(m);
      }

      let xMin = Infinity;
      let xMax = -Infinity;
      let yMin = Infinity;
      let yMax = -Infinity;

      const pts = [
        new Point(this.x, this.y),
        new Point(this.x2, this.y),
        new Point(this.x, this.y2),
        new Point(this.x2, this.y2)
      ];

      pts.forEach(function (p) {
        p = p.transform(m);
        xMin = Math.min(xMin, p.x);
        xMax = Math.max(xMax, p.x);
        yMin = Math.min(yMin, p.y);
        yMax = Math.max(yMax, p.y);
      });

      return new Box(xMin, yMin, xMax - xMin, yMax - yMin)
    }
  }

  function getBox(el, getBBoxFn, retry) {
    let box;

    try {
      // Try to get the box with the provided function
      box = getBBoxFn(el.node);

      // If the box is worthless and not even in the dom, retry
      // by throwing an error here...
      if (isNulledBox(box) && !domContains(el.node)) {
        throw new Error('Element not in the dom')
      }
    } catch (e) {
      // ... and calling the retry handler here
      box = retry(el);
    }

    return box
  }

  function bbox() {
    // Function to get bbox is getBBox()
    const getBBox = (node) => node.getBBox();

    // Take all measures so that a stupid browser renders the element
    // so we can get the bbox from it when we try again
    const retry = (el) => {
      try {
        const clone = el.clone().addTo(parser().svg).show();
        const box = clone.node.getBBox();
        clone.remove();
        return box
      } catch (e) {
        // We give up...
        throw new Error(
          `Getting bbox of element "${
          el.node.nodeName
        }" is not possible: ${e.toString()}`
        )
      }
    };

    const box = getBox(this, getBBox, retry);
    const bbox = new Box(box);

    return bbox
  }

  function rbox(el) {
    const getRBox = (node) => node.getBoundingClientRect();
    const retry = (el) => {
      // There is no point in trying tricks here because if we insert the element into the dom ourselves
      // it obviously will be at the wrong position
      throw new Error(
        `Getting rbox of element "${el.node.nodeName}" is not possible`
      )
    };

    const box = getBox(this, getRBox, retry);
    const rbox = new Box(box);

    // If an element was passed, we want the bbox in the coordinate system of that element
    if (el) {
      return rbox.transform(el.screenCTM().inverseO())
    }

    // Else we want it in absolute screen coordinates
    // Therefore we need to add the scrollOffset
    return rbox.addOffset()
  }

  // Checks whether the given point is inside the bounding box
  function inside(x, y) {
    const box = this.bbox();

    return (
      x > box.x && y > box.y && x < box.x + box.width && y < box.y + box.height
    )
  }

  registerMethods({
    viewbox: {
      viewbox(x, y, width, height) {
        // act as getter
        if (x == null) return new Box(this.attr('viewBox'))

        // act as setter
        return this.attr('viewBox', new Box(x, y, width, height))
      },

      zoom(level, point) {
        // Its best to rely on the attributes here and here is why:
        // clientXYZ: Doesn't work on non-root svgs because they dont have a CSSBox (silly!)
        // getBoundingClientRect: Doesn't work because Chrome just ignores width and height of nested svgs completely
        //                        that means, their clientRect is always as big as the content.
        //                        Furthermore this size is incorrect if the element is further transformed by its parents
        // computedStyle: Only returns meaningful values if css was used with px. We dont go this route here!
        // getBBox: returns the bounding box of its content - that doesn't help!
        let { width, height } = this.attr(['width', 'height']);

        // Width and height is a string when a number with a unit is present which we can't use
        // So we try clientXYZ
        if (
          (!width && !height) ||
          typeof width === 'string' ||
          typeof height === 'string'
        ) {
          width = this.node.clientWidth;
          height = this.node.clientHeight;
        }

        // Giving up...
        if (!width || !height) {
          throw new Error(
            'Impossible to get absolute width and height. Please provide an absolute width and height attribute on the zooming element'
          )
        }

        const v = this.viewbox();

        const zoomX = width / v.width;
        const zoomY = height / v.height;
        const zoom = Math.min(zoomX, zoomY);

        if (level == null) {
          return zoom
        }

        let zoomAmount = zoom / level;

        // Set the zoomAmount to the highest value which is safe to process and recover from
        // The * 100 is a bit of wiggle room for the matrix transformation
        if (zoomAmount === Infinity) zoomAmount = Number.MAX_SAFE_INTEGER / 100;

        point =
          point || new Point(width / 2 / zoomX + v.x, height / 2 / zoomY + v.y);

        const box = new Box(v).transform(
          new Matrix({ scale: zoomAmount, origin: point })
        );

        return this.viewbox(box)
      }
    }
  });

  register(Box, 'Box');

  // import { subClassArray } from './ArrayPolyfill.js'

  class List extends Array {
    constructor(arr = [], ...args) {
      super(arr, ...args);
      if (typeof arr === 'number') return this
      this.length = 0;
      this.push(...arr);
    }
  }

  extend([List], {
    each(fnOrMethodName, ...args) {
      if (typeof fnOrMethodName === 'function') {
        return this.map((el, i, arr) => {
          return fnOrMethodName.call(el, el, i, arr)
        })
      } else {
        return this.map((el) => {
          return el[fnOrMethodName](...args)
        })
      }
    },

    toArray() {
      return Array.prototype.concat.apply([], this)
    }
  });

  const reserved = ['toArray', 'constructor', 'each'];

  List.extend = function (methods) {
    methods = methods.reduce((obj, name) => {
      // Don't overwrite own methods
      if (reserved.includes(name)) return obj

      // Don't add private methods
      if (name[0] === '_') return obj

      // Allow access to original Array methods through a prefix
      if (name in Array.prototype) {
        obj['$' + name] = Array.prototype[name];
      }

      // Relay every call to each()
      obj[name] = function (...attrs) {
        return this.each(name, ...attrs)
      };
      return obj
    }, {});

    extend([List], methods);
  };

  function baseFind(query, parent) {
    return new List(
      map((parent || globals.document).querySelectorAll(query), function (node) {
        return adopt(node)
      })
    )
  }

  // Scoped find method
  function find(query) {
    return baseFind(query, this.node)
  }

  function findOne(query) {
    return adopt(this.node.querySelector(query))
  }

  let listenerId = 0;
  const windowEvents = {};

  function getEvents(instance) {
    let n = instance.getEventHolder();

    // We dont want to save events in global space
    if (n === globals.window) n = windowEvents;
    if (!n.events) n.events = {};
    return n.events
  }

  function getEventTarget(instance) {
    return instance.getEventTarget()
  }

  function clearEvents(instance) {
    let n = instance.getEventHolder();
    if (n === globals.window) n = windowEvents;
    if (n.events) n.events = {};
  }

  // Add event binder in the SVG namespace
  function on(node, events, listener, binding, options) {
    const l = listener.bind(binding || node);
    const instance = makeInstance(node);
    const bag = getEvents(instance);
    const n = getEventTarget(instance);

    // events can be an array of events or a string of events
    events = Array.isArray(events) ? events : events.split(delimiter);

    // add id to listener
    if (!listener._svgjsListenerId) {
      listener._svgjsListenerId = ++listenerId;
    }

    events.forEach(function (event) {
      const ev = event.split('.')[0];
      const ns = event.split('.')[1] || '*';

      // ensure valid object
      bag[ev] = bag[ev] || {};
      bag[ev][ns] = bag[ev][ns] || {};

      // reference listener
      bag[ev][ns][listener._svgjsListenerId] = l;

      // add listener
      n.addEventListener(ev, l, options || false);
    });
  }

  // Add event unbinder in the SVG namespace
  function off(node, events, listener, options) {
    const instance = makeInstance(node);
    const bag = getEvents(instance);
    const n = getEventTarget(instance);

    // listener can be a function or a number
    if (typeof listener === 'function') {
      listener = listener._svgjsListenerId;
      if (!listener) return
    }

    // events can be an array of events or a string or undefined
    events = Array.isArray(events) ? events : (events || '').split(delimiter);

    events.forEach(function (event) {
      const ev = event && event.split('.')[0];
      const ns = event && event.split('.')[1];
      let namespace, l;

      if (listener) {
        // remove listener reference
        if (bag[ev] && bag[ev][ns || '*']) {
          // removeListener
          n.removeEventListener(
            ev,
            bag[ev][ns || '*'][listener],
            options || false
          );

          delete bag[ev][ns || '*'][listener];
        }
      } else if (ev && ns) {
        // remove all listeners for a namespaced event
        if (bag[ev] && bag[ev][ns]) {
          for (l in bag[ev][ns]) {
            off(n, [ev, ns].join('.'), l);
          }

          delete bag[ev][ns];
        }
      } else if (ns) {
        // remove all listeners for a specific namespace
        for (event in bag) {
          for (namespace in bag[event]) {
            if (ns === namespace) {
              off(n, [event, ns].join('.'));
            }
          }
        }
      } else if (ev) {
        // remove all listeners for the event
        if (bag[ev]) {
          for (namespace in bag[ev]) {
            off(n, [ev, namespace].join('.'));
          }

          delete bag[ev];
        }
      } else {
        // remove all listeners on a given node
        for (event in bag) {
          off(n, event);
        }

        clearEvents(instance);
      }
    });
  }

  function dispatch(node, event, data, options) {
    const n = getEventTarget(node);

    // Dispatch event
    if (event instanceof globals.window.Event) {
      n.dispatchEvent(event);
    } else {
      event = new globals.window.CustomEvent(event, {
        detail: data,
        cancelable: true,
        ...options
      });
      n.dispatchEvent(event);
    }
    return event
  }

  class EventTarget extends Base$1 {
    addEventListener() {}

    dispatch(event, data, options) {
      return dispatch(this, event, data, options)
    }

    dispatchEvent(event) {
      const bag = this.getEventHolder().events;
      if (!bag) return true

      const events = bag[event.type];

      for (const i in events) {
        for (const j in events[i]) {
          events[i][j](event);
        }
      }

      return !event.defaultPrevented
    }

    // Fire given event
    fire(event, data, options) {
      this.dispatch(event, data, options);
      return this
    }

    getEventHolder() {
      return this
    }

    getEventTarget() {
      return this
    }

    // Unbind event from listener
    off(event, listener, options) {
      off(this, event, listener, options);
      return this
    }

    // Bind given event to listener
    on(event, listener, binding, options) {
      on(this, event, listener, binding, options);
      return this
    }

    removeEventListener() {}
  }

  register(EventTarget, 'EventTarget');

  function noop() {}

  // Default animation values
  const timeline = {
    duration: 400,
    ease: '>',
    delay: 0
  };

  // Default attribute values
  const attrs = {
    // fill and stroke
    'fill-opacity': 1,
    'stroke-opacity': 1,
    'stroke-width': 0,
    'stroke-linejoin': 'miter',
    'stroke-linecap': 'butt',
    fill: '#000000',
    stroke: '#000000',
    opacity: 1,

    // position
    x: 0,
    y: 0,
    cx: 0,
    cy: 0,

    // size
    width: 0,
    height: 0,

    // radius
    r: 0,
    rx: 0,
    ry: 0,

    // gradient
    offset: 0,
    'stop-opacity': 1,
    'stop-color': '#000000',

    // text
    'text-anchor': 'start'
  };

  class SVGArray extends Array {
    constructor(...args) {
      super(...args);
      this.init(...args);
    }

    clone() {
      return new this.constructor(this)
    }

    init(arr) {
      // This catches the case, that native map tries to create an array with new Array(1)
      if (typeof arr === 'number') return this
      this.length = 0;
      this.push(...this.parse(arr));
      return this
    }

    // Parse whitespace separated string
    parse(array = []) {
      // If already is an array, no need to parse it
      if (array instanceof Array) return array

      return array.trim().split(delimiter).map(parseFloat)
    }

    toArray() {
      return Array.prototype.concat.apply([], this)
    }

    toSet() {
      return new Set(this)
    }

    toString() {
      return this.join(' ')
    }

    // Flattens the array if needed
    valueOf() {
      const ret = [];
      ret.push(...this);
      return ret
    }
  }

  // Module for unit conversions
  class SVGNumber {
    // Initialize
    constructor(...args) {
      this.init(...args);
    }

    convert(unit) {
      return new SVGNumber(this.value, unit)
    }

    // Divide number
    divide(number) {
      number = new SVGNumber(number);
      return new SVGNumber(this / number, this.unit || number.unit)
    }

    init(value, unit) {
      unit = Array.isArray(value) ? value[1] : unit;
      value = Array.isArray(value) ? value[0] : value;

      // initialize defaults
      this.value = 0;
      this.unit = unit || '';

      // parse value
      if (typeof value === 'number') {
        // ensure a valid numeric value
        this.value = isNaN(value)
          ? 0
          : !isFinite(value)
            ? value < 0
              ? -3.4e38
              : +3.4e38
            : value;
      } else if (typeof value === 'string') {
        unit = value.match(numberAndUnit);

        if (unit) {
          // make value numeric
          this.value = parseFloat(unit[1]);

          // normalize
          if (unit[5] === '%') {
            this.value /= 100;
          } else if (unit[5] === 's') {
            this.value *= 1000;
          }

          // store unit
          this.unit = unit[5];
        }
      } else {
        if (value instanceof SVGNumber) {
          this.value = value.valueOf();
          this.unit = value.unit;
        }
      }

      return this
    }

    // Subtract number
    minus(number) {
      number = new SVGNumber(number);
      return new SVGNumber(this - number, this.unit || number.unit)
    }

    // Add number
    plus(number) {
      number = new SVGNumber(number);
      return new SVGNumber(this + number, this.unit || number.unit)
    }

    // Multiply number
    times(number) {
      number = new SVGNumber(number);
      return new SVGNumber(this * number, this.unit || number.unit)
    }

    toArray() {
      return [this.value, this.unit]
    }

    toJSON() {
      return this.toString()
    }

    toString() {
      return (
        (this.unit === '%'
          ? ~~(this.value * 1e8) / 1e6
          : this.unit === 's'
            ? this.value / 1e3
            : this.value) + this.unit
      )
    }

    valueOf() {
      return this.value
    }
  }

  const colorAttributes = new Set([
    'fill',
    'stroke',
    'color',
    'bgcolor',
    'stop-color',
    'flood-color',
    'lighting-color'
  ]);

  const hooks = [];
  function registerAttrHook(fn) {
    hooks.push(fn);
  }

  // Set svg element attribute
  function attr(attr, val, ns) {
    // act as full getter
    if (attr == null) {
      // get an object of attributes
      attr = {};
      val = this.node.attributes;

      for (const node of val) {
        attr[node.nodeName] = isNumber.test(node.nodeValue)
          ? parseFloat(node.nodeValue)
          : node.nodeValue;
      }

      return attr
    } else if (attr instanceof Array) {
      // loop through array and get all values
      return attr.reduce((last, curr) => {
        last[curr] = this.attr(curr);
        return last
      }, {})
    } else if (typeof attr === 'object' && attr.constructor === Object) {
      // apply every attribute individually if an object is passed
      for (val in attr) this.attr(val, attr[val]);
    } else if (val === null) {
      // remove value
      this.node.removeAttribute(attr);
    } else if (val == null) {
      // act as a getter if the first and only argument is not an object
      val = this.node.getAttribute(attr);
      return val == null
        ? attrs[attr]
        : isNumber.test(val)
          ? parseFloat(val)
          : val
    } else {
      // Loop through hooks and execute them to convert value
      val = hooks.reduce((_val, hook) => {
        return hook(attr, _val, this)
      }, val);

      // ensure correct numeric values (also accepts NaN and Infinity)
      if (typeof val === 'number') {
        val = new SVGNumber(val);
      } else if (colorAttributes.has(attr) && Color.isColor(val)) {
        // ensure full hex color
        val = new Color(val);
      } else if (val.constructor === Array) {
        // Check for plain arrays and parse array values
        val = new SVGArray(val);
      }

      // if the passed attribute is leading...
      if (attr === 'leading') {
        // ... call the leading method instead
        if (this.leading) {
          this.leading(val);
        }
      } else {
        // set given attribute on node
        typeof ns === 'string'
          ? this.node.setAttributeNS(ns, attr, val.toString())
          : this.node.setAttribute(attr, val.toString());
      }

      // rebuild if required
      if (this.rebuild && (attr === 'font-size' || attr === 'x')) {
        this.rebuild();
      }
    }

    return this
  }

  class Dom extends EventTarget {
    constructor(node, attrs) {
      super();
      this.node = node;
      this.type = node.nodeName;

      if (attrs && node !== attrs) {
        this.attr(attrs);
      }
    }

    // Add given element at a position
    add(element, i) {
      element = makeInstance(element);

      // If non-root svg nodes are added we have to remove their namespaces
      if (
        element.removeNamespace &&
        this.node instanceof globals.window.SVGElement
      ) {
        element.removeNamespace();
      }

      if (i == null) {
        this.node.appendChild(element.node);
      } else if (element.node !== this.node.childNodes[i]) {
        this.node.insertBefore(element.node, this.node.childNodes[i]);
      }

      return this
    }

    // Add element to given container and return self
    addTo(parent, i) {
      return makeInstance(parent).put(this, i)
    }

    // Returns all child elements
    children() {
      return new List(
        map(this.node.children, function (node) {
          return adopt(node)
        })
      )
    }

    // Remove all elements in this container
    clear() {
      // remove children
      while (this.node.hasChildNodes()) {
        this.node.removeChild(this.node.lastChild);
      }

      return this
    }

    // Clone element
    clone(deep = true, assignNewIds = true) {
      // write dom data to the dom so the clone can pickup the data
      this.writeDataToDom();

      // clone element
      let nodeClone = this.node.cloneNode(deep);
      if (assignNewIds) {
        // assign new id
        nodeClone = assignNewId(nodeClone);
      }
      return new this.constructor(nodeClone)
    }

    // Iterates over all children and invokes a given block
    each(block, deep) {
      const children = this.children();
      let i, il;

      for (i = 0, il = children.length; i < il; i++) {
        block.apply(children[i], [i, children]);

        if (deep) {
          children[i].each(block, deep);
        }
      }

      return this
    }

    element(nodeName, attrs) {
      return this.put(new Dom(create(nodeName), attrs))
    }

    // Get first child
    first() {
      return adopt(this.node.firstChild)
    }

    // Get a element at the given index
    get(i) {
      return adopt(this.node.childNodes[i])
    }

    getEventHolder() {
      return this.node
    }

    getEventTarget() {
      return this.node
    }

    // Checks if the given element is a child
    has(element) {
      return this.index(element) >= 0
    }

    html(htmlOrFn, outerHTML) {
      return this.xml(htmlOrFn, outerHTML, html)
    }

    // Get / set id
    id(id) {
      // generate new id if no id set
      if (typeof id === 'undefined' && !this.node.id) {
        this.node.id = eid(this.type);
      }

      // don't set directly with this.node.id to make `null` work correctly
      return this.attr('id', id)
    }

    // Gets index of given element
    index(element) {
      return [].slice.call(this.node.childNodes).indexOf(element.node)
    }

    // Get the last child
    last() {
      return adopt(this.node.lastChild)
    }

    // matches the element vs a css selector
    matches(selector) {
      const el = this.node;
      const matcher =
        el.matches ||
        el.matchesSelector ||
        el.msMatchesSelector ||
        el.mozMatchesSelector ||
        el.webkitMatchesSelector ||
        el.oMatchesSelector ||
        null;
      return matcher && matcher.call(el, selector)
    }

    // Returns the parent element instance
    parent(type) {
      let parent = this;

      // check for parent
      if (!parent.node.parentNode) return null

      // get parent element
      parent = adopt(parent.node.parentNode);

      if (!type) return parent

      // loop through ancestors if type is given
      do {
        if (
          typeof type === 'string' ? parent.matches(type) : parent instanceof type
        )
          return parent
      } while ((parent = adopt(parent.node.parentNode)))

      return parent
    }

    // Basically does the same as `add()` but returns the added element instead
    put(element, i) {
      element = makeInstance(element);
      this.add(element, i);
      return element
    }

    // Add element to given container and return container
    putIn(parent, i) {
      return makeInstance(parent).add(this, i)
    }

    // Remove element
    remove() {
      if (this.parent()) {
        this.parent().removeElement(this);
      }

      return this
    }

    // Remove a given child
    removeElement(element) {
      this.node.removeChild(element.node);

      return this
    }

    // Replace this with element
    replace(element) {
      element = makeInstance(element);

      if (this.node.parentNode) {
        this.node.parentNode.replaceChild(element.node, this.node);
      }

      return element
    }

    round(precision = 2, map = null) {
      const factor = 10 ** precision;
      const attrs = this.attr(map);

      for (const i in attrs) {
        if (typeof attrs[i] === 'number') {
          attrs[i] = Math.round(attrs[i] * factor) / factor;
        }
      }

      this.attr(attrs);
      return this
    }

    // Import / Export raw svg
    svg(svgOrFn, outerSVG) {
      return this.xml(svgOrFn, outerSVG, svg)
    }

    // Return id on string conversion
    toString() {
      return this.id()
    }

    words(text) {
      // This is faster than removing all children and adding a new one
      this.node.textContent = text;
      return this
    }

    wrap(node) {
      const parent = this.parent();

      if (!parent) {
        return this.addTo(node)
      }

      const position = parent.index(this);
      return parent.put(node, position).put(this)
    }

    // write svgjs data to the dom
    writeDataToDom() {
      // dump variables recursively
      this.each(function () {
        this.writeDataToDom();
      });

      return this
    }

    // Import / Export raw svg
    xml(xmlOrFn, outerXML, ns) {
      if (typeof xmlOrFn === 'boolean') {
        ns = outerXML;
        outerXML = xmlOrFn;
        xmlOrFn = null;
      }

      // act as getter if no svg string is given
      if (xmlOrFn == null || typeof xmlOrFn === 'function') {
        // The default for exports is, that the outerNode is included
        outerXML = outerXML == null ? true : outerXML;

        // write svgjs data to the dom
        this.writeDataToDom();
        let current = this;

        // An export modifier was passed
        if (xmlOrFn != null) {
          current = adopt(current.node.cloneNode(true));

          // If the user wants outerHTML we need to process this node, too
          if (outerXML) {
            const result = xmlOrFn(current);
            current = result || current;

            // The user does not want this node? Well, then he gets nothing
            if (result === false) return ''
          }

          // Deep loop through all children and apply modifier
          current.each(function () {
            const result = xmlOrFn(this);
            const _this = result || this;

            // If modifier returns false, discard node
            if (result === false) {
              this.remove();

              // If modifier returns new node, use it
            } else if (result && this !== _this) {
              this.replace(_this);
            }
          }, true);
        }

        // Return outer or inner content
        return outerXML ? current.node.outerHTML : current.node.innerHTML
      }

      // Act as setter if we got a string

      // The default for import is, that the current node is not replaced
      outerXML = outerXML == null ? false : outerXML;

      // Create temporary holder
      const well = create('wrapper', ns);
      const fragment = globals.document.createDocumentFragment();

      // Dump raw svg
      well.innerHTML = xmlOrFn;

      // Transplant nodes into the fragment
      for (let len = well.children.length; len--; ) {
        fragment.appendChild(well.firstElementChild);
      }

      const parent = this.parent();

      // Add the whole fragment at once
      return outerXML ? this.replace(fragment) && parent : this.add(fragment)
    }
  }

  extend(Dom, { attr, find, findOne });
  register(Dom, 'Dom');

  let Element$1 = class Element extends Dom {
    constructor(node, attrs) {
      super(node, attrs);

      // initialize data object
      this.dom = {};

      // create circular reference
      this.node.instance = this;

      if (node.hasAttribute('data-svgjs') || node.hasAttribute('svgjs:data')) {
        // pull svgjs data from the dom (getAttributeNS doesn't work in html5)
        this.setData(
          JSON.parse(node.getAttribute('data-svgjs')) ??
            JSON.parse(node.getAttribute('svgjs:data')) ??
            {}
        );
      }
    }

    // Move element by its center
    center(x, y) {
      return this.cx(x).cy(y)
    }

    // Move by center over x-axis
    cx(x) {
      return x == null
        ? this.x() + this.width() / 2
        : this.x(x - this.width() / 2)
    }

    // Move by center over y-axis
    cy(y) {
      return y == null
        ? this.y() + this.height() / 2
        : this.y(y - this.height() / 2)
    }

    // Get defs
    defs() {
      const root = this.root();
      return root && root.defs()
    }

    // Relative move over x and y axes
    dmove(x, y) {
      return this.dx(x).dy(y)
    }

    // Relative move over x axis
    dx(x = 0) {
      return this.x(new SVGNumber(x).plus(this.x()))
    }

    // Relative move over y axis
    dy(y = 0) {
      return this.y(new SVGNumber(y).plus(this.y()))
    }

    getEventHolder() {
      return this
    }

    // Set height of element
    height(height) {
      return this.attr('height', height)
    }

    // Move element to given x and y values
    move(x, y) {
      return this.x(x).y(y)
    }

    // return array of all ancestors of given type up to the root svg
    parents(until = this.root()) {
      const isSelector = typeof until === 'string';
      if (!isSelector) {
        until = makeInstance(until);
      }
      const parents = new List();
      let parent = this;

      while (
        (parent = parent.parent()) &&
        parent.node !== globals.document &&
        parent.nodeName !== '#document-fragment'
      ) {
        parents.push(parent);

        if (!isSelector && parent.node === until.node) {
          break
        }
        if (isSelector && parent.matches(until)) {
          break
        }
        if (parent.node === this.root().node) {
          // We worked our way to the root and didn't match `until`
          return null
        }
      }

      return parents
    }

    // Get referenced element form attribute value
    reference(attr) {
      attr = this.attr(attr);
      if (!attr) return null

      const m = (attr + '').match(reference);
      return m ? makeInstance(m[1]) : null
    }

    // Get parent document
    root() {
      const p = this.parent(getClass(root));
      return p && p.root()
    }

    // set given data to the elements data property
    setData(o) {
      this.dom = o;
      return this
    }

    // Set element size to given width and height
    size(width, height) {
      const p = proportionalSize(this, width, height);

      return this.width(new SVGNumber(p.width)).height(new SVGNumber(p.height))
    }

    // Set width of element
    width(width) {
      return this.attr('width', width)
    }

    // write svgjs data to the dom
    writeDataToDom() {
      writeDataToDom(this, this.dom);
      return super.writeDataToDom()
    }

    // Move over x-axis
    x(x) {
      return this.attr('x', x)
    }

    // Move over y-axis
    y(y) {
      return this.attr('y', y)
    }
  };

  extend(Element$1, {
    bbox,
    rbox,
    inside,
    point,
    ctm,
    screenCTM
  });

  register(Element$1, 'Element');

  // Define list of available attributes for stroke and fill
  const sugar = {
    stroke: [
      'color',
      'width',
      'opacity',
      'linecap',
      'linejoin',
      'miterlimit',
      'dasharray',
      'dashoffset'
    ],
    fill: ['color', 'opacity', 'rule'],
    prefix: function (t, a) {
      return a === 'color' ? t : t + '-' + a
    }
  }

  // Add sugar for fill and stroke
  ;['fill', 'stroke'].forEach(function (m) {
    const extension = {};
    let i;

    extension[m] = function (o) {
      if (typeof o === 'undefined') {
        return this.attr(m)
      }
      if (
        typeof o === 'string' ||
        o instanceof Color ||
        Color.isRgb(o) ||
        o instanceof Element$1
      ) {
        this.attr(m, o);
      } else {
        // set all attributes from sugar.fill and sugar.stroke list
        for (i = sugar[m].length - 1; i >= 0; i--) {
          if (o[sugar[m][i]] != null) {
            this.attr(sugar.prefix(m, sugar[m][i]), o[sugar[m][i]]);
          }
        }
      }

      return this
    };

    registerMethods(['Element', 'Runner'], extension);
  });

  registerMethods(['Element', 'Runner'], {
    // Let the user set the matrix directly
    matrix: function (mat, b, c, d, e, f) {
      // Act as a getter
      if (mat == null) {
        return new Matrix(this)
      }

      // Act as a setter, the user can pass a matrix or a set of numbers
      return this.attr('transform', new Matrix(mat, b, c, d, e, f))
    },

    // Map rotation to transform
    rotate: function (angle, cx, cy) {
      return this.transform({ rotate: angle, ox: cx, oy: cy }, true)
    },

    // Map skew to transform
    skew: function (x, y, cx, cy) {
      return arguments.length === 1 || arguments.length === 3
        ? this.transform({ skew: x, ox: y, oy: cx }, true)
        : this.transform({ skew: [x, y], ox: cx, oy: cy }, true)
    },

    shear: function (lam, cx, cy) {
      return this.transform({ shear: lam, ox: cx, oy: cy }, true)
    },

    // Map scale to transform
    scale: function (x, y, cx, cy) {
      return arguments.length === 1 || arguments.length === 3
        ? this.transform({ scale: x, ox: y, oy: cx }, true)
        : this.transform({ scale: [x, y], ox: cx, oy: cy }, true)
    },

    // Map translate to transform
    translate: function (x, y) {
      return this.transform({ translate: [x, y] }, true)
    },

    // Map relative translations to transform
    relative: function (x, y) {
      return this.transform({ relative: [x, y] }, true)
    },

    // Map flip to transform
    flip: function (direction = 'both', origin = 'center') {
      if ('xybothtrue'.indexOf(direction) === -1) {
        origin = direction;
        direction = 'both';
      }

      return this.transform({ flip: direction, origin: origin }, true)
    },

    // Opacity
    opacity: function (value) {
      return this.attr('opacity', value)
    }
  });

  registerMethods('radius', {
    // Add x and y radius
    radius: function (x, y = x) {
      const type = (this._element || this).type;
      return type === 'radialGradient'
        ? this.attr('r', new SVGNumber(x))
        : this.rx(x).ry(y)
    }
  });

  registerMethods('Path', {
    // Get path length
    length: function () {
      return this.node.getTotalLength()
    },
    // Get point at length
    pointAt: function (length) {
      return new Point(this.node.getPointAtLength(length))
    }
  });

  registerMethods(['Element', 'Runner'], {
    // Set font
    font: function (a, v) {
      if (typeof a === 'object') {
        for (v in a) this.font(v, a[v]);
        return this
      }

      return a === 'leading'
        ? this.leading(v)
        : a === 'anchor'
          ? this.attr('text-anchor', v)
          : a === 'size' ||
              a === 'family' ||
              a === 'weight' ||
              a === 'stretch' ||
              a === 'variant' ||
              a === 'style'
            ? this.attr('font-' + a, v)
            : this.attr(a, v)
    }
  });

  // Add events to elements
  const methods = [
    'click',
    'dblclick',
    'mousedown',
    'mouseup',
    'mouseover',
    'mouseout',
    'mousemove',
    'mouseenter',
    'mouseleave',
    'touchstart',
    'touchmove',
    'touchleave',
    'touchend',
    'touchcancel',
    'contextmenu',
    'wheel',
    'pointerdown',
    'pointermove',
    'pointerup',
    'pointerleave',
    'pointercancel'
  ].reduce(function (last, event) {
    // add event to Element
    const fn = function (f) {
      if (f === null) {
        this.off(event);
      } else {
        this.on(event, f);
      }
      return this
    };

    last[event] = fn;
    return last
  }, {});

  registerMethods('Element', methods);

  // Reset all transformations
  function untransform() {
    return this.attr('transform', null)
  }

  // merge the whole transformation chain into one matrix and returns it
  function matrixify() {
    const matrix = (this.attr('transform') || '')
      // split transformations
      .split(transforms)
      .slice(0, -1)
      .map(function (str) {
        // generate key => value pairs
        const kv = str.trim().split('(');
        return [
          kv[0],
          kv[1].split(delimiter).map(function (str) {
            return parseFloat(str)
          })
        ]
      })
      .reverse()
      // merge every transformation into one matrix
      .reduce(function (matrix, transform) {
        if (transform[0] === 'matrix') {
          return matrix.lmultiply(Matrix.fromArray(transform[1]))
        }
        return matrix[transform[0]].apply(matrix, transform[1])
      }, new Matrix());

    return matrix
  }

  // add an element to another parent without changing the visual representation on the screen
  function toParent(parent, i) {
    if (this === parent) return this

    if (isDescriptive(this.node)) return this.addTo(parent, i)

    const ctm = this.screenCTM();
    const pCtm = parent.screenCTM().inverse();

    this.addTo(parent, i).untransform().transform(pCtm.multiply(ctm));

    return this
  }

  // same as above with parent equals root-svg
  function toRoot(i) {
    return this.toParent(this.root(), i)
  }

  // Add transformations
  function transform(o, relative) {
    // Act as a getter if no object was passed
    if (o == null || typeof o === 'string') {
      const decomposed = new Matrix(this).decompose();
      return o == null ? decomposed : decomposed[o]
    }

    if (!Matrix.isMatrixLike(o)) {
      // Set the origin according to the defined transform
      o = { ...o, origin: getOrigin(o, this) };
    }

    // The user can pass a boolean, an Element or an Matrix or nothing
    const cleanRelative = relative === true ? this : relative || false;
    const result = new Matrix(cleanRelative).transform(o);
    return this.attr('transform', result)
  }

  registerMethods('Element', {
    untransform,
    matrixify,
    toParent,
    toRoot,
    transform
  });

  class Container extends Element$1 {
    flatten() {
      this.each(function () {
        if (this instanceof Container) {
          return this.flatten().ungroup()
        }
      });

      return this
    }

    ungroup(parent = this.parent(), index = parent.index(this)) {
      // when parent != this, we want append all elements to the end
      index = index === -1 ? parent.children().length : index;

      this.each(function (i, children) {
        // reverse each
        return children[children.length - i - 1].toParent(parent, index)
      });

      return this.remove()
    }
  }

  register(Container, 'Container');

  class Defs extends Container {
    constructor(node, attrs = node) {
      super(nodeOrNew('defs', node), attrs);
    }

    flatten() {
      return this
    }

    ungroup() {
      return this
    }
  }

  register(Defs, 'Defs');

  class Shape extends Element$1 {}

  register(Shape, 'Shape');

  // Radius x value
  function rx(rx) {
    return this.attr('rx', rx)
  }

  // Radius y value
  function ry(ry) {
    return this.attr('ry', ry)
  }

  // Move over x-axis
  function x$3(x) {
    return x == null ? this.cx() - this.rx() : this.cx(x + this.rx())
  }

  // Move over y-axis
  function y$3(y) {
    return y == null ? this.cy() - this.ry() : this.cy(y + this.ry())
  }

  // Move by center over x-axis
  function cx$1(x) {
    return this.attr('cx', x)
  }

  // Move by center over y-axis
  function cy$1(y) {
    return this.attr('cy', y)
  }

  // Set width of element
  function width$2(width) {
    return width == null ? this.rx() * 2 : this.rx(new SVGNumber(width).divide(2))
  }

  // Set height of element
  function height$2(height) {
    return height == null
      ? this.ry() * 2
      : this.ry(new SVGNumber(height).divide(2))
  }

  var circled = /*#__PURE__*/Object.freeze({
    __proto__: null,
    cx: cx$1,
    cy: cy$1,
    height: height$2,
    rx: rx,
    ry: ry,
    width: width$2,
    x: x$3,
    y: y$3
  });

  class Ellipse extends Shape {
    constructor(node, attrs = node) {
      super(nodeOrNew('ellipse', node), attrs);
    }

    size(width, height) {
      const p = proportionalSize(this, width, height);

      return this.rx(new SVGNumber(p.width).divide(2)).ry(
        new SVGNumber(p.height).divide(2)
      )
    }
  }

  extend(Ellipse, circled);

  registerMethods('Container', {
    // Create an ellipse
    ellipse: wrapWithAttrCheck(function (width = 0, height = width) {
      return this.put(new Ellipse()).size(width, height).move(0, 0)
    })
  });

  register(Ellipse, 'Ellipse');

  class Fragment extends Dom {
    constructor(node = globals.document.createDocumentFragment()) {
      super(node);
    }

    // Import / Export raw xml
    xml(xmlOrFn, outerXML, ns) {
      if (typeof xmlOrFn === 'boolean') {
        ns = outerXML;
        outerXML = xmlOrFn;
        xmlOrFn = null;
      }

      // because this is a fragment we have to put all elements into a wrapper first
      // before we can get the innerXML from it
      if (xmlOrFn == null || typeof xmlOrFn === 'function') {
        const wrapper = new Dom(create('wrapper', ns));
        wrapper.add(this.node.cloneNode(true));

        return wrapper.xml(false, ns)
      }

      // Act as setter if we got a string
      return super.xml(xmlOrFn, false, ns)
    }
  }

  register(Fragment, 'Fragment');

  function from(x, y) {
    return (this._element || this).type === 'radialGradient'
      ? this.attr({ fx: new SVGNumber(x), fy: new SVGNumber(y) })
      : this.attr({ x1: new SVGNumber(x), y1: new SVGNumber(y) })
  }

  function to(x, y) {
    return (this._element || this).type === 'radialGradient'
      ? this.attr({ cx: new SVGNumber(x), cy: new SVGNumber(y) })
      : this.attr({ x2: new SVGNumber(x), y2: new SVGNumber(y) })
  }

  var gradiented = /*#__PURE__*/Object.freeze({
    __proto__: null,
    from: from,
    to: to
  });

  class Gradient extends Container {
    constructor(type, attrs) {
      super(
        nodeOrNew(type + 'Gradient', typeof type === 'string' ? null : type),
        attrs
      );
    }

    // custom attr to handle transform
    attr(a, b, c) {
      if (a === 'transform') a = 'gradientTransform';
      return super.attr(a, b, c)
    }

    bbox() {
      return new Box()
    }

    targets() {
      return baseFind('svg [fill*=' + this.id() + ']')
    }

    // Alias string conversion to fill
    toString() {
      return this.url()
    }

    // Update gradient
    update(block) {
      // remove all stops
      this.clear();

      // invoke passed block
      if (typeof block === 'function') {
        block.call(this, this);
      }

      return this
    }

    // Return the fill id
    url() {
      return 'url(#' + this.id() + ')'
    }
  }

  extend(Gradient, gradiented);

  registerMethods({
    Container: {
      // Create gradient element in defs
      gradient(...args) {
        return this.defs().gradient(...args)
      }
    },
    // define gradient
    Defs: {
      gradient: wrapWithAttrCheck(function (type, block) {
        return this.put(new Gradient(type)).update(block)
      })
    }
  });

  register(Gradient, 'Gradient');

  class Pattern extends Container {
    // Initialize node
    constructor(node, attrs = node) {
      super(nodeOrNew('pattern', node), attrs);
    }

    // custom attr to handle transform
    attr(a, b, c) {
      if (a === 'transform') a = 'patternTransform';
      return super.attr(a, b, c)
    }

    bbox() {
      return new Box()
    }

    targets() {
      return baseFind('svg [fill*=' + this.id() + ']')
    }

    // Alias string conversion to fill
    toString() {
      return this.url()
    }

    // Update pattern by rebuilding
    update(block) {
      // remove content
      this.clear();

      // invoke passed block
      if (typeof block === 'function') {
        block.call(this, this);
      }

      return this
    }

    // Return the fill id
    url() {
      return 'url(#' + this.id() + ')'
    }
  }

  registerMethods({
    Container: {
      // Create pattern element in defs
      pattern(...args) {
        return this.defs().pattern(...args)
      }
    },
    Defs: {
      pattern: wrapWithAttrCheck(function (width, height, block) {
        return this.put(new Pattern()).update(block).attr({
          x: 0,
          y: 0,
          width: width,
          height: height,
          patternUnits: 'userSpaceOnUse'
        })
      })
    }
  });

  register(Pattern, 'Pattern');

  let Image$1 = class Image extends Shape {
    constructor(node, attrs = node) {
      super(nodeOrNew('image', node), attrs);
    }

    // (re)load image
    load(url, callback) {
      if (!url) return this

      const img = new globals.window.Image();

      on(
        img,
        'load',
        function (e) {
          const p = this.parent(Pattern);

          // ensure image size
          if (this.width() === 0 && this.height() === 0) {
            this.size(img.width, img.height);
          }

          if (p instanceof Pattern) {
            // ensure pattern size if not set
            if (p.width() === 0 && p.height() === 0) {
              p.size(this.width(), this.height());
            }
          }

          if (typeof callback === 'function') {
            callback.call(this, e);
          }
        },
        this
      );

      on(img, 'load error', function () {
        // dont forget to unbind memory leaking events
        off(img);
      });

      return this.attr('href', (img.src = url), xlink)
    }
  };

  registerAttrHook(function (attr, val, _this) {
    // convert image fill and stroke to patterns
    if (attr === 'fill' || attr === 'stroke') {
      if (isImage.test(val)) {
        val = _this.root().defs().image(val);
      }
    }

    if (val instanceof Image$1) {
      val = _this
        .root()
        .defs()
        .pattern(0, 0, (pattern) => {
          pattern.add(val);
        });
    }

    return val
  });

  registerMethods({
    Container: {
      // create image element, load image and set its size
      image: wrapWithAttrCheck(function (source, callback) {
        return this.put(new Image$1()).size(0, 0).load(source, callback)
      })
    }
  });

  register(Image$1, 'Image');

  class PointArray extends SVGArray {
    // Get bounding box of points
    bbox() {
      let maxX = -Infinity;
      let maxY = -Infinity;
      let minX = Infinity;
      let minY = Infinity;
      this.forEach(function (el) {
        maxX = Math.max(el[0], maxX);
        maxY = Math.max(el[1], maxY);
        minX = Math.min(el[0], minX);
        minY = Math.min(el[1], minY);
      });
      return new Box(minX, minY, maxX - minX, maxY - minY)
    }

    // Move point string
    move(x, y) {
      const box = this.bbox();

      // get relative offset
      x -= box.x;
      y -= box.y;

      // move every point
      if (!isNaN(x) && !isNaN(y)) {
        for (let i = this.length - 1; i >= 0; i--) {
          this[i] = [this[i][0] + x, this[i][1] + y];
        }
      }

      return this
    }

    // Parse point string and flat array
    parse(array = [0, 0]) {
      const points = [];

      // if it is an array, we flatten it and therefore clone it to 1 depths
      if (array instanceof Array) {
        array = Array.prototype.concat.apply([], array);
      } else {
        // Else, it is considered as a string
        // parse points
        array = array.trim().split(delimiter).map(parseFloat);
      }

      // validate points - https://svgwg.org/svg2-draft/shapes.html#DataTypePoints
      // Odd number of coordinates is an error. In such cases, drop the last odd coordinate.
      if (array.length % 2 !== 0) array.pop();

      // wrap points in two-tuples
      for (let i = 0, len = array.length; i < len; i = i + 2) {
        points.push([array[i], array[i + 1]]);
      }

      return points
    }

    // Resize poly string
    size(width, height) {
      let i;
      const box = this.bbox();

      // recalculate position of all points according to new size
      for (i = this.length - 1; i >= 0; i--) {
        if (box.width)
          this[i][0] = ((this[i][0] - box.x) * width) / box.width + box.x;
        if (box.height)
          this[i][1] = ((this[i][1] - box.y) * height) / box.height + box.y;
      }

      return this
    }

    // Convert array to line object
    toLine() {
      return {
        x1: this[0][0],
        y1: this[0][1],
        x2: this[1][0],
        y2: this[1][1]
      }
    }

    // Convert array to string
    toString() {
      const array = [];
      // convert to a poly point string
      for (let i = 0, il = this.length; i < il; i++) {
        array.push(this[i].join(','));
      }

      return array.join(' ')
    }

    transform(m) {
      return this.clone().transformO(m)
    }

    // transform points with matrix (similar to Point.transform)
    transformO(m) {
      if (!Matrix.isMatrixLike(m)) {
        m = new Matrix(m);
      }

      for (let i = this.length; i--; ) {
        // Perform the matrix multiplication
        const [x, y] = this[i];
        this[i][0] = m.a * x + m.c * y + m.e;
        this[i][1] = m.b * x + m.d * y + m.f;
      }

      return this
    }
  }

  const MorphArray = PointArray;

  // Move by left top corner over x-axis
  function x$2(x) {
    return x == null ? this.bbox().x : this.move(x, this.bbox().y)
  }

  // Move by left top corner over y-axis
  function y$2(y) {
    return y == null ? this.bbox().y : this.move(this.bbox().x, y)
  }

  // Set width of element
  function width$1(width) {
    const b = this.bbox();
    return width == null ? b.width : this.size(width, b.height)
  }

  // Set height of element
  function height$1(height) {
    const b = this.bbox();
    return height == null ? b.height : this.size(b.width, height)
  }

  var pointed = /*#__PURE__*/Object.freeze({
    __proto__: null,
    MorphArray: MorphArray,
    height: height$1,
    width: width$1,
    x: x$2,
    y: y$2
  });

  let Line$1 = class Line extends Shape {
    // Initialize node
    constructor(node, attrs = node) {
      super(nodeOrNew('line', node), attrs);
    }

    // Get array
    array() {
      return new PointArray([
        [this.attr('x1'), this.attr('y1')],
        [this.attr('x2'), this.attr('y2')]
      ])
    }

    // Move by left top corner
    move(x, y) {
      return this.attr(this.array().move(x, y).toLine())
    }

    // Overwrite native plot() method
    plot(x1, y1, x2, y2) {
      if (x1 == null) {
        return this.array()
      } else if (typeof y1 !== 'undefined') {
        x1 = { x1, y1, x2, y2 };
      } else {
        x1 = new PointArray(x1).toLine();
      }

      return this.attr(x1)
    }

    // Set element size to given width and height
    size(width, height) {
      const p = proportionalSize(this, width, height);
      return this.attr(this.array().size(p.width, p.height).toLine())
    }
  };

  extend(Line$1, pointed);

  registerMethods({
    Container: {
      // Create a line element
      line: wrapWithAttrCheck(function (...args) {
        // make sure plot is called as a setter
        // x1 is not necessarily a number, it can also be an array, a string and a PointArray
        return Line$1.prototype.plot.apply(
          this.put(new Line$1()),
          args[0] != null ? args : [0, 0, 0, 0]
        )
      })
    }
  });

  register(Line$1, 'Line');

  let Marker$1 = class Marker extends Container {
    // Initialize node
    constructor(node, attrs = node) {
      super(nodeOrNew('marker', node), attrs);
    }

    // Set height of element
    height(height) {
      return this.attr('markerHeight', height)
    }

    orient(orient) {
      return this.attr('orient', orient)
    }

    // Set marker refX and refY
    ref(x, y) {
      return this.attr('refX', x).attr('refY', y)
    }

    // Return the fill id
    toString() {
      return 'url(#' + this.id() + ')'
    }

    // Update marker
    update(block) {
      // remove all content
      this.clear();

      // invoke passed block
      if (typeof block === 'function') {
        block.call(this, this);
      }

      return this
    }

    // Set width of element
    width(width) {
      return this.attr('markerWidth', width)
    }
  };

  registerMethods({
    Container: {
      marker(...args) {
        // Create marker element in defs
        return this.defs().marker(...args)
      }
    },
    Defs: {
      // Create marker
      marker: wrapWithAttrCheck(function (width, height, block) {
        // Set default viewbox to match the width and height, set ref to cx and cy and set orient to auto
        return this.put(new Marker$1())
          .size(width, height)
          .ref(width / 2, height / 2)
          .viewbox(0, 0, width, height)
          .attr('orient', 'auto')
          .update(block)
      })
    },
    marker: {
      // Create and attach markers
      marker(marker, width, height, block) {
        let attr = ['marker'];

        // Build attribute name
        if (marker !== 'all') attr.push(marker);
        attr = attr.join('-');

        // Set marker attribute
        marker =
          arguments[1] instanceof Marker$1
            ? arguments[1]
            : this.defs().marker(width, height, block);

        return this.attr(attr, marker)
      }
    }
  });

  register(Marker$1, 'Marker');

  /***
  Base Class
  ==========
  The base stepper class that will be
  ***/

  function makeSetterGetter(k, f) {
    return function (v) {
      if (v == null) return this[k]
      this[k] = v;
      if (f) f.call(this);
      return this
    }
  }

  const easing = {
    '-': function (pos) {
      return pos
    },
    '<>': function (pos) {
      return -Math.cos(pos * Math.PI) / 2 + 0.5
    },
    '>': function (pos) {
      return Math.sin((pos * Math.PI) / 2)
    },
    '<': function (pos) {
      return -Math.cos((pos * Math.PI) / 2) + 1
    },
    bezier: function (x1, y1, x2, y2) {
      // see https://www.w3.org/TR/css-easing-1/#cubic-bezier-algo
      return function (t) {
        if (t < 0) {
          if (x1 > 0) {
            return (y1 / x1) * t
          } else if (x2 > 0) {
            return (y2 / x2) * t
          } else {
            return 0
          }
        } else if (t > 1) {
          if (x2 < 1) {
            return ((1 - y2) / (1 - x2)) * t + (y2 - x2) / (1 - x2)
          } else if (x1 < 1) {
            return ((1 - y1) / (1 - x1)) * t + (y1 - x1) / (1 - x1)
          } else {
            return 1
          }
        } else {
          return 3 * t * (1 - t) ** 2 * y1 + 3 * t ** 2 * (1 - t) * y2 + t ** 3
        }
      }
    },
    // see https://www.w3.org/TR/css-easing-1/#step-timing-function-algo
    steps: function (steps, stepPosition = 'end') {
      // deal with "jump-" prefix
      stepPosition = stepPosition.split('-').reverse()[0];

      let jumps = steps;
      if (stepPosition === 'none') {
        --jumps;
      } else if (stepPosition === 'both') {
        ++jumps;
      }

      // The beforeFlag is essentially useless
      return (t, beforeFlag = false) => {
        // Step is called currentStep in referenced url
        let step = Math.floor(t * steps);
        const jumping = (t * step) % 1 === 0;

        if (stepPosition === 'start' || stepPosition === 'both') {
          ++step;
        }

        if (beforeFlag && jumping) {
          --step;
        }

        if (t >= 0 && step < 0) {
          step = 0;
        }

        if (t <= 1 && step > jumps) {
          step = jumps;
        }

        return step / jumps
      }
    }
  };

  class Stepper {
    done() {
      return false
    }
  }

  /***
  Easing Functions
  ================
  ***/

  class Ease extends Stepper {
    constructor(fn = timeline.ease) {
      super();
      this.ease = easing[fn] || fn;
    }

    step(from, to, pos) {
      if (typeof from !== 'number') {
        return pos < 1 ? from : to
      }
      return from + (to - from) * this.ease(pos)
    }
  }

  /***
  Controller Types
  ================
  ***/

  class Controller extends Stepper {
    constructor(fn) {
      super();
      this.stepper = fn;
    }

    done(c) {
      return c.done
    }

    step(current, target, dt, c) {
      return this.stepper(current, target, dt, c)
    }
  }

  function recalculate() {
    // Apply the default parameters
    const duration = (this._duration || 500) / 1000;
    const overshoot = this._overshoot || 0;

    // Calculate the PID natural response
    const eps = 1e-10;
    const pi = Math.PI;
    const os = Math.log(overshoot / 100 + eps);
    const zeta = -os / Math.sqrt(pi * pi + os * os);
    const wn = 3.9 / (zeta * duration);

    // Calculate the Spring values
    this.d = 2 * zeta * wn;
    this.k = wn * wn;
  }

  class Spring extends Controller {
    constructor(duration = 500, overshoot = 0) {
      super();
      this.duration(duration).overshoot(overshoot);
    }

    step(current, target, dt, c) {
      if (typeof current === 'string') return current
      c.done = dt === Infinity;
      if (dt === Infinity) return target
      if (dt === 0) return current

      if (dt > 100) dt = 16;

      dt /= 1000;

      // Get the previous velocity
      const velocity = c.velocity || 0;

      // Apply the control to get the new position and store it
      const acceleration = -this.d * velocity - this.k * (current - target);
      const newPosition = current + velocity * dt + (acceleration * dt * dt) / 2;

      // Store the velocity
      c.velocity = velocity + acceleration * dt;

      // Figure out if we have converged, and if so, pass the value
      c.done = Math.abs(target - newPosition) + Math.abs(velocity) < 0.002;
      return c.done ? target : newPosition
    }
  }

  extend(Spring, {
    duration: makeSetterGetter('_duration', recalculate),
    overshoot: makeSetterGetter('_overshoot', recalculate)
  });

  class PID extends Controller {
    constructor(p = 0.1, i = 0.01, d = 0, windup = 1000) {
      super();
      this.p(p).i(i).d(d).windup(windup);
    }

    step(current, target, dt, c) {
      if (typeof current === 'string') return current
      c.done = dt === Infinity;

      if (dt === Infinity) return target
      if (dt === 0) return current

      const p = target - current;
      let i = (c.integral || 0) + p * dt;
      const d = (p - (c.error || 0)) / dt;
      const windup = this._windup;

      // antiwindup
      if (windup !== false) {
        i = Math.max(-windup, Math.min(i, windup));
      }

      c.error = p;
      c.integral = i;

      c.done = Math.abs(p) < 0.001;

      return c.done ? target : current + (this.P * p + this.I * i + this.D * d)
    }
  }

  extend(PID, {
    windup: makeSetterGetter('_windup'),
    p: makeSetterGetter('P'),
    i: makeSetterGetter('I'),
    d: makeSetterGetter('D')
  });

  const segmentParameters = {
    M: 2,
    L: 2,
    H: 1,
    V: 1,
    C: 6,
    S: 4,
    Q: 4,
    T: 2,
    A: 7,
    Z: 0
  };

  const pathHandlers = {
    M: function (c, p, p0) {
      p.x = p0.x = c[0];
      p.y = p0.y = c[1];

      return ['M', p.x, p.y]
    },
    L: function (c, p) {
      p.x = c[0];
      p.y = c[1];
      return ['L', c[0], c[1]]
    },
    H: function (c, p) {
      p.x = c[0];
      return ['H', c[0]]
    },
    V: function (c, p) {
      p.y = c[0];
      return ['V', c[0]]
    },
    C: function (c, p) {
      p.x = c[4];
      p.y = c[5];
      return ['C', c[0], c[1], c[2], c[3], c[4], c[5]]
    },
    S: function (c, p) {
      p.x = c[2];
      p.y = c[3];
      return ['S', c[0], c[1], c[2], c[3]]
    },
    Q: function (c, p) {
      p.x = c[2];
      p.y = c[3];
      return ['Q', c[0], c[1], c[2], c[3]]
    },
    T: function (c, p) {
      p.x = c[0];
      p.y = c[1];
      return ['T', c[0], c[1]]
    },
    Z: function (c, p, p0) {
      p.x = p0.x;
      p.y = p0.y;
      return ['Z']
    },
    A: function (c, p) {
      p.x = c[5];
      p.y = c[6];
      return ['A', c[0], c[1], c[2], c[3], c[4], c[5], c[6]]
    }
  };

  const mlhvqtcsaz = 'mlhvqtcsaz'.split('');

  for (let i = 0, il = mlhvqtcsaz.length; i < il; ++i) {
    pathHandlers[mlhvqtcsaz[i]] = (function (i) {
      return function (c, p, p0) {
        if (i === 'H') c[0] = c[0] + p.x;
        else if (i === 'V') c[0] = c[0] + p.y;
        else if (i === 'A') {
          c[5] = c[5] + p.x;
          c[6] = c[6] + p.y;
        } else {
          for (let j = 0, jl = c.length; j < jl; ++j) {
            c[j] = c[j] + (j % 2 ? p.y : p.x);
          }
        }

        return pathHandlers[i](c, p, p0)
      }
    })(mlhvqtcsaz[i].toUpperCase());
  }

  function makeAbsolut(parser) {
    const command = parser.segment[0];
    return pathHandlers[command](parser.segment.slice(1), parser.p, parser.p0)
  }

  function segmentComplete(parser) {
    return (
      parser.segment.length &&
      parser.segment.length - 1 ===
        segmentParameters[parser.segment[0].toUpperCase()]
    )
  }

  function startNewSegment(parser, token) {
    parser.inNumber && finalizeNumber(parser, false);
    const pathLetter = isPathLetter.test(token);

    if (pathLetter) {
      parser.segment = [token];
    } else {
      const lastCommand = parser.lastCommand;
      const small = lastCommand.toLowerCase();
      const isSmall = lastCommand === small;
      parser.segment = [small === 'm' ? (isSmall ? 'l' : 'L') : lastCommand];
    }

    parser.inSegment = true;
    parser.lastCommand = parser.segment[0];

    return pathLetter
  }

  function finalizeNumber(parser, inNumber) {
    if (!parser.inNumber) throw new Error('Parser Error')
    parser.number && parser.segment.push(parseFloat(parser.number));
    parser.inNumber = inNumber;
    parser.number = '';
    parser.pointSeen = false;
    parser.hasExponent = false;

    if (segmentComplete(parser)) {
      finalizeSegment(parser);
    }
  }

  function finalizeSegment(parser) {
    parser.inSegment = false;
    if (parser.absolute) {
      parser.segment = makeAbsolut(parser);
    }
    parser.segments.push(parser.segment);
  }

  function isArcFlag(parser) {
    if (!parser.segment.length) return false
    const isArc = parser.segment[0].toUpperCase() === 'A';
    const length = parser.segment.length;

    return isArc && (length === 4 || length === 5)
  }

  function isExponential(parser) {
    return parser.lastToken.toUpperCase() === 'E'
  }

  const pathDelimiters = new Set([' ', ',', '\t', '\n', '\r', '\f']);
  function pathParser(d, toAbsolute = true) {
    let index = 0;
    let token = '';
    const parser = {
      segment: [],
      inNumber: false,
      number: '',
      lastToken: '',
      inSegment: false,
      segments: [],
      pointSeen: false,
      hasExponent: false,
      absolute: toAbsolute,
      p0: new Point(),
      p: new Point()
    };

    while (((parser.lastToken = token), (token = d.charAt(index++)))) {
      if (!parser.inSegment) {
        if (startNewSegment(parser, token)) {
          continue
        }
      }

      if (token === '.') {
        if (parser.pointSeen || parser.hasExponent) {
          finalizeNumber(parser, false);
          --index;
          continue
        }
        parser.inNumber = true;
        parser.pointSeen = true;
        parser.number += token;
        continue
      }

      if (!isNaN(parseInt(token))) {
        if (parser.number === '0' || isArcFlag(parser)) {
          parser.inNumber = true;
          parser.number = token;
          finalizeNumber(parser, true);
          continue
        }

        parser.inNumber = true;
        parser.number += token;
        continue
      }

      if (pathDelimiters.has(token)) {
        if (parser.inNumber) {
          finalizeNumber(parser, false);
        }
        continue
      }

      if (token === '-' || token === '+') {
        if (parser.inNumber && !isExponential(parser)) {
          finalizeNumber(parser, false);
          --index;
          continue
        }
        parser.number += token;
        parser.inNumber = true;
        continue
      }

      if (token.toUpperCase() === 'E') {
        parser.number += token;
        parser.hasExponent = true;
        continue
      }

      if (isPathLetter.test(token)) {
        if (parser.inNumber) {
          finalizeNumber(parser, false);
        } else if (!segmentComplete(parser)) {
          throw new Error('parser Error')
        } else {
          finalizeSegment(parser);
        }
        --index;
      }
    }

    if (parser.inNumber) {
      finalizeNumber(parser, false);
    }

    if (parser.inSegment && segmentComplete(parser)) {
      finalizeSegment(parser);
    }

    return parser.segments
  }

  function arrayToString(a) {
    let s = '';
    for (let i = 0, il = a.length; i < il; i++) {
      s += a[i][0];

      if (a[i][1] != null) {
        s += a[i][1];

        if (a[i][2] != null) {
          s += ' ';
          s += a[i][2];

          if (a[i][3] != null) {
            s += ' ';
            s += a[i][3];
            s += ' ';
            s += a[i][4];

            if (a[i][5] != null) {
              s += ' ';
              s += a[i][5];
              s += ' ';
              s += a[i][6];

              if (a[i][7] != null) {
                s += ' ';
                s += a[i][7];
              }
            }
          }
        }
      }
    }

    return s + ' '
  }

  class PathArray extends SVGArray {
    // Get bounding box of path
    bbox() {
      parser().path.setAttribute('d', this.toString());
      return new Box(parser.nodes.path.getBBox())
    }

    // Move path string
    move(x, y) {
      // get bounding box of current situation
      const box = this.bbox();

      // get relative offset
      x -= box.x;
      y -= box.y;

      if (!isNaN(x) && !isNaN(y)) {
        // move every point
        for (let l, i = this.length - 1; i >= 0; i--) {
          l = this[i][0];

          if (l === 'M' || l === 'L' || l === 'T') {
            this[i][1] += x;
            this[i][2] += y;
          } else if (l === 'H') {
            this[i][1] += x;
          } else if (l === 'V') {
            this[i][1] += y;
          } else if (l === 'C' || l === 'S' || l === 'Q') {
            this[i][1] += x;
            this[i][2] += y;
            this[i][3] += x;
            this[i][4] += y;

            if (l === 'C') {
              this[i][5] += x;
              this[i][6] += y;
            }
          } else if (l === 'A') {
            this[i][6] += x;
            this[i][7] += y;
          }
        }
      }

      return this
    }

    // Absolutize and parse path to array
    parse(d = 'M0 0') {
      if (Array.isArray(d)) {
        d = Array.prototype.concat.apply([], d).toString();
      }

      return pathParser(d)
    }

    // Resize path string
    size(width, height) {
      // get bounding box of current situation
      const box = this.bbox();
      let i, l;

      // If the box width or height is 0 then we ignore
      // transformations on the respective axis
      box.width = box.width === 0 ? 1 : box.width;
      box.height = box.height === 0 ? 1 : box.height;

      // recalculate position of all points according to new size
      for (i = this.length - 1; i >= 0; i--) {
        l = this[i][0];

        if (l === 'M' || l === 'L' || l === 'T') {
          this[i][1] = ((this[i][1] - box.x) * width) / box.width + box.x;
          this[i][2] = ((this[i][2] - box.y) * height) / box.height + box.y;
        } else if (l === 'H') {
          this[i][1] = ((this[i][1] - box.x) * width) / box.width + box.x;
        } else if (l === 'V') {
          this[i][1] = ((this[i][1] - box.y) * height) / box.height + box.y;
        } else if (l === 'C' || l === 'S' || l === 'Q') {
          this[i][1] = ((this[i][1] - box.x) * width) / box.width + box.x;
          this[i][2] = ((this[i][2] - box.y) * height) / box.height + box.y;
          this[i][3] = ((this[i][3] - box.x) * width) / box.width + box.x;
          this[i][4] = ((this[i][4] - box.y) * height) / box.height + box.y;

          if (l === 'C') {
            this[i][5] = ((this[i][5] - box.x) * width) / box.width + box.x;
            this[i][6] = ((this[i][6] - box.y) * height) / box.height + box.y;
          }
        } else if (l === 'A') {
          // resize radii
          this[i][1] = (this[i][1] * width) / box.width;
          this[i][2] = (this[i][2] * height) / box.height;

          // move position values
          this[i][6] = ((this[i][6] - box.x) * width) / box.width + box.x;
          this[i][7] = ((this[i][7] - box.y) * height) / box.height + box.y;
        }
      }

      return this
    }

    // Convert array to string
    toString() {
      return arrayToString(this)
    }
  }

  const getClassForType = (value) => {
    const type = typeof value;

    if (type === 'number') {
      return SVGNumber
    } else if (type === 'string') {
      if (Color.isColor(value)) {
        return Color
      } else if (delimiter.test(value)) {
        return isPathLetter.test(value) ? PathArray : SVGArray
      } else if (numberAndUnit.test(value)) {
        return SVGNumber
      } else {
        return NonMorphable
      }
    } else if (morphableTypes.indexOf(value.constructor) > -1) {
      return value.constructor
    } else if (Array.isArray(value)) {
      return SVGArray
    } else if (type === 'object') {
      return ObjectBag
    } else {
      return NonMorphable
    }
  };

  class Morphable {
    constructor(stepper) {
      this._stepper = stepper || new Ease('-');

      this._from = null;
      this._to = null;
      this._type = null;
      this._context = null;
      this._morphObj = null;
    }

    at(pos) {
      return this._morphObj.morph(
        this._from,
        this._to,
        pos,
        this._stepper,
        this._context
      )
    }

    done() {
      const complete = this._context.map(this._stepper.done).reduce(function (
        last,
        curr
      ) {
        return last && curr
      }, true);
      return complete
    }

    from(val) {
      if (val == null) {
        return this._from
      }

      this._from = this._set(val);
      return this
    }

    stepper(stepper) {
      if (stepper == null) return this._stepper
      this._stepper = stepper;
      return this
    }

    to(val) {
      if (val == null) {
        return this._to
      }

      this._to = this._set(val);
      return this
    }

    type(type) {
      // getter
      if (type == null) {
        return this._type
      }

      // setter
      this._type = type;
      return this
    }

    _set(value) {
      if (!this._type) {
        this.type(getClassForType(value));
      }

      let result = new this._type(value);
      if (this._type === Color) {
        result = this._to
          ? result[this._to[4]]()
          : this._from
            ? result[this._from[4]]()
            : result;
      }

      if (this._type === ObjectBag) {
        result = this._to
          ? result.align(this._to)
          : this._from
            ? result.align(this._from)
            : result;
      }

      result = result.toConsumable();

      this._morphObj = this._morphObj || new this._type();
      this._context =
        this._context ||
        Array.apply(null, Array(result.length))
          .map(Object)
          .map(function (o) {
            o.done = true;
            return o
          });
      return result
    }
  }

  class NonMorphable {
    constructor(...args) {
      this.init(...args);
    }

    init(val) {
      val = Array.isArray(val) ? val[0] : val;
      this.value = val;
      return this
    }

    toArray() {
      return [this.value]
    }

    valueOf() {
      return this.value
    }
  }

  class TransformBag {
    constructor(...args) {
      this.init(...args);
    }

    init(obj) {
      if (Array.isArray(obj)) {
        obj = {
          scaleX: obj[0],
          scaleY: obj[1],
          shear: obj[2],
          rotate: obj[3],
          translateX: obj[4],
          translateY: obj[5],
          originX: obj[6],
          originY: obj[7]
        };
      }

      Object.assign(this, TransformBag.defaults, obj);
      return this
    }

    toArray() {
      const v = this;

      return [
        v.scaleX,
        v.scaleY,
        v.shear,
        v.rotate,
        v.translateX,
        v.translateY,
        v.originX,
        v.originY
      ]
    }
  }

  TransformBag.defaults = {
    scaleX: 1,
    scaleY: 1,
    shear: 0,
    rotate: 0,
    translateX: 0,
    translateY: 0,
    originX: 0,
    originY: 0
  };

  const sortByKey = (a, b) => {
    return a[0] < b[0] ? -1 : a[0] > b[0] ? 1 : 0
  };

  class ObjectBag {
    constructor(...args) {
      this.init(...args);
    }

    align(other) {
      const values = this.values;
      for (let i = 0, il = values.length; i < il; ++i) {
        // If the type is the same we only need to check if the color is in the correct format
        if (values[i + 1] === other[i + 1]) {
          if (values[i + 1] === Color && other[i + 7] !== values[i + 7]) {
            const space = other[i + 7];
            const color = new Color(this.values.splice(i + 3, 5))
              [space]()
              .toArray();
            this.values.splice(i + 3, 0, ...color);
          }

          i += values[i + 2] + 2;
          continue
        }

        if (!other[i + 1]) {
          return this
        }

        // The types differ, so we overwrite the new type with the old one
        // And initialize it with the types default (e.g. black for color or 0 for number)
        const defaultObject = new other[i + 1]().toArray();

        // Than we fix the values array
        const toDelete = values[i + 2] + 3;

        values.splice(
          i,
          toDelete,
          other[i],
          other[i + 1],
          other[i + 2],
          ...defaultObject
        );

        i += values[i + 2] + 2;
      }
      return this
    }

    init(objOrArr) {
      this.values = [];

      if (Array.isArray(objOrArr)) {
        this.values = objOrArr.slice();
        return
      }

      objOrArr = objOrArr || {};
      const entries = [];

      for (const i in objOrArr) {
        const Type = getClassForType(objOrArr[i]);
        const val = new Type(objOrArr[i]).toArray();
        entries.push([i, Type, val.length, ...val]);
      }

      entries.sort(sortByKey);

      this.values = entries.reduce((last, curr) => last.concat(curr), []);
      return this
    }

    toArray() {
      return this.values
    }

    valueOf() {
      const obj = {};
      const arr = this.values;

      // for (var i = 0, len = arr.length; i < len; i += 2) {
      while (arr.length) {
        const key = arr.shift();
        const Type = arr.shift();
        const num = arr.shift();
        const values = arr.splice(0, num);
        obj[key] = new Type(values); // .valueOf()
      }

      return obj
    }
  }

  const morphableTypes = [NonMorphable, TransformBag, ObjectBag];

  function registerMorphableType(type = []) {
    morphableTypes.push(...[].concat(type));
  }

  function makeMorphable() {
    extend(morphableTypes, {
      to(val) {
        return new Morphable()
          .type(this.constructor)
          .from(this.toArray()) // this.valueOf())
          .to(val)
      },
      fromArray(arr) {
        this.init(arr);
        return this
      },
      toConsumable() {
        return this.toArray()
      },
      morph(from, to, pos, stepper, context) {
        const mapper = function (i, index) {
          return stepper.step(i, to[index], pos, context[index], context)
        };

        return this.fromArray(from.map(mapper))
      }
    });
  }

  class Path extends Shape {
    // Initialize node
    constructor(node, attrs = node) {
      super(nodeOrNew('path', node), attrs);
    }

    // Get array
    array() {
      return this._array || (this._array = new PathArray(this.attr('d')))
    }

    // Clear array cache
    clear() {
      delete this._array;
      return this
    }

    // Set height of element
    height(height) {
      return height == null
        ? this.bbox().height
        : this.size(this.bbox().width, height)
    }

    // Move by left top corner
    move(x, y) {
      return this.attr('d', this.array().move(x, y))
    }

    // Plot new path
    plot(d) {
      return d == null
        ? this.array()
        : this.clear().attr(
            'd',
            typeof d === 'string' ? d : (this._array = new PathArray(d))
          )
    }

    // Set element size to given width and height
    size(width, height) {
      const p = proportionalSize(this, width, height);
      return this.attr('d', this.array().size(p.width, p.height))
    }

    // Set width of element
    width(width) {
      return width == null
        ? this.bbox().width
        : this.size(width, this.bbox().height)
    }

    // Move by left top corner over x-axis
    x(x) {
      return x == null ? this.bbox().x : this.move(x, this.bbox().y)
    }

    // Move by left top corner over y-axis
    y(y) {
      return y == null ? this.bbox().y : this.move(this.bbox().x, y)
    }
  }

  // Define morphable array
  Path.prototype.MorphArray = PathArray;

  // Add parent method
  registerMethods({
    Container: {
      // Create a wrapped path element
      path: wrapWithAttrCheck(function (d) {
        // make sure plot is called as a setter
        return this.put(new Path()).plot(d || new PathArray())
      })
    }
  });

  register(Path, 'Path');

  // Get array
  function array() {
    return this._array || (this._array = new PointArray(this.attr('points')))
  }

  // Clear array cache
  function clear() {
    delete this._array;
    return this
  }

  // Move by left top corner
  function move$2(x, y) {
    return this.attr('points', this.array().move(x, y))
  }

  // Plot new path
  function plot(p) {
    return p == null
      ? this.array()
      : this.clear().attr(
          'points',
          typeof p === 'string' ? p : (this._array = new PointArray(p))
        )
  }

  // Set element size to given width and height
  function size$1(width, height) {
    const p = proportionalSize(this, width, height);
    return this.attr('points', this.array().size(p.width, p.height))
  }

  var poly = /*#__PURE__*/Object.freeze({
    __proto__: null,
    array: array,
    clear: clear,
    move: move$2,
    plot: plot,
    size: size$1
  });

  class Polygon extends Shape {
    // Initialize node
    constructor(node, attrs = node) {
      super(nodeOrNew('polygon', node), attrs);
    }
  }

  registerMethods({
    Container: {
      // Create a wrapped polygon element
      polygon: wrapWithAttrCheck(function (p) {
        // make sure plot is called as a setter
        return this.put(new Polygon()).plot(p || new PointArray())
      })
    }
  });

  extend(Polygon, pointed);
  extend(Polygon, poly);
  register(Polygon, 'Polygon');

  class Polyline extends Shape {
    // Initialize node
    constructor(node, attrs = node) {
      super(nodeOrNew('polyline', node), attrs);
    }
  }

  registerMethods({
    Container: {
      // Create a wrapped polygon element
      polyline: wrapWithAttrCheck(function (p) {
        // make sure plot is called as a setter
        return this.put(new Polyline()).plot(p || new PointArray())
      })
    }
  });

  extend(Polyline, pointed);
  extend(Polyline, poly);
  register(Polyline, 'Polyline');

  class Rect extends Shape {
    // Initialize node
    constructor(node, attrs = node) {
      super(nodeOrNew('rect', node), attrs);
    }
  }

  extend(Rect, { rx, ry });

  registerMethods({
    Container: {
      // Create a rect element
      rect: wrapWithAttrCheck(function (width, height) {
        return this.put(new Rect()).size(width, height)
      })
    }
  });

  register(Rect, 'Rect');

  class Queue {
    constructor() {
      this._first = null;
      this._last = null;
    }

    // Shows us the first item in the list
    first() {
      return this._first && this._first.value
    }

    // Shows us the last item in the list
    last() {
      return this._last && this._last.value
    }

    push(value) {
      // An item stores an id and the provided value
      const item =
        typeof value.next !== 'undefined'
          ? value
          : { value: value, next: null, prev: null };

      // Deal with the queue being empty or populated
      if (this._last) {
        item.prev = this._last;
        this._last.next = item;
        this._last = item;
      } else {
        this._last = item;
        this._first = item;
      }

      // Return the current item
      return item
    }

    // Removes the item that was returned from the push
    remove(item) {
      // Relink the previous item
      if (item.prev) item.prev.next = item.next;
      if (item.next) item.next.prev = item.prev;
      if (item === this._last) this._last = item.prev;
      if (item === this._first) this._first = item.next;

      // Invalidate item
      item.prev = null;
      item.next = null;
    }

    shift() {
      // Check if we have a value
      const remove = this._first;
      if (!remove) return null

      // If we do, remove it and relink things
      this._first = remove.next;
      if (this._first) this._first.prev = null;
      this._last = this._first ? this._last : null;
      return remove.value
    }
  }

  const Animator = {
    nextDraw: null,
    frames: new Queue(),
    timeouts: new Queue(),
    immediates: new Queue(),
    timer: () => globals.window.performance || globals.window.Date,
    transforms: [],

    frame(fn) {
      // Store the node
      const node = Animator.frames.push({ run: fn });

      // Request an animation frame if we don't have one
      if (Animator.nextDraw === null) {
        Animator.nextDraw = globals.window.requestAnimationFrame(Animator._draw);
      }

      // Return the node so we can remove it easily
      return node
    },

    timeout(fn, delay) {
      delay = delay || 0;

      // Work out when the event should fire
      const time = Animator.timer().now() + delay;

      // Add the timeout to the end of the queue
      const node = Animator.timeouts.push({ run: fn, time: time });

      // Request another animation frame if we need one
      if (Animator.nextDraw === null) {
        Animator.nextDraw = globals.window.requestAnimationFrame(Animator._draw);
      }

      return node
    },

    immediate(fn) {
      // Add the immediate fn to the end of the queue
      const node = Animator.immediates.push(fn);
      // Request another animation frame if we need one
      if (Animator.nextDraw === null) {
        Animator.nextDraw = globals.window.requestAnimationFrame(Animator._draw);
      }

      return node
    },

    cancelFrame(node) {
      node != null && Animator.frames.remove(node);
    },

    clearTimeout(node) {
      node != null && Animator.timeouts.remove(node);
    },

    cancelImmediate(node) {
      node != null && Animator.immediates.remove(node);
    },

    _draw(now) {
      // Run all the timeouts we can run, if they are not ready yet, add them
      // to the end of the queue immediately! (bad timeouts!!! [sarcasm])
      let nextTimeout = null;
      const lastTimeout = Animator.timeouts.last();
      while ((nextTimeout = Animator.timeouts.shift())) {
        // Run the timeout if its time, or push it to the end
        if (now >= nextTimeout.time) {
          nextTimeout.run();
        } else {
          Animator.timeouts.push(nextTimeout);
        }

        // If we hit the last item, we should stop shifting out more items
        if (nextTimeout === lastTimeout) break
      }

      // Run all of the animation frames
      let nextFrame = null;
      const lastFrame = Animator.frames.last();
      while (nextFrame !== lastFrame && (nextFrame = Animator.frames.shift())) {
        nextFrame.run(now);
      }

      let nextImmediate = null;
      while ((nextImmediate = Animator.immediates.shift())) {
        nextImmediate();
      }

      // If we have remaining timeouts or frames, draw until we don't anymore
      Animator.nextDraw =
        Animator.timeouts.first() || Animator.frames.first()
          ? globals.window.requestAnimationFrame(Animator._draw)
          : null;
    }
  };

  const makeSchedule = function (runnerInfo) {
    const start = runnerInfo.start;
    const duration = runnerInfo.runner.duration();
    const end = start + duration;
    return {
      start: start,
      duration: duration,
      end: end,
      runner: runnerInfo.runner
    }
  };

  const defaultSource = function () {
    const w = globals.window;
    return (w.performance || w.Date).now()
  };

  class Timeline extends EventTarget {
    // Construct a new timeline on the given element
    constructor(timeSource = defaultSource) {
      super();

      this._timeSource = timeSource;

      // terminate resets all variables to their initial state
      this.terminate();
    }

    active() {
      return !!this._nextFrame
    }

    finish() {
      // Go to end and pause
      this.time(this.getEndTimeOfTimeline() + 1);
      return this.pause()
    }

    // Calculates the end of the timeline
    getEndTime() {
      const lastRunnerInfo = this.getLastRunnerInfo();
      const lastDuration = lastRunnerInfo ? lastRunnerInfo.runner.duration() : 0;
      const lastStartTime = lastRunnerInfo ? lastRunnerInfo.start : this._time;
      return lastStartTime + lastDuration
    }

    getEndTimeOfTimeline() {
      const endTimes = this._runners.map((i) => i.start + i.runner.duration());
      return Math.max(0, ...endTimes)
    }

    getLastRunnerInfo() {
      return this.getRunnerInfoById(this._lastRunnerId)
    }

    getRunnerInfoById(id) {
      return this._runners[this._runnerIds.indexOf(id)] || null
    }

    pause() {
      this._paused = true;
      return this._continue()
    }

    persist(dtOrForever) {
      if (dtOrForever == null) return this._persist
      this._persist = dtOrForever;
      return this
    }

    play() {
      // Now make sure we are not paused and continue the animation
      this._paused = false;
      return this.updateTime()._continue()
    }

    reverse(yes) {
      const currentSpeed = this.speed();
      if (yes == null) return this.speed(-currentSpeed)

      const positive = Math.abs(currentSpeed);
      return this.speed(yes ? -positive : positive)
    }

    // schedules a runner on the timeline
    schedule(runner, delay, when) {
      if (runner == null) {
        return this._runners.map(makeSchedule)
      }

      // The start time for the next animation can either be given explicitly,
      // derived from the current timeline time or it can be relative to the
      // last start time to chain animations directly

      let absoluteStartTime = 0;
      const endTime = this.getEndTime();
      delay = delay || 0;

      // Work out when to start the animation
      if (when == null || when === 'last' || when === 'after') {
        // Take the last time and increment
        absoluteStartTime = endTime;
      } else if (when === 'absolute' || when === 'start') {
        absoluteStartTime = delay;
        delay = 0;
      } else if (when === 'now') {
        absoluteStartTime = this._time;
      } else if (when === 'relative') {
        const runnerInfo = this.getRunnerInfoById(runner.id);
        if (runnerInfo) {
          absoluteStartTime = runnerInfo.start + delay;
          delay = 0;
        }
      } else if (when === 'with-last') {
        const lastRunnerInfo = this.getLastRunnerInfo();
        const lastStartTime = lastRunnerInfo ? lastRunnerInfo.start : this._time;
        absoluteStartTime = lastStartTime;
      } else {
        throw new Error('Invalid value for the "when" parameter')
      }

      // Manage runner
      runner.unschedule();
      runner.timeline(this);

      const persist = runner.persist();
      const runnerInfo = {
        persist: persist === null ? this._persist : persist,
        start: absoluteStartTime + delay,
        runner
      };

      this._lastRunnerId = runner.id;

      this._runners.push(runnerInfo);
      this._runners.sort((a, b) => a.start - b.start);
      this._runnerIds = this._runners.map((info) => info.runner.id);

      this.updateTime()._continue();
      return this
    }

    seek(dt) {
      return this.time(this._time + dt)
    }

    source(fn) {
      if (fn == null) return this._timeSource
      this._timeSource = fn;
      return this
    }

    speed(speed) {
      if (speed == null) return this._speed
      this._speed = speed;
      return this
    }

    stop() {
      // Go to start and pause
      this.time(0);
      return this.pause()
    }

    time(time) {
      if (time == null) return this._time
      this._time = time;
      return this._continue(true)
    }

    // Remove the runner from this timeline
    unschedule(runner) {
      const index = this._runnerIds.indexOf(runner.id);
      if (index < 0) return this

      this._runners.splice(index, 1);
      this._runnerIds.splice(index, 1);

      runner.timeline(null);
      return this
    }

    // Makes sure, that after pausing the time doesn't jump
    updateTime() {
      if (!this.active()) {
        this._lastSourceTime = this._timeSource();
      }
      return this
    }

    // Checks if we are running and continues the animation
    _continue(immediateStep = false) {
      Animator.cancelFrame(this._nextFrame);
      this._nextFrame = null;

      if (immediateStep) return this._stepImmediate()
      if (this._paused) return this

      this._nextFrame = Animator.frame(this._step);
      return this
    }

    _stepFn(immediateStep = false) {
      // Get the time delta from the last time and update the time
      const time = this._timeSource();
      let dtSource = time - this._lastSourceTime;

      if (immediateStep) dtSource = 0;

      const dtTime = this._speed * dtSource + (this._time - this._lastStepTime);
      this._lastSourceTime = time;

      // Only update the time if we use the timeSource.
      // Otherwise use the current time
      if (!immediateStep) {
        // Update the time
        this._time += dtTime;
        this._time = this._time < 0 ? 0 : this._time;
      }
      this._lastStepTime = this._time;
      this.fire('time', this._time);

      // This is for the case that the timeline was seeked so that the time
      // is now before the startTime of the runner. That is why we need to set
      // the runner to position 0

      // FIXME:
      // However, resetting in insertion order leads to bugs. Considering the case,
      // where 2 runners change the same attribute but in different times,
      // resetting both of them will lead to the case where the later defined
      // runner always wins the reset even if the other runner started earlier
      // and therefore should win the attribute battle
      // this can be solved by resetting them backwards
      for (let k = this._runners.length; k--; ) {
        // Get and run the current runner and ignore it if its inactive
        const runnerInfo = this._runners[k];
        const runner = runnerInfo.runner;

        // Make sure that we give the actual difference
        // between runner start time and now
        const dtToStart = this._time - runnerInfo.start;

        // Dont run runner if not started yet
        // and try to reset it
        if (dtToStart <= 0) {
          runner.reset();
        }
      }

      // Run all of the runners directly
      let runnersLeft = false;
      for (let i = 0, len = this._runners.length; i < len; i++) {
        // Get and run the current runner and ignore it if its inactive
        const runnerInfo = this._runners[i];
        const runner = runnerInfo.runner;
        let dt = dtTime;

        // Make sure that we give the actual difference
        // between runner start time and now
        const dtToStart = this._time - runnerInfo.start;

        // Dont run runner if not started yet
        if (dtToStart <= 0) {
          runnersLeft = true;
          continue
        } else if (dtToStart < dt) {
          // Adjust dt to make sure that animation is on point
          dt = dtToStart;
        }

        if (!runner.active()) continue

        // If this runner is still going, signal that we need another animation
        // frame, otherwise, remove the completed runner
        const finished = runner.step(dt).done;
        if (!finished) {
          runnersLeft = true;
          // continue
        } else if (runnerInfo.persist !== true) {
          // runner is finished. And runner might get removed
          const endTime = runner.duration() - runner.time() + this._time;

          if (endTime + runnerInfo.persist < this._time) {
            // Delete runner and correct index
            runner.unschedule();
            --i;
            --len;
          }
        }
      }

      // Basically: we continue when there are runners right from us in time
      // when -->, and when runners are left from us when <--
      if (
        (runnersLeft && !(this._speed < 0 && this._time === 0)) ||
        (this._runnerIds.length && this._speed < 0 && this._time > 0)
      ) {
        this._continue();
      } else {
        this.pause();
        this.fire('finished');
      }

      return this
    }

    terminate() {
      // cleanup memory

      // Store the timing variables
      this._startTime = 0;
      this._speed = 1.0;

      // Determines how long a runner is hold in memory. Can be a dt or true/false
      this._persist = 0;

      // Keep track of the running animations and their starting parameters
      this._nextFrame = null;
      this._paused = true;
      this._runners = [];
      this._runnerIds = [];
      this._lastRunnerId = -1;
      this._time = 0;
      this._lastSourceTime = 0;
      this._lastStepTime = 0;

      // Make sure that step is always called in class context
      this._step = this._stepFn.bind(this, false);
      this._stepImmediate = this._stepFn.bind(this, true);
    }
  }

  registerMethods({
    Element: {
      timeline: function (timeline) {
        if (timeline == null) {
          this._timeline = this._timeline || new Timeline();
          return this._timeline
        } else {
          this._timeline = timeline;
          return this
        }
      }
    }
  });

  class Runner extends EventTarget {
    constructor(options) {
      super();

      // Store a unique id on the runner, so that we can identify it later
      this.id = Runner.id++;

      // Ensure a default value
      options = options == null ? timeline.duration : options;

      // Ensure that we get a controller
      options = typeof options === 'function' ? new Controller(options) : options;

      // Declare all of the variables
      this._element = null;
      this._timeline = null;
      this.done = false;
      this._queue = [];

      // Work out the stepper and the duration
      this._duration = typeof options === 'number' && options;
      this._isDeclarative = options instanceof Controller;
      this._stepper = this._isDeclarative ? options : new Ease();

      // We copy the current values from the timeline because they can change
      this._history = {};

      // Store the state of the runner
      this.enabled = true;
      this._time = 0;
      this._lastTime = 0;

      // At creation, the runner is in reset state
      this._reseted = true;

      // Save transforms applied to this runner
      this.transforms = new Matrix();
      this.transformId = 1;

      // Looping variables
      this._haveReversed = false;
      this._reverse = false;
      this._loopsDone = 0;
      this._swing = false;
      this._wait = 0;
      this._times = 1;

      this._frameId = null;

      // Stores how long a runner is stored after being done
      this._persist = this._isDeclarative ? true : null;
    }

    static sanitise(duration, delay, when) {
      // Initialise the default parameters
      let times = 1;
      let swing = false;
      let wait = 0;
      duration = duration ?? timeline.duration;
      delay = delay ?? timeline.delay;
      when = when || 'last';

      // If we have an object, unpack the values
      if (typeof duration === 'object' && !(duration instanceof Stepper)) {
        delay = duration.delay ?? delay;
        when = duration.when ?? when;
        swing = duration.swing || swing;
        times = duration.times ?? times;
        wait = duration.wait ?? wait;
        duration = duration.duration ?? timeline.duration;
      }

      return {
        duration: duration,
        delay: delay,
        swing: swing,
        times: times,
        wait: wait,
        when: when
      }
    }

    active(enabled) {
      if (enabled == null) return this.enabled
      this.enabled = enabled;
      return this
    }

    /*
    Private Methods
    ===============
    Methods that shouldn't be used externally
    */
    addTransform(transform) {
      this.transforms.lmultiplyO(transform);
      return this
    }

    after(fn) {
      return this.on('finished', fn)
    }

    animate(duration, delay, when) {
      const o = Runner.sanitise(duration, delay, when);
      const runner = new Runner(o.duration);
      if (this._timeline) runner.timeline(this._timeline);
      if (this._element) runner.element(this._element);
      return runner.loop(o).schedule(o.delay, o.when)
    }

    clearTransform() {
      this.transforms = new Matrix();
      return this
    }

    // TODO: Keep track of all transformations so that deletion is faster
    clearTransformsFromQueue() {
      if (
        !this.done ||
        !this._timeline ||
        !this._timeline._runnerIds.includes(this.id)
      ) {
        this._queue = this._queue.filter((item) => {
          return !item.isTransform
        });
      }
    }

    delay(delay) {
      return this.animate(0, delay)
    }

    duration() {
      return this._times * (this._wait + this._duration) - this._wait
    }

    during(fn) {
      return this.queue(null, fn)
    }

    ease(fn) {
      this._stepper = new Ease(fn);
      return this
    }
    /*
    Runner Definitions
    ==================
    These methods help us define the runtime behaviour of the Runner or they
    help us make new runners from the current runner
    */

    element(element) {
      if (element == null) return this._element
      this._element = element;
      element._prepareRunner();
      return this
    }

    finish() {
      return this.step(Infinity)
    }

    loop(times, swing, wait) {
      // Deal with the user passing in an object
      if (typeof times === 'object') {
        swing = times.swing;
        wait = times.wait;
        times = times.times;
      }

      // Sanitise the values and store them
      this._times = times || Infinity;
      this._swing = swing || false;
      this._wait = wait || 0;

      // Allow true to be passed
      if (this._times === true) {
        this._times = Infinity;
      }

      return this
    }

    loops(p) {
      const loopDuration = this._duration + this._wait;
      if (p == null) {
        const loopsDone = Math.floor(this._time / loopDuration);
        const relativeTime = this._time - loopsDone * loopDuration;
        const position = relativeTime / this._duration;
        return Math.min(loopsDone + position, this._times)
      }
      const whole = Math.floor(p);
      const partial = p % 1;
      const time = loopDuration * whole + this._duration * partial;
      return this.time(time)
    }

    persist(dtOrForever) {
      if (dtOrForever == null) return this._persist
      this._persist = dtOrForever;
      return this
    }

    position(p) {
      // Get all of the variables we need
      const x = this._time;
      const d = this._duration;
      const w = this._wait;
      const t = this._times;
      const s = this._swing;
      const r = this._reverse;
      let position;

      if (p == null) {
        /*
        This function converts a time to a position in the range [0, 1]
        The full explanation can be found in this desmos demonstration
          https://www.desmos.com/calculator/u4fbavgche
        The logic is slightly simplified here because we can use booleans
        */

        // Figure out the value without thinking about the start or end time
        const f = function (x) {
          const swinging = s * Math.floor((x % (2 * (w + d))) / (w + d));
          const backwards = (swinging && !r) || (!swinging && r);
          const uncliped =
            (Math.pow(-1, backwards) * (x % (w + d))) / d + backwards;
          const clipped = Math.max(Math.min(uncliped, 1), 0);
          return clipped
        };

        // Figure out the value by incorporating the start time
        const endTime = t * (w + d) - w;
        position =
          x <= 0
            ? Math.round(f(1e-5))
            : x < endTime
              ? f(x)
              : Math.round(f(endTime - 1e-5));
        return position
      }

      // Work out the loops done and add the position to the loops done
      const loopsDone = Math.floor(this.loops());
      const swingForward = s && loopsDone % 2 === 0;
      const forwards = (swingForward && !r) || (r && swingForward);
      position = loopsDone + (forwards ? p : 1 - p);
      return this.loops(position)
    }

    progress(p) {
      if (p == null) {
        return Math.min(1, this._time / this.duration())
      }
      return this.time(p * this.duration())
    }

    /*
    Basic Functionality
    ===================
    These methods allow us to attach basic functions to the runner directly
    */
    queue(initFn, runFn, retargetFn, isTransform) {
      this._queue.push({
        initialiser: initFn || noop,
        runner: runFn || noop,
        retarget: retargetFn,
        isTransform: isTransform,
        initialised: false,
        finished: false
      });
      const timeline = this.timeline();
      timeline && this.timeline()._continue();
      return this
    }

    reset() {
      if (this._reseted) return this
      this.time(0);
      this._reseted = true;
      return this
    }

    reverse(reverse) {
      this._reverse = reverse == null ? !this._reverse : reverse;
      return this
    }

    schedule(timeline, delay, when) {
      // The user doesn't need to pass a timeline if we already have one
      if (!(timeline instanceof Timeline)) {
        when = delay;
        delay = timeline;
        timeline = this.timeline();
      }

      // If there is no timeline, yell at the user...
      if (!timeline) {
        throw Error('Runner cannot be scheduled without timeline')
      }

      // Schedule the runner on the timeline provided
      timeline.schedule(this, delay, when);
      return this
    }

    step(dt) {
      // If we are inactive, this stepper just gets skipped
      if (!this.enabled) return this

      // Update the time and get the new position
      dt = dt == null ? 16 : dt;
      this._time += dt;
      const position = this.position();

      // Figure out if we need to run the stepper in this frame
      const running = this._lastPosition !== position && this._time >= 0;
      this._lastPosition = position;

      // Figure out if we just started
      const duration = this.duration();
      const justStarted = this._lastTime <= 0 && this._time > 0;
      const justFinished = this._lastTime < duration && this._time >= duration;

      this._lastTime = this._time;
      if (justStarted) {
        this.fire('start', this);
      }

      // Work out if the runner is finished set the done flag here so animations
      // know, that they are running in the last step (this is good for
      // transformations which can be merged)
      const declarative = this._isDeclarative;
      this.done = !declarative && !justFinished && this._time >= duration;

      // Runner is running. So its not in reset state anymore
      this._reseted = false;

      let converged = false;
      // Call initialise and the run function
      if (running || declarative) {
        this._initialise(running);

        // clear the transforms on this runner so they dont get added again and again
        this.transforms = new Matrix();
        converged = this._run(declarative ? dt : position);

        this.fire('step', this);
      }
      // correct the done flag here
      // declarative animations itself know when they converged
      this.done = this.done || (converged && declarative);
      if (justFinished) {
        this.fire('finished', this);
      }
      return this
    }

    /*
    Runner animation methods
    ========================
    Control how the animation plays
    */
    time(time) {
      if (time == null) {
        return this._time
      }
      const dt = time - this._time;
      this.step(dt);
      return this
    }

    timeline(timeline) {
      // check explicitly for undefined so we can set the timeline to null
      if (typeof timeline === 'undefined') return this._timeline
      this._timeline = timeline;
      return this
    }

    unschedule() {
      const timeline = this.timeline();
      timeline && timeline.unschedule(this);
      return this
    }

    // Run each initialise function in the runner if required
    _initialise(running) {
      // If we aren't running, we shouldn't initialise when not declarative
      if (!running && !this._isDeclarative) return

      // Loop through all of the initialisers
      for (let i = 0, len = this._queue.length; i < len; ++i) {
        // Get the current initialiser
        const current = this._queue[i];

        // Determine whether we need to initialise
        const needsIt = this._isDeclarative || (!current.initialised && running);
        running = !current.finished;

        // Call the initialiser if we need to
        if (needsIt && running) {
          current.initialiser.call(this);
          current.initialised = true;
        }
      }
    }

    // Save a morpher to the morpher list so that we can retarget it later
    _rememberMorpher(method, morpher) {
      this._history[method] = {
        morpher: morpher,
        caller: this._queue[this._queue.length - 1]
      };

      // We have to resume the timeline in case a controller
      // is already done without being ever run
      // This can happen when e.g. this is done:
      //    anim = el.animate(new SVG.Spring)
      // and later
      //    anim.move(...)
      if (this._isDeclarative) {
        const timeline = this.timeline();
        timeline && timeline.play();
      }
    }

    // Try to set the target for a morpher if the morpher exists, otherwise
    // Run each run function for the position or dt given
    _run(positionOrDt) {
      // Run all of the _queue directly
      let allfinished = true;
      for (let i = 0, len = this._queue.length; i < len; ++i) {
        // Get the current function to run
        const current = this._queue[i];

        // Run the function if its not finished, we keep track of the finished
        // flag for the sake of declarative _queue
        const converged = current.runner.call(this, positionOrDt);
        current.finished = current.finished || converged === true;
        allfinished = allfinished && current.finished;
      }

      // We report when all of the constructors are finished
      return allfinished
    }

    // do nothing and return false
    _tryRetarget(method, target, extra) {
      if (this._history[method]) {
        // if the last method wasn't even initialised, throw it away
        if (!this._history[method].caller.initialised) {
          const index = this._queue.indexOf(this._history[method].caller);
          this._queue.splice(index, 1);
          return false
        }

        // for the case of transformations, we use the special retarget function
        // which has access to the outer scope
        if (this._history[method].caller.retarget) {
          this._history[method].caller.retarget.call(this, target, extra);
          // for everything else a simple morpher change is sufficient
        } else {
          this._history[method].morpher.to(target);
        }

        this._history[method].caller.finished = false;
        const timeline = this.timeline();
        timeline && timeline.play();
        return true
      }
      return false
    }
  }

  Runner.id = 0;

  class FakeRunner {
    constructor(transforms = new Matrix(), id = -1, done = true) {
      this.transforms = transforms;
      this.id = id;
      this.done = done;
    }

    clearTransformsFromQueue() {}
  }

  extend([Runner, FakeRunner], {
    mergeWith(runner) {
      return new FakeRunner(
        runner.transforms.lmultiply(this.transforms),
        runner.id
      )
    }
  });

  // FakeRunner.emptyRunner = new FakeRunner()

  const lmultiply = (last, curr) => last.lmultiplyO(curr);
  const getRunnerTransform = (runner) => runner.transforms;

  function mergeTransforms() {
    // Find the matrix to apply to the element and apply it
    const runners = this._transformationRunners.runners;
    const netTransform = runners
      .map(getRunnerTransform)
      .reduce(lmultiply, new Matrix());

    this.transform(netTransform);

    this._transformationRunners.merge();

    if (this._transformationRunners.length() === 1) {
      this._frameId = null;
    }
  }

  class RunnerArray {
    constructor() {
      this.runners = [];
      this.ids = [];
    }

    add(runner) {
      if (this.runners.includes(runner)) return
      const id = runner.id + 1;

      this.runners.push(runner);
      this.ids.push(id);

      return this
    }

    clearBefore(id) {
      const deleteCnt = this.ids.indexOf(id + 1) || 1;
      this.ids.splice(0, deleteCnt, 0);
      this.runners
        .splice(0, deleteCnt, new FakeRunner())
        .forEach((r) => r.clearTransformsFromQueue());
      return this
    }

    edit(id, newRunner) {
      const index = this.ids.indexOf(id + 1);
      this.ids.splice(index, 1, id + 1);
      this.runners.splice(index, 1, newRunner);
      return this
    }

    getByID(id) {
      return this.runners[this.ids.indexOf(id + 1)]
    }

    length() {
      return this.ids.length
    }

    merge() {
      let lastRunner = null;
      for (let i = 0; i < this.runners.length; ++i) {
        const runner = this.runners[i];

        const condition =
          lastRunner &&
          runner.done &&
          lastRunner.done &&
          // don't merge runner when persisted on timeline
          (!runner._timeline ||
            !runner._timeline._runnerIds.includes(runner.id)) &&
          (!lastRunner._timeline ||
            !lastRunner._timeline._runnerIds.includes(lastRunner.id));

        if (condition) {
          // the +1 happens in the function
          this.remove(runner.id);
          const newRunner = runner.mergeWith(lastRunner);
          this.edit(lastRunner.id, newRunner);
          lastRunner = newRunner;
          --i;
        } else {
          lastRunner = runner;
        }
      }

      return this
    }

    remove(id) {
      const index = this.ids.indexOf(id + 1);
      this.ids.splice(index, 1);
      this.runners.splice(index, 1);
      return this
    }
  }

  registerMethods({
    Element: {
      animate(duration, delay, when) {
        const o = Runner.sanitise(duration, delay, when);
        const timeline = this.timeline();
        return new Runner(o.duration)
          .loop(o)
          .element(this)
          .timeline(timeline.play())
          .schedule(o.delay, o.when)
      },

      delay(by, when) {
        return this.animate(0, by, when)
      },

      // this function searches for all runners on the element and deletes the ones
      // which run before the current one. This is because absolute transformations
      // overwrite anything anyway so there is no need to waste time computing
      // other runners
      _clearTransformRunnersBefore(currentRunner) {
        this._transformationRunners.clearBefore(currentRunner.id);
      },

      _currentTransform(current) {
        return (
          this._transformationRunners.runners
            // we need the equal sign here to make sure, that also transformations
            // on the same runner which execute before the current transformation are
            // taken into account
            .filter((runner) => runner.id <= current.id)
            .map(getRunnerTransform)
            .reduce(lmultiply, new Matrix())
        )
      },

      _addRunner(runner) {
        this._transformationRunners.add(runner);

        // Make sure that the runner merge is executed at the very end of
        // all Animator functions. That is why we use immediate here to execute
        // the merge right after all frames are run
        Animator.cancelImmediate(this._frameId);
        this._frameId = Animator.immediate(mergeTransforms.bind(this));
      },

      _prepareRunner() {
        if (this._frameId == null) {
          this._transformationRunners = new RunnerArray().add(
            new FakeRunner(new Matrix(this))
          );
        }
      }
    }
  });

  // Will output the elements from array A that are not in the array B
  const difference = (a, b) => a.filter((x) => !b.includes(x));

  extend(Runner, {
    attr(a, v) {
      return this.styleAttr('attr', a, v)
    },

    // Add animatable styles
    css(s, v) {
      return this.styleAttr('css', s, v)
    },

    styleAttr(type, nameOrAttrs, val) {
      if (typeof nameOrAttrs === 'string') {
        return this.styleAttr(type, { [nameOrAttrs]: val })
      }

      let attrs = nameOrAttrs;
      if (this._tryRetarget(type, attrs)) return this

      let morpher = new Morphable(this._stepper).to(attrs);
      let keys = Object.keys(attrs);

      this.queue(
        function () {
          morpher = morpher.from(this.element()[type](keys));
        },
        function (pos) {
          this.element()[type](morpher.at(pos).valueOf());
          return morpher.done()
        },
        function (newToAttrs) {
          // Check if any new keys were added
          const newKeys = Object.keys(newToAttrs);
          const differences = difference(newKeys, keys);

          // If their are new keys, initialize them and add them to morpher
          if (differences.length) {
            // Get the values
            const addedFromAttrs = this.element()[type](differences);

            // Get the already initialized values
            const oldFromAttrs = new ObjectBag(morpher.from()).valueOf();

            // Merge old and new
            Object.assign(oldFromAttrs, addedFromAttrs);
            morpher.from(oldFromAttrs);
          }

          // Get the object from the morpher
          const oldToAttrs = new ObjectBag(morpher.to()).valueOf();

          // Merge in new attributes
          Object.assign(oldToAttrs, newToAttrs);

          // Change morpher target
          morpher.to(oldToAttrs);

          // Make sure that we save the work we did so we don't need it to do again
          keys = newKeys;
          attrs = newToAttrs;
        }
      );

      this._rememberMorpher(type, morpher);
      return this
    },

    zoom(level, point) {
      if (this._tryRetarget('zoom', level, point)) return this

      let morpher = new Morphable(this._stepper).to(new SVGNumber(level));

      this.queue(
        function () {
          morpher = morpher.from(this.element().zoom());
        },
        function (pos) {
          this.element().zoom(morpher.at(pos), point);
          return morpher.done()
        },
        function (newLevel, newPoint) {
          point = newPoint;
          morpher.to(newLevel);
        }
      );

      this._rememberMorpher('zoom', morpher);
      return this
    },

    /**
     ** absolute transformations
     **/

    //
    // M v -----|-----(D M v = F v)------|----->  T v
    //
    // 1. define the final state (T) and decompose it (once)
    //    t = [tx, ty, the, lam, sy, sx]
    // 2. on every frame: pull the current state of all previous transforms
    //    (M - m can change)
    //   and then write this as m = [tx0, ty0, the0, lam0, sy0, sx0]
    // 3. Find the interpolated matrix F(pos) = m + pos * (t - m)
    //   - Note F(0) = M
    //   - Note F(1) = T
    // 4. Now you get the delta matrix as a result: D = F * inv(M)

    transform(transforms, relative, affine) {
      // If we have a declarative function, we should retarget it if possible
      relative = transforms.relative || relative;
      if (
        this._isDeclarative &&
        !relative &&
        this._tryRetarget('transform', transforms)
      ) {
        return this
      }

      // Parse the parameters
      const isMatrix = Matrix.isMatrixLike(transforms);
      affine =
        transforms.affine != null
          ? transforms.affine
          : affine != null
            ? affine
            : !isMatrix;

      // Create a morpher and set its type
      const morpher = new Morphable(this._stepper).type(
        affine ? TransformBag : Matrix
      );

      let origin;
      let element;
      let current;
      let currentAngle;
      let startTransform;

      function setup() {
        // make sure element and origin is defined
        element = element || this.element();
        origin = origin || getOrigin(transforms, element);

        startTransform = new Matrix(relative ? undefined : element);

        // add the runner to the element so it can merge transformations
        element._addRunner(this);

        // Deactivate all transforms that have run so far if we are absolute
        if (!relative) {
          element._clearTransformRunnersBefore(this);
        }
      }

      function run(pos) {
        // clear all other transforms before this in case something is saved
        // on this runner. We are absolute. We dont need these!
        if (!relative) this.clearTransform();

        const { x, y } = new Point(origin).transform(
          element._currentTransform(this)
        );

        let target = new Matrix({ ...transforms, origin: [x, y] });
        let start = this._isDeclarative && current ? current : startTransform;

        if (affine) {
          target = target.decompose(x, y);
          start = start.decompose(x, y);

          // Get the current and target angle as it was set
          const rTarget = target.rotate;
          const rCurrent = start.rotate;

          // Figure out the shortest path to rotate directly
          const possibilities = [rTarget - 360, rTarget, rTarget + 360];
          const distances = possibilities.map((a) => Math.abs(a - rCurrent));
          const shortest = Math.min(...distances);
          const index = distances.indexOf(shortest);
          target.rotate = possibilities[index];
        }

        if (relative) {
          // we have to be careful here not to overwrite the rotation
          // with the rotate method of Matrix
          if (!isMatrix) {
            target.rotate = transforms.rotate || 0;
          }
          if (this._isDeclarative && currentAngle) {
            start.rotate = currentAngle;
          }
        }

        morpher.from(start);
        morpher.to(target);

        const affineParameters = morpher.at(pos);
        currentAngle = affineParameters.rotate;
        current = new Matrix(affineParameters);

        this.addTransform(current);
        element._addRunner(this);
        return morpher.done()
      }

      function retarget(newTransforms) {
        // only get a new origin if it changed since the last call
        if (
          (newTransforms.origin || 'center').toString() !==
          (transforms.origin || 'center').toString()
        ) {
          origin = getOrigin(newTransforms, element);
        }

        // overwrite the old transformations with the new ones
        transforms = { ...newTransforms, origin };
      }

      this.queue(setup, run, retarget, true);
      this._isDeclarative && this._rememberMorpher('transform', morpher);
      return this
    },

    // Animatable x-axis
    x(x) {
      return this._queueNumber('x', x)
    },

    // Animatable y-axis
    y(y) {
      return this._queueNumber('y', y)
    },

    ax(x) {
      return this._queueNumber('ax', x)
    },

    ay(y) {
      return this._queueNumber('ay', y)
    },

    dx(x = 0) {
      return this._queueNumberDelta('x', x)
    },

    dy(y = 0) {
      return this._queueNumberDelta('y', y)
    },

    dmove(x, y) {
      return this.dx(x).dy(y)
    },

    _queueNumberDelta(method, to) {
      to = new SVGNumber(to);

      // Try to change the target if we have this method already registered
      if (this._tryRetarget(method, to)) return this

      // Make a morpher and queue the animation
      const morpher = new Morphable(this._stepper).to(to);
      let from = null;
      this.queue(
        function () {
          from = this.element()[method]();
          morpher.from(from);
          morpher.to(from + to);
        },
        function (pos) {
          this.element()[method](morpher.at(pos));
          return morpher.done()
        },
        function (newTo) {
          morpher.to(from + new SVGNumber(newTo));
        }
      );

      // Register the morpher so that if it is changed again, we can retarget it
      this._rememberMorpher(method, morpher);
      return this
    },

    _queueObject(method, to) {
      // Try to change the target if we have this method already registered
      if (this._tryRetarget(method, to)) return this

      // Make a morpher and queue the animation
      const morpher = new Morphable(this._stepper).to(to);
      this.queue(
        function () {
          morpher.from(this.element()[method]());
        },
        function (pos) {
          this.element()[method](morpher.at(pos));
          return morpher.done()
        }
      );

      // Register the morpher so that if it is changed again, we can retarget it
      this._rememberMorpher(method, morpher);
      return this
    },

    _queueNumber(method, value) {
      return this._queueObject(method, new SVGNumber(value))
    },

    // Animatable center x-axis
    cx(x) {
      return this._queueNumber('cx', x)
    },

    // Animatable center y-axis
    cy(y) {
      return this._queueNumber('cy', y)
    },

    // Add animatable move
    move(x, y) {
      return this.x(x).y(y)
    },

    amove(x, y) {
      return this.ax(x).ay(y)
    },

    // Add animatable center
    center(x, y) {
      return this.cx(x).cy(y)
    },

    // Add animatable size
    size(width, height) {
      // animate bbox based size for all other elements
      let box;

      if (!width || !height) {
        box = this._element.bbox();
      }

      if (!width) {
        width = (box.width / box.height) * height;
      }

      if (!height) {
        height = (box.height / box.width) * width;
      }

      return this.width(width).height(height)
    },

    // Add animatable width
    width(width) {
      return this._queueNumber('width', width)
    },

    // Add animatable height
    height(height) {
      return this._queueNumber('height', height)
    },

    // Add animatable plot
    plot(a, b, c, d) {
      // Lines can be plotted with 4 arguments
      if (arguments.length === 4) {
        return this.plot([a, b, c, d])
      }

      if (this._tryRetarget('plot', a)) return this

      const morpher = new Morphable(this._stepper)
        .type(this._element.MorphArray)
        .to(a);

      this.queue(
        function () {
          morpher.from(this._element.array());
        },
        function (pos) {
          this._element.plot(morpher.at(pos));
          return morpher.done()
        }
      );

      this._rememberMorpher('plot', morpher);
      return this
    },

    // Add leading method
    leading(value) {
      return this._queueNumber('leading', value)
    },

    // Add animatable viewbox
    viewbox(x, y, width, height) {
      return this._queueObject('viewbox', new Box(x, y, width, height))
    },

    update(o) {
      if (typeof o !== 'object') {
        return this.update({
          offset: arguments[0],
          color: arguments[1],
          opacity: arguments[2]
        })
      }

      if (o.opacity != null) this.attr('stop-opacity', o.opacity);
      if (o.color != null) this.attr('stop-color', o.color);
      if (o.offset != null) this.attr('offset', o.offset);

      return this
    }
  });

  extend(Runner, { rx, ry, from, to });
  register(Runner, 'Runner');

  class Svg extends Container {
    constructor(node, attrs = node) {
      super(nodeOrNew('svg', node), attrs);
      this.namespace();
    }

    // Creates and returns defs element
    defs() {
      if (!this.isRoot()) return this.root().defs()

      return adopt(this.node.querySelector('defs')) || this.put(new Defs())
    }

    isRoot() {
      return (
        !this.node.parentNode ||
        (!(this.node.parentNode instanceof globals.window.SVGElement) &&
          this.node.parentNode.nodeName !== '#document-fragment')
      )
    }

    // Add namespaces
    namespace() {
      if (!this.isRoot()) return this.root().namespace()
      return this.attr({ xmlns: svg, version: '1.1' }).attr(
        'xmlns:xlink',
        xlink,
        xmlns
      )
    }

    removeNamespace() {
      return this.attr({ xmlns: null, version: null })
        .attr('xmlns:xlink', null, xmlns)
        .attr('xmlns:svgjs', null, xmlns)
    }

    // Check if this is a root svg
    // If not, call root() from this element
    root() {
      if (this.isRoot()) return this
      return super.root()
    }
  }

  registerMethods({
    Container: {
      // Create nested svg document
      nested: wrapWithAttrCheck(function () {
        return this.put(new Svg())
      })
    }
  });

  register(Svg, 'Svg', true);

  let Symbol$1 = class Symbol extends Container {
    // Initialize node
    constructor(node, attrs = node) {
      super(nodeOrNew('symbol', node), attrs);
    }
  };

  registerMethods({
    Container: {
      symbol: wrapWithAttrCheck(function () {
        return this.put(new Symbol$1())
      })
    }
  });

  register(Symbol$1, 'Symbol');

  // Create plain text node
  function plain(text) {
    // clear if build mode is disabled
    if (this._build === false) {
      this.clear();
    }

    // create text node
    this.node.appendChild(globals.document.createTextNode(text));

    return this
  }

  // Get length of text element
  function length() {
    return this.node.getComputedTextLength()
  }

  // Move over x-axis
  // Text is moved by its bounding box
  // text-anchor does NOT matter
  function x$1(x, box = this.bbox()) {
    if (x == null) {
      return box.x
    }

    return this.attr('x', this.attr('x') + x - box.x)
  }

  // Move over y-axis
  function y$1(y, box = this.bbox()) {
    if (y == null) {
      return box.y
    }

    return this.attr('y', this.attr('y') + y - box.y)
  }

  function move$1(x, y, box = this.bbox()) {
    return this.x(x, box).y(y, box)
  }

  // Move center over x-axis
  function cx(x, box = this.bbox()) {
    if (x == null) {
      return box.cx
    }

    return this.attr('x', this.attr('x') + x - box.cx)
  }

  // Move center over y-axis
  function cy(y, box = this.bbox()) {
    if (y == null) {
      return box.cy
    }

    return this.attr('y', this.attr('y') + y - box.cy)
  }

  function center(x, y, box = this.bbox()) {
    return this.cx(x, box).cy(y, box)
  }

  function ax(x) {
    return this.attr('x', x)
  }

  function ay(y) {
    return this.attr('y', y)
  }

  function amove(x, y) {
    return this.ax(x).ay(y)
  }

  // Enable / disable build mode
  function build(build) {
    this._build = !!build;
    return this
  }

  var textable = /*#__PURE__*/Object.freeze({
    __proto__: null,
    amove: amove,
    ax: ax,
    ay: ay,
    build: build,
    center: center,
    cx: cx,
    cy: cy,
    length: length,
    move: move$1,
    plain: plain,
    x: x$1,
    y: y$1
  });

  class Text extends Shape {
    // Initialize node
    constructor(node, attrs = node) {
      super(nodeOrNew('text', node), attrs);

      this.dom.leading = this.dom.leading ?? new SVGNumber(1.3); // store leading value for rebuilding
      this._rebuild = true; // enable automatic updating of dy values
      this._build = false; // disable build mode for adding multiple lines
    }

    // Set / get leading
    leading(value) {
      // act as getter
      if (value == null) {
        return this.dom.leading
      }

      // act as setter
      this.dom.leading = new SVGNumber(value);

      return this.rebuild()
    }

    // Rebuild appearance type
    rebuild(rebuild) {
      // store new rebuild flag if given
      if (typeof rebuild === 'boolean') {
        this._rebuild = rebuild;
      }

      // define position of all lines
      if (this._rebuild) {
        const self = this;
        let blankLineOffset = 0;
        const leading = this.dom.leading;

        this.each(function (i) {
          if (isDescriptive(this.node)) return

          const fontSize = globals.window
            .getComputedStyle(this.node)
            .getPropertyValue('font-size');

          const dy = leading * new SVGNumber(fontSize);

          if (this.dom.newLined) {
            this.attr('x', self.attr('x'));

            if (this.text() === '\n') {
              blankLineOffset += dy;
            } else {
              this.attr('dy', i ? dy + blankLineOffset : 0);
              blankLineOffset = 0;
            }
          }
        });

        this.fire('rebuild');
      }

      return this
    }

    // overwrite method from parent to set data properly
    setData(o) {
      this.dom = o;
      this.dom.leading = new SVGNumber(o.leading || 1.3);
      return this
    }

    writeDataToDom() {
      writeDataToDom(this, this.dom, { leading: 1.3 });
      return this
    }

    // Set the text content
    text(text) {
      // act as getter
      if (text === undefined) {
        const children = this.node.childNodes;
        let firstLine = 0;
        text = '';

        for (let i = 0, len = children.length; i < len; ++i) {
          // skip textPaths - they are no lines
          if (children[i].nodeName === 'textPath' || isDescriptive(children[i])) {
            if (i === 0) firstLine = i + 1;
            continue
          }

          // add newline if its not the first child and newLined is set to true
          if (
            i !== firstLine &&
            children[i].nodeType !== 3 &&
            adopt(children[i]).dom.newLined === true
          ) {
            text += '\n';
          }

          // add content of this node
          text += children[i].textContent;
        }

        return text
      }

      // remove existing content
      this.clear().build(true);

      if (typeof text === 'function') {
        // call block
        text.call(this, this);
      } else {
        // store text and make sure text is not blank
        text = (text + '').split('\n');

        // build new lines
        for (let j = 0, jl = text.length; j < jl; j++) {
          this.newLine(text[j]);
        }
      }

      // disable build mode and rebuild lines
      return this.build(false).rebuild()
    }
  }

  extend(Text, textable);

  registerMethods({
    Container: {
      // Create text element
      text: wrapWithAttrCheck(function (text = '') {
        return this.put(new Text()).text(text)
      }),

      // Create plain text element
      plain: wrapWithAttrCheck(function (text = '') {
        return this.put(new Text()).plain(text)
      })
    }
  });

  register(Text, 'Text');

  class Tspan extends Shape {
    // Initialize node
    constructor(node, attrs = node) {
      super(nodeOrNew('tspan', node), attrs);
      this._build = false; // disable build mode for adding multiple lines
    }

    // Shortcut dx
    dx(dx) {
      return this.attr('dx', dx)
    }

    // Shortcut dy
    dy(dy) {
      return this.attr('dy', dy)
    }

    // Create new line
    newLine() {
      // mark new line
      this.dom.newLined = true;

      // fetch parent
      const text = this.parent();

      // early return in case we are not in a text element
      if (!(text instanceof Text)) {
        return this
      }

      const i = text.index(this);

      const fontSize = globals.window
        .getComputedStyle(this.node)
        .getPropertyValue('font-size');
      const dy = text.dom.leading * new SVGNumber(fontSize);

      // apply new position
      return this.dy(i ? dy : 0).attr('x', text.x())
    }

    // Set text content
    text(text) {
      if (text == null)
        return this.node.textContent + (this.dom.newLined ? '\n' : '')

      if (typeof text === 'function') {
        this.clear().build(true);
        text.call(this, this);
        this.build(false);
      } else {
        this.plain(text);
      }

      return this
    }
  }

  extend(Tspan, textable);

  registerMethods({
    Tspan: {
      tspan: wrapWithAttrCheck(function (text = '') {
        const tspan = new Tspan();

        // clear if build mode is disabled
        if (!this._build) {
          this.clear();
        }

        // add new tspan
        return this.put(tspan).text(text)
      })
    },
    Text: {
      newLine: function (text = '') {
        return this.tspan(text).newLine()
      }
    }
  });

  register(Tspan, 'Tspan');

  class Circle extends Shape {
    constructor(node, attrs = node) {
      super(nodeOrNew('circle', node), attrs);
    }

    radius(r) {
      return this.attr('r', r)
    }

    // Radius x value
    rx(rx) {
      return this.attr('r', rx)
    }

    // Alias radius x value
    ry(ry) {
      return this.rx(ry)
    }

    size(size) {
      return this.radius(new SVGNumber(size).divide(2))
    }
  }

  extend(Circle, { x: x$3, y: y$3, cx: cx$1, cy: cy$1, width: width$2, height: height$2 });

  registerMethods({
    Container: {
      // Create circle element
      circle: wrapWithAttrCheck(function (size = 0) {
        return this.put(new Circle()).size(size).move(0, 0)
      })
    }
  });

  register(Circle, 'Circle');

  class ClipPath extends Container {
    constructor(node, attrs = node) {
      super(nodeOrNew('clipPath', node), attrs);
    }

    // Unclip all clipped elements and remove itself
    remove() {
      // unclip all targets
      this.targets().forEach(function (el) {
        el.unclip();
      });

      // remove clipPath from parent
      return super.remove()
    }

    targets() {
      return baseFind('svg [clip-path*=' + this.id() + ']')
    }
  }

  registerMethods({
    Container: {
      // Create clipping element
      clip: wrapWithAttrCheck(function () {
        return this.defs().put(new ClipPath())
      })
    },
    Element: {
      // Distribute clipPath to svg element
      clipper() {
        return this.reference('clip-path')
      },

      clipWith(element) {
        // use given clip or create a new one
        const clipper =
          element instanceof ClipPath
            ? element
            : this.parent().clip().add(element);

        // apply mask
        return this.attr('clip-path', 'url(#' + clipper.id() + ')')
      },

      // Unclip element
      unclip() {
        return this.attr('clip-path', null)
      }
    }
  });

  register(ClipPath, 'ClipPath');

  class ForeignObject extends Element$1 {
    constructor(node, attrs = node) {
      super(nodeOrNew('foreignObject', node), attrs);
    }
  }

  registerMethods({
    Container: {
      foreignObject: wrapWithAttrCheck(function (width, height) {
        return this.put(new ForeignObject()).size(width, height)
      })
    }
  });

  register(ForeignObject, 'ForeignObject');

  function dmove(dx, dy) {
    this.children().forEach((child) => {
      let bbox;

      // We have to wrap this for elements that dont have a bbox
      // e.g. title and other descriptive elements
      try {
        // Get the childs bbox
        // Bug: https://bugzilla.mozilla.org/show_bug.cgi?id=1905039
        // Because bbox for nested svgs returns the contents bbox in the coordinate space of the svg itself (weird!), we cant use bbox for svgs
        // Therefore we have to use getBoundingClientRect. But THAT is broken (as explained in the bug).
        // Funnily enough the broken behavior would work for us but that breaks it in chrome
        // So we have to replicate the broken behavior of FF by just reading the attributes of the svg itself
        bbox =
          child.node instanceof getWindow().SVGSVGElement
            ? new Box(child.attr(['x', 'y', 'width', 'height']))
            : child.bbox();
      } catch (e) {
        return
      }

      // Get childs matrix
      const m = new Matrix(child);
      // Translate childs matrix by amount and
      // transform it back into parents space
      const matrix = m.translate(dx, dy).transform(m.inverse());
      // Calculate new x and y from old box
      const p = new Point(bbox.x, bbox.y).transform(matrix);
      // Move element
      child.move(p.x, p.y);
    });

    return this
  }

  function dx(dx) {
    return this.dmove(dx, 0)
  }

  function dy(dy) {
    return this.dmove(0, dy)
  }

  function height(height, box = this.bbox()) {
    if (height == null) return box.height
    return this.size(box.width, height, box)
  }

  function move(x = 0, y = 0, box = this.bbox()) {
    const dx = x - box.x;
    const dy = y - box.y;

    return this.dmove(dx, dy)
  }

  function size(width, height, box = this.bbox()) {
    const p = proportionalSize(this, width, height, box);
    const scaleX = p.width / box.width;
    const scaleY = p.height / box.height;

    this.children().forEach((child) => {
      const o = new Point(box).transform(new Matrix(child).inverse());
      child.scale(scaleX, scaleY, o.x, o.y);
    });

    return this
  }

  function width(width, box = this.bbox()) {
    if (width == null) return box.width
    return this.size(width, box.height, box)
  }

  function x(x, box = this.bbox()) {
    if (x == null) return box.x
    return this.move(x, box.y, box)
  }

  function y(y, box = this.bbox()) {
    if (y == null) return box.y
    return this.move(box.x, y, box)
  }

  var containerGeometry = /*#__PURE__*/Object.freeze({
    __proto__: null,
    dmove: dmove,
    dx: dx,
    dy: dy,
    height: height,
    move: move,
    size: size,
    width: width,
    x: x,
    y: y
  });

  class G extends Container {
    constructor(node, attrs = node) {
      super(nodeOrNew('g', node), attrs);
    }
  }

  extend(G, containerGeometry);

  registerMethods({
    Container: {
      // Create a group element
      group: wrapWithAttrCheck(function () {
        return this.put(new G())
      })
    }
  });

  register(G, 'G');

  class A extends Container {
    constructor(node, attrs = node) {
      super(nodeOrNew('a', node), attrs);
    }

    // Link target attribute
    target(target) {
      return this.attr('target', target)
    }

    // Link url
    to(url) {
      return this.attr('href', url, xlink)
    }
  }

  extend(A, containerGeometry);

  registerMethods({
    Container: {
      // Create a hyperlink element
      link: wrapWithAttrCheck(function (url) {
        return this.put(new A()).to(url)
      })
    },
    Element: {
      unlink() {
        const link = this.linker();

        if (!link) return this

        const parent = link.parent();

        if (!parent) {
          return this.remove()
        }

        const index = parent.index(link);
        parent.add(this, index);

        link.remove();
        return this
      },
      linkTo(url) {
        // reuse old link if possible
        let link = this.linker();

        if (!link) {
          link = new A();
          this.wrap(link);
        }

        if (typeof url === 'function') {
          url.call(link, link);
        } else {
          link.to(url);
        }

        return this
      },
      linker() {
        const link = this.parent();
        if (link && link.node.nodeName.toLowerCase() === 'a') {
          return link
        }

        return null
      }
    }
  });

  register(A, 'A');

  class Mask extends Container {
    // Initialize node
    constructor(node, attrs = node) {
      super(nodeOrNew('mask', node), attrs);
    }

    // Unmask all masked elements and remove itself
    remove() {
      // unmask all targets
      this.targets().forEach(function (el) {
        el.unmask();
      });

      // remove mask from parent
      return super.remove()
    }

    targets() {
      return baseFind('svg [mask*=' + this.id() + ']')
    }
  }

  registerMethods({
    Container: {
      mask: wrapWithAttrCheck(function () {
        return this.defs().put(new Mask())
      })
    },
    Element: {
      // Distribute mask to svg element
      masker() {
        return this.reference('mask')
      },

      maskWith(element) {
        // use given mask or create a new one
        const masker =
          element instanceof Mask ? element : this.parent().mask().add(element);

        // apply mask
        return this.attr('mask', 'url(#' + masker.id() + ')')
      },

      // Unmask element
      unmask() {
        return this.attr('mask', null)
      }
    }
  });

  register(Mask, 'Mask');

  class Stop extends Element$1 {
    constructor(node, attrs = node) {
      super(nodeOrNew('stop', node), attrs);
    }

    // add color stops
    update(o) {
      if (typeof o === 'number' || o instanceof SVGNumber) {
        o = {
          offset: arguments[0],
          color: arguments[1],
          opacity: arguments[2]
        };
      }

      // set attributes
      if (o.opacity != null) this.attr('stop-opacity', o.opacity);
      if (o.color != null) this.attr('stop-color', o.color);
      if (o.offset != null) this.attr('offset', new SVGNumber(o.offset));

      return this
    }
  }

  registerMethods({
    Gradient: {
      // Add a color stop
      stop: function (offset, color, opacity) {
        return this.put(new Stop()).update(offset, color, opacity)
      }
    }
  });

  register(Stop, 'Stop');

  function cssRule(selector, rule) {
    if (!selector) return ''
    if (!rule) return selector

    let ret = selector + '{';

    for (const i in rule) {
      ret += unCamelCase(i) + ':' + rule[i] + ';';
    }

    ret += '}';

    return ret
  }

  class Style extends Element$1 {
    constructor(node, attrs = node) {
      super(nodeOrNew('style', node), attrs);
    }

    addText(w = '') {
      this.node.textContent += w;
      return this
    }

    font(name, src, params = {}) {
      return this.rule('@font-face', {
        fontFamily: name,
        src: src,
        ...params
      })
    }

    rule(selector, obj) {
      return this.addText(cssRule(selector, obj))
    }
  }

  registerMethods('Dom', {
    style(selector, obj) {
      return this.put(new Style()).rule(selector, obj)
    },
    fontface(name, src, params) {
      return this.put(new Style()).font(name, src, params)
    }
  });

  register(Style, 'Style');

  class TextPath extends Text {
    // Initialize node
    constructor(node, attrs = node) {
      super(nodeOrNew('textPath', node), attrs);
    }

    // return the array of the path track element
    array() {
      const track = this.track();

      return track ? track.array() : null
    }

    // Plot path if any
    plot(d) {
      const track = this.track();
      let pathArray = null;

      if (track) {
        pathArray = track.plot(d);
      }

      return d == null ? pathArray : this
    }

    // Get the path element
    track() {
      return this.reference('href')
    }
  }

  registerMethods({
    Container: {
      textPath: wrapWithAttrCheck(function (text, path) {
        // Convert text to instance if needed
        if (!(text instanceof Text)) {
          text = this.text(text);
        }

        return text.path(path)
      })
    },
    Text: {
      // Create path for text to run on
      path: wrapWithAttrCheck(function (track, importNodes = true) {
        const textPath = new TextPath();

        // if track is a path, reuse it
        if (!(track instanceof Path)) {
          // create path element
          track = this.defs().path(track);
        }

        // link textPath to path and add content
        textPath.attr('href', '#' + track, xlink);

        // Transplant all nodes from text to textPath
        let node;
        if (importNodes) {
          while ((node = this.node.firstChild)) {
            textPath.node.appendChild(node);
          }
        }

        // add textPath element as child node and return textPath
        return this.put(textPath)
      }),

      // Get the textPath children
      textPath() {
        return this.findOne('textPath')
      }
    },
    Path: {
      // creates a textPath from this path
      text: wrapWithAttrCheck(function (text) {
        // Convert text to instance if needed
        if (!(text instanceof Text)) {
          text = new Text().addTo(this.parent()).text(text);
        }

        // Create textPath from text and path and return
        return text.path(this)
      }),

      targets() {
        return baseFind('svg textPath').filter((node) => {
          return (node.attr('href') || '').includes(this.id())
        })

        // Does not work in IE11. Use when IE support is dropped
        // return baseFind('svg textPath[*|href*=' + this.id() + ']')
      }
    }
  });

  TextPath.prototype.MorphArray = PathArray;
  register(TextPath, 'TextPath');

  class Use extends Shape {
    constructor(node, attrs = node) {
      super(nodeOrNew('use', node), attrs);
    }

    // Use element as a reference
    use(element, file) {
      // Set lined element
      return this.attr('href', (file || '') + '#' + element, xlink)
    }
  }

  registerMethods({
    Container: {
      // Create a use element
      use: wrapWithAttrCheck(function (element, file) {
        return this.put(new Use()).use(element, file)
      })
    }
  });

  register(Use, 'Use');

  /* Optional Modules */
  const SVG = makeInstance;

  extend([Svg, Symbol$1, Image$1, Pattern, Marker$1], getMethodsFor('viewbox'));

  extend([Line$1, Polyline, Polygon, Path], getMethodsFor('marker'));

  extend(Text, getMethodsFor('Text'));
  extend(Path, getMethodsFor('Path'));

  extend(Defs, getMethodsFor('Defs'));

  extend([Text, Tspan], getMethodsFor('Tspan'));

  extend([Rect, Ellipse, Gradient, Runner], getMethodsFor('radius'));

  extend(EventTarget, getMethodsFor('EventTarget'));
  extend(Dom, getMethodsFor('Dom'));
  extend(Element$1, getMethodsFor('Element'));
  extend(Shape, getMethodsFor('Shape'));
  extend([Container, Fragment], getMethodsFor('Container'));
  extend(Gradient, getMethodsFor('Gradient'));

  extend(Runner, getMethodsFor('Runner'));

  List.extend(getMethodNames());

  registerMorphableType([
    SVGNumber,
    Color,
    Box,
    Matrix,
    SVGArray,
    PointArray,
    PathArray,
    Point
  ]);

  makeMorphable();

  class Filter extends Element$1 {
    constructor (node) {
      super(nodeOrNew('filter', node), node);

      this.$source = 'SourceGraphic';
      this.$sourceAlpha = 'SourceAlpha';
      this.$background = 'BackgroundImage';
      this.$backgroundAlpha = 'BackgroundAlpha';
      this.$fill = 'FillPaint';
      this.$stroke = 'StrokePaint';
      this.$autoSetIn = true;
    }

    put (element, i) {
      element = super.put(element, i);

      if (!element.attr('in') && this.$autoSetIn) {
        element.attr('in', this.$source);
      }
      if (!element.attr('result')) {
        element.attr('result', element.id());
      }

      return element
    }

    // Unmask all masked elements and remove itself
    remove () {
      // unmask all targets
      this.targets().each('unfilter');

      // remove mask from parent
      return super.remove()
    }

    targets () {
      return baseFind('svg [filter*="' + this.id() + '"]')
    }

    toString () {
      return 'url(#' + this.id() + ')'
    }
  }

  // Create Effect class
  class Effect extends Element$1 {
    constructor (node, attr) {
      super(node, attr);
      this.result(this.id());
    }

    in (effect) {
      // Act as getter
      if (effect == null) {
        const _in = this.attr('in');
        const ref = this.parent() && this.parent().find(`[result="${_in}"]`)[0];
        return ref || _in
      }

      // Avr as setter
      return this.attr('in', effect)
    }

    // Named result
    result (result) {
      return this.attr('result', result)
    }

    // Stringification
    toString () {
      return this.result()
    }
  }

  // This function takes an array with attr keys and sets for every key the
  // attribute to the value of one paramater
  // getAttrSetter(['a', 'b']) becomes this.attr({a: param1, b: param2})
  const getAttrSetter = (params) => {
    return function (...args) {
      for (let i = params.length; i--;) {
        if (args[i] != null) {
          this.attr(params[i], args[i]);
        }
      }
    }
  };

  const updateFunctions = {
    blend: getAttrSetter(['in', 'in2', 'mode']),
    // ColorMatrix effect
    colorMatrix: getAttrSetter(['type', 'values']),
    // Composite effect
    composite: getAttrSetter(['in', 'in2', 'operator']),
    // ConvolveMatrix effect
    convolveMatrix: function (matrix) {
      matrix = new SVGArray(matrix).toString();

      this.attr({
        order: Math.sqrt(matrix.split(' ').length),
        kernelMatrix: matrix
      });
    },
    // DiffuseLighting effect
    diffuseLighting: getAttrSetter(['surfaceScale', 'lightingColor', 'diffuseConstant', 'kernelUnitLength']),
    // DisplacementMap effect
    displacementMap: getAttrSetter(['in', 'in2', 'scale', 'xChannelSelector', 'yChannelSelector']),
    // DropShadow effect
    dropShadow: getAttrSetter(['in', 'dx', 'dy', 'stdDeviation']),
    // Flood effect
    flood: getAttrSetter(['flood-color', 'flood-opacity']),
    // Gaussian Blur effect
    gaussianBlur: function (x = 0, y = x) {
      this.attr('stdDeviation', x + ' ' + y);
    },
    // Image effect
    image: function (src) {
      this.attr('href', src, xlink);
    },
    // Morphology effect
    morphology: getAttrSetter(['operator', 'radius']),
    // Offset effect
    offset: getAttrSetter(['dx', 'dy']),
    // SpecularLighting effect
    specularLighting: getAttrSetter(['surfaceScale', 'lightingColor', 'diffuseConstant', 'specularExponent', 'kernelUnitLength']),
    // Tile effect
    tile: getAttrSetter([]),
    // Turbulence effect
    turbulence: getAttrSetter(['baseFrequency', 'numOctaves', 'seed', 'stitchTiles', 'type'])
  };

  const filterNames = [
    'blend',
    'colorMatrix',
    'componentTransfer',
    'composite',
    'convolveMatrix',
    'diffuseLighting',
    'displacementMap',
    'dropShadow',
    'flood',
    'gaussianBlur',
    'image',
    'merge',
    'morphology',
    'offset',
    'specularLighting',
    'tile',
    'turbulence'
  ];

  // For every filter create a class
  filterNames.forEach((effect) => {
    const name = capitalize(effect);
    const fn = updateFunctions[effect];

    Filter[name + 'Effect'] = class extends Effect {
      constructor (node) {
        super(nodeOrNew('fe' + name, node), node);
      }

      // This function takes all parameters from the factory call
      // and updates the attributes according to the updateFunctions
      update (args) {
        fn.apply(this, args);
        return this
      }
    };

    // Add factory function to filter
    // Allow to pass a function or object
    // The attr object is catched from "wrapWithAttrCheck"
    Filter.prototype[effect] = wrapWithAttrCheck(function (fn, ...args) {
      const effect = new Filter[name + 'Effect']();

      if (fn == null) return this.put(effect)

      // For Effects which can take children, a function is allowed
      if (typeof fn === 'function') {
        fn.call(effect, effect);
      } else {
        // In case it is not a function, add it to arguments
        args.unshift(fn);
      }
      return this.put(effect).update(args)
    });
  });

  // Correct factories which are not that simple
  extend(Filter, {
    merge (arrayOrFn) {
      const node = this.put(new Filter.MergeEffect());

      // If a function was passed, execute it
      // That makes stuff like this possible:
      // filter.merge((mergeEffect) => mergeEffect.mergeNode(in))
      if (typeof arrayOrFn === 'function') {
        arrayOrFn.call(node, node);
        return node
      }

      // Check if first child is an array, otherwise use arguments as array
      const children = arrayOrFn instanceof Array ? arrayOrFn : [...arguments];

      children.forEach((child) => {
        if (child instanceof Filter.MergeNode) {
          node.put(child);
        } else {
          node.mergeNode(child);
        }
      });

      return node
    },
    componentTransfer (components = {}) {
      const node = this.put(new Filter.ComponentTransferEffect());

      if (typeof components === 'function') {
        components.call(node, node);
        return node
      }

      // If no component is set, we use the given object for all components
      if (!components.r && !components.g && !components.b && !components.a) {
        const temp = components;
        components = {
          r: temp, g: temp, b: temp, a: temp
        };
      }

      for (const c in components) {
        // components[c] has to hold an attributes object
        node.add(new Filter['Func' + c.toUpperCase()](components[c]));
      }

      return node
    }
  });

  const filterChildNodes = [
    'distantLight',
    'pointLight',
    'spotLight',
    'mergeNode',
    'FuncR',
    'FuncG',
    'FuncB',
    'FuncA'
  ];

  filterChildNodes.forEach((child) => {
    const name = capitalize(child);
    Filter[name] = class extends Effect {
      constructor (node) {
        super(nodeOrNew('fe' + name, node), node);
      }
    };
  });

  const componentFuncs = [
    'funcR',
    'funcG',
    'funcB',
    'funcA'
  ];

  // Add an update function for componentTransfer-children
  componentFuncs.forEach(function (c) {
    const _class = Filter[capitalize(c)];
    const fn = wrapWithAttrCheck(function () {
      return this.put(new _class())
    });

    Filter.ComponentTransferEffect.prototype[c] = fn;
  });

  const lights = [
    'distantLight',
    'pointLight',
    'spotLight'
  ];

  // Add light sources factories to lightining effects
  lights.forEach((light) => {
    const _class = Filter[capitalize(light)];
    const fn = wrapWithAttrCheck(function () {
      return this.put(new _class())
    });

    Filter.DiffuseLightingEffect.prototype[light] = fn;
    Filter.SpecularLightingEffect.prototype[light] = fn;
  });

  extend(Filter.MergeEffect, {
    mergeNode (_in) {
      return this.put(new Filter.MergeNode()).attr('in', _in)
    }
  });

  // add .filter function
  extend(Defs, {
    // Define filter
    filter: function (block) {
      const filter = this.put(new Filter());

      /* invoke passed block */
      if (typeof block === 'function') { block.call(filter, filter); }

      return filter
    }
  });

  extend(Container, {
    // Define filter on defs
    filter: function (block) {
      return this.defs().filter(block)
    }
  });

  extend(Element$1, {
    // Create filter element in defs and store reference
    filterWith: function (block) {
      const filter = block instanceof Filter
        ? block
        : this.defs().filter(block);

      return this.attr('filter', filter)
    },
    // Remove filter
    unfilter: function (remove) {
      /* remove filter attribute */
      return this.attr('filter', null)
    },
    filterer () {
      return this.reference('filter')
    }
  });

  // chaining
  const chainingEffects = {
    // Blend effect
    blend: function (in2, mode) {
      return this.parent() && this.parent().blend(this, in2, mode) // pass this as the first input
    },
    // ColorMatrix effect
    colorMatrix: function (type, values) {
      return this.parent() && this.parent().colorMatrix(type, values).in(this)
    },
    // ComponentTransfer effect
    componentTransfer: function (components) {
      return this.parent() && this.parent().componentTransfer(components).in(this)
    },
    // Composite effect
    composite: function (in2, operator) {
      return this.parent() && this.parent().composite(this, in2, operator) // pass this as the first input
    },
    // ConvolveMatrix effect
    convolveMatrix: function (matrix) {
      return this.parent() && this.parent().convolveMatrix(matrix).in(this)
    },
    // DiffuseLighting effect
    diffuseLighting: function (surfaceScale, lightingColor, diffuseConstant, kernelUnitLength) {
      return this.parent() && this.parent().diffuseLighting(surfaceScale, diffuseConstant, kernelUnitLength).in(this)
    },
    // DisplacementMap effect
    displacementMap: function (in2, scale, xChannelSelector, yChannelSelector) {
      return this.parent() && this.parent().displacementMap(this, in2, scale, xChannelSelector, yChannelSelector) // pass this as the first input
    },
    // DisplacementMap effect
    dropShadow: function (x, y, stdDeviation) {
      return this.parent() && this.parent().dropShadow(this, x, y, stdDeviation).in(this) // pass this as the first input
    },
    // Flood effect
    flood: function (color, opacity) {
      return this.parent() && this.parent().flood(color, opacity) // this effect dont have inputs
    },
    // Gaussian Blur effect
    gaussianBlur: function (x, y) {
      return this.parent() && this.parent().gaussianBlur(x, y).in(this)
    },
    // Image effect
    image: function (src) {
      return this.parent() && this.parent().image(src) // this effect dont have inputs
    },
    // Merge effect
    merge: function (arg) {
      arg = arg instanceof Array ? arg : [...arg];
      return this.parent() && this.parent().merge(this, ...arg) // pass this as the first argument
    },
    // Morphology effect
    morphology: function (operator, radius) {
      return this.parent() && this.parent().morphology(operator, radius).in(this)
    },
    // Offset effect
    offset: function (dx, dy) {
      return this.parent() && this.parent().offset(dx, dy).in(this)
    },
    // SpecularLighting effect
    specularLighting: function (surfaceScale, lightingColor, diffuseConstant, specularExponent, kernelUnitLength) {
      return this.parent() && this.parent().specularLighting(surfaceScale, diffuseConstant, specularExponent, kernelUnitLength).in(this)
    },
    // Tile effect
    tile: function () {
      return this.parent() && this.parent().tile().in(this)
    },
    // Turbulence effect
    turbulence: function (baseFrequency, numOctaves, seed, stitchTiles, type) {
      return this.parent() && this.parent().turbulence(baseFrequency, numOctaves, seed, stitchTiles, type).in(this)
    }
  };

  extend(Effect, chainingEffects);

  // Effect-specific extensions
  extend(Filter.MergeEffect, {
    in: function (effect) {
      if (effect instanceof Filter.MergeNode) {
        this.add(effect, 0);
      } else {
        this.add(new Filter.MergeNode().in(effect), 0);
      }

      return this
    }
  });

  extend([Filter.CompositeEffect, Filter.BlendEffect, Filter.DisplacementMapEffect], {
    in2: function (effect) {
      if (effect == null) {
        const in2 = this.attr('in2');
        const ref = this.parent() && this.parent().find(`[result="${in2}"]`)[0];
        return ref || in2
      }
      return this.attr('in2', effect)
    }
  });

  // Presets
  Filter.filter = {
    sepiatone: [
      0.343, 0.669, 0.119, 0, 0,
      0.249, 0.626, 0.130, 0, 0,
      0.172, 0.334, 0.111, 0, 0,
      0.000, 0.000, 0.000, 1, 0]
  };

  /**
   * ApexCharts Filters Class for setting hover/active states on the paths.
   *
   * @module Formatters
   **/
  var Filters = /*#__PURE__*/function () {
    function Filters(ctx) {
      _classCallCheck(this, Filters);
      this.ctx = ctx;
      this.w = ctx.w;
    }

    // create a re-usable filter which can be appended other filter effects and applied to multiple elements
    _createClass(Filters, [{
      key: "getDefaultFilter",
      value: function getDefaultFilter(el, i) {
        var w = this.w;
        el.unfilter(true);
        var filter = new Filter();
        filter.size('120%', '180%', '-5%', '-40%');
        if (w.config.chart.dropShadow.enabled) {
          this.dropShadow(el, w.config.chart.dropShadow, i);
        }
      }
    }, {
      key: "applyFilter",
      value: function applyFilter(el, i, filterType) {
        var _this = this,
          _el$filterer2;
        var w = this.w;
        el.unfilter(true);
        if (filterType === 'none') {
          this.getDefaultFilter(el, i);
          return;
        }
        var shadowAttr = w.config.chart.dropShadow;
        var brightnessFactor = filterType === 'lighten' ? 2 : 0.3;
        el.filterWith(function (add) {
          add.colorMatrix({
            type: 'matrix',
            values: "\n          ".concat(brightnessFactor, " 0 0 0 0\n          0 ").concat(brightnessFactor, " 0 0 0\n          0 0 ").concat(brightnessFactor, " 0 0\n          0 0 0 1 0\n        "),
            in: 'SourceGraphic',
            result: 'brightness'
          });
          if (shadowAttr.enabled) {
            _this.addShadow(add, i, shadowAttr, 'brightness');
          }
        });
        if (!shadowAttr.noUserSpaceOnUse) {
          var _el$filterer, _el$filterer$node;
          (_el$filterer = el.filterer()) === null || _el$filterer === void 0 ? void 0 : (_el$filterer$node = _el$filterer.node) === null || _el$filterer$node === void 0 ? void 0 : _el$filterer$node.setAttribute('filterUnits', 'userSpaceOnUse');
        }

        // this scales the filter to a bigger size so that the dropshadow doesn't crops
        this._scaleFilterSize((_el$filterer2 = el.filterer()) === null || _el$filterer2 === void 0 ? void 0 : _el$filterer2.node);
      }

      // appends dropShadow to the filter object which can be chained with other filter effects
    }, {
      key: "addShadow",
      value: function addShadow(add, i, attrs, source) {
        var _w$config$chart$dropS;
        var w = this.w;
        var blur = attrs.blur,
          top = attrs.top,
          left = attrs.left,
          color = attrs.color,
          opacity = attrs.opacity;
        color = Array.isArray(color) ? color[i] : color;
        if (((_w$config$chart$dropS = w.config.chart.dropShadow.enabledOnSeries) === null || _w$config$chart$dropS === void 0 ? void 0 : _w$config$chart$dropS.length) > 0) {
          if (w.config.chart.dropShadow.enabledOnSeries.indexOf(i) === -1) {
            return add;
          }
        }
        add.offset({
          in: source,
          dx: left,
          dy: top,
          result: 'offset'
        });
        add.gaussianBlur({
          in: 'offset',
          stdDeviation: blur,
          result: 'blur'
        });
        add.flood({
          'flood-color': color,
          'flood-opacity': opacity,
          result: 'flood'
        });
        add.composite({
          in: 'flood',
          in2: 'blur',
          operator: 'in',
          result: 'shadow'
        });
        add.merge(['shadow', source]);
      }

      // directly adds dropShadow to the element and returns the same element.
    }, {
      key: "dropShadow",
      value: function dropShadow(el, attrs) {
        var _w$config$chart$dropS2,
          _this2 = this,
          _el$filterer4;
        var i = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
        var w = this.w;
        el.unfilter(true);
        if (Utils$1.isMsEdge() && w.config.chart.type === 'radialBar') {
          // in radialbar charts, dropshadow is clipping actual drawing in IE
          return el;
        }
        if (((_w$config$chart$dropS2 = w.config.chart.dropShadow.enabledOnSeries) === null || _w$config$chart$dropS2 === void 0 ? void 0 : _w$config$chart$dropS2.length) > 0) {
          var _w$config$chart$dropS3;
          if (((_w$config$chart$dropS3 = w.config.chart.dropShadow.enabledOnSeries) === null || _w$config$chart$dropS3 === void 0 ? void 0 : _w$config$chart$dropS3.indexOf(i)) === -1) {
            return el;
          }
        }
        el.filterWith(function (add) {
          _this2.addShadow(add, i, attrs, 'SourceGraphic');
        });
        if (!attrs.noUserSpaceOnUse) {
          var _el$filterer3, _el$filterer3$node;
          (_el$filterer3 = el.filterer()) === null || _el$filterer3 === void 0 ? void 0 : (_el$filterer3$node = _el$filterer3.node) === null || _el$filterer3$node === void 0 ? void 0 : _el$filterer3$node.setAttribute('filterUnits', 'userSpaceOnUse');
        }

        // this scales the filter to a bigger size so that the dropshadow doesn't crops
        this._scaleFilterSize((_el$filterer4 = el.filterer()) === null || _el$filterer4 === void 0 ? void 0 : _el$filterer4.node);
        return el;
      }
    }, {
      key: "setSelectionFilter",
      value: function setSelectionFilter(el, realIndex, dataPointIndex) {
        var w = this.w;
        if (typeof w.globals.selectedDataPoints[realIndex] !== 'undefined') {
          if (w.globals.selectedDataPoints[realIndex].indexOf(dataPointIndex) > -1) {
            el.node.setAttribute('selected', true);
            var activeFilter = w.config.states.active.filter;
            if (activeFilter !== 'none') {
              this.applyFilter(el, realIndex, activeFilter.type);
            }
          }
        }
      }
    }, {
      key: "_scaleFilterSize",
      value: function _scaleFilterSize(el) {
        if (!el) return;
        var setAttributes = function setAttributes(attrs) {
          for (var key in attrs) {
            if (attrs.hasOwnProperty(key)) {
              el.setAttribute(key, attrs[key]);
            }
          }
        };
        setAttributes({
          width: '200%',
          height: '200%',
          x: '-50%',
          y: '-50%'
        });
      }
    }]);
    return Filters;
  }();

  /**
   * ApexCharts Graphics Class for all drawing operations.
   *
   * @module Graphics
   **/
  var Graphics = /*#__PURE__*/function () {
    function Graphics(ctx) {
      _classCallCheck(this, Graphics);
      this.ctx = ctx;
      this.w = ctx.w;
    }

    /*****************************************************************************
     *                                                                            *
     *  SVG Path Rounding Function                                                *
     *  Copyright (C) 2014 Yona Appletree                                         *
     *                                                                            *
     *  Licensed under the Apache License, Version 2.0 (the "License");           *
     *  you may not use this file except in compliance with the License.          *
     *  You may obtain a copy of the License at                                   *
     *                                                                            *
     *      http://www.apache.org/licenses/LICENSE-2.0                            *
     *                                                                            *
     *  Unless required by applicable law or agreed to in writing, software       *
     *  distributed under the License is distributed on an "AS IS" BASIS,         *
     *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  *
     *  See the License for the specific language governing permissions and       *
     *  limitations under the License.                                            *
     *                                                                            *
     *****************************************************************************/

    /**
     * SVG Path rounding function. Takes an input path string and outputs a path
     * string where all line-line corners have been rounded. Only supports absolute
     * commands at the moment.
     *
     * @param pathString The SVG input path
     * @param radius The amount to round the corners, either a value in the SVG
     *               coordinate space, or, if useFractionalRadius is true, a value
     *               from 0 to 1.
     * @returns A new SVG path string with the rounding
     */
    _createClass(Graphics, [{
      key: "roundPathCorners",
      value: function roundPathCorners(pathString, radius) {
        if (pathString.indexOf('NaN') > -1) pathString = '';
        function moveTowardsLength(movingPoint, targetPoint, amount) {
          var width = targetPoint.x - movingPoint.x;
          var height = targetPoint.y - movingPoint.y;
          var distance = Math.sqrt(width * width + height * height);
          return moveTowardsFractional(movingPoint, targetPoint, Math.min(1, amount / distance));
        }
        function moveTowardsFractional(movingPoint, targetPoint, fraction) {
          return {
            x: movingPoint.x + (targetPoint.x - movingPoint.x) * fraction,
            y: movingPoint.y + (targetPoint.y - movingPoint.y) * fraction
          };
        }

        // Adjusts the ending position of a command
        function adjustCommand(cmd, newPoint) {
          if (cmd.length > 2) {
            cmd[cmd.length - 2] = newPoint.x;
            cmd[cmd.length - 1] = newPoint.y;
          }
        }

        // Gives an {x, y} object for a command's ending position
        function pointForCommand(cmd) {
          return {
            x: parseFloat(cmd[cmd.length - 2]),
            y: parseFloat(cmd[cmd.length - 1])
          };
        }

        // Split apart the path, handing concatonated letters and numbers
        var pathParts = pathString.split(/[,\s]/).reduce(function (parts, part) {
          var match = part.match(/^([a-zA-Z])(.+)/);
          if (match) {
            parts.push(match[1]);
            parts.push(match[2]);
          } else {
            parts.push(part);
          }
          return parts;
        }, []);

        // Group the commands with their arguments for easier handling
        var commands = pathParts.reduce(function (commands, part) {
          if (parseFloat(part) == part && commands.length) {
            commands[commands.length - 1].push(part);
          } else {
            commands.push([part]);
          }
          return commands;
        }, []);

        // The resulting commands, also grouped
        var resultCommands = [];
        if (commands.length > 1) {
          var startPoint = pointForCommand(commands[0]);

          // Handle the close path case with a "virtual" closing line
          var virtualCloseLine = null;
          if (commands[commands.length - 1][0] == 'Z' && commands[0].length > 2) {
            virtualCloseLine = ['L', startPoint.x, startPoint.y];
            commands[commands.length - 1] = virtualCloseLine;
          }

          // We always use the first command (but it may be mutated)
          resultCommands.push(commands[0]);
          for (var cmdIndex = 1; cmdIndex < commands.length; cmdIndex++) {
            var prevCmd = resultCommands[resultCommands.length - 1];
            var curCmd = commands[cmdIndex];

            // Handle closing case
            var nextCmd = curCmd == virtualCloseLine ? commands[1] : commands[cmdIndex + 1];

            // Nasty logic to decide if this path is a candidite.
            if (nextCmd && prevCmd && prevCmd.length > 2 && curCmd[0] == 'L' && nextCmd.length > 2 && nextCmd[0] == 'L') {
              // Calc the points we're dealing with
              var prevPoint = pointForCommand(prevCmd);
              var curPoint = pointForCommand(curCmd);
              var nextPoint = pointForCommand(nextCmd);

              // The start and end of the cuve are just our point moved towards the previous and next points, respectivly
              var curveStart, curveEnd;
              curveStart = moveTowardsLength(curPoint, prevPoint, radius);
              curveEnd = moveTowardsLength(curPoint, nextPoint, radius);

              // Adjust the current command and add it
              adjustCommand(curCmd, curveStart);
              curCmd.origPoint = curPoint;
              resultCommands.push(curCmd);

              // The curve control points are halfway between the start/end of the curve and
              // the original point
              var startControl = moveTowardsFractional(curveStart, curPoint, 0.5);
              var endControl = moveTowardsFractional(curPoint, curveEnd, 0.5);

              // Create the curve
              var curveCmd = ['C', startControl.x, startControl.y, endControl.x, endControl.y, curveEnd.x, curveEnd.y];
              // Save the original point for fractional calculations
              curveCmd.origPoint = curPoint;
              resultCommands.push(curveCmd);
            } else {
              // Pass through commands that don't qualify
              resultCommands.push(curCmd);
            }
          }

          // Fix up the starting point and restore the close path if the path was orignally closed
          if (virtualCloseLine) {
            var newStartPoint = pointForCommand(resultCommands[resultCommands.length - 1]);
            resultCommands.push(['Z']);
            adjustCommand(resultCommands[0], newStartPoint);
          }
        } else {
          resultCommands = commands;
        }
        return resultCommands.reduce(function (str, c) {
          return str + c.join(' ') + ' ';
        }, '');
      }
    }, {
      key: "drawLine",
      value: function drawLine(x1, y1, x2, y2) {
        var lineColor = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : '#a8a8a8';
        var dashArray = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 0;
        var strokeWidth = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : null;
        var strokeLineCap = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : 'butt';
        var w = this.w;
        var line = w.globals.dom.Paper.line().attr({
          x1: x1,
          y1: y1,
          x2: x2,
          y2: y2,
          stroke: lineColor,
          'stroke-dasharray': dashArray,
          'stroke-width': strokeWidth,
          'stroke-linecap': strokeLineCap
        });
        return line;
      }
    }, {
      key: "drawRect",
      value: function drawRect() {
        var x1 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
        var y1 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
        var x2 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
        var y2 = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
        var radius = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;
        var color = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : '#fefefe';
        var opacity = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : 1;
        var strokeWidth = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : null;
        var strokeColor = arguments.length > 8 && arguments[8] !== undefined ? arguments[8] : null;
        var strokeDashArray = arguments.length > 9 && arguments[9] !== undefined ? arguments[9] : 0;
        var w = this.w;
        var rect = w.globals.dom.Paper.rect();
        rect.attr({
          x: x1,
          y: y1,
          width: x2 > 0 ? x2 : 0,
          height: y2 > 0 ? y2 : 0,
          rx: radius,
          ry: radius,
          opacity: opacity,
          'stroke-width': strokeWidth !== null ? strokeWidth : 0,
          stroke: strokeColor !== null ? strokeColor : 'none',
          'stroke-dasharray': strokeDashArray
        });

        // fix apexcharts.js#1410
        rect.node.setAttribute('fill', color);
        return rect;
      }
    }, {
      key: "drawPolygon",
      value: function drawPolygon(polygonString) {
        var stroke = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '#e1e1e1';
        var strokeWidth = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 1;
        var fill = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 'none';
        var w = this.w;
        var polygon = w.globals.dom.Paper.polygon(polygonString).attr({
          fill: fill,
          stroke: stroke,
          'stroke-width': strokeWidth
        });
        return polygon;
      }
    }, {
      key: "drawCircle",
      value: function drawCircle(radius) {
        var attrs = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
        var w = this.w;
        if (radius < 0) radius = 0;
        var c = w.globals.dom.Paper.circle(radius * 2);
        if (attrs !== null) {
          c.attr(attrs);
        }
        return c;
      }
    }, {
      key: "drawPath",
      value: function drawPath(_ref) {
        var _ref$d = _ref.d,
          d = _ref$d === void 0 ? '' : _ref$d,
          _ref$stroke = _ref.stroke,
          stroke = _ref$stroke === void 0 ? '#a8a8a8' : _ref$stroke,
          _ref$strokeWidth = _ref.strokeWidth,
          strokeWidth = _ref$strokeWidth === void 0 ? 1 : _ref$strokeWidth,
          fill = _ref.fill,
          _ref$fillOpacity = _ref.fillOpacity,
          fillOpacity = _ref$fillOpacity === void 0 ? 1 : _ref$fillOpacity,
          _ref$strokeOpacity = _ref.strokeOpacity,
          strokeOpacity = _ref$strokeOpacity === void 0 ? 1 : _ref$strokeOpacity,
          classes = _ref.classes,
          _ref$strokeLinecap = _ref.strokeLinecap,
          strokeLinecap = _ref$strokeLinecap === void 0 ? null : _ref$strokeLinecap,
          _ref$strokeDashArray = _ref.strokeDashArray,
          strokeDashArray = _ref$strokeDashArray === void 0 ? 0 : _ref$strokeDashArray;
        var w = this.w;
        if (strokeLinecap === null) {
          strokeLinecap = w.config.stroke.lineCap;
        }
        if (d.indexOf('undefined') > -1 || d.indexOf('NaN') > -1) {
          d = "M 0 ".concat(w.globals.gridHeight);
        }
        var p = w.globals.dom.Paper.path(d).attr({
          fill: fill,
          'fill-opacity': fillOpacity,
          stroke: stroke,
          'stroke-opacity': strokeOpacity,
          'stroke-linecap': strokeLinecap,
          'stroke-width': strokeWidth,
          'stroke-dasharray': strokeDashArray,
          class: classes
        });
        return p;
      }
    }, {
      key: "group",
      value: function group() {
        var attrs = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
        var w = this.w;
        var g = w.globals.dom.Paper.group();
        if (attrs !== null) {
          g.attr(attrs);
        }
        return g;
      }
    }, {
      key: "move",
      value: function move(x, y) {
        var move = ['M', x, y].join(' ');
        return move;
      }
    }, {
      key: "line",
      value: function line(x, y) {
        var hORv = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
        var line = null;
        if (hORv === null) {
          line = [' L', x, y].join(' ');
        } else if (hORv === 'H') {
          line = [' H', x].join(' ');
        } else if (hORv === 'V') {
          line = [' V', y].join(' ');
        }
        return line;
      }
    }, {
      key: "curve",
      value: function curve(x1, y1, x2, y2, x, y) {
        var curve = ['C', x1, y1, x2, y2, x, y].join(' ');
        return curve;
      }
    }, {
      key: "quadraticCurve",
      value: function quadraticCurve(x1, y1, x, y) {
        var curve = ['Q', x1, y1, x, y].join(' ');
        return curve;
      }
    }, {
      key: "arc",
      value: function arc(rx, ry, axisRotation, largeArcFlag, sweepFlag, x, y) {
        var relative = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : false;
        var coord = 'A';
        if (relative) coord = 'a';
        var arc = [coord, rx, ry, axisRotation, largeArcFlag, sweepFlag, x, y].join(' ');
        return arc;
      }

      /**
       * @memberof Graphics
       * @param {object}
       *  i = series's index
       *  realIndex = realIndex is series's actual index when it was drawn time. After several redraws, the iterating "i" may change in loops, but realIndex doesn't
       *  pathFrom = existing pathFrom to animateTo
       *  pathTo = new Path to which d attr will be animated from pathFrom to pathTo
       *  stroke = line Color
       *  strokeWidth = width of path Line
       *  fill = it can be gradient, single color, pattern or image
       *  animationDelay = how much to delay when starting animation (in milliseconds)
       *  dataChangeSpeed = for dynamic animations, when data changes
       *  className = class attribute to add
       * @return {object} svg.js path object
       **/
    }, {
      key: "renderPaths",
      value: function renderPaths(_ref2) {
        var j = _ref2.j,
          realIndex = _ref2.realIndex,
          pathFrom = _ref2.pathFrom,
          pathTo = _ref2.pathTo,
          stroke = _ref2.stroke,
          strokeWidth = _ref2.strokeWidth,
          strokeLinecap = _ref2.strokeLinecap,
          fill = _ref2.fill,
          animationDelay = _ref2.animationDelay,
          initialSpeed = _ref2.initialSpeed,
          dataChangeSpeed = _ref2.dataChangeSpeed,
          className = _ref2.className,
          chartType = _ref2.chartType,
          _ref2$shouldClipToGri = _ref2.shouldClipToGrid,
          shouldClipToGrid = _ref2$shouldClipToGri === void 0 ? true : _ref2$shouldClipToGri,
          _ref2$bindEventsOnPat = _ref2.bindEventsOnPaths,
          bindEventsOnPaths = _ref2$bindEventsOnPat === void 0 ? true : _ref2$bindEventsOnPat,
          _ref2$drawShadow = _ref2.drawShadow,
          drawShadow = _ref2$drawShadow === void 0 ? true : _ref2$drawShadow;
        var w = this.w;
        var filters = new Filters(this.ctx);
        var anim = new Animations(this.ctx);
        var initialAnim = this.w.config.chart.animations.enabled;
        var dynamicAnim = initialAnim && this.w.config.chart.animations.dynamicAnimation.enabled;

        // Fix for paths starting with M 0 0
        if (pathFrom && pathFrom.startsWith('M 0 0') && pathTo) {
          var moveCommand = pathTo.match(/^M\s+[\d.-]+\s+[\d.-]+/);
          if (moveCommand) {
            pathFrom = pathFrom.replace(/^M\s+0\s+0/, moveCommand[0]);
          }
        }
        var d;
        var shouldAnimate = !!(initialAnim && !w.globals.resized || dynamicAnim && w.globals.dataChanged && w.globals.shouldAnimate);
        if (shouldAnimate) {
          d = pathFrom;
        } else {
          d = pathTo;
          w.globals.animationEnded = true;
        }
        var strokeDashArrayOpt = w.config.stroke.dashArray;
        var strokeDashArray = 0;
        if (Array.isArray(strokeDashArrayOpt)) {
          strokeDashArray = strokeDashArrayOpt[realIndex];
        } else {
          strokeDashArray = w.config.stroke.dashArray;
        }
        var el = this.drawPath({
          d: d,
          stroke: stroke,
          strokeWidth: strokeWidth,
          fill: fill,
          fillOpacity: 1,
          classes: className,
          strokeLinecap: strokeLinecap,
          strokeDashArray: strokeDashArray
        });
        el.attr('index', realIndex);
        if (shouldClipToGrid) {
          if (chartType === 'bar' && !w.globals.isHorizontal || w.globals.comboCharts) {
            el.attr({
              'clip-path': "url(#gridRectBarMask".concat(w.globals.cuid, ")")
            });
          } else {
            el.attr({
              'clip-path': "url(#gridRectMask".concat(w.globals.cuid, ")")
            });
          }
        }
        if (w.config.chart.dropShadow.enabled && drawShadow) {
          filters.dropShadow(el, w.config.chart.dropShadow, realIndex);
        }
        if (bindEventsOnPaths) {
          el.node.addEventListener('mouseenter', this.pathMouseEnter.bind(this, el));
          el.node.addEventListener('mouseleave', this.pathMouseLeave.bind(this, el));
          el.node.addEventListener('mousedown', this.pathMouseDown.bind(this, el));
        }
        el.attr({
          pathTo: pathTo,
          pathFrom: pathFrom
        });
        var defaultAnimateOpts = {
          el: el,
          j: j,
          realIndex: realIndex,
          pathFrom: pathFrom,
          pathTo: pathTo,
          fill: fill,
          strokeWidth: strokeWidth,
          delay: animationDelay
        };
        if (initialAnim && !w.globals.resized && !w.globals.dataChanged) {
          anim.animatePathsGradually(_objectSpread2(_objectSpread2({}, defaultAnimateOpts), {}, {
            speed: initialSpeed
          }));
        } else {
          if (w.globals.resized || !w.globals.dataChanged) {
            anim.showDelayedElements();
          }
        }
        if (w.globals.dataChanged && dynamicAnim && shouldAnimate) {
          anim.animatePathsGradually(_objectSpread2(_objectSpread2({}, defaultAnimateOpts), {}, {
            speed: dataChangeSpeed
          }));
        }
        return el;
      }
    }, {
      key: "drawPattern",
      value: function drawPattern(style, width, height) {
        var stroke = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : '#a8a8a8';
        var strokeWidth = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;
        var w = this.w;
        var p = w.globals.dom.Paper.pattern(width, height, function (add) {
          if (style === 'horizontalLines') {
            add.line(0, 0, height, 0).stroke({
              color: stroke,
              width: strokeWidth + 1
            });
          } else if (style === 'verticalLines') {
            add.line(0, 0, 0, width).stroke({
              color: stroke,
              width: strokeWidth + 1
            });
          } else if (style === 'slantedLines') {
            add.line(0, 0, width, height).stroke({
              color: stroke,
              width: strokeWidth
            });
          } else if (style === 'squares') {
            add.rect(width, height).fill('none').stroke({
              color: stroke,
              width: strokeWidth
            });
          } else if (style === 'circles') {
            add.circle(width).fill('none').stroke({
              color: stroke,
              width: strokeWidth
            });
          }
        });
        return p;
      }
    }, {
      key: "drawGradient",
      value: function drawGradient(style, gfrom, gto, opacityFrom, opacityTo) {
        var size = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : null;
        var stops = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : null;
        var colorStops = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : [];
        var i = arguments.length > 8 && arguments[8] !== undefined ? arguments[8] : 0;
        var w = this.w;
        var g;
        if (gfrom.length < 9 && gfrom.indexOf('#') === 0) {
          // if the hex contains alpha and is of 9 digit, skip the opacity
          gfrom = Utils$1.hexToRgba(gfrom, opacityFrom);
        }
        if (gto.length < 9 && gto.indexOf('#') === 0) {
          gto = Utils$1.hexToRgba(gto, opacityTo);
        }
        var stop1 = 0;
        var stop2 = 1;
        var stop3 = 1;
        var stop4 = null;
        if (stops !== null) {
          stop1 = typeof stops[0] !== 'undefined' ? stops[0] / 100 : 0;
          stop2 = typeof stops[1] !== 'undefined' ? stops[1] / 100 : 1;
          stop3 = typeof stops[2] !== 'undefined' ? stops[2] / 100 : 1;
          stop4 = typeof stops[3] !== 'undefined' ? stops[3] / 100 : null;
        }
        var radial = !!(w.config.chart.type === 'donut' || w.config.chart.type === 'pie' || w.config.chart.type === 'polarArea' || w.config.chart.type === 'bubble');
        if (!colorStops || colorStops.length === 0) {
          g = w.globals.dom.Paper.gradient(radial ? 'radial' : 'linear', function (add) {
            add.stop(stop1, gfrom, opacityFrom);
            add.stop(stop2, gto, opacityTo);
            add.stop(stop3, gto, opacityTo);
            if (stop4 !== null) {
              add.stop(stop4, gfrom, opacityFrom);
            }
          });
        } else {
          g = w.globals.dom.Paper.gradient(radial ? 'radial' : 'linear', function (add) {
            var gradientStops = Array.isArray(colorStops[i]) ? colorStops[i] : colorStops;
            gradientStops.forEach(function (s) {
              add.stop(s.offset / 100, s.color, s.opacity);
            });
          });
        }
        if (!radial) {
          if (style === 'vertical') {
            g.from(0, 0).to(0, 1);
          } else if (style === 'diagonal') {
            g.from(0, 0).to(1, 1);
          } else if (style === 'horizontal') {
            g.from(0, 1).to(1, 1);
          } else if (style === 'diagonal2') {
            g.from(1, 0).to(0, 1);
          }
        } else {
          var offx = w.globals.gridWidth / 2;
          var offy = w.globals.gridHeight / 2;
          if (w.config.chart.type !== 'bubble') {
            g.attr({
              gradientUnits: 'userSpaceOnUse',
              cx: offx,
              cy: offy,
              r: size
            });
          } else {
            g.attr({
              cx: 0.5,
              cy: 0.5,
              r: 0.8,
              fx: 0.2,
              fy: 0.2
            });
          }
        }
        return g;
      }
    }, {
      key: "getTextBasedOnMaxWidth",
      value: function getTextBasedOnMaxWidth(_ref3) {
        var text = _ref3.text,
          maxWidth = _ref3.maxWidth,
          fontSize = _ref3.fontSize,
          fontFamily = _ref3.fontFamily;
        var tRects = this.getTextRects(text, fontSize, fontFamily);
        var wordWidth = tRects.width / text.length;
        var wordsBasedOnWidth = Math.floor(maxWidth / wordWidth);
        if (maxWidth < tRects.width) {
          return text.slice(0, wordsBasedOnWidth - 3) + '...';
        }
        return text;
      }
    }, {
      key: "drawText",
      value: function drawText(_ref4) {
        var _this = this;
        var x = _ref4.x,
          y = _ref4.y,
          text = _ref4.text,
          textAnchor = _ref4.textAnchor,
          fontSize = _ref4.fontSize,
          fontFamily = _ref4.fontFamily,
          fontWeight = _ref4.fontWeight,
          foreColor = _ref4.foreColor,
          opacity = _ref4.opacity,
          maxWidth = _ref4.maxWidth,
          _ref4$cssClass = _ref4.cssClass,
          cssClass = _ref4$cssClass === void 0 ? '' : _ref4$cssClass,
          _ref4$isPlainText = _ref4.isPlainText,
          isPlainText = _ref4$isPlainText === void 0 ? true : _ref4$isPlainText,
          _ref4$dominantBaselin = _ref4.dominantBaseline,
          dominantBaseline = _ref4$dominantBaselin === void 0 ? 'auto' : _ref4$dominantBaselin;
        var w = this.w;
        if (typeof text === 'undefined') text = '';
        var truncatedText = text;
        if (!textAnchor) {
          textAnchor = 'start';
        }
        if (!foreColor || !foreColor.length) {
          foreColor = w.config.chart.foreColor;
        }
        fontFamily = fontFamily || w.config.chart.fontFamily;
        fontSize = fontSize || '11px';
        fontWeight = fontWeight || 'regular';
        var commonProps = {
          maxWidth: maxWidth,
          fontSize: fontSize,
          fontFamily: fontFamily
        };
        var elText;
        if (Array.isArray(text)) {
          elText = w.globals.dom.Paper.text(function (add) {
            for (var i = 0; i < text.length; i++) {
              truncatedText = text[i];
              if (maxWidth) {
                truncatedText = _this.getTextBasedOnMaxWidth(_objectSpread2({
                  text: text[i]
                }, commonProps));
              }
              i === 0 ? add.tspan(truncatedText) : add.tspan(truncatedText).newLine();
            }
          });
        } else {
          if (maxWidth) {
            truncatedText = this.getTextBasedOnMaxWidth(_objectSpread2({
              text: text
            }, commonProps));
          }
          elText = isPlainText ? w.globals.dom.Paper.plain(text) : w.globals.dom.Paper.text(function (add) {
            return add.tspan(truncatedText);
          });
        }
        elText.attr({
          x: x,
          y: y,
          'text-anchor': textAnchor,
          'dominant-baseline': dominantBaseline,
          'font-size': fontSize,
          'font-family': fontFamily,
          'font-weight': fontWeight,
          fill: foreColor,
          class: 'apexcharts-text ' + cssClass
        });
        elText.node.style.fontFamily = fontFamily;
        elText.node.style.opacity = opacity;
        return elText;
      }
    }, {
      key: "getMarkerPath",
      value: function getMarkerPath(x, y, type, size) {
        var d = '';
        switch (type) {
          case 'cross':
            size = size / 1.4;
            d = "M ".concat(x - size, " ").concat(y - size, " L ").concat(x + size, " ").concat(y + size, "  M ").concat(x - size, " ").concat(y + size, " L ").concat(x + size, " ").concat(y - size);
            break;
          case 'plus':
            size = size / 1.12;
            d = "M ".concat(x - size, " ").concat(y, " L ").concat(x + size, " ").concat(y, "  M ").concat(x, " ").concat(y - size, " L ").concat(x, " ").concat(y + size);
            break;
          case 'star':
          case 'sparkle':
            var points = 5;
            size = size * 1.15;
            if (type === 'sparkle') {
              size = size / 1.1;
              points = 4;
            }
            var step = Math.PI / points;
            for (var i = 0; i <= 2 * points; i++) {
              var angle = i * step;
              var radius = i % 2 === 0 ? size : size / 2;
              var xPos = x + radius * Math.sin(angle);
              var yPos = y - radius * Math.cos(angle);
              d += (i === 0 ? 'M' : 'L') + xPos + ',' + yPos;
            }
            d += 'Z';
            break;
          case 'triangle':
            d = "M ".concat(x, " ").concat(y - size, " \n             L ").concat(x + size, " ").concat(y + size, " \n             L ").concat(x - size, " ").concat(y + size, " \n             Z");
            break;
          case 'square':
          case 'rect':
            size = size / 1.125;
            d = "M ".concat(x - size, " ").concat(y - size, " \n           L ").concat(x + size, " ").concat(y - size, " \n           L ").concat(x + size, " ").concat(y + size, " \n           L ").concat(x - size, " ").concat(y + size, " \n           Z");
            break;
          case 'diamond':
            size = size * 1.05;
            d = "M ".concat(x, " ").concat(y - size, " \n             L ").concat(x + size, " ").concat(y, " \n             L ").concat(x, " ").concat(y + size, " \n             L ").concat(x - size, " ").concat(y, " \n            Z");
            break;
          case 'line':
            size = size / 1.1;
            d = "M ".concat(x - size, " ").concat(y, " \n           L ").concat(x + size, " ").concat(y);
            break;
          case 'circle':
          default:
            size = size * 2;
            d = "M ".concat(x, ", ").concat(y, " \n           m -").concat(size / 2, ", 0 \n           a ").concat(size / 2, ",").concat(size / 2, " 0 1,0 ").concat(size, ",0 \n           a ").concat(size / 2, ",").concat(size / 2, " 0 1,0 -").concat(size, ",0");
            break;
        }
        return d;
      }

      /**
       * @param {number} x - The x-coordinate of the marker
       * @param {number} y - The y-coordinate of the marker.
       * @param {number} size - The size of the marker
       * @param {Object} opts - The options for the marker.
       * @returns {Object} The created marker.
       */
    }, {
      key: "drawMarkerShape",
      value: function drawMarkerShape(x, y, type, size, opts) {
        var path = this.drawPath({
          d: this.getMarkerPath(x, y, type, size, opts),
          stroke: opts.pointStrokeColor,
          strokeDashArray: opts.pointStrokeDashArray,
          strokeWidth: opts.pointStrokeWidth,
          fill: opts.pointFillColor,
          fillOpacity: opts.pointFillOpacity,
          strokeOpacity: opts.pointStrokeOpacity
        });
        path.attr({
          cx: x,
          cy: y,
          shape: opts.shape,
          class: opts.class ? opts.class : ''
        });
        return path;
      }
    }, {
      key: "drawMarker",
      value: function drawMarker(x, y, opts) {
        x = x || 0;
        var size = opts.pSize || 0;
        if (!Utils$1.isNumber(y)) {
          size = 0;
          y = 0;
        }
        return this.drawMarkerShape(x, y, opts === null || opts === void 0 ? void 0 : opts.shape, size, _objectSpread2(_objectSpread2({}, opts), opts.shape === 'line' || opts.shape === 'plus' || opts.shape === 'cross' ? {
          pointStrokeColor: opts.pointFillColor,
          pointStrokeOpacity: opts.pointFillOpacity
        } : {}));
      }
    }, {
      key: "pathMouseEnter",
      value: function pathMouseEnter(path, e) {
        var w = this.w;
        var filters = new Filters(this.ctx);
        var i = parseInt(path.node.getAttribute('index'), 10);
        var j = parseInt(path.node.getAttribute('j'), 10);
        if (typeof w.config.chart.events.dataPointMouseEnter === 'function') {
          w.config.chart.events.dataPointMouseEnter(e, this.ctx, {
            seriesIndex: i,
            dataPointIndex: j,
            w: w
          });
        }
        this.ctx.events.fireEvent('dataPointMouseEnter', [e, this.ctx, {
          seriesIndex: i,
          dataPointIndex: j,
          w: w
        }]);
        if (w.config.states.active.filter.type !== 'none') {
          if (path.node.getAttribute('selected') === 'true') {
            return;
          }
        }
        if (w.config.states.hover.filter.type !== 'none') {
          if (!w.globals.isTouchDevice) {
            var hoverFilter = w.config.states.hover.filter;
            filters.applyFilter(path, i, hoverFilter.type);
          }
        }
      }
    }, {
      key: "pathMouseLeave",
      value: function pathMouseLeave(path, e) {
        var w = this.w;
        var filters = new Filters(this.ctx);
        var i = parseInt(path.node.getAttribute('index'), 10);
        var j = parseInt(path.node.getAttribute('j'), 10);
        if (typeof w.config.chart.events.dataPointMouseLeave === 'function') {
          w.config.chart.events.dataPointMouseLeave(e, this.ctx, {
            seriesIndex: i,
            dataPointIndex: j,
            w: w
          });
        }
        this.ctx.events.fireEvent('dataPointMouseLeave', [e, this.ctx, {
          seriesIndex: i,
          dataPointIndex: j,
          w: w
        }]);
        if (w.config.states.active.filter.type !== 'none') {
          if (path.node.getAttribute('selected') === 'true') {
            return;
          }
        }
        if (w.config.states.hover.filter.type !== 'none') {
          filters.getDefaultFilter(path, i);
        }
      }
    }, {
      key: "pathMouseDown",
      value: function pathMouseDown(path, e) {
        var w = this.w;
        var filters = new Filters(this.ctx);
        var i = parseInt(path.node.getAttribute('index'), 10);
        var j = parseInt(path.node.getAttribute('j'), 10);
        var selected = 'false';
        if (path.node.getAttribute('selected') === 'true') {
          path.node.setAttribute('selected', 'false');
          if (w.globals.selectedDataPoints[i].indexOf(j) > -1) {
            var index = w.globals.selectedDataPoints[i].indexOf(j);
            w.globals.selectedDataPoints[i].splice(index, 1);
          }
        } else {
          if (!w.config.states.active.allowMultipleDataPointsSelection && w.globals.selectedDataPoints.length > 0) {
            w.globals.selectedDataPoints = [];
            var elPaths = w.globals.dom.Paper.find('.apexcharts-series path:not(.apexcharts-decoration-element)');
            var elCircles = w.globals.dom.Paper.find('.apexcharts-series circle:not(.apexcharts-decoration-element), .apexcharts-series rect:not(.apexcharts-decoration-element)');
            var deSelect = function deSelect(els) {
              Array.prototype.forEach.call(els, function (el) {
                el.node.setAttribute('selected', 'false');
                filters.getDefaultFilter(el, i);
              });
            };
            deSelect(elPaths);
            deSelect(elCircles);
          }
          path.node.setAttribute('selected', 'true');
          selected = 'true';
          if (typeof w.globals.selectedDataPoints[i] === 'undefined') {
            w.globals.selectedDataPoints[i] = [];
          }
          w.globals.selectedDataPoints[i].push(j);
        }
        if (selected === 'true') {
          var activeFilter = w.config.states.active.filter;
          if (activeFilter !== 'none') {
            filters.applyFilter(path, i, activeFilter.type);
          } else {
            // Reapply the hover filter in case it was removed by `deselect`when there is no active filter and it is not a touch device
            if (w.config.states.hover.filter !== 'none') {
              if (!w.globals.isTouchDevice) {
                var hoverFilter = w.config.states.hover.filter;
                filters.applyFilter(path, i, hoverFilter.type);
              }
            }
          }
        } else {
          // If the item was deselected, apply hover state filter if it is not a touch device
          if (w.config.states.active.filter.type !== 'none') {
            if (w.config.states.hover.filter.type !== 'none' && !w.globals.isTouchDevice) {
              var hoverFilter = w.config.states.hover.filter;
              filters.applyFilter(path, i, hoverFilter.type);
            } else {
              filters.getDefaultFilter(path, i);
            }
          }
        }
        if (typeof w.config.chart.events.dataPointSelection === 'function') {
          w.config.chart.events.dataPointSelection(e, this.ctx, {
            selectedDataPoints: w.globals.selectedDataPoints,
            seriesIndex: i,
            dataPointIndex: j,
            w: w
          });
        }
        if (e) {
          this.ctx.events.fireEvent('dataPointSelection', [e, this.ctx, {
            selectedDataPoints: w.globals.selectedDataPoints,
            seriesIndex: i,
            dataPointIndex: j,
            w: w
          }]);
        }
      }
    }, {
      key: "rotateAroundCenter",
      value: function rotateAroundCenter(el) {
        var coord = {};
        if (el && typeof el.getBBox === 'function') {
          coord = el.getBBox();
        }
        var x = coord.x + coord.width / 2;
        var y = coord.y + coord.height / 2;
        return {
          x: x,
          y: y
        };
      }
    }, {
      key: "getTextRects",
      value: function getTextRects(text, fontSize, fontFamily, transform) {
        var useBBox = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : true;
        var w = this.w;
        var virtualText = this.drawText({
          x: -200,
          y: -200,
          text: text,
          textAnchor: 'start',
          fontSize: fontSize,
          fontFamily: fontFamily,
          foreColor: '#fff',
          opacity: 0
        });
        if (transform) {
          virtualText.attr('transform', transform);
        }
        w.globals.dom.Paper.add(virtualText);
        var rect = virtualText.bbox();
        if (!useBBox) {
          rect = virtualText.node.getBoundingClientRect();
        }
        virtualText.remove();
        return {
          width: rect.width,
          height: rect.height
        };
      }

      /**
       * append ... to long text
       * http://stackoverflow.com/questions/9241315/trimming-text-to-a-given-pixel-width-in-svg
       * @memberof Graphics
       **/
    }, {
      key: "placeTextWithEllipsis",
      value: function placeTextWithEllipsis(textObj, textString, width) {
        if (typeof textObj.getComputedTextLength !== 'function') return;
        textObj.textContent = textString;
        if (textString.length > 0) {
          // ellipsis is needed
          if (textObj.getComputedTextLength() >= width / 1.1) {
            for (var x = textString.length - 3; x > 0; x -= 3) {
              if (textObj.getSubStringLength(0, x) <= width / 1.1) {
                textObj.textContent = textString.substring(0, x) + '...';
                return;
              }
            }
            textObj.textContent = '.'; // can't place at all
          }
        }
      }
    }], [{
      key: "setAttrs",
      value: function setAttrs(el, attrs) {
        for (var key in attrs) {
          if (attrs.hasOwnProperty(key)) {
            el.setAttribute(key, attrs[key]);
          }
        }
      }
    }]);
    return Graphics;
  }();

  /*
   ** Util functions which are dependent on ApexCharts instance
   */
  var CoreUtils = /*#__PURE__*/function () {
    function CoreUtils(ctx) {
      _classCallCheck(this, CoreUtils);
      this.ctx = ctx;
      this.w = ctx.w;
    }
    _createClass(CoreUtils, [{
      key: "getStackedSeriesTotals",
      value:
      /**
       * @memberof CoreUtils
       * returns the sum of all individual values in a multiple stacked series
       * Eg. w.globals.series = [[32,33,43,12], [2,3,5,1]]
       *  @return [34,36,48,13]
       **/
      function getStackedSeriesTotals() {
        var excludedSeriesIndices = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
        var w = this.w;
        var total = [];
        if (w.globals.series.length === 0) return total;
        for (var i = 0; i < w.globals.series[w.globals.maxValsInArrayIndex].length; i++) {
          var t = 0;
          for (var j = 0; j < w.globals.series.length; j++) {
            if (typeof w.globals.series[j][i] !== 'undefined' && excludedSeriesIndices.indexOf(j) === -1) {
              t += w.globals.series[j][i];
            }
          }
          total.push(t);
        }
        return total;
      }

      // get total of the all values inside all series
    }, {
      key: "getSeriesTotalByIndex",
      value: function getSeriesTotalByIndex() {
        var index = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
        if (index === null) {
          // non-plot chart types - pie / donut / circle
          return this.w.config.series.reduce(function (acc, cur) {
            return acc + cur;
          }, 0);
        } else {
          // axis charts - supporting multiple series
          return this.w.globals.series[index].reduce(function (acc, cur) {
            return acc + cur;
          }, 0);
        }
      }

      /**
       * @memberof CoreUtils
       * returns the sum of values in a multiple stacked grouped charts
       * Eg. w.globals.series = [[32,33,43,12], [2,3,5,1], [43, 23, 34, 22]]
       * series 1 and 2 are in a group, while series 3 is in another group
       *  @return [[34, 36, 48, 12], [43, 23, 34, 22]]
       **/
    }, {
      key: "getStackedSeriesTotalsByGroups",
      value: function getStackedSeriesTotalsByGroups() {
        var _this = this;
        var w = this.w;
        var total = [];
        w.globals.seriesGroups.forEach(function (sg) {
          var includedIndexes = [];
          w.config.series.forEach(function (s, si) {
            if (sg.indexOf(w.globals.seriesNames[si]) > -1) {
              includedIndexes.push(si);
            }
          });
          var excludedIndices = w.globals.series.map(function (_, fi) {
            return includedIndexes.indexOf(fi) === -1 ? fi : -1;
          }).filter(function (f) {
            return f !== -1;
          });
          total.push(_this.getStackedSeriesTotals(excludedIndices));
        });
        return total;
      }
    }, {
      key: "setSeriesYAxisMappings",
      value: function setSeriesYAxisMappings() {
        var gl = this.w.globals;
        var cnf = this.w.config;

        // The old config method to map multiple series to a y axis is to
        // include one yaxis config per series but set each yaxis seriesName to the
        // same series name. This relies on indexing equivalence to map series to
        // an axis: series[n] => yaxis[n]. This needs to be retained for compatibility.
        // But we introduce an alternative that explicitly configures yaxis elements
        // with the series that will be referenced to them (seriesName: []). This
        // only requires including the yaxis elements that will be seen on the chart.
        // Old way:
        // ya: s
        // 0: 0
        // 1: 1
        // 2: 1
        // 3: 1
        // 4: 1
        // Axes 0..4 are all scaled and all will be rendered unless the axes are
        // show: false. If the chart is stacked, it's assumed that series 1..4 are
        // the contributing series. This is not particularly intuitive.
        // New way:
        // ya: s
        // 0: [0]
        // 1: [1,2,3,4]
        // If the chart is stacked, it can be assumed that any axis with multiple
        // series is stacked.
        //
        // If this is an old chart and we are being backward compatible, it will be
        // expected that each series is associated with it's corresponding yaxis
        // through their indices, one-to-one.
        // If yaxis.seriesName matches series.name, we have indices yi and si.
        // A name match where yi != si is interpretted as yaxis[yi] and yaxis[si]
        // will both be scaled to fit the combined series[si] and series[yi].
        // Consider series named: S0,S1,S2 and yaxes A0,A1,A2.
        //
        // Example 1: A0 and A1 scaled the same.
        // A0.seriesName: S0
        // A1.seriesName: S0
        // A2.seriesName: S2
        // Then A1 <-> A0
        //
        // Example 2: A0, A1 and A2 all scaled the same.
        // A0.seriesName: S2
        // A1.seriesName: S0
        // A2.seriesName: S1
        // A0 <-> A2, A1 <-> A0, A2 <-> A1 --->>> A0 <-> A1 <-> A2

        var axisSeriesMap = [];
        var seriesYAxisReverseMap = [];
        var unassignedSeriesIndices = [];
        var seriesNameArrayStyle = gl.series.length > cnf.yaxis.length || cnf.yaxis.some(function (a) {
          return Array.isArray(a.seriesName);
        });
        cnf.series.forEach(function (s, i) {
          unassignedSeriesIndices.push(i);
          seriesYAxisReverseMap.push(null);
        });
        cnf.yaxis.forEach(function (yaxe, yi) {
          axisSeriesMap[yi] = [];
        });
        var unassignedYAxisIndices = [];

        // here, we loop through the yaxis array and find the item which has "seriesName" property
        cnf.yaxis.forEach(function (yaxe, yi) {
          var assigned = false;
          // Allow seriesName to be either a string (for backward compatibility),
          // in which case, handle multiple yaxes referencing the same series.
          // or an array of strings so that a yaxis can reference multiple series.
          // Feature request #4237
          if (yaxe.seriesName) {
            var seriesNames = [];
            if (Array.isArray(yaxe.seriesName)) {
              seriesNames = yaxe.seriesName;
            } else {
              seriesNames.push(yaxe.seriesName);
            }
            seriesNames.forEach(function (name) {
              cnf.series.forEach(function (s, si) {
                if (s.name === name) {
                  var remove = si;
                  if (yi === si || seriesNameArrayStyle) {
                    // New style, don't allow series to be double referenced
                    if (!seriesNameArrayStyle || unassignedSeriesIndices.indexOf(si) > -1) {
                      axisSeriesMap[yi].push([yi, si]);
                    } else {
                      console.warn("Series '" + s.name + "' referenced more than once in what looks like the new style." + ' That is, when using either seriesName: [],' + ' or when there are more series than yaxes.');
                    }
                  } else {
                    // The series index refers to the target yaxis and the current
                    // yaxis index refers to the actual referenced series.
                    axisSeriesMap[si].push([si, yi]);
                    remove = yi;
                  }
                  assigned = true;
                  remove = unassignedSeriesIndices.indexOf(remove);
                  if (remove !== -1) {
                    unassignedSeriesIndices.splice(remove, 1);
                  }
                }
              });
            });
          }
          if (!assigned) {
            unassignedYAxisIndices.push(yi);
          }
        });
        axisSeriesMap = axisSeriesMap.map(function (yaxe, yi) {
          var ra = [];
          yaxe.forEach(function (sa) {
            seriesYAxisReverseMap[sa[1]] = sa[0];
            ra.push(sa[1]);
          });
          return ra;
        });

        // All series referenced directly by yaxes have been assigned to those axes.
        // Any series so far unassigned will be assigned to any yaxes that have yet
        // to reference series directly, one-for-one in order of appearance, with
        // all left-over series assigned to either the last unassigned yaxis, or the
        // last yaxis if all have assigned series. This captures the
        // default single and multiaxis config options which simply includes zero,
        // one or as many yaxes as there are series but do not reference them by name.
        var lastUnassignedYAxis = cnf.yaxis.length - 1;
        for (var i = 0; i < unassignedYAxisIndices.length; i++) {
          lastUnassignedYAxis = unassignedYAxisIndices[i];
          axisSeriesMap[lastUnassignedYAxis] = [];
          if (unassignedSeriesIndices) {
            var si = unassignedSeriesIndices[0];
            unassignedSeriesIndices.shift();
            axisSeriesMap[lastUnassignedYAxis].push(si);
            seriesYAxisReverseMap[si] = lastUnassignedYAxis;
          } else {
            break;
          }
        }
        unassignedSeriesIndices.forEach(function (i) {
          axisSeriesMap[lastUnassignedYAxis].push(i);
          seriesYAxisReverseMap[i] = lastUnassignedYAxis;
        });

        // For the old-style seriesName-as-string-only, leave the zero-length yaxis
        // array elements in for compatibility so that series.length == yaxes.length
        // for multi axis charts.
        gl.seriesYAxisMap = axisSeriesMap.map(function (x) {
          return x;
        });
        gl.seriesYAxisReverseMap = seriesYAxisReverseMap.map(function (x) {
          return x;
        });
        // Set default series group names
        gl.seriesYAxisMap.forEach(function (axisSeries, ai) {
          axisSeries.forEach(function (si) {
            // series may be bare until loaded in realtime
            if (cnf.series[si] && cnf.series[si].group === undefined) {
              if (cnf.series[si].__apexParsed) {
                // For parsed series, use sequential counter to avoid duplicates
                cnf.series[si].group = 'apexcharts-axis-'.concat(si.toString());
              } else {
                // For non-parsed series,
                // A series with no group defined will be named after the axis that
                // referenced it and thus form a group automatically.
                cnf.series[si].group = 'apexcharts-axis-'.concat(ai.toString());
              }
            }
          });
        });
      }
    }, {
      key: "isSeriesNull",
      value: function isSeriesNull() {
        var index = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
        var r = [];
        if (index === null) {
          // non-plot chart types - pie / donut / circle
          r = this.w.config.series.filter(function (d) {
            return d !== null;
          });
        } else {
          // axis charts - supporting multiple series
          r = this.w.config.series[index].data.filter(function (d) {
            return d !== null;
          });
        }
        return r.length === 0;
      }
    }, {
      key: "seriesHaveSameValues",
      value: function seriesHaveSameValues(index) {
        return this.w.globals.series[index].every(function (val, i, arr) {
          return val === arr[0];
        });
      }
    }, {
      key: "getCategoryLabels",
      value: function getCategoryLabels(labels) {
        var w = this.w;
        var catLabels = labels.slice();
        if (w.config.xaxis.convertedCatToNumeric) {
          catLabels = labels.map(function (i, li) {
            return w.config.xaxis.labels.formatter(i - w.globals.minX + 1);
          });
        }
        return catLabels;
      }
      // maxValsInArrayIndex is the index of series[] which has the largest number of items
    }, {
      key: "getLargestSeries",
      value: function getLargestSeries() {
        var w = this.w;
        w.globals.maxValsInArrayIndex = w.globals.series.map(function (a) {
          return a.length;
        }).indexOf(Math.max.apply(Math, w.globals.series.map(function (a) {
          return a.length;
        })));
      }
    }, {
      key: "getLargestMarkerSize",
      value: function getLargestMarkerSize() {
        var w = this.w;
        var size = 0;
        w.globals.markers.size.forEach(function (m) {
          size = Math.max(size, m);
        });
        if (w.config.markers.discrete && w.config.markers.discrete.length) {
          w.config.markers.discrete.forEach(function (m) {
            size = Math.max(size, m.size);
          });
        }
        if (size > 0) {
          if (w.config.markers.hover.size > 0) {
            size = w.config.markers.hover.size;
          } else {
            size += w.config.markers.hover.sizeOffset;
          }
        }
        w.globals.markers.largestSize = size;
        return size;
      }

      /**
       * @memberof Core
       * returns the sum of all values in a series
       * Eg. w.globals.series = [[32,33,43,12], [2,3,5,1]]
       *  @return [120, 11]
       **/
    }, {
      key: "getSeriesTotals",
      value: function getSeriesTotals() {
        var w = this.w;
        w.globals.seriesTotals = w.globals.series.map(function (ser, index) {
          var total = 0;
          if (Array.isArray(ser)) {
            for (var j = 0; j < ser.length; j++) {
              total += ser[j];
            }
          } else {
            // for pie/donuts/gauges
            total += ser;
          }
          return total;
        });
      }
    }, {
      key: "getSeriesTotalsXRange",
      value: function getSeriesTotalsXRange(minX, maxX) {
        var w = this.w;
        var seriesTotalsXRange = w.globals.series.map(function (ser, index) {
          var total = 0;
          for (var j = 0; j < ser.length; j++) {
            if (w.globals.seriesX[index][j] > minX && w.globals.seriesX[index][j] < maxX) {
              total += ser[j];
            }
          }
          return total;
        });
        return seriesTotalsXRange;
      }

      /**
       * @memberof CoreUtils
       * returns the percentage value of all individual values which can be used in a 100% stacked series
       * Eg. w.globals.series = [[32, 33, 43, 12], [2, 3, 5, 1]]
       *  @return [[94.11, 91.66, 89.58, 92.30], [5.88, 8.33, 10.41, 7.7]]
       **/
    }, {
      key: "getPercentSeries",
      value: function getPercentSeries() {
        var w = this.w;
        w.globals.seriesPercent = w.globals.series.map(function (ser, index) {
          var seriesPercent = [];
          if (Array.isArray(ser)) {
            for (var j = 0; j < ser.length; j++) {
              var total = w.globals.stackedSeriesTotals[j];
              var percent = 0;
              if (total) {
                percent = 100 * ser[j] / total;
              }
              seriesPercent.push(percent);
            }
          } else {
            var _total = w.globals.seriesTotals.reduce(function (acc, val) {
              return acc + val;
            }, 0);
            var _percent = 100 * ser / _total;
            seriesPercent.push(_percent);
          }
          return seriesPercent;
        });
      }
    }, {
      key: "getCalculatedRatios",
      value: function getCalculatedRatios() {
        var _this2 = this;
        var w = this.w;
        var gl = w.globals;
        var yRatio = [];
        var invertedYRatio = 0;
        var xRatio = 0;
        var invertedXRatio = 0;
        var zRatio = 0;
        var baseLineY = [];
        var baseLineInvertedY = 0.1;
        var baseLineX = 0;
        gl.yRange = [];
        if (gl.isMultipleYAxis) {
          for (var i = 0; i < gl.minYArr.length; i++) {
            gl.yRange.push(Math.abs(gl.minYArr[i] - gl.maxYArr[i]));
            baseLineY.push(0);
          }
        } else {
          gl.yRange.push(Math.abs(gl.minY - gl.maxY));
        }
        gl.xRange = Math.abs(gl.maxX - gl.minX);
        gl.zRange = Math.abs(gl.maxZ - gl.minZ);

        // multiple y axis
        for (var _i = 0; _i < gl.yRange.length; _i++) {
          yRatio.push(gl.yRange[_i] / gl.gridHeight);
        }
        xRatio = gl.xRange / gl.gridWidth;
        invertedYRatio = gl.yRange / gl.gridWidth;
        invertedXRatio = gl.xRange / gl.gridHeight;
        zRatio = gl.zRange / gl.gridHeight * 16;
        if (!zRatio) {
          zRatio = 1;
        }
        if (gl.minY !== Number.MIN_VALUE && Math.abs(gl.minY) !== 0) {
          // Negative numbers present in series
          gl.hasNegs = true;
        }

        // Check we have a map as series may still to be added/updated.
        if (w.globals.seriesYAxisReverseMap.length > 0) {
          var scaleBaseLineYScale = function scaleBaseLineYScale(y, i) {
            var yAxis = w.config.yaxis[w.globals.seriesYAxisReverseMap[i]];
            var sign = y < 0 ? -1 : 1;
            y = Math.abs(y);
            if (yAxis.logarithmic) {
              y = _this2.getBaseLog(yAxis.logBase, y);
            }
            return -sign * y / yRatio[i];
          };
          if (gl.isMultipleYAxis) {
            baseLineY = [];
            // baseline variables is the 0 of the yaxis which will be needed when there are negatives
            for (var _i2 = 0; _i2 < yRatio.length; _i2++) {
              baseLineY.push(scaleBaseLineYScale(gl.minYArr[_i2], _i2));
            }
          } else {
            baseLineY = [];
            baseLineY.push(scaleBaseLineYScale(gl.minY, 0));
            if (gl.minY !== Number.MIN_VALUE && Math.abs(gl.minY) !== 0) {
              baseLineInvertedY = -gl.minY / invertedYRatio; // this is for bar chart
              baseLineX = gl.minX / xRatio;
            }
          }
        } else {
          baseLineY = [];
          baseLineY.push(0);
          baseLineInvertedY = 0;
          baseLineX = 0;
        }
        return {
          yRatio: yRatio,
          invertedYRatio: invertedYRatio,
          zRatio: zRatio,
          xRatio: xRatio,
          invertedXRatio: invertedXRatio,
          baseLineInvertedY: baseLineInvertedY,
          baseLineY: baseLineY,
          baseLineX: baseLineX
        };
      }
    }, {
      key: "getLogSeries",
      value: function getLogSeries(series) {
        var _this3 = this;
        var w = this.w;
        w.globals.seriesLog = series.map(function (s, i) {
          var yAxisIndex = w.globals.seriesYAxisReverseMap[i];
          if (w.config.yaxis[yAxisIndex] && w.config.yaxis[yAxisIndex].logarithmic) {
            return s.map(function (d) {
              if (d === null) return null;
              return _this3.getLogVal(w.config.yaxis[yAxisIndex].logBase, d, i);
            });
          } else {
            return s;
          }
        });
        return w.globals.invalidLogScale ? series : w.globals.seriesLog;
      }
    }, {
      key: "getLogValAtSeriesIndex",
      value: function getLogValAtSeriesIndex(val, seriesIndex) {
        if (val === null) return null;
        var w = this.w;
        var yAxisIndex = w.globals.seriesYAxisReverseMap[seriesIndex];
        if (w.config.yaxis[yAxisIndex] && w.config.yaxis[yAxisIndex].logarithmic) {
          return this.getLogVal(w.config.yaxis[yAxisIndex].logBase, val, seriesIndex);
        }
        return val;
      }
    }, {
      key: "getBaseLog",
      value: function getBaseLog(base, value) {
        return Math.log(value) / Math.log(base);
      }
    }, {
      key: "getLogVal",
      value: function getLogVal(b, d, seriesIndex) {
        if (d <= 0) {
          return 0; // Should be Number.NEGATIVE_INFINITY
        }
        var w = this.w;
        var min_log_val = w.globals.minYArr[seriesIndex] === 0 ? -1 // make sure we dont calculate log of 0
        : this.getBaseLog(b, w.globals.minYArr[seriesIndex]);
        var max_log_val = w.globals.maxYArr[seriesIndex] === 0 ? 0 // make sure we dont calculate log of 0
        : this.getBaseLog(b, w.globals.maxYArr[seriesIndex]);
        var number_of_height_levels = max_log_val - min_log_val;
        if (d < 1) return d / number_of_height_levels;
        var log_height_value = this.getBaseLog(b, d) - min_log_val;
        return log_height_value / number_of_height_levels;
      }
    }, {
      key: "getLogYRatios",
      value: function getLogYRatios(yRatio) {
        var _this4 = this;
        var w = this.w;
        var gl = this.w.globals;
        gl.yLogRatio = yRatio.slice();
        gl.logYRange = gl.yRange.map(function (_, i) {
          var yAxisIndex = w.globals.seriesYAxisReverseMap[i];
          if (w.config.yaxis[yAxisIndex] && _this4.w.config.yaxis[yAxisIndex].logarithmic) {
            var maxY = -Number.MAX_VALUE;
            var minY = Number.MIN_VALUE;
            var range = 1;
            gl.seriesLog.forEach(function (s, si) {
              s.forEach(function (v) {
                if (w.config.yaxis[si] && w.config.yaxis[si].logarithmic) {
                  maxY = Math.max(v, maxY);
                  minY = Math.min(v, minY);
                }
              });
            });
            range = Math.pow(gl.yRange[i], Math.abs(minY - maxY) / gl.yRange[i]);
            gl.yLogRatio[i] = range / gl.gridHeight;
            return range;
          }
        });
        return gl.invalidLogScale ? yRatio.slice() : gl.yLogRatio;
      }

      // Some config objects can be array - and we need to extend them correctly
    }, {
      key: "drawSeriesByGroup",
      value:
      // Series of the same group and type can be stacked together distinct from
      // other series of the same type on the same axis.
      function drawSeriesByGroup(typeSeries, typeGroups, type, chartClass) {
        var w = this.w;
        var graph = [];
        if (typeSeries.series.length > 0) {
          // draw each group separately
          typeGroups.forEach(function (gn) {
            var gs = [];
            var gi = [];
            typeSeries.i.forEach(function (i, ii) {
              if (w.config.series[i].group === gn) {
                gs.push(typeSeries.series[ii]);
                gi.push(i);
              }
            });
            gs.length > 0 && graph.push(chartClass.draw(gs, type, gi));
          });
        }
        return graph;
      }
    }], [{
      key: "checkComboSeries",
      value: function checkComboSeries(series, chartType) {
        var comboCharts = false;
        var comboBarCount = 0;
        var comboCount = 0;
        if (chartType === undefined) {
          chartType = 'line';
        }

        // Check if user specified a type in series that may make us a combo chart.
        // The default type for chart is "line" and the default for series is the
        // chart type, therefore, if the types of all series match the chart type,
        // this should not be considered a combo chart.
        if (series.length && typeof series[0].type !== 'undefined') {
          series.forEach(function (s) {
            if (s.type === 'bar' || s.type === 'column' || s.type === 'candlestick' || s.type === 'boxPlot') {
              comboBarCount++;
            }
            if (typeof s.type !== 'undefined' && s.type !== chartType) {
              comboCount++;
            }
          });
        }
        if (comboCount > 0) {
          comboCharts = true;
        }
        return {
          comboBarCount: comboBarCount,
          comboCharts: comboCharts
        };
      }
    }, {
      key: "extendArrayProps",
      value: function extendArrayProps(configInstance, options, w) {
        var _options, _options2;
        if ((_options = options) !== null && _options !== void 0 && _options.yaxis) {
          options = configInstance.extendYAxis(options, w);
        }
        if ((_options2 = options) !== null && _options2 !== void 0 && _options2.annotations) {
          var _options3, _options3$annotations, _options4, _options4$annotations;
          if (options.annotations.yaxis) {
            options = configInstance.extendYAxisAnnotations(options);
          }
          if ((_options3 = options) !== null && _options3 !== void 0 && (_options3$annotations = _options3.annotations) !== null && _options3$annotations !== void 0 && _options3$annotations.xaxis) {
            options = configInstance.extendXAxisAnnotations(options);
          }
          if ((_options4 = options) !== null && _options4 !== void 0 && (_options4$annotations = _options4.annotations) !== null && _options4$annotations !== void 0 && _options4$annotations.points) {
            options = configInstance.extendPointAnnotations(options);
          }
        }
        return options;
      }
    }]);
    return CoreUtils;
  }();

  var Helpers$4 = /*#__PURE__*/function () {
    function Helpers(annoCtx) {
      _classCallCheck(this, Helpers);
      this.w = annoCtx.w;
      this.annoCtx = annoCtx;
    }
    _createClass(Helpers, [{
      key: "setOrientations",
      value: function setOrientations(anno) {
        var annoIndex = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
        var w = this.w;
        if (anno.label.orientation === 'vertical') {
          var i = annoIndex !== null ? annoIndex : 0;
          var xAnno = w.globals.dom.baseEl.querySelector(".apexcharts-xaxis-annotations .apexcharts-xaxis-annotation-label[rel='".concat(i, "']"));
          if (xAnno !== null) {
            var xAnnoCoord = xAnno.getBoundingClientRect();
            xAnno.setAttribute('x', parseFloat(xAnno.getAttribute('x')) - xAnnoCoord.height + 4);
            var yOffset = anno.label.position === 'top' ? xAnnoCoord.width : -xAnnoCoord.width;
            xAnno.setAttribute('y', parseFloat(xAnno.getAttribute('y')) + yOffset);
            var _this$annoCtx$graphic = this.annoCtx.graphics.rotateAroundCenter(xAnno),
              x = _this$annoCtx$graphic.x,
              y = _this$annoCtx$graphic.y;
            xAnno.setAttribute('transform', "rotate(-90 ".concat(x, " ").concat(y, ")"));
          }
        }
      }
    }, {
      key: "addBackgroundToAnno",
      value: function addBackgroundToAnno(annoEl, anno) {
        var w = this.w;
        if (!annoEl || !anno.label.text || !String(anno.label.text).trim()) {
          return null;
        }
        var elGridRect = w.globals.dom.baseEl.querySelector('.apexcharts-grid').getBoundingClientRect();
        var coords = annoEl.getBoundingClientRect();
        var _anno$label$style$pad = anno.label.style.padding,
          pleft = _anno$label$style$pad.left,
          pright = _anno$label$style$pad.right,
          ptop = _anno$label$style$pad.top,
          pbottom = _anno$label$style$pad.bottom;
        if (anno.label.orientation === 'vertical') {
          var _ref = [pleft, pright, ptop, pbottom];
          ptop = _ref[0];
          pbottom = _ref[1];
          pleft = _ref[2];
          pright = _ref[3];
        }
        var x1 = coords.left - elGridRect.left - pleft;
        var y1 = coords.top - elGridRect.top - ptop;
        var elRect = this.annoCtx.graphics.drawRect(x1 - w.globals.barPadForNumericAxis, y1, coords.width + pleft + pright, coords.height + ptop + pbottom, anno.label.borderRadius, anno.label.style.background, 1, anno.label.borderWidth, anno.label.borderColor, 0);
        if (anno.id) {
          elRect.node.classList.add(anno.id);
        }
        return elRect;
      }
    }, {
      key: "annotationsBackground",
      value: function annotationsBackground() {
        var _this = this;
        var w = this.w;
        var add = function add(anno, i, type) {
          var annoLabel = w.globals.dom.baseEl.querySelector(".apexcharts-".concat(type, "-annotations .apexcharts-").concat(type, "-annotation-label[rel='").concat(i, "']"));
          if (annoLabel) {
            var parent = annoLabel.parentNode;
            var elRect = _this.addBackgroundToAnno(annoLabel, anno);
            if (elRect) {
              parent.insertBefore(elRect.node, annoLabel);
              if (anno.label.mouseEnter) {
                elRect.node.addEventListener('mouseenter', anno.label.mouseEnter.bind(_this, anno));
              }
              if (anno.label.mouseLeave) {
                elRect.node.addEventListener('mouseleave', anno.label.mouseLeave.bind(_this, anno));
              }
              if (anno.label.click) {
                elRect.node.addEventListener('click', anno.label.click.bind(_this, anno));
              }
            }
          }
        };
        w.config.annotations.xaxis.forEach(function (anno, i) {
          return add(anno, i, 'xaxis');
        });
        w.config.annotations.yaxis.forEach(function (anno, i) {
          return add(anno, i, 'yaxis');
        });
        w.config.annotations.points.forEach(function (anno, i) {
          return add(anno, i, 'point');
        });
      }
    }, {
      key: "getY1Y2",
      value: function getY1Y2(type, anno) {
        var w = this.w;
        var y = type === 'y1' ? anno.y : anno.y2;
        var yP;
        var clipped = false;
        if (this.annoCtx.invertAxis) {
          var labels = w.config.xaxis.convertedCatToNumeric ? w.globals.categoryLabels : w.globals.labels;
          var catIndex = labels.indexOf(y);
          var xLabel = w.globals.dom.baseEl.querySelector(".apexcharts-yaxis-texts-g text:nth-child(".concat(catIndex + 1, ")"));
          yP = xLabel ? parseFloat(xLabel.getAttribute('y')) : (w.globals.gridHeight / labels.length - 1) * (catIndex + 1) - w.globals.barHeight;
          if (anno.seriesIndex !== undefined && w.globals.barHeight) {
            yP -= w.globals.barHeight / 2 * (w.globals.series.length - 1) - w.globals.barHeight * anno.seriesIndex;
          }
        } else {
          var _w$config$yaxis$anno$;
          var seriesIndex = w.globals.seriesYAxisMap[anno.yAxisIndex][0];
          var yPos = w.config.yaxis[anno.yAxisIndex].logarithmic ? new CoreUtils(this.annoCtx.ctx).getLogVal(w.config.yaxis[anno.yAxisIndex].logBase, y, seriesIndex) / w.globals.yLogRatio[seriesIndex] : (y - w.globals.minYArr[seriesIndex]) / (w.globals.yRange[seriesIndex] / w.globals.gridHeight);
          yP = w.globals.gridHeight - Math.min(Math.max(yPos, 0), w.globals.gridHeight);
          clipped = yPos > w.globals.gridHeight || yPos < 0;
          if (anno.marker && (anno.y === undefined || anno.y === null)) {
            yP = 0;
          }
          if ((_w$config$yaxis$anno$ = w.config.yaxis[anno.yAxisIndex]) !== null && _w$config$yaxis$anno$ !== void 0 && _w$config$yaxis$anno$.reversed) {
            yP = yPos;
          }
        }
        if (typeof y === 'string' && y.includes('px')) {
          yP = parseFloat(y);
        }
        return {
          yP: yP,
          clipped: clipped
        };
      }
    }, {
      key: "getX1X2",
      value: function getX1X2(type, anno) {
        var w = this.w;
        var x = type === 'x1' ? anno.x : anno.x2;
        var min = this.annoCtx.invertAxis ? w.globals.minY : w.globals.minX;
        var max = this.annoCtx.invertAxis ? w.globals.maxY : w.globals.maxX;
        var range = this.annoCtx.invertAxis ? w.globals.yRange[0] : w.globals.xRange;
        var clipped = false;
        var xP = this.annoCtx.inversedReversedAxis ? (max - x) / (range / w.globals.gridWidth) : (x - min) / (range / w.globals.gridWidth);
        if ((w.config.xaxis.type === 'category' || w.config.xaxis.convertedCatToNumeric) && !this.annoCtx.invertAxis && !w.globals.dataFormatXNumeric) {
          if (!w.config.chart.sparkline.enabled) {
            xP = this.getStringX(x);
          }
        }
        if (typeof x === 'string' && x.includes('px')) {
          xP = parseFloat(x);
        }
        if ((x === undefined || x === null) && anno.marker) {
          xP = w.globals.gridWidth;
        }
        if (anno.seriesIndex !== undefined && w.globals.barWidth && !this.annoCtx.invertAxis) {
          xP -= w.globals.barWidth / 2 * (w.globals.series.length - 1) - w.globals.barWidth * anno.seriesIndex;
        }
        if (typeof xP !== 'number') {
          xP = 0;
          clipped = true;
        }
        if (parseFloat(xP.toFixed(10)) > parseFloat(w.globals.gridWidth.toFixed(10))) {
          xP = w.globals.gridWidth;
          clipped = true;
        } else if (xP < 0) {
          xP = 0;
          clipped = true;
        }
        return {
          x: xP,
          clipped: clipped
        };
      }
    }, {
      key: "getStringX",
      value: function getStringX(x) {
        var w = this.w;
        var rX = x;
        if (w.config.xaxis.convertedCatToNumeric && w.globals.categoryLabels.length) {
          x = w.globals.categoryLabels.indexOf(x) + 1;
        }
        var catIndex = w.globals.labels.map(function (item) {
          return Array.isArray(item) ? item.join(' ') : item;
        }).indexOf(x);
        var xLabel = w.globals.dom.baseEl.querySelector(".apexcharts-xaxis-texts-g text:nth-child(".concat(catIndex + 1, ")"));
        if (xLabel) {
          rX = parseFloat(xLabel.getAttribute('x'));
        }
        return rX;
      }
    }]);
    return Helpers;
  }();

  var XAnnotations = /*#__PURE__*/function () {
    function XAnnotations(annoCtx) {
      _classCallCheck(this, XAnnotations);
      this.w = annoCtx.w;
      this.annoCtx = annoCtx;
      this.invertAxis = this.annoCtx.invertAxis;
      this.helpers = new Helpers$4(this.annoCtx);
    }
    _createClass(XAnnotations, [{
      key: "addXaxisAnnotation",
      value: function addXaxisAnnotation(anno, parent, index) {
        var w = this.w;
        var result = this.helpers.getX1X2('x1', anno);
        var x1 = result.x;
        var clipX1 = result.clipped;
        var clipX2 = true;
        var x2;
        var text = anno.label.text;
        var strokeDashArray = anno.strokeDashArray;
        if (!Utils$1.isNumber(x1)) return;
        if (anno.x2 === null || typeof anno.x2 === 'undefined') {
          if (!clipX1) {
            var line = this.annoCtx.graphics.drawLine(x1 + anno.offsetX,
            // x1
            0 + anno.offsetY,
            // y1
            x1 + anno.offsetX,
            // x2
            w.globals.gridHeight + anno.offsetY,
            // y2
            anno.borderColor,
            // lineColor
            strokeDashArray,
            //dashArray
            anno.borderWidth);
            parent.appendChild(line.node);
            if (anno.id) {
              line.node.classList.add(anno.id);
            }
          }
        } else {
          var _result = this.helpers.getX1X2('x2', anno);
          x2 = _result.x;
          clipX2 = _result.clipped;
          if (x2 < x1) {
            var temp = x1;
            x1 = x2;
            x2 = temp;
          }
          var rect = this.annoCtx.graphics.drawRect(x1 + anno.offsetX,
          // x1
          0 + anno.offsetY,
          // y1
          x2 - x1,
          // x2
          w.globals.gridHeight + anno.offsetY,
          // y2
          0,
          // radius
          anno.fillColor,
          // color
          anno.opacity,
          // opacity,
          1,
          // strokeWidth
          anno.borderColor,
          // strokeColor
          strokeDashArray // stokeDashArray
          );
          rect.node.classList.add('apexcharts-annotation-rect');
          rect.attr('clip-path', "url(#gridRectMask".concat(w.globals.cuid, ")"));
          parent.appendChild(rect.node);
          if (anno.id) {
            rect.node.classList.add(anno.id);
          }
        }
        if (!(clipX1 && clipX2)) {
          var textRects = this.annoCtx.graphics.getTextRects(text, parseFloat(anno.label.style.fontSize));
          var textY = anno.label.position === 'top' ? 4 : anno.label.position === 'center' ? w.globals.gridHeight / 2 + (anno.label.orientation === 'vertical' ? textRects.width / 2 : 0) : w.globals.gridHeight;
          var elText = this.annoCtx.graphics.drawText({
            x: x1 + anno.label.offsetX,
            y: textY + anno.label.offsetY - (anno.label.orientation === 'vertical' ? anno.label.position === 'top' ? textRects.width / 2 - 12 : -textRects.width / 2 : 0),
            text: text,
            textAnchor: anno.label.textAnchor,
            fontSize: anno.label.style.fontSize,
            fontFamily: anno.label.style.fontFamily,
            fontWeight: anno.label.style.fontWeight,
            foreColor: anno.label.style.color,
            cssClass: "apexcharts-xaxis-annotation-label ".concat(anno.label.style.cssClass, " ").concat(anno.id ? anno.id : '')
          });
          elText.attr({
            rel: index
          });
          parent.appendChild(elText.node);

          // after placing the annotations on svg, set any vertically placed annotations
          this.annoCtx.helpers.setOrientations(anno, index);
        }
      }
    }, {
      key: "drawXAxisAnnotations",
      value: function drawXAxisAnnotations() {
        var _this = this;
        var w = this.w;
        var elg = this.annoCtx.graphics.group({
          class: 'apexcharts-xaxis-annotations'
        });
        w.config.annotations.xaxis.map(function (anno, index) {
          _this.addXaxisAnnotation(anno, elg.node, index);
        });
        return elg;
      }
    }]);
    return XAnnotations;
  }();

  /**
   * DateTime Class to manipulate datetime values.
   *
   * @module DateTime
   **/
  var DateTime = /*#__PURE__*/function () {
    function DateTime(ctx) {
      _classCallCheck(this, DateTime);
      this.ctx = ctx;
      this.w = ctx.w;
      this.months31 = [1, 3, 5, 7, 8, 10, 12];
      this.months30 = [2, 4, 6, 9, 11];
      this.daysCntOfYear = [0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334];
    }
    _createClass(DateTime, [{
      key: "isValidDate",
      value: function isValidDate(date) {
        if (typeof date === 'number') {
          return false; // don't test for timestamps
        }
        return !isNaN(this.parseDate(date));
      }
    }, {
      key: "getTimeStamp",
      value: function getTimeStamp(dateStr) {
        if (!Date.parse(dateStr)) {
          return dateStr;
        }
        var utc = this.w.config.xaxis.labels.datetimeUTC;
        return !utc ? new Date(dateStr).getTime() : new Date(new Date(dateStr).toISOString().substr(0, 25)).getTime();
      }
    }, {
      key: "getDate",
      value: function getDate(timestamp) {
        var utc = this.w.config.xaxis.labels.datetimeUTC;
        return utc ? new Date(new Date(timestamp).toUTCString()) : new Date(timestamp);
      }
    }, {
      key: "parseDate",
      value: function parseDate(dateStr) {
        var parsed = Date.parse(dateStr);
        if (!isNaN(parsed)) {
          return this.getTimeStamp(dateStr);
        }
        var output = Date.parse(dateStr.replace(/-/g, '/').replace(/[a-z]+/gi, ' '));
        output = this.getTimeStamp(output);
        return output;
      }

      // This fixes the difference of x-axis labels between chrome/safari
      // Fixes #1726, #1544, #1485, #1255
    }, {
      key: "parseDateWithTimezone",
      value: function parseDateWithTimezone(dateStr) {
        return Date.parse(dateStr.replace(/-/g, '/').replace(/[a-z]+/gi, ' '));
      }

      // http://stackoverflow.com/questions/14638018/current-time-formatting-with-javascript#answer-14638191
    }, {
      key: "formatDate",
      value: function formatDate(date, format) {
        var locale = this.w.globals.locale;
        var utc = this.w.config.xaxis.labels.datetimeUTC;
        var MMMM = ['\x00'].concat(_toConsumableArray(locale.months));
        var MMM = ['\x01'].concat(_toConsumableArray(locale.shortMonths));
        var dddd = ['\x02'].concat(_toConsumableArray(locale.days));
        var ddd = ['\x03'].concat(_toConsumableArray(locale.shortDays));
        function ii(i, len) {
          var s = i + '';
          len = len || 2;
          while (s.length < len) {
            s = '0' + s;
          }
          return s;
        }
        var y = utc ? date.getUTCFullYear() : date.getFullYear();
        format = format.replace(/(^|[^\\])yyyy+/g, '$1' + y);
        format = format.replace(/(^|[^\\])yy/g, '$1' + y.toString().substr(2, 2));
        format = format.replace(/(^|[^\\])y/g, '$1' + y);
        var M = (utc ? date.getUTCMonth() : date.getMonth()) + 1;
        format = format.replace(/(^|[^\\])MMMM+/g, '$1' + MMMM[0]);
        format = format.replace(/(^|[^\\])MMM/g, '$1' + MMM[0]);
        format = format.replace(/(^|[^\\])MM/g, '$1' + ii(M));
        format = format.replace(/(^|[^\\])M/g, '$1' + M);
        var d = utc ? date.getUTCDate() : date.getDate();
        format = format.replace(/(^|[^\\])dddd+/g, '$1' + dddd[0]);
        format = format.replace(/(^|[^\\])ddd/g, '$1' + ddd[0]);
        format = format.replace(/(^|[^\\])dd/g, '$1' + ii(d));
        format = format.replace(/(^|[^\\])d/g, '$1' + d);
        var H = utc ? date.getUTCHours() : date.getHours();
        format = format.replace(/(^|[^\\])HH+/g, '$1' + ii(H));
        format = format.replace(/(^|[^\\])H/g, '$1' + H);
        var h = H > 12 ? H - 12 : H === 0 ? 12 : H;
        format = format.replace(/(^|[^\\])hh+/g, '$1' + ii(h));
        format = format.replace(/(^|[^\\])h/g, '$1' + h);
        var m = utc ? date.getUTCMinutes() : date.getMinutes();
        format = format.replace(/(^|[^\\])mm+/g, '$1' + ii(m));
        format = format.replace(/(^|[^\\])m/g, '$1' + m);
        var s = utc ? date.getUTCSeconds() : date.getSeconds();
        format = format.replace(/(^|[^\\])ss+/g, '$1' + ii(s));
        format = format.replace(/(^|[^\\])s/g, '$1' + s);
        var f = utc ? date.getUTCMilliseconds() : date.getMilliseconds();
        format = format.replace(/(^|[^\\])fff+/g, '$1' + ii(f, 3));
        f = Math.round(f / 10);
        format = format.replace(/(^|[^\\])ff/g, '$1' + ii(f));
        f = Math.round(f / 10);
        format = format.replace(/(^|[^\\])f/g, '$1' + f);
        var T = H < 12 ? 'AM' : 'PM';
        format = format.replace(/(^|[^\\])TT+/g, '$1' + T);
        format = format.replace(/(^|[^\\])T/g, '$1' + T.charAt(0));
        var t = T.toLowerCase();
        format = format.replace(/(^|[^\\])tt+/g, '$1' + t);
        format = format.replace(/(^|[^\\])t/g, '$1' + t.charAt(0));
        var tz = -date.getTimezoneOffset();
        var K = utc || !tz ? 'Z' : tz > 0 ? '+' : '-';
        if (!utc) {
          tz = Math.abs(tz);
          var tzHrs = Math.floor(tz / 60);
          var tzMin = tz % 60;
          K += ii(tzHrs) + ':' + ii(tzMin);
        }
        format = format.replace(/(^|[^\\])K/g, '$1' + K);
        var day = (utc ? date.getUTCDay() : date.getDay()) + 1;
        format = format.replace(new RegExp(dddd[0], 'g'), dddd[day]);
        format = format.replace(new RegExp(ddd[0], 'g'), ddd[day]);
        format = format.replace(new RegExp(MMMM[0], 'g'), MMMM[M]);
        format = format.replace(new RegExp(MMM[0], 'g'), MMM[M]);
        format = format.replace(/\\(.)/g, '$1');
        return format;
      }
    }, {
      key: "getTimeUnitsfromTimestamp",
      value: function getTimeUnitsfromTimestamp(minX, maxX, utc) {
        var w = this.w;
        if (w.config.xaxis.min !== undefined) {
          minX = w.config.xaxis.min;
        }
        if (w.config.xaxis.max !== undefined) {
          maxX = w.config.xaxis.max;
        }
        var tsMin = this.getDate(minX);
        var tsMax = this.getDate(maxX);
        var minD = this.formatDate(tsMin, 'yyyy MM dd HH mm ss fff').split(' ');
        var maxD = this.formatDate(tsMax, 'yyyy MM dd HH mm ss fff').split(' ');
        return {
          minMillisecond: parseInt(minD[6], 10),
          maxMillisecond: parseInt(maxD[6], 10),
          minSecond: parseInt(minD[5], 10),
          maxSecond: parseInt(maxD[5], 10),
          minMinute: parseInt(minD[4], 10),
          maxMinute: parseInt(maxD[4], 10),
          minHour: parseInt(minD[3], 10),
          maxHour: parseInt(maxD[3], 10),
          minDate: parseInt(minD[2], 10),
          maxDate: parseInt(maxD[2], 10),
          minMonth: parseInt(minD[1], 10) - 1,
          maxMonth: parseInt(maxD[1], 10) - 1,
          minYear: parseInt(minD[0], 10),
          maxYear: parseInt(maxD[0], 10)
        };
      }
    }, {
      key: "isLeapYear",
      value: function isLeapYear(year) {
        return year % 4 === 0 && year % 100 !== 0 || year % 400 === 0;
      }
    }, {
      key: "calculcateLastDaysOfMonth",
      value: function calculcateLastDaysOfMonth(month, year, subtract) {
        var days = this.determineDaysOfMonths(month, year);

        // whatever days we get, subtract the number of days asked
        return days - subtract;
      }
    }, {
      key: "determineDaysOfYear",
      value: function determineDaysOfYear(year) {
        var days = 365;
        if (this.isLeapYear(year)) {
          days = 366;
        }
        return days;
      }
    }, {
      key: "determineRemainingDaysOfYear",
      value: function determineRemainingDaysOfYear(year, month, date) {
        var dayOfYear = this.daysCntOfYear[month] + date;
        if (month > 1 && this.isLeapYear()) dayOfYear++;
        return dayOfYear;
      }
    }, {
      key: "determineDaysOfMonths",
      value: function determineDaysOfMonths(month, year) {
        var days = 30;
        month = Utils$1.monthMod(month);
        switch (true) {
          case this.months30.indexOf(month) > -1:
            if (month === 2) {
              if (this.isLeapYear(year)) {
                days = 29;
              } else {
                days = 28;
              }
            }
            break;
          case this.months31.indexOf(month) > -1:
            days = 31;
            break;
          default:
            days = 31;
            break;
        }
        return days;
      }
    }]);
    return DateTime;
  }();

  /**
   * ApexCharts Formatter Class for setting value formatters for axes as well as tooltips.
   *
   * @module Formatters
   **/
  var Formatters = /*#__PURE__*/function () {
    function Formatters(ctx) {
      _classCallCheck(this, Formatters);
      this.ctx = ctx;
      this.w = ctx.w;
      this.tooltipKeyFormat = 'dd MMM';
    }
    _createClass(Formatters, [{
      key: "xLabelFormat",
      value: function xLabelFormat(fn, val, timestamp, opts) {
        var w = this.w;
        if (w.config.xaxis.type === 'datetime') {
          if (w.config.xaxis.labels.formatter === undefined) {
            // if user has not specified a custom formatter, use the default tooltip.x.format
            if (w.config.tooltip.x.formatter === undefined) {
              var datetimeObj = new DateTime(this.ctx);
              return datetimeObj.formatDate(datetimeObj.getDate(val), w.config.tooltip.x.format);
            }
          }
        }
        return fn(val, timestamp, opts);
      }
    }, {
      key: "defaultGeneralFormatter",
      value: function defaultGeneralFormatter(val) {
        if (Array.isArray(val)) {
          return val.map(function (v) {
            return v;
          });
        } else {
          return val;
        }
      }
    }, {
      key: "defaultYFormatter",
      value: function defaultYFormatter(v, yaxe, i) {
        var w = this.w;
        if (Utils$1.isNumber(v)) {
          if (w.globals.yValueDecimal !== 0) {
            v = v.toFixed(yaxe.decimalsInFloat !== undefined ? yaxe.decimalsInFloat : w.globals.yValueDecimal);
          } else {
            // We have an integer value but the label is not an integer. We can
            // deduce this is due to the number of ticks exceeding the even lower
            // integer range. Add an additional decimal place only in this case.
            var f = v.toFixed(0);
            // Do not change the == to ===
            v = v == f ? f : v.toFixed(1);
          }
        }
        return v;
      }
    }, {
      key: "setLabelFormatters",
      value: function setLabelFormatters() {
        var _this = this;
        var w = this.w;
        w.globals.xaxisTooltipFormatter = function (val) {
          return _this.defaultGeneralFormatter(val);
        };
        w.globals.ttKeyFormatter = function (val) {
          return _this.defaultGeneralFormatter(val);
        };
        w.globals.ttZFormatter = function (val) {
          return val;
        };
        w.globals.legendFormatter = function (val) {
          return _this.defaultGeneralFormatter(val);
        };

        // formatter function will always overwrite format property
        if (w.config.xaxis.labels.formatter !== undefined) {
          w.globals.xLabelFormatter = w.config.xaxis.labels.formatter;
        } else {
          w.globals.xLabelFormatter = function (val) {
            if (Utils$1.isNumber(val)) {
              if (!w.config.xaxis.convertedCatToNumeric && w.config.xaxis.type === 'numeric') {
                if (Utils$1.isNumber(w.config.xaxis.decimalsInFloat)) {
                  return val.toFixed(w.config.xaxis.decimalsInFloat);
                } else {
                  var diff = w.globals.maxX - w.globals.minX;
                  if (diff > 0 && diff < 100) {
                    return val.toFixed(1);
                  }
                  return val.toFixed(0);
                }
              }
              if (w.globals.isBarHorizontal) {
                var range = w.globals.maxY - w.globals.minYArr;
                if (range < 4) {
                  return val.toFixed(1);
                }
              }
              return val.toFixed(0);
            }
            return val;
          };
        }
        if (typeof w.config.tooltip.x.formatter === 'function') {
          w.globals.ttKeyFormatter = w.config.tooltip.x.formatter;
        } else {
          w.globals.ttKeyFormatter = w.globals.xLabelFormatter;
        }
        if (typeof w.config.xaxis.tooltip.formatter === 'function') {
          w.globals.xaxisTooltipFormatter = w.config.xaxis.tooltip.formatter;
        }
        if (Array.isArray(w.config.tooltip.y)) {
          w.globals.ttVal = w.config.tooltip.y;
        } else {
          if (w.config.tooltip.y.formatter !== undefined) {
            w.globals.ttVal = w.config.tooltip.y;
          }
        }
        if (w.config.tooltip.z.formatter !== undefined) {
          w.globals.ttZFormatter = w.config.tooltip.z.formatter;
        }

        // legend formatter - if user wants to append any global values of series to legend text
        if (w.config.legend.formatter !== undefined) {
          w.globals.legendFormatter = w.config.legend.formatter;
        }

        // formatter function will always overwrite format property
        w.config.yaxis.forEach(function (yaxe, i) {
          if (yaxe.labels.formatter !== undefined) {
            w.globals.yLabelFormatters[i] = yaxe.labels.formatter;
          } else {
            w.globals.yLabelFormatters[i] = function (val) {
              if (!w.globals.xyCharts) return val;
              if (Array.isArray(val)) {
                return val.map(function (v) {
                  return _this.defaultYFormatter(v, yaxe, i);
                });
              } else {
                return _this.defaultYFormatter(val, yaxe, i);
              }
            };
          }
        });
        return w.globals;
      }
    }, {
      key: "heatmapLabelFormatters",
      value: function heatmapLabelFormatters() {
        var w = this.w;
        if (w.config.chart.type === 'heatmap') {
          w.globals.yAxisScale[0].result = w.globals.seriesNames.slice();

          //  get the longest string from the labels array and also apply label formatter to it
          var longest = w.globals.seriesNames.reduce(function (a, b) {
            return a.length > b.length ? a : b;
          }, 0);
          w.globals.yAxisScale[0].niceMax = longest;
          w.globals.yAxisScale[0].niceMin = longest;
        }
      }
    }]);
    return Formatters;
  }();

  var AxesUtils = /*#__PURE__*/function () {
    function AxesUtils(ctx) {
      _classCallCheck(this, AxesUtils);
      this.ctx = ctx;
      this.w = ctx.w;
    }

    // Based on the formatter function, get the label text and position
    _createClass(AxesUtils, [{
      key: "getLabel",
      value: function getLabel(labels, timescaleLabels, x, i) {
        var drawnLabels = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : [];
        var fontSize = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : '12px';
        var isLeafGroup = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : true;
        var w = this.w;
        var rawLabel = typeof labels[i] === 'undefined' ? '' : labels[i];
        var label = rawLabel;
        var xlbFormatter = w.globals.xLabelFormatter;
        var customFormatter = w.config.xaxis.labels.formatter;
        var isBold = false;
        var xFormat = new Formatters(this.ctx);
        var timestamp = rawLabel;
        if (isLeafGroup) {
          label = xFormat.xLabelFormat(xlbFormatter, rawLabel, timestamp, {
            i: i,
            dateFormatter: new DateTime(this.ctx).formatDate,
            w: w
          });
          if (customFormatter !== undefined) {
            label = customFormatter(rawLabel, labels[i], {
              i: i,
              dateFormatter: new DateTime(this.ctx).formatDate,
              w: w
            });
          }
        }
        var determineHighestUnit = function determineHighestUnit(unit) {
          var highestUnit = null;
          timescaleLabels.forEach(function (t) {
            if (t.unit === 'month') {
              highestUnit = 'year';
            } else if (t.unit === 'day') {
              highestUnit = 'month';
            } else if (t.unit === 'hour') {
              highestUnit = 'day';
            } else if (t.unit === 'minute') {
              highestUnit = 'hour';
            }
          });
          return highestUnit === unit;
        };
        if (timescaleLabels.length > 0) {
          isBold = determineHighestUnit(timescaleLabels[i].unit);
          x = timescaleLabels[i].position;
          label = timescaleLabels[i].value;
        } else {
          if (w.config.xaxis.type === 'datetime' && customFormatter === undefined) {
            label = '';
          }
        }
        if (typeof label === 'undefined') label = '';
        label = Array.isArray(label) ? label : label.toString();
        var graphics = new Graphics(this.ctx);
        var textRect = {};
        if (w.globals.rotateXLabels && isLeafGroup) {
          textRect = graphics.getTextRects(label, parseInt(fontSize, 10), null, "rotate(".concat(w.config.xaxis.labels.rotate, " 0 0)"), false);
        } else {
          textRect = graphics.getTextRects(label, parseInt(fontSize, 10));
        }
        var allowDuplicatesInTimeScale = !w.config.xaxis.labels.showDuplicates && this.ctx.timeScale;
        if (!Array.isArray(label) && (String(label) === 'NaN' || drawnLabels.indexOf(label) >= 0 && allowDuplicatesInTimeScale)) {
          label = '';
        }
        return {
          x: x,
          text: label,
          textRect: textRect,
          isBold: isBold
        };
      }
    }, {
      key: "checkLabelBasedOnTickamount",
      value: function checkLabelBasedOnTickamount(i, label, labelsLen) {
        var w = this.w;
        var ticks = w.config.xaxis.tickAmount;
        if (ticks === 'dataPoints') ticks = Math.round(w.globals.gridWidth / 120);
        if (ticks > labelsLen) return label;
        var tickMultiple = Math.round(labelsLen / (ticks + 1));
        if (i % tickMultiple === 0) {
          return label;
        } else {
          label.text = '';
        }
        return label;
      }
    }, {
      key: "checkForOverflowingLabels",
      value: function checkForOverflowingLabels(i, label, labelsLen, drawnLabels, drawnLabelsRects) {
        var w = this.w;
        if (i === 0) {
          // check if first label is being truncated
          if (w.globals.skipFirstTimelinelabel) {
            label.text = '';
          }
        }
        if (i === labelsLen - 1) {
          // check if last label is being truncated
          if (w.globals.skipLastTimelinelabel) {
            label.text = '';
          }
        }
        if (w.config.xaxis.labels.hideOverlappingLabels && drawnLabels.length > 0) {
          var prev = drawnLabelsRects[drawnLabelsRects.length - 1];
          if (w.config.xaxis.labels.trim && w.config.xaxis.type !== 'datetime') {
            return label;
          }
          if (label.x < prev.textRect.width / (w.globals.rotateXLabels ? Math.abs(w.config.xaxis.labels.rotate) / 12 : 1.01) + prev.x) {
            label.text = '';
          }
        }
        return label;
      }
    }, {
      key: "checkForReversedLabels",
      value: function checkForReversedLabels(i, labels) {
        var w = this.w;
        if (w.config.yaxis[i] && w.config.yaxis[i].reversed) {
          labels.reverse();
        }
        return labels;
      }
    }, {
      key: "yAxisAllSeriesCollapsed",
      value: function yAxisAllSeriesCollapsed(index) {
        var gl = this.w.globals;
        return !gl.seriesYAxisMap[index].some(function (si) {
          return gl.collapsedSeriesIndices.indexOf(si) === -1;
        });
      }

      // Method to translate annotation.yAxisIndex values from
      // seriesName-as-a-string values to seriesName-as-an-array values (old style
      // series mapping to new style).
    }, {
      key: "translateYAxisIndex",
      value: function translateYAxisIndex(index) {
        var w = this.w;
        var gl = w.globals;
        var yaxis = w.config.yaxis;
        var newStyle = gl.series.length > yaxis.length || yaxis.some(function (a) {
          return Array.isArray(a.seriesName);
        });
        if (newStyle) {
          return index;
        } else {
          return gl.seriesYAxisReverseMap[index];
        }
      }
    }, {
      key: "isYAxisHidden",
      value: function isYAxisHidden(index) {
        var w = this.w;
        var yaxis = w.config.yaxis[index];
        if (!yaxis.show || this.yAxisAllSeriesCollapsed(index)) {
          return true;
        }
        if (!yaxis.showForNullSeries) {
          var seriesIndices = w.globals.seriesYAxisMap[index];
          var coreUtils = new CoreUtils(this.ctx);
          return seriesIndices.every(function (si) {
            return coreUtils.isSeriesNull(si);
          });
        }
        return false;
      }

      // get the label color for y-axis
      // realIndex is the actual series index, while i is the tick Index
    }, {
      key: "getYAxisForeColor",
      value: function getYAxisForeColor(yColors, realIndex) {
        var w = this.w;
        if (Array.isArray(yColors) && w.globals.yAxisScale[realIndex]) {
          this.ctx.theme.pushExtraColors(yColors, w.globals.yAxisScale[realIndex].result.length, false);
        }
        return yColors;
      }
    }, {
      key: "drawYAxisTicks",
      value: function drawYAxisTicks(x, tickAmount, axisBorder, axisTicks, realIndex, labelsDivider, elYaxis) {
        var w = this.w;
        var graphics = new Graphics(this.ctx);

        // initial label position = 0;
        var tY = w.globals.translateY + w.config.yaxis[realIndex].labels.offsetY;
        if (w.globals.isBarHorizontal) {
          tY = 0;
        } else if (w.config.chart.type === 'heatmap') {
          tY += labelsDivider / 2;
        }
        if (axisTicks.show && tickAmount > 0) {
          if (w.config.yaxis[realIndex].opposite === true) x = x + axisTicks.width;
          for (var i = tickAmount; i >= 0; i--) {
            var elTick = graphics.drawLine(x + axisBorder.offsetX - axisTicks.width + axisTicks.offsetX, tY + axisTicks.offsetY, x + axisBorder.offsetX + axisTicks.offsetX, tY + axisTicks.offsetY, axisTicks.color);
            elYaxis.add(elTick);
            tY += labelsDivider;
          }
        }
      }
    }]);
    return AxesUtils;
  }();

  var YAnnotations = /*#__PURE__*/function () {
    function YAnnotations(annoCtx) {
      _classCallCheck(this, YAnnotations);
      this.w = annoCtx.w;
      this.annoCtx = annoCtx;
      this.helpers = new Helpers$4(this.annoCtx);
      this.axesUtils = new AxesUtils(this.annoCtx);
    }
    _createClass(YAnnotations, [{
      key: "addYaxisAnnotation",
      value: function addYaxisAnnotation(anno, parent, index) {
        var w = this.w;
        var strokeDashArray = anno.strokeDashArray;
        var result = this.helpers.getY1Y2('y1', anno);
        var y1 = result.yP;
        var clipY1 = result.clipped;
        var y2;
        var clipY2 = true;
        var drawn = false;
        var text = anno.label.text;
        if (anno.y2 === null || typeof anno.y2 === 'undefined') {
          if (!clipY1) {
            drawn = true;
            var line = this.annoCtx.graphics.drawLine(0 + anno.offsetX,
            // x1
            y1 + anno.offsetY,
            // y1
            this._getYAxisAnnotationWidth(anno),
            // x2
            y1 + anno.offsetY,
            // y2
            anno.borderColor,
            // lineColor
            strokeDashArray,
            // dashArray
            anno.borderWidth);
            parent.appendChild(line.node);
            if (anno.id) {
              line.node.classList.add(anno.id);
            }
          }
        } else {
          result = this.helpers.getY1Y2('y2', anno);
          y2 = result.yP;
          clipY2 = result.clipped;
          if (y2 > y1) {
            var temp = y1;
            y1 = y2;
            y2 = temp;
          }
          if (!(clipY1 && clipY2)) {
            drawn = true;
            var rect = this.annoCtx.graphics.drawRect(0 + anno.offsetX,
            // x1
            y2 + anno.offsetY,
            // y1
            this._getYAxisAnnotationWidth(anno),
            // x2
            y1 - y2,
            // y2
            0,
            // radius
            anno.fillColor,
            // color
            anno.opacity,
            // opacity,
            1,
            // strokeWidth
            anno.borderColor,
            // strokeColor
            strokeDashArray // stokeDashArray
            );
            rect.node.classList.add('apexcharts-annotation-rect');
            rect.attr('clip-path', "url(#gridRectMask".concat(w.globals.cuid, ")"));
            parent.appendChild(rect.node);
            if (anno.id) {
              rect.node.classList.add(anno.id);
            }
          }
        }
        if (drawn) {
          var textX = anno.label.position === 'right' ? w.globals.gridWidth : anno.label.position === 'center' ? w.globals.gridWidth / 2 : 0;
          var elText = this.annoCtx.graphics.drawText({
            x: textX + anno.label.offsetX,
            y: (y2 != null ? y2 : y1) + anno.label.offsetY - 3,
            text: text,
            textAnchor: anno.label.textAnchor,
            fontSize: anno.label.style.fontSize,
            fontFamily: anno.label.style.fontFamily,
            fontWeight: anno.label.style.fontWeight,
            foreColor: anno.label.style.color,
            cssClass: "apexcharts-yaxis-annotation-label ".concat(anno.label.style.cssClass, " ").concat(anno.id ? anno.id : '')
          });
          elText.attr({
            rel: index
          });
          parent.appendChild(elText.node);
        }
      }
    }, {
      key: "_getYAxisAnnotationWidth",
      value: function _getYAxisAnnotationWidth(anno) {
        // issue apexcharts.js#2009
        var w = this.w;
        var width = w.globals.gridWidth;
        if (anno.width.indexOf('%') > -1) {
          width = w.globals.gridWidth * parseInt(anno.width, 10) / 100;
        } else {
          width = parseInt(anno.width, 10);
        }
        return width + anno.offsetX;
      }
    }, {
      key: "drawYAxisAnnotations",
      value: function drawYAxisAnnotations() {
        var _this = this;
        var w = this.w;
        var elg = this.annoCtx.graphics.group({
          class: 'apexcharts-yaxis-annotations'
        });
        w.config.annotations.yaxis.forEach(function (anno, index) {
          anno.yAxisIndex = _this.axesUtils.translateYAxisIndex(anno.yAxisIndex);
          if (!(_this.axesUtils.isYAxisHidden(anno.yAxisIndex) && _this.axesUtils.yAxisAllSeriesCollapsed(anno.yAxisIndex))) {
            _this.addYaxisAnnotation(anno, elg.node, index);
          }
        });
        return elg;
      }
    }]);
    return YAnnotations;
  }();

  var PointAnnotations = /*#__PURE__*/function () {
    function PointAnnotations(annoCtx) {
      _classCallCheck(this, PointAnnotations);
      this.w = annoCtx.w;
      this.annoCtx = annoCtx;
      this.helpers = new Helpers$4(this.annoCtx);
    }
    _createClass(PointAnnotations, [{
      key: "addPointAnnotation",
      value: function addPointAnnotation(anno, parent, index) {
        var w = this.w;
        if (w.globals.collapsedSeriesIndices.indexOf(anno.seriesIndex) > -1) {
          return;
        }
        var result = this.helpers.getX1X2('x1', anno);
        var x = result.x;
        var clipX = result.clipped;
        result = this.helpers.getY1Y2('y1', anno);
        var y = result.yP;
        var clipY = result.clipped;
        if (!Utils$1.isNumber(x)) return;
        if (!(clipY || clipX)) {
          var optsPoints = {
            pSize: anno.marker.size,
            pointStrokeWidth: anno.marker.strokeWidth,
            pointFillColor: anno.marker.fillColor,
            pointStrokeColor: anno.marker.strokeColor,
            shape: anno.marker.shape,
            pRadius: anno.marker.radius,
            class: "apexcharts-point-annotation-marker ".concat(anno.marker.cssClass, " ").concat(anno.id ? anno.id : '')
          };
          var point = this.annoCtx.graphics.drawMarker(x + anno.marker.offsetX, y + anno.marker.offsetY, optsPoints);
          parent.appendChild(point.node);
          var text = anno.label.text ? anno.label.text : '';
          var elText = this.annoCtx.graphics.drawText({
            x: x + anno.label.offsetX,
            y: y + anno.label.offsetY - anno.marker.size - parseFloat(anno.label.style.fontSize) / 1.6,
            text: text,
            textAnchor: anno.label.textAnchor,
            fontSize: anno.label.style.fontSize,
            fontFamily: anno.label.style.fontFamily,
            fontWeight: anno.label.style.fontWeight,
            foreColor: anno.label.style.color,
            cssClass: "apexcharts-point-annotation-label ".concat(anno.label.style.cssClass, " ").concat(anno.id ? anno.id : '')
          });
          elText.attr({
            rel: index
          });
          parent.appendChild(elText.node);

          // TODO: deprecate this as we will use custom
          if (anno.customSVG.SVG) {
            var g = this.annoCtx.graphics.group({
              class: 'apexcharts-point-annotations-custom-svg ' + anno.customSVG.cssClass
            });
            g.attr({
              transform: "translate(".concat(x + anno.customSVG.offsetX, ", ").concat(y + anno.customSVG.offsetY, ")")
            });
            g.node.innerHTML = anno.customSVG.SVG;
            parent.appendChild(g.node);
          }
          if (anno.image.path) {
            var imgWidth = anno.image.width ? anno.image.width : 20;
            var imgHeight = anno.image.height ? anno.image.height : 20;
            point = this.annoCtx.addImage({
              x: x + anno.image.offsetX - imgWidth / 2,
              y: y + anno.image.offsetY - imgHeight / 2,
              width: imgWidth,
              height: imgHeight,
              path: anno.image.path,
              appendTo: '.apexcharts-point-annotations'
            });
          }
          if (anno.mouseEnter) {
            point.node.addEventListener('mouseenter', anno.mouseEnter.bind(this, anno));
          }
          if (anno.mouseLeave) {
            point.node.addEventListener('mouseleave', anno.mouseLeave.bind(this, anno));
          }
          if (anno.click) {
            point.node.addEventListener('click', anno.click.bind(this, anno));
          }
        }
      }
    }, {
      key: "drawPointAnnotations",
      value: function drawPointAnnotations() {
        var _this = this;
        var w = this.w;
        var elg = this.annoCtx.graphics.group({
          class: 'apexcharts-point-annotations'
        });
        w.config.annotations.points.map(function (anno, index) {
          _this.addPointAnnotation(anno, elg.node, index);
        });
        return elg;
      }
    }]);
    return PointAnnotations;
  }();

  const name = "en";
  const options = {
  	months: [
  		"January",
  		"February",
  		"March",
  		"April",
  		"May",
  		"June",
  		"July",
  		"August",
  		"September",
  		"October",
  		"November",
  		"December"
  	],
  	shortMonths: [
  		"Jan",
  		"Feb",
  		"Mar",
  		"Apr",
  		"May",
  		"Jun",
  		"Jul",
  		"Aug",
  		"Sep",
  		"Oct",
  		"Nov",
  		"Dec"
  	],
  	days: [
  		"Sunday",
  		"Monday",
  		"Tuesday",
  		"Wednesday",
  		"Thursday",
  		"Friday",
  		"Saturday"
  	],
  	shortDays: [
  		"Sun",
  		"Mon",
  		"Tue",
  		"Wed",
  		"Thu",
  		"Fri",
  		"Sat"
  	],
  	toolbar: {
  		exportToSVG: "Download SVG",
  		exportToPNG: "Download PNG",
  		exportToCSV: "Download CSV",
  		menu: "Menu",
  		selection: "Selection",
  		selectionZoom: "Selection Zoom",
  		zoomIn: "Zoom In",
  		zoomOut: "Zoom Out",
  		pan: "Panning",
  		reset: "Reset Zoom"
  	}
  };
  var en = {
  	name: name,
  	options: options
  };

  var Options = /*#__PURE__*/function () {
    function Options() {
      _classCallCheck(this, Options);
      this.yAxis = {
        show: true,
        showAlways: false,
        showForNullSeries: true,
        seriesName: undefined,
        opposite: false,
        reversed: false,
        logarithmic: false,
        logBase: 10,
        tickAmount: undefined,
        stepSize: undefined,
        forceNiceScale: false,
        max: undefined,
        min: undefined,
        floating: false,
        decimalsInFloat: undefined,
        labels: {
          show: true,
          showDuplicates: false,
          minWidth: 0,
          maxWidth: 160,
          offsetX: 0,
          offsetY: 0,
          align: undefined,
          rotate: 0,
          padding: 20,
          style: {
            colors: [],
            fontSize: '11px',
            fontWeight: 400,
            fontFamily: undefined,
            cssClass: ''
          },
          formatter: undefined
        },
        axisBorder: {
          show: false,
          color: '#e0e0e0',
          width: 1,
          offsetX: 0,
          offsetY: 0
        },
        axisTicks: {
          show: false,
          color: '#e0e0e0',
          width: 6,
          offsetX: 0,
          offsetY: 0
        },
        title: {
          text: undefined,
          rotate: -90,
          offsetY: 0,
          offsetX: 0,
          style: {
            color: undefined,
            fontSize: '11px',
            fontWeight: 900,
            fontFamily: undefined,
            cssClass: ''
          }
        },
        tooltip: {
          enabled: false,
          offsetX: 0
        },
        crosshairs: {
          show: true,
          position: 'front',
          stroke: {
            color: '#b6b6b6',
            width: 1,
            dashArray: 0
          }
        }
      };
      this.pointAnnotation = {
        id: undefined,
        x: 0,
        y: null,
        yAxisIndex: 0,
        seriesIndex: undefined,
        mouseEnter: undefined,
        mouseLeave: undefined,
        click: undefined,
        marker: {
          size: 4,
          fillColor: '#fff',
          strokeWidth: 2,
          strokeColor: '#333',
          shape: 'circle',
          offsetX: 0,
          offsetY: 0,
          // radius: 2, // DEPRECATED
          cssClass: ''
        },
        label: {
          borderColor: '#c2c2c2',
          borderWidth: 1,
          borderRadius: 2,
          text: undefined,
          textAnchor: 'middle',
          offsetX: 0,
          offsetY: 0,
          mouseEnter: undefined,
          mouseLeave: undefined,
          click: undefined,
          style: {
            background: '#fff',
            color: undefined,
            fontSize: '11px',
            fontFamily: undefined,
            fontWeight: 400,
            cssClass: '',
            padding: {
              left: 5,
              right: 5,
              top: 2,
              bottom: 2
            }
          }
        },
        customSVG: {
          // this will be deprecated in the next major version as it is going to be replaced with a better alternative below (image)
          SVG: undefined,
          cssClass: undefined,
          offsetX: 0,
          offsetY: 0
        },
        image: {
          path: undefined,
          width: 20,
          height: 20,
          offsetX: 0,
          offsetY: 0
        }
      };
      this.yAxisAnnotation = {
        id: undefined,
        y: 0,
        y2: null,
        strokeDashArray: 1,
        fillColor: '#c2c2c2',
        borderColor: '#c2c2c2',
        borderWidth: 1,
        opacity: 0.3,
        offsetX: 0,
        offsetY: 0,
        width: '100%',
        yAxisIndex: 0,
        label: {
          borderColor: '#c2c2c2',
          borderWidth: 1,
          borderRadius: 2,
          text: undefined,
          textAnchor: 'end',
          position: 'right',
          offsetX: 0,
          offsetY: -3,
          mouseEnter: undefined,
          mouseLeave: undefined,
          click: undefined,
          style: {
            background: '#fff',
            color: undefined,
            fontSize: '11px',
            fontFamily: undefined,
            fontWeight: 400,
            cssClass: '',
            padding: {
              left: 5,
              right: 5,
              top: 2,
              bottom: 2
            }
          }
        }
      };
      this.xAxisAnnotation = {
        id: undefined,
        x: 0,
        x2: null,
        strokeDashArray: 1,
        fillColor: '#c2c2c2',
        borderColor: '#c2c2c2',
        borderWidth: 1,
        opacity: 0.3,
        offsetX: 0,
        offsetY: 0,
        label: {
          borderColor: '#c2c2c2',
          borderWidth: 1,
          borderRadius: 2,
          text: undefined,
          textAnchor: 'middle',
          orientation: 'vertical',
          position: 'top',
          offsetX: 0,
          offsetY: 0,
          mouseEnter: undefined,
          mouseLeave: undefined,
          click: undefined,
          style: {
            background: '#fff',
            color: undefined,
            fontSize: '11px',
            fontFamily: undefined,
            fontWeight: 400,
            cssClass: '',
            padding: {
              left: 5,
              right: 5,
              top: 2,
              bottom: 2
            }
          }
        }
      };
      this.text = {
        x: 0,
        y: 0,
        text: '',
        textAnchor: 'start',
        foreColor: undefined,
        fontSize: '13px',
        fontFamily: undefined,
        fontWeight: 400,
        appendTo: '.apexcharts-annotations',
        backgroundColor: 'transparent',
        borderColor: '#c2c2c2',
        borderRadius: 0,
        borderWidth: 0,
        paddingLeft: 4,
        paddingRight: 4,
        paddingTop: 2,
        paddingBottom: 2
      };
    }
    _createClass(Options, [{
      key: "init",
      value: function init() {
        return {
          annotations: {
            yaxis: [this.yAxisAnnotation],
            xaxis: [this.xAxisAnnotation],
            points: [this.pointAnnotation],
            texts: [],
            images: [],
            shapes: []
          },
          chart: {
            animations: {
              enabled: true,
              speed: 800,
              animateGradually: {
                delay: 150,
                enabled: true
              },
              dynamicAnimation: {
                enabled: true,
                speed: 350
              }
            },
            background: '',
            locales: [en],
            defaultLocale: 'en',
            dropShadow: {
              enabled: false,
              enabledOnSeries: undefined,
              top: 2,
              left: 2,
              blur: 4,
              color: '#000',
              opacity: 0.7
            },
            events: {
              animationEnd: undefined,
              beforeMount: undefined,
              mounted: undefined,
              updated: undefined,
              click: undefined,
              mouseMove: undefined,
              mouseLeave: undefined,
              xAxisLabelClick: undefined,
              legendClick: undefined,
              markerClick: undefined,
              selection: undefined,
              dataPointSelection: undefined,
              dataPointMouseEnter: undefined,
              dataPointMouseLeave: undefined,
              beforeZoom: undefined,
              beforeResetZoom: undefined,
              zoomed: undefined,
              scrolled: undefined,
              brushScrolled: undefined
            },
            foreColor: '#373d3f',
            fontFamily: 'Helvetica, Arial, sans-serif',
            height: 'auto',
            parentHeightOffset: 15,
            redrawOnParentResize: true,
            redrawOnWindowResize: true,
            id: undefined,
            group: undefined,
            nonce: undefined,
            offsetX: 0,
            offsetY: 0,
            injectStyleSheet: true,
            selection: {
              enabled: false,
              type: 'x',
              // selectedPoints: undefined, // default datapoints that should be selected automatically
              fill: {
                color: '#24292e',
                opacity: 0.1
              },
              stroke: {
                width: 1,
                color: '#24292e',
                opacity: 0.4,
                dashArray: 3
              },
              xaxis: {
                min: undefined,
                max: undefined
              },
              yaxis: {
                min: undefined,
                max: undefined
              }
            },
            sparkline: {
              enabled: false
            },
            brush: {
              enabled: false,
              autoScaleYaxis: true,
              target: undefined,
              targets: undefined
            },
            stacked: false,
            stackOnlyBar: true,
            // mixed chart with stacked bars and line series - incorrect line draw #907
            stackType: 'normal',
            toolbar: {
              show: true,
              offsetX: 0,
              offsetY: 0,
              tools: {
                download: true,
                selection: true,
                zoom: true,
                zoomin: true,
                zoomout: true,
                pan: true,
                reset: true,
                customIcons: []
              },
              export: {
                csv: {
                  filename: undefined,
                  columnDelimiter: ',',
                  headerCategory: 'category',
                  headerValue: 'value',
                  categoryFormatter: undefined,
                  valueFormatter: undefined
                },
                png: {
                  filename: undefined
                },
                svg: {
                  filename: undefined
                },
                scale: undefined,
                width: undefined
              },
              autoSelected: 'zoom' // accepts -> zoom, pan, selection
            },
            type: 'line',
            width: '100%',
            zoom: {
              enabled: true,
              type: 'x',
              autoScaleYaxis: false,
              allowMouseWheelZoom: true,
              zoomedArea: {
                fill: {
                  color: '#90CAF9',
                  opacity: 0.4
                },
                stroke: {
                  color: '#0D47A1',
                  opacity: 0.4,
                  width: 1
                }
              }
            }
          },
          parsing: {
            x: undefined,
            y: undefined
          },
          plotOptions: {
            line: {
              isSlopeChart: false,
              colors: {
                threshold: 0,
                colorAboveThreshold: undefined,
                colorBelowThreshold: undefined
              }
            },
            area: {
              fillTo: 'origin'
            },
            bar: {
              horizontal: false,
              columnWidth: '70%',
              // should be in percent 0 - 100
              barHeight: '70%',
              // should be in percent 0 - 100
              distributed: false,
              borderRadius: 0,
              borderRadiusApplication: 'around',
              // [around, end]
              borderRadiusWhenStacked: 'last',
              // [all, last]
              rangeBarOverlap: true,
              rangeBarGroupRows: false,
              hideZeroBarsWhenGrouped: false,
              isDumbbell: false,
              dumbbellColors: undefined,
              isFunnel: false,
              isFunnel3d: true,
              colors: {
                ranges: [],
                backgroundBarColors: [],
                backgroundBarOpacity: 1,
                backgroundBarRadius: 0
              },
              dataLabels: {
                position: 'top',
                // top, center, bottom
                maxItems: 100,
                hideOverflowingLabels: true,
                orientation: 'horizontal',
                total: {
                  enabled: false,
                  formatter: undefined,
                  offsetX: 0,
                  offsetY: 0,
                  style: {
                    color: '#373d3f',
                    fontSize: '12px',
                    fontFamily: undefined,
                    fontWeight: 600
                  }
                }
              }
            },
            bubble: {
              zScaling: true,
              minBubbleRadius: undefined,
              maxBubbleRadius: undefined
            },
            candlestick: {
              colors: {
                upward: '#00B746',
                downward: '#EF403C'
              },
              wick: {
                useFillColor: true
              }
            },
            boxPlot: {
              colors: {
                upper: '#00E396',
                lower: '#008FFB'
              }
            },
            heatmap: {
              radius: 2,
              enableShades: true,
              shadeIntensity: 0.5,
              reverseNegativeShade: false,
              distributed: false,
              useFillColorAsStroke: false,
              colorScale: {
                inverse: false,
                ranges: [],
                min: undefined,
                max: undefined
              }
            },
            treemap: {
              enableShades: true,
              shadeIntensity: 0.5,
              distributed: false,
              reverseNegativeShade: false,
              useFillColorAsStroke: false,
              borderRadius: 4,
              dataLabels: {
                format: 'scale' // scale | truncate
              },
              colorScale: {
                inverse: false,
                ranges: [],
                min: undefined,
                max: undefined
              },
              seriesTitle: {
                show: true,
                offsetY: 1,
                offsetX: 1,
                borderColor: '#000',
                borderWidth: 1,
                borderRadius: 2,
                style: {
                  background: 'rgba(0, 0, 0, 0.6)',
                  color: '#fff',
                  fontSize: '12px',
                  fontFamily: undefined,
                  fontWeight: 400,
                  cssClass: '',
                  padding: {
                    left: 6,
                    right: 6,
                    top: 2,
                    bottom: 2
                  }
                }
              }
            },
            radialBar: {
              inverseOrder: false,
              startAngle: 0,
              endAngle: 360,
              offsetX: 0,
              offsetY: 0,
              hollow: {
                margin: 5,
                size: '50%',
                background: 'transparent',
                image: undefined,
                imageWidth: 150,
                imageHeight: 150,
                imageOffsetX: 0,
                imageOffsetY: 0,
                imageClipped: true,
                position: 'front',
                dropShadow: {
                  enabled: false,
                  top: 0,
                  left: 0,
                  blur: 3,
                  color: '#000',
                  opacity: 0.5
                }
              },
              track: {
                show: true,
                startAngle: undefined,
                endAngle: undefined,
                background: '#f2f2f2',
                strokeWidth: '97%',
                opacity: 1,
                margin: 5,
                // margin is in pixels
                dropShadow: {
                  enabled: false,
                  top: 0,
                  left: 0,
                  blur: 3,
                  color: '#000',
                  opacity: 0.5
                }
              },
              dataLabels: {
                show: true,
                name: {
                  show: true,
                  fontSize: '16px',
                  fontFamily: undefined,
                  fontWeight: 600,
                  color: undefined,
                  offsetY: 0,
                  formatter: function formatter(val) {
                    return val;
                  }
                },
                value: {
                  show: true,
                  fontSize: '14px',
                  fontFamily: undefined,
                  fontWeight: 400,
                  color: undefined,
                  offsetY: 16,
                  formatter: function formatter(val) {
                    return val + '%';
                  }
                },
                total: {
                  show: false,
                  label: 'Total',
                  fontSize: '16px',
                  fontWeight: 600,
                  fontFamily: undefined,
                  color: undefined,
                  formatter: function formatter(w) {
                    return w.globals.seriesTotals.reduce(function (a, b) {
                      return a + b;
                    }, 0) / w.globals.series.length + '%';
                  }
                }
              },
              barLabels: {
                enabled: false,
                offsetX: 0,
                offsetY: 0,
                useSeriesColors: true,
                fontFamily: undefined,
                fontWeight: 600,
                fontSize: '16px',
                formatter: function formatter(val) {
                  return val;
                },
                onClick: undefined
              }
            },
            pie: {
              customScale: 1,
              offsetX: 0,
              offsetY: 0,
              startAngle: 0,
              endAngle: 360,
              expandOnClick: true,
              dataLabels: {
                // These are the percentage values which are displayed on slice
                offset: 0,
                // offset by which labels will move outside
                minAngleToShowLabel: 10
              },
              donut: {
                size: '65%',
                background: 'transparent',
                labels: {
                  // These are the inner labels appearing inside donut
                  show: false,
                  name: {
                    show: true,
                    fontSize: '16px',
                    fontFamily: undefined,
                    fontWeight: 600,
                    color: undefined,
                    offsetY: -10,
                    formatter: function formatter(val) {
                      return val;
                    }
                  },
                  value: {
                    show: true,
                    fontSize: '20px',
                    fontFamily: undefined,
                    fontWeight: 400,
                    color: undefined,
                    offsetY: 10,
                    formatter: function formatter(val) {
                      return val;
                    }
                  },
                  total: {
                    show: false,
                    showAlways: false,
                    label: 'Total',
                    fontSize: '16px',
                    fontWeight: 400,
                    fontFamily: undefined,
                    color: undefined,
                    formatter: function formatter(w) {
                      return w.globals.seriesTotals.reduce(function (a, b) {
                        return a + b;
                      }, 0);
                    }
                  }
                }
              }
            },
            polarArea: {
              rings: {
                strokeWidth: 1,
                strokeColor: '#e8e8e8'
              },
              spokes: {
                strokeWidth: 1,
                connectorColors: '#e8e8e8'
              }
            },
            radar: {
              size: undefined,
              offsetX: 0,
              offsetY: 0,
              polygons: {
                // strokeColor: '#e8e8e8', // should be deprecated in the minor version i.e 3.2
                strokeWidth: 1,
                strokeColors: '#e8e8e8',
                connectorColors: '#e8e8e8',
                fill: {
                  colors: undefined
                }
              }
            }
          },
          colors: undefined,
          dataLabels: {
            enabled: true,
            enabledOnSeries: undefined,
            formatter: function formatter(val) {
              return val !== null ? val : '';
            },
            textAnchor: 'middle',
            distributed: false,
            offsetX: 0,
            offsetY: 0,
            style: {
              fontSize: '12px',
              fontFamily: undefined,
              fontWeight: 600,
              colors: undefined
            },
            background: {
              enabled: true,
              foreColor: '#fff',
              backgroundColor: undefined,
              borderRadius: 2,
              padding: 4,
              opacity: 0.9,
              borderWidth: 1,
              borderColor: '#fff',
              dropShadow: {
                enabled: false,
                top: 1,
                left: 1,
                blur: 1,
                color: '#000',
                opacity: 0.8
              }
            },
            dropShadow: {
              enabled: false,
              top: 1,
              left: 1,
              blur: 1,
              color: '#000',
              opacity: 0.8
            }
          },
          fill: {
            type: 'solid',
            colors: undefined,
            // array of colors
            opacity: 0.85,
            gradient: {
              shade: 'dark',
              type: 'horizontal',
              shadeIntensity: 0.5,
              gradientToColors: undefined,
              inverseColors: true,
              opacityFrom: 1,
              opacityTo: 1,
              stops: [0, 50, 100],
              colorStops: []
            },
            image: {
              src: [],
              width: undefined,
              // optional
              height: undefined // optional
            },
            pattern: {
              style: 'squares',
              // String | Array of Strings
              width: 6,
              height: 6,
              strokeWidth: 2
            }
          },
          forecastDataPoints: {
            count: 0,
            fillOpacity: 0.5,
            strokeWidth: undefined,
            dashArray: 4
          },
          grid: {
            show: true,
            borderColor: '#e0e0e0',
            strokeDashArray: 0,
            position: 'back',
            xaxis: {
              lines: {
                show: false
              }
            },
            yaxis: {
              lines: {
                show: true
              }
            },
            row: {
              colors: undefined,
              // takes as array which will be repeated on rows
              opacity: 0.5
            },
            column: {
              colors: undefined,
              // takes an array which will be repeated on columns
              opacity: 0.5
            },
            padding: {
              top: 0,
              right: 10,
              bottom: 0,
              left: 12
            }
          },
          labels: [],
          legend: {
            show: true,
            showForSingleSeries: false,
            showForNullSeries: true,
            showForZeroSeries: true,
            floating: false,
            position: 'bottom',
            // whether to position legends in 1 of 4
            // direction - top, bottom, left, right
            horizontalAlign: 'center',
            // when position top/bottom, you can specify whether to align legends left, right or center
            inverseOrder: false,
            fontSize: '12px',
            fontFamily: undefined,
            fontWeight: 400,
            width: undefined,
            height: undefined,
            formatter: undefined,
            tooltipHoverFormatter: undefined,
            offsetX: -20,
            offsetY: 4,
            customLegendItems: [],
            clusterGroupedSeries: true,
            clusterGroupedSeriesOrientation: 'vertical',
            labels: {
              colors: undefined,
              useSeriesColors: false
            },
            markers: {
              size: 7,
              fillColors: undefined,
              strokeWidth: 1,
              shape: undefined,
              offsetX: 0,
              offsetY: 0,
              customHTML: undefined,
              onClick: undefined
            },
            itemMargin: {
              horizontal: 5,
              vertical: 4
            },
            onItemClick: {
              toggleDataSeries: true
            },
            onItemHover: {
              highlightDataSeries: true
            }
          },
          markers: {
            discrete: [],
            size: 0,
            colors: undefined,
            strokeColors: '#fff',
            strokeWidth: 2,
            strokeOpacity: 0.9,
            strokeDashArray: 0,
            fillOpacity: 1,
            shape: 'circle',
            offsetX: 0,
            offsetY: 0,
            showNullDataPoints: true,
            onClick: undefined,
            onDblClick: undefined,
            hover: {
              size: undefined,
              sizeOffset: 3
            }
          },
          noData: {
            text: undefined,
            align: 'center',
            verticalAlign: 'middle',
            offsetX: 0,
            offsetY: 0,
            style: {
              color: undefined,
              fontSize: '14px',
              fontFamily: undefined
            }
          },
          responsive: [],
          // breakpoints should follow ascending order 400, then 700, then 1000
          series: undefined,
          states: {
            hover: {
              filter: {
                type: 'lighten'
              }
            },
            active: {
              allowMultipleDataPointsSelection: false,
              filter: {
                type: 'darken'
              }
            }
          },
          title: {
            text: undefined,
            align: 'left',
            margin: 5,
            offsetX: 0,
            offsetY: 0,
            floating: false,
            style: {
              fontSize: '14px',
              fontWeight: 900,
              fontFamily: undefined,
              color: undefined
            }
          },
          subtitle: {
            text: undefined,
            align: 'left',
            margin: 5,
            offsetX: 0,
            offsetY: 30,
            floating: false,
            style: {
              fontSize: '12px',
              fontWeight: 400,
              fontFamily: undefined,
              color: undefined
            }
          },
          stroke: {
            show: true,
            curve: 'smooth',
            // "smooth" / "straight" / "monotoneCubic" / "stepline" / "linestep"
            lineCap: 'butt',
            // round, butt , square
            width: 2,
            colors: undefined,
            // array of colors
            dashArray: 0,
            // single value or array of values
            fill: {
              type: 'solid',
              colors: undefined,
              // array of colors
              opacity: 0.85,
              gradient: {
                shade: 'dark',
                type: 'horizontal',
                shadeIntensity: 0.5,
                gradientToColors: undefined,
                inverseColors: true,
                opacityFrom: 1,
                opacityTo: 1,
                stops: [0, 50, 100],
                colorStops: []
              }
            }
          },
          tooltip: {
            enabled: true,
            enabledOnSeries: undefined,
            shared: true,
            hideEmptySeries: false,
            followCursor: false,
            // when disabled, the tooltip will show on top of the series instead of mouse position
            intersect: false,
            // when enabled, tooltip will only show when user directly hovers over point
            inverseOrder: false,
            custom: undefined,
            fillSeriesColor: false,
            theme: 'light',
            cssClass: '',
            style: {
              fontSize: '12px',
              fontFamily: undefined
            },
            onDatasetHover: {
              highlightDataSeries: false
            },
            x: {
              // x value
              show: true,
              format: 'dd MMM',
              // dd/MM, dd MMM yy, dd MMM yyyy
              formatter: undefined // a custom user supplied formatter function
            },
            y: {
              formatter: undefined,
              title: {
                formatter: function formatter(seriesName) {
                  return seriesName ? seriesName + ': ' : '';
                }
              }
            },
            z: {
              formatter: undefined,
              title: 'Size: '
            },
            marker: {
              show: true,
              fillColors: undefined
            },
            items: {
              display: 'flex'
            },
            fixed: {
              enabled: false,
              position: 'topRight',
              // topRight, topLeft, bottomRight, bottomLeft
              offsetX: 0,
              offsetY: 0
            }
          },
          xaxis: {
            type: 'category',
            categories: [],
            convertedCatToNumeric: false,
            // internal property which should not be altered outside
            offsetX: 0,
            offsetY: 0,
            overwriteCategories: undefined,
            labels: {
              show: true,
              rotate: -45,
              rotateAlways: false,
              hideOverlappingLabels: true,
              trim: false,
              minHeight: undefined,
              maxHeight: 120,
              showDuplicates: true,
              style: {
                colors: [],
                fontSize: '12px',
                fontWeight: 400,
                fontFamily: undefined,
                cssClass: ''
              },
              offsetX: 0,
              offsetY: 0,
              format: undefined,
              formatter: undefined,
              // custom formatter function which will override format
              datetimeUTC: true,
              datetimeFormatter: {
                year: 'yyyy',
                month: "MMM 'yy",
                day: 'dd MMM',
                hour: 'HH:mm',
                minute: 'HH:mm:ss',
                second: 'HH:mm:ss'
              }
            },
            group: {
              groups: [],
              style: {
                colors: [],
                fontSize: '12px',
                fontWeight: 400,
                fontFamily: undefined,
                cssClass: ''
              }
            },
            axisBorder: {
              show: true,
              color: '#e0e0e0',
              width: '100%',
              height: 1,
              offsetX: 0,
              offsetY: 0
            },
            axisTicks: {
              show: true,
              color: '#e0e0e0',
              height: 6,
              offsetX: 0,
              offsetY: 0
            },
            stepSize: undefined,
            tickAmount: undefined,
            tickPlacement: 'on',
            min: undefined,
            max: undefined,
            range: undefined,
            floating: false,
            decimalsInFloat: undefined,
            position: 'bottom',
            title: {
              text: undefined,
              offsetX: 0,
              offsetY: 0,
              style: {
                color: undefined,
                fontSize: '12px',
                fontWeight: 900,
                fontFamily: undefined,
                cssClass: ''
              }
            },
            crosshairs: {
              show: true,
              width: 1,
              // tickWidth/barWidth or an integer
              position: 'back',
              opacity: 0.9,
              stroke: {
                color: '#b6b6b6',
                width: 1,
                dashArray: 3
              },
              fill: {
                type: 'solid',
                // solid, gradient
                color: '#B1B9C4',
                gradient: {
                  colorFrom: '#D8E3F0',
                  colorTo: '#BED1E6',
                  stops: [0, 100],
                  opacityFrom: 0.4,
                  opacityTo: 0.5
                }
              },
              dropShadow: {
                enabled: false,
                left: 0,
                top: 0,
                blur: 1,
                opacity: 0.8
              }
            },
            tooltip: {
              enabled: true,
              offsetY: 0,
              formatter: undefined,
              style: {
                fontSize: '12px',
                fontFamily: undefined
              }
            }
          },
          yaxis: this.yAxis,
          theme: {
            mode: '',
            palette: 'palette1',
            // If defined, it will overwrite globals.colors variable
            monochrome: {
              // monochrome allows you to select just 1 color and fill out the rest with light/dark shade (intensity can be selected)
              enabled: false,
              color: '#008FFB',
              shadeTo: 'light',
              shadeIntensity: 0.65
            }
          }
        };
      }
    }]);
    return Options;
  }();

  /**
   * ApexCharts Annotations Class for drawing lines/rects on both xaxis and yaxis.
   *
   * @module Annotations
   **/
  var Annotations = /*#__PURE__*/function () {
    function Annotations(ctx) {
      _classCallCheck(this, Annotations);
      this.ctx = ctx;
      this.w = ctx.w;
      this.graphics = new Graphics(this.ctx);
      if (this.w.globals.isBarHorizontal) {
        this.invertAxis = true;
      }
      this.helpers = new Helpers$4(this);
      this.xAxisAnnotations = new XAnnotations(this);
      this.yAxisAnnotations = new YAnnotations(this);
      this.pointsAnnotations = new PointAnnotations(this);
      if (this.w.globals.isBarHorizontal && this.w.config.yaxis[0].reversed) {
        this.inversedReversedAxis = true;
      }
      this.xDivision = this.w.globals.gridWidth / this.w.globals.dataPoints;
    }
    _createClass(Annotations, [{
      key: "drawAxesAnnotations",
      value: function drawAxesAnnotations() {
        var w = this.w;
        if (w.globals.axisCharts && w.globals.dataPoints) {
          // w.globals.dataPoints check added to fix  #1832
          var yAnnotations = this.yAxisAnnotations.drawYAxisAnnotations();
          var xAnnotations = this.xAxisAnnotations.drawXAxisAnnotations();
          var pointAnnotations = this.pointsAnnotations.drawPointAnnotations();
          var initialAnim = w.config.chart.animations.enabled;
          var annoArray = [yAnnotations, xAnnotations, pointAnnotations];
          var annoElArray = [xAnnotations.node, yAnnotations.node, pointAnnotations.node];
          for (var i = 0; i < 3; i++) {
            w.globals.dom.elGraphical.add(annoArray[i]);
            if (initialAnim && !w.globals.resized && !w.globals.dataChanged) {
              // fixes apexcharts/apexcharts.js#685
              if (w.config.chart.type !== 'scatter' && w.config.chart.type !== 'bubble' && w.globals.dataPoints > 1) {
                annoElArray[i].classList.add('apexcharts-element-hidden');
              }
            }
            w.globals.delayedElements.push({
              el: annoElArray[i],
              index: 0
            });
          }

          // background sizes needs to be calculated after text is drawn, so calling them last
          this.helpers.annotationsBackground();
        }
      }
    }, {
      key: "drawImageAnnos",
      value: function drawImageAnnos() {
        var _this = this;
        var w = this.w;
        w.config.annotations.images.map(function (s, index) {
          _this.addImage(s, index);
        });
      }
    }, {
      key: "drawTextAnnos",
      value: function drawTextAnnos() {
        var _this2 = this;
        var w = this.w;
        w.config.annotations.texts.map(function (t, index) {
          _this2.addText(t, index);
        });
      }
    }, {
      key: "addXaxisAnnotation",
      value: function addXaxisAnnotation(anno, parent, index) {
        this.xAxisAnnotations.addXaxisAnnotation(anno, parent, index);
      }
    }, {
      key: "addYaxisAnnotation",
      value: function addYaxisAnnotation(anno, parent, index) {
        this.yAxisAnnotations.addYaxisAnnotation(anno, parent, index);
      }
    }, {
      key: "addPointAnnotation",
      value: function addPointAnnotation(anno, parent, index) {
        this.pointsAnnotations.addPointAnnotation(anno, parent, index);
      }
    }, {
      key: "addText",
      value: function addText(params, index) {
        var x = params.x,
          y = params.y,
          text = params.text,
          textAnchor = params.textAnchor,
          foreColor = params.foreColor,
          fontSize = params.fontSize,
          fontFamily = params.fontFamily,
          fontWeight = params.fontWeight,
          cssClass = params.cssClass,
          backgroundColor = params.backgroundColor,
          borderWidth = params.borderWidth,
          strokeDashArray = params.strokeDashArray,
          borderRadius = params.borderRadius,
          borderColor = params.borderColor,
          _params$appendTo = params.appendTo,
          appendTo = _params$appendTo === void 0 ? '.apexcharts-svg' : _params$appendTo,
          _params$paddingLeft = params.paddingLeft,
          paddingLeft = _params$paddingLeft === void 0 ? 4 : _params$paddingLeft,
          _params$paddingRight = params.paddingRight,
          paddingRight = _params$paddingRight === void 0 ? 4 : _params$paddingRight,
          _params$paddingBottom = params.paddingBottom,
          paddingBottom = _params$paddingBottom === void 0 ? 2 : _params$paddingBottom,
          _params$paddingTop = params.paddingTop,
          paddingTop = _params$paddingTop === void 0 ? 2 : _params$paddingTop;
        var w = this.w;
        var elText = this.graphics.drawText({
          x: x,
          y: y,
          text: text,
          textAnchor: textAnchor || 'start',
          fontSize: fontSize || '12px',
          fontWeight: fontWeight || 'regular',
          fontFamily: fontFamily || w.config.chart.fontFamily,
          foreColor: foreColor || w.config.chart.foreColor,
          cssClass: 'apexcharts-text ' + cssClass ? cssClass : ''
        });
        var parent = w.globals.dom.baseEl.querySelector(appendTo);
        if (parent) {
          parent.appendChild(elText.node);
        }
        var textRect = elText.bbox();
        if (text) {
          var elRect = this.graphics.drawRect(textRect.x - paddingLeft, textRect.y - paddingTop, textRect.width + paddingLeft + paddingRight, textRect.height + paddingBottom + paddingTop, borderRadius, backgroundColor ? backgroundColor : 'transparent', 1, borderWidth, borderColor, strokeDashArray);
          parent.insertBefore(elRect.node, elText.node);
        }
      }
    }, {
      key: "addImage",
      value: function addImage(params, index) {
        var w = this.w;
        var path = params.path,
          _params$x = params.x,
          x = _params$x === void 0 ? 0 : _params$x,
          _params$y = params.y,
          y = _params$y === void 0 ? 0 : _params$y,
          _params$width = params.width,
          width = _params$width === void 0 ? 20 : _params$width,
          _params$height = params.height,
          height = _params$height === void 0 ? 20 : _params$height,
          _params$appendTo2 = params.appendTo,
          appendTo = _params$appendTo2 === void 0 ? '.apexcharts-svg' : _params$appendTo2;
        var img = w.globals.dom.Paper.image(path);
        img.size(width, height).move(x, y);
        var parent = w.globals.dom.baseEl.querySelector(appendTo);
        if (parent) {
          parent.appendChild(img.node);
        }
        return img;
      }

      // The addXaxisAnnotation method requires a parent class, and user calling this method externally on the chart instance may not specify parent, hence a different method
    }, {
      key: "addXaxisAnnotationExternal",
      value: function addXaxisAnnotationExternal(params, pushToMemory, context) {
        this.addAnnotationExternal({
          params: params,
          pushToMemory: pushToMemory,
          context: context,
          type: 'xaxis',
          contextMethod: context.addXaxisAnnotation
        });
        return context;
      }
    }, {
      key: "addYaxisAnnotationExternal",
      value: function addYaxisAnnotationExternal(params, pushToMemory, context) {
        this.addAnnotationExternal({
          params: params,
          pushToMemory: pushToMemory,
          context: context,
          type: 'yaxis',
          contextMethod: context.addYaxisAnnotation
        });
        return context;
      }
    }, {
      key: "addPointAnnotationExternal",
      value: function addPointAnnotationExternal(params, pushToMemory, context) {
        if (typeof this.invertAxis === 'undefined') {
          this.invertAxis = context.w.globals.isBarHorizontal;
        }
        this.addAnnotationExternal({
          params: params,
          pushToMemory: pushToMemory,
          context: context,
          type: 'point',
          contextMethod: context.addPointAnnotation
        });
        return context;
      }
    }, {
      key: "addAnnotationExternal",
      value: function addAnnotationExternal(_ref) {
        var params = _ref.params,
          pushToMemory = _ref.pushToMemory,
          context = _ref.context,
          type = _ref.type,
          contextMethod = _ref.contextMethod;
        var me = context;
        var w = me.w;
        var parent = w.globals.dom.baseEl.querySelector(".apexcharts-".concat(type, "-annotations"));
        var index = parent.childNodes.length + 1;
        var options = new Options();
        var axesAnno = Object.assign({}, type === 'xaxis' ? options.xAxisAnnotation : type === 'yaxis' ? options.yAxisAnnotation : options.pointAnnotation);
        var anno = Utils$1.extend(axesAnno, params);
        switch (type) {
          case 'xaxis':
            this.addXaxisAnnotation(anno, parent, index);
            break;
          case 'yaxis':
            this.addYaxisAnnotation(anno, parent, index);
            break;
          case 'point':
            this.addPointAnnotation(anno, parent, index);
            break;
        }

        // add background
        var axesAnnoLabel = w.globals.dom.baseEl.querySelector(".apexcharts-".concat(type, "-annotations .apexcharts-").concat(type, "-annotation-label[rel='").concat(index, "']"));
        var elRect = this.helpers.addBackgroundToAnno(axesAnnoLabel, anno);
        if (elRect) {
          parent.insertBefore(elRect.node, axesAnnoLabel);
        }
        if (pushToMemory) {
          w.globals.memory.methodsToExec.push({
            context: me,
            id: anno.id ? anno.id : Utils$1.randomId(),
            method: contextMethod,
            label: 'addAnnotation',
            params: params
          });
        }
        return context;
      }
    }, {
      key: "clearAnnotations",
      value: function clearAnnotations(ctx) {
        var w = ctx.w;
        var annos = w.globals.dom.baseEl.querySelectorAll('.apexcharts-yaxis-annotations, .apexcharts-xaxis-annotations, .apexcharts-point-annotations');

        // annotations added externally should be cleared out too
        for (var i = w.globals.memory.methodsToExec.length - 1; i >= 0; i--) {
          if (w.globals.memory.methodsToExec[i].label === 'addText' || w.globals.memory.methodsToExec[i].label === 'addAnnotation') {
            w.globals.memory.methodsToExec.splice(i, 1);
          }
        }
        annos = Utils$1.listToArray(annos);

        // delete the DOM elements
        Array.prototype.forEach.call(annos, function (a) {
          while (a.firstChild) {
            a.removeChild(a.firstChild);
          }
        });
      }
    }, {
      key: "removeAnnotation",
      value: function removeAnnotation(ctx, id) {
        var w = ctx.w;
        var annos = w.globals.dom.baseEl.querySelectorAll(".".concat(id));
        if (annos) {
          w.globals.memory.methodsToExec.map(function (m, i) {
            if (m.id === id) {
              w.globals.memory.methodsToExec.splice(i, 1);
            }
          });
          Object.keys(w.config.annotations).forEach(function (key) {
            var annotationArray = w.config.annotations[key];
            if (Array.isArray(annotationArray)) {
              // remove entry from the config, so on the next update it doesn't come back
              w.config.annotations[key] = annotationArray.filter(function (m) {
                return m.id !== id;
              });
            }
          });
          Array.prototype.forEach.call(annos, function (a) {
            a.parentElement.removeChild(a);
          });
        }
      }
    }]);
    return Annotations;
  }();

  /**
   * ApexCharts Default Class for setting default options for all chart types.
   *
   * @module Defaults
   **/

  var getRangeValues = function getRangeValues(_ref) {
    var _w$config$series$seri;
    var isTimeline = _ref.isTimeline,
      ctx = _ref.ctx,
      seriesIndex = _ref.seriesIndex,
      dataPointIndex = _ref.dataPointIndex,
      y1 = _ref.y1,
      y2 = _ref.y2,
      w = _ref.w;
    var start = w.globals.seriesRangeStart[seriesIndex][dataPointIndex];
    var end = w.globals.seriesRangeEnd[seriesIndex][dataPointIndex];
    var ylabel = w.globals.labels[dataPointIndex];
    var seriesName = w.config.series[seriesIndex].name ? w.config.series[seriesIndex].name : '';
    var yLbFormatter = w.globals.ttKeyFormatter;
    var yLbTitleFormatter = w.config.tooltip.y.title.formatter;
    var opts = {
      w: w,
      seriesIndex: seriesIndex,
      dataPointIndex: dataPointIndex,
      start: start,
      end: end
    };
    if (typeof yLbTitleFormatter === 'function') {
      seriesName = yLbTitleFormatter(seriesName, opts);
    }
    if ((_w$config$series$seri = w.config.series[seriesIndex].data[dataPointIndex]) !== null && _w$config$series$seri !== void 0 && _w$config$series$seri.x) {
      ylabel = w.config.series[seriesIndex].data[dataPointIndex].x;
    }
    if (!isTimeline) {
      if (w.config.xaxis.type === 'datetime') {
        var xFormat = new Formatters(ctx);
        ylabel = xFormat.xLabelFormat(w.globals.ttKeyFormatter, ylabel, ylabel, {
          i: undefined,
          dateFormatter: new DateTime(ctx).formatDate,
          w: w
        });
      }
    }
    if (typeof yLbFormatter === 'function') {
      ylabel = yLbFormatter(ylabel, opts);
    }
    if (Number.isFinite(y1) && Number.isFinite(y2)) {
      start = y1;
      end = y2;
    }
    var startVal = '';
    var endVal = '';
    var color = w.globals.colors[seriesIndex];
    if (w.config.tooltip.x.formatter === undefined) {
      if (w.config.xaxis.type === 'datetime') {
        var datetimeObj = new DateTime(ctx);
        startVal = datetimeObj.formatDate(datetimeObj.getDate(start), w.config.tooltip.x.format);
        endVal = datetimeObj.formatDate(datetimeObj.getDate(end), w.config.tooltip.x.format);
      } else {
        startVal = start;
        endVal = end;
      }
    } else {
      startVal = w.config.tooltip.x.formatter(start);
      endVal = w.config.tooltip.x.formatter(end);
    }
    return {
      start: start,
      end: end,
      startVal: startVal,
      endVal: endVal,
      ylabel: ylabel,
      color: color,
      seriesName: seriesName
    };
  };
  var buildRangeTooltipHTML = function buildRangeTooltipHTML(opts) {
    var color = opts.color,
      seriesName = opts.seriesName,
      ylabel = opts.ylabel,
      start = opts.start,
      end = opts.end,
      seriesIndex = opts.seriesIndex,
      dataPointIndex = opts.dataPointIndex;
    var formatter = opts.ctx.tooltip.tooltipLabels.getFormatters(seriesIndex);
    start = formatter.yLbFormatter(start);
    end = formatter.yLbFormatter(end);
    var val = formatter.yLbFormatter(opts.w.globals.series[seriesIndex][dataPointIndex]);
    var valueHTML = '';
    var rangeValues = "<span class=\"value start-value\">\n  ".concat(start, "\n  </span> <span class=\"separator\">-</span> <span class=\"value end-value\">\n  ").concat(end, "\n  </span>");
    if (opts.w.globals.comboCharts) {
      if (opts.w.config.series[seriesIndex].type === 'rangeArea' || opts.w.config.series[seriesIndex].type === 'rangeBar') {
        valueHTML = rangeValues;
      } else {
        valueHTML = "<span>".concat(val, "</span>");
      }
    } else {
      valueHTML = rangeValues;
    }
    return '<div class="apexcharts-tooltip-rangebar">' + '<div> <span class="series-name" style="color: ' + color + '">' + (seriesName ? seriesName : '') + '</span></div>' + '<div> <span class="category">' + ylabel + ': </span> ' + valueHTML + ' </div>' + '</div>';
  };
  var Defaults = /*#__PURE__*/function () {
    function Defaults(opts) {
      _classCallCheck(this, Defaults);
      this.opts = opts;
    }
    _createClass(Defaults, [{
      key: "hideYAxis",
      value: function hideYAxis() {
        this.opts.yaxis[0].show = false;
        this.opts.yaxis[0].title.text = '';
        this.opts.yaxis[0].axisBorder.show = false;
        this.opts.yaxis[0].axisTicks.show = false;
        this.opts.yaxis[0].floating = true;
      }
    }, {
      key: "line",
      value: function line() {
        return {
          dataLabels: {
            enabled: false
          },
          stroke: {
            width: 5,
            curve: 'straight'
          },
          markers: {
            size: 0,
            hover: {
              sizeOffset: 6
            }
          },
          xaxis: {
            crosshairs: {
              width: 1
            }
          }
        };
      }
    }, {
      key: "sparkline",
      value: function sparkline(defaults) {
        this.hideYAxis();
        var ret = {
          grid: {
            show: false,
            padding: {
              left: 0,
              right: 0,
              top: 0,
              bottom: 0
            }
          },
          legend: {
            show: false
          },
          xaxis: {
            labels: {
              show: false
            },
            tooltip: {
              enabled: false
            },
            axisBorder: {
              show: false
            },
            axisTicks: {
              show: false
            }
          },
          chart: {
            toolbar: {
              show: false
            },
            zoom: {
              enabled: false
            }
          },
          dataLabels: {
            enabled: false
          }
        };
        return Utils$1.extend(defaults, ret);
      }
    }, {
      key: "slope",
      value: function slope() {
        this.hideYAxis();
        return {
          chart: {
            toolbar: {
              show: false
            },
            zoom: {
              enabled: false
            }
          },
          dataLabels: {
            enabled: true,
            formatter: function formatter(val, opts) {
              var seriesName = opts.w.config.series[opts.seriesIndex].name;
              return val !== null ? seriesName + ': ' + val : '';
            },
            background: {
              enabled: false
            },
            offsetX: -5
          },
          grid: {
            xaxis: {
              lines: {
                show: true
              }
            },
            yaxis: {
              lines: {
                show: false
              }
            }
          },
          xaxis: {
            position: 'top',
            labels: {
              style: {
                fontSize: 14,
                fontWeight: 900
              }
            },
            tooltip: {
              enabled: false
            },
            crosshairs: {
              show: false
            }
          },
          markers: {
            size: 8,
            hover: {
              sizeOffset: 1
            }
          },
          legend: {
            show: false
          },
          tooltip: {
            shared: false,
            intersect: true,
            followCursor: true
          },
          stroke: {
            width: 5,
            curve: 'straight'
          }
        };
      }
    }, {
      key: "bar",
      value: function bar() {
        return {
          chart: {
            stacked: false
          },
          plotOptions: {
            bar: {
              dataLabels: {
                position: 'center'
              }
            }
          },
          dataLabels: {
            style: {
              colors: ['#fff']
            },
            background: {
              enabled: false
            }
          },
          stroke: {
            width: 0,
            lineCap: 'square'
          },
          fill: {
            opacity: 0.85
          },
          legend: {
            markers: {
              shape: 'square'
            }
          },
          tooltip: {
            shared: false,
            intersect: true
          },
          xaxis: {
            tooltip: {
              enabled: false
            },
            tickPlacement: 'between',
            crosshairs: {
              width: 'barWidth',
              position: 'back',
              fill: {
                type: 'gradient'
              },
              dropShadow: {
                enabled: false
              },
              stroke: {
                width: 0
              }
            }
          }
        };
      }
    }, {
      key: "funnel",
      value: function funnel() {
        this.hideYAxis();
        return _objectSpread2(_objectSpread2({}, this.bar()), {}, {
          chart: {
            animations: {
              speed: 800,
              animateGradually: {
                enabled: false
              }
            }
          },
          plotOptions: {
            bar: {
              horizontal: true,
              borderRadiusApplication: 'around',
              borderRadius: 0,
              dataLabels: {
                position: 'center'
              }
            }
          },
          grid: {
            show: false,
            padding: {
              left: 0,
              right: 0
            }
          },
          xaxis: {
            labels: {
              show: false
            },
            tooltip: {
              enabled: false
            },
            axisBorder: {
              show: false
            },
            axisTicks: {
              show: false
            }
          }
        });
      }
    }, {
      key: "candlestick",
      value: function candlestick() {
        var _this = this;
        return {
          stroke: {
            width: 1
          },
          fill: {
            opacity: 1
          },
          dataLabels: {
            enabled: false
          },
          tooltip: {
            shared: true,
            custom: function custom(_ref2) {
              var seriesIndex = _ref2.seriesIndex,
                dataPointIndex = _ref2.dataPointIndex,
                w = _ref2.w;
              return _this._getBoxTooltip(w, seriesIndex, dataPointIndex, ['Open', 'High', '', 'Low', 'Close'], 'candlestick');
            }
          },
          states: {
            active: {
              filter: {
                type: 'none'
              }
            }
          },
          xaxis: {
            crosshairs: {
              width: 1
            }
          }
        };
      }
    }, {
      key: "boxPlot",
      value: function boxPlot() {
        var _this2 = this;
        return {
          chart: {
            animations: {
              dynamicAnimation: {
                enabled: false
              }
            }
          },
          stroke: {
            width: 1,
            colors: ['#24292e']
          },
          dataLabels: {
            enabled: false
          },
          tooltip: {
            shared: true,
            custom: function custom(_ref3) {
              var seriesIndex = _ref3.seriesIndex,
                dataPointIndex = _ref3.dataPointIndex,
                w = _ref3.w;
              return _this2._getBoxTooltip(w, seriesIndex, dataPointIndex, ['Minimum', 'Q1', 'Median', 'Q3', 'Maximum'], 'boxPlot');
            }
          },
          markers: {
            size: 7,
            strokeWidth: 1,
            strokeColors: '#111'
          },
          xaxis: {
            crosshairs: {
              width: 1
            }
          }
        };
      }
    }, {
      key: "rangeBar",
      value: function rangeBar() {
        var handleTimelineTooltip = function handleTimelineTooltip(opts) {
          var _getRangeValues = getRangeValues(_objectSpread2(_objectSpread2({}, opts), {}, {
              isTimeline: true
            })),
            color = _getRangeValues.color,
            seriesName = _getRangeValues.seriesName,
            ylabel = _getRangeValues.ylabel,
            startVal = _getRangeValues.startVal,
            endVal = _getRangeValues.endVal;
          return buildRangeTooltipHTML(_objectSpread2(_objectSpread2({}, opts), {}, {
            color: color,
            seriesName: seriesName,
            ylabel: ylabel,
            start: startVal,
            end: endVal
          }));
        };
        var handleRangeColumnTooltip = function handleRangeColumnTooltip(opts) {
          var _getRangeValues2 = getRangeValues(opts),
            color = _getRangeValues2.color,
            seriesName = _getRangeValues2.seriesName,
            ylabel = _getRangeValues2.ylabel,
            start = _getRangeValues2.start,
            end = _getRangeValues2.end;
          return buildRangeTooltipHTML(_objectSpread2(_objectSpread2({}, opts), {}, {
            color: color,
            seriesName: seriesName,
            ylabel: ylabel,
            start: start,
            end: end
          }));
        };
        return {
          chart: {
            animations: {
              animateGradually: false
            }
          },
          stroke: {
            width: 0,
            lineCap: 'square'
          },
          plotOptions: {
            bar: {
              borderRadius: 0,
              dataLabels: {
                position: 'center'
              }
            }
          },
          dataLabels: {
            enabled: false,
            formatter: function formatter(val, _ref4) {
              _ref4.ctx;
                var seriesIndex = _ref4.seriesIndex,
                dataPointIndex = _ref4.dataPointIndex,
                w = _ref4.w;
              var getVal = function getVal() {
                var start = w.globals.seriesRangeStart[seriesIndex][dataPointIndex];
                var end = w.globals.seriesRangeEnd[seriesIndex][dataPointIndex];
                return end - start;
              };
              if (w.globals.comboCharts) {
                if (w.config.series[seriesIndex].type === 'rangeBar' || w.config.series[seriesIndex].type === 'rangeArea') {
                  return getVal();
                } else {
                  return val;
                }
              } else {
                return getVal();
              }
            },
            background: {
              enabled: false
            },
            style: {
              colors: ['#fff']
            }
          },
          markers: {
            size: 10
          },
          tooltip: {
            shared: false,
            followCursor: true,
            custom: function custom(opts) {
              if (opts.w.config.plotOptions && opts.w.config.plotOptions.bar && opts.w.config.plotOptions.bar.horizontal) {
                return handleTimelineTooltip(opts);
              } else {
                return handleRangeColumnTooltip(opts);
              }
            }
          },
          xaxis: {
            tickPlacement: 'between',
            tooltip: {
              enabled: false
            },
            crosshairs: {
              stroke: {
                width: 0
              }
            }
          }
        };
      }
    }, {
      key: "dumbbell",
      value: function dumbbell(opts) {
        var _opts$plotOptions$bar, _opts$plotOptions$bar2;
        if (!((_opts$plotOptions$bar = opts.plotOptions.bar) !== null && _opts$plotOptions$bar !== void 0 && _opts$plotOptions$bar.barHeight)) {
          opts.plotOptions.bar.barHeight = 2;
        }
        if (!((_opts$plotOptions$bar2 = opts.plotOptions.bar) !== null && _opts$plotOptions$bar2 !== void 0 && _opts$plotOptions$bar2.columnWidth)) {
          opts.plotOptions.bar.columnWidth = 2;
        }
        return opts;
      }
    }, {
      key: "area",
      value: function area() {
        return {
          stroke: {
            width: 4,
            fill: {
              type: 'solid',
              gradient: {
                inverseColors: false,
                shade: 'light',
                type: 'vertical',
                opacityFrom: 0.65,
                opacityTo: 0.5,
                stops: [0, 100, 100]
              }
            }
          },
          fill: {
            type: 'gradient',
            gradient: {
              inverseColors: false,
              shade: 'light',
              type: 'vertical',
              opacityFrom: 0.65,
              opacityTo: 0.5,
              stops: [0, 100, 100]
            }
          },
          markers: {
            size: 0,
            hover: {
              sizeOffset: 6
            }
          },
          tooltip: {
            followCursor: false
          }
        };
      }
    }, {
      key: "rangeArea",
      value: function rangeArea() {
        var handleRangeAreaTooltip = function handleRangeAreaTooltip(opts) {
          var _getRangeValues3 = getRangeValues(opts),
            color = _getRangeValues3.color,
            seriesName = _getRangeValues3.seriesName,
            ylabel = _getRangeValues3.ylabel,
            start = _getRangeValues3.start,
            end = _getRangeValues3.end;
          return buildRangeTooltipHTML(_objectSpread2(_objectSpread2({}, opts), {}, {
            color: color,
            seriesName: seriesName,
            ylabel: ylabel,
            start: start,
            end: end
          }));
        };
        return {
          stroke: {
            curve: 'straight',
            width: 0
          },
          fill: {
            type: 'solid',
            opacity: 0.6
          },
          markers: {
            size: 0
          },
          states: {
            hover: {
              filter: {
                type: 'none'
              }
            },
            active: {
              filter: {
                type: 'none'
              }
            }
          },
          tooltip: {
            intersect: false,
            shared: true,
            followCursor: true,
            custom: function custom(opts) {
              return handleRangeAreaTooltip(opts);
            }
          }
        };
      }
    }, {
      key: "brush",
      value: function brush(defaults) {
        var ret = {
          chart: {
            toolbar: {
              autoSelected: 'selection',
              show: false
            },
            zoom: {
              enabled: false
            }
          },
          dataLabels: {
            enabled: false
          },
          stroke: {
            width: 1
          },
          tooltip: {
            enabled: false
          },
          xaxis: {
            tooltip: {
              enabled: false
            }
          }
        };
        return Utils$1.extend(defaults, ret);
      }
    }, {
      key: "stacked100",
      value: function stacked100(opts) {
        opts.dataLabels = opts.dataLabels || {};
        opts.dataLabels.formatter = opts.dataLabels.formatter || undefined;
        var existingDataLabelFormatter = opts.dataLabels.formatter;
        opts.yaxis.forEach(function (yaxe, index) {
          opts.yaxis[index].min = 0;
          opts.yaxis[index].max = 100;
        });
        var isBar = opts.chart.type === 'bar';
        if (isBar) {
          opts.dataLabels.formatter = existingDataLabelFormatter || function (val) {
            if (typeof val === 'number') {
              return val ? val.toFixed(0) + '%' : val;
            }
            return val;
          };
        }
        return opts;
      }
    }, {
      key: "stackedBars",
      value: function stackedBars() {
        var barDefaults = this.bar();
        return _objectSpread2(_objectSpread2({}, barDefaults), {}, {
          plotOptions: _objectSpread2(_objectSpread2({}, barDefaults.plotOptions), {}, {
            bar: _objectSpread2(_objectSpread2({}, barDefaults.plotOptions.bar), {}, {
              borderRadiusApplication: 'end',
              borderRadiusWhenStacked: 'last'
            })
          })
        });
      }

      // This function removes the left and right spacing in chart for line/area/scatter if xaxis type = category for those charts by converting xaxis = numeric. Numeric/Datetime xaxis prevents the unnecessary spacing in the left/right of the chart area
    }, {
      key: "convertCatToNumeric",
      value: function convertCatToNumeric(opts) {
        opts.xaxis.convertedCatToNumeric = true;
        return opts;
      }
    }, {
      key: "convertCatToNumericXaxis",
      value: function convertCatToNumericXaxis(opts, ctx, cats) {
        opts.xaxis.type = 'numeric';
        opts.xaxis.labels = opts.xaxis.labels || {};
        opts.xaxis.labels.formatter = opts.xaxis.labels.formatter || function (val) {
          return Utils$1.isNumber(val) ? Math.floor(val) : val;
        };
        var defaultFormatter = opts.xaxis.labels.formatter;
        var labels = opts.xaxis.categories && opts.xaxis.categories.length ? opts.xaxis.categories : opts.labels;
        if (cats && cats.length) {
          labels = cats.map(function (c) {
            return Array.isArray(c) ? c : String(c);
          });
        }
        if (labels && labels.length) {
          opts.xaxis.labels.formatter = function (val) {
            return Utils$1.isNumber(val) ? defaultFormatter(labels[Math.floor(val) - 1]) : defaultFormatter(val);
          };
        }
        opts.xaxis.categories = [];
        opts.labels = [];
        opts.xaxis.tickAmount = opts.xaxis.tickAmount || 'dataPoints';
        return opts;
      }
    }, {
      key: "bubble",
      value: function bubble() {
        return {
          dataLabels: {
            style: {
              colors: ['#fff']
            }
          },
          tooltip: {
            shared: false,
            intersect: true
          },
          xaxis: {
            crosshairs: {
              width: 0
            }
          },
          fill: {
            type: 'solid',
            gradient: {
              shade: 'light',
              inverse: true,
              shadeIntensity: 0.55,
              opacityFrom: 0.4,
              opacityTo: 0.8
            }
          }
        };
      }
    }, {
      key: "scatter",
      value: function scatter() {
        return {
          dataLabels: {
            enabled: false
          },
          tooltip: {
            shared: false,
            intersect: true
          },
          markers: {
            size: 6,
            strokeWidth: 1,
            hover: {
              sizeOffset: 2
            }
          }
        };
      }
    }, {
      key: "heatmap",
      value: function heatmap() {
        return {
          chart: {
            stacked: false
          },
          fill: {
            opacity: 1
          },
          dataLabels: {
            style: {
              colors: ['#fff']
            }
          },
          stroke: {
            colors: ['#fff']
          },
          tooltip: {
            followCursor: true,
            marker: {
              show: false
            },
            x: {
              show: false
            }
          },
          legend: {
            position: 'top',
            markers: {
              shape: 'square'
            }
          },
          grid: {
            padding: {
              right: 20
            }
          }
        };
      }
    }, {
      key: "treemap",
      value: function treemap() {
        return {
          chart: {
            zoom: {
              enabled: false
            }
          },
          dataLabels: {
            style: {
              fontSize: 14,
              fontWeight: 600,
              colors: ['#fff']
            }
          },
          stroke: {
            show: true,
            width: 2,
            colors: ['#fff']
          },
          legend: {
            show: false
          },
          fill: {
            opacity: 1,
            gradient: {
              stops: [0, 100]
            }
          },
          tooltip: {
            followCursor: true,
            x: {
              show: false
            }
          },
          grid: {
            padding: {
              left: 0,
              right: 0
            }
          },
          xaxis: {
            crosshairs: {
              show: false
            },
            tooltip: {
              enabled: false
            }
          }
        };
      }
    }, {
      key: "pie",
      value: function pie() {
        return {
          chart: {
            toolbar: {
              show: false
            }
          },
          plotOptions: {
            pie: {
              donut: {
                labels: {
                  show: false
                }
              }
            }
          },
          dataLabels: {
            formatter: function formatter(val) {
              return val.toFixed(1) + '%';
            },
            style: {
              colors: ['#fff']
            },
            background: {
              enabled: false
            },
            dropShadow: {
              enabled: true
            }
          },
          stroke: {
            colors: ['#fff']
          },
          fill: {
            opacity: 1,
            gradient: {
              shade: 'light',
              stops: [0, 100]
            }
          },
          tooltip: {
            theme: 'dark',
            fillSeriesColor: true
          },
          legend: {
            position: 'right'
          },
          grid: {
            padding: {
              left: 0,
              right: 0,
              top: 0,
              bottom: 0
            }
          }
        };
      }
    }, {
      key: "donut",
      value: function donut() {
        return {
          chart: {
            toolbar: {
              show: false
            }
          },
          dataLabels: {
            formatter: function formatter(val) {
              return val.toFixed(1) + '%';
            },
            style: {
              colors: ['#fff']
            },
            background: {
              enabled: false
            },
            dropShadow: {
              enabled: true
            }
          },
          stroke: {
            colors: ['#fff']
          },
          fill: {
            opacity: 1,
            gradient: {
              shade: 'light',
              shadeIntensity: 0.35,
              stops: [80, 100],
              opacityFrom: 1,
              opacityTo: 1
            }
          },
          tooltip: {
            theme: 'dark',
            fillSeriesColor: true
          },
          legend: {
            position: 'right'
          },
          grid: {
            padding: {
              left: 0,
              right: 0,
              top: 0,
              bottom: 0
            }
          }
        };
      }
    }, {
      key: "polarArea",
      value: function polarArea() {
        return {
          chart: {
            toolbar: {
              show: false
            }
          },
          dataLabels: {
            formatter: function formatter(val) {
              return val.toFixed(1) + '%';
            },
            enabled: false
          },
          stroke: {
            show: true,
            width: 2
          },
          fill: {
            opacity: 0.7
          },
          tooltip: {
            theme: 'dark',
            fillSeriesColor: true
          },
          legend: {
            position: 'right'
          },
          grid: {
            padding: {
              left: 0,
              right: 0,
              top: 0,
              bottom: 0
            }
          }
        };
      }
    }, {
      key: "radar",
      value: function radar() {
        this.opts.yaxis[0].labels.offsetY = this.opts.yaxis[0].labels.offsetY ? this.opts.yaxis[0].labels.offsetY : 6;
        return {
          dataLabels: {
            enabled: false,
            style: {
              fontSize: '11px'
            }
          },
          stroke: {
            width: 2
          },
          markers: {
            size: 5,
            strokeWidth: 1,
            strokeOpacity: 1
          },
          fill: {
            opacity: 0.2
          },
          tooltip: {
            shared: false,
            intersect: true,
            followCursor: true
          },
          grid: {
            show: false,
            padding: {
              left: 0,
              right: 0,
              top: 0,
              bottom: 0
            }
          },
          xaxis: {
            labels: {
              formatter: function formatter(val) {
                return val;
              },
              style: {
                colors: ['#a8a8a8'],
                fontSize: '11px'
              }
            },
            tooltip: {
              enabled: false
            },
            crosshairs: {
              show: false
            }
          }
        };
      }
    }, {
      key: "radialBar",
      value: function radialBar() {
        return {
          chart: {
            animations: {
              dynamicAnimation: {
                enabled: true,
                speed: 800
              }
            },
            toolbar: {
              show: false
            }
          },
          fill: {
            gradient: {
              shade: 'dark',
              shadeIntensity: 0.4,
              inverseColors: false,
              type: 'diagonal2',
              opacityFrom: 1,
              opacityTo: 1,
              stops: [70, 98, 100]
            }
          },
          legend: {
            show: false,
            position: 'right'
          },
          tooltip: {
            enabled: false,
            fillSeriesColor: true
          },
          grid: {
            padding: {
              left: 0,
              right: 0,
              top: 0,
              bottom: 0
            }
          }
        };
      }
    }, {
      key: "_getBoxTooltip",
      value: function _getBoxTooltip(w, seriesIndex, dataPointIndex, labels, chartType) {
        var o = w.globals.seriesCandleO[seriesIndex][dataPointIndex];
        var h = w.globals.seriesCandleH[seriesIndex][dataPointIndex];
        var m = w.globals.seriesCandleM[seriesIndex][dataPointIndex];
        var l = w.globals.seriesCandleL[seriesIndex][dataPointIndex];
        var c = w.globals.seriesCandleC[seriesIndex][dataPointIndex];
        if (w.config.series[seriesIndex].type && w.config.series[seriesIndex].type !== chartType) {
          return "<div class=\"apexcharts-custom-tooltip\">\n          ".concat(w.config.series[seriesIndex].name ? w.config.series[seriesIndex].name : 'series-' + (seriesIndex + 1), ": <strong>").concat(w.globals.series[seriesIndex][dataPointIndex], "</strong>\n        </div>");
        } else {
          return "<div class=\"apexcharts-tooltip-box apexcharts-tooltip-".concat(w.config.chart.type, "\">") + "<div>".concat(labels[0], ": <span class=\"value\">") + o + '</span></div>' + "<div>".concat(labels[1], ": <span class=\"value\">") + h + '</span></div>' + (m ? "<div>".concat(labels[2], ": <span class=\"value\">") + m + '</span></div>' : '') + "<div>".concat(labels[3], ": <span class=\"value\">") + l + '</span></div>' + "<div>".concat(labels[4], ": <span class=\"value\">") + c + '</span></div>' + '</div>';
        }
      }
    }]);
    return Defaults;
  }();

  /**
   * ApexCharts Config Class for extending user options with pre-defined ApexCharts config.
   *
   * @module Config
   **/
  var Config = /*#__PURE__*/function () {
    function Config(opts) {
      _classCallCheck(this, Config);
      this.opts = opts;
    }
    _createClass(Config, [{
      key: "init",
      value: function init(_ref) {
        var responsiveOverride = _ref.responsiveOverride;
        var opts = this.opts;
        var options = new Options();
        var defaults = new Defaults(opts);
        this.chartType = opts.chart.type;
        opts = this.extendYAxis(opts);
        opts = this.extendAnnotations(opts);
        var config = options.init();
        var newDefaults = {};
        if (opts && _typeof(opts) === 'object') {
          var _opts$plotOptions, _opts$plotOptions$bar, _opts$chart$brush, _opts$plotOptions2, _opts$plotOptions2$li, _opts$plotOptions3, _opts$plotOptions3$ba, _opts$chart$sparkline, _window$Apex$chart, _window$Apex$chart$sp;
          var chartDefaults = {};
          var chartTypes = ['line', 'area', 'bar', 'candlestick', 'boxPlot', 'rangeBar', 'rangeArea', 'bubble', 'scatter', 'heatmap', 'treemap', 'pie', 'polarArea', 'donut', 'radar', 'radialBar'];
          if (chartTypes.indexOf(opts.chart.type) !== -1) {
            chartDefaults = defaults[opts.chart.type]();
          } else {
            chartDefaults = defaults.line();
          }
          if ((_opts$plotOptions = opts.plotOptions) !== null && _opts$plotOptions !== void 0 && (_opts$plotOptions$bar = _opts$plotOptions.bar) !== null && _opts$plotOptions$bar !== void 0 && _opts$plotOptions$bar.isFunnel) {
            chartDefaults = defaults.funnel();
          }
          if (opts.chart.stacked && opts.chart.type === 'bar') {
            chartDefaults = defaults.stackedBars();
          }
          if ((_opts$chart$brush = opts.chart.brush) !== null && _opts$chart$brush !== void 0 && _opts$chart$brush.enabled) {
            chartDefaults = defaults.brush(chartDefaults);
          }
          if ((_opts$plotOptions2 = opts.plotOptions) !== null && _opts$plotOptions2 !== void 0 && (_opts$plotOptions2$li = _opts$plotOptions2.line) !== null && _opts$plotOptions2$li !== void 0 && _opts$plotOptions2$li.isSlopeChart) {
            chartDefaults = defaults.slope();
          }
          if (opts.chart.stacked && opts.chart.stackType === '100%') {
            opts = defaults.stacked100(opts);
          }
          if ((_opts$plotOptions3 = opts.plotOptions) !== null && _opts$plotOptions3 !== void 0 && (_opts$plotOptions3$ba = _opts$plotOptions3.bar) !== null && _opts$plotOptions3$ba !== void 0 && _opts$plotOptions3$ba.isDumbbell) {
            opts = defaults.dumbbell(opts);
          }

          // If user has specified a dark theme, make the tooltip dark too
          this.checkForDarkTheme(window.Apex); // check global window Apex options
          this.checkForDarkTheme(opts); // check locally passed options

          opts.xaxis = opts.xaxis || window.Apex.xaxis || {};

          // an important boolean needs to be set here
          // otherwise all the charts will have this flag set to true window.Apex.xaxis is set globally
          if (!responsiveOverride) {
            opts.xaxis.convertedCatToNumeric = false;
          }
          opts = this.checkForCatToNumericXAxis(this.chartType, chartDefaults, opts);
          if ((_opts$chart$sparkline = opts.chart.sparkline) !== null && _opts$chart$sparkline !== void 0 && _opts$chart$sparkline.enabled || (_window$Apex$chart = window.Apex.chart) !== null && _window$Apex$chart !== void 0 && (_window$Apex$chart$sp = _window$Apex$chart.sparkline) !== null && _window$Apex$chart$sp !== void 0 && _window$Apex$chart$sp.enabled) {
            chartDefaults = defaults.sparkline(chartDefaults);
          }
          newDefaults = Utils$1.extend(config, chartDefaults);
        }

        // config should cascade in this fashion
        // default-config < global-apex-variable-config < user-defined-config

        // get GLOBALLY defined options and merge with the default config
        var mergedWithDefaultConfig = Utils$1.extend(newDefaults, window.Apex);

        // get the merged config and extend with user defined config
        config = Utils$1.extend(mergedWithDefaultConfig, opts);

        // some features are not supported. those mismatches should be handled
        config = this.handleUserInputErrors(config);
        return config;
      }
    }, {
      key: "checkForCatToNumericXAxis",
      value: function checkForCatToNumericXAxis(chartType, chartDefaults, opts) {
        var _opts$plotOptions4, _opts$plotOptions4$ba;
        var defaults = new Defaults(opts);
        var isBarHorizontal = (chartType === 'bar' || chartType === 'boxPlot') && ((_opts$plotOptions4 = opts.plotOptions) === null || _opts$plotOptions4 === void 0 ? void 0 : (_opts$plotOptions4$ba = _opts$plotOptions4.bar) === null || _opts$plotOptions4$ba === void 0 ? void 0 : _opts$plotOptions4$ba.horizontal);
        var unsupportedZoom = chartType === 'pie' || chartType === 'polarArea' || chartType === 'donut' || chartType === 'radar' || chartType === 'radialBar' || chartType === 'heatmap';
        var notNumericXAxis = opts.xaxis.type !== 'datetime' && opts.xaxis.type !== 'numeric';
        var tickPlacement = opts.xaxis.tickPlacement ? opts.xaxis.tickPlacement : chartDefaults.xaxis && chartDefaults.xaxis.tickPlacement;
        if (!isBarHorizontal && !unsupportedZoom && notNumericXAxis && tickPlacement !== 'between') {
          opts = defaults.convertCatToNumeric(opts);
        }
        return opts;
      }
    }, {
      key: "extendYAxis",
      value: function extendYAxis(opts, w) {
        var options = new Options();
        if (typeof opts.yaxis === 'undefined' || !opts.yaxis || Array.isArray(opts.yaxis) && opts.yaxis.length === 0) {
          opts.yaxis = {};
        }

        // extend global yaxis config (only if object is provided / not an array)
        if (opts.yaxis.constructor !== Array && window.Apex.yaxis && window.Apex.yaxis.constructor !== Array) {
          opts.yaxis = Utils$1.extend(opts.yaxis, window.Apex.yaxis);
        }

        // as we can't extend nested object's array with extend, we need to do it first
        // user can provide either an array or object in yaxis config
        if (opts.yaxis.constructor !== Array) {
          // convert the yaxis to array if user supplied object
          opts.yaxis = [Utils$1.extend(options.yAxis, opts.yaxis)];
        } else {
          opts.yaxis = Utils$1.extendArray(opts.yaxis, options.yAxis);
        }
        var isLogY = false;
        opts.yaxis.forEach(function (y) {
          if (y.logarithmic) {
            isLogY = true;
          }
        });
        var series = opts.series;
        if (w && !series) {
          series = w.config.series;
        }

        // A logarithmic chart works correctly when each series has a corresponding y-axis
        // If this is not the case, we manually create yaxis for multi-series log chart
        if (isLogY && series.length !== opts.yaxis.length && series.length) {
          opts.yaxis = series.map(function (s, i) {
            if (!s.name) {
              series[i].name = "series-".concat(i + 1);
            }
            if (opts.yaxis[i]) {
              opts.yaxis[i].seriesName = series[i].name;
              return opts.yaxis[i];
            } else {
              var newYaxis = Utils$1.extend(options.yAxis, opts.yaxis[0]);
              newYaxis.show = false;
              return newYaxis;
            }
          });
        }
        if (isLogY && series.length > 1 && series.length !== opts.yaxis.length) {
          console.warn('A multi-series logarithmic chart should have equal number of series and y-axes');
        }
        return opts;
      }

      // annotations also accepts array, so we need to extend them manually
    }, {
      key: "extendAnnotations",
      value: function extendAnnotations(opts) {
        if (typeof opts.annotations === 'undefined') {
          opts.annotations = {};
          opts.annotations.yaxis = [];
          opts.annotations.xaxis = [];
          opts.annotations.points = [];
        }
        opts = this.extendYAxisAnnotations(opts);
        opts = this.extendXAxisAnnotations(opts);
        opts = this.extendPointAnnotations(opts);
        return opts;
      }
    }, {
      key: "extendYAxisAnnotations",
      value: function extendYAxisAnnotations(opts) {
        var options = new Options();
        opts.annotations.yaxis = Utils$1.extendArray(typeof opts.annotations.yaxis !== 'undefined' ? opts.annotations.yaxis : [], options.yAxisAnnotation);
        return opts;
      }
    }, {
      key: "extendXAxisAnnotations",
      value: function extendXAxisAnnotations(opts) {
        var options = new Options();
        opts.annotations.xaxis = Utils$1.extendArray(typeof opts.annotations.xaxis !== 'undefined' ? opts.annotations.xaxis : [], options.xAxisAnnotation);
        return opts;
      }
    }, {
      key: "extendPointAnnotations",
      value: function extendPointAnnotations(opts) {
        var options = new Options();
        opts.annotations.points = Utils$1.extendArray(typeof opts.annotations.points !== 'undefined' ? opts.annotations.points : [], options.pointAnnotation);
        return opts;
      }
    }, {
      key: "checkForDarkTheme",
      value: function checkForDarkTheme(opts) {
        if (opts.theme && opts.theme.mode === 'dark') {
          if (!opts.tooltip) {
            opts.tooltip = {};
          }
          if (opts.tooltip.theme !== 'light') {
            opts.tooltip.theme = 'dark';
          }
          if (!opts.chart.foreColor) {
            opts.chart.foreColor = '#f6f7f8';
          }
          if (!opts.theme.palette) {
            opts.theme.palette = 'palette4';
          }
        }
      }
    }, {
      key: "handleUserInputErrors",
      value: function handleUserInputErrors(opts) {
        var config = opts;
        // conflicting tooltip option. intersect makes sure to focus on 1 point at a time. Shared cannot be used along with it
        if (config.tooltip.shared && config.tooltip.intersect) {
          throw new Error('tooltip.shared cannot be enabled when tooltip.intersect is true. Turn off any other option by setting it to false.');
        }
        if (config.chart.type === 'bar' && config.plotOptions.bar.horizontal) {
          // No multiple yaxis for bars
          if (config.yaxis.length > 1) {
            throw new Error('Multiple Y Axis for bars are not supported. Switch to column chart by setting plotOptions.bar.horizontal=false');
          }

          // if yaxis is reversed in horizontal bar chart, you should draw the y-axis on right side
          if (config.yaxis[0].reversed) {
            config.yaxis[0].opposite = true;
          }
          config.xaxis.tooltip.enabled = false; // no xaxis tooltip for horizontal bar
          config.yaxis[0].tooltip.enabled = false; // no xaxis tooltip for horizontal bar
          config.chart.zoom.enabled = false; // no zooming for horz bars
        }
        if (config.chart.type === 'bar' || config.chart.type === 'rangeBar') {
          if (config.tooltip.shared) {
            if (config.xaxis.crosshairs.width === 'barWidth' && config.series.length > 1) {
              config.xaxis.crosshairs.width = 'tickWidth';
            }
          }
        }
        if (config.chart.type === 'candlestick' || config.chart.type === 'boxPlot') {
          if (config.yaxis[0].reversed) {
            console.warn("Reversed y-axis in ".concat(config.chart.type, " chart is not supported."));
            config.yaxis[0].reversed = false;
          }
        }
        return config;
      }
    }]);
    return Config;
  }();

  var Globals = /*#__PURE__*/function () {
    function Globals() {
      _classCallCheck(this, Globals);
    }
    _createClass(Globals, [{
      key: "initGlobalVars",
      value: function initGlobalVars(gl) {
        gl.series = []; // the MAIN series array (y values)
        gl.seriesCandleO = [];
        gl.seriesCandleH = [];
        gl.seriesCandleM = [];
        gl.seriesCandleL = [];
        gl.seriesCandleC = [];
        gl.seriesRangeStart = [];
        gl.seriesRangeEnd = [];
        gl.seriesRange = [];
        gl.seriesPercent = [];
        gl.seriesGoals = [];
        gl.seriesX = [];
        gl.seriesZ = [];
        gl.seriesNames = [];
        gl.seriesTotals = [];
        gl.seriesLog = [];
        gl.seriesColors = [];
        gl.stackedSeriesTotals = [];
        gl.seriesXvalues = []; // we will need this in tooltip (it's x position) when we will have unequal x values, we will need some way to get x value depending on mouse pointer
        gl.seriesYvalues = []; // we will need this when deciding which series user hovered on
        gl.dataWasParsed = false;
        gl.originalSeries = null;
        gl.labels = [];
        gl.hasXaxisGroups = false;
        gl.groups = [];
        gl.barGroups = [];
        gl.lineGroups = [];
        gl.areaGroups = [];
        gl.hasSeriesGroups = false;
        gl.seriesGroups = [];
        gl.categoryLabels = [];
        gl.timescaleLabels = [];
        gl.noLabelsProvided = false;
        gl.resizeTimer = null;
        gl.selectionResizeTimer = null;
        gl.lastWheelExecution = 0;
        gl.delayedElements = [];
        gl.pointsArray = [];
        gl.dataLabelsRects = [];
        gl.isXNumeric = false;
        gl.skipLastTimelinelabel = false;
        gl.skipFirstTimelinelabel = false;
        gl.isDataXYZ = false;
        gl.isMultiLineX = false;
        gl.isMultipleYAxis = false;
        gl.maxY = -Number.MAX_VALUE;
        gl.minY = Number.MIN_VALUE;
        gl.minYArr = [];
        gl.maxYArr = [];
        gl.maxX = -Number.MAX_VALUE;
        gl.minX = Number.MAX_VALUE;
        gl.initialMaxX = -Number.MAX_VALUE;
        gl.initialMinX = Number.MAX_VALUE;
        gl.maxDate = 0;
        gl.minDate = Number.MAX_VALUE;
        gl.minZ = Number.MAX_VALUE;
        gl.maxZ = -Number.MAX_VALUE;
        gl.minXDiff = Number.MAX_VALUE;
        gl.yAxisScale = [];
        gl.xAxisScale = null;
        gl.xAxisTicksPositions = [];
        gl.yLabelsCoords = [];
        gl.yTitleCoords = [];
        gl.barPadForNumericAxis = 0;
        gl.padHorizontal = 0;
        gl.xRange = 0;
        gl.yRange = [];
        gl.zRange = 0;
        gl.dataPoints = 0;
        gl.xTickAmount = 0;
        gl.multiAxisTickAmount = 0;
      }
    }, {
      key: "globalVars",
      value: function globalVars(config) {
        return {
          chartID: null,
          // chart ID - apexcharts-cuid
          cuid: null,
          // chart ID - random numbers excluding "apexcharts" part
          events: {
            beforeMount: [],
            mounted: [],
            updated: [],
            clicked: [],
            selection: [],
            dataPointSelection: [],
            zoomed: [],
            scrolled: []
          },
          colors: [],
          clientX: null,
          clientY: null,
          fill: {
            colors: []
          },
          stroke: {
            colors: []
          },
          dataLabels: {
            style: {
              colors: []
            }
          },
          radarPolygons: {
            fill: {
              colors: []
            }
          },
          markers: {
            colors: [],
            size: config.markers.size,
            largestSize: 0
          },
          animationEnded: false,
          isTouchDevice: 'ontouchstart' in window || navigator.msMaxTouchPoints,
          isDirty: false,
          // chart has been updated after the initial render. This is different than dataChanged property. isDirty means user manually called some method to update
          isExecCalled: false,
          // whether user updated the chart through the exec method
          initialConfig: null,
          // we will store the first config user has set to go back when user finishes interactions like zooming and come out of it
          initialSeries: [],
          lastXAxis: [],
          lastYAxis: [],
          columnSeries: null,
          labels: [],
          // store the text to draw on x axis
          // Don't mutate the labels, many things including tooltips depends on it!
          timescaleLabels: [],
          // store the timescaleLabels Labels in another variable
          noLabelsProvided: false,
          // if user didn't provide any categories/labels or x values, fallback to 1,2,3,4...
          allSeriesCollapsed: false,
          collapsedSeries: [],
          // when user collapses a series, it goes into this array
          collapsedSeriesIndices: [],
          // this stores the index of the collapsedSeries instead of whole object for quick access
          ancillaryCollapsedSeries: [],
          // when user collapses an "alwaysVisible" series, it goes into this array
          ancillaryCollapsedSeriesIndices: [],
          // this stores the index of the ancillaryCollapsedSeries whose y-axis is always visible
          risingSeries: [],
          // when user re-opens a collapsed series, it goes here
          dataFormatXNumeric: false,
          // boolean value to indicate user has passed numeric x values
          capturedSeriesIndex: -1,
          capturedDataPointIndex: -1,
          selectedDataPoints: [],
          invalidLogScale: false,
          // if a user enabled log scale but the data provided is not valid to generate a log scale, turn on this flag
          ignoreYAxisIndexes: [],
          // when series are being collapsed in multiple y axes, ignore certain index
          maxValsInArrayIndex: 0,
          radialSize: 0,
          selection: undefined,
          zoomEnabled: config.chart.toolbar.autoSelected === 'zoom' && config.chart.toolbar.tools.zoom && config.chart.zoom.enabled,
          panEnabled: config.chart.toolbar.autoSelected === 'pan' && config.chart.toolbar.tools.pan,
          selectionEnabled: config.chart.toolbar.autoSelected === 'selection' && config.chart.toolbar.tools.selection,
          yaxis: null,
          mousedown: false,
          lastClientPosition: {},
          // don't reset this variable this the chart is destroyed. It is used to detect right or left mousemove in panning
          visibleXRange: undefined,
          yValueDecimal: 0,
          // are there floating numbers in the series. If yes, this represent the len of the decimals
          total: 0,
          SVGNS: 'http://www.w3.org/2000/svg',
          // svg namespace
          svgWidth: 0,
          // the whole svg width
          svgHeight: 0,
          // the whole svg height
          noData: false,
          // whether there is any data to display or not
          locale: {},
          // the current locale values will be preserved here for global access
          dom: {},
          // for storing all dom nodes in this particular property
          memory: {
            methodsToExec: []
          },
          shouldAnimate: true,
          skipLastTimelinelabel: false,
          // when last label is cropped, skip drawing it
          skipFirstTimelinelabel: false,
          // when first label is cropped, skip drawing it
          delayedElements: [],
          // element which appear after animation has finished
          axisCharts: true,
          // chart type = line or area or bar
          // (refer them also as plot charts in the code)
          isDataXYZ: false,
          // bool: data was provided in a {[x,y,z]} pattern
          isSlopeChart: config.plotOptions.line.isSlopeChart,
          resized: false,
          // bool: user has resized
          resizeTimer: null,
          // timeout function to make a small delay before
          // drawing when user resized
          comboCharts: false,
          // bool: whether it's a combination of line/column
          dataChanged: false,
          // bool: has data changed dynamically
          previousPaths: [],
          // array: when data is changed, it will animate from
          // previous paths
          allSeriesHasEqualX: true,
          pointsArray: [],
          // store the points positions here to draw later on hover
          // format is - [[x,y],[x,y]... [x,y]]
          dataLabelsRects: [],
          // store the positions of datalabels to prevent collision
          lastDrawnDataLabelsIndexes: [],
          hasNullValues: false,
          // bool: whether series contains null values
          zoomed: false,
          // whether user has zoomed or not
          gridWidth: 0,
          // drawable width of actual graphs (series paths)
          gridHeight: 0,
          // drawable height of actual graphs (series paths)
          rotateXLabels: false,
          defaultLabels: false,
          xLabelFormatter: undefined,
          // formatter for x axis labels
          yLabelFormatters: [],
          xaxisTooltipFormatter: undefined,
          // formatter for x axis tooltip
          ttKeyFormatter: undefined,
          ttVal: undefined,
          ttZFormatter: undefined,
          LINE_HEIGHT_RATIO: 1.618,
          xAxisLabelsHeight: 0,
          xAxisGroupLabelsHeight: 0,
          xAxisLabelsWidth: 0,
          yAxisLabelsWidth: 0,
          scaleX: 1,
          scaleY: 1,
          translateX: 0,
          translateY: 0,
          translateYAxisX: [],
          yAxisWidths: [],
          translateXAxisY: 0,
          translateXAxisX: 0,
          tooltip: null,
          // Rules for niceScaleAllowedMagMsd:
          // 1) An array of two arrays only ([[],[]]):
          //    * array[0][]: influences labelling of data series that contain only integers
          //       - must contain only integers (or expect ugly ticks)
          //    * array[1][]: influences labelling of data series that contain at least one float
          //       - may contain floats
          //    * both arrays:
          //       - each array[][i] ideally satisfy: 10 mod array[][i] == 0 (or expect ugly ticks)
          //       - to avoid clipping data point keep each array[][i] >= i
          // 2) each array[i][] contains 11 values, for all possible index values 0..10.
          //    array[][0] should not be needed (not proven) but ensures non-zero is returned.
          //
          // Users can effectively force their preferred "magMsd" through stepSize and
          // forceNiceScale. With forceNiceScale: true, stepSize becomes normalizable to the
          // axis's min..max range, which allows users to set stepSize to an integer 1..10, for
          // example, stepSize: 3. This value will be preferred to the value determined through
          // this array. The range-normalized value is checked for consistency with other
          // user defined options and will be ignored if inconsistent.
          niceScaleAllowedMagMsd: [[1, 1, 2, 5, 5, 5, 10, 10, 10, 10, 10], [1, 1, 2, 5, 5, 5, 10, 10, 10, 10, 10]],
          // Default ticks based on SVG size. These values have high numbers
          // of divisors. The array is indexed using a calculated maxTicks value
          // divided by 2 simply to halve the array size. See Scales.niceScale().
          niceScaleDefaultTicks: [1, 2, 4, 4, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 12, 12, 12, 12, 12, 12, 12, 12, 12, 24],
          seriesYAxisMap: [],
          // Given yAxis index, return all series indices belonging to it. Multiple series can be referenced to each yAxis.
          seriesYAxisReverseMap: [] // Given a Series index, return its yAxis index.
        };
      }
    }, {
      key: "init",
      value: function init(config) {
        var globals = this.globalVars(config);
        this.initGlobalVars(globals);
        globals.initialConfig = Utils$1.extend({}, config);
        globals.initialSeries = Utils$1.clone(config.series);
        globals.lastXAxis = Utils$1.clone(globals.initialConfig.xaxis);
        globals.lastYAxis = Utils$1.clone(globals.initialConfig.yaxis);
        return globals;
      }
    }]);
    return Globals;
  }();

  /**
   * ApexCharts Base Class for extending user options with pre-defined ApexCharts config.
   *
   * @module Base
   **/
  var Base = /*#__PURE__*/function () {
    function Base(opts) {
      _classCallCheck(this, Base);
      this.opts = opts;
    }
    _createClass(Base, [{
      key: "init",
      value: function init() {
        var config = new Config(this.opts).init({
          responsiveOverride: false
        });
        var globals = new Globals().init(config);
        var w = {
          config: config,
          globals: globals
        };
        return w;
      }
    }]);
    return Base;
  }();

  /**
   * ApexCharts Fill Class for setting fill options of the paths.
   *
   * @module Fill
   **/
  var Fill = /*#__PURE__*/function () {
    function Fill(ctx) {
      _classCallCheck(this, Fill);
      this.ctx = ctx;
      this.w = ctx.w;
      this.opts = null;
      this.seriesIndex = 0;
      this.patternIDs = [];
    }
    _createClass(Fill, [{
      key: "clippedImgArea",
      value: function clippedImgArea(params) {
        var w = this.w;
        var cnf = w.config;
        var svgW = parseInt(w.globals.gridWidth, 10);
        var svgH = parseInt(w.globals.gridHeight, 10);
        var size = svgW > svgH ? svgW : svgH;
        var fillImg = params.image;
        var imgWidth = 0;
        var imgHeight = 0;
        if (typeof params.width === 'undefined' && typeof params.height === 'undefined') {
          if (cnf.fill.image.width !== undefined && cnf.fill.image.height !== undefined) {
            imgWidth = cnf.fill.image.width + 1;
            imgHeight = cnf.fill.image.height;
          } else {
            imgWidth = size + 1;
            imgHeight = size;
          }
        } else {
          imgWidth = params.width;
          imgHeight = params.height;
        }
        var elPattern = document.createElementNS(w.globals.SVGNS, 'pattern');
        Graphics.setAttrs(elPattern, {
          id: params.patternID,
          patternUnits: params.patternUnits ? params.patternUnits : 'userSpaceOnUse',
          width: imgWidth + 'px',
          height: imgHeight + 'px'
        });
        var elImage = document.createElementNS(w.globals.SVGNS, 'image');
        elPattern.appendChild(elImage);
        elImage.setAttributeNS(window.SVG.xlink, 'href', fillImg);
        Graphics.setAttrs(elImage, {
          x: 0,
          y: 0,
          preserveAspectRatio: 'none',
          width: imgWidth + 'px',
          height: imgHeight + 'px'
        });
        elImage.style.opacity = params.opacity;
        w.globals.dom.elDefs.node.appendChild(elPattern);
      }
    }, {
      key: "getSeriesIndex",
      value: function getSeriesIndex(opts) {
        var w = this.w;
        var cType = w.config.chart.type;
        if ((cType === 'bar' || cType === 'rangeBar') && w.config.plotOptions.bar.distributed || cType === 'heatmap' || cType === 'treemap') {
          this.seriesIndex = opts.seriesNumber;
        } else {
          this.seriesIndex = opts.seriesNumber % w.globals.series.length;
        }
        return this.seriesIndex;
      }
    }, {
      key: "computeColorStops",
      value: function computeColorStops(data, multiColorConfig) {
        var w = this.w;
        var maxPositive = null;
        var minNegative = null;
        var _iterator = _createForOfIteratorHelper(data),
          _step;
        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var value = _step.value;
            if (value >= multiColorConfig.threshold) {
              if (maxPositive === null || value > maxPositive) {
                maxPositive = value;
              }
            } else {
              if (minNegative === null || value < minNegative) {
                minNegative = value;
              }
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
        if (maxPositive === null) {
          maxPositive = multiColorConfig.threshold;
        }
        if (minNegative === null) {
          minNegative = multiColorConfig.threshold;
        }
        var totalRange = maxPositive - multiColorConfig.threshold + (multiColorConfig.threshold - minNegative);
        if (totalRange === 0) {
          totalRange = 1;
        }
        var negativePercentage = (multiColorConfig.threshold - minNegative) / totalRange * 100;
        var offset = 100 - negativePercentage;
        offset = Math.max(0, Math.min(offset, 100));
        return [{
          offset: offset,
          color: multiColorConfig.colorAboveThreshold,
          opacity: w.config.fill.opacity
        }, {
          offset: 0,
          color: multiColorConfig.colorBelowThreshold,
          opacity: w.config.fill.opacity
        }];
      }
    }, {
      key: "fillPath",
      value: function fillPath(opts) {
        var _w$config$series$this, _w$config$series$this2, _w$config$series$this3;
        var w = this.w;
        this.opts = opts;
        var cnf = this.w.config;
        var pathFill;
        var patternFill, gradientFill;
        this.seriesIndex = this.getSeriesIndex(opts);
        var drawMultiColorLine = cnf.plotOptions.line.colors.colorAboveThreshold && cnf.plotOptions.line.colors.colorBelowThreshold;
        var fillColors = this.getFillColors();
        var fillColor = fillColors[this.seriesIndex];

        //override fillcolor if user inputted color with data
        if (w.globals.seriesColors[this.seriesIndex] !== undefined) {
          fillColor = w.globals.seriesColors[this.seriesIndex];
        }
        if (typeof fillColor === 'function') {
          fillColor = fillColor({
            seriesIndex: this.seriesIndex,
            dataPointIndex: opts.dataPointIndex,
            value: opts.value,
            w: w
          });
        }
        var fillType = opts.fillType ? opts.fillType : this.getFillType(this.seriesIndex);
        var fillOpacity = Array.isArray(cnf.fill.opacity) ? cnf.fill.opacity[this.seriesIndex] : cnf.fill.opacity;

        // when line colors needs to be different based on values, we use gradient config to achieve this
        var useGradient = fillType === 'gradient' || drawMultiColorLine;
        if (opts.color) {
          fillColor = opts.color;
        }
        if ((_w$config$series$this = w.config.series[this.seriesIndex]) !== null && _w$config$series$this !== void 0 && (_w$config$series$this2 = _w$config$series$this.data) !== null && _w$config$series$this2 !== void 0 && (_w$config$series$this3 = _w$config$series$this2[opts.dataPointIndex]) !== null && _w$config$series$this3 !== void 0 && _w$config$series$this3.fillColor) {
          var _w$config$series$this4, _w$config$series$this5, _w$config$series$this6;
          fillColor = (_w$config$series$this4 = w.config.series[this.seriesIndex]) === null || _w$config$series$this4 === void 0 ? void 0 : (_w$config$series$this5 = _w$config$series$this4.data) === null || _w$config$series$this5 === void 0 ? void 0 : (_w$config$series$this6 = _w$config$series$this5[opts.dataPointIndex]) === null || _w$config$series$this6 === void 0 ? void 0 : _w$config$series$this6.fillColor;
        }

        // in case a color is undefined, fallback to white color to prevent runtime error
        if (!fillColor) {
          fillColor = '#fff';
          console.warn('undefined color - ApexCharts');
        }
        var defaultColor = fillColor;
        if (fillColor.indexOf('rgb') === -1) {
          if (fillColor.indexOf('#') === -1) {
            defaultColor = fillColor;
          } else if (fillColor.length < 9) {
            // if the hex contains alpha and is of 9 digit, skip the opacity
            defaultColor = Utils$1.hexToRgba(fillColor, fillOpacity);
          }
        } else {
          if (fillColor.indexOf('rgba') > -1) {
            fillOpacity = Utils$1.getOpacityFromRGBA(fillColor);
          } else {
            defaultColor = Utils$1.hexToRgba(Utils$1.rgb2hex(fillColor), fillOpacity);
          }
        }
        if (opts.opacity) fillOpacity = opts.opacity;
        if (fillType === 'pattern') {
          patternFill = this.handlePatternFill({
            fillConfig: opts.fillConfig,
            patternFill: patternFill,
            fillColor: fillColor,
            fillOpacity: fillOpacity,
            defaultColor: defaultColor
          });
        }
        if (useGradient) {
          var colorStops = _toConsumableArray(cnf.fill.gradient.colorStops) || [];
          var type = cnf.fill.gradient.type;
          if (drawMultiColorLine) {
            colorStops[this.seriesIndex] = this.computeColorStops(w.globals.series[this.seriesIndex], cnf.plotOptions.line.colors);
            type = 'vertical';
          }
          gradientFill = this.handleGradientFill({
            type: type,
            fillConfig: opts.fillConfig,
            fillColor: fillColor,
            fillOpacity: fillOpacity,
            colorStops: colorStops,
            i: this.seriesIndex
          });
        }
        if (fillType === 'image') {
          var imgSrc = cnf.fill.image.src;
          var patternID = opts.patternID ? opts.patternID : '';
          var patternKey = "pattern".concat(w.globals.cuid).concat(opts.seriesNumber + 1).concat(patternID);
          if (this.patternIDs.indexOf(patternKey) === -1) {
            this.clippedImgArea({
              opacity: fillOpacity,
              image: Array.isArray(imgSrc) ? opts.seriesNumber < imgSrc.length ? imgSrc[opts.seriesNumber] : imgSrc[0] : imgSrc,
              width: opts.width ? opts.width : undefined,
              height: opts.height ? opts.height : undefined,
              patternUnits: opts.patternUnits,
              patternID: patternKey
            });
            this.patternIDs.push(patternKey);
          }
          pathFill = "url(#".concat(patternKey, ")");
        } else if (useGradient) {
          pathFill = gradientFill;
        } else if (fillType === 'pattern') {
          pathFill = patternFill;
        } else {
          pathFill = defaultColor;
        }

        // override pattern/gradient if opts.solid is true
        if (opts.solid) {
          pathFill = defaultColor;
        }
        return pathFill;
      }
    }, {
      key: "getFillType",
      value: function getFillType(seriesIndex) {
        var w = this.w;
        if (Array.isArray(w.config.fill.type)) {
          return w.config.fill.type[seriesIndex];
        } else {
          return w.config.fill.type;
        }
      }
    }, {
      key: "getFillColors",
      value: function getFillColors() {
        var w = this.w;
        var cnf = w.config;
        var opts = this.opts;
        var fillColors = [];
        if (w.globals.comboCharts) {
          if (w.config.series[this.seriesIndex].type === 'line') {
            if (Array.isArray(w.globals.stroke.colors)) {
              fillColors = w.globals.stroke.colors;
            } else {
              fillColors.push(w.globals.stroke.colors);
            }
          } else {
            if (Array.isArray(w.globals.fill.colors)) {
              fillColors = w.globals.fill.colors;
            } else {
              fillColors.push(w.globals.fill.colors);
            }
          }
        } else {
          if (cnf.chart.type === 'line') {
            if (Array.isArray(w.globals.stroke.colors)) {
              fillColors = w.globals.stroke.colors;
            } else {
              fillColors.push(w.globals.stroke.colors);
            }
          } else {
            if (Array.isArray(w.globals.fill.colors)) {
              fillColors = w.globals.fill.colors;
            } else {
              fillColors.push(w.globals.fill.colors);
            }
          }
        }

        // colors passed in arguments
        if (typeof opts.fillColors !== 'undefined') {
          fillColors = [];
          if (Array.isArray(opts.fillColors)) {
            fillColors = opts.fillColors.slice();
          } else {
            fillColors.push(opts.fillColors);
          }
        }
        return fillColors;
      }
    }, {
      key: "handlePatternFill",
      value: function handlePatternFill(_ref) {
        var fillConfig = _ref.fillConfig,
          patternFill = _ref.patternFill,
          fillColor = _ref.fillColor,
          fillOpacity = _ref.fillOpacity,
          defaultColor = _ref.defaultColor;
        var fillCnf = this.w.config.fill;
        if (fillConfig) {
          fillCnf = fillConfig;
        }
        var opts = this.opts;
        var graphics = new Graphics(this.ctx);
        var patternStrokeWidth = Array.isArray(fillCnf.pattern.strokeWidth) ? fillCnf.pattern.strokeWidth[this.seriesIndex] : fillCnf.pattern.strokeWidth;
        var patternLineColor = fillColor;
        if (Array.isArray(fillCnf.pattern.style)) {
          if (typeof fillCnf.pattern.style[opts.seriesNumber] !== 'undefined') {
            var pf = graphics.drawPattern(fillCnf.pattern.style[opts.seriesNumber], fillCnf.pattern.width, fillCnf.pattern.height, patternLineColor, patternStrokeWidth, fillOpacity);
            patternFill = pf;
          } else {
            patternFill = defaultColor;
          }
        } else {
          patternFill = graphics.drawPattern(fillCnf.pattern.style, fillCnf.pattern.width, fillCnf.pattern.height, patternLineColor, patternStrokeWidth, fillOpacity);
        }
        return patternFill;
      }
    }, {
      key: "handleGradientFill",
      value: function handleGradientFill(_ref2) {
        var type = _ref2.type,
          fillColor = _ref2.fillColor,
          fillOpacity = _ref2.fillOpacity,
          fillConfig = _ref2.fillConfig,
          colorStops = _ref2.colorStops,
          i = _ref2.i;
        var fillCnf = this.w.config.fill;
        if (fillConfig) {
          fillCnf = _objectSpread2(_objectSpread2({}, fillCnf), fillConfig);
        }
        var opts = this.opts;
        var graphics = new Graphics(this.ctx);
        var utils = new Utils$1();
        type = type || fillCnf.gradient.type;
        var gradientFrom = fillColor;
        var gradientTo;
        var opacityFrom = fillCnf.gradient.opacityFrom === undefined ? fillOpacity : Array.isArray(fillCnf.gradient.opacityFrom) ? fillCnf.gradient.opacityFrom[i] : fillCnf.gradient.opacityFrom;
        if (gradientFrom.indexOf('rgba') > -1) {
          opacityFrom = Utils$1.getOpacityFromRGBA(gradientFrom);
        }
        var opacityTo = fillCnf.gradient.opacityTo === undefined ? fillOpacity : Array.isArray(fillCnf.gradient.opacityTo) ? fillCnf.gradient.opacityTo[i] : fillCnf.gradient.opacityTo;
        if (fillCnf.gradient.gradientToColors === undefined || fillCnf.gradient.gradientToColors.length === 0) {
          if (fillCnf.gradient.shade === 'dark') {
            gradientTo = utils.shadeColor(parseFloat(fillCnf.gradient.shadeIntensity) * -1, fillColor.indexOf('rgb') > -1 ? Utils$1.rgb2hex(fillColor) : fillColor);
          } else {
            gradientTo = utils.shadeColor(parseFloat(fillCnf.gradient.shadeIntensity), fillColor.indexOf('rgb') > -1 ? Utils$1.rgb2hex(fillColor) : fillColor);
          }
        } else {
          if (fillCnf.gradient.gradientToColors[opts.seriesNumber]) {
            var gToColor = fillCnf.gradient.gradientToColors[opts.seriesNumber];
            gradientTo = gToColor;
            if (gToColor.indexOf('rgba') > -1) {
              opacityTo = Utils$1.getOpacityFromRGBA(gToColor);
            }
          } else {
            gradientTo = fillColor;
          }
        }
        if (fillCnf.gradient.gradientFrom) {
          gradientFrom = fillCnf.gradient.gradientFrom;
        }
        if (fillCnf.gradient.gradientTo) {
          gradientTo = fillCnf.gradient.gradientTo;
        }
        if (fillCnf.gradient.inverseColors) {
          var t = gradientFrom;
          gradientFrom = gradientTo;
          gradientTo = t;
        }
        if (gradientFrom.indexOf('rgb') > -1) {
          gradientFrom = Utils$1.rgb2hex(gradientFrom);
        }
        if (gradientTo.indexOf('rgb') > -1) {
          gradientTo = Utils$1.rgb2hex(gradientTo);
        }
        return graphics.drawGradient(type, gradientFrom, gradientTo, opacityFrom, opacityTo, opts.size, fillCnf.gradient.stops, colorStops, i);
      }
    }]);
    return Fill;
  }();

  /**
   * ApexCharts Markers Class for drawing markers on y values in axes charts.
   *
   * @module Markers
   **/
  var Markers = /*#__PURE__*/function () {
    function Markers(ctx, opts) {
      _classCallCheck(this, Markers);
      this.ctx = ctx;
      this.w = ctx.w;
    }
    _createClass(Markers, [{
      key: "setGlobalMarkerSize",
      value: function setGlobalMarkerSize() {
        var w = this.w;
        w.globals.markers.size = Array.isArray(w.config.markers.size) ? w.config.markers.size : [w.config.markers.size];
        if (w.globals.markers.size.length > 0) {
          if (w.globals.markers.size.length < w.globals.series.length + 1) {
            for (var i = 0; i <= w.globals.series.length; i++) {
              if (typeof w.globals.markers.size[i] === 'undefined') {
                w.globals.markers.size.push(w.globals.markers.size[0]);
              }
            }
          }
        } else {
          w.globals.markers.size = w.config.series.map(function (s) {
            return w.config.markers.size;
          });
        }
      }
    }, {
      key: "plotChartMarkers",
      value: function plotChartMarkers(_ref) {
        var pointsPos = _ref.pointsPos,
          seriesIndex = _ref.seriesIndex,
          j = _ref.j,
          pSize = _ref.pSize,
          _ref$alwaysDrawMarker = _ref.alwaysDrawMarker,
          alwaysDrawMarker = _ref$alwaysDrawMarker === void 0 ? false : _ref$alwaysDrawMarker,
          _ref$isVirtualPoint = _ref.isVirtualPoint,
          isVirtualPoint = _ref$isVirtualPoint === void 0 ? false : _ref$isVirtualPoint;
        var w = this.w;
        var i = seriesIndex;
        var p = pointsPos;
        var elMarkersWrap = null;
        var graphics = new Graphics(this.ctx);
        var hasDiscreteMarkers = w.config.markers.discrete && w.config.markers.discrete.length;
        if (Array.isArray(p.x)) {
          for (var q = 0; q < p.x.length; q++) {
            var markerElement = void 0;
            var dataPointIndex = j;
            var invalidMarker = !Utils$1.isNumber(p.y[q]);
            if (w.globals.markers.largestSize === 0 && w.globals.hasNullValues && w.globals.series[i][j + 1] !== null && !isVirtualPoint) {
              invalidMarker = true;
            }

            // a small hack as we have 2 points for the first val to connect it
            if (j === 1 && q === 0) dataPointIndex = 0;
            if (j === 1 && q === 1) dataPointIndex = 1;
            var markerClasses = 'apexcharts-marker';
            if ((w.config.chart.type === 'line' || w.config.chart.type === 'area') && !w.globals.comboCharts && !w.config.tooltip.intersect) {
              markerClasses += ' no-pointer-events';
            }
            var shouldMarkerDraw = Array.isArray(w.config.markers.size) ? w.globals.markers.size[seriesIndex] > 0 : w.config.markers.size > 0;
            if (shouldMarkerDraw || alwaysDrawMarker || hasDiscreteMarkers) {
              if (!invalidMarker) {
                markerClasses += " w".concat(Utils$1.randomId());
              }
              var opts = this.getMarkerConfig({
                cssClass: markerClasses,
                seriesIndex: seriesIndex,
                dataPointIndex: dataPointIndex
              });
              if (w.config.series[i].data[dataPointIndex]) {
                if (w.config.series[i].data[dataPointIndex].fillColor) {
                  opts.pointFillColor = w.config.series[i].data[dataPointIndex].fillColor;
                }
                if (w.config.series[i].data[dataPointIndex].strokeColor) {
                  opts.pointStrokeColor = w.config.series[i].data[dataPointIndex].strokeColor;
                }
              }
              if (typeof pSize !== 'undefined') {
                opts.pSize = pSize;
              }
              if (p.x[q] < -w.globals.markers.largestSize || p.x[q] > w.globals.gridWidth + w.globals.markers.largestSize || p.y[q] < -w.globals.markers.largestSize || p.y[q] > w.globals.gridHeight + w.globals.markers.largestSize) {
                opts.pSize = 0;
              }
              if (!invalidMarker) {
                var shouldCreateMarkerWrap = w.globals.markers.size[seriesIndex] > 0 || alwaysDrawMarker || hasDiscreteMarkers;
                if (shouldCreateMarkerWrap && !elMarkersWrap) {
                  elMarkersWrap = graphics.group({
                    class: alwaysDrawMarker || hasDiscreteMarkers ? '' : 'apexcharts-series-markers'
                  });
                  elMarkersWrap.attr('clip-path', "url(#gridRectMarkerMask".concat(w.globals.cuid, ")"));
                }
                markerElement = graphics.drawMarker(p.x[q], p.y[q], opts);
                markerElement.attr('rel', dataPointIndex);
                markerElement.attr('j', dataPointIndex);
                markerElement.attr('index', seriesIndex);
                markerElement.node.setAttribute('default-marker-size', opts.pSize);
                var filters = new Filters(this.ctx);
                filters.setSelectionFilter(markerElement, seriesIndex, dataPointIndex);
                this.addEvents(markerElement);
                if (elMarkersWrap) {
                  elMarkersWrap.add(markerElement);
                }
              }
            } else {
              // dynamic array creation - multidimensional
              if (typeof w.globals.pointsArray[seriesIndex] === 'undefined') w.globals.pointsArray[seriesIndex] = [];
              w.globals.pointsArray[seriesIndex].push([p.x[q], p.y[q]]);
            }
          }
        }
        return elMarkersWrap;
      }
    }, {
      key: "getMarkerConfig",
      value: function getMarkerConfig(_ref2) {
        var cssClass = _ref2.cssClass,
          seriesIndex = _ref2.seriesIndex,
          _ref2$dataPointIndex = _ref2.dataPointIndex,
          dataPointIndex = _ref2$dataPointIndex === void 0 ? null : _ref2$dataPointIndex,
          _ref2$radius = _ref2.radius,
          radius = _ref2$radius === void 0 ? null : _ref2$radius,
          _ref2$size = _ref2.size,
          size = _ref2$size === void 0 ? null : _ref2$size,
          _ref2$strokeWidth = _ref2.strokeWidth,
          strokeWidth = _ref2$strokeWidth === void 0 ? null : _ref2$strokeWidth;
        var w = this.w;
        var pStyle = this.getMarkerStyle(seriesIndex);
        var pSize = size === null ? w.globals.markers.size[seriesIndex] : size;
        var m = w.config.markers;

        // discrete markers is an option where user can specify a particular marker with different shape, size and color

        if (dataPointIndex !== null && m.discrete.length) {
          m.discrete.map(function (marker) {
            if (marker.seriesIndex === seriesIndex && marker.dataPointIndex === dataPointIndex) {
              pStyle.pointStrokeColor = marker.strokeColor;
              pStyle.pointFillColor = marker.fillColor;
              pSize = marker.size;
              pStyle.pointShape = marker.shape;
            }
          });
        }
        return {
          pSize: radius === null ? pSize : radius,
          pRadius: radius !== null ? radius : m.radius,
          pointStrokeWidth: strokeWidth !== null ? strokeWidth : Array.isArray(m.strokeWidth) ? m.strokeWidth[seriesIndex] : m.strokeWidth,
          pointStrokeColor: pStyle.pointStrokeColor,
          pointFillColor: pStyle.pointFillColor,
          shape: pStyle.pointShape || (Array.isArray(m.shape) ? m.shape[seriesIndex] : m.shape),
          class: cssClass,
          pointStrokeOpacity: Array.isArray(m.strokeOpacity) ? m.strokeOpacity[seriesIndex] : m.strokeOpacity,
          pointStrokeDashArray: Array.isArray(m.strokeDashArray) ? m.strokeDashArray[seriesIndex] : m.strokeDashArray,
          pointFillOpacity: Array.isArray(m.fillOpacity) ? m.fillOpacity[seriesIndex] : m.fillOpacity,
          seriesIndex: seriesIndex
        };
      }
    }, {
      key: "addEvents",
      value: function addEvents(marker) {
        var w = this.w;
        var graphics = new Graphics(this.ctx);
        marker.node.addEventListener('mouseenter', graphics.pathMouseEnter.bind(this.ctx, marker));
        marker.node.addEventListener('mouseleave', graphics.pathMouseLeave.bind(this.ctx, marker));
        marker.node.addEventListener('mousedown', graphics.pathMouseDown.bind(this.ctx, marker));
        marker.node.addEventListener('click', w.config.markers.onClick);
        marker.node.addEventListener('dblclick', w.config.markers.onDblClick);
        marker.node.addEventListener('touchstart', graphics.pathMouseDown.bind(this.ctx, marker), {
          passive: true
        });
      }
    }, {
      key: "getMarkerStyle",
      value: function getMarkerStyle(seriesIndex) {
        var w = this.w;
        var colors = w.globals.markers.colors;
        var strokeColors = w.config.markers.strokeColor || w.config.markers.strokeColors;
        var pointStrokeColor = Array.isArray(strokeColors) ? strokeColors[seriesIndex] : strokeColors;
        var pointFillColor = Array.isArray(colors) ? colors[seriesIndex] : colors;
        return {
          pointStrokeColor: pointStrokeColor,
          pointFillColor: pointFillColor
        };
      }
    }]);
    return Markers;
  }();

  /**
   * ApexCharts Scatter Class.
   * This Class also handles bubbles chart as currently there is no major difference in drawing them,
   * @module Scatter
   **/
  var Scatter = /*#__PURE__*/function () {
    function Scatter(ctx) {
      _classCallCheck(this, Scatter);
      this.ctx = ctx;
      this.w = ctx.w;
      this.initialAnim = this.w.config.chart.animations.enabled;
    }
    _createClass(Scatter, [{
      key: "draw",
      value: function draw(elSeries, j, opts) {
        var w = this.w;
        var graphics = new Graphics(this.ctx);
        var realIndex = opts.realIndex;
        var pointsPos = opts.pointsPos;
        var zRatio = opts.zRatio;
        var elPointsMain = opts.elParent;
        var elPointsWrap = graphics.group({
          class: "apexcharts-series-markers apexcharts-series-".concat(w.config.chart.type)
        });
        elPointsWrap.attr('clip-path', "url(#gridRectMarkerMask".concat(w.globals.cuid, ")"));
        if (Array.isArray(pointsPos.x)) {
          for (var q = 0; q < pointsPos.x.length; q++) {
            var dataPointIndex = j + 1;
            var shouldDraw = true;

            // a small hack as we have 2 points for the first val to connect it
            if (j === 0 && q === 0) dataPointIndex = 0;
            if (j === 0 && q === 1) dataPointIndex = 1;
            var radius = w.globals.markers.size[realIndex];
            if (zRatio !== Infinity) {
              // means we have a bubble
              var bubble = w.config.plotOptions.bubble;
              radius = w.globals.seriesZ[realIndex][dataPointIndex];
              if (bubble.zScaling) {
                radius /= zRatio;
              }
              if (bubble.minBubbleRadius && radius < bubble.minBubbleRadius) {
                radius = bubble.minBubbleRadius;
              }
              if (bubble.maxBubbleRadius && radius > bubble.maxBubbleRadius) {
                radius = bubble.maxBubbleRadius;
              }
            }
            var x = pointsPos.x[q];
            var y = pointsPos.y[q];
            radius = radius || 0;
            if (y === null || typeof w.globals.series[realIndex][dataPointIndex] === 'undefined') {
              shouldDraw = false;
            }
            if (shouldDraw) {
              var point = this.drawPoint(x, y, radius, realIndex, dataPointIndex, j);
              elPointsWrap.add(point);
            }
            elPointsMain.add(elPointsWrap);
          }
        }
      }
    }, {
      key: "drawPoint",
      value: function drawPoint(x, y, radius, realIndex, dataPointIndex, j) {
        var w = this.w;
        var i = realIndex;
        var anim = new Animations(this.ctx);
        var filters = new Filters(this.ctx);
        var fill = new Fill(this.ctx);
        var markers = new Markers(this.ctx);
        var graphics = new Graphics(this.ctx);
        var markerConfig = markers.getMarkerConfig({
          cssClass: 'apexcharts-marker',
          seriesIndex: i,
          dataPointIndex: dataPointIndex,
          radius: w.config.chart.type === 'bubble' || w.globals.comboCharts && w.config.series[realIndex] && w.config.series[realIndex].type === 'bubble' ? radius : null
        });
        var pathFillCircle = fill.fillPath({
          seriesNumber: realIndex,
          dataPointIndex: dataPointIndex,
          color: markerConfig.pointFillColor,
          patternUnits: 'objectBoundingBox',
          value: w.globals.series[realIndex][j]
        });
        var el = graphics.drawMarker(x, y, markerConfig);
        if (w.config.series[i].data[dataPointIndex]) {
          if (w.config.series[i].data[dataPointIndex].fillColor) {
            pathFillCircle = w.config.series[i].data[dataPointIndex].fillColor;
          }
        }
        el.attr({
          fill: pathFillCircle
        });
        if (w.config.chart.dropShadow.enabled) {
          var dropShadow = w.config.chart.dropShadow;
          filters.dropShadow(el, dropShadow, realIndex);
        }
        if (this.initialAnim && !w.globals.dataChanged && !w.globals.resized) {
          var speed = w.config.chart.animations.speed;
          anim.animateMarker(el, speed, w.globals.easing, function () {
            window.setTimeout(function () {
              anim.animationCompleted(el);
            }, 100);
          });
        } else {
          w.globals.animationEnded = true;
        }
        el.attr({
          rel: dataPointIndex,
          j: dataPointIndex,
          index: realIndex,
          'default-marker-size': markerConfig.pSize
        });
        filters.setSelectionFilter(el, realIndex, dataPointIndex);
        markers.addEvents(el);
        el.node.classList.add('apexcharts-marker');
        return el;
      }
    }, {
      key: "centerTextInBubble",
      value: function centerTextInBubble(y) {
        var w = this.w;
        y = y + parseInt(w.config.dataLabels.style.fontSize, 10) / 4;
        return {
          y: y
        };
      }
    }]);
    return Scatter;
  }();

  /**
   * ApexCharts DataLabels Class for drawing dataLabels on Axes based Charts.
   *
   * @module DataLabels
   **/
  var DataLabels = /*#__PURE__*/function () {
    function DataLabels(ctx) {
      _classCallCheck(this, DataLabels);
      this.ctx = ctx;
      this.w = ctx.w;
    }

    // When there are many datalabels to be printed, and some of them overlaps each other in the same series, this method will take care of that
    // Also, when datalabels exceeds the drawable area and get clipped off, we need to adjust and move some pixels to make them visible again
    _createClass(DataLabels, [{
      key: "dataLabelsCorrection",
      value: function dataLabelsCorrection(x, y, val, i, dataPointIndex, alwaysDrawDataLabel, fontSize) {
        var w = this.w;
        var graphics = new Graphics(this.ctx);
        var drawnextLabel = false; //

        var textRects = graphics.getTextRects(val, fontSize);
        var width = textRects.width;
        var height = textRects.height;
        if (y < 0) y = 0;
        if (y > w.globals.gridHeight + height) y = w.globals.gridHeight + height / 2;

        // first value in series, so push an empty array
        if (typeof w.globals.dataLabelsRects[i] === 'undefined') w.globals.dataLabelsRects[i] = [];

        // then start pushing actual rects in that sub-array
        w.globals.dataLabelsRects[i].push({
          x: x,
          y: y,
          width: width,
          height: height
        });
        var len = w.globals.dataLabelsRects[i].length - 2;
        var lastDrawnIndex = typeof w.globals.lastDrawnDataLabelsIndexes[i] !== 'undefined' ? w.globals.lastDrawnDataLabelsIndexes[i][w.globals.lastDrawnDataLabelsIndexes[i].length - 1] : 0;
        if (typeof w.globals.dataLabelsRects[i][len] !== 'undefined') {
          var lastDataLabelRect = w.globals.dataLabelsRects[i][lastDrawnIndex];
          if (
          // next label forward and x not intersecting
          x > lastDataLabelRect.x + lastDataLabelRect.width || y > lastDataLabelRect.y + lastDataLabelRect.height || y + height < lastDataLabelRect.y || x + width < lastDataLabelRect.x // next label is going to be drawn backwards
          ) {
            // the 2 indexes don't override, so OK to draw next label
            drawnextLabel = true;
          }
        }
        if (dataPointIndex === 0 || alwaysDrawDataLabel) {
          drawnextLabel = true;
        }
        return {
          x: x,
          y: y,
          textRects: textRects,
          drawnextLabel: drawnextLabel
        };
      }
    }, {
      key: "drawDataLabel",
      value: function drawDataLabel(_ref) {
        var _this = this;
        var type = _ref.type,
          pos = _ref.pos,
          i = _ref.i,
          j = _ref.j,
          isRangeStart = _ref.isRangeStart,
          _ref$strokeWidth = _ref.strokeWidth,
          strokeWidth = _ref$strokeWidth === void 0 ? 2 : _ref$strokeWidth;
        // this method handles line, area, bubble, scatter charts as those charts contains markers/points which have pre-defined x/y positions
        // all other charts like radar / bars / heatmaps will define their own drawDataLabel routine
        var w = this.w;
        var graphics = new Graphics(this.ctx);
        var dataLabelsConfig = w.config.dataLabels;
        var x = 0;
        var y = 0;
        var dataPointIndex = j;
        var elDataLabelsWrap = null;
        var seriesCollapsed = w.globals.collapsedSeriesIndices.indexOf(i) !== -1;
        if (seriesCollapsed || !dataLabelsConfig.enabled || !Array.isArray(pos.x)) {
          return elDataLabelsWrap;
        }
        elDataLabelsWrap = graphics.group({
          class: 'apexcharts-data-labels'
        });
        for (var q = 0; q < pos.x.length; q++) {
          x = pos.x[q] + dataLabelsConfig.offsetX;
          y = pos.y[q] + dataLabelsConfig.offsetY + strokeWidth;
          if (!isNaN(x)) {
            // a small hack as we have 2 points for the first val to connect it
            if (j === 1 && q === 0) dataPointIndex = 0;
            if (j === 1 && q === 1) dataPointIndex = 1;
            var val = w.globals.series[i][dataPointIndex];
            if (type === 'rangeArea') {
              if (isRangeStart) {
                val = w.globals.seriesRangeStart[i][dataPointIndex];
              } else {
                val = w.globals.seriesRangeEnd[i][dataPointIndex];
              }
            }
            var text = '';
            var getText = function getText(v) {
              return w.config.dataLabels.formatter(v, {
                ctx: _this.ctx,
                seriesIndex: i,
                dataPointIndex: dataPointIndex,
                w: w
              });
            };
            if (w.config.chart.type === 'bubble') {
              val = w.globals.seriesZ[i][dataPointIndex];
              text = getText(val);
              y = pos.y[q];
              var scatter = new Scatter(this.ctx);
              var centerTextInBubbleCoords = scatter.centerTextInBubble(y, i, dataPointIndex);
              y = centerTextInBubbleCoords.y;
            } else {
              if (typeof val !== 'undefined') {
                text = getText(val);
              }
            }
            var textAnchor = w.config.dataLabels.textAnchor;
            if (w.globals.isSlopeChart) {
              if (dataPointIndex === 0) {
                textAnchor = 'end';
              } else if (dataPointIndex === w.config.series[i].data.length - 1) {
                textAnchor = 'start';
              } else {
                textAnchor = 'middle';
              }
            }
            this.plotDataLabelsText({
              x: x,
              y: y,
              text: text,
              i: i,
              j: dataPointIndex,
              parent: elDataLabelsWrap,
              offsetCorrection: true,
              dataLabelsConfig: w.config.dataLabels,
              textAnchor: textAnchor
            });
          }
        }
        return elDataLabelsWrap;
      }
    }, {
      key: "plotDataLabelsText",
      value: function plotDataLabelsText(opts) {
        var w = this.w;
        var graphics = new Graphics(this.ctx);
        var x = opts.x,
          y = opts.y,
          i = opts.i,
          j = opts.j,
          text = opts.text,
          textAnchor = opts.textAnchor,
          fontSize = opts.fontSize,
          parent = opts.parent,
          dataLabelsConfig = opts.dataLabelsConfig,
          color = opts.color,
          alwaysDrawDataLabel = opts.alwaysDrawDataLabel,
          offsetCorrection = opts.offsetCorrection,
          className = opts.className;
        var dataLabelText = null;
        if (Array.isArray(w.config.dataLabels.enabledOnSeries)) {
          if (w.config.dataLabels.enabledOnSeries.indexOf(i) < 0) {
            return dataLabelText;
          }
        }
        var correctedLabels = {
          x: x,
          y: y,
          drawnextLabel: true,
          textRects: null
        };
        if (offsetCorrection) {
          correctedLabels = this.dataLabelsCorrection(x, y, text, i, j, alwaysDrawDataLabel, parseInt(dataLabelsConfig.style.fontSize, 10));
        }

        // when zoomed, we don't need to correct labels offsets,
        // but if normally, labels get cropped, correct them
        if (!w.globals.zoomed) {
          x = correctedLabels.x;
          y = correctedLabels.y;
        }
        if (correctedLabels.textRects) {
          // fixes #2264
          if (x < -20 - correctedLabels.textRects.width || x > w.globals.gridWidth + correctedLabels.textRects.width + 30) {
            // datalabels fall outside drawing area, so draw a blank label
            text = '';
          }
        }
        var dataLabelColor = w.globals.dataLabels.style.colors[i];
        if ((w.config.chart.type === 'bar' || w.config.chart.type === 'rangeBar') && w.config.plotOptions.bar.distributed || w.config.dataLabels.distributed) {
          dataLabelColor = w.globals.dataLabels.style.colors[j];
        }
        if (typeof dataLabelColor === 'function') {
          dataLabelColor = dataLabelColor({
            series: w.globals.series,
            seriesIndex: i,
            dataPointIndex: j,
            w: w
          });
        }
        if (color) {
          dataLabelColor = color;
        }
        var offX = dataLabelsConfig.offsetX;
        var offY = dataLabelsConfig.offsetY;
        if (w.config.chart.type === 'bar' || w.config.chart.type === 'rangeBar') {
          // for certain chart types, we handle offsets while calculating datalabels pos
          // why? because bars/column may have negative values and based on that
          // offsets becomes reversed
          offX = 0;
          offY = 0;
        }
        if (w.globals.isSlopeChart) {
          if (j !== 0) {
            offX = dataLabelsConfig.offsetX * -2 + 5;
          }
          if (j !== 0 && j !== w.config.series[i].data.length - 1) {
            offX = 0;
          }
        }
        if (correctedLabels.drawnextLabel) {
          if (textAnchor === 'middle') {
            if (x === w.globals.gridWidth) {
              // last label - might get cropped
              // fixes https://github.com/apexcharts/apexcharts.js/issues/5036
              textAnchor = 'end';
            }
          }
          dataLabelText = graphics.drawText({
            width: 100,
            height: parseInt(dataLabelsConfig.style.fontSize, 10),
            x: x + offX,
            y: y + offY,
            foreColor: dataLabelColor,
            textAnchor: textAnchor || dataLabelsConfig.textAnchor,
            text: text,
            fontSize: fontSize || dataLabelsConfig.style.fontSize,
            fontFamily: dataLabelsConfig.style.fontFamily,
            fontWeight: dataLabelsConfig.style.fontWeight || 'normal'
          });
          dataLabelText.attr({
            class: className || 'apexcharts-datalabel',
            cx: x,
            cy: y
          });
          if (dataLabelsConfig.dropShadow.enabled) {
            var textShadow = dataLabelsConfig.dropShadow;
            var filters = new Filters(this.ctx);
            filters.dropShadow(dataLabelText, textShadow);
          }
          parent.add(dataLabelText);
          if (typeof w.globals.lastDrawnDataLabelsIndexes[i] === 'undefined') {
            w.globals.lastDrawnDataLabelsIndexes[i] = [];
          }
          w.globals.lastDrawnDataLabelsIndexes[i].push(j);
        }
        return dataLabelText;
      }
    }, {
      key: "addBackgroundToDataLabel",
      value: function addBackgroundToDataLabel(el, coords) {
        var w = this.w;
        var bCnf = w.config.dataLabels.background;
        var paddingH = bCnf.padding;
        var paddingV = bCnf.padding / 2;
        var width = coords.width;
        var height = coords.height;
        var graphics = new Graphics(this.ctx);
        var elRect = graphics.drawRect(coords.x - paddingH, coords.y - paddingV / 2, width + paddingH * 2, height + paddingV, bCnf.borderRadius, w.config.chart.background === 'transparent' || !w.config.chart.background ? '#fff' : w.config.chart.background, bCnf.opacity, bCnf.borderWidth, bCnf.borderColor);
        if (bCnf.dropShadow.enabled) {
          var filters = new Filters(this.ctx);
          filters.dropShadow(elRect, bCnf.dropShadow);
        }
        return elRect;
      }
    }, {
      key: "dataLabelsBackground",
      value: function dataLabelsBackground() {
        var w = this.w;
        if (w.config.chart.type === 'bubble') return;
        var elDataLabels = w.globals.dom.baseEl.querySelectorAll('.apexcharts-datalabels text');
        for (var i = 0; i < elDataLabels.length; i++) {
          var el = elDataLabels[i];
          var coords = el.getBBox();
          var elRect = null;
          if (coords.width && coords.height) {
            elRect = this.addBackgroundToDataLabel(el, coords);
          }
          if (elRect) {
            el.parentNode.insertBefore(elRect.node, el);
            var background = w.config.dataLabels.background.backgroundColor || el.getAttribute('fill');
            var shouldAnim = w.config.chart.animations.enabled && !w.globals.resized && !w.globals.dataChanged;
            if (shouldAnim) {
              elRect.animate().attr({
                fill: background
              });
            } else {
              elRect.attr({
                fill: background
              });
            }
            el.setAttribute('fill', w.config.dataLabels.background.foreColor);
          }
        }
      }
    }, {
      key: "bringForward",
      value: function bringForward() {
        var w = this.w;
        var elDataLabelsNodes = w.globals.dom.baseEl.querySelectorAll('.apexcharts-datalabels');
        var elSeries = w.globals.dom.baseEl.querySelector('.apexcharts-plot-series:last-child');
        for (var i = 0; i < elDataLabelsNodes.length; i++) {
          if (elSeries) {
            elSeries.insertBefore(elDataLabelsNodes[i], elSeries.nextSibling);
          }
        }
      }
    }]);
    return DataLabels;
  }();

  var css_248z$1 = ".apexcharts-flip-y {\n  transform: scaleY(-1) translateY(-100%);\n  transform-origin: top;\n  transform-box: fill-box;\n}\n.apexcharts-flip-x {\n  transform: scaleX(-1);\n  transform-origin: center;\n  transform-box: fill-box;\n}\n.apexcharts-legend {\n  display: flex;\n  overflow: auto;\n  padding: 0 10px;\n}\n.apexcharts-legend.apexcharts-legend-group-horizontal {\n  flex-direction: column;\n}\n.apexcharts-legend-group {\n  display: flex;\n}\n.apexcharts-legend-group-vertical {\n  flex-direction: column-reverse;\n}\n.apexcharts-legend.apx-legend-position-bottom, .apexcharts-legend.apx-legend-position-top {\n  flex-wrap: wrap\n}\n.apexcharts-legend.apx-legend-position-right, .apexcharts-legend.apx-legend-position-left {\n  flex-direction: column;\n  bottom: 0;\n}\n.apexcharts-legend.apx-legend-position-bottom.apexcharts-align-left, .apexcharts-legend.apx-legend-position-top.apexcharts-align-left, .apexcharts-legend.apx-legend-position-right, .apexcharts-legend.apx-legend-position-left {\n  justify-content: flex-start;\n  align-items: flex-start;\n}\n.apexcharts-legend.apx-legend-position-bottom.apexcharts-align-center, .apexcharts-legend.apx-legend-position-top.apexcharts-align-center {\n  justify-content: center;\n  align-items: center;\n}\n.apexcharts-legend.apx-legend-position-bottom.apexcharts-align-right, .apexcharts-legend.apx-legend-position-top.apexcharts-align-right {\n  justify-content: flex-end;\n  align-items: flex-end;\n}\n.apexcharts-legend-series {\n  cursor: pointer;\n  line-height: normal;\n  display: flex;\n  align-items: center;\n}\n.apexcharts-legend-text {\n  position: relative;\n  font-size: 14px;\n}\n.apexcharts-legend-text *, .apexcharts-legend-marker * {\n  pointer-events: none;\n}\n.apexcharts-legend-marker {\n  position: relative;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  cursor: pointer;\n  margin-right: 1px;\n}\n\n.apexcharts-legend-series.apexcharts-no-click {\n  cursor: auto;\n}\n.apexcharts-legend .apexcharts-hidden-zero-series, .apexcharts-legend .apexcharts-hidden-null-series {\n  display: none !important;\n}\n.apexcharts-inactive-legend {\n  opacity: 0.45;\n} ";

  /**
   * ApexCharts Series Class for interaction with the Series of the chart.
   *
   * @module Series
   **/
  var Series = /*#__PURE__*/function () {
    function Series(ctx) {
      _classCallCheck(this, Series);
      this.ctx = ctx;
      this.w = ctx.w;
      this.legendInactiveClass = 'legend-mouseover-inactive';
    }
    _createClass(Series, [{
      key: "getAllSeriesEls",
      value: function getAllSeriesEls() {
        return this.w.globals.dom.baseEl.getElementsByClassName("apexcharts-series");
      }
    }, {
      key: "getSeriesByName",
      value: function getSeriesByName(seriesName) {
        return this.w.globals.dom.baseEl.querySelector(".apexcharts-inner .apexcharts-series[seriesName='".concat(Utils$1.escapeString(seriesName), "']"));
      }
    }, {
      key: "isSeriesHidden",
      value: function isSeriesHidden(seriesName) {
        var targetElement = this.getSeriesByName(seriesName);
        var realIndex = parseInt(targetElement.getAttribute('data:realIndex'), 10);
        var isHidden = targetElement.classList.contains('apexcharts-series-collapsed');
        return {
          isHidden: isHidden,
          realIndex: realIndex
        };
      }
    }, {
      key: "addCollapsedClassToSeries",
      value: function addCollapsedClassToSeries(elSeries, index) {
        var w = this.w;
        function iterateOnAllCollapsedSeries(series) {
          for (var cs = 0; cs < series.length; cs++) {
            if (series[cs].index === index) {
              elSeries.node.classList.add('apexcharts-series-collapsed');
            }
          }
        }
        iterateOnAllCollapsedSeries(w.globals.collapsedSeries);
        iterateOnAllCollapsedSeries(w.globals.ancillaryCollapsedSeries);
      }
    }, {
      key: "toggleSeries",
      value: function toggleSeries(seriesName) {
        var isSeriesHidden = this.isSeriesHidden(seriesName);
        this.ctx.legend.legendHelpers.toggleDataSeries(isSeriesHidden.realIndex, isSeriesHidden.isHidden);
        return isSeriesHidden.isHidden;
      }
    }, {
      key: "showSeries",
      value: function showSeries(seriesName) {
        var isSeriesHidden = this.isSeriesHidden(seriesName);
        if (isSeriesHidden.isHidden) {
          this.ctx.legend.legendHelpers.toggleDataSeries(isSeriesHidden.realIndex, true);
        }
      }
    }, {
      key: "hideSeries",
      value: function hideSeries(seriesName) {
        var isSeriesHidden = this.isSeriesHidden(seriesName);
        if (!isSeriesHidden.isHidden) {
          this.ctx.legend.legendHelpers.toggleDataSeries(isSeriesHidden.realIndex, false);
        }
      }
    }, {
      key: "resetSeries",
      value: function resetSeries() {
        var shouldUpdateChart = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
        var shouldResetZoom = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
        var shouldResetCollapsed = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
        var w = this.w;
        var series = Utils$1.clone(w.globals.initialSeries);
        w.globals.previousPaths = [];
        if (shouldResetCollapsed) {
          w.globals.collapsedSeries = [];
          w.globals.ancillaryCollapsedSeries = [];
          w.globals.collapsedSeriesIndices = [];
          w.globals.ancillaryCollapsedSeriesIndices = [];
        } else {
          series = this.emptyCollapsedSeries(series);
        }
        w.config.series = series;
        if (shouldUpdateChart) {
          if (shouldResetZoom) {
            w.globals.zoomed = false;
            this.ctx.updateHelpers.revertDefaultAxisMinMax();
          }
          this.ctx.updateHelpers._updateSeries(series, w.config.chart.animations.dynamicAnimation.enabled);
        }
      }
    }, {
      key: "emptyCollapsedSeries",
      value: function emptyCollapsedSeries(series) {
        var w = this.w;
        for (var i = 0; i < series.length; i++) {
          if (w.globals.collapsedSeriesIndices.indexOf(i) > -1) {
            series[i].data = [];
          }
        }
        return series;
      }
    }, {
      key: "highlightSeries",
      value: function highlightSeries(seriesName) {
        var w = this.w;
        var targetElement = this.getSeriesByName(seriesName);
        var realIndex = parseInt(targetElement === null || targetElement === void 0 ? void 0 : targetElement.getAttribute('data:realIndex'), 10);
        var allSeriesEls = w.globals.dom.baseEl.querySelectorAll(".apexcharts-series, .apexcharts-datalabels, .apexcharts-yaxis");
        var seriesEl = null;
        var dataLabelEl = null;
        var yaxisEl = null;
        if (w.globals.axisCharts || w.config.chart.type === 'radialBar') {
          if (w.globals.axisCharts) {
            seriesEl = w.globals.dom.baseEl.querySelector(".apexcharts-series[data\\:realIndex='".concat(realIndex, "']"));
            dataLabelEl = w.globals.dom.baseEl.querySelector(".apexcharts-datalabels[data\\:realIndex='".concat(realIndex, "']"));
            var yaxisIndex = w.globals.seriesYAxisReverseMap[realIndex];
            yaxisEl = w.globals.dom.baseEl.querySelector(".apexcharts-yaxis[rel='".concat(yaxisIndex, "']"));
          } else {
            seriesEl = w.globals.dom.baseEl.querySelector(".apexcharts-series[rel='".concat(realIndex + 1, "']"));
          }
        } else {
          seriesEl = w.globals.dom.baseEl.querySelector(".apexcharts-series[rel='".concat(realIndex + 1, "'] path"));
        }
        for (var se = 0; se < allSeriesEls.length; se++) {
          allSeriesEls[se].classList.add(this.legendInactiveClass);
        }
        if (seriesEl) {
          if (!w.globals.axisCharts) {
            seriesEl.parentNode.classList.remove(this.legendInactiveClass);
          }
          seriesEl.classList.remove(this.legendInactiveClass);
          if (dataLabelEl !== null) {
            dataLabelEl.classList.remove(this.legendInactiveClass);
          }
          if (yaxisEl !== null) {
            yaxisEl.classList.remove(this.legendInactiveClass);
          }
        } else {
          for (var _se = 0; _se < allSeriesEls.length; _se++) {
            allSeriesEls[_se].classList.remove(this.legendInactiveClass);
          }
        }
      }
    }, {
      key: "toggleSeriesOnHover",
      value: function toggleSeriesOnHover(e, targetElement) {
        var w = this.w;
        if (!targetElement) targetElement = e.target;
        var allSeriesEls = w.globals.dom.baseEl.querySelectorAll(".apexcharts-series, .apexcharts-datalabels, .apexcharts-yaxis");
        if (e.type === 'mousemove') {
          var realIndex = parseInt(targetElement.getAttribute('rel'), 10) - 1;
          this.highlightSeries(w.globals.seriesNames[realIndex]);
        } else if (e.type === 'mouseout') {
          for (var se = 0; se < allSeriesEls.length; se++) {
            allSeriesEls[se].classList.remove(this.legendInactiveClass);
          }
        }
      }
    }, {
      key: "highlightRangeInSeries",
      value: function highlightRangeInSeries(e, targetElement) {
        var _this = this;
        var w = this.w;
        var allHeatMapElements = w.globals.dom.baseEl.getElementsByClassName('apexcharts-heatmap-rect');
        var activeInactive = function activeInactive(action) {
          for (var i = 0; i < allHeatMapElements.length; i++) {
            allHeatMapElements[i].classList[action](_this.legendInactiveClass);
          }
        };
        var removeInactiveClassFromHoveredRange = function removeInactiveClassFromHoveredRange(range, rangeMax) {
          for (var i = 0; i < allHeatMapElements.length; i++) {
            var val = Number(allHeatMapElements[i].getAttribute('val'));
            if (val >= range.from && (val < range.to || range.to === rangeMax && val === rangeMax)) {
              allHeatMapElements[i].classList.remove(_this.legendInactiveClass);
            }
          }
        };
        if (e.type === 'mousemove') {
          var seriesCnt = parseInt(targetElement.getAttribute('rel'), 10) - 1;
          activeInactive('add');
          var ranges = w.config.plotOptions.heatmap.colorScale.ranges;
          var range = ranges[seriesCnt];
          var rangeMax = ranges.reduce(function (acc, cur) {
            return Math.max(acc, cur.to);
          }, 0);
          removeInactiveClassFromHoveredRange(range, rangeMax);
        } else if (e.type === 'mouseout') {
          activeInactive('remove');
        }
      }
    }, {
      key: "getActiveConfigSeriesIndex",
      value: function getActiveConfigSeriesIndex() {
        var order = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'asc';
        var chartTypes = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
        var w = this.w;
        var activeIndex = 0;
        if (w.config.series.length > 1) {
          // active series flag is required to know if user has not deactivated via legend click
          var activeSeriesIndex = w.config.series.map(function (s, index) {
            var checkChartType = function checkChartType() {
              if (w.globals.comboCharts) {
                return chartTypes.length === 0 || chartTypes.length && chartTypes.indexOf(w.config.series[index].type) > -1;
              }
              return true;
            };
            var hasData = s.data && s.data.length > 0 && w.globals.collapsedSeriesIndices.indexOf(index) === -1;
            return hasData && checkChartType() ? index : -1;
          });
          for (var a = order === 'asc' ? 0 : activeSeriesIndex.length - 1; order === 'asc' ? a < activeSeriesIndex.length : a >= 0; order === 'asc' ? a++ : a--) {
            if (activeSeriesIndex[a] !== -1) {
              activeIndex = activeSeriesIndex[a];
              break;
            }
          }
        }
        return activeIndex;
      }
    }, {
      key: "getBarSeriesIndices",
      value: function getBarSeriesIndices() {
        var w = this.w;
        if (w.globals.comboCharts) {
          return this.w.config.series.map(function (s, i) {
            return s.type === 'bar' || s.type === 'column' ? i : -1;
          }).filter(function (i) {
            return i !== -1;
          });
        }
        return this.w.config.series.map(function (s, i) {
          return i;
        });
      }
    }, {
      key: "getPreviousPaths",
      value: function getPreviousPaths() {
        var w = this.w;
        w.globals.previousPaths = [];
        function pushPaths(seriesEls, i, type) {
          var paths = seriesEls[i].childNodes;
          var dArr = {
            type: type,
            paths: [],
            realIndex: seriesEls[i].getAttribute('data:realIndex')
          };
          for (var j = 0; j < paths.length; j++) {
            if (paths[j].hasAttribute('pathTo')) {
              var d = paths[j].getAttribute('pathTo');
              dArr.paths.push({
                d: d
              });
            }
          }
          w.globals.previousPaths.push(dArr);
        }
        var getPaths = function getPaths(chartType) {
          return w.globals.dom.baseEl.querySelectorAll(".apexcharts-".concat(chartType, "-series .apexcharts-series"));
        };
        var chartTypes = ['line', 'area', 'bar', 'rangebar', 'rangeArea', 'candlestick', 'radar'];
        chartTypes.forEach(function (type) {
          var paths = getPaths(type);
          for (var p = 0; p < paths.length; p++) {
            pushPaths(paths, p, type);
          }
        });
        var heatTreeSeries = w.globals.dom.baseEl.querySelectorAll(".apexcharts-".concat(w.config.chart.type, " .apexcharts-series"));
        if (heatTreeSeries.length > 0) {
          var _loop = function _loop(h) {
            var seriesEls = w.globals.dom.baseEl.querySelectorAll(".apexcharts-".concat(w.config.chart.type, " .apexcharts-series[data\\:realIndex='").concat(h, "'] rect"));
            var dArr = [];
            var _loop2 = function _loop2(i) {
              var getAttr = function getAttr(x) {
                return seriesEls[i].getAttribute(x);
              };
              var rect = {
                x: parseFloat(getAttr('x')),
                y: parseFloat(getAttr('y')),
                width: parseFloat(getAttr('width')),
                height: parseFloat(getAttr('height'))
              };
              dArr.push({
                rect: rect,
                color: seriesEls[i].getAttribute('color')
              });
            };
            for (var i = 0; i < seriesEls.length; i++) {
              _loop2(i);
            }
            w.globals.previousPaths.push(dArr);
          };
          for (var h = 0; h < heatTreeSeries.length; h++) {
            _loop(h);
          }
        }
        if (!w.globals.axisCharts) {
          // for non-axis charts (i.e., circular charts, pathFrom is not usable. We need whole series)
          w.globals.previousPaths = w.globals.series;
        }
      }
    }, {
      key: "clearPreviousPaths",
      value: function clearPreviousPaths() {
        var w = this.w;
        w.globals.previousPaths = [];
        w.globals.allSeriesCollapsed = false;
      }
    }, {
      key: "handleNoData",
      value: function handleNoData() {
        var w = this.w;
        var me = this;
        var noDataOpts = w.config.noData;
        var graphics = new Graphics(me.ctx);
        var x = w.globals.svgWidth / 2;
        var y = w.globals.svgHeight / 2;
        var textAnchor = 'middle';
        w.globals.noData = true;
        w.globals.animationEnded = true;
        if (noDataOpts.align === 'left') {
          x = 10;
          textAnchor = 'start';
        } else if (noDataOpts.align === 'right') {
          x = w.globals.svgWidth - 10;
          textAnchor = 'end';
        }
        if (noDataOpts.verticalAlign === 'top') {
          y = 50;
        } else if (noDataOpts.verticalAlign === 'bottom') {
          y = w.globals.svgHeight - 50;
        }
        x = x + noDataOpts.offsetX;
        y = y + parseInt(noDataOpts.style.fontSize, 10) + 2 + noDataOpts.offsetY;
        if (noDataOpts.text !== undefined && noDataOpts.text !== '') {
          var titleText = graphics.drawText({
            x: x,
            y: y,
            text: noDataOpts.text,
            textAnchor: textAnchor,
            fontSize: noDataOpts.style.fontSize,
            fontFamily: noDataOpts.style.fontFamily,
            foreColor: noDataOpts.style.color,
            opacity: 1,
            class: 'apexcharts-text-nodata'
          });
          w.globals.dom.Paper.add(titleText);
        }
      }

      // When user clicks on legends, the collapsed series is filled with [0,0,0,...,0]
      // This is because we don't want to alter the series' length as it is used at many places
    }, {
      key: "setNullSeriesToZeroValues",
      value: function setNullSeriesToZeroValues(series) {
        var w = this.w;
        for (var sl = 0; sl < series.length; sl++) {
          if (series[sl].length === 0) {
            for (var j = 0; j < series[w.globals.maxValsInArrayIndex].length; j++) {
              series[sl].push(0);
            }
          }
        }
        return series;
      }
    }, {
      key: "hasAllSeriesEqualX",
      value: function hasAllSeriesEqualX() {
        var equalLen = true;
        var w = this.w;
        var filteredSerX = this.filteredSeriesX();
        for (var i = 0; i < filteredSerX.length - 1; i++) {
          if (filteredSerX[i][0] !== filteredSerX[i + 1][0]) {
            equalLen = false;
            break;
          }
        }
        w.globals.allSeriesHasEqualX = equalLen;
        return equalLen;
      }
    }, {
      key: "filteredSeriesX",
      value: function filteredSeriesX() {
        var w = this.w;
        var filteredSeriesX = w.globals.seriesX.map(function (ser) {
          return ser.length > 0 ? ser : [];
        });
        return filteredSeriesX;
      }
    }]);
    return Series;
  }();

  var Data = /*#__PURE__*/function () {
    function Data(ctx) {
      _classCallCheck(this, Data);
      this.ctx = ctx;
      this.w = ctx.w;
      this.twoDSeries = [];
      this.threeDSeries = [];
      this.twoDSeriesX = [];
      this.seriesGoals = [];
      this.coreUtils = new CoreUtils(this.ctx);
    }
    _createClass(Data, [{
      key: "isMultiFormat",
      value: function isMultiFormat() {
        return this.isFormatXY() || this.isFormat2DArray();
      }

      // given format is [{x, y}, {x, y}]
    }, {
      key: "isFormatXY",
      value: function isFormatXY() {
        var series = this.w.config.series.slice();
        var sr = new Series(this.ctx);
        this.activeSeriesIndex = sr.getActiveConfigSeriesIndex();
        if (typeof series[this.activeSeriesIndex].data !== 'undefined' && series[this.activeSeriesIndex].data.length > 0 && series[this.activeSeriesIndex].data[0] !== null && typeof series[this.activeSeriesIndex].data[0].x !== 'undefined' && series[this.activeSeriesIndex].data[0] !== null) {
          return true;
        }
      }

      // given format is [[x, y], [x, y]]
    }, {
      key: "isFormat2DArray",
      value: function isFormat2DArray() {
        var series = this.w.config.series.slice();
        var sr = new Series(this.ctx);
        this.activeSeriesIndex = sr.getActiveConfigSeriesIndex();
        if (typeof series[this.activeSeriesIndex].data !== 'undefined' && series[this.activeSeriesIndex].data.length > 0 && typeof series[this.activeSeriesIndex].data[0] !== 'undefined' && series[this.activeSeriesIndex].data[0] !== null && series[this.activeSeriesIndex].data[0].constructor === Array) {
          return true;
        }
      }
    }, {
      key: "handleFormat2DArray",
      value: function handleFormat2DArray(ser, i) {
        var cnf = this.w.config;
        var gl = this.w.globals;
        var isBoxPlot = cnf.chart.type === 'boxPlot' || cnf.series[i].type === 'boxPlot';
        for (var j = 0; j < ser[i].data.length; j++) {
          if (typeof ser[i].data[j][1] !== 'undefined') {
            if (Array.isArray(ser[i].data[j][1]) && ser[i].data[j][1].length === 4 && !isBoxPlot) {
              // candlestick nested ohlc format
              this.twoDSeries.push(Utils$1.parseNumber(ser[i].data[j][1][3]));
            } else if (ser[i].data[j].length >= 5) {
              // candlestick non-nested ohlc format
              this.twoDSeries.push(Utils$1.parseNumber(ser[i].data[j][4]));
            } else {
              this.twoDSeries.push(Utils$1.parseNumber(ser[i].data[j][1]));
            }
            gl.dataFormatXNumeric = true;
          }
          if (cnf.xaxis.type === 'datetime') {
            // if timestamps are provided and xaxis type is datetime,

            var ts = new Date(ser[i].data[j][0]);
            ts = new Date(ts).getTime();
            this.twoDSeriesX.push(ts);
          } else {
            this.twoDSeriesX.push(ser[i].data[j][0]);
          }
        }
        for (var _j = 0; _j < ser[i].data.length; _j++) {
          if (typeof ser[i].data[_j][2] !== 'undefined') {
            this.threeDSeries.push(ser[i].data[_j][2]);
            gl.isDataXYZ = true;
          }
        }
      }
    }, {
      key: "handleFormatXY",
      value: function handleFormatXY(ser, i) {
        var cnf = this.w.config;
        var gl = this.w.globals;
        var dt = new DateTime(this.ctx);
        var activeI = i;
        if (gl.collapsedSeriesIndices.indexOf(i) > -1) {
          // fix #368
          activeI = this.activeSeriesIndex;
        }

        // get series
        for (var j = 0; j < ser[i].data.length; j++) {
          if (typeof ser[i].data[j].y !== 'undefined') {
            if (Array.isArray(ser[i].data[j].y)) {
              this.twoDSeries.push(Utils$1.parseNumber(ser[i].data[j].y[ser[i].data[j].y.length - 1]));
            } else {
              this.twoDSeries.push(Utils$1.parseNumber(ser[i].data[j].y));
            }
          }
          if (typeof ser[i].data[j].goals !== 'undefined' && Array.isArray(ser[i].data[j].goals)) {
            if (typeof this.seriesGoals[i] === 'undefined') {
              this.seriesGoals[i] = [];
            }
            this.seriesGoals[i].push(ser[i].data[j].goals);
          } else {
            if (typeof this.seriesGoals[i] === 'undefined') {
              this.seriesGoals[i] = [];
            }
            this.seriesGoals[i].push(null);
          }
        }

        // get seriesX
        for (var _j2 = 0; _j2 < ser[activeI].data.length; _j2++) {
          var isXString = typeof ser[activeI].data[_j2].x === 'string';
          var isXArr = Array.isArray(ser[activeI].data[_j2].x);
          var isXDate = !isXArr && !!dt.isValidDate(ser[activeI].data[_j2].x);
          if (isXString || isXDate) {
            // user supplied '01/01/2017' or a date string (a JS date object is not supported)
            if (isXString || cnf.xaxis.convertedCatToNumeric) {
              var isRangeColumn = gl.isBarHorizontal && gl.isRangeData;
              if (cnf.xaxis.type === 'datetime' && !isRangeColumn) {
                this.twoDSeriesX.push(dt.parseDate(ser[activeI].data[_j2].x));
              } else {
                // a category and not a numeric x value
                this.fallbackToCategory = true;
                this.twoDSeriesX.push(ser[activeI].data[_j2].x);
                if (!isNaN(ser[activeI].data[_j2].x) && this.w.config.xaxis.type !== 'category' && typeof ser[activeI].data[_j2].x !== 'string') {
                  gl.isXNumeric = true;
                }
              }
            } else {
              if (cnf.xaxis.type === 'datetime') {
                this.twoDSeriesX.push(dt.parseDate(ser[activeI].data[_j2].x.toString()));
              } else {
                gl.dataFormatXNumeric = true;
                gl.isXNumeric = true;
                this.twoDSeriesX.push(parseFloat(ser[activeI].data[_j2].x));
              }
            }
          } else if (isXArr) {
            // a multiline label described in array format
            this.fallbackToCategory = true;
            this.twoDSeriesX.push(ser[activeI].data[_j2].x);
          } else {
            // a numeric value in x property
            gl.isXNumeric = true;
            gl.dataFormatXNumeric = true;
            this.twoDSeriesX.push(ser[activeI].data[_j2].x);
          }
        }
        if (ser[i].data[0] && typeof ser[i].data[0].z !== 'undefined') {
          for (var t = 0; t < ser[i].data.length; t++) {
            this.threeDSeries.push(ser[i].data[t].z);
          }
          gl.isDataXYZ = true;
        }
      }
    }, {
      key: "handleRangeData",
      value: function handleRangeData(ser, i) {
        var gl = this.w.globals;
        var range = {};
        if (this.isFormat2DArray()) {
          range = this.handleRangeDataFormat('array', ser, i);
        } else if (this.isFormatXY()) {
          range = this.handleRangeDataFormat('xy', ser, i);
        }

        // Fix: RangeArea Chart: hide all series results in a crash #3984
        gl.seriesRangeStart[i] = range.start === undefined ? [] : range.start;
        gl.seriesRangeEnd[i] = range.end === undefined ? [] : range.end;
        gl.seriesRange[i] = range.rangeUniques;

        // check for overlaps to avoid clashes in a timeline chart
        gl.seriesRange.forEach(function (sr, si) {
          if (sr) {
            sr.forEach(function (sarr, sarri) {
              sarr.y.forEach(function (arr, arri) {
                for (var sri = 0; sri < sarr.y.length; sri++) {
                  if (arri !== sri) {
                    var range1y1 = arr.y1;
                    var range1y2 = arr.y2;
                    var range2y1 = sarr.y[sri].y1;
                    var range2y2 = sarr.y[sri].y2;
                    if (range1y1 <= range2y2 && range2y1 <= range1y2) {
                      if (sarr.overlaps.indexOf(arr.rangeName) < 0) {
                        sarr.overlaps.push(arr.rangeName);
                      }
                      if (sarr.overlaps.indexOf(sarr.y[sri].rangeName) < 0) {
                        sarr.overlaps.push(sarr.y[sri].rangeName);
                      }
                    }
                  }
                }
              });
            });
          }
        });
        return range;
      }
    }, {
      key: "handleCandleStickBoxData",
      value: function handleCandleStickBoxData(ser, i) {
        var gl = this.w.globals;
        var ohlc = {};
        if (this.isFormat2DArray()) {
          ohlc = this.handleCandleStickBoxDataFormat('array', ser, i);
        } else if (this.isFormatXY()) {
          ohlc = this.handleCandleStickBoxDataFormat('xy', ser, i);
        }
        gl.seriesCandleO[i] = ohlc.o;
        gl.seriesCandleH[i] = ohlc.h;
        gl.seriesCandleM[i] = ohlc.m;
        gl.seriesCandleL[i] = ohlc.l;
        gl.seriesCandleC[i] = ohlc.c;
        return ohlc;
      }
    }, {
      key: "handleRangeDataFormat",
      value: function handleRangeDataFormat(format, ser, i) {
        var rangeStart = [];
        var rangeEnd = [];
        var uniqueKeys = ser[i].data.filter(function (thing, index, self) {
          return index === self.findIndex(function (t) {
            return t.x === thing.x;
          });
        }).map(function (r, index) {
          return {
            x: r.x,
            overlaps: [],
            y: []
          };
        });
        if (format === 'array') {
          for (var j = 0; j < ser[i].data.length; j++) {
            if (Array.isArray(ser[i].data[j])) {
              rangeStart.push(ser[i].data[j][1][0]);
              rangeEnd.push(ser[i].data[j][1][1]);
            } else {
              rangeStart.push(ser[i].data[j]);
              rangeEnd.push(ser[i].data[j]);
            }
          }
        } else if (format === 'xy') {
          var _loop = function _loop(_j3) {
            var isDataPoint2D = Array.isArray(ser[i].data[_j3].y);
            var id = Utils$1.randomId();
            var x = ser[i].data[_j3].x;
            var y = {
              y1: isDataPoint2D ? ser[i].data[_j3].y[0] : ser[i].data[_j3].y,
              y2: isDataPoint2D ? ser[i].data[_j3].y[1] : ser[i].data[_j3].y,
              rangeName: id
            };

            // CAUTION: mutating config object by adding a new property
            // TODO: As this is specifically for timeline rangebar charts, update the docs mentioning the series only supports xy format
            ser[i].data[_j3].rangeName = id;
            var uI = uniqueKeys.findIndex(function (t) {
              return t.x === x;
            });
            uniqueKeys[uI].y.push(y);
            rangeStart.push(y.y1);
            rangeEnd.push(y.y2);
          };
          for (var _j3 = 0; _j3 < ser[i].data.length; _j3++) {
            _loop(_j3);
          }
        }
        return {
          start: rangeStart,
          end: rangeEnd,
          rangeUniques: uniqueKeys
        };
      }
    }, {
      key: "handleCandleStickBoxDataFormat",
      value: function handleCandleStickBoxDataFormat(format, ser, i) {
        var w = this.w;
        var isBoxPlot = w.config.chart.type === 'boxPlot' || w.config.series[i].type === 'boxPlot';
        var serO = [];
        var serH = [];
        var serM = [];
        var serL = [];
        var serC = [];
        if (format === 'array') {
          if (isBoxPlot && ser[i].data[0].length === 6 || !isBoxPlot && ser[i].data[0].length === 5) {
            for (var j = 0; j < ser[i].data.length; j++) {
              serO.push(ser[i].data[j][1]);
              serH.push(ser[i].data[j][2]);
              if (isBoxPlot) {
                serM.push(ser[i].data[j][3]);
                serL.push(ser[i].data[j][4]);
                serC.push(ser[i].data[j][5]);
              } else {
                serL.push(ser[i].data[j][3]);
                serC.push(ser[i].data[j][4]);
              }
            }
          } else {
            for (var _j4 = 0; _j4 < ser[i].data.length; _j4++) {
              if (Array.isArray(ser[i].data[_j4][1])) {
                serO.push(ser[i].data[_j4][1][0]);
                serH.push(ser[i].data[_j4][1][1]);
                if (isBoxPlot) {
                  serM.push(ser[i].data[_j4][1][2]);
                  serL.push(ser[i].data[_j4][1][3]);
                  serC.push(ser[i].data[_j4][1][4]);
                } else {
                  serL.push(ser[i].data[_j4][1][2]);
                  serC.push(ser[i].data[_j4][1][3]);
                }
              }
            }
          }
        } else if (format === 'xy') {
          for (var _j5 = 0; _j5 < ser[i].data.length; _j5++) {
            if (Array.isArray(ser[i].data[_j5].y)) {
              serO.push(ser[i].data[_j5].y[0]);
              serH.push(ser[i].data[_j5].y[1]);
              if (isBoxPlot) {
                serM.push(ser[i].data[_j5].y[2]);
                serL.push(ser[i].data[_j5].y[3]);
                serC.push(ser[i].data[_j5].y[4]);
              } else {
                serL.push(ser[i].data[_j5].y[2]);
                serC.push(ser[i].data[_j5].y[3]);
              }
            }
          }
        }
        return {
          o: serO,
          h: serH,
          m: serM,
          l: serL,
          c: serC
        };
      }
    }, {
      key: "parseDataAxisCharts",
      value: function parseDataAxisCharts(ser) {
        var _this = this;
        var ctx = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.ctx;
        var cnf = this.w.config;
        var gl = this.w.globals;
        var dt = new DateTime(ctx);
        var xlabels = cnf.labels.length > 0 ? cnf.labels.slice() : cnf.xaxis.categories.slice();
        gl.isRangeBar = cnf.chart.type === 'rangeBar' && gl.isBarHorizontal;
        gl.hasXaxisGroups = cnf.xaxis.type === 'category' && cnf.xaxis.group.groups.length > 0;
        if (gl.hasXaxisGroups) {
          gl.groups = cnf.xaxis.group.groups;
        }
        ser.forEach(function (s, i) {
          if (s.name !== undefined) {
            gl.seriesNames.push(s.name);
          } else {
            gl.seriesNames.push('series-' + parseInt(i + 1, 10));
          }
        });
        this.coreUtils.setSeriesYAxisMappings();
        // At this point, every series that didn't have a user defined group name
        // has been given a name according to the yaxis the series is referenced by.
        // This fits the existing behaviour where all series associated with an axis
        // are defacto presented as a single group. It is now formalised.
        var buckets = [];
        var groups = _toConsumableArray(new Set(cnf.series.map(function (s) {
          return s.group;
        })));
        cnf.series.forEach(function (s, i) {
          var index = groups.indexOf(s.group);
          if (!buckets[index]) buckets[index] = [];
          buckets[index].push(gl.seriesNames[i]);
        });
        gl.seriesGroups = buckets;
        var handleDates = function handleDates() {
          for (var j = 0; j < xlabels.length; j++) {
            if (typeof xlabels[j] === 'string') {
              // user provided date strings
              var isDate = dt.isValidDate(xlabels[j]);
              if (isDate) {
                _this.twoDSeriesX.push(dt.parseDate(xlabels[j]));
              } else {
                throw new Error('You have provided invalid Date format. Please provide a valid JavaScript Date');
              }
            } else {
              // user provided timestamps
              _this.twoDSeriesX.push(xlabels[j]);
            }
          }
        };
        for (var i = 0; i < ser.length; i++) {
          this.twoDSeries = [];
          this.twoDSeriesX = [];
          this.threeDSeries = [];
          if (typeof ser[i].data === 'undefined') {
            console.error("It is a possibility that you may have not included 'data' property in series.");
            return;
          }
          if (cnf.chart.type === 'rangeBar' || cnf.chart.type === 'rangeArea' || ser[i].type === 'rangeBar' || ser[i].type === 'rangeArea') {
            gl.isRangeData = true;
            this.handleRangeData(ser, i);
          }
          if (this.isMultiFormat()) {
            if (this.isFormat2DArray()) {
              this.handleFormat2DArray(ser, i);
            } else if (this.isFormatXY()) {
              this.handleFormatXY(ser, i);
            }
            if (cnf.chart.type === 'candlestick' || ser[i].type === 'candlestick' || cnf.chart.type === 'boxPlot' || ser[i].type === 'boxPlot') {
              this.handleCandleStickBoxData(ser, i);
            }
            gl.series.push(this.twoDSeries);
            gl.labels.push(this.twoDSeriesX);
            gl.seriesX.push(this.twoDSeriesX);
            gl.seriesGoals = this.seriesGoals;
            if (i === this.activeSeriesIndex && !this.fallbackToCategory) {
              gl.isXNumeric = true;
            }
          } else {
            if (cnf.xaxis.type === 'datetime') {
              // user didn't supplied [{x,y}] or [[x,y]], but single array in data.
              // Also labels/categories were supplied differently
              gl.isXNumeric = true;
              handleDates();
              gl.seriesX.push(this.twoDSeriesX);
            } else if (cnf.xaxis.type === 'numeric') {
              gl.isXNumeric = true;
              if (xlabels.length > 0) {
                this.twoDSeriesX = xlabels;
                gl.seriesX.push(this.twoDSeriesX);
              }
            }
            gl.labels.push(this.twoDSeriesX);
            var singleArray = ser[i].data.map(function (d) {
              return Utils$1.parseNumber(d);
            });
            gl.series.push(singleArray);
          }
          gl.seriesZ.push(this.threeDSeries);

          // overrided default color if user inputs color with series data
          if (ser[i].color !== undefined) {
            gl.seriesColors.push(ser[i].color);
          } else {
            gl.seriesColors.push(undefined);
          }
        }
        return this.w;
      }
    }, {
      key: "parseDataNonAxisCharts",
      value: function parseDataNonAxisCharts(ser) {
        var gl = this.w.globals;
        var cnf = this.w.config;

        // Check if we have both old format (numeric series + labels) and new format
        var hasOldFormat = Array.isArray(ser) && ser.every(function (s) {
          return typeof s === 'number';
        }) && cnf.labels.length > 0;
        var hasNewFormat = Array.isArray(ser) && ser.some(function (s) {
          return s && _typeof(s) === 'object' && s.data || s && _typeof(s) === 'object' && s.parsing;
        });
        if (hasOldFormat && hasNewFormat) {
          console.warn('ApexCharts: Both old format (numeric series + labels) and new format (series objects with data/parsing) detected. Using old format for backward compatibility.');
        }

        // If old format exists, use it (backward compatibility priority)
        if (hasOldFormat) {
          gl.series = ser.slice();
          gl.seriesNames = cnf.labels.slice();
          for (var i = 0; i < gl.series.length; i++) {
            if (gl.seriesNames[i] === undefined) {
              gl.seriesNames.push('series-' + (i + 1));
            }
          }
          return this.w;
        }

        // Check if it's just a plain numeric array without labels (radialBar common case)
        if (Array.isArray(ser) && ser.every(function (s) {
          return typeof s === 'number';
        })) {
          gl.series = ser.slice();
          gl.seriesNames = [];
          for (var _i = 0; _i < gl.series.length; _i++) {
            gl.seriesNames.push(cnf.labels[_i] || "series-".concat(_i + 1));
          }
          return this.w;
        }
        var processedData = this.extractPieDataFromSeries(ser);
        gl.series = processedData.values;
        gl.seriesNames = processedData.labels;

        // Special handling for radialBar - ensure percentages are valid
        if (cnf.chart.type === 'radialBar') {
          gl.series = gl.series.map(function (val) {
            var numVal = Utils$1.parseNumber(val);
            if (numVal > 100) {
              console.warn("ApexCharts: RadialBar value ".concat(numVal, " > 100, consider using percentage values (0-100)"));
            }
            return numVal;
          });
        }

        // Ensure we have proper fallback names
        for (var _i2 = 0; _i2 < gl.series.length; _i2++) {
          if (gl.seriesNames[_i2] === undefined) {
            gl.seriesNames.push('series-' + (_i2 + 1));
          }
        }
        return this.w;
      }

      /**
       * Reset parsing flags to allow re-parsing of data during updates
       */
    }, {
      key: "resetParsingFlags",
      value: function resetParsingFlags() {
        var w = this.w;
        w.globals.dataWasParsed = false;
        w.globals.originalSeries = null;
        if (w.config.series) {
          w.config.series.forEach(function (serie) {
            if (serie.__apexParsed) {
              delete serie.__apexParsed;
            }
          });
        }
      }
    }, {
      key: "extractPieDataFromSeries",
      value: function extractPieDataFromSeries(ser) {
        var values = [];
        var labels = [];
        if (!Array.isArray(ser)) {
          console.warn('ApexCharts: Expected array for series data');
          return {
            values: [],
            labels: []
          };
        }
        if (ser.length === 0) {
          console.warn('ApexCharts: Empty series array');
          return {
            values: [],
            labels: []
          };
        }

        // Handle only series objects with data property
        var firstItem = ser[0];
        if (_typeof(firstItem) === 'object' && firstItem !== null && firstItem.data) {
          // Format: [{ data: [{x: 'A', y: 10}] }] or [{ data: rawData, parsing: {...} }]
          this.extractPieDataFromSeriesObjects(ser, values, labels);
        } else {
          // Unsupported format
          console.warn('ApexCharts: Unsupported series format for pie/donut/radialBar. Expected series objects with data property.');
          return {
            values: [],
            labels: []
          };
        }
        return {
          values: values,
          labels: labels
        };
      }

      // Extract data from series objects: [{ data: [...], parsing: {...} }]
    }, {
      key: "extractPieDataFromSeriesObjects",
      value: function extractPieDataFromSeriesObjects(seriesArray, values, labels) {
        seriesArray.forEach(function (serie, serieIndex) {
          if (!serie.data || !Array.isArray(serie.data)) {
            console.warn("ApexCharts: Series ".concat(serieIndex, " has no valid data array"));
            return;
          }

          // If series was already parsed by parseRawDataIfNeeded, data should be in {x, y} format
          serie.data.forEach(function (dataPoint) {
            if (_typeof(dataPoint) === 'object' && dataPoint !== null) {
              if (dataPoint.x !== undefined && dataPoint.y !== undefined) {
                labels.push(String(dataPoint.x));
                values.push(Utils$1.parseNumber(dataPoint.y));
              } else {
                console.warn('ApexCharts: Invalid data point format for pie chart. Expected {x, y} format:', dataPoint);
              }
            } else {
              console.warn('ApexCharts: Expected object data point, got:', _typeof(dataPoint));
            }
          });
        });
      }

      /** User possibly set string categories in xaxis.categories or labels prop
       * Or didn't set xaxis labels at all - in which case we manually do it.
       * If user passed series data as [[3, 2], [4, 5]] or [{ x: 3, y: 55 }],
       * this shouldn't be called
       * @param {array} ser - the series which user passed to the config
       */
    }, {
      key: "handleExternalLabelsData",
      value: function handleExternalLabelsData(ser) {
        var cnf = this.w.config;
        var gl = this.w.globals;
        if (cnf.xaxis.categories.length > 0) {
          // user provided labels in xaxis.category prop
          gl.labels = cnf.xaxis.categories;
        } else if (cnf.labels.length > 0) {
          // user provided labels in labels props
          gl.labels = cnf.labels.slice();
        } else if (this.fallbackToCategory) {
          // user provided labels in x prop in [{ x: 3, y: 55 }] data, and those labels are already stored in gl.labels[0], so just re-arrange the gl.labels array
          gl.labels = gl.labels[0];
          if (gl.seriesRange.length) {
            gl.seriesRange.map(function (srt) {
              srt.forEach(function (sr) {
                if (gl.labels.indexOf(sr.x) < 0 && sr.x) {
                  gl.labels.push(sr.x);
                }
              });
            });
            // remove duplicate x-axis labels
            gl.labels = Array.from(new Set(gl.labels.map(JSON.stringify)), JSON.parse);
          }
          if (cnf.xaxis.convertedCatToNumeric) {
            var defaults = new Defaults(cnf);
            defaults.convertCatToNumericXaxis(cnf, this.ctx, gl.seriesX[0]);
            this._generateExternalLabels(ser);
          }
        } else {
          this._generateExternalLabels(ser);
        }
      }
    }, {
      key: "_generateExternalLabels",
      value: function _generateExternalLabels(ser) {
        var gl = this.w.globals;
        var cnf = this.w.config;
        // user didn't provided any labels, fallback to 1-2-3-4-5
        var labelArr = [];
        if (gl.axisCharts) {
          if (gl.series.length > 0) {
            if (this.isFormatXY()) {
              // in case there is a combo chart (boxplot/scatter)
              // and there are duplicated x values, we need to eliminate duplicates
              var seriesDataFiltered = cnf.series.map(function (serie, s) {
                return serie.data.filter(function (v, i, a) {
                  return a.findIndex(function (t) {
                    return t.x === v.x;
                  }) === i;
                });
              });
              var len = seriesDataFiltered.reduce(function (p, c, i, a) {
                return a[p].length > c.length ? p : i;
              }, 0);
              for (var i = 0; i < seriesDataFiltered[len].length; i++) {
                labelArr.push(i + 1);
              }
            } else {
              for (var _i3 = 0; _i3 < gl.series[gl.maxValsInArrayIndex].length; _i3++) {
                labelArr.push(_i3 + 1);
              }
            }
          }
          gl.seriesX = [];
          // create gl.seriesX as it will be used in calculations of x positions
          for (var _i4 = 0; _i4 < ser.length; _i4++) {
            gl.seriesX.push(labelArr);
          }

          // turn on the isXNumeric flag to allow minX and maxX to function properly
          if (!this.w.globals.isBarHorizontal) {
            gl.isXNumeric = true;
          }
        }

        // no series to pull labels from, put a 0-10 series
        // possibly, user collapsed all series. Hence we can't work with above calc
        if (labelArr.length === 0) {
          labelArr = gl.axisCharts ? [] : gl.series.map(function (gls, glsi) {
            return glsi + 1;
          });
          for (var _i5 = 0; _i5 < ser.length; _i5++) {
            gl.seriesX.push(labelArr);
          }
        }

        // Finally, pass the labelArr in gl.labels which will be printed on x-axis
        gl.labels = labelArr;
        if (cnf.xaxis.convertedCatToNumeric) {
          gl.categoryLabels = labelArr.map(function (l) {
            return cnf.xaxis.labels.formatter(l);
          });
        }

        // Turn on this global flag to indicate no labels were provided by user
        gl.noLabelsProvided = true;
      }
    }, {
      key: "parseRawDataIfNeeded",
      value: function parseRawDataIfNeeded(series) {
        var _this2 = this;
        var cnf = this.w.config;
        var gl = this.w.globals;
        var globalParsing = cnf.parsing;

        // If data was already parsed, don't parse again
        if (gl.dataWasParsed) {
          return series;
        }

        // If no global parsing config and no series-level parsing, return as-is
        if (!globalParsing && !series.some(function (s) {
          return s.parsing;
        })) {
          return series;
        }
        var processedSeries = series.map(function (serie, index) {
          var _serie$parsing, _serie$parsing2, _serie$parsing3;
          if (!serie.data || !Array.isArray(serie.data) || serie.data.length === 0) {
            return serie;
          }

          // Resolve effective parsing config for this series
          var effectiveParsing = {
            x: ((_serie$parsing = serie.parsing) === null || _serie$parsing === void 0 ? void 0 : _serie$parsing.x) || (globalParsing === null || globalParsing === void 0 ? void 0 : globalParsing.x),
            y: ((_serie$parsing2 = serie.parsing) === null || _serie$parsing2 === void 0 ? void 0 : _serie$parsing2.y) || (globalParsing === null || globalParsing === void 0 ? void 0 : globalParsing.y),
            z: ((_serie$parsing3 = serie.parsing) === null || _serie$parsing3 === void 0 ? void 0 : _serie$parsing3.z) || (globalParsing === null || globalParsing === void 0 ? void 0 : globalParsing.z)
          };

          // If no effective parsing config, return as-is
          if (!effectiveParsing.x && !effectiveParsing.y) {
            return serie;
          }

          // Check if data is already in {x, y} format or 2D array format
          var firstDataPoint = serie.data[0];
          if (_typeof(firstDataPoint) === 'object' && firstDataPoint !== null && (firstDataPoint.hasOwnProperty('x') || firstDataPoint.hasOwnProperty('y')) || Array.isArray(firstDataPoint)) {
            return serie;
          }

          // Validate that we have both x and y parsing config
          if (!effectiveParsing.x || !effectiveParsing.y || Array.isArray(effectiveParsing.y) && effectiveParsing.y.length === 0) {
            console.warn("ApexCharts: Series ".concat(index, " has parsing config but missing x or y field specification"));
            return serie;
          }

          // Transform raw data to {x, y} format
          var transformedData = serie.data.map(function (item, itemIndex) {
            if (_typeof(item) !== 'object' || item === null) {
              console.warn("ApexCharts: Series ".concat(index, ", data point ").concat(itemIndex, " is not an object, skipping parsing"));
              return item;
            }
            var x = _this2.getNestedValue(item, effectiveParsing.x);
            var y;
            var z = undefined;
            if (Array.isArray(effectiveParsing.y)) {
              var yValues = effectiveParsing.y.map(function (fieldName) {
                return _this2.getNestedValue(item, fieldName);
              });
              if (_this2.w.config.chart.type === 'bubble' && yValues.length === 2) {
                // For bubble: [y-value, z-value] → y = yValues[0], z = yValues[1]
                y = yValues[0];
              } else {
                y = yValues;
              }
            } else {
              y = _this2.getNestedValue(item, effectiveParsing.y);
            }

            // explicit z field for bubble charts
            if (effectiveParsing.z) {
              z = _this2.getNestedValue(item, effectiveParsing.z);
            }

            // Warn if fields don't exist
            if (x === undefined) {
              console.warn("ApexCharts: Series ".concat(index, ", data point ").concat(itemIndex, " missing field '").concat(effectiveParsing.x, "'"));
            }
            if (y === undefined) {
              console.warn("ApexCharts: Series ".concat(index, ", data point ").concat(itemIndex, " missing field '").concat(effectiveParsing.y, "'"));
            }
            var result = {
              x: x,
              y: y
            };
            if (_this2.w.config.chart.type === 'bubble' && Array.isArray(effectiveParsing.y) && effectiveParsing.y.length === 2) {
              var zValue = _this2.getNestedValue(item, effectiveParsing.y[1]);
              if (zValue !== undefined) {
                result.z = zValue;
              }
            }
            if (z !== undefined) {
              result.z = z;
            }
            return result;
          });
          return _objectSpread2(_objectSpread2({}, serie), {}, {
            data: transformedData,
            __apexParsed: true
          });
        });

        // Mark that data was parsed
        gl.dataWasParsed = true;
        if (!gl.originalSeries) {
          gl.originalSeries = Utils$1.clone(series);
        }
        return processedSeries;
      }

      /**
       * Get nested object value using dot notation path
       * @param {Object} obj - The object to search in
       * @param {string} path - Dot notation path (e.g., 'user.profile.name')
       * @returns {*} The value at the path, or undefined if not found
       */
    }, {
      key: "getNestedValue",
      value: function getNestedValue(obj, path) {
        if (!obj || _typeof(obj) !== 'object' || !path) {
          return undefined;
        }

        // Handle simple property access (no dots)
        if (path.indexOf('.') === -1) {
          return obj[path];
        }

        // Handle nested property access
        var keys = path.split('.');
        var current = obj;
        for (var i = 0; i < keys.length; i++) {
          if (current === null || current === undefined || _typeof(current) !== 'object') {
            return undefined;
          }
          current = current[keys[i]];
        }
        return current;
      }

      // Segregate user provided data into appropriate vars
    }, {
      key: "parseData",
      value: function parseData(ser) {
        var w = this.w;
        var cnf = w.config;
        var gl = w.globals;
        ser = this.parseRawDataIfNeeded(ser);
        cnf.series = ser;
        gl.initialSeries = Utils$1.clone(ser);
        this.excludeCollapsedSeriesInYAxis();

        // If we detected string in X prop of series, we fallback to category x-axis
        this.fallbackToCategory = false;
        this.ctx.core.resetGlobals();
        this.ctx.core.isMultipleY();
        if (gl.axisCharts) {
          // axisCharts includes line / area / column / scatter
          this.parseDataAxisCharts(ser);
          this.coreUtils.getLargestSeries();
        } else {
          // non-axis charts are pie / donut
          this.parseDataNonAxisCharts(ser);
        }

        // set Null values to 0 in all series when user hides/shows some series
        if (cnf.chart.stacked) {
          var series = new Series(this.ctx);
          gl.series = series.setNullSeriesToZeroValues(gl.series);
        }
        this.coreUtils.getSeriesTotals();
        if (gl.axisCharts) {
          gl.stackedSeriesTotals = this.coreUtils.getStackedSeriesTotals();
          gl.stackedSeriesTotalsByGroups = this.coreUtils.getStackedSeriesTotalsByGroups();
        }
        this.coreUtils.getPercentSeries();
        if (!gl.dataFormatXNumeric && (!gl.isXNumeric || cnf.xaxis.type === 'numeric' && cnf.labels.length === 0 && cnf.xaxis.categories.length === 0)) {
          // x-axis labels couldn't be detected; hence try searching every option in config
          this.handleExternalLabelsData(ser);
        }

        // check for multiline xaxis
        var catLabels = this.coreUtils.getCategoryLabels(gl.labels);
        for (var l = 0; l < catLabels.length; l++) {
          if (Array.isArray(catLabels[l])) {
            gl.isMultiLineX = true;
            break;
          }
        }
      }
    }, {
      key: "excludeCollapsedSeriesInYAxis",
      value: function excludeCollapsedSeriesInYAxis() {
        var w = this.w;
        // Post revision 3.46.0 there is no longer a strict one-to-one
        // correspondence between series and Y axes.
        // An axis can be ignored only while all series referenced by it
        // are collapsed.
        var yAxisIndexes = [];
        w.globals.seriesYAxisMap.forEach(function (yAxisArr, yi) {
          var collapsedCount = 0;
          yAxisArr.forEach(function (seriesIndex) {
            if (w.globals.collapsedSeriesIndices.indexOf(seriesIndex) !== -1) {
              collapsedCount++;
            }
          });
          // It's possible to have a yaxis that doesn't reference any series yet,
          // eg, because there are no series' yet, so don't list it as ignored
          // prematurely.
          if (collapsedCount > 0 && collapsedCount == yAxisArr.length) {
            yAxisIndexes.push(yi);
          }
        });
        w.globals.ignoreYAxisIndexes = yAxisIndexes.map(function (x) {
          return x;
        });
      }
    }]);
    return Data;
  }();

  var Exports = /*#__PURE__*/function () {
    function Exports(ctx) {
      _classCallCheck(this, Exports);
      this.ctx = ctx;
      this.w = ctx.w;
    }
    _createClass(Exports, [{
      key: "svgStringToNode",
      value: function svgStringToNode(svgString) {
        var parser = new DOMParser();
        var svgDoc = parser.parseFromString(svgString, 'image/svg+xml');
        return svgDoc.documentElement;
      }
    }, {
      key: "scaleSvgNode",
      value: function scaleSvgNode(svg, scale) {
        // get current both width and height of the svg
        var svgWidth = parseFloat(svg.getAttributeNS(null, 'width'));
        var svgHeight = parseFloat(svg.getAttributeNS(null, 'height'));
        // set new width and height based on the scale
        svg.setAttributeNS(null, 'width', svgWidth * scale);
        svg.setAttributeNS(null, 'height', svgHeight * scale);
        svg.setAttributeNS(null, 'viewBox', '0 0 ' + svgWidth + ' ' + svgHeight);
      }
    }, {
      key: "getSvgString",
      value: function getSvgString(_scale) {
        var _this = this;
        return new Promise(function (resolve) {
          var w = _this.w;
          var scale = _scale || w.config.chart.toolbar.export.scale || w.config.chart.toolbar.export.width / w.globals.svgWidth;
          if (!scale) {
            scale = 1; // if no scale is specified, don't scale...
          }
          var width = w.globals.svgWidth * scale;
          var height = w.globals.svgHeight * scale;
          var clonedNode = w.globals.dom.elWrap.cloneNode(true);
          clonedNode.style.width = width + 'px';
          clonedNode.style.height = height + 'px';
          var serializedNode = new XMLSerializer().serializeToString(clonedNode);

          // Check if legend is shown and should be included in export
          var shouldIncludeLegendStyles = w.config.legend.show && w.globals.dom.elLegendWrap && w.globals.dom.elLegendWrap.children.length > 0;

          // Base styles for export
          var exportStyles = "\n        .apexcharts-tooltip, .apexcharts-toolbar, .apexcharts-xaxistooltip, .apexcharts-yaxistooltip, .apexcharts-xcrosshairs, .apexcharts-ycrosshairs, .apexcharts-zoom-rect, .apexcharts-selection-rect {\n          display: none;\n        }\n      ";

          // Add legend styles if legend is shown
          if (shouldIncludeLegendStyles) {
            exportStyles += css_248z$1;
          }
          var svgString = "\n        <svg xmlns=\"http://www.w3.org/2000/svg\"\n          version=\"1.1\"\n          xmlns:xlink=\"http://www.w3.org/1999/xlink\"\n          class=\"apexcharts-svg\"\n          xmlns:data=\"ApexChartsNS\"\n          transform=\"translate(0, 0)\"\n          width=\"".concat(w.globals.svgWidth, "px\" height=\"").concat(w.globals.svgHeight, "px\">\n          <foreignObject width=\"100%\" height=\"100%\">\n            <div xmlns=\"http://www.w3.org/1999/xhtml\" style=\"width:").concat(width, "px; height:").concat(height, "px;\">\n            <style type=\"text/css\">\n              ").concat(exportStyles, "\n            </style>\n              ").concat(serializedNode, "\n            </div>\n          </foreignObject>\n        </svg>\n      ");
          var svgNode = _this.svgStringToNode(svgString);
          if (scale !== 1) {
            // scale the image
            _this.scaleSvgNode(svgNode, scale);
          }
          _this.convertImagesToBase64(svgNode).then(function () {
            svgString = new XMLSerializer().serializeToString(svgNode);
            resolve(svgString.replace(/&nbsp;/g, '&#160;'));
          });
        });
      }
    }, {
      key: "convertImagesToBase64",
      value: function convertImagesToBase64(svgNode) {
        var _this2 = this;
        var images = svgNode.getElementsByTagName('image');
        var promises = Array.from(images).map(function (img) {
          var href = img.getAttributeNS('http://www.w3.org/1999/xlink', 'href');
          if (href && !href.startsWith('data:')) {
            return _this2.getBase64FromUrl(href).then(function (base64) {
              img.setAttributeNS('http://www.w3.org/1999/xlink', 'href', base64);
            }).catch(function (error) {
              console.error('Error converting image to base64:', error);
            });
          }
          return Promise.resolve();
        });
        return Promise.all(promises);
      }
    }, {
      key: "getBase64FromUrl",
      value: function getBase64FromUrl(url) {
        return new Promise(function (resolve, reject) {
          var img = new Image();
          img.crossOrigin = 'Anonymous';
          img.onload = function () {
            var canvas = document.createElement('canvas');
            canvas.width = img.width;
            canvas.height = img.height;
            var ctx = canvas.getContext('2d');
            ctx.drawImage(img, 0, 0);
            resolve(canvas.toDataURL());
          };
          img.onerror = reject;
          img.src = url;
        });
      }
    }, {
      key: "svgUrl",
      value: function svgUrl() {
        var _this3 = this;
        return new Promise(function (resolve) {
          _this3.getSvgString().then(function (svgData) {
            var svgBlob = new Blob([svgData], {
              type: 'image/svg+xml;charset=utf-8'
            });
            resolve(URL.createObjectURL(svgBlob));
          });
        });
      }
    }, {
      key: "dataURI",
      value: function dataURI(options) {
        var _this4 = this;
        return new Promise(function (resolve) {
          var w = _this4.w;
          var scale = options ? options.scale || options.width / w.globals.svgWidth : 1;
          var canvas = document.createElement('canvas');
          canvas.width = w.globals.svgWidth * scale;
          canvas.height = parseInt(w.globals.dom.elWrap.style.height, 10) * scale; // because of resizeNonAxisCharts

          var canvasBg = w.config.chart.background === 'transparent' || !w.config.chart.background ? '#fff' : w.config.chart.background;
          var ctx = canvas.getContext('2d');
          ctx.fillStyle = canvasBg;
          ctx.fillRect(0, 0, canvas.width * scale, canvas.height * scale);
          _this4.getSvgString(scale).then(function (svgData) {
            var svgUrl = 'data:image/svg+xml,' + encodeURIComponent(svgData);
            var img = new Image();
            img.crossOrigin = 'anonymous';
            img.onload = function () {
              ctx.drawImage(img, 0, 0);
              if (canvas.msToBlob) {
                // Microsoft Edge can't navigate to data urls, so we return the blob instead
                var blob = canvas.msToBlob();
                resolve({
                  blob: blob
                });
              } else {
                var imgURI = canvas.toDataURL('image/png');
                resolve({
                  imgURI: imgURI
                });
              }
            };
            img.src = svgUrl;
          });
        });
      }
    }, {
      key: "exportToSVG",
      value: function exportToSVG() {
        var _this5 = this;
        this.svgUrl().then(function (url) {
          _this5.triggerDownload(url, _this5.w.config.chart.toolbar.export.svg.filename, '.svg');
        });
      }
    }, {
      key: "exportToPng",
      value: function exportToPng() {
        var _this6 = this;
        var scale = this.w.config.chart.toolbar.export.scale;
        var width = this.w.config.chart.toolbar.export.width;
        var option = scale ? {
          scale: scale
        } : width ? {
          width: width
        } : undefined;
        this.dataURI(option).then(function (_ref) {
          var imgURI = _ref.imgURI,
            blob = _ref.blob;
          if (blob) {
            navigator.msSaveOrOpenBlob(blob, _this6.w.globals.chartID + '.png');
          } else {
            _this6.triggerDownload(imgURI, _this6.w.config.chart.toolbar.export.png.filename, '.png');
          }
        });
      }
    }, {
      key: "exportToCSV",
      value: function exportToCSV(_ref2) {
        var _this7 = this;
        var series = _ref2.series,
          fileName = _ref2.fileName,
          _ref2$columnDelimiter = _ref2.columnDelimiter,
          columnDelimiter = _ref2$columnDelimiter === void 0 ? ',' : _ref2$columnDelimiter,
          _ref2$lineDelimiter = _ref2.lineDelimiter,
          lineDelimiter = _ref2$lineDelimiter === void 0 ? '\n' : _ref2$lineDelimiter;
        var w = this.w;
        if (!series) series = w.config.series;
        var columns = [];
        var rows = [];
        var result = '';
        var universalBOM = "\uFEFF";
        var gSeries = w.globals.series.map(function (s, i) {
          return w.globals.collapsedSeriesIndices.indexOf(i) === -1 ? s : [];
        });
        var getFormattedCategory = function getFormattedCategory(cat) {
          if (typeof w.config.chart.toolbar.export.csv.categoryFormatter === 'function') {
            return w.config.chart.toolbar.export.csv.categoryFormatter(cat);
          }
          if (w.config.xaxis.type === 'datetime' && String(cat).length >= 10) {
            return new Date(cat).toDateString();
          }
          return Utils$1.isNumber(cat) ? cat : cat.split(columnDelimiter).join('');
        };
        var getFormattedValue = function getFormattedValue(value) {
          return typeof w.config.chart.toolbar.export.csv.valueFormatter === 'function' ? w.config.chart.toolbar.export.csv.valueFormatter(value) : value;
        };
        var seriesMaxDataLength = Math.max.apply(Math, _toConsumableArray(series.map(function (s) {
          return s.data ? s.data.length : 0;
        })));
        var dataFormat = new Data(this.ctx);
        var axesUtils = new AxesUtils(this.ctx);
        var getCat = function getCat(i) {
          var cat = '';

          // pie / donut/ radial
          if (!w.globals.axisCharts) {
            cat = w.config.labels[i];
          } else {
            // xy charts

            // non datetime
            if (w.config.xaxis.type === 'category' || w.config.xaxis.convertedCatToNumeric) {
              if (w.globals.isBarHorizontal) {
                var lbFormatter = w.globals.yLabelFormatters[0];
                var sr = new Series(_this7.ctx);
                var activeSeries = sr.getActiveConfigSeriesIndex();
                cat = lbFormatter(w.globals.labels[i], {
                  seriesIndex: activeSeries,
                  dataPointIndex: i,
                  w: w
                });
              } else {
                cat = axesUtils.getLabel(w.globals.labels, w.globals.timescaleLabels, 0, i).text;
              }
            }

            // datetime, but labels specified in categories or labels
            if (w.config.xaxis.type === 'datetime') {
              if (w.config.xaxis.categories.length) {
                cat = w.config.xaxis.categories[i];
              } else if (w.config.labels.length) {
                cat = w.config.labels[i];
              }
            }
          }

          // let the caller know the current category is null. this can happen for example
          // when dealing with line charts having inconsistent time series data
          if (cat === null) return 'nullvalue';
          if (Array.isArray(cat)) {
            cat = cat.join(' ');
          }
          return Utils$1.isNumber(cat) ? cat : cat.split(columnDelimiter).join('');
        };

        // Fix https://github.com/apexcharts/apexcharts.js/issues/3365
        var getEmptyDataForCsvColumn = function getEmptyDataForCsvColumn() {
          return _toConsumableArray(Array(seriesMaxDataLength)).map(function () {
            return '';
          });
        };
        var handleAxisRowsColumns = function handleAxisRowsColumns(s, sI) {
          if (columns.length && sI === 0) {
            // It's the first series.  Go ahead and create the first row with header information.
            rows.push(columns.join(columnDelimiter));
          }
          if (s.data) {
            // Use the data we have, or generate a properly sized empty array with empty data if some data is missing.
            s.data = s.data.length && s.data || getEmptyDataForCsvColumn();
            for (var i = 0; i < s.data.length; i++) {
              // Reset the columns array so that we can start building columns for this row.
              columns = [];
              var cat = getCat(i);

              // current category is null, let's move on to the next one
              if (cat === 'nullvalue') continue;
              if (!cat) {
                if (dataFormat.isFormatXY()) {
                  cat = series[sI].data[i].x;
                } else if (dataFormat.isFormat2DArray()) {
                  cat = series[sI].data[i] ? series[sI].data[i][0] : '';
                }
              }
              if (sI === 0) {
                // It's the first series.  Also handle the category.
                columns.push(getFormattedCategory(cat));
                for (var ci = 0; ci < w.globals.series.length; ci++) {
                  var _series$ci$data$i;
                  var value = dataFormat.isFormatXY() ? (_series$ci$data$i = series[ci].data[i]) === null || _series$ci$data$i === void 0 ? void 0 : _series$ci$data$i.y : gSeries[ci][i];
                  columns.push(getFormattedValue(value));
                }
              }
              if (w.config.chart.type === 'candlestick' || s.type && s.type === 'candlestick') {
                columns.pop();
                columns.push(w.globals.seriesCandleO[sI][i]);
                columns.push(w.globals.seriesCandleH[sI][i]);
                columns.push(w.globals.seriesCandleL[sI][i]);
                columns.push(w.globals.seriesCandleC[sI][i]);
              }
              if (w.config.chart.type === 'boxPlot' || s.type && s.type === 'boxPlot') {
                columns.pop();
                columns.push(w.globals.seriesCandleO[sI][i]);
                columns.push(w.globals.seriesCandleH[sI][i]);
                columns.push(w.globals.seriesCandleM[sI][i]);
                columns.push(w.globals.seriesCandleL[sI][i]);
                columns.push(w.globals.seriesCandleC[sI][i]);
              }
              if (w.config.chart.type === 'rangeBar') {
                columns.pop();
                columns.push(w.globals.seriesRangeStart[sI][i]);
                columns.push(w.globals.seriesRangeEnd[sI][i]);
              }
              if (columns.length) {
                rows.push(columns.join(columnDelimiter));
              }
            }
          }
        };
        var handleUnequalXValues = function handleUnequalXValues() {
          var categories = new Set();
          var data = {};
          series.forEach(function (s, sI) {
            s === null || s === void 0 ? void 0 : s.data.forEach(function (dataItem) {
              var cat, value;
              if (dataFormat.isFormatXY()) {
                cat = dataItem.x;
                value = dataItem.y;
              } else if (dataFormat.isFormat2DArray()) {
                cat = dataItem[0];
                value = dataItem[1];
              } else {
                return;
              }
              if (!data[cat]) {
                data[cat] = Array(series.length).fill('');
              }
              data[cat][sI] = getFormattedValue(value);
              categories.add(cat);
            });
          });
          if (columns.length) {
            rows.push(columns.join(columnDelimiter));
          }
          Array.from(categories).sort().forEach(function (cat) {
            rows.push([getFormattedCategory(cat), data[cat].join(columnDelimiter)]);
          });
        };
        columns.push(w.config.chart.toolbar.export.csv.headerCategory);
        if (w.config.chart.type === 'boxPlot') {
          columns.push('minimum');
          columns.push('q1');
          columns.push('median');
          columns.push('q3');
          columns.push('maximum');
        } else if (w.config.chart.type === 'candlestick') {
          columns.push('open');
          columns.push('high');
          columns.push('low');
          columns.push('close');
        } else if (w.config.chart.type === 'rangeBar') {
          columns.push('minimum');
          columns.push('maximum');
        } else {
          series.map(function (s, sI) {
            var sname = (s.name ? s.name : "series-".concat(sI)) + '';
            if (w.globals.axisCharts) {
              columns.push(sname.split(columnDelimiter).join('') ? sname.split(columnDelimiter).join('') : "series-".concat(sI));
            }
          });
        }
        if (!w.globals.axisCharts) {
          columns.push(w.config.chart.toolbar.export.csv.headerValue);
          rows.push(columns.join(columnDelimiter));
        }
        if (!w.globals.allSeriesHasEqualX && w.globals.axisCharts && !w.config.xaxis.categories.length && !w.config.labels.length) {
          handleUnequalXValues();
        } else {
          series.map(function (s, sI) {
            if (w.globals.axisCharts) {
              handleAxisRowsColumns(s, sI);
            } else {
              columns = [];
              columns.push(getFormattedCategory(w.globals.labels[sI]));
              columns.push(getFormattedValue(gSeries[sI]));
              rows.push(columns.join(columnDelimiter));
            }
          });
        }
        result += rows.join(lineDelimiter);
        this.triggerDownload('data:text/csv; charset=utf-8,' + encodeURIComponent(universalBOM + result), fileName ? fileName : w.config.chart.toolbar.export.csv.filename, '.csv');
      }
    }, {
      key: "triggerDownload",
      value: function triggerDownload(href, filename, ext) {
        var downloadLink = document.createElement('a');
        downloadLink.href = href;
        downloadLink.download = (filename ? filename : this.w.globals.chartID) + ext;
        document.body.appendChild(downloadLink);
        downloadLink.click();
        document.body.removeChild(downloadLink);
      }
    }]);
    return Exports;
  }();

  /**
   * ApexCharts XAxis Class for drawing X-Axis.
   *
   * @module XAxis
   **/
  var XAxis = /*#__PURE__*/function () {
    function XAxis(ctx, elgrid) {
      _classCallCheck(this, XAxis);
      this.ctx = ctx;
      this.elgrid = elgrid;
      this.w = ctx.w;
      var w = this.w;
      this.axesUtils = new AxesUtils(ctx);
      this.xaxisLabels = w.globals.labels.slice();
      if (w.globals.timescaleLabels.length > 0 && !w.globals.isBarHorizontal) {
        //  timeline labels are there and chart is not rangeabr timeline
        this.xaxisLabels = w.globals.timescaleLabels.slice();
      }
      if (w.config.xaxis.overwriteCategories) {
        this.xaxisLabels = w.config.xaxis.overwriteCategories;
      }
      this.drawnLabels = [];
      this.drawnLabelsRects = [];
      if (w.config.xaxis.position === 'top') {
        this.offY = 0;
      } else {
        this.offY = w.globals.gridHeight;
      }
      this.offY = this.offY + w.config.xaxis.axisBorder.offsetY;
      this.isCategoryBarHorizontal = w.config.chart.type === 'bar' && w.config.plotOptions.bar.horizontal;
      this.xaxisFontSize = w.config.xaxis.labels.style.fontSize;
      this.xaxisFontFamily = w.config.xaxis.labels.style.fontFamily;
      this.xaxisForeColors = w.config.xaxis.labels.style.colors;
      this.xaxisBorderWidth = w.config.xaxis.axisBorder.width;
      if (this.isCategoryBarHorizontal) {
        this.xaxisBorderWidth = w.config.yaxis[0].axisBorder.width.toString();
      }
      if (String(this.xaxisBorderWidth).indexOf('%') > -1) {
        this.xaxisBorderWidth = w.globals.gridWidth * parseInt(this.xaxisBorderWidth, 10) / 100;
      } else {
        this.xaxisBorderWidth = parseInt(this.xaxisBorderWidth, 10);
      }
      this.xaxisBorderHeight = w.config.xaxis.axisBorder.height;

      // For bars, we will only consider single y xais,
      // as we are not providing multiple yaxis for bar charts
      this.yaxis = w.config.yaxis[0];
    }
    _createClass(XAxis, [{
      key: "drawXaxis",
      value: function drawXaxis() {
        var w = this.w;
        var graphics = new Graphics(this.ctx);
        var elXaxis = graphics.group({
          class: 'apexcharts-xaxis',
          transform: "translate(".concat(w.config.xaxis.offsetX, ", ").concat(w.config.xaxis.offsetY, ")")
        });
        var elXaxisTexts = graphics.group({
          class: 'apexcharts-xaxis-texts-g',
          transform: "translate(".concat(w.globals.translateXAxisX, ", ").concat(w.globals.translateXAxisY, ")")
        });
        elXaxis.add(elXaxisTexts);
        var labels = [];
        for (var i = 0; i < this.xaxisLabels.length; i++) {
          labels.push(this.xaxisLabels[i]);
        }
        this.drawXAxisLabelAndGroup(true, graphics, elXaxisTexts, labels, w.globals.isXNumeric, function (i, colWidth) {
          return colWidth;
        });
        if (w.globals.hasXaxisGroups) {
          var labelsGroup = w.globals.groups;
          labels = [];
          for (var _i = 0; _i < labelsGroup.length; _i++) {
            labels.push(labelsGroup[_i].title);
          }
          var overwriteStyles = {};
          if (w.config.xaxis.group.style) {
            overwriteStyles.xaxisFontSize = w.config.xaxis.group.style.fontSize;
            overwriteStyles.xaxisFontFamily = w.config.xaxis.group.style.fontFamily;
            overwriteStyles.xaxisForeColors = w.config.xaxis.group.style.colors;
            overwriteStyles.fontWeight = w.config.xaxis.group.style.fontWeight;
            overwriteStyles.cssClass = w.config.xaxis.group.style.cssClass;
          }
          this.drawXAxisLabelAndGroup(false, graphics, elXaxisTexts, labels, false, function (i, colWidth) {
            return labelsGroup[i].cols * colWidth;
          }, overwriteStyles);
        }
        if (w.config.xaxis.title.text !== undefined) {
          var elXaxisTitle = graphics.group({
            class: 'apexcharts-xaxis-title'
          });
          var elXAxisTitleText = graphics.drawText({
            x: w.globals.gridWidth / 2 + w.config.xaxis.title.offsetX,
            y: this.offY + parseFloat(this.xaxisFontSize) + (w.config.xaxis.position === 'bottom' ? w.globals.xAxisLabelsHeight : -w.globals.xAxisLabelsHeight - 10) + w.config.xaxis.title.offsetY,
            text: w.config.xaxis.title.text,
            textAnchor: 'middle',
            fontSize: w.config.xaxis.title.style.fontSize,
            fontFamily: w.config.xaxis.title.style.fontFamily,
            fontWeight: w.config.xaxis.title.style.fontWeight,
            foreColor: w.config.xaxis.title.style.color,
            cssClass: 'apexcharts-xaxis-title-text ' + w.config.xaxis.title.style.cssClass
          });
          elXaxisTitle.add(elXAxisTitleText);
          elXaxis.add(elXaxisTitle);
        }
        if (w.config.xaxis.axisBorder.show) {
          var offX = w.globals.barPadForNumericAxis;
          var elHorzLine = graphics.drawLine(w.globals.padHorizontal + w.config.xaxis.axisBorder.offsetX - offX, this.offY, this.xaxisBorderWidth + offX, this.offY, w.config.xaxis.axisBorder.color, 0, this.xaxisBorderHeight);
          if (this.elgrid && this.elgrid.elGridBorders && w.config.grid.show) {
            this.elgrid.elGridBorders.add(elHorzLine);
          } else {
            elXaxis.add(elHorzLine);
          }
        }
        return elXaxis;
      }
    }, {
      key: "drawXAxisLabelAndGroup",
      value: function drawXAxisLabelAndGroup(isLeafGroup, graphics, elXaxisTexts, labels, isXNumeric, colWidthCb) {
        var _this = this;
        var overwriteStyles = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : {};
        var drawnLabels = [];
        var drawnLabelsRects = [];
        var w = this.w;
        var xaxisFontSize = overwriteStyles.xaxisFontSize || this.xaxisFontSize;
        var xaxisFontFamily = overwriteStyles.xaxisFontFamily || this.xaxisFontFamily;
        var xaxisForeColors = overwriteStyles.xaxisForeColors || this.xaxisForeColors;
        var fontWeight = overwriteStyles.fontWeight || w.config.xaxis.labels.style.fontWeight;
        var cssClass = overwriteStyles.cssClass || w.config.xaxis.labels.style.cssClass;
        var colWidth;

        // initial x Position (keep adding column width in the loop)
        var xPos = w.globals.padHorizontal;
        var labelsLen = labels.length;

        /**
         * labelsLen can be different (whether you are drawing x-axis labels or x-axis group labels)
         * hence, we introduce dataPoints to be consistent.
         * Also, in datetime/numeric xaxis, dataPoints can be misleading, so we resort to labelsLen for such xaxis type
         */
        var dataPoints = w.config.xaxis.type === 'category' ? w.globals.dataPoints : labelsLen;

        // when all series are collapsed, fixes #3381
        if (dataPoints === 0 && labelsLen > dataPoints) dataPoints = labelsLen;
        if (isXNumeric) {
          var len = Math.max(Number(w.config.xaxis.tickAmount) || 1, dataPoints > 1 ? dataPoints - 1 : dataPoints);
          colWidth = w.globals.gridWidth / Math.min(len, labelsLen - 1);
          xPos = xPos + colWidthCb(0, colWidth) / 2 + w.config.xaxis.labels.offsetX;
        } else {
          colWidth = w.globals.gridWidth / dataPoints;
          xPos = xPos + colWidthCb(0, colWidth) + w.config.xaxis.labels.offsetX;
        }
        var _loop = function _loop(i) {
          var x = xPos - colWidthCb(i, colWidth) / 2 + w.config.xaxis.labels.offsetX;
          if (i === 0 && labelsLen === 1 && colWidth / 2 === xPos && dataPoints === 1) {
            // single datapoint
            x = w.globals.gridWidth / 2;
          }
          var label = _this.axesUtils.getLabel(labels, w.globals.timescaleLabels, x, i, drawnLabels, xaxisFontSize, isLeafGroup);
          var offsetYCorrection = 28;
          if (w.globals.rotateXLabels && isLeafGroup) {
            offsetYCorrection = 22;
          }
          if (w.config.xaxis.title.text && w.config.xaxis.position === 'top') {
            offsetYCorrection += parseFloat(w.config.xaxis.title.style.fontSize) + 2;
          }
          if (!isLeafGroup) {
            offsetYCorrection = offsetYCorrection + parseFloat(xaxisFontSize) + (w.globals.xAxisLabelsHeight - w.globals.xAxisGroupLabelsHeight) + (w.globals.rotateXLabels ? 10 : 0);
          }
          var isCategoryTickAmounts = typeof w.config.xaxis.tickAmount !== 'undefined' && w.config.xaxis.tickAmount !== 'dataPoints' && w.config.xaxis.type !== 'datetime';
          if (isCategoryTickAmounts) {
            label = _this.axesUtils.checkLabelBasedOnTickamount(i, label, labelsLen);
          } else {
            label = _this.axesUtils.checkForOverflowingLabels(i, label, labelsLen, drawnLabels, drawnLabelsRects);
          }
          var getCatForeColor = function getCatForeColor() {
            return isLeafGroup && w.config.xaxis.convertedCatToNumeric ? xaxisForeColors[w.globals.minX + i - 1] : xaxisForeColors[i];
          };
          if (w.config.xaxis.labels.show) {
            var elText = graphics.drawText({
              x: label.x,
              y: _this.offY + w.config.xaxis.labels.offsetY + offsetYCorrection - (w.config.xaxis.position === 'top' ? w.globals.xAxisHeight + w.config.xaxis.axisTicks.height - 2 : 0),
              text: label.text,
              textAnchor: 'middle',
              fontWeight: label.isBold ? 600 : fontWeight,
              fontSize: xaxisFontSize,
              fontFamily: xaxisFontFamily,
              foreColor: Array.isArray(xaxisForeColors) ? getCatForeColor() : xaxisForeColors,
              isPlainText: false,
              cssClass: (isLeafGroup ? 'apexcharts-xaxis-label ' : 'apexcharts-xaxis-group-label ') + cssClass
            });
            elXaxisTexts.add(elText);
            elText.on('click', function (e) {
              if (typeof w.config.chart.events.xAxisLabelClick === 'function') {
                var opts = Object.assign({}, w, {
                  labelIndex: i
                });
                w.config.chart.events.xAxisLabelClick(e, _this.ctx, opts);
              }
            });
            if (isLeafGroup) {
              var elTooltipTitle = document.createElementNS(w.globals.SVGNS, 'title');
              elTooltipTitle.textContent = Array.isArray(label.text) ? label.text.join(' ') : label.text;
              elText.node.appendChild(elTooltipTitle);
              if (label.text !== '') {
                drawnLabels.push(label.text);
                drawnLabelsRects.push(label);
              }
            }
          }
          if (i < labelsLen - 1) {
            xPos = xPos + colWidthCb(i + 1, colWidth);
          }
        };
        for (var i = 0; i <= labelsLen - 1; i++) {
          _loop(i);
        }
      }

      // this actually becomes the vertical axis (for bar charts)
    }, {
      key: "drawXaxisInversed",
      value: function drawXaxisInversed(realIndex) {
        var _this2 = this;
        var w = this.w;
        var graphics = new Graphics(this.ctx);
        var translateYAxisX = w.config.yaxis[0].opposite ? w.globals.translateYAxisX[realIndex] : 0;
        var elYaxis = graphics.group({
          class: 'apexcharts-yaxis apexcharts-xaxis-inversed',
          rel: realIndex
        });
        var elYaxisTexts = graphics.group({
          class: 'apexcharts-yaxis-texts-g apexcharts-xaxis-inversed-texts-g',
          transform: 'translate(' + translateYAxisX + ', 0)'
        });
        elYaxis.add(elYaxisTexts);
        var colHeight;

        // initial x Position (keep adding column width in the loop)
        var yPos;
        var labels = [];
        if (w.config.yaxis[realIndex].show) {
          for (var i = 0; i < this.xaxisLabels.length; i++) {
            labels.push(this.xaxisLabels[i]);
          }
        }
        colHeight = w.globals.gridHeight / labels.length;
        yPos = -(colHeight / 2.2);
        var lbFormatter = w.globals.yLabelFormatters[0];
        var ylabels = w.config.yaxis[0].labels;
        if (ylabels.show) {
          var _loop2 = function _loop2(_i2) {
            var label = typeof labels[_i2] === 'undefined' ? '' : labels[_i2];
            label = lbFormatter(label, {
              seriesIndex: realIndex,
              dataPointIndex: _i2,
              w: w
            });
            var yColors = _this2.axesUtils.getYAxisForeColor(ylabels.style.colors, realIndex);
            var getForeColor = function getForeColor() {
              return Array.isArray(yColors) ? yColors[_i2] : yColors;
            };
            var multiY = 0;
            if (Array.isArray(label)) {
              multiY = label.length / 2 * parseInt(ylabels.style.fontSize, 10);
            }
            var offsetX = ylabels.offsetX - 15;
            var textAnchor = 'end';
            if (_this2.yaxis.opposite) {
              textAnchor = 'start';
            }
            if (w.config.yaxis[0].labels.align === 'left') {
              offsetX = ylabels.offsetX;
              textAnchor = 'start';
            } else if (w.config.yaxis[0].labels.align === 'center') {
              offsetX = ylabels.offsetX;
              textAnchor = 'middle';
            } else if (w.config.yaxis[0].labels.align === 'right') {
              textAnchor = 'end';
            }
            var elLabel = graphics.drawText({
              x: offsetX,
              y: yPos + colHeight + ylabels.offsetY - multiY,
              text: label,
              textAnchor: textAnchor,
              foreColor: getForeColor(),
              fontSize: ylabels.style.fontSize,
              fontFamily: ylabels.style.fontFamily,
              fontWeight: ylabels.style.fontWeight,
              isPlainText: false,
              cssClass: 'apexcharts-yaxis-label ' + ylabels.style.cssClass,
              maxWidth: ylabels.maxWidth
            });
            elYaxisTexts.add(elLabel);
            elLabel.on('click', function (e) {
              if (typeof w.config.chart.events.xAxisLabelClick === 'function') {
                var opts = Object.assign({}, w, {
                  labelIndex: _i2
                });
                w.config.chart.events.xAxisLabelClick(e, _this2.ctx, opts);
              }
            });
            var elTooltipTitle = document.createElementNS(w.globals.SVGNS, 'title');
            elTooltipTitle.textContent = Array.isArray(label) ? label.join(' ') : label;
            elLabel.node.appendChild(elTooltipTitle);
            if (w.config.yaxis[realIndex].labels.rotate !== 0) {
              var labelRotatingCenter = graphics.rotateAroundCenter(elLabel.node);
              elLabel.node.setAttribute('transform', "rotate(".concat(w.config.yaxis[realIndex].labels.rotate, " 0 ").concat(labelRotatingCenter.y, ")"));
            }
            yPos = yPos + colHeight;
          };
          for (var _i2 = 0; _i2 <= labels.length - 1; _i2++) {
            _loop2(_i2);
          }
        }
        if (w.config.yaxis[0].title.text !== undefined) {
          var elXaxisTitle = graphics.group({
            class: 'apexcharts-yaxis-title apexcharts-xaxis-title-inversed',
            transform: 'translate(' + translateYAxisX + ', 0)'
          });
          var elXAxisTitleText = graphics.drawText({
            x: w.config.yaxis[0].title.offsetX,
            y: w.globals.gridHeight / 2 + w.config.yaxis[0].title.offsetY,
            text: w.config.yaxis[0].title.text,
            textAnchor: 'middle',
            foreColor: w.config.yaxis[0].title.style.color,
            fontSize: w.config.yaxis[0].title.style.fontSize,
            fontWeight: w.config.yaxis[0].title.style.fontWeight,
            fontFamily: w.config.yaxis[0].title.style.fontFamily,
            cssClass: 'apexcharts-yaxis-title-text ' + w.config.yaxis[0].title.style.cssClass
          });
          elXaxisTitle.add(elXAxisTitleText);
          elYaxis.add(elXaxisTitle);
        }
        var offX = 0;
        if (this.isCategoryBarHorizontal && w.config.yaxis[0].opposite) {
          offX = w.globals.gridWidth;
        }
        var axisBorder = w.config.xaxis.axisBorder;
        if (axisBorder.show) {
          var elVerticalLine = graphics.drawLine(w.globals.padHorizontal + axisBorder.offsetX + offX, 1 + axisBorder.offsetY, w.globals.padHorizontal + axisBorder.offsetX + offX, w.globals.gridHeight + axisBorder.offsetY, axisBorder.color, 0);
          if (this.elgrid && this.elgrid.elGridBorders && w.config.grid.show) {
            this.elgrid.elGridBorders.add(elVerticalLine);
          } else {
            elYaxis.add(elVerticalLine);
          }
        }
        if (w.config.yaxis[0].axisTicks.show) {
          this.axesUtils.drawYAxisTicks(offX, labels.length, w.config.yaxis[0].axisBorder, w.config.yaxis[0].axisTicks, 0, colHeight, elYaxis);
        }
        return elYaxis;
      }
    }, {
      key: "drawXaxisTicks",
      value: function drawXaxisTicks(x1, y2, appendToElement) {
        var w = this.w;
        var x2 = x1;
        if (x1 < 0 || x1 - 2 > w.globals.gridWidth) return;
        var y1 = this.offY + w.config.xaxis.axisTicks.offsetY;
        y2 = y2 + y1 + w.config.xaxis.axisTicks.height;
        if (w.config.xaxis.position === 'top') {
          y2 = y1 - w.config.xaxis.axisTicks.height;
        }
        if (w.config.xaxis.axisTicks.show) {
          var graphics = new Graphics(this.ctx);
          var line = graphics.drawLine(x1 + w.config.xaxis.axisTicks.offsetX, y1 + w.config.xaxis.offsetY, x2 + w.config.xaxis.axisTicks.offsetX, y2 + w.config.xaxis.offsetY, w.config.xaxis.axisTicks.color);

          // we are not returning anything, but appending directly to the element passed in param
          appendToElement.add(line);
          line.node.classList.add('apexcharts-xaxis-tick');
        }
      }
    }, {
      key: "getXAxisTicksPositions",
      value: function getXAxisTicksPositions() {
        var w = this.w;
        var xAxisTicksPositions = [];
        var xCount = this.xaxisLabels.length;
        var x1 = w.globals.padHorizontal;
        if (w.globals.timescaleLabels.length > 0) {
          for (var i = 0; i < xCount; i++) {
            x1 = this.xaxisLabels[i].position;
            xAxisTicksPositions.push(x1);
          }
        } else {
          var xCountForCategoryCharts = xCount;
          for (var _i3 = 0; _i3 < xCountForCategoryCharts; _i3++) {
            var x1Count = xCountForCategoryCharts;
            if (w.globals.isXNumeric && w.config.chart.type !== 'bar') {
              x1Count -= 1;
            }
            x1 = x1 + w.globals.gridWidth / x1Count;
            xAxisTicksPositions.push(x1);
          }
        }
        return xAxisTicksPositions;
      }

      // to rotate x-axis labels or to put ... for longer text in xaxis
    }, {
      key: "xAxisLabelCorrections",
      value: function xAxisLabelCorrections() {
        var w = this.w;
        var graphics = new Graphics(this.ctx);
        var xAxis = w.globals.dom.baseEl.querySelector('.apexcharts-xaxis-texts-g');
        var xAxisTexts = w.globals.dom.baseEl.querySelectorAll('.apexcharts-xaxis-texts-g text:not(.apexcharts-xaxis-group-label)');
        var yAxisTextsInversed = w.globals.dom.baseEl.querySelectorAll('.apexcharts-yaxis-inversed text');
        var xAxisTextsInversed = w.globals.dom.baseEl.querySelectorAll('.apexcharts-xaxis-inversed-texts-g text tspan');
        if (w.globals.rotateXLabels || w.config.xaxis.labels.rotateAlways) {
          for (var xat = 0; xat < xAxisTexts.length; xat++) {
            var textRotatingCenter = graphics.rotateAroundCenter(xAxisTexts[xat]);
            textRotatingCenter.y = textRotatingCenter.y - 1; // + tickWidth/4;
            textRotatingCenter.x = textRotatingCenter.x + 1;
            xAxisTexts[xat].setAttribute('transform', "rotate(".concat(w.config.xaxis.labels.rotate, " ").concat(textRotatingCenter.x, " ").concat(textRotatingCenter.y, ")"));
            xAxisTexts[xat].setAttribute('text-anchor', "end");
            var offsetHeight = 10;
            xAxis.setAttribute('transform', "translate(0, ".concat(-offsetHeight, ")"));
            var tSpan = xAxisTexts[xat].childNodes;
            if (w.config.xaxis.labels.trim) {
              Array.prototype.forEach.call(tSpan, function (ts) {
                graphics.placeTextWithEllipsis(ts, ts.textContent, w.globals.xAxisLabelsHeight - (w.config.legend.position === 'bottom' ? 20 : 10));
              });
            }
          }
        } else {
          (function () {
            var width = w.globals.gridWidth / (w.globals.labels.length + 1);
            for (var _xat = 0; _xat < xAxisTexts.length; _xat++) {
              var _tSpan = xAxisTexts[_xat].childNodes;
              if (w.config.xaxis.labels.trim && w.config.xaxis.type !== 'datetime') {
                Array.prototype.forEach.call(_tSpan, function (ts) {
                  graphics.placeTextWithEllipsis(ts, ts.textContent, width);
                });
              }
            }
          })();
        }
        if (yAxisTextsInversed.length > 0) {
          // truncate rotated y axis in bar chart (x axis)
          var firstLabelPosX = yAxisTextsInversed[yAxisTextsInversed.length - 1].getBBox();
          var lastLabelPosX = yAxisTextsInversed[0].getBBox();
          if (firstLabelPosX.x < -20) {
            yAxisTextsInversed[yAxisTextsInversed.length - 1].parentNode.removeChild(yAxisTextsInversed[yAxisTextsInversed.length - 1]);
          }
          if (lastLabelPosX.x + lastLabelPosX.width > w.globals.gridWidth && !w.globals.isBarHorizontal) {
            yAxisTextsInversed[0].parentNode.removeChild(yAxisTextsInversed[0]);
          }

          // truncate rotated x axis in bar chart (y axis)
          for (var _xat2 = 0; _xat2 < xAxisTextsInversed.length; _xat2++) {
            graphics.placeTextWithEllipsis(xAxisTextsInversed[_xat2], xAxisTextsInversed[_xat2].textContent, w.config.yaxis[0].labels.maxWidth - (w.config.yaxis[0].title.text ? parseFloat(w.config.yaxis[0].title.style.fontSize) * 2 : 0) - 15);
          }
        }
      }

      // renderXAxisBands() {
      //   let w = this.w;

      //   let plotBand = document.createElementNS(w.globals.SVGNS, 'rect')
      //   w.globals.dom.elGraphical.add(plotBand)
      // }
    }]);
    return XAxis;
  }();

  /**
   * ApexCharts Grid Class for drawing Cartesian Grid.
   *
   * @module Grid
   **/
  var Grid = /*#__PURE__*/function () {
    function Grid(ctx) {
      _classCallCheck(this, Grid);
      this.ctx = ctx;
      this.w = ctx.w;
      var w = this.w;
      this.xaxisLabels = w.globals.labels.slice();
      this.axesUtils = new AxesUtils(ctx);
      this.isRangeBar = w.globals.seriesRange.length && w.globals.isBarHorizontal;
      if (w.globals.timescaleLabels.length > 0) {
        //  timescaleLabels labels are there
        this.xaxisLabels = w.globals.timescaleLabels.slice();
      }
    }
    _createClass(Grid, [{
      key: "drawGridArea",
      value: function drawGridArea() {
        var elGrid = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
        var w = this.w;
        var graphics = new Graphics(this.ctx);
        if (!elGrid) {
          elGrid = graphics.group({
            class: 'apexcharts-grid'
          });
        }
        var elVerticalLine = graphics.drawLine(w.globals.padHorizontal, 1, w.globals.padHorizontal, w.globals.gridHeight, 'transparent');
        var elHorzLine = graphics.drawLine(w.globals.padHorizontal, w.globals.gridHeight, w.globals.gridWidth, w.globals.gridHeight, 'transparent');
        elGrid.add(elHorzLine);
        elGrid.add(elVerticalLine);
        return elGrid;
      }
    }, {
      key: "drawGrid",
      value: function drawGrid() {
        var gl = this.w.globals;
        if (gl.axisCharts) {
          var elgrid = this.renderGrid();
          this.drawGridArea(elgrid.el);
          return elgrid;
        }
        return null;
      }
    }, {
      key: "createGridMask",
      value: function createGridMask() {
        var w = this.w;
        var gl = w.globals;
        var graphics = new Graphics(this.ctx);
        var strokeSize = Array.isArray(w.config.stroke.width) ? Math.max.apply(Math, _toConsumableArray(w.config.stroke.width)) : w.config.stroke.width;
        var createClipPath = function createClipPath(id) {
          var clipPath = document.createElementNS(gl.SVGNS, 'clipPath');
          clipPath.setAttribute('id', id);
          return clipPath;
        };
        gl.dom.elGridRectMask = createClipPath("gridRectMask".concat(gl.cuid));
        gl.dom.elGridRectBarMask = createClipPath("gridRectBarMask".concat(gl.cuid));
        gl.dom.elGridRectMarkerMask = createClipPath("gridRectMarkerMask".concat(gl.cuid));
        gl.dom.elForecastMask = createClipPath("forecastMask".concat(gl.cuid));
        gl.dom.elNonForecastMask = createClipPath("nonForecastMask".concat(gl.cuid));
        var hasBar = ['bar', 'rangeBar', 'candlestick', 'boxPlot'].includes(w.config.chart.type) || w.globals.comboBarCount > 0;
        var barWidthLeft = 0;
        var barWidthRight = 0;
        if (hasBar && w.globals.isXNumeric && !w.globals.isBarHorizontal) {
          barWidthLeft = Math.max(w.config.grid.padding.left, gl.barPadForNumericAxis);
          barWidthRight = Math.max(w.config.grid.padding.right, gl.barPadForNumericAxis);
        }
        gl.dom.elGridRect = graphics.drawRect(-strokeSize / 2 - 2, -strokeSize / 2 - 2, gl.gridWidth + strokeSize + 4, gl.gridHeight + strokeSize + 4, 0, '#fff');
        gl.dom.elGridRectBar = graphics.drawRect(-strokeSize / 2 - barWidthLeft - 2, -strokeSize / 2 - 2, gl.gridWidth + strokeSize + barWidthRight + barWidthLeft + 4, gl.gridHeight + strokeSize + 4, 0, '#fff');
        var markerSize = w.globals.markers.largestSize;
        gl.dom.elGridRectMarker = graphics.drawRect(Math.min(-strokeSize / 2 - barWidthLeft - 2, -markerSize), -markerSize, gl.gridWidth + Math.max(strokeSize + barWidthRight + barWidthLeft + 4, markerSize * 2), gl.gridHeight + markerSize * 2, 0, '#fff');
        gl.dom.elGridRectMask.appendChild(gl.dom.elGridRect.node);
        gl.dom.elGridRectBarMask.appendChild(gl.dom.elGridRectBar.node);
        gl.dom.elGridRectMarkerMask.appendChild(gl.dom.elGridRectMarker.node);
        var defs = gl.dom.baseEl.querySelector('defs');
        defs.appendChild(gl.dom.elGridRectMask);
        defs.appendChild(gl.dom.elGridRectBarMask);
        defs.appendChild(gl.dom.elGridRectMarkerMask);
        defs.appendChild(gl.dom.elForecastMask);
        defs.appendChild(gl.dom.elNonForecastMask);
      }
    }, {
      key: "_drawGridLines",
      value: function _drawGridLines(_ref) {
        var i = _ref.i,
          x1 = _ref.x1,
          y1 = _ref.y1,
          x2 = _ref.x2,
          y2 = _ref.y2,
          xCount = _ref.xCount,
          parent = _ref.parent;
        var w = this.w;
        var shouldDraw = function shouldDraw() {
          if (i === 0 && w.globals.skipFirstTimelinelabel) return false;
          if (i === xCount - 1 && w.globals.skipLastTimelinelabel && !w.config.xaxis.labels.formatter) return false;
          if (w.config.chart.type === 'radar') return false;
          return true;
        };
        if (shouldDraw()) {
          if (w.config.grid.xaxis.lines.show) {
            this._drawGridLine({
              i: i,
              x1: x1,
              y1: y1,
              x2: x2,
              y2: y2,
              xCount: xCount,
              parent: parent
            });
          }
          var y_2 = 0;
          if (w.globals.hasXaxisGroups && w.config.xaxis.tickPlacement === 'between') {
            var groups = w.globals.groups;
            if (groups) {
              var gacc = 0;
              for (var gi = 0; gacc < i && gi < groups.length; gi++) {
                gacc += groups[gi].cols;
              }
              if (gacc === i) {
                y_2 = w.globals.xAxisLabelsHeight * 0.6;
              }
            }
          }
          var xAxis = new XAxis(this.ctx);
          xAxis.drawXaxisTicks(x1, y_2, w.globals.dom.elGraphical);
        }
      }
    }, {
      key: "_drawGridLine",
      value: function _drawGridLine(_ref2) {
        var i = _ref2.i,
          x1 = _ref2.x1,
          y1 = _ref2.y1,
          x2 = _ref2.x2,
          y2 = _ref2.y2,
          xCount = _ref2.xCount,
          parent = _ref2.parent;
        var w = this.w;
        var isHorzLine = parent.node.classList.contains('apexcharts-gridlines-horizontal');
        var offX = w.globals.barPadForNumericAxis;
        var excludeBorders = y1 === 0 && y2 === 0 || x1 === 0 && x2 === 0 || y1 === w.globals.gridHeight && y2 === w.globals.gridHeight || w.globals.isBarHorizontal && (i === 0 || i === xCount - 1);
        var graphics = new Graphics(this);
        var line = graphics.drawLine(x1 - (isHorzLine ? offX : 0), y1, x2 + (isHorzLine ? offX : 0), y2, w.config.grid.borderColor, w.config.grid.strokeDashArray);
        line.node.classList.add('apexcharts-gridline');
        if (excludeBorders && w.config.grid.show) {
          this.elGridBorders.add(line);
        } else {
          parent.add(line);
        }
      }
    }, {
      key: "_drawGridBandRect",
      value: function _drawGridBandRect(_ref3) {
        var c = _ref3.c,
          x1 = _ref3.x1,
          y1 = _ref3.y1,
          x2 = _ref3.x2,
          y2 = _ref3.y2,
          type = _ref3.type;
        var w = this.w;
        var graphics = new Graphics(this.ctx);
        var offX = w.globals.barPadForNumericAxis;
        var color = w.config.grid[type].colors[c];
        var rect = graphics.drawRect(x1 - (type === 'row' ? offX : 0), y1, x2 + (type === 'row' ? offX * 2 : 0), y2, 0, color, w.config.grid[type].opacity);
        this.elg.add(rect);
        rect.attr('clip-path', "url(#gridRectMask".concat(w.globals.cuid, ")"));
        rect.node.classList.add("apexcharts-grid-".concat(type));
      }
    }, {
      key: "_drawXYLines",
      value: function _drawXYLines(_ref4) {
        var _this = this;
        var xCount = _ref4.xCount,
          tickAmount = _ref4.tickAmount;
        var w = this.w;
        var datetimeLines = function datetimeLines(_ref5) {
          var xC = _ref5.xC,
            x1 = _ref5.x1,
            y1 = _ref5.y1,
            x2 = _ref5.x2,
            y2 = _ref5.y2;
          for (var i = 0; i < xC; i++) {
            x1 = _this.xaxisLabels[i].position;
            x2 = _this.xaxisLabels[i].position;
            _this._drawGridLines({
              i: i,
              x1: x1,
              y1: y1,
              x2: x2,
              y2: y2,
              xCount: xCount,
              parent: _this.elgridLinesV
            });
          }
        };
        var categoryLines = function categoryLines(_ref6) {
          var xC = _ref6.xC,
            x1 = _ref6.x1,
            y1 = _ref6.y1,
            x2 = _ref6.x2,
            y2 = _ref6.y2;
          for (var i = 0; i < xC + (w.globals.isXNumeric ? 0 : 1); i++) {
            if (i === 0 && xC === 1 && w.globals.dataPoints === 1) {
              x1 = w.globals.gridWidth / 2;
              x2 = x1;
            }
            _this._drawGridLines({
              i: i,
              x1: x1,
              y1: y1,
              x2: x2,
              y2: y2,
              xCount: xCount,
              parent: _this.elgridLinesV
            });
            x1 += w.globals.gridWidth / (w.globals.isXNumeric ? xC - 1 : xC);
            x2 = x1;
          }
        };
        if (w.config.grid.xaxis.lines.show || w.config.xaxis.axisTicks.show) {
          var x1 = w.globals.padHorizontal;
          var y1 = 0;
          var x2;
          var y2 = w.globals.gridHeight;
          if (w.globals.timescaleLabels.length) {
            datetimeLines({
              xC: xCount,
              x1: x1,
              y1: y1,
              x2: x2,
              y2: y2
            });
          } else {
            if (w.globals.isXNumeric) {
              xCount = w.globals.xAxisScale.result.length;
            }
            categoryLines({
              xC: xCount,
              x1: x1,
              y1: y1,
              x2: x2,
              y2: y2
            });
          }
        }
        if (w.config.grid.yaxis.lines.show) {
          var _x = 0;
          var _y = 0;
          var _y2 = 0;
          var _x2 = w.globals.gridWidth;
          var tA = tickAmount + 1;
          if (this.isRangeBar) {
            tA = w.globals.labels.length;
          }
          for (var i = 0; i < tA + (this.isRangeBar ? 1 : 0); i++) {
            this._drawGridLine({
              i: i,
              xCount: tA + (this.isRangeBar ? 1 : 0),
              x1: _x,
              y1: _y,
              x2: _x2,
              y2: _y2,
              parent: this.elgridLinesH
            });
            _y += w.globals.gridHeight / (this.isRangeBar ? tA : tickAmount);
            _y2 = _y;
          }
        }
      }
    }, {
      key: "_drawInvertedXYLines",
      value: function _drawInvertedXYLines(_ref7) {
        var xCount = _ref7.xCount;
        var w = this.w;
        if (w.config.grid.xaxis.lines.show || w.config.xaxis.axisTicks.show) {
          var x1 = w.globals.padHorizontal;
          var y1 = 0;
          var x2;
          var y2 = w.globals.gridHeight;
          for (var i = 0; i < xCount + 1; i++) {
            if (w.config.grid.xaxis.lines.show) {
              this._drawGridLine({
                i: i,
                xCount: xCount + 1,
                x1: x1,
                y1: y1,
                x2: x2,
                y2: y2,
                parent: this.elgridLinesV
              });
            }
            var xAxis = new XAxis(this.ctx);
            xAxis.drawXaxisTicks(x1, 0, w.globals.dom.elGraphical);
            x1 += w.globals.gridWidth / xCount;
            x2 = x1;
          }
        }
        if (w.config.grid.yaxis.lines.show) {
          var _x3 = 0;
          var _y3 = 0;
          var _y4 = 0;
          var _x4 = w.globals.gridWidth;
          for (var _i = 0; _i < w.globals.dataPoints + 1; _i++) {
            this._drawGridLine({
              i: _i,
              xCount: w.globals.dataPoints + 1,
              x1: _x3,
              y1: _y3,
              x2: _x4,
              y2: _y4,
              parent: this.elgridLinesH
            });
            _y3 += w.globals.gridHeight / w.globals.dataPoints;
            _y4 = _y3;
          }
        }
      }
    }, {
      key: "renderGrid",
      value: function renderGrid() {
        var w = this.w;
        var gl = w.globals;
        var graphics = new Graphics(this.ctx);
        this.elg = graphics.group({
          class: 'apexcharts-grid'
        });
        this.elgridLinesH = graphics.group({
          class: 'apexcharts-gridlines-horizontal'
        });
        this.elgridLinesV = graphics.group({
          class: 'apexcharts-gridlines-vertical'
        });
        this.elGridBorders = graphics.group({
          class: 'apexcharts-grid-borders'
        });
        this.elg.add(this.elgridLinesH);
        this.elg.add(this.elgridLinesV);
        if (!w.config.grid.show) {
          this.elgridLinesV.hide();
          this.elgridLinesH.hide();
          this.elGridBorders.hide();
        }
        var gridAxisIndex = 0;
        while (gridAxisIndex < gl.seriesYAxisMap.length && gl.ignoreYAxisIndexes.includes(gridAxisIndex)) {
          gridAxisIndex++;
        }
        if (gridAxisIndex === gl.seriesYAxisMap.length) {
          gridAxisIndex = 0;
        }
        var yTickAmount = gl.yAxisScale[gridAxisIndex].result.length - 1;
        var xCount;
        if (!gl.isBarHorizontal || this.isRangeBar) {
          xCount = this.xaxisLabels.length;
          if (this.isRangeBar) {
            var _gl$yAxisScale, _gl$yAxisScale$gridAx, _gl$yAxisScale$gridAx2;
            yTickAmount = gl.labels.length;
            if (w.config.xaxis.tickAmount && w.config.xaxis.labels.formatter) {
              xCount = w.config.xaxis.tickAmount;
            }
            if (((_gl$yAxisScale = gl.yAxisScale) === null || _gl$yAxisScale === void 0 ? void 0 : (_gl$yAxisScale$gridAx = _gl$yAxisScale[gridAxisIndex]) === null || _gl$yAxisScale$gridAx === void 0 ? void 0 : (_gl$yAxisScale$gridAx2 = _gl$yAxisScale$gridAx.result) === null || _gl$yAxisScale$gridAx2 === void 0 ? void 0 : _gl$yAxisScale$gridAx2.length) > 0 && w.config.xaxis.type !== 'datetime') {
              xCount = gl.yAxisScale[gridAxisIndex].result.length - 1;
            }
          }
          this._drawXYLines({
            xCount: xCount,
            tickAmount: yTickAmount
          });
        } else {
          xCount = yTickAmount;

          // for horizontal bar chart, get the xaxis tickamount
          yTickAmount = gl.xTickAmount;
          this._drawInvertedXYLines({
            xCount: xCount,
            tickAmount: yTickAmount
          });
        }
        this.drawGridBands(xCount, yTickAmount);
        return {
          el: this.elg,
          elGridBorders: this.elGridBorders,
          xAxisTickWidth: gl.gridWidth / xCount
        };
      }
    }, {
      key: "drawGridBands",
      value: function drawGridBands(xCount, tickAmount) {
        var _this2 = this,
          _w$config$grid$row$co,
          _w$config$grid$column;
        var w = this.w;
        var drawBands = function drawBands(type, count, x1, y1, x2, y2) {
          for (var i = 0, c = 0; i < count; i++, c++) {
            if (c >= w.config.grid[type].colors.length) {
              c = 0;
            }
            _this2._drawGridBandRect({
              c: c,
              x1: x1,
              y1: y1,
              x2: x2,
              y2: y2,
              type: type
            });
            y1 += w.globals.gridHeight / tickAmount;
          }
        };
        if (((_w$config$grid$row$co = w.config.grid.row.colors) === null || _w$config$grid$row$co === void 0 ? void 0 : _w$config$grid$row$co.length) > 0) {
          drawBands('row', tickAmount, 0, 0, w.globals.gridWidth, w.globals.gridHeight / tickAmount);
        }
        if (((_w$config$grid$column = w.config.grid.column.colors) === null || _w$config$grid$column === void 0 ? void 0 : _w$config$grid$column.length) > 0) {
          var xc = !w.globals.isBarHorizontal && w.config.xaxis.tickPlacement === 'on' && (w.config.xaxis.type === 'category' || w.config.xaxis.convertedCatToNumeric) ? xCount - 1 : xCount;
          if (w.globals.isXNumeric) {
            xc = w.globals.xAxisScale.result.length - 1;
          }
          var x1 = w.globals.padHorizontal;
          var y1 = 0;
          var x2 = w.globals.padHorizontal + w.globals.gridWidth / xc;
          var y2 = w.globals.gridHeight;
          for (var i = 0, c = 0; i < xCount; i++, c++) {
            if (c >= w.config.grid.column.colors.length) {
              c = 0;
            }
            if (w.config.xaxis.type === 'datetime') {
              var _this$xaxisLabels;
              x1 = this.xaxisLabels[i].position;
              x2 = (((_this$xaxisLabels = this.xaxisLabels[i + 1]) === null || _this$xaxisLabels === void 0 ? void 0 : _this$xaxisLabels.position) || w.globals.gridWidth) - this.xaxisLabels[i].position;
            }
            this._drawGridBandRect({
              c: c,
              x1: x1,
              y1: y1,
              x2: x2,
              y2: y2,
              type: 'column'
            });
            x1 += w.globals.gridWidth / xc;
          }
        }
      }
    }]);
    return Grid;
  }();

  var Scales = /*#__PURE__*/function () {
    function Scales(ctx) {
      _classCallCheck(this, Scales);
      this.ctx = ctx;
      this.w = ctx.w;
      this.coreUtils = new CoreUtils(this.ctx);
    }

    // http://stackoverflow.com/questions/326679/choosing-an-attractive-linear-scale-for-a-graphs-y-axis
    // This routine creates the Y axis values for a graph.
    _createClass(Scales, [{
      key: "niceScale",
      value: function niceScale(yMin, yMax) {
        var index = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
        // Calculate Min amd Max graphical labels and graph
        // increments.
        //
        // Output will be an array of the Y axis values that
        // encompass the Y values.
        var jsPrecision = 1e-11; // JS precision errors
        var w = this.w;
        var gl = w.globals;
        var axisCnf;
        var maxTicks;
        var gotMin;
        var gotMax;
        if (gl.isBarHorizontal) {
          axisCnf = w.config.xaxis;
          // The most ticks we can fit into the svg chart dimensions
          maxTicks = Math.max((gl.svgWidth - 100) / 25, 2); // Guestimate
        } else {
          axisCnf = w.config.yaxis[index];
          maxTicks = Math.max((gl.svgHeight - 100) / 15, 2);
        }
        if (!Utils$1.isNumber(maxTicks)) {
          maxTicks = 10;
        }
        gotMin = axisCnf.min !== undefined && axisCnf.min !== null;
        gotMax = axisCnf.max !== undefined && axisCnf.min !== null;
        var gotStepSize = axisCnf.stepSize !== undefined && axisCnf.stepSize !== null;
        var gotTickAmount = axisCnf.tickAmount !== undefined && axisCnf.tickAmount !== null;
        var ticks = gotTickAmount ? axisCnf.tickAmount : gl.niceScaleDefaultTicks[Math.min(Math.round(maxTicks / 2), gl.niceScaleDefaultTicks.length - 1)];

        // In case we have a multi axis chart:
        // Ensure subsequent series start with the same tickAmount as series[0],
        // because the tick lines are drawn based on series[0]. This does not
        // override user defined options for any yaxis.
        if (gl.isMultipleYAxis && !gotTickAmount && gl.multiAxisTickAmount > 0) {
          ticks = gl.multiAxisTickAmount;
          gotTickAmount = true;
        }
        if (ticks === 'dataPoints') {
          ticks = gl.dataPoints - 1;
        } else {
          // Ensure ticks is an integer
          ticks = Math.abs(Math.round(ticks));
        }
        if (yMin === Number.MIN_VALUE && yMax === 0 || !Utils$1.isNumber(yMin) && !Utils$1.isNumber(yMax) || yMin === Number.MIN_VALUE && yMax === -Number.MAX_VALUE) {
          // when all values are 0
          yMin = Utils$1.isNumber(axisCnf.min) ? axisCnf.min : 0;
          yMax = Utils$1.isNumber(axisCnf.max) ? axisCnf.max : yMin + ticks;
          gl.allSeriesCollapsed = false;
        }
        if (yMin > yMax) {
          // if somehow due to some wrong config, user sent max less than min,
          // adjust the min/max again
          console.warn('axis.min cannot be greater than axis.max: swapping min and max');
          var temp = yMax;
          yMax = yMin;
          yMin = temp;
        } else if (yMin === yMax) {
          // If yMin and yMax are identical, then
          // adjust the yMin and yMax values to actually
          // make a graph. Also avoids division by zero errors.
          yMin = yMin === 0 ? 0 : yMin - 1; // choose an integer in case yValueDecimals=0
          yMax = yMax === 0 ? 2 : yMax + 1; // choose an integer in case yValueDecimals=0
        }
        var result = [];
        if (ticks < 1) {
          ticks = 1;
        }
        var tiks = ticks;

        // Determine Range
        var range = Math.abs(yMax - yMin);

        // Snap min or max to zero if close
        var proximityRatio = 0.15;
        if (!gotMin && yMin > 0 && yMin / range < proximityRatio) {
          yMin = 0;
          gotMin = true;
        }
        if (!gotMax && yMax < 0 && -yMax / range < proximityRatio) {
          yMax = 0;
          gotMax = true;
        }
        range = Math.abs(yMax - yMin);

        // Calculate a pretty step value based on ticks

        // Initial stepSize
        var stepSize = range / tiks;
        var niceStep = stepSize;
        var mag = Math.floor(Math.log10(niceStep));
        var magPow = Math.pow(10, mag);
        // ceil() is used below in conjunction with the values populating
        // niceScaleAllowedMagMsd[][] to ensure that (niceStep * tiks)
        // produces a range that doesn't clip data points after stretching
        // the raw range out a little to match the prospective new range.
        var magMsd = Math.ceil(niceStep / magPow);
        // See globals.js for info on what niceScaleAllowedMagMsd does
        magMsd = gl.niceScaleAllowedMagMsd[gl.yValueDecimal === 0 ? 0 : 1][magMsd];
        niceStep = magMsd * magPow;

        // Initial stepSize
        stepSize = niceStep;

        // Get step value
        if (gl.isBarHorizontal && axisCnf.stepSize && axisCnf.type !== 'datetime') {
          stepSize = axisCnf.stepSize;
          gotStepSize = true;
        } else if (gotStepSize) {
          stepSize = axisCnf.stepSize;
        }
        if (gotStepSize) {
          if (axisCnf.forceNiceScale) {
            // Check that given stepSize is sane with respect to the range.
            //
            // The user can, by setting forceNiceScale = true,
            // define a stepSize that will be scaled to a useful value before
            // it's checked for consistency.
            //
            // If, for example, the range = 4 and the user defined stepSize = 8
            // (or 8000 or 0.0008, etc), then stepSize is inapplicable as
            // it is. Reducing it to 0.8 will fit with 5 ticks.
            //
            var stepMag = Math.floor(Math.log10(stepSize));
            stepSize *= Math.pow(10, mag - stepMag);
          }
        }

        // Start applying some rules
        if (gotMin && gotMax) {
          var crudeStep = range / tiks;
          // min and max (range) cannot be changed
          if (gotTickAmount) {
            if (gotStepSize) {
              if (Utils$1.mod(range, stepSize) != 0) {
                // stepSize conflicts with range
                var gcdStep = Utils$1.getGCD(stepSize, crudeStep);
                // gcdStep is a multiple of range because crudeStep is a multiple.
                // gcdStep is also a multiple of stepSize, so it partially honoured
                // All three could be equal, which would be very nice
                // if the computed stepSize generates too many ticks they will be
                // reduced later, unless the number is prime, in which case,
                // the chart will display all of them or just one (plus the X axis)
                // depending on svg dimensions. Setting forceNiceScale: true will force
                // the display of at least the default number of ticks.
                if (crudeStep / gcdStep < 10) {
                  stepSize = gcdStep;
                } else {
                  // stepSize conflicts and no reasonable adjustment, but must
                  // honour tickAmount
                  stepSize = crudeStep;
                }
              } else {
                // stepSize fits
                if (Utils$1.mod(stepSize, crudeStep) == 0) {
                  // crudeStep is a multiple of stepSize, or vice versa
                  // but we know that crudeStep will generate tickAmount ticks
                  stepSize = crudeStep;
                } else {
                  // stepSize conflicts with tickAmount
                  // if the user is setting up a multi-axis chart and wants
                  // synced axis ticks then they should not define stepSize
                  // or ensure there is no conflict between any of their options
                  // on any axis.
                  crudeStep = stepSize;
                  // De-prioritizing ticks from now on
                  gotTickAmount = false;
                }
              }
            } else {
              // no user stepSize, honour tickAmount
              stepSize = crudeStep;
            }
          } else {
            // default ticks in use, tiks can change
            if (gotStepSize) {
              if (Utils$1.mod(range, stepSize) == 0) {
                // user stepSize fits
                crudeStep = stepSize;
              } else {
                stepSize = crudeStep;
              }
            } else {
              // no user stepSize
              if (Utils$1.mod(range, stepSize) == 0) {
                // generated nice stepSize fits
                crudeStep = stepSize;
              } else {
                tiks = Math.ceil(range / stepSize);
                crudeStep = range / tiks;
                var _gcdStep = Utils$1.getGCD(range, stepSize);
                if (range / _gcdStep < maxTicks) {
                  crudeStep = _gcdStep;
                }
                stepSize = crudeStep;
              }
            }
          }
          tiks = Math.round(range / stepSize);
        } else {
          // Snap range to ticks
          if (!gotMin && !gotMax) {
            if (gl.isMultipleYAxis && gotTickAmount) {
              // Ensure graph doesn't clip.
              var tMin = stepSize * Math.floor(yMin / stepSize);
              var tMax = tMin + stepSize * tiks;
              if (tMax < yMax) {
                stepSize *= 2;
              }
              yMin = tMin;
              tMax = yMax;
              yMax = yMin + stepSize * tiks;
              // Snap min or max to zero if possible
              range = Math.abs(yMax - yMin);
              if (yMin > 0 && yMin < Math.abs(tMax - yMax)) {
                yMin = 0;
                yMax = stepSize * tiks;
              }
              if (yMax < 0 && -yMax < Math.abs(tMin - yMin)) {
                yMax = 0;
                yMin = -stepSize * tiks;
              }
            } else {
              yMin = stepSize * Math.floor(yMin / stepSize);
              yMax = stepSize * Math.ceil(yMax / stepSize);
            }
          } else if (gotMax) {
            if (gotTickAmount) {
              yMin = yMax - stepSize * tiks;
            } else {
              var yMinPrev = yMin;
              yMin = stepSize * Math.floor(yMin / stepSize);
              if (Math.abs(yMax - yMin) / Utils$1.getGCD(range, stepSize) > maxTicks) {
                // Use default ticks to compute yMin then shrinkwrap
                yMin = yMax - stepSize * ticks;
                yMin += stepSize * Math.floor((yMinPrev - yMin) / stepSize);
              }
            }
          } else if (gotMin) {
            if (gotTickAmount) {
              yMax = yMin + stepSize * tiks;
            } else {
              var yMaxPrev = yMax;
              yMax = stepSize * Math.ceil(yMax / stepSize);
              if (Math.abs(yMax - yMin) / Utils$1.getGCD(range, stepSize) > maxTicks) {
                // Use default ticks to compute yMin then shrinkwrap
                yMax = yMin + stepSize * ticks;
                yMax += stepSize * Math.ceil((yMaxPrev - yMax) / stepSize);
              }
            }
          }
          range = Math.abs(yMax - yMin);
          // Final check and possible adjustment of stepSize to prevent
          // overriding the user's min or max choice.
          stepSize = Utils$1.getGCD(range, stepSize);
          tiks = Math.round(range / stepSize);
        }

        // Shrinkwrap ticks to the range
        if (!gotTickAmount && !(gotMin || gotMax)) {
          tiks = Math.ceil((range - jsPrecision) / (stepSize + jsPrecision));
          // No user tickAmount, or min or max, we are free to adjust to avoid a
          // prime number. This helps when reducing ticks for small svg dimensions.
          if (tiks > 16 && Utils$1.getPrimeFactors(tiks).length < 2) {
            tiks++;
          }
        }

        // Prune tiks down to range if series is all integers. Since tiks > range,
        // range is very low (< 10 or so). Skip this step if gotTickAmount is true
        // because either the user set tickAmount or the chart is multiscale and
        // this axis is not determining the number of grid lines.
        if (!gotTickAmount && axisCnf.forceNiceScale && gl.yValueDecimal === 0 && tiks > range) {
          tiks = range;
          stepSize = Math.round(range / tiks);
        }
        if (tiks > maxTicks && (!(gotTickAmount || gotStepSize) || axisCnf.forceNiceScale)) {
          // Reduce the number of ticks nicely if chart svg dimensions shrink too far.
          // The reduced tick set should always be a subset of the full set.
          //
          // This following products of prime factors method works as follows:
          // We compute the prime factors of the full tick count (tiks), then all the
          // possible products of those factors in order from smallest to biggest,
          // until we find a product P such that: tiks/P < maxTicks.
          //
          // Example:
          // Computing products of the prime factors of 30.
          //
          //   tiks | pf  |  1     2     3      4      5      6  <-- compute order
          //   --------------------------------------------------
          //     30 |  5  |              5             5      5  <-- Multiply all
          //        |  3  |        3            3      3      3  <-- primes in each
          //        |  2  |  2                  2             2  <-- column = P
          //   --------------------------------------------------
          //                15    10     6      5      2      1  <-- tiks/P
          //
          //   tiks = 30 has prime factors [2, 3, 5]
          //   The loop below computes the products [2,3,5,6,15,30].
          //   The last product of P = 2*3*5 is skipped since 30/P = 1.
          //   This yields tiks/P = [15,10,6,5,2,1], checked in order until
          //   tiks/P < maxTicks.
          //
          //   Pros:
          //      1) The ticks in the reduced set are always members of the
          //         full set of ticks.
          //   Cons:
          //      1) None: if tiks is prime, we get all or one, nothing between, so
          //      the worst case is to display all, which is the status quo. Really
          //      only a problem visually for larger tick numbers, say, > 7.
          //
          var pf = Utils$1.getPrimeFactors(tiks);
          var last = pf.length - 1;
          var tt = tiks;
          reduceLoop: for (var xFactors = 0; xFactors < last; xFactors++) {
            for (var lowest = 0; lowest <= last - xFactors; lowest++) {
              var stop = Math.min(lowest + xFactors, last);
              var t = tt;
              var div = 1;
              for (var next = lowest; next <= stop; next++) {
                div *= pf[next];
              }
              t /= div;
              if (t < maxTicks) {
                tt = t;
                break reduceLoop;
              }
            }
          }
          if (tt === tiks) {
            // Could not reduce ticks at all, go all in and display just the
            // X axis and one tick.
            stepSize = range;
          } else {
            stepSize = range / tt;
          }
          tiks = Math.round(range / stepSize);
        }

        // Record final tiks for use by other series that call niceScale().
        // Note: some don't, like logarithmicScale(), etc.
        if (gl.isMultipleYAxis && gl.multiAxisTickAmount == 0 && gl.ignoreYAxisIndexes.indexOf(index) < 0) {
          gl.multiAxisTickAmount = tiks;
        }

        // build Y label array.

        var val = yMin - stepSize;
        // Ensure we don't under/over shoot due to JS precision errors.
        // This also fixes (amongst others):
        // https://github.com/apexcharts/apexcharts.js/issues/430
        var err = stepSize * jsPrecision;
        do {
          val += stepSize;
          result.push(Utils$1.stripNumber(val, 7));
        } while (yMax - val > err);
        return {
          result: result,
          niceMin: result[0],
          niceMax: result[result.length - 1]
        };
      }
    }, {
      key: "linearScale",
      value: function linearScale(yMin, yMax) {
        var ticks = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 10;
        var index = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
        var step = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : undefined;
        var range = Math.abs(yMax - yMin);
        var result = [];
        if (yMin === yMax) {
          result = [yMin];
          return {
            result: result,
            niceMin: result[0],
            niceMax: result[result.length - 1]
          };
        }
        ticks = this._adjustTicksForSmallRange(ticks, index, range);
        if (ticks === 'dataPoints') {
          ticks = this.w.globals.dataPoints - 1;
        }
        if (!step) {
          step = range / ticks;
        }
        step = Math.round((step + Number.EPSILON) * 100) / 100;
        if (ticks === Number.MAX_VALUE) {
          ticks = 5;
          step = 1;
        }
        var v = yMin;
        while (ticks >= 0) {
          result.push(v);
          v = Utils$1.preciseAddition(v, step);
          ticks -= 1;
        }
        return {
          result: result,
          niceMin: result[0],
          niceMax: result[result.length - 1]
        };
      }
    }, {
      key: "logarithmicScaleNice",
      value: function logarithmicScaleNice(yMin, yMax, base) {
        // Basic validation to avoid for loop starting at -inf.
        if (yMax <= 0) yMax = Math.max(yMin, base);
        if (yMin <= 0) yMin = Math.min(yMax, base);
        var logs = [];

        // Get powers of base for our max and min
        var logMax = Math.ceil(Math.log(yMax) / Math.log(base) + 1);
        var logMin = Math.floor(Math.log(yMin) / Math.log(base));
        for (var i = logMin; i < logMax; i++) {
          logs.push(Math.pow(base, i));
        }
        return {
          result: logs,
          niceMin: logs[0],
          niceMax: logs[logs.length - 1]
        };
      }
    }, {
      key: "logarithmicScale",
      value: function logarithmicScale(yMin, yMax, base) {
        // Basic validation to avoid for loop starting at -inf.
        if (yMax <= 0) yMax = Math.max(yMin, base);
        if (yMin <= 0) yMin = Math.min(yMax, base);
        var logs = [];

        // Get the logarithmic range.
        var logMax = Math.log(yMax) / Math.log(base);
        var logMin = Math.log(yMin) / Math.log(base);

        // Get the exact logarithmic range.
        // (This is the exact number of multiples of the base there are between yMin and yMax).
        var logRange = logMax - logMin;

        // Round the logarithmic range to get the number of ticks we will create.
        // If the chosen min/max values are multiples of each other WRT the base, this will be neat.
        // If the chosen min/max aren't, we will at least still provide USEFUL ticks.
        var ticks = Math.round(logRange);

        // Get the logarithmic spacing between ticks.
        var logTickSpacing = logRange / ticks;

        // Create as many ticks as there is range in the logs.
        for (var i = 0, logTick = logMin; i < ticks; i++, logTick += logTickSpacing) {
          logs.push(Math.pow(base, logTick));
        }

        // Add a final tick at the yMax.
        logs.push(Math.pow(base, logMax));
        return {
          result: logs,
          niceMin: yMin,
          niceMax: yMax
        };
      }
    }, {
      key: "_adjustTicksForSmallRange",
      value: function _adjustTicksForSmallRange(ticks, index, range) {
        var newTicks = ticks;
        if (typeof index !== 'undefined' && this.w.config.yaxis[index].labels.formatter && this.w.config.yaxis[index].tickAmount === undefined) {
          var formattedVal = Number(this.w.config.yaxis[index].labels.formatter(1));
          if (Utils$1.isNumber(formattedVal) && this.w.globals.yValueDecimal === 0) {
            newTicks = Math.ceil(range);
          }
        }
        return newTicks < ticks ? newTicks : ticks;
      }
    }, {
      key: "setYScaleForIndex",
      value: function setYScaleForIndex(index, minY, maxY) {
        var gl = this.w.globals;
        var cnf = this.w.config;
        var y = gl.isBarHorizontal ? cnf.xaxis : cnf.yaxis[index];
        if (typeof gl.yAxisScale[index] === 'undefined') {
          gl.yAxisScale[index] = [];
        }
        var range = Math.abs(maxY - minY);
        if (y.logarithmic && range <= 5) {
          gl.invalidLogScale = true;
        }
        if (y.logarithmic && range > 5) {
          gl.allSeriesCollapsed = false;
          gl.yAxisScale[index] = y.forceNiceScale ? this.logarithmicScaleNice(minY, maxY, y.logBase) : this.logarithmicScale(minY, maxY, y.logBase);
        } else {
          if (maxY === -Number.MAX_VALUE || !Utils$1.isNumber(maxY) || minY === Number.MAX_VALUE || !Utils$1.isNumber(minY)) {
            // no data in the chart.
            // Either all series collapsed or user passed a blank array.
            // Show the user's yaxis with their scale options but with a range.
            gl.yAxisScale[index] = this.niceScale(Number.MIN_VALUE, 0, index);
          } else {
            // there is some data. Turn off the allSeriesCollapsed flag
            gl.allSeriesCollapsed = false;
            gl.yAxisScale[index] = this.niceScale(minY, maxY, index);
          }
        }
      }
    }, {
      key: "setXScale",
      value: function setXScale(minX, maxX) {
        var w = this.w;
        var gl = w.globals;
        if (maxX === -Number.MAX_VALUE || !Utils$1.isNumber(maxX)) {
          // no data in the chart. Either all series collapsed or user passed a blank array
          gl.xAxisScale = this.linearScale(0, 10, 10);
        } else {
          var ticks = gl.xTickAmount;
          gl.xAxisScale = this.linearScale(minX, maxX, ticks, 0, w.config.xaxis.max === undefined ? w.config.xaxis.stepSize : undefined);
        }
        return gl.xAxisScale;
      }
    }, {
      key: "scaleMultipleYAxes",
      value: function scaleMultipleYAxes() {
        var _this = this;
        var cnf = this.w.config;
        var gl = this.w.globals;
        this.coreUtils.setSeriesYAxisMappings();
        var axisSeriesMap = gl.seriesYAxisMap;
        var minYArr = gl.minYArr;
        var maxYArr = gl.maxYArr;

        // Compute min..max for each yaxis
        gl.allSeriesCollapsed = true;
        gl.barGroups = [];
        axisSeriesMap.forEach(function (axisSeries, ai) {
          var groupNames = [];
          axisSeries.forEach(function (as) {
            var _cnf$series$as;
            var group = (_cnf$series$as = cnf.series[as]) === null || _cnf$series$as === void 0 ? void 0 : _cnf$series$as.group;
            if (groupNames.indexOf(group) < 0) {
              groupNames.push(group);
            }
          });
          if (axisSeries.length > 0) {
            (function () {
              var minY = Number.MAX_VALUE;
              var maxY = -Number.MAX_VALUE;
              var lowestY = minY;
              var highestY = maxY;
              var seriesType;
              var seriesGroupName;
              if (cnf.chart.stacked) {
                (function () {
                  // Series' on this axis with the same group name will be stacked.
                  // Sum series in each group separately
                  var mapSeries = new Array(gl.dataPoints).fill(0);
                  var sumSeries = [];
                  var posSeries = [];
                  var negSeries = [];
                  groupNames.forEach(function () {
                    sumSeries.push(mapSeries.map(function () {
                      return Number.MIN_VALUE;
                    }));
                    posSeries.push(mapSeries.map(function () {
                      return Number.MIN_VALUE;
                    }));
                    negSeries.push(mapSeries.map(function () {
                      return Number.MIN_VALUE;
                    }));
                  });
                  var _loop = function _loop(i) {
                    // Assume chart type but the first series that has a type overrides.
                    if (!seriesType && cnf.series[axisSeries[i]].type) {
                      seriesType = cnf.series[axisSeries[i]].type;
                    }
                    // Sum all series for this yaxis at each corresponding datapoint
                    // For bar and column charts we need to keep positive and negative
                    // values separate, for each group separately.
                    var si = axisSeries[i];
                    if (cnf.series[si].group) {
                      seriesGroupName = cnf.series[si].group;
                    } else {
                      seriesGroupName = 'axis-'.concat(ai);
                    }
                    var collapsed = !(gl.collapsedSeriesIndices.indexOf(si) < 0 && gl.ancillaryCollapsedSeriesIndices.indexOf(si) < 0);
                    if (!collapsed) {
                      gl.allSeriesCollapsed = false;
                      groupNames.forEach(function (gn, gni) {
                        // Undefined group names will be grouped together as their own
                        // group.
                        if (cnf.series[si].group === gn) {
                          for (var j = 0; j < gl.series[si].length; j++) {
                            var val = gl.series[si][j];
                            if (val >= 0) {
                              posSeries[gni][j] += val;
                            } else {
                              negSeries[gni][j] += val;
                            }
                            sumSeries[gni][j] += val;
                            // For non bar-like series' we need these point max/min values.
                            lowestY = Math.min(lowestY, val);
                            highestY = Math.max(highestY, val);
                          }
                        }
                      });
                    }
                    if (seriesType === 'bar' || seriesType === 'column') {
                      gl.barGroups.push(seriesGroupName);
                    }
                  };
                  for (var i = 0; i < axisSeries.length; i++) {
                    _loop(i);
                  }
                  if (!seriesType) {
                    seriesType = cnf.chart.type;
                  }
                  if (seriesType === 'bar' || seriesType === 'column') {
                    groupNames.forEach(function (gn, gni) {
                      minY = Math.min(minY, Math.min.apply(null, negSeries[gni]));
                      maxY = Math.max(maxY, Math.max.apply(null, posSeries[gni]));
                    });
                  } else {
                    groupNames.forEach(function (gn, gni) {
                      lowestY = Math.min(lowestY, Math.min.apply(null, sumSeries[gni]));
                      highestY = Math.max(highestY, Math.max.apply(null, sumSeries[gni]));
                    });
                    minY = lowestY;
                    maxY = highestY;
                  }
                  if (minY === Number.MIN_VALUE && maxY === Number.MIN_VALUE) {
                    // No series data
                    maxY = -Number.MAX_VALUE;
                  }
                })();
              } else {
                for (var i = 0; i < axisSeries.length; i++) {
                  var si = axisSeries[i];
                  minY = Math.min(minY, minYArr[si]);
                  maxY = Math.max(maxY, maxYArr[si]);
                  var collapsed = !(gl.collapsedSeriesIndices.indexOf(si) < 0 && gl.ancillaryCollapsedSeriesIndices.indexOf(si) < 0);
                  if (!collapsed) {
                    gl.allSeriesCollapsed = false;
                  }
                }
              }
              if (cnf.yaxis[ai].min !== undefined) {
                if (typeof cnf.yaxis[ai].min === 'function') {
                  minY = cnf.yaxis[ai].min(minY);
                } else {
                  minY = cnf.yaxis[ai].min;
                }
              }
              if (cnf.yaxis[ai].max !== undefined) {
                if (typeof cnf.yaxis[ai].max === 'function') {
                  maxY = cnf.yaxis[ai].max(maxY);
                } else {
                  maxY = cnf.yaxis[ai].max;
                }
              }
              gl.barGroups = gl.barGroups.filter(function (v, i, a) {
                return a.indexOf(v) === i;
              });
              // Set the scale for this yaxis
              _this.setYScaleForIndex(ai, minY, maxY);
              // Set individual series min and max to nice values
              axisSeries.forEach(function (si) {
                minYArr[si] = gl.yAxisScale[ai].niceMin;
                maxYArr[si] = gl.yAxisScale[ai].niceMax;
              });
            })();
          } else {
            // No series referenced by this yaxis
            _this.setYScaleForIndex(ai, 0, -Number.MAX_VALUE);
          }
        });
      }
    }]);
    return Scales;
  }();

  /**
   * Range is used to generates values between min and max.
   *
   * @module Range
   **/
  var Range = /*#__PURE__*/function () {
    function Range(ctx) {
      _classCallCheck(this, Range);
      this.ctx = ctx;
      this.w = ctx.w;
      this.scales = new Scales(ctx);
    }
    _createClass(Range, [{
      key: "init",
      value: function init() {
        this.setYRange();
        this.setXRange();
        this.setZRange();
      }
    }, {
      key: "getMinYMaxY",
      value: function getMinYMaxY(startingSeriesIndex) {
        var lowestY = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : Number.MAX_VALUE;
        var highestY = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : -Number.MAX_VALUE;
        var endingSeriesIndex = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
        var cnf = this.w.config;
        var gl = this.w.globals;
        var maxY = -Number.MAX_VALUE;
        var minY = Number.MIN_VALUE;
        if (endingSeriesIndex === null) {
          endingSeriesIndex = startingSeriesIndex + 1;
        }
        var series = gl.series;
        var seriesMin = series;
        var seriesMax = series;
        if (cnf.chart.type === 'candlestick') {
          seriesMin = gl.seriesCandleL;
          seriesMax = gl.seriesCandleH;
        } else if (cnf.chart.type === 'boxPlot') {
          seriesMin = gl.seriesCandleO;
          seriesMax = gl.seriesCandleC;
        } else if (gl.isRangeData) {
          seriesMin = gl.seriesRangeStart;
          seriesMax = gl.seriesRangeEnd;
        }
        var autoScaleYaxis = false;
        if (gl.seriesX.length >= endingSeriesIndex) {
          var _gl$brushSource;
          // Eventually brushSource will be set if the current chart is a target.
          // That is, after the appropriate event causes us to update.
          var brush = (_gl$brushSource = gl.brushSource) === null || _gl$brushSource === void 0 ? void 0 : _gl$brushSource.w.config.chart.brush;
          if (cnf.chart.zoom.enabled && cnf.chart.zoom.autoScaleYaxis || brush !== null && brush !== void 0 && brush.enabled && brush !== null && brush !== void 0 && brush.autoScaleYaxis) {
            autoScaleYaxis = true;
          }
        }
        for (var i = startingSeriesIndex; i < endingSeriesIndex; i++) {
          gl.dataPoints = Math.max(gl.dataPoints, series[i].length);
          var seriesType = cnf.series[i].type;
          if (gl.categoryLabels.length) {
            gl.dataPoints = gl.categoryLabels.filter(function (label) {
              return typeof label !== 'undefined';
            }).length;
          }
          if (gl.labels.length && cnf.xaxis.type !== 'datetime' && gl.series.reduce(function (a, c) {
            return a + c.length;
          }, 0) !== 0) {
            // the condition cnf.xaxis.type !== 'datetime' fixes #3897 and #3905
            gl.dataPoints = Math.max(gl.dataPoints, gl.labels.length);
          }
          var firstXIndex = 0;
          var lastXIndex = series[i].length - 1;
          if (autoScaleYaxis) {
            // Scale the Y axis to the min..max within the possibly zoomed X axis domain.
            if (cnf.xaxis.min) {
              for (; firstXIndex < lastXIndex && gl.seriesX[i][firstXIndex] < cnf.xaxis.min; firstXIndex++) {}
            }
            if (cnf.xaxis.max) {
              for (; lastXIndex > firstXIndex && gl.seriesX[i][lastXIndex] > cnf.xaxis.max; lastXIndex--) {}
            }
          }
          for (var j = firstXIndex; j <= lastXIndex && j < gl.series[i].length; j++) {
            var val = series[i][j];
            if (val !== null && Utils$1.isNumber(val)) {
              var _seriesMax$i, _seriesMin$i, _seriesMin$i2, _seriesMin$i3;
              if (typeof ((_seriesMax$i = seriesMax[i]) === null || _seriesMax$i === void 0 ? void 0 : _seriesMax$i[j]) !== 'undefined') {
                maxY = Math.max(maxY, seriesMax[i][j]);
                lowestY = Math.min(lowestY, seriesMax[i][j]);
              }
              if (typeof ((_seriesMin$i = seriesMin[i]) === null || _seriesMin$i === void 0 ? void 0 : _seriesMin$i[j]) !== 'undefined') {
                lowestY = Math.min(lowestY, seriesMin[i][j]);
                highestY = Math.max(highestY, seriesMin[i][j]);
              }

              // These series arrays are dual purpose:
              // Array      : CandleO, CandleH, CandleM, CandleL, CandleC
              // Candlestick: O        H                 L        C
              // Boxplot    : Min      Q1       Median   Q3       Max
              switch (seriesType) {
                case 'candlestick':
                  {
                    if (typeof gl.seriesCandleC[i][j] !== 'undefined') {
                      maxY = Math.max(maxY, gl.seriesCandleH[i][j]);
                      lowestY = Math.min(lowestY, gl.seriesCandleL[i][j]);
                    }
                  }
                  break;
                case 'boxPlot':
                  {
                    if (typeof gl.seriesCandleC[i][j] !== 'undefined') {
                      maxY = Math.max(maxY, gl.seriesCandleC[i][j]);
                      lowestY = Math.min(lowestY, gl.seriesCandleO[i][j]);
                    }
                  }
                  break;
              }

              // there is a combo chart and the specified series in not either
              // candlestick, boxplot, or rangeArea/rangeBar; find the max there.
              if (seriesType && seriesType !== 'candlestick' && seriesType !== 'boxPlot' && seriesType !== 'rangeArea' && seriesType !== 'rangeBar') {
                maxY = Math.max(maxY, gl.series[i][j]);
                lowestY = Math.min(lowestY, gl.series[i][j]);
              }
              if (gl.seriesGoals[i] && gl.seriesGoals[i][j] && Array.isArray(gl.seriesGoals[i][j])) {
                gl.seriesGoals[i][j].forEach(function (g) {
                  maxY = Math.max(maxY, g.value);
                  lowestY = Math.min(lowestY, g.value);
                });
              }
              highestY = maxY;
              val = Utils$1.noExponents(val);
              if (Utils$1.isFloat(val)) {
                gl.yValueDecimal = Math.max(gl.yValueDecimal, val.toString().split('.')[1].length);
              }
              if (minY > ((_seriesMin$i2 = seriesMin[i]) === null || _seriesMin$i2 === void 0 ? void 0 : _seriesMin$i2[j]) && ((_seriesMin$i3 = seriesMin[i]) === null || _seriesMin$i3 === void 0 ? void 0 : _seriesMin$i3[j]) < 0) {
                minY = seriesMin[i][j];
              }
            } else {
              gl.hasNullValues = true;
            }
          }
          if (seriesType === 'bar' || seriesType === 'column') {
            if (minY < 0 && maxY < 0) {
              // all negative values in a bar series, hence make the max to 0
              maxY = 0;
              highestY = Math.max(highestY, 0);
            }
            if (minY === Number.MIN_VALUE) {
              minY = 0;
              lowestY = Math.min(lowestY, 0);
            }
          }
        }
        if (cnf.chart.type === 'rangeBar' && gl.seriesRangeStart.length && gl.isBarHorizontal) {
          minY = lowestY;
        }
        if (cnf.chart.type === 'bar') {
          if (minY < 0 && maxY < 0) {
            // all negative values in a bar chart, hence make the max to 0
            maxY = 0;
          }
          if (minY === Number.MIN_VALUE) {
            minY = 0;
          }
        }
        return {
          minY: minY,
          maxY: maxY,
          lowestY: lowestY,
          highestY: highestY
        };
      }
    }, {
      key: "setYRange",
      value: function setYRange() {
        var gl = this.w.globals;
        var cnf = this.w.config;
        gl.maxY = -Number.MAX_VALUE;
        gl.minY = Number.MIN_VALUE;
        var lowestYInAllSeries = Number.MAX_VALUE;
        var minYMaxY;
        if (gl.isMultipleYAxis) {
          // we need to get minY and maxY for multiple y axis
          lowestYInAllSeries = Number.MAX_VALUE;
          for (var i = 0; i < gl.series.length; i++) {
            minYMaxY = this.getMinYMaxY(i);
            gl.minYArr[i] = minYMaxY.lowestY;
            gl.maxYArr[i] = minYMaxY.highestY;
            lowestYInAllSeries = Math.min(lowestYInAllSeries, minYMaxY.lowestY);
          }
        }

        // and then, get the minY and maxY from all series
        minYMaxY = this.getMinYMaxY(0, lowestYInAllSeries, null, gl.series.length);
        if (cnf.chart.type === 'bar') {
          gl.minY = minYMaxY.minY;
          gl.maxY = minYMaxY.maxY;
        } else {
          gl.minY = minYMaxY.lowestY;
          gl.maxY = minYMaxY.highestY;
        }
        lowestYInAllSeries = minYMaxY.lowestY;
        if (cnf.chart.stacked) {
          this._setStackedMinMax();
        }

        // if the numbers are too big, reduce the range
        // for eg, if number is between 100000-110000, putting 0 as the lowest
        // value is not so good idea. So change the gl.minY for
        // line/area/scatter/candlesticks/boxPlot/vertical rangebar
        if (cnf.chart.type === 'line' || cnf.chart.type === 'area' || cnf.chart.type === 'scatter' || cnf.chart.type === 'candlestick' || cnf.chart.type === 'boxPlot' || cnf.chart.type === 'rangeBar' && !gl.isBarHorizontal) {
          if (gl.minY === Number.MIN_VALUE && lowestYInAllSeries !== -Number.MAX_VALUE && lowestYInAllSeries !== gl.maxY // single value possibility
          ) {
            gl.minY = lowestYInAllSeries;
          }
        } else {
          gl.minY = gl.minY !== Number.MIN_VALUE ? Math.min(minYMaxY.minY, gl.minY) : minYMaxY.minY;
        }
        cnf.yaxis.forEach(function (yaxe, index) {
          // override all min/max values by user defined values (y axis)
          if (yaxe.max !== undefined) {
            if (typeof yaxe.max === 'number') {
              gl.maxYArr[index] = yaxe.max;
            } else if (typeof yaxe.max === 'function') {
              // fixes apexcharts.js/issues/2098
              gl.maxYArr[index] = yaxe.max(gl.isMultipleYAxis ? gl.maxYArr[index] : gl.maxY);
            }

            // gl.maxY is for single y-axis chart, it will be ignored in multi-yaxis
            gl.maxY = gl.maxYArr[index];
          }
          if (yaxe.min !== undefined) {
            if (typeof yaxe.min === 'number') {
              gl.minYArr[index] = yaxe.min;
            } else if (typeof yaxe.min === 'function') {
              // fixes apexcharts.js/issues/2098
              gl.minYArr[index] = yaxe.min(gl.isMultipleYAxis ? gl.minYArr[index] === Number.MIN_VALUE ? 0 : gl.minYArr[index] : gl.minY);
            }
            // gl.minY is for single y-axis chart, it will be ignored in multi-yaxis
            gl.minY = gl.minYArr[index];
          }
        });

        // for horizontal bar charts, we need to check xaxis min/max as user may have specified there
        if (gl.isBarHorizontal) {
          var minmax = ['min', 'max'];
          minmax.forEach(function (m) {
            if (cnf.xaxis[m] !== undefined && typeof cnf.xaxis[m] === 'number') {
              m === 'min' ? gl.minY = cnf.xaxis[m] : gl.maxY = cnf.xaxis[m];
            }
          });
        }
        if (gl.isMultipleYAxis) {
          this.scales.scaleMultipleYAxes();
          gl.minY = lowestYInAllSeries;
        } else {
          this.scales.setYScaleForIndex(0, gl.minY, gl.maxY);
          gl.minY = gl.yAxisScale[0].niceMin;
          gl.maxY = gl.yAxisScale[0].niceMax;
          gl.minYArr[0] = gl.minY;
          gl.maxYArr[0] = gl.maxY;
        }
        gl.barGroups = [];
        gl.lineGroups = [];
        gl.areaGroups = [];
        cnf.series.forEach(function (s) {
          var type = s.type || cnf.chart.type;
          switch (type) {
            case 'bar':
            case 'column':
              gl.barGroups.push(s.group);
              break;
            case 'line':
              gl.lineGroups.push(s.group);
              break;
            case 'area':
              gl.areaGroups.push(s.group);
              break;
          }
        });
        // Uniquify the group names in each stackable chart type.
        gl.barGroups = gl.barGroups.filter(function (v, i, a) {
          return a.indexOf(v) === i;
        });
        gl.lineGroups = gl.lineGroups.filter(function (v, i, a) {
          return a.indexOf(v) === i;
        });
        gl.areaGroups = gl.areaGroups.filter(function (v, i, a) {
          return a.indexOf(v) === i;
        });
        return {
          minY: gl.minY,
          maxY: gl.maxY,
          minYArr: gl.minYArr,
          maxYArr: gl.maxYArr,
          yAxisScale: gl.yAxisScale
        };
      }
    }, {
      key: "setXRange",
      value: function setXRange() {
        var gl = this.w.globals;
        var cnf = this.w.config;
        var isXNumeric = cnf.xaxis.type === 'numeric' || cnf.xaxis.type === 'datetime' || cnf.xaxis.type === 'category' && !gl.noLabelsProvided || gl.noLabelsProvided || gl.isXNumeric;
        var getInitialMinXMaxX = function getInitialMinXMaxX() {
          for (var i = 0; i < gl.series.length; i++) {
            if (gl.labels[i]) {
              for (var j = 0; j < gl.labels[i].length; j++) {
                if (gl.labels[i][j] !== null && Utils$1.isNumber(gl.labels[i][j])) {
                  gl.maxX = Math.max(gl.maxX, gl.labels[i][j]);
                  gl.initialMaxX = Math.max(gl.maxX, gl.labels[i][j]);
                  gl.minX = Math.min(gl.minX, gl.labels[i][j]);
                  gl.initialMinX = Math.min(gl.minX, gl.labels[i][j]);
                }
              }
            }
          }
        };
        // minX maxX starts here
        if (gl.isXNumeric) {
          getInitialMinXMaxX();
        }
        if (gl.noLabelsProvided) {
          if (cnf.xaxis.categories.length === 0) {
            gl.maxX = gl.labels[gl.labels.length - 1];
            gl.initialMaxX = gl.labels[gl.labels.length - 1];
            gl.minX = 1;
            gl.initialMinX = 1;
          }
        }
        if (gl.isXNumeric || gl.noLabelsProvided || gl.dataFormatXNumeric) {
          var ticks = 10;
          if (cnf.xaxis.tickAmount === undefined) {
            ticks = Math.round(gl.svgWidth / 150);

            // no labels provided and total number of dataPoints is less than 30
            if (cnf.xaxis.type === 'numeric' && gl.dataPoints < 30) {
              ticks = gl.dataPoints - 1;
            }

            // this check is for when ticks exceeds total datapoints and that would result in duplicate labels
            if (ticks > gl.dataPoints && gl.dataPoints !== 0) {
              ticks = gl.dataPoints - 1;
            }
          } else if (cnf.xaxis.tickAmount === 'dataPoints') {
            if (gl.series.length > 1) {
              ticks = gl.series[gl.maxValsInArrayIndex].length - 1;
            }
            if (gl.isXNumeric) {
              var diff = Math.round(gl.maxX - gl.minX);
              if (diff < 30) {
                // When numeric range is small, show a tick for every integer
                ticks = diff;
              }
            }
          } else {
            ticks = cnf.xaxis.tickAmount;
          }
          gl.xTickAmount = ticks;

          // override all min/max values by user defined values (x axis)
          if (cnf.xaxis.max !== undefined && typeof cnf.xaxis.max === 'number') {
            gl.maxX = cnf.xaxis.max;
          }
          if (cnf.xaxis.min !== undefined && typeof cnf.xaxis.min === 'number') {
            gl.minX = cnf.xaxis.min;
          }

          // if range is provided, adjust the new minX
          if (cnf.xaxis.range !== undefined) {
            gl.minX = gl.maxX - cnf.xaxis.range;
          }
          if (gl.minX !== Number.MAX_VALUE && gl.maxX !== -Number.MAX_VALUE) {
            if (cnf.xaxis.convertedCatToNumeric && !gl.dataFormatXNumeric) {
              var catScale = [];
              for (var i = gl.minX - 1; i < gl.maxX; i++) {
                catScale.push(i + 1);
              }
              gl.xAxisScale = {
                result: catScale,
                niceMin: catScale[0],
                niceMax: catScale[catScale.length - 1]
              };
            } else {
              gl.xAxisScale = this.scales.setXScale(gl.minX, gl.maxX);
            }
          } else {
            gl.xAxisScale = this.scales.linearScale(0, ticks, ticks, 0, cnf.xaxis.stepSize);
            if (gl.noLabelsProvided && gl.labels.length > 0) {
              gl.xAxisScale = this.scales.linearScale(1, gl.labels.length, ticks - 1, 0, cnf.xaxis.stepSize);

              // this is the only place seriesX is again mutated
              gl.seriesX = gl.labels.slice();
            }
          }
          // we will still store these labels as the count for this will be different (to draw grid and labels placement)
          if (isXNumeric) {
            gl.labels = gl.xAxisScale.result.slice();
          }
        }
        if (gl.isBarHorizontal && gl.labels.length) {
          gl.xTickAmount = gl.labels.length;
        }

        // single dataPoint
        this._handleSingleDataPoint();

        // minimum x difference to calculate bar width in numeric bars
        this._getMinXDiff();
        return {
          minX: gl.minX,
          maxX: gl.maxX
        };
      }
    }, {
      key: "setZRange",
      value: function setZRange() {
        // minZ, maxZ starts here
        var gl = this.w.globals;
        if (!gl.isDataXYZ) return;
        for (var i = 0; i < gl.series.length; i++) {
          if (typeof gl.seriesZ[i] !== 'undefined') {
            for (var j = 0; j < gl.seriesZ[i].length; j++) {
              if (gl.seriesZ[i][j] !== null && Utils$1.isNumber(gl.seriesZ[i][j])) {
                gl.maxZ = Math.max(gl.maxZ, gl.seriesZ[i][j]);
                gl.minZ = Math.min(gl.minZ, gl.seriesZ[i][j]);
              }
            }
          }
        }
      }
    }, {
      key: "_handleSingleDataPoint",
      value: function _handleSingleDataPoint() {
        var gl = this.w.globals;
        var cnf = this.w.config;
        if (gl.minX === gl.maxX) {
          var datetimeObj = new DateTime(this.ctx);
          if (cnf.xaxis.type === 'datetime') {
            var newMinX = datetimeObj.getDate(gl.minX);
            if (cnf.xaxis.labels.datetimeUTC) {
              newMinX.setUTCDate(newMinX.getUTCDate() - 2);
            } else {
              newMinX.setDate(newMinX.getDate() - 2);
            }
            gl.minX = new Date(newMinX).getTime();
            var newMaxX = datetimeObj.getDate(gl.maxX);
            if (cnf.xaxis.labels.datetimeUTC) {
              newMaxX.setUTCDate(newMaxX.getUTCDate() + 2);
            } else {
              newMaxX.setDate(newMaxX.getDate() + 2);
            }
            gl.maxX = new Date(newMaxX).getTime();
          } else if (cnf.xaxis.type === 'numeric' || cnf.xaxis.type === 'category' && !gl.noLabelsProvided) {
            gl.minX = gl.minX - 2;
            gl.initialMinX = gl.minX;
            gl.maxX = gl.maxX + 2;
            gl.initialMaxX = gl.maxX;
          }
        }
      }
    }, {
      key: "_getMinXDiff",
      value: function _getMinXDiff() {
        var gl = this.w.globals;
        if (gl.isXNumeric) {
          // get the least x diff if numeric x axis is present
          gl.seriesX.forEach(function (sX, i) {
            if (sX.length) {
              if (sX.length === 1) {
                // a small hack to prevent overlapping multiple bars when there is just 1 datapoint in bar series.
                // fix #811
                sX.push(gl.seriesX[gl.maxValsInArrayIndex][gl.seriesX[gl.maxValsInArrayIndex].length - 1]);
              }

              // fix #983 (clone the array to avoid side effects)
              var seriesX = sX.slice();
              seriesX.sort(function (a, b) {
                return a - b;
              });
              seriesX.forEach(function (s, j) {
                if (j > 0) {
                  var xDiff = s - seriesX[j - 1];
                  if (xDiff > 0) {
                    gl.minXDiff = Math.min(xDiff, gl.minXDiff);
                  }
                }
              });
              if (gl.dataPoints === 1 || gl.minXDiff === Number.MAX_VALUE) {
                // fixes apexcharts.js #1221
                gl.minXDiff = 0.5;
              }
            }
          });
        }
      }
    }, {
      key: "_setStackedMinMax",
      value: function _setStackedMinMax() {
        var _this = this;
        var gl = this.w.globals;
        // for stacked charts, we calculate each series's parallel values.
        // i.e, series[0][j] + series[1][j] .... [series[i.length][j]]
        // and get the max out of it

        if (!gl.series.length) return;
        var seriesGroups = gl.seriesGroups;
        if (!seriesGroups.length) {
          seriesGroups = [this.w.globals.seriesNames.map(function (name) {
            return name;
          })];
        }
        var stackedPoss = {};
        var stackedNegs = {};
        seriesGroups.forEach(function (group) {
          stackedPoss[group] = [];
          stackedNegs[group] = [];
          var indicesOfSeriesInGroup = _this.w.config.series.map(function (serie, si) {
            return group.indexOf(gl.seriesNames[si]) > -1 ? si : null;
          }).filter(function (f) {
            return f !== null;
          });
          indicesOfSeriesInGroup.forEach(function (i) {
            for (var j = 0; j < gl.series[gl.maxValsInArrayIndex].length; j++) {
              var _this$w$config$series, _this$w$config$series2, _this$w$config$series3, _this$w$config$series4;
              if (typeof stackedPoss[group][j] === 'undefined') {
                stackedPoss[group][j] = 0;
                stackedNegs[group][j] = 0;
              }
              var stackSeries = _this.w.config.chart.stacked && !gl.comboCharts || _this.w.config.chart.stacked && gl.comboCharts && (!_this.w.config.chart.stackOnlyBar || ((_this$w$config$series = _this.w.config.series) === null || _this$w$config$series === void 0 ? void 0 : (_this$w$config$series2 = _this$w$config$series[i]) === null || _this$w$config$series2 === void 0 ? void 0 : _this$w$config$series2.type) === 'bar' || ((_this$w$config$series3 = _this.w.config.series) === null || _this$w$config$series3 === void 0 ? void 0 : (_this$w$config$series4 = _this$w$config$series3[i]) === null || _this$w$config$series4 === void 0 ? void 0 : _this$w$config$series4.type) === 'column');
              if (stackSeries) {
                if (gl.series[i][j] !== null && Utils$1.isNumber(gl.series[i][j])) {
                  gl.series[i][j] > 0 ? stackedPoss[group][j] += parseFloat(gl.series[i][j]) + 0.0001 : stackedNegs[group][j] += parseFloat(gl.series[i][j]);
                }
              }
            }
          });
        });
        Object.entries(stackedPoss).forEach(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 1),
            key = _ref2[0];
          stackedPoss[key].forEach(function (_, stgi) {
            gl.maxY = Math.max(gl.maxY, stackedPoss[key][stgi]);
            gl.minY = Math.min(gl.minY, stackedNegs[key][stgi]);
          });
        });
      }
    }]);
    return Range;
  }();

  /**
   * ApexCharts YAxis Class for drawing Y-Axis.
   *
   * @module YAxis
   **/
  var YAxis = /*#__PURE__*/function () {
    function YAxis(ctx, elgrid) {
      _classCallCheck(this, YAxis);
      this.ctx = ctx;
      this.elgrid = elgrid;
      this.w = ctx.w;
      var w = this.w;
      this.xaxisFontSize = w.config.xaxis.labels.style.fontSize;
      this.axisFontFamily = w.config.xaxis.labels.style.fontFamily;
      this.xaxisForeColors = w.config.xaxis.labels.style.colors;
      this.isCategoryBarHorizontal = w.config.chart.type === 'bar' && w.config.plotOptions.bar.horizontal;
      this.xAxisoffX = w.config.xaxis.position === 'bottom' ? w.globals.gridHeight : 0;
      this.drawnLabels = [];
      this.axesUtils = new AxesUtils(ctx);
    }
    _createClass(YAxis, [{
      key: "drawYaxis",
      value: function drawYaxis(realIndex) {
        var w = this.w;
        var graphics = new Graphics(this.ctx);
        var yaxisStyle = w.config.yaxis[realIndex].labels.style;
        var yaxisFontSize = yaxisStyle.fontSize,
          yaxisFontFamily = yaxisStyle.fontFamily,
          yaxisFontWeight = yaxisStyle.fontWeight;
        var elYaxis = graphics.group({
          class: 'apexcharts-yaxis',
          rel: realIndex,
          transform: "translate(".concat(w.globals.translateYAxisX[realIndex], ", 0)")
        });
        if (this.axesUtils.isYAxisHidden(realIndex)) return elYaxis;
        var elYaxisTexts = graphics.group({
          class: 'apexcharts-yaxis-texts-g'
        });
        elYaxis.add(elYaxisTexts);
        var tickAmount = w.globals.yAxisScale[realIndex].result.length - 1;
        var labelsDivider = w.globals.gridHeight / tickAmount;
        var lbFormatter = w.globals.yLabelFormatters[realIndex];
        var labels = this.axesUtils.checkForReversedLabels(realIndex, w.globals.yAxisScale[realIndex].result.slice());
        if (w.config.yaxis[realIndex].labels.show) {
          var lY = w.globals.translateY + w.config.yaxis[realIndex].labels.offsetY;
          if (w.globals.isBarHorizontal) lY = 0;else if (w.config.chart.type === 'heatmap') lY -= labelsDivider / 2;
          lY += parseInt(yaxisFontSize, 10) / 3;
          for (var i = tickAmount; i >= 0; i--) {
            var val = lbFormatter(labels[i], i, w);
            var xPad = w.config.yaxis[realIndex].labels.padding;
            if (w.config.yaxis[realIndex].opposite && w.config.yaxis.length !== 0) xPad *= -1;
            var textAnchor = this.getTextAnchor(w.config.yaxis[realIndex].labels.align, w.config.yaxis[realIndex].opposite);
            var yColors = this.axesUtils.getYAxisForeColor(yaxisStyle.colors, realIndex);
            var foreColor = Array.isArray(yColors) ? yColors[i] : yColors;
            var existingYLabels = Utils$1.listToArray(w.globals.dom.baseEl.querySelectorAll(".apexcharts-yaxis[rel='".concat(realIndex, "'] .apexcharts-yaxis-label tspan"))).map(function (label) {
              return label.textContent;
            });
            var label = graphics.drawText({
              x: xPad,
              y: lY,
              text: existingYLabels.includes(val) && !w.config.yaxis[realIndex].labels.showDuplicates ? '' : val,
              textAnchor: textAnchor,
              fontSize: yaxisFontSize,
              fontFamily: yaxisFontFamily,
              fontWeight: yaxisFontWeight,
              maxWidth: w.config.yaxis[realIndex].labels.maxWidth,
              foreColor: foreColor,
              isPlainText: false,
              cssClass: "apexcharts-yaxis-label ".concat(yaxisStyle.cssClass)
            });
            elYaxisTexts.add(label);
            this.addTooltip(label, val);
            if (w.config.yaxis[realIndex].labels.rotate !== 0) {
              this.rotateLabel(graphics, label, firstLabel, w.config.yaxis[realIndex].labels.rotate);
            }
            lY += labelsDivider;
          }
        }
        this.addYAxisTitle(graphics, elYaxis, realIndex);
        this.addAxisBorder(graphics, elYaxis, realIndex, tickAmount, labelsDivider);
        return elYaxis;
      }
    }, {
      key: "getTextAnchor",
      value: function getTextAnchor(align, opposite) {
        if (align === 'left') return 'start';
        if (align === 'center') return 'middle';
        if (align === 'right') return 'end';
        return opposite ? 'start' : 'end';
      }
    }, {
      key: "addTooltip",
      value: function addTooltip(label, val) {
        var elTooltipTitle = document.createElementNS(this.w.globals.SVGNS, 'title');
        elTooltipTitle.textContent = Array.isArray(val) ? val.join(' ') : val;
        label.node.appendChild(elTooltipTitle);
      }
    }, {
      key: "rotateLabel",
      value: function rotateLabel(graphics, label, firstLabel, rotate) {
        var firstLabelCenter = graphics.rotateAroundCenter(firstLabel.node);
        var labelCenter = graphics.rotateAroundCenter(label.node);
        label.node.setAttribute('transform', "rotate(".concat(rotate, " ").concat(firstLabelCenter.x, " ").concat(labelCenter.y, ")"));
      }
    }, {
      key: "addYAxisTitle",
      value: function addYAxisTitle(graphics, elYaxis, realIndex) {
        var w = this.w;
        if (w.config.yaxis[realIndex].title.text !== undefined) {
          var elYaxisTitle = graphics.group({
            class: 'apexcharts-yaxis-title'
          });
          var x = w.config.yaxis[realIndex].opposite ? w.globals.translateYAxisX[realIndex] : 0;
          var elYAxisTitleText = graphics.drawText({
            x: x,
            y: w.globals.gridHeight / 2 + w.globals.translateY + w.config.yaxis[realIndex].title.offsetY,
            text: w.config.yaxis[realIndex].title.text,
            textAnchor: 'end',
            foreColor: w.config.yaxis[realIndex].title.style.color,
            fontSize: w.config.yaxis[realIndex].title.style.fontSize,
            fontWeight: w.config.yaxis[realIndex].title.style.fontWeight,
            fontFamily: w.config.yaxis[realIndex].title.style.fontFamily,
            cssClass: "apexcharts-yaxis-title-text ".concat(w.config.yaxis[realIndex].title.style.cssClass)
          });
          elYaxisTitle.add(elYAxisTitleText);
          elYaxis.add(elYaxisTitle);
        }
      }
    }, {
      key: "addAxisBorder",
      value: function addAxisBorder(graphics, elYaxis, realIndex, tickAmount, labelsDivider) {
        var w = this.w;
        var axisBorder = w.config.yaxis[realIndex].axisBorder;
        var x = 31 + axisBorder.offsetX;
        if (w.config.yaxis[realIndex].opposite) x = -31 - axisBorder.offsetX;
        if (axisBorder.show) {
          var elVerticalLine = graphics.drawLine(x, w.globals.translateY + axisBorder.offsetY - 2, x, w.globals.gridHeight + w.globals.translateY + axisBorder.offsetY + 2, axisBorder.color, 0, axisBorder.width);
          elYaxis.add(elVerticalLine);
        }
        if (w.config.yaxis[realIndex].axisTicks.show) {
          this.axesUtils.drawYAxisTicks(x, tickAmount, axisBorder, w.config.yaxis[realIndex].axisTicks, realIndex, labelsDivider, elYaxis);
        }
      }
    }, {
      key: "drawYaxisInversed",
      value: function drawYaxisInversed(realIndex) {
        var w = this.w;
        var graphics = new Graphics(this.ctx);
        var elXaxis = graphics.group({
          class: 'apexcharts-xaxis apexcharts-yaxis-inversed'
        });
        var elXaxisTexts = graphics.group({
          class: 'apexcharts-xaxis-texts-g',
          transform: "translate(".concat(w.globals.translateXAxisX, ", ").concat(w.globals.translateXAxisY, ")")
        });
        elXaxis.add(elXaxisTexts);
        var tickAmount = w.globals.yAxisScale[realIndex].result.length - 1;
        var labelsDivider = w.globals.gridWidth / tickAmount + 0.1;
        var l = labelsDivider + w.config.xaxis.labels.offsetX;
        var lbFormatter = w.globals.xLabelFormatter;
        var labels = this.axesUtils.checkForReversedLabels(realIndex, w.globals.yAxisScale[realIndex].result.slice());
        var timescaleLabels = w.globals.timescaleLabels;
        if (timescaleLabels.length > 0) {
          this.xaxisLabels = timescaleLabels.slice();
          labels = timescaleLabels.slice();
          tickAmount = labels.length;
        }
        if (w.config.xaxis.labels.show) {
          for (var i = timescaleLabels.length ? 0 : tickAmount; timescaleLabels.length ? i < timescaleLabels.length : i >= 0; timescaleLabels.length ? i++ : i--) {
            var val = lbFormatter(labels[i], i, w);
            var x = w.globals.gridWidth + w.globals.padHorizontal - (l - labelsDivider + w.config.xaxis.labels.offsetX);
            if (timescaleLabels.length) {
              var label = this.axesUtils.getLabel(labels, timescaleLabels, x, i, this.drawnLabels, this.xaxisFontSize);
              x = label.x;
              val = label.text;
              this.drawnLabels.push(label.text);
              if (i === 0 && w.globals.skipFirstTimelinelabel) val = '';
              if (i === labels.length - 1 && w.globals.skipLastTimelinelabel) val = '';
            }
            var elTick = graphics.drawText({
              x: x,
              y: this.xAxisoffX + w.config.xaxis.labels.offsetY + 30 - (w.config.xaxis.position === 'top' ? w.globals.xAxisHeight + w.config.xaxis.axisTicks.height - 2 : 0),
              text: val,
              textAnchor: 'middle',
              foreColor: Array.isArray(this.xaxisForeColors) ? this.xaxisForeColors[realIndex] : this.xaxisForeColors,
              fontSize: this.xaxisFontSize,
              fontFamily: this.xaxisFontFamily,
              fontWeight: w.config.xaxis.labels.style.fontWeight,
              isPlainText: false,
              cssClass: "apexcharts-xaxis-label ".concat(w.config.xaxis.labels.style.cssClass)
            });
            elXaxisTexts.add(elTick);
            elTick.tspan(val);
            this.addTooltip(elTick, val);
            l += labelsDivider;
          }
        }
        this.inversedYAxisTitleText(elXaxis);
        this.inversedYAxisBorder(elXaxis);
        return elXaxis;
      }
    }, {
      key: "inversedYAxisBorder",
      value: function inversedYAxisBorder(parent) {
        var w = this.w;
        var graphics = new Graphics(this.ctx);
        var axisBorder = w.config.xaxis.axisBorder;
        if (axisBorder.show) {
          var lineCorrection = 0;
          if (w.config.chart.type === 'bar' && w.globals.isXNumeric) lineCorrection -= 15;
          var elHorzLine = graphics.drawLine(w.globals.padHorizontal + lineCorrection + axisBorder.offsetX, this.xAxisoffX, w.globals.gridWidth, this.xAxisoffX, axisBorder.color, 0, axisBorder.height);
          if (this.elgrid && this.elgrid.elGridBorders && w.config.grid.show) {
            this.elgrid.elGridBorders.add(elHorzLine);
          } else {
            parent.add(elHorzLine);
          }
        }
      }
    }, {
      key: "inversedYAxisTitleText",
      value: function inversedYAxisTitleText(parent) {
        var w = this.w;
        var graphics = new Graphics(this.ctx);
        if (w.config.xaxis.title.text !== undefined) {
          var elYaxisTitle = graphics.group({
            class: 'apexcharts-xaxis-title apexcharts-yaxis-title-inversed'
          });
          var elYAxisTitleText = graphics.drawText({
            x: w.globals.gridWidth / 2 + w.config.xaxis.title.offsetX,
            y: this.xAxisoffX + parseFloat(this.xaxisFontSize) + parseFloat(w.config.xaxis.title.style.fontSize) + w.config.xaxis.title.offsetY + 20,
            text: w.config.xaxis.title.text,
            textAnchor: 'middle',
            fontSize: w.config.xaxis.title.style.fontSize,
            fontFamily: w.config.xaxis.title.style.fontFamily,
            fontWeight: w.config.xaxis.title.style.fontWeight,
            foreColor: w.config.xaxis.title.style.color,
            cssClass: "apexcharts-xaxis-title-text ".concat(w.config.xaxis.title.style.cssClass)
          });
          elYaxisTitle.add(elYAxisTitleText);
          parent.add(elYaxisTitle);
        }
      }
    }, {
      key: "yAxisTitleRotate",
      value: function yAxisTitleRotate(realIndex, yAxisOpposite) {
        var w = this.w;
        var graphics = new Graphics(this.ctx);
        var elYAxisLabelsWrap = w.globals.dom.baseEl.querySelector(".apexcharts-yaxis[rel='".concat(realIndex, "'] .apexcharts-yaxis-texts-g"));
        var yAxisLabelsCoord = elYAxisLabelsWrap ? elYAxisLabelsWrap.getBoundingClientRect() : {
          width: 0,
          height: 0
        };
        var yAxisTitle = w.globals.dom.baseEl.querySelector(".apexcharts-yaxis[rel='".concat(realIndex, "'] .apexcharts-yaxis-title text"));
        var yAxisTitleCoord = yAxisTitle ? yAxisTitle.getBoundingClientRect() : {
          width: 0,
          height: 0
        };
        if (yAxisTitle) {
          var x = this.xPaddingForYAxisTitle(realIndex, yAxisLabelsCoord, yAxisTitleCoord, yAxisOpposite);
          yAxisTitle.setAttribute('x', x.xPos - (yAxisOpposite ? 10 : 0));
          var titleRotatingCenter = graphics.rotateAroundCenter(yAxisTitle);
          yAxisTitle.setAttribute('transform', "rotate(".concat(yAxisOpposite ? w.config.yaxis[realIndex].title.rotate * -1 : w.config.yaxis[realIndex].title.rotate, " ").concat(titleRotatingCenter.x, " ").concat(titleRotatingCenter.y, ")"));
        }
      }
    }, {
      key: "xPaddingForYAxisTitle",
      value: function xPaddingForYAxisTitle(realIndex, yAxisLabelsCoord, yAxisTitleCoord, yAxisOpposite) {
        var w = this.w;
        var x = 0;
        var padd = 10;
        if (w.config.yaxis[realIndex].title.text === undefined || realIndex < 0) {
          return {
            xPos: x,
            padd: 0
          };
        }
        if (yAxisOpposite) {
          x = yAxisLabelsCoord.width + w.config.yaxis[realIndex].title.offsetX + yAxisTitleCoord.width / 2 + padd / 2;
        } else {
          x = yAxisLabelsCoord.width * -1 + w.config.yaxis[realIndex].title.offsetX + padd / 2 + yAxisTitleCoord.width / 2;
          if (w.globals.isBarHorizontal) {
            padd = 25;
            x = yAxisLabelsCoord.width * -1 - w.config.yaxis[realIndex].title.offsetX - padd;
          }
        }
        return {
          xPos: x,
          padd: padd
        };
      }
    }, {
      key: "setYAxisXPosition",
      value: function setYAxisXPosition(yaxisLabelCoords, yTitleCoords) {
        var w = this.w;
        var xLeft = 0;
        var xRight = 0;
        var leftOffsetX = 18;
        var rightOffsetX = 1;
        if (w.config.yaxis.length > 1) this.multipleYs = true;
        w.config.yaxis.forEach(function (yaxe, index) {
          var shouldNotDrawAxis = w.globals.ignoreYAxisIndexes.includes(index) || !yaxe.show || yaxe.floating || yaxisLabelCoords[index].width === 0;
          var axisWidth = yaxisLabelCoords[index].width + yTitleCoords[index].width;
          if (!yaxe.opposite) {
            xLeft = w.globals.translateX - leftOffsetX;
            if (!shouldNotDrawAxis) leftOffsetX += axisWidth + 20;
            w.globals.translateYAxisX[index] = xLeft + yaxe.labels.offsetX;
          } else {
            if (w.globals.isBarHorizontal) {
              xRight = w.globals.gridWidth + w.globals.translateX - 1;
              w.globals.translateYAxisX[index] = xRight - yaxe.labels.offsetX;
            } else {
              xRight = w.globals.gridWidth + w.globals.translateX + rightOffsetX;
              if (!shouldNotDrawAxis) rightOffsetX += axisWidth + 20;
              w.globals.translateYAxisX[index] = xRight - yaxe.labels.offsetX + 20;
            }
          }
        });
      }
    }, {
      key: "setYAxisTextAlignments",
      value: function setYAxisTextAlignments() {
        var w = this.w;
        var yaxis = Utils$1.listToArray(w.globals.dom.baseEl.getElementsByClassName('apexcharts-yaxis'));
        yaxis.forEach(function (y, index) {
          var yaxe = w.config.yaxis[index];
          if (yaxe && !yaxe.floating && yaxe.labels.align !== undefined) {
            var yAxisInner = w.globals.dom.baseEl.querySelector(".apexcharts-yaxis[rel='".concat(index, "'] .apexcharts-yaxis-texts-g"));
            var yAxisTexts = Utils$1.listToArray(w.globals.dom.baseEl.querySelectorAll(".apexcharts-yaxis[rel='".concat(index, "'] .apexcharts-yaxis-label")));
            var rect = yAxisInner.getBoundingClientRect();
            yAxisTexts.forEach(function (label) {
              label.setAttribute('text-anchor', yaxe.labels.align);
            });
            if (yaxe.labels.align === 'left' && !yaxe.opposite) {
              yAxisInner.setAttribute('transform', "translate(-".concat(rect.width, ", 0)"));
            } else if (yaxe.labels.align === 'center') {
              yAxisInner.setAttribute('transform', "translate(".concat(rect.width / 2 * (!yaxe.opposite ? -1 : 1), ", 0)"));
            } else if (yaxe.labels.align === 'right' && yaxe.opposite) {
              yAxisInner.setAttribute('transform', "translate(".concat(rect.width, ", 0)"));
            }
          }
        });
      }
    }]);
    return YAxis;
  }();

  var Events = /*#__PURE__*/function () {
    function Events(ctx) {
      _classCallCheck(this, Events);
      this.ctx = ctx;
      this.w = ctx.w;
      this.documentEvent = Utils$1.bind(this.documentEvent, this);
    }
    _createClass(Events, [{
      key: "addEventListener",
      value: function addEventListener(name, handler) {
        var w = this.w;
        if (w.globals.events.hasOwnProperty(name)) {
          w.globals.events[name].push(handler);
        } else {
          w.globals.events[name] = [handler];
        }
      }
    }, {
      key: "removeEventListener",
      value: function removeEventListener(name, handler) {
        var w = this.w;
        if (!w.globals.events.hasOwnProperty(name)) {
          return;
        }
        var index = w.globals.events[name].indexOf(handler);
        if (index !== -1) {
          w.globals.events[name].splice(index, 1);
        }
      }
    }, {
      key: "fireEvent",
      value: function fireEvent(name, args) {
        var w = this.w;
        if (!w.globals.events.hasOwnProperty(name)) {
          return;
        }
        if (!args || !args.length) {
          args = [];
        }
        var evs = w.globals.events[name];
        var l = evs.length;
        for (var i = 0; i < l; i++) {
          evs[i].apply(null, args);
        }
      }
    }, {
      key: "setupEventHandlers",
      value: function setupEventHandlers() {
        var _this = this;
        var w = this.w;
        var me = this.ctx;
        var clickableArea = w.globals.dom.baseEl.querySelector(w.globals.chartClass);
        this.ctx.eventList.forEach(function (event) {
          clickableArea.addEventListener(event, function (e) {
            var capturedSeriesIndex = e.target.getAttribute('i') === null && w.globals.capturedSeriesIndex !== -1 ? w.globals.capturedSeriesIndex : e.target.getAttribute('i');
            var capturedDataPointIndex = e.target.getAttribute('j') === null && w.globals.capturedDataPointIndex !== -1 ? w.globals.capturedDataPointIndex : e.target.getAttribute('j');
            var opts = Object.assign({}, w, {
              seriesIndex: w.globals.axisCharts ? capturedSeriesIndex : 0,
              dataPointIndex: capturedDataPointIndex
            });
            if (e.type === 'mousemove' || e.type === 'touchmove') {
              if (typeof w.config.chart.events.mouseMove === 'function') {
                w.config.chart.events.mouseMove(e, me, opts);
              }
            } else if (e.type === 'mouseleave' || e.type === 'touchleave') {
              if (typeof w.config.chart.events.mouseLeave === 'function') {
                w.config.chart.events.mouseLeave(e, me, opts);
              }
            } else if (e.type === 'mouseup' && e.which === 1 || e.type === 'touchend') {
              if (typeof w.config.chart.events.click === 'function') {
                w.config.chart.events.click(e, me, opts);
              }
              me.ctx.events.fireEvent('click', [e, me, opts]);
            }
          }, {
            capture: false,
            passive: true
          });
        });
        this.ctx.eventList.forEach(function (event) {
          w.globals.dom.baseEl.addEventListener(event, _this.documentEvent, {
            passive: true
          });
        });
        this.ctx.core.setupBrushHandler();
      }
    }, {
      key: "documentEvent",
      value: function documentEvent(e) {
        var w = this.w;
        var target = e.target.className;
        if (e.type === 'click') {
          var elMenu = w.globals.dom.baseEl.querySelector('.apexcharts-menu');
          if (elMenu && elMenu.classList.contains('apexcharts-menu-open') && target !== 'apexcharts-menu-icon') {
            elMenu.classList.remove('apexcharts-menu-open');
          }
        }
        w.globals.clientX = e.type === 'touchmove' ? e.touches[0].clientX : e.clientX;
        w.globals.clientY = e.type === 'touchmove' ? e.touches[0].clientY : e.clientY;
      }
    }]);
    return Events;
  }();

  var Localization = /*#__PURE__*/function () {
    function Localization(ctx) {
      _classCallCheck(this, Localization);
      this.ctx = ctx;
      this.w = ctx.w;
    }
    _createClass(Localization, [{
      key: "setCurrentLocaleValues",
      value: function setCurrentLocaleValues(localeName) {
        var locales = this.w.config.chart.locales;

        // check if user has specified locales in global Apex variable
        // if yes - then extend those with local chart's locale
        if (window.Apex.chart && window.Apex.chart.locales && window.Apex.chart.locales.length > 0) {
          locales = this.w.config.chart.locales.concat(window.Apex.chart.locales);
        }

        // find the locale from the array of locales which user has set (either by chart.defaultLocale or by calling setLocale() method.)
        var selectedLocale = locales.filter(function (c) {
          return c.name === localeName;
        })[0];
        if (selectedLocale) {
          // create a complete locale object by extending defaults so you don't get undefined errors.
          var ret = Utils$1.extend(en, selectedLocale);

          // store these locale options in global var for ease access
          this.w.globals.locale = ret.options;
        } else {
          throw new Error('Wrong locale name provided. Please make sure you set the correct locale name in options');
        }
      }
    }]);
    return Localization;
  }();

  var Axes = /*#__PURE__*/function () {
    function Axes(ctx) {
      _classCallCheck(this, Axes);
      this.ctx = ctx;
      this.w = ctx.w;
    }
    _createClass(Axes, [{
      key: "drawAxis",
      value: function drawAxis(type, elgrid) {
        var _this = this;
        var gl = this.w.globals;
        var cnf = this.w.config;
        var xAxis = new XAxis(this.ctx, elgrid);
        var yAxis = new YAxis(this.ctx, elgrid);
        if (gl.axisCharts && type !== 'radar') {
          var elXaxis, elYaxis;
          if (gl.isBarHorizontal) {
            elYaxis = yAxis.drawYaxisInversed(0);
            elXaxis = xAxis.drawXaxisInversed(0);
            gl.dom.elGraphical.add(elXaxis);
            gl.dom.elGraphical.add(elYaxis);
          } else {
            elXaxis = xAxis.drawXaxis();
            gl.dom.elGraphical.add(elXaxis);
            cnf.yaxis.map(function (yaxe, index) {
              if (gl.ignoreYAxisIndexes.indexOf(index) === -1) {
                elYaxis = yAxis.drawYaxis(index);
                gl.dom.Paper.add(elYaxis);
                if (_this.w.config.grid.position === 'back') {
                  var inner = gl.dom.Paper.children()[1];
                  inner.remove();
                  gl.dom.Paper.add(inner);
                }
              }
            });
          }
        }
      }
    }]);
    return Axes;
  }();

  var Crosshairs = /*#__PURE__*/function () {
    function Crosshairs(ctx) {
      _classCallCheck(this, Crosshairs);
      this.ctx = ctx;
      this.w = ctx.w;
    }
    _createClass(Crosshairs, [{
      key: "drawXCrosshairs",
      value: function drawXCrosshairs() {
        var w = this.w;
        var graphics = new Graphics(this.ctx);
        var filters = new Filters(this.ctx);
        var crosshairGradient = w.config.xaxis.crosshairs.fill.gradient;
        var crosshairShadow = w.config.xaxis.crosshairs.dropShadow;
        var fillType = w.config.xaxis.crosshairs.fill.type;
        var gradientFrom = crosshairGradient.colorFrom;
        var gradientTo = crosshairGradient.colorTo;
        var opacityFrom = crosshairGradient.opacityFrom;
        var opacityTo = crosshairGradient.opacityTo;
        var stops = crosshairGradient.stops;
        var shadow = 'none';
        var dropShadow = crosshairShadow.enabled;
        var shadowLeft = crosshairShadow.left;
        var shadowTop = crosshairShadow.top;
        var shadowBlur = crosshairShadow.blur;
        var shadowColor = crosshairShadow.color;
        var shadowOpacity = crosshairShadow.opacity;
        var xcrosshairsFill = w.config.xaxis.crosshairs.fill.color;
        if (w.config.xaxis.crosshairs.show) {
          if (fillType === 'gradient') {
            xcrosshairsFill = graphics.drawGradient('vertical', gradientFrom, gradientTo, opacityFrom, opacityTo, null, stops, null);
          }
          var xcrosshairs = graphics.drawRect();
          if (w.config.xaxis.crosshairs.width === 1) {
            // to prevent drawing 2 lines, convert rect to line
            xcrosshairs = graphics.drawLine();
          }
          var gridHeight = w.globals.gridHeight;
          if (!Utils$1.isNumber(gridHeight) || gridHeight < 0) {
            gridHeight = 0;
          }
          var crosshairsWidth = w.config.xaxis.crosshairs.width;
          if (!Utils$1.isNumber(crosshairsWidth) || crosshairsWidth < 0) {
            crosshairsWidth = 0;
          }
          xcrosshairs.attr({
            class: 'apexcharts-xcrosshairs',
            x: 0,
            y: 0,
            y2: gridHeight,
            width: crosshairsWidth,
            height: gridHeight,
            fill: xcrosshairsFill,
            filter: shadow,
            'fill-opacity': w.config.xaxis.crosshairs.opacity,
            stroke: w.config.xaxis.crosshairs.stroke.color,
            'stroke-width': w.config.xaxis.crosshairs.stroke.width,
            'stroke-dasharray': w.config.xaxis.crosshairs.stroke.dashArray
          });
          if (dropShadow) {
            xcrosshairs = filters.dropShadow(xcrosshairs, {
              left: shadowLeft,
              top: shadowTop,
              blur: shadowBlur,
              color: shadowColor,
              opacity: shadowOpacity
            });
          }
          w.globals.dom.elGraphical.add(xcrosshairs);
        }
      }
    }, {
      key: "drawYCrosshairs",
      value: function drawYCrosshairs() {
        var w = this.w;
        var graphics = new Graphics(this.ctx);
        var crosshair = w.config.yaxis[0].crosshairs;
        var offX = w.globals.barPadForNumericAxis;
        if (w.config.yaxis[0].crosshairs.show) {
          var ycrosshairs = graphics.drawLine(-offX, 0, w.globals.gridWidth + offX, 0, crosshair.stroke.color, crosshair.stroke.dashArray, crosshair.stroke.width);
          ycrosshairs.attr({
            class: 'apexcharts-ycrosshairs'
          });
          w.globals.dom.elGraphical.add(ycrosshairs);
        }

        // draw an invisible crosshair to help in positioning the yaxis tooltip
        var ycrosshairsHidden = graphics.drawLine(-offX, 0, w.globals.gridWidth + offX, 0, crosshair.stroke.color, 0, 0);
        ycrosshairsHidden.attr({
          class: 'apexcharts-ycrosshairs-hidden'
        });
        w.globals.dom.elGraphical.add(ycrosshairsHidden);
      }
    }]);
    return Crosshairs;
  }();

  /**
   * ApexCharts Responsive Class to override options for different screen sizes.
   *
   * @module Responsive
   **/
  var Responsive = /*#__PURE__*/function () {
    function Responsive(ctx) {
      _classCallCheck(this, Responsive);
      this.ctx = ctx;
      this.w = ctx.w;
    }

    // the opts parameter if not null has to be set overriding everything
    // as the opts is set by user externally
    _createClass(Responsive, [{
      key: "checkResponsiveConfig",
      value: function checkResponsiveConfig(opts) {
        var _this = this;
        var w = this.w;
        var cnf = w.config;

        // check if responsive config exists
        if (cnf.responsive.length === 0) return;
        var res = cnf.responsive.slice();
        res.sort(function (a, b) {
          return a.breakpoint > b.breakpoint ? 1 : b.breakpoint > a.breakpoint ? -1 : 0;
        }).reverse();
        var config = new Config({});
        var iterateResponsiveOptions = function iterateResponsiveOptions() {
          var newOptions = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
          var largestBreakpoint = res[0].breakpoint;
          var width = window.innerWidth > 0 ? window.innerWidth : screen.width;
          if (width > largestBreakpoint) {
            var initialConfig = Utils$1.clone(w.globals.initialConfig);
            // Retain state of series in case any have been collapsed
            // (indicated by series.data === [], these series' will be zeroed later
            // enabling stacking to work correctly)
            initialConfig.series = Utils$1.clone(w.config.series);
            var options = CoreUtils.extendArrayProps(config, initialConfig, w);
            newOptions = Utils$1.extend(options, newOptions);
            newOptions = Utils$1.extend(w.config, newOptions);
            _this.overrideResponsiveOptions(newOptions);
          } else {
            for (var i = 0; i < res.length; i++) {
              if (width < res[i].breakpoint) {
                newOptions = CoreUtils.extendArrayProps(config, res[i].options, w);
                newOptions = Utils$1.extend(w.config, newOptions);
                _this.overrideResponsiveOptions(newOptions);
              }
            }
          }
        };
        if (opts) {
          var options = CoreUtils.extendArrayProps(config, opts, w);
          options = Utils$1.extend(w.config, options);
          options = Utils$1.extend(options, opts);
          iterateResponsiveOptions(options);
        } else {
          iterateResponsiveOptions({});
        }
      }
    }, {
      key: "overrideResponsiveOptions",
      value: function overrideResponsiveOptions(newOptions) {
        var newConfig = new Config(newOptions).init({
          responsiveOverride: true
        });
        this.w.config = newConfig;
      }
    }]);
    return Responsive;
  }();

  /**
   * ApexCharts Theme Class for setting the colors and palettes.
   *
   * @module Theme
   **/
  var Theme = /*#__PURE__*/function () {
    function Theme(ctx) {
      _classCallCheck(this, Theme);
      this.ctx = ctx;
      this.w = ctx.w;
      this.colors = [];
      this.isColorFn = false;
      this.isHeatmapDistributed = this.checkHeatmapDistributed();
      this.isBarDistributed = this.checkBarDistributed();
    }
    _createClass(Theme, [{
      key: "checkHeatmapDistributed",
      value: function checkHeatmapDistributed() {
        var _this$w$config = this.w.config,
          chart = _this$w$config.chart,
          plotOptions = _this$w$config.plotOptions;
        return chart.type === 'treemap' && plotOptions.treemap && plotOptions.treemap.distributed || chart.type === 'heatmap' && plotOptions.heatmap && plotOptions.heatmap.distributed;
      }
    }, {
      key: "checkBarDistributed",
      value: function checkBarDistributed() {
        var _this$w$config2 = this.w.config,
          chart = _this$w$config2.chart,
          plotOptions = _this$w$config2.plotOptions;
        return plotOptions.bar && plotOptions.bar.distributed && (chart.type === 'bar' || chart.type === 'rangeBar');
      }
    }, {
      key: "init",
      value: function init() {
        this.setDefaultColors();
      }
    }, {
      key: "setDefaultColors",
      value: function setDefaultColors() {
        var w = this.w;
        var utils = new Utils$1();
        w.globals.dom.elWrap.classList.add("apexcharts-theme-".concat(w.config.theme.mode || 'light'));

        // Create a copy of config.colors array to avoid mutating the original config.colors
        var configColors = _toConsumableArray(w.config.colors || w.config.fill.colors || []);
        w.globals.colors = this.getColors(configColors);
        this.applySeriesColors(w.globals.seriesColors, w.globals.colors);
        if (w.config.theme.monochrome.enabled) {
          w.globals.colors = this.getMonochromeColors(w.config.theme.monochrome, w.globals.series, utils);
        }
        var defaultColors = w.globals.colors.slice();
        this.pushExtraColors(w.globals.colors);
        this.applyColorTypes(['fill', 'stroke'], defaultColors);
        this.applyDataLabelsColors(defaultColors);
        this.applyRadarPolygonsColors();
        this.applyMarkersColors(defaultColors);
      }
    }, {
      key: "getColors",
      value: function getColors(configColors) {
        var _this = this;
        var w = this.w;
        if (!configColors || configColors.length === 0) {
          return this.predefined();
        }
        if (Array.isArray(configColors) && configColors.length > 0 && typeof configColors[0] === 'function') {
          this.isColorFn = true;
          return w.config.series.map(function (s, i) {
            var c = configColors[i] || configColors[0];
            return typeof c === 'function' ? c({
              value: w.globals.axisCharts ? w.globals.series[i][0] || 0 : w.globals.series[i],
              seriesIndex: i,
              dataPointIndex: i,
              w: _this.w
            }) : c;
          });
        }
        return configColors;
      }
    }, {
      key: "applySeriesColors",
      value: function applySeriesColors(seriesColors, globalsColors) {
        seriesColors.forEach(function (c, i) {
          if (c) {
            globalsColors[i] = c;
          }
        });
      }
    }, {
      key: "getMonochromeColors",
      value: function getMonochromeColors(monochrome, series, utils) {
        var color = monochrome.color,
          shadeIntensity = monochrome.shadeIntensity,
          shadeTo = monochrome.shadeTo;
        var glsCnt = this.isBarDistributed || this.isHeatmapDistributed ? series[0].length * series.length : series.length;
        var part = 1 / (glsCnt / shadeIntensity);
        var percent = 0;
        return Array.from({
          length: glsCnt
        }, function () {
          var newColor = shadeTo === 'dark' ? utils.shadeColor(percent * -1, color) : utils.shadeColor(percent, color);
          percent += part;
          return newColor;
        });
      }
    }, {
      key: "applyColorTypes",
      value: function applyColorTypes(colorTypes, defaultColors) {
        var _this2 = this;
        var w = this.w;
        colorTypes.forEach(function (c) {
          w.globals[c].colors = w.config[c].colors === undefined ? _this2.isColorFn ? w.config.colors : defaultColors : w.config[c].colors.slice();
          _this2.pushExtraColors(w.globals[c].colors);
        });
      }
    }, {
      key: "applyDataLabelsColors",
      value: function applyDataLabelsColors(defaultColors) {
        var w = this.w;
        w.globals.dataLabels.style.colors = w.config.dataLabels.style.colors === undefined ? defaultColors : w.config.dataLabels.style.colors.slice();
        this.pushExtraColors(w.globals.dataLabels.style.colors, 50);
      }
    }, {
      key: "applyRadarPolygonsColors",
      value: function applyRadarPolygonsColors() {
        var w = this.w;
        w.globals.radarPolygons.fill.colors = w.config.plotOptions.radar.polygons.fill.colors === undefined ? [w.config.theme.mode === 'dark' ? '#343A3F' : 'none'] : w.config.plotOptions.radar.polygons.fill.colors.slice();
        this.pushExtraColors(w.globals.radarPolygons.fill.colors, 20);
      }
    }, {
      key: "applyMarkersColors",
      value: function applyMarkersColors(defaultColors) {
        var w = this.w;
        w.globals.markers.colors = w.config.markers.colors === undefined ? defaultColors : w.config.markers.colors.slice();
        this.pushExtraColors(w.globals.markers.colors);
      }
    }, {
      key: "pushExtraColors",
      value: function pushExtraColors(colorSeries, length) {
        var distributed = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
        var w = this.w;
        var len = length || w.globals.series.length;
        if (distributed === null) {
          distributed = this.isBarDistributed || this.isHeatmapDistributed || w.config.chart.type === 'heatmap' && w.config.plotOptions.heatmap && w.config.plotOptions.heatmap.colorScale.inverse;
        }
        if (distributed && w.globals.series.length) {
          len = w.globals.series[w.globals.maxValsInArrayIndex].length * w.globals.series.length;
        }
        if (colorSeries.length < len) {
          var diff = len - colorSeries.length;
          for (var i = 0; i < diff; i++) {
            colorSeries.push(colorSeries[i]);
          }
        }
      }
    }, {
      key: "updateThemeOptions",
      value: function updateThemeOptions(options) {
        options.chart = options.chart || {};
        options.tooltip = options.tooltip || {};
        var mode = options.theme.mode;
        var palette = mode === 'dark' ? 'palette4' : mode === 'light' ? 'palette1' : options.theme.palette || 'palette1';
        var foreColor = mode === 'dark' ? '#f6f7f8' : mode === 'light' ? '#373d3f' : options.chart.foreColor || '#373d3f';
        options.tooltip.theme = mode || 'light';
        options.chart.foreColor = foreColor;
        options.theme.palette = palette;
        return options;
      }
    }, {
      key: "predefined",
      value: function predefined() {
        var palette = this.w.config.theme.palette;
        var palettes = this.ctx.constructor.getThemePalettes();
        return palettes[palette] || palettes.palette1;
      }
    }]);
    return Theme;
  }();

  var TitleSubtitle = /*#__PURE__*/function () {
    function TitleSubtitle(ctx) {
      _classCallCheck(this, TitleSubtitle);
      this.ctx = ctx;
      this.w = ctx.w;
    }
    _createClass(TitleSubtitle, [{
      key: "draw",
      value: function draw() {
        this.drawTitleSubtitle('title');
        this.drawTitleSubtitle('subtitle');
      }
    }, {
      key: "drawTitleSubtitle",
      value: function drawTitleSubtitle(type) {
        var w = this.w;
        var tsConfig = type === 'title' ? w.config.title : w.config.subtitle;
        var x = w.globals.svgWidth / 2;
        var y = tsConfig.offsetY;
        var textAnchor = 'middle';
        if (tsConfig.align === 'left') {
          x = 10;
          textAnchor = 'start';
        } else if (tsConfig.align === 'right') {
          x = w.globals.svgWidth - 10;
          textAnchor = 'end';
        }
        x = x + tsConfig.offsetX;
        y = y + parseInt(tsConfig.style.fontSize, 10) + tsConfig.margin / 2;
        if (tsConfig.text !== undefined) {
          var graphics = new Graphics(this.ctx);
          var titleText = graphics.drawText({
            x: x,
            y: y,
            text: tsConfig.text,
            textAnchor: textAnchor,
            fontSize: tsConfig.style.fontSize,
            fontFamily: tsConfig.style.fontFamily,
            fontWeight: tsConfig.style.fontWeight,
            foreColor: tsConfig.style.color,
            opacity: 1
          });
          titleText.node.setAttribute('class', "apexcharts-".concat(type, "-text"));
          w.globals.dom.Paper.add(titleText);
        }
      }
    }]);
    return TitleSubtitle;
  }();

  var Helpers$3 = /*#__PURE__*/function () {
    function Helpers(dCtx) {
      _classCallCheck(this, Helpers);
      this.w = dCtx.w;
      this.dCtx = dCtx;
    }

    /**
     * Get Chart Title/Subtitle Dimensions
     * @memberof Dimensions
     * @return {{width, height}}
     **/
    _createClass(Helpers, [{
      key: "getTitleSubtitleCoords",
      value: function getTitleSubtitleCoords(type) {
        var w = this.w;
        var width = 0;
        var height = 0;
        var floating = type === 'title' ? w.config.title.floating : w.config.subtitle.floating;
        var el = w.globals.dom.baseEl.querySelector(".apexcharts-".concat(type, "-text"));
        if (el !== null && !floating) {
          var coord = el.getBoundingClientRect();
          width = coord.width;
          height = w.globals.axisCharts ? coord.height + 5 : coord.height;
        }
        return {
          width: width,
          height: height
        };
      }
    }, {
      key: "getLegendsRect",
      value: function getLegendsRect() {
        var w = this.w;
        var elLegendWrap = w.globals.dom.elLegendWrap;
        if (!w.config.legend.height && (w.config.legend.position === 'top' || w.config.legend.position === 'bottom')) {
          // avoid legend to take up all the space
          elLegendWrap.style.maxHeight = w.globals.svgHeight / 2 + 'px';
        }
        var lgRect = Object.assign({}, Utils$1.getBoundingClientRect(elLegendWrap));
        if (elLegendWrap !== null && !w.config.legend.floating && w.config.legend.show) {
          this.dCtx.lgRect = {
            x: lgRect.x,
            y: lgRect.y,
            height: lgRect.height,
            width: lgRect.height === 0 ? 0 : lgRect.width
          };
        } else {
          this.dCtx.lgRect = {
            x: 0,
            y: 0,
            height: 0,
            width: 0
          };
        }

        // if legend takes up all of the chart space, we need to restrict it.
        if (w.config.legend.position === 'left' || w.config.legend.position === 'right') {
          if (this.dCtx.lgRect.width * 1.5 > w.globals.svgWidth) {
            this.dCtx.lgRect.width = w.globals.svgWidth / 1.5;
          }
        }
        return this.dCtx.lgRect;
      }

      /**
       * Get Y Axis Dimensions
       * @memberof Dimensions
       * @return {{width, height}}
       **/
    }, {
      key: "getDatalabelsRect",
      value: function getDatalabelsRect() {
        var _this = this;
        var w = this.w;
        var allLabels = [];
        w.config.series.forEach(function (serie, seriesIndex) {
          serie.data.forEach(function (datum, dataPointIndex) {
            var getText = function getText(v) {
              return w.config.dataLabels.formatter(v, {
                ctx: _this.dCtx.ctx,
                seriesIndex: seriesIndex,
                dataPointIndex: dataPointIndex,
                w: w
              });
            };
            val = getText(w.globals.series[seriesIndex][dataPointIndex]);
            allLabels.push(val);
          });
        });
        var val = Utils$1.getLargestStringFromArr(allLabels);
        var graphics = new Graphics(this.dCtx.ctx);
        var dataLabelsStyle = w.config.dataLabels.style;
        var labelrect = graphics.getTextRects(val, parseInt(dataLabelsStyle.fontSize), dataLabelsStyle.fontFamily);
        return {
          width: labelrect.width * 1.05,
          height: labelrect.height
        };
      }
    }, {
      key: "getLargestStringFromMultiArr",
      value: function getLargestStringFromMultiArr(val, arr) {
        var w = this.w;
        var valArr = val;
        if (w.globals.isMultiLineX) {
          // if the xaxis labels has multiline texts (array)
          var maxArrs = arr.map(function (xl, idx) {
            return Array.isArray(xl) ? xl.length : 1;
          });
          var maxArrLen = Math.max.apply(Math, _toConsumableArray(maxArrs));
          var maxArrIndex = maxArrs.indexOf(maxArrLen);
          valArr = arr[maxArrIndex];
        }
        return valArr;
      }
    }]);
    return Helpers;
  }();

  var DimXAxis = /*#__PURE__*/function () {
    function DimXAxis(dCtx) {
      _classCallCheck(this, DimXAxis);
      this.w = dCtx.w;
      this.dCtx = dCtx;
    }

    /**
     * Get X Axis Dimensions
     * @memberof Dimensions
     * @return {{width, height}}
     **/
    _createClass(DimXAxis, [{
      key: "getxAxisLabelsCoords",
      value: function getxAxisLabelsCoords() {
        var w = this.w;
        var xaxisLabels = w.globals.labels.slice();
        if (w.config.xaxis.convertedCatToNumeric && xaxisLabels.length === 0) {
          xaxisLabels = w.globals.categoryLabels;
        }
        var rect;
        if (w.globals.timescaleLabels.length > 0) {
          var coords = this.getxAxisTimeScaleLabelsCoords();
          rect = {
            width: coords.width,
            height: coords.height
          };
          w.globals.rotateXLabels = false;
        } else {
          this.dCtx.lgWidthForSideLegends = (w.config.legend.position === 'left' || w.config.legend.position === 'right') && !w.config.legend.floating ? this.dCtx.lgRect.width : 0;

          // get the longest string from the labels array and also apply label formatter
          var xlbFormatter = w.globals.xLabelFormatter;
          // prevent changing xaxisLabels to avoid issues in multi-yaxes - fix #522
          var val = Utils$1.getLargestStringFromArr(xaxisLabels);
          var valArr = this.dCtx.dimHelpers.getLargestStringFromMultiArr(val, xaxisLabels);

          // the labels gets changed for bar charts
          if (w.globals.isBarHorizontal) {
            val = w.globals.yAxisScale[0].result.reduce(function (a, b) {
              return a.length > b.length ? a : b;
            }, 0);
            valArr = val;
          }
          var xFormat = new Formatters(this.dCtx.ctx);
          var timestamp = val;
          val = xFormat.xLabelFormat(xlbFormatter, val, timestamp, {
            i: undefined,
            dateFormatter: new DateTime(this.dCtx.ctx).formatDate,
            w: w
          });
          valArr = xFormat.xLabelFormat(xlbFormatter, valArr, timestamp, {
            i: undefined,
            dateFormatter: new DateTime(this.dCtx.ctx).formatDate,
            w: w
          });
          if (w.config.xaxis.convertedCatToNumeric && typeof val === 'undefined' || String(val).trim() === '') {
            val = '1';
            valArr = val;
          }
          var graphics = new Graphics(this.dCtx.ctx);
          var xLabelrect = graphics.getTextRects(val, w.config.xaxis.labels.style.fontSize);
          var xArrLabelrect = xLabelrect;
          if (val !== valArr) {
            xArrLabelrect = graphics.getTextRects(valArr, w.config.xaxis.labels.style.fontSize);
          }
          rect = {
            width: xLabelrect.width >= xArrLabelrect.width ? xLabelrect.width : xArrLabelrect.width,
            height: xLabelrect.height >= xArrLabelrect.height ? xLabelrect.height : xArrLabelrect.height
          };
          if (rect.width * xaxisLabels.length > w.globals.svgWidth - this.dCtx.lgWidthForSideLegends - this.dCtx.yAxisWidth - this.dCtx.gridPad.left - this.dCtx.gridPad.right && w.config.xaxis.labels.rotate !== 0 || w.config.xaxis.labels.rotateAlways) {
            if (!w.globals.isBarHorizontal) {
              w.globals.rotateXLabels = true;
              var getRotatedTextRects = function getRotatedTextRects(text) {
                return graphics.getTextRects(text, w.config.xaxis.labels.style.fontSize, w.config.xaxis.labels.style.fontFamily, "rotate(".concat(w.config.xaxis.labels.rotate, " 0 0)"), false);
              };
              xLabelrect = getRotatedTextRects(val);
              if (val !== valArr) {
                xArrLabelrect = getRotatedTextRects(valArr);
              }
              rect.height = (xLabelrect.height > xArrLabelrect.height ? xLabelrect.height : xArrLabelrect.height) / 1.5;
              rect.width = xLabelrect.width > xArrLabelrect.width ? xLabelrect.width : xArrLabelrect.width;
            }
          } else {
            w.globals.rotateXLabels = false;
          }
        }
        if (!w.config.xaxis.labels.show) {
          rect = {
            width: 0,
            height: 0
          };
        }
        return {
          width: rect.width,
          height: rect.height
        };
      }

      /**
       * Get X Axis Label Group height
       * @memberof Dimensions
       * @return {{width, height}}
       */
    }, {
      key: "getxAxisGroupLabelsCoords",
      value: function getxAxisGroupLabelsCoords() {
        var _w$config$xaxis$group;
        var w = this.w;
        if (!w.globals.hasXaxisGroups) {
          return {
            width: 0,
            height: 0
          };
        }
        var fontSize = ((_w$config$xaxis$group = w.config.xaxis.group.style) === null || _w$config$xaxis$group === void 0 ? void 0 : _w$config$xaxis$group.fontSize) || w.config.xaxis.labels.style.fontSize;
        var xaxisLabels = w.globals.groups.map(function (g) {
          return g.title;
        });
        var rect;

        // prevent changing xaxisLabels to avoid issues in multi-yaxes - fix #522
        var val = Utils$1.getLargestStringFromArr(xaxisLabels);
        var valArr = this.dCtx.dimHelpers.getLargestStringFromMultiArr(val, xaxisLabels);
        var graphics = new Graphics(this.dCtx.ctx);
        var xLabelrect = graphics.getTextRects(val, fontSize);
        var xArrLabelrect = xLabelrect;
        if (val !== valArr) {
          xArrLabelrect = graphics.getTextRects(valArr, fontSize);
        }
        rect = {
          width: xLabelrect.width >= xArrLabelrect.width ? xLabelrect.width : xArrLabelrect.width,
          height: xLabelrect.height >= xArrLabelrect.height ? xLabelrect.height : xArrLabelrect.height
        };
        if (!w.config.xaxis.labels.show) {
          rect = {
            width: 0,
            height: 0
          };
        }
        return {
          width: rect.width,
          height: rect.height
        };
      }

      /**
       * Get X Axis Title Dimensions
       * @memberof Dimensions
       * @return {{width, height}}
       **/
    }, {
      key: "getxAxisTitleCoords",
      value: function getxAxisTitleCoords() {
        var w = this.w;
        var width = 0;
        var height = 0;
        if (w.config.xaxis.title.text !== undefined) {
          var graphics = new Graphics(this.dCtx.ctx);
          var rect = graphics.getTextRects(w.config.xaxis.title.text, w.config.xaxis.title.style.fontSize);
          width = rect.width;
          height = rect.height;
        }
        return {
          width: width,
          height: height
        };
      }
    }, {
      key: "getxAxisTimeScaleLabelsCoords",
      value: function getxAxisTimeScaleLabelsCoords() {
        var w = this.w;
        var rect;
        this.dCtx.timescaleLabels = w.globals.timescaleLabels.slice();
        var labels = this.dCtx.timescaleLabels.map(function (label) {
          return label.value;
        });

        //  get the longest string from the labels array and also apply label formatter to it
        var val = labels.reduce(function (a, b) {
          // if undefined, maybe user didn't pass the datetime(x) values
          if (typeof a === 'undefined') {
            console.error('You have possibly supplied invalid Date format. Please supply a valid JavaScript Date');
            return 0;
          } else {
            return a.length > b.length ? a : b;
          }
        }, 0);
        var graphics = new Graphics(this.dCtx.ctx);
        rect = graphics.getTextRects(val, w.config.xaxis.labels.style.fontSize);
        var totalWidthRotated = rect.width * 1.05 * labels.length;
        if (totalWidthRotated > w.globals.gridWidth && w.config.xaxis.labels.rotate !== 0) {
          w.globals.overlappingXLabels = true;
        }
        return rect;
      }

      // In certain cases, the last labels gets cropped in xaxis.
      // Hence, we add some additional padding based on the label length to avoid the last label being cropped or we don't draw it at all
    }, {
      key: "additionalPaddingXLabels",
      value: function additionalPaddingXLabels(xaxisLabelCoords) {
        var _this = this;
        var w = this.w;
        var gl = w.globals;
        var cnf = w.config;
        var xtype = cnf.xaxis.type;
        var lbWidth = xaxisLabelCoords.width;
        gl.skipLastTimelinelabel = false;
        gl.skipFirstTimelinelabel = false;
        var isBarOpposite = w.config.yaxis[0].opposite && w.globals.isBarHorizontal;
        var isCollapsed = function isCollapsed(i) {
          return gl.collapsedSeriesIndices.indexOf(i) !== -1;
        };
        var rightPad = function rightPad(yaxe) {
          if (_this.dCtx.timescaleLabels && _this.dCtx.timescaleLabels.length) {
            // for timeline labels, we take the last label and check if it exceeds gridWidth
            var firstimescaleLabel = _this.dCtx.timescaleLabels[0];
            var lastTimescaleLabel = _this.dCtx.timescaleLabels[_this.dCtx.timescaleLabels.length - 1];
            var lastLabelPosition = lastTimescaleLabel.position + lbWidth / 1.75 - _this.dCtx.yAxisWidthRight;
            var firstLabelPosition = firstimescaleLabel.position - lbWidth / 1.75 + _this.dCtx.yAxisWidthLeft;
            var lgRightRectWidth = w.config.legend.position === 'right' && _this.dCtx.lgRect.width > 0 ? _this.dCtx.lgRect.width : 0;
            if (lastLabelPosition > gl.svgWidth - gl.translateX - lgRightRectWidth) {
              gl.skipLastTimelinelabel = true;
            }
            if (firstLabelPosition < -((!yaxe.show || yaxe.floating) && (cnf.chart.type === 'bar' || cnf.chart.type === 'candlestick' || cnf.chart.type === 'rangeBar' || cnf.chart.type === 'boxPlot') ? lbWidth / 1.75 : 10)) {
              gl.skipFirstTimelinelabel = true;
            }
          } else if (xtype === 'datetime') {
            // If user has enabled DateTime, but uses own's formatter
            if (_this.dCtx.gridPad.right < lbWidth && !gl.rotateXLabels) {
              gl.skipLastTimelinelabel = true;
            }
          } else if (xtype !== 'datetime') {
            if (_this.dCtx.gridPad.right < lbWidth / 2 - _this.dCtx.yAxisWidthRight && !gl.rotateXLabels && !w.config.xaxis.labels.trim) {
              _this.dCtx.xPadRight = lbWidth / 2 + 1;
            }
          }
        };
        var padYAxe = function padYAxe(yaxe, i) {
          if (cnf.yaxis.length > 1 && isCollapsed(i)) return;
          rightPad(yaxe);
        };
        cnf.yaxis.forEach(function (yaxe, i) {
          if (isBarOpposite) {
            if (_this.dCtx.gridPad.left < lbWidth) {
              _this.dCtx.xPadLeft = lbWidth / 2 + 1;
            }
            _this.dCtx.xPadRight = lbWidth / 2 + 1;
          } else {
            padYAxe(yaxe, i);
          }
        });
      }
    }]);
    return DimXAxis;
  }();

  var DimYAxis = /*#__PURE__*/function () {
    function DimYAxis(dCtx) {
      _classCallCheck(this, DimYAxis);
      this.w = dCtx.w;
      this.dCtx = dCtx;
    }

    /**
     * Get Y Axis Dimensions
     * @memberof Dimensions
     * @return {{width, height}}
     **/
    _createClass(DimYAxis, [{
      key: "getyAxisLabelsCoords",
      value: function getyAxisLabelsCoords() {
        var _this = this;
        var w = this.w;
        var width = 0;
        var height = 0;
        var ret = [];
        var labelPad = 10;
        var axesUtils = new AxesUtils(this.dCtx.ctx);
        w.config.yaxis.map(function (yaxe, index) {
          var formatterArgs = {
            seriesIndex: index,
            dataPointIndex: -1,
            w: w
          };
          var yS = w.globals.yAxisScale[index];
          var yAxisMinWidth = 0;
          if (!axesUtils.isYAxisHidden(index) && yaxe.labels.show && yaxe.labels.minWidth !== undefined) yAxisMinWidth = yaxe.labels.minWidth;
          if (!axesUtils.isYAxisHidden(index) && yaxe.labels.show && yS.result.length) {
            var lbFormatter = w.globals.yLabelFormatters[index];
            var minV = yS.niceMin === Number.MIN_VALUE ? 0 : yS.niceMin;
            var val = yS.result.reduce(function (acc, curr) {
              var _String, _String2;
              return ((_String = String(lbFormatter(acc, formatterArgs))) === null || _String === void 0 ? void 0 : _String.length) > ((_String2 = String(lbFormatter(curr, formatterArgs))) === null || _String2 === void 0 ? void 0 : _String2.length) ? acc : curr;
            }, minV);
            val = lbFormatter(val, formatterArgs);

            // the second parameter -1 is the index of tick which user can use in the formatter
            var valArr = val;

            // if user has specified a custom formatter, and the result is null or empty, we need to discard the formatter and take the value as it is.
            if (typeof val === 'undefined' || val.length === 0) {
              val = yS.niceMax;
            }
            if (w.globals.isBarHorizontal) {
              labelPad = 0;
              var barYaxisLabels = w.globals.labels.slice();

              //  get the longest string from the labels array and also apply label formatter to it
              val = Utils$1.getLargestStringFromArr(barYaxisLabels);
              val = lbFormatter(val, {
                seriesIndex: index,
                dataPointIndex: -1,
                w: w
              });
              valArr = _this.dCtx.dimHelpers.getLargestStringFromMultiArr(val, barYaxisLabels);
            }
            var graphics = new Graphics(_this.dCtx.ctx);
            var rotateStr = 'rotate('.concat(yaxe.labels.rotate, ' 0 0)');
            var rect = graphics.getTextRects(val, yaxe.labels.style.fontSize, yaxe.labels.style.fontFamily, rotateStr, false);
            var arrLabelrect = rect;
            if (val !== valArr) {
              arrLabelrect = graphics.getTextRects(valArr, yaxe.labels.style.fontSize, yaxe.labels.style.fontFamily, rotateStr, false);
            }
            ret.push({
              width: (yAxisMinWidth > arrLabelrect.width || yAxisMinWidth > rect.width ? yAxisMinWidth : arrLabelrect.width > rect.width ? arrLabelrect.width : rect.width) + labelPad,
              height: arrLabelrect.height > rect.height ? arrLabelrect.height : rect.height
            });
          } else {
            ret.push({
              width: width,
              height: height
            });
          }
        });
        return ret;
      }

      /**
       * Get Y Axis Dimensions
       * @memberof Dimensions
       * @return {{width, height}}
       **/
    }, {
      key: "getyAxisTitleCoords",
      value: function getyAxisTitleCoords() {
        var _this2 = this;
        var w = this.w;
        var ret = [];
        w.config.yaxis.map(function (yaxe, index) {
          if (yaxe.show && yaxe.title.text !== undefined) {
            var graphics = new Graphics(_this2.dCtx.ctx);
            var rotateStr = 'rotate('.concat(yaxe.title.rotate, ' 0 0)');
            var rect = graphics.getTextRects(yaxe.title.text, yaxe.title.style.fontSize, yaxe.title.style.fontFamily, rotateStr, false);
            ret.push({
              width: rect.width,
              height: rect.height
            });
          } else {
            ret.push({
              width: 0,
              height: 0
            });
          }
        });
        return ret;
      }
    }, {
      key: "getTotalYAxisWidth",
      value: function getTotalYAxisWidth() {
        var w = this.w;
        var yAxisWidth = 0;
        var yAxisWidthLeft = 0;
        var yAxisWidthRight = 0;
        var padding = w.globals.yAxisScale.length > 1 ? 10 : 0;
        var axesUtils = new AxesUtils(this.dCtx.ctx);
        var isHiddenYAxis = function isHiddenYAxis(index) {
          return w.globals.ignoreYAxisIndexes.indexOf(index) > -1;
        };
        var padForLabelTitle = function padForLabelTitle(coord, index) {
          var floating = w.config.yaxis[index].floating;
          var width = 0;
          if (coord.width > 0 && !floating) {
            width = coord.width + padding;
            if (isHiddenYAxis(index)) {
              width = width - coord.width - padding;
            }
          } else {
            width = floating || axesUtils.isYAxisHidden(index) ? 0 : 5;
          }
          w.config.yaxis[index].opposite ? yAxisWidthRight = yAxisWidthRight + width : yAxisWidthLeft = yAxisWidthLeft + width;
          yAxisWidth = yAxisWidth + width;
        };
        w.globals.yLabelsCoords.map(function (yLabelCoord, index) {
          padForLabelTitle(yLabelCoord, index);
        });
        w.globals.yTitleCoords.map(function (yTitleCoord, index) {
          padForLabelTitle(yTitleCoord, index);
        });
        if (w.globals.isBarHorizontal && !w.config.yaxis[0].floating) {
          yAxisWidth = w.globals.yLabelsCoords[0].width + w.globals.yTitleCoords[0].width + 15;
        }
        this.dCtx.yAxisWidthLeft = yAxisWidthLeft;
        this.dCtx.yAxisWidthRight = yAxisWidthRight;
        return yAxisWidth;
      }
    }]);
    return DimYAxis;
  }();

  var DimGrid = /*#__PURE__*/function () {
    function DimGrid(dCtx) {
      _classCallCheck(this, DimGrid);
      this.w = dCtx.w;
      this.dCtx = dCtx;
    }
    _createClass(DimGrid, [{
      key: "gridPadForColumnsInNumericAxis",
      value: function gridPadForColumnsInNumericAxis(gridWidth) {
        var w = this.w;
        var cnf = w.config,
          gl = w.globals;
        if (gl.noData || gl.collapsedSeries.length + gl.ancillaryCollapsedSeries.length === cnf.series.length) {
          return 0;
        }
        var hasBar = function hasBar(type) {
          return ['bar', 'rangeBar', 'candlestick', 'boxPlot'].includes(type);
        };
        var type = cnf.chart.type;
        var barWidth = 0;
        var seriesLen = hasBar(type) ? cnf.series.length : 1;
        if (gl.comboBarCount > 0) {
          seriesLen = gl.comboBarCount;
        }
        gl.collapsedSeries.forEach(function (c) {
          if (hasBar(c.type)) {
            seriesLen -= 1;
          }
        });
        if (cnf.chart.stacked) {
          seriesLen = 1;
        }
        var barsPresent = hasBar(type) || gl.comboBarCount > 0;
        var xRange = Math.abs(gl.initialMaxX - gl.initialMinX);
        if (barsPresent && gl.isXNumeric && !gl.isBarHorizontal && seriesLen > 0 && xRange !== 0) {
          if (xRange <= 3) {
            xRange = gl.dataPoints;
          }
          var xRatio = xRange / gridWidth;
          var xDivision = gl.minXDiff && gl.minXDiff / xRatio > 0 ? gl.minXDiff / xRatio : 0;
          if (xDivision > gridWidth / 2) {
            xDivision /= 2;
          }
          // Here, barWidth is assumed to be the width occupied by a group of bars.
          // There will be one bar in the group for each series plotted.
          // Note: This version of the following math is different to that over in
          // Helpers.js. Don't assume they should be the same. Over there,
          // xDivision is computed differently and it's used on different charts.
          // They were the same, but the solution to
          // https://github.com/apexcharts/apexcharts.js/issues/4178
          // was to remove the division by seriesLen.
          barWidth = xDivision * parseInt(cnf.plotOptions.bar.columnWidth, 10) / 100;
          if (barWidth < 1) {
            barWidth = 1;
          }
          gl.barPadForNumericAxis = barWidth;
        }
        return barWidth;
      }
    }, {
      key: "gridPadFortitleSubtitle",
      value: function gridPadFortitleSubtitle() {
        var _this = this;
        var w = this.w;
        var gl = w.globals;
        var gridShrinkOffset = this.dCtx.isSparkline || !gl.axisCharts ? 0 : 10;
        var titleSubtitle = ['title', 'subtitle'];
        titleSubtitle.forEach(function (t) {
          if (w.config[t].text !== undefined) {
            gridShrinkOffset += w.config[t].margin;
          } else {
            gridShrinkOffset += _this.dCtx.isSparkline || !gl.axisCharts ? 0 : 5;
          }
        });
        if (w.config.legend.show && w.config.legend.position === 'bottom' && !w.config.legend.floating && !gl.axisCharts) {
          gridShrinkOffset += 10;
        }
        var titleCoords = this.dCtx.dimHelpers.getTitleSubtitleCoords('title');
        var subtitleCoords = this.dCtx.dimHelpers.getTitleSubtitleCoords('subtitle');
        gl.gridHeight -= titleCoords.height + subtitleCoords.height + gridShrinkOffset;
        gl.translateY += titleCoords.height + subtitleCoords.height + gridShrinkOffset;
      }
    }, {
      key: "setGridXPosForDualYAxis",
      value: function setGridXPosForDualYAxis(yTitleCoords, yaxisLabelCoords) {
        var w = this.w;
        var axesUtils = new AxesUtils(this.dCtx.ctx);
        w.config.yaxis.forEach(function (yaxe, index) {
          if (w.globals.ignoreYAxisIndexes.indexOf(index) === -1 && !yaxe.floating && !axesUtils.isYAxisHidden(index)) {
            if (yaxe.opposite) {
              w.globals.translateX -= yaxisLabelCoords[index].width + yTitleCoords[index].width + parseInt(yaxe.labels.style.fontSize, 10) / 1.2 + 12;
            }

            // fixes apexcharts.js#1599
            if (w.globals.translateX < 2) {
              w.globals.translateX = 2;
            }
          }
        });
      }
    }]);
    return DimGrid;
  }();

  /**
   * ApexCharts Dimensions Class for calculating rects of all elements that are drawn and will be drawn.
   *
   * @module Dimensions
   **/
  var Dimensions = /*#__PURE__*/function () {
    function Dimensions(ctx) {
      _classCallCheck(this, Dimensions);
      this.ctx = ctx;
      this.w = ctx.w;
      this.lgRect = {};
      this.yAxisWidth = 0;
      this.yAxisWidthLeft = 0;
      this.yAxisWidthRight = 0;
      this.xAxisHeight = 0;
      this.isSparkline = this.w.config.chart.sparkline.enabled;
      this.dimHelpers = new Helpers$3(this);
      this.dimYAxis = new DimYAxis(this);
      this.dimXAxis = new DimXAxis(this);
      this.dimGrid = new DimGrid(this);
      this.lgWidthForSideLegends = 0;
      this.gridPad = this.w.config.grid.padding;
      this.xPadRight = 0;
      this.xPadLeft = 0;
    }

    /**
     * @memberof Dimensions
     * @param {object} w - chart context
     **/
    _createClass(Dimensions, [{
      key: "plotCoords",
      value: function plotCoords() {
        var _this = this;
        var w = this.w;
        var gl = w.globals;
        this.lgRect = this.dimHelpers.getLegendsRect();
        this.datalabelsCoords = {
          width: 0,
          height: 0
        };
        var maxStrokeWidth = Array.isArray(w.config.stroke.width) ? Math.max.apply(Math, _toConsumableArray(w.config.stroke.width)) : w.config.stroke.width;
        if (this.isSparkline) {
          if (w.config.markers.discrete.length > 0 || w.config.markers.size > 0) {
            Object.entries(this.gridPad).forEach(function (_ref) {
              var _ref2 = _slicedToArray(_ref, 2),
                k = _ref2[0],
                v = _ref2[1];
              _this.gridPad[k] = Math.max(v, _this.w.globals.markers.largestSize / 1.5);
            });
          }
          this.gridPad.top = Math.max(maxStrokeWidth / 2, this.gridPad.top);
          this.gridPad.bottom = Math.max(maxStrokeWidth / 2, this.gridPad.bottom);
        }
        if (gl.axisCharts) {
          // for line / area / scatter / column
          this.setDimensionsForAxisCharts();
        } else {
          // for pie / donuts / circle
          this.setDimensionsForNonAxisCharts();
        }
        this.dimGrid.gridPadFortitleSubtitle();

        // after calculating everything, apply padding set by user
        gl.gridHeight = gl.gridHeight - this.gridPad.top - this.gridPad.bottom;
        gl.gridWidth = gl.gridWidth - this.gridPad.left - this.gridPad.right - this.xPadRight - this.xPadLeft;
        var barWidth = this.dimGrid.gridPadForColumnsInNumericAxis(gl.gridWidth);
        gl.gridWidth = gl.gridWidth - barWidth * 2;
        gl.translateX = gl.translateX + this.gridPad.left + this.xPadLeft + (barWidth > 0 ? barWidth : 0);
        gl.translateY = gl.translateY + this.gridPad.top;
      }
    }, {
      key: "setDimensionsForAxisCharts",
      value: function setDimensionsForAxisCharts() {
        var _this2 = this;
        var w = this.w;
        var gl = w.globals;
        var yaxisLabelCoords = this.dimYAxis.getyAxisLabelsCoords();
        var yTitleCoords = this.dimYAxis.getyAxisTitleCoords();
        if (gl.isSlopeChart) {
          this.datalabelsCoords = this.dimHelpers.getDatalabelsRect();
        }
        w.globals.yLabelsCoords = [];
        w.globals.yTitleCoords = [];
        w.config.yaxis.map(function (yaxe, index) {
          // store the labels and titles coords in global vars
          w.globals.yLabelsCoords.push({
            width: yaxisLabelCoords[index].width,
            index: index
          });
          w.globals.yTitleCoords.push({
            width: yTitleCoords[index].width,
            index: index
          });
        });
        this.yAxisWidth = this.dimYAxis.getTotalYAxisWidth();
        var xaxisLabelCoords = this.dimXAxis.getxAxisLabelsCoords();
        var xaxisGroupLabelCoords = this.dimXAxis.getxAxisGroupLabelsCoords();
        var xtitleCoords = this.dimXAxis.getxAxisTitleCoords();
        this.conditionalChecksForAxisCoords(xaxisLabelCoords, xtitleCoords, xaxisGroupLabelCoords);
        gl.translateXAxisY = w.globals.rotateXLabels ? this.xAxisHeight / 8 : -4;
        gl.translateXAxisX = w.globals.rotateXLabels && w.globals.isXNumeric && w.config.xaxis.labels.rotate <= -45 ? -this.xAxisWidth / 4 : 0;
        if (w.globals.isBarHorizontal) {
          gl.rotateXLabels = false;
          gl.translateXAxisY = -1 * (parseInt(w.config.xaxis.labels.style.fontSize, 10) / 1.5);
        }
        gl.translateXAxisY = gl.translateXAxisY + w.config.xaxis.labels.offsetY;
        gl.translateXAxisX = gl.translateXAxisX + w.config.xaxis.labels.offsetX;
        var yAxisWidth = this.yAxisWidth;
        var xAxisHeight = this.xAxisHeight;
        gl.xAxisLabelsHeight = this.xAxisHeight - xtitleCoords.height;
        gl.xAxisGroupLabelsHeight = gl.xAxisLabelsHeight - xaxisLabelCoords.height;
        gl.xAxisLabelsWidth = this.xAxisWidth;
        gl.xAxisHeight = this.xAxisHeight;
        var translateY = 10;
        if (w.config.chart.type === 'radar' || this.isSparkline) {
          yAxisWidth = 0;
          xAxisHeight = 0;
        }
        if (this.isSparkline) {
          this.lgRect = {
            height: 0,
            width: 0
          };
        }
        if (this.isSparkline || w.config.chart.type === 'treemap') {
          yAxisWidth = 0;
          xAxisHeight = 0;
          translateY = 0;
        }
        if (!this.isSparkline && w.config.chart.type !== 'treemap') {
          this.dimXAxis.additionalPaddingXLabels(xaxisLabelCoords);
        }
        var legendTopBottom = function legendTopBottom() {
          gl.translateX = yAxisWidth + _this2.datalabelsCoords.width;
          gl.gridHeight = gl.svgHeight - _this2.lgRect.height - xAxisHeight - (!_this2.isSparkline && w.config.chart.type !== 'treemap' ? w.globals.rotateXLabels ? 10 : 15 : 0);
          gl.gridWidth = gl.svgWidth - yAxisWidth - _this2.datalabelsCoords.width * 2;
        };
        if (w.config.xaxis.position === 'top') translateY = gl.xAxisHeight - w.config.xaxis.axisTicks.height - 5;
        switch (w.config.legend.position) {
          case 'bottom':
            gl.translateY = translateY;
            legendTopBottom();
            break;
          case 'top':
            gl.translateY = this.lgRect.height + translateY;
            legendTopBottom();
            break;
          case 'left':
            gl.translateY = translateY;
            gl.translateX = this.lgRect.width + yAxisWidth + this.datalabelsCoords.width;
            gl.gridHeight = gl.svgHeight - xAxisHeight - 12;
            gl.gridWidth = gl.svgWidth - this.lgRect.width - yAxisWidth - this.datalabelsCoords.width * 2;
            break;
          case 'right':
            gl.translateY = translateY;
            gl.translateX = yAxisWidth + this.datalabelsCoords.width;
            gl.gridHeight = gl.svgHeight - xAxisHeight - 12;
            gl.gridWidth = gl.svgWidth - this.lgRect.width - yAxisWidth - this.datalabelsCoords.width * 2 - 5;
            break;
          default:
            throw new Error('Legend position not supported');
        }
        this.dimGrid.setGridXPosForDualYAxis(yTitleCoords, yaxisLabelCoords);

        // after drawing everything, set the Y axis positions
        var objyAxis = new YAxis(this.ctx);
        objyAxis.setYAxisXPosition(yaxisLabelCoords, yTitleCoords);
      }
    }, {
      key: "setDimensionsForNonAxisCharts",
      value: function setDimensionsForNonAxisCharts() {
        var w = this.w;
        var gl = w.globals;
        var cnf = w.config;
        var xPad = 0;
        if (w.config.legend.show && !w.config.legend.floating) {
          xPad = 20;
        }
        var type = cnf.chart.type === 'pie' || cnf.chart.type === 'polarArea' || cnf.chart.type === 'donut' ? 'pie' : 'radialBar';
        var offY = cnf.plotOptions[type].offsetY;
        var offX = cnf.plotOptions[type].offsetX;
        if (!cnf.legend.show || cnf.legend.floating) {
          gl.gridHeight = gl.svgHeight;
          var maxWidth = gl.dom.elWrap.getBoundingClientRect().width;
          gl.gridWidth = Math.min(maxWidth, gl.gridHeight);
          gl.translateY = offY;
          gl.translateX = offX + (gl.svgWidth - gl.gridWidth) / 2;
          return;
        }
        switch (cnf.legend.position) {
          case 'bottom':
            gl.gridHeight = gl.svgHeight - this.lgRect.height;
            gl.gridWidth = gl.svgWidth;
            gl.translateY = offY - 10;
            gl.translateX = offX + (gl.svgWidth - gl.gridWidth) / 2;
            break;
          case 'top':
            gl.gridHeight = gl.svgHeight - this.lgRect.height;
            gl.gridWidth = gl.svgWidth;
            gl.translateY = this.lgRect.height + offY + 10;
            gl.translateX = offX + (gl.svgWidth - gl.gridWidth) / 2;
            break;
          case 'left':
            gl.gridWidth = gl.svgWidth - this.lgRect.width - xPad;
            gl.gridHeight = cnf.chart.height !== 'auto' ? gl.svgHeight : gl.gridWidth;
            gl.translateY = offY;
            gl.translateX = offX + this.lgRect.width + xPad;
            break;
          case 'right':
            gl.gridWidth = gl.svgWidth - this.lgRect.width - xPad - 5;
            gl.gridHeight = cnf.chart.height !== 'auto' ? gl.svgHeight : gl.gridWidth;
            gl.translateY = offY;
            gl.translateX = offX + 10;
            break;
          default:
            throw new Error('Legend position not supported');
        }
      }
    }, {
      key: "conditionalChecksForAxisCoords",
      value: function conditionalChecksForAxisCoords(xaxisLabelCoords, xtitleCoords, xaxisGroupLabelCoords) {
        var w = this.w;
        var xAxisNum = w.globals.hasXaxisGroups ? 2 : 1;
        var baseXAxisHeight = xaxisGroupLabelCoords.height + xaxisLabelCoords.height + xtitleCoords.height;
        var xAxisHeightMultiplicate = w.globals.isMultiLineX ? 1.2 : w.globals.LINE_HEIGHT_RATIO;
        var rotatedXAxisOffset = w.globals.rotateXLabels ? 22 : 10;
        var rotatedXAxisLegendOffset = w.globals.rotateXLabels && w.config.legend.position === 'bottom';
        var additionalOffset = rotatedXAxisLegendOffset ? 10 : 0;
        this.xAxisHeight = baseXAxisHeight * xAxisHeightMultiplicate + xAxisNum * rotatedXAxisOffset + additionalOffset;
        this.xAxisWidth = xaxisLabelCoords.width;
        if (this.xAxisHeight - xtitleCoords.height > w.config.xaxis.labels.maxHeight) {
          this.xAxisHeight = w.config.xaxis.labels.maxHeight;
        }
        if (w.config.xaxis.labels.minHeight && this.xAxisHeight < w.config.xaxis.labels.minHeight) {
          this.xAxisHeight = w.config.xaxis.labels.minHeight;
        }
        if (w.config.xaxis.floating) {
          this.xAxisHeight = 0;
        }
        var minYAxisWidth = 0;
        var maxYAxisWidth = 0;
        w.config.yaxis.forEach(function (y) {
          minYAxisWidth += y.labels.minWidth;
          maxYAxisWidth += y.labels.maxWidth;
        });
        if (this.yAxisWidth < minYAxisWidth) {
          this.yAxisWidth = minYAxisWidth;
        }
        if (this.yAxisWidth > maxYAxisWidth) {
          this.yAxisWidth = maxYAxisWidth;
        }
      }
    }]);
    return Dimensions;
  }();

  var Helpers$2 = /*#__PURE__*/function () {
    function Helpers(lgCtx) {
      _classCallCheck(this, Helpers);
      this.w = lgCtx.w;
      this.lgCtx = lgCtx;
    }
    _createClass(Helpers, [{
      key: "getLegendStyles",
      value: function getLegendStyles() {
        var _this$lgCtx$ctx, _this$lgCtx$ctx$opts, _this$lgCtx$ctx$opts$;
        var stylesheet = document.createElement('style');
        stylesheet.setAttribute('type', 'text/css');
        var nonce = ((_this$lgCtx$ctx = this.lgCtx.ctx) === null || _this$lgCtx$ctx === void 0 ? void 0 : (_this$lgCtx$ctx$opts = _this$lgCtx$ctx.opts) === null || _this$lgCtx$ctx$opts === void 0 ? void 0 : (_this$lgCtx$ctx$opts$ = _this$lgCtx$ctx$opts.chart) === null || _this$lgCtx$ctx$opts$ === void 0 ? void 0 : _this$lgCtx$ctx$opts$.nonce) || this.w.config.chart.nonce;
        if (nonce) {
          stylesheet.setAttribute('nonce', nonce);
        }
        var rule = document.createTextNode(css_248z$1);
        stylesheet.appendChild(rule);
        return stylesheet;
      }
    }, {
      key: "getLegendDimensions",
      value: function getLegendDimensions() {
        var w = this.w;
        var currLegendsWrap = w.globals.dom.baseEl.querySelector('.apexcharts-legend');
        var _currLegendsWrap$getB = currLegendsWrap.getBoundingClientRect(),
          currLegendsWrapWidth = _currLegendsWrap$getB.width,
          currLegendsWrapHeight = _currLegendsWrap$getB.height;
        return {
          clwh: currLegendsWrapHeight,
          clww: currLegendsWrapWidth
        };
      }
    }, {
      key: "appendToForeignObject",
      value: function appendToForeignObject() {
        var gl = this.w.globals;
        if (this.w.config.chart.injectStyleSheet !== false) {
          gl.dom.elLegendForeign.appendChild(this.getLegendStyles());
        }
      }
    }, {
      key: "toggleDataSeries",
      value: function toggleDataSeries(seriesCnt, isHidden) {
        var _this = this;
        var w = this.w;
        if (w.globals.axisCharts || w.config.chart.type === 'radialBar') {
          w.globals.resized = true; // we don't want initial animations again

          var seriesEl = null;
          var realIndex = null;

          // yes, make it null. 1 series will rise at a time
          w.globals.risingSeries = [];
          if (w.globals.axisCharts) {
            seriesEl = w.globals.dom.baseEl.querySelector(".apexcharts-series[data\\:realIndex='".concat(seriesCnt, "']"));
            realIndex = parseInt(seriesEl.getAttribute('data:realIndex'), 10);
          } else {
            seriesEl = w.globals.dom.baseEl.querySelector(".apexcharts-series[rel='".concat(seriesCnt + 1, "']"));
            realIndex = parseInt(seriesEl.getAttribute('rel'), 10) - 1;
          }
          if (isHidden) {
            var seriesToMakeVisible = [{
              cs: w.globals.collapsedSeries,
              csi: w.globals.collapsedSeriesIndices
            }, {
              cs: w.globals.ancillaryCollapsedSeries,
              csi: w.globals.ancillaryCollapsedSeriesIndices
            }];
            seriesToMakeVisible.forEach(function (r) {
              _this.riseCollapsedSeries(r.cs, r.csi, realIndex);
            });
          } else {
            this.hideSeries({
              seriesEl: seriesEl,
              realIndex: realIndex
            });
          }
        } else {
          // for non-axis charts i.e pie / donuts
          var _seriesEl = w.globals.dom.Paper.findOne(" .apexcharts-series[rel='".concat(seriesCnt + 1, "'] path"));
          var type = w.config.chart.type;
          if (type === 'pie' || type === 'polarArea' || type === 'donut') {
            var dataLabels = w.config.plotOptions.pie.donut.labels;
            var graphics = new Graphics(this.lgCtx.ctx);
            graphics.pathMouseDown(_seriesEl, null);
            this.lgCtx.ctx.pie.printDataLabelsInner(_seriesEl.node, dataLabels);
          }
          _seriesEl.fire('click');
        }
      }
    }, {
      key: "getSeriesAfterCollapsing",
      value: function getSeriesAfterCollapsing(_ref) {
        var realIndex = _ref.realIndex;
        var w = this.w;
        var gl = w.globals;
        var series = Utils$1.clone(w.config.series);
        if (gl.axisCharts) {
          var yaxis = w.config.yaxis[gl.seriesYAxisReverseMap[realIndex]];
          var collapseData = {
            index: realIndex,
            data: series[realIndex].data.slice(),
            type: series[realIndex].type || w.config.chart.type
          };
          if (yaxis && yaxis.show && yaxis.showAlways) {
            if (gl.ancillaryCollapsedSeriesIndices.indexOf(realIndex) < 0) {
              gl.ancillaryCollapsedSeries.push(collapseData);
              gl.ancillaryCollapsedSeriesIndices.push(realIndex);
            }
          } else {
            if (gl.collapsedSeriesIndices.indexOf(realIndex) < 0) {
              gl.collapsedSeries.push(collapseData);
              gl.collapsedSeriesIndices.push(realIndex);
              var removeIndexOfRising = gl.risingSeries.indexOf(realIndex);
              gl.risingSeries.splice(removeIndexOfRising, 1);
            }
          }
        } else {
          gl.collapsedSeries.push({
            index: realIndex,
            data: series[realIndex]
          });
          gl.collapsedSeriesIndices.push(realIndex);
        }
        gl.allSeriesCollapsed = gl.collapsedSeries.length + gl.ancillaryCollapsedSeries.length === w.config.series.length;
        return this._getSeriesBasedOnCollapsedState(series);
      }
    }, {
      key: "hideSeries",
      value: function hideSeries(_ref2) {
        var seriesEl = _ref2.seriesEl,
          realIndex = _ref2.realIndex;
        var w = this.w;
        var series = this.getSeriesAfterCollapsing({
          realIndex: realIndex
        });
        var seriesChildren = seriesEl.childNodes;
        for (var sc = 0; sc < seriesChildren.length; sc++) {
          if (seriesChildren[sc].classList.contains('apexcharts-series-markers-wrap')) {
            if (seriesChildren[sc].classList.contains('apexcharts-hide')) {
              seriesChildren[sc].classList.remove('apexcharts-hide');
            } else {
              seriesChildren[sc].classList.add('apexcharts-hide');
            }
          }
        }
        this.lgCtx.ctx.updateHelpers._updateSeries(series, w.config.chart.animations.dynamicAnimation.enabled);
      }
    }, {
      key: "riseCollapsedSeries",
      value: function riseCollapsedSeries(collapsedSeries, seriesIndices, realIndex) {
        var w = this.w;
        var series = Utils$1.clone(w.config.series);
        if (collapsedSeries.length > 0) {
          for (var c = 0; c < collapsedSeries.length; c++) {
            if (collapsedSeries[c].index === realIndex) {
              if (w.globals.axisCharts) {
                series[realIndex].data = collapsedSeries[c].data.slice();
              } else {
                series[realIndex] = collapsedSeries[c].data;
              }
              if (typeof series[realIndex] !== 'number') {
                series[realIndex].hidden = false;
              }
              collapsedSeries.splice(c, 1);
              seriesIndices.splice(c, 1);
              w.globals.risingSeries.push(realIndex);
            }
          }
          series = this._getSeriesBasedOnCollapsedState(series);
          this.lgCtx.ctx.updateHelpers._updateSeries(series, w.config.chart.animations.dynamicAnimation.enabled);
        }
      }
    }, {
      key: "_getSeriesBasedOnCollapsedState",
      value: function _getSeriesBasedOnCollapsedState(series) {
        var w = this.w;
        var collapsed = 0;
        if (w.globals.axisCharts) {
          series.forEach(function (s, sI) {
            if (!(w.globals.collapsedSeriesIndices.indexOf(sI) < 0 && w.globals.ancillaryCollapsedSeriesIndices.indexOf(sI) < 0)) {
              series[sI].data = [];
              collapsed++;
            }
          });
        } else {
          series.forEach(function (s, sI) {
            if (!w.globals.collapsedSeriesIndices.indexOf(sI) < 0) {
              series[sI] = 0;
              collapsed++;
            }
          });
        }
        w.globals.allSeriesCollapsed = collapsed === series.length;
        return series;
      }
    }]);
    return Helpers;
  }();

  /**
   * ApexCharts Legend Class to draw legend.
   *
   * @module Legend
   **/
  var Legend = /*#__PURE__*/function () {
    function Legend(ctx) {
      _classCallCheck(this, Legend);
      this.ctx = ctx;
      this.w = ctx.w;
      this.onLegendClick = this.onLegendClick.bind(this);
      this.onLegendHovered = this.onLegendHovered.bind(this);
      this.isBarsDistributed = this.w.config.chart.type === 'bar' && this.w.config.plotOptions.bar.distributed && this.w.config.series.length === 1;
      this.legendHelpers = new Helpers$2(this);
    }
    _createClass(Legend, [{
      key: "init",
      value: function init() {
        var w = this.w;
        var gl = w.globals;
        var cnf = w.config;
        var showLegendAlways = cnf.legend.showForSingleSeries && gl.series.length === 1 || this.isBarsDistributed || gl.series.length > 1;
        this.legendHelpers.appendToForeignObject();
        if ((showLegendAlways || !gl.axisCharts) && cnf.legend.show) {
          while (gl.dom.elLegendWrap.firstChild) {
            gl.dom.elLegendWrap.removeChild(gl.dom.elLegendWrap.firstChild);
          }
          this.drawLegends();
          if (cnf.legend.position === 'bottom' || cnf.legend.position === 'top') {
            this.legendAlignHorizontal();
          } else if (cnf.legend.position === 'right' || cnf.legend.position === 'left') {
            this.legendAlignVertical();
          }
        }
      }
    }, {
      key: "createLegendMarker",
      value: function createLegendMarker(_ref) {
        var i = _ref.i,
          fillcolor = _ref.fillcolor;
        var w = this.w;
        var elMarker = document.createElement('span');
        elMarker.classList.add('apexcharts-legend-marker');
        var mShape = w.config.legend.markers.shape || w.config.markers.shape;
        var shape = mShape;
        if (Array.isArray(mShape)) {
          shape = mShape[i];
        }
        var mSize = Array.isArray(w.config.legend.markers.size) ? parseFloat(w.config.legend.markers.size[i]) : parseFloat(w.config.legend.markers.size);
        var mOffsetX = Array.isArray(w.config.legend.markers.offsetX) ? parseFloat(w.config.legend.markers.offsetX[i]) : parseFloat(w.config.legend.markers.offsetX);
        var mOffsetY = Array.isArray(w.config.legend.markers.offsetY) ? parseFloat(w.config.legend.markers.offsetY[i]) : parseFloat(w.config.legend.markers.offsetY);
        var mBorderWidth = Array.isArray(w.config.legend.markers.strokeWidth) ? parseFloat(w.config.legend.markers.strokeWidth[i]) : parseFloat(w.config.legend.markers.strokeWidth);
        var mStyle = elMarker.style;
        mStyle.height = (mSize + mBorderWidth) * 2 + 'px';
        mStyle.width = (mSize + mBorderWidth) * 2 + 'px';
        mStyle.left = mOffsetX + 'px';
        mStyle.top = mOffsetY + 'px';
        if (w.config.legend.markers.customHTML) {
          mStyle.background = 'transparent';
          mStyle.color = fillcolor[i];
          if (Array.isArray(w.config.legend.markers.customHTML)) {
            if (w.config.legend.markers.customHTML[i]) {
              elMarker.innerHTML = w.config.legend.markers.customHTML[i]();
            }
          } else {
            elMarker.innerHTML = w.config.legend.markers.customHTML();
          }
        } else {
          var markers = new Markers(this.ctx);
          var markerConfig = markers.getMarkerConfig({
            cssClass: "apexcharts-legend-marker apexcharts-marker apexcharts-marker-".concat(shape),
            seriesIndex: i,
            strokeWidth: mBorderWidth,
            size: mSize
          });
          var SVGMarker = window.SVG().addTo(elMarker).size('100%', '100%');
          var marker = new Graphics(this.ctx).drawMarker(0, 0, _objectSpread2(_objectSpread2({}, markerConfig), {}, {
            pointFillColor: Array.isArray(fillcolor) ? fillcolor[i] : markerConfig.pointFillColor,
            shape: shape
          }));
          var shapesEls = w.globals.dom.Paper.find('.apexcharts-legend-marker.apexcharts-marker');
          shapesEls.forEach(function (shapeEl) {
            if (shapeEl.node.classList.contains('apexcharts-marker-triangle')) {
              shapeEl.node.style.transform = 'translate(50%, 45%)';
            } else {
              shapeEl.node.style.transform = 'translate(50%, 50%)';
            }
          });
          SVGMarker.add(marker);
        }
        return elMarker;
      }
    }, {
      key: "drawLegends",
      value: function drawLegends() {
        var _this = this;
        var me = this;
        var w = this.w;
        var fontFamily = w.config.legend.fontFamily;
        var legendNames = w.globals.seriesNames;
        var fillcolor = w.config.legend.markers.fillColors ? w.config.legend.markers.fillColors.slice() : w.globals.colors.slice();
        if (w.config.chart.type === 'heatmap') {
          var ranges = w.config.plotOptions.heatmap.colorScale.ranges;
          legendNames = ranges.map(function (colorScale) {
            return colorScale.name ? colorScale.name : colorScale.from + ' - ' + colorScale.to;
          });
          fillcolor = ranges.map(function (color) {
            return color.color;
          });
        } else if (this.isBarsDistributed) {
          legendNames = w.globals.labels.slice();
        }
        if (w.config.legend.customLegendItems.length) {
          legendNames = w.config.legend.customLegendItems;
        }
        var legendFormatter = w.globals.legendFormatter;
        var isLegendInversed = w.config.legend.inverseOrder;
        var legendGroups = [];
        if (w.globals.seriesGroups.length > 1 && w.config.legend.clusterGroupedSeries) {
          w.globals.seriesGroups.forEach(function (_, gi) {
            legendGroups[gi] = document.createElement('div');
            legendGroups[gi].classList.add('apexcharts-legend-group', "apexcharts-legend-group-".concat(gi));
            if (w.config.legend.clusterGroupedSeriesOrientation === 'horizontal') {
              w.globals.dom.elLegendWrap.classList.add('apexcharts-legend-group-horizontal');
            } else {
              legendGroups[gi].classList.add('apexcharts-legend-group-vertical');
            }
          });
        }
        var _loop = function _loop(i) {
          var _w$config$legend$labe;
          var text = legendFormatter(legendNames[i], {
            seriesIndex: i,
            w: w
          });
          var collapsedSeries = false;
          var ancillaryCollapsedSeries = false;
          if (w.globals.collapsedSeries.length > 0) {
            for (var c = 0; c < w.globals.collapsedSeries.length; c++) {
              if (w.globals.collapsedSeries[c].index === i) {
                collapsedSeries = true;
              }
            }
          }
          if (w.globals.ancillaryCollapsedSeriesIndices.length > 0) {
            for (var _c = 0; _c < w.globals.ancillaryCollapsedSeriesIndices.length; _c++) {
              if (w.globals.ancillaryCollapsedSeriesIndices[_c] === i) {
                ancillaryCollapsedSeries = true;
              }
            }
          }
          var elMarker = _this.createLegendMarker({
            i: i,
            fillcolor: fillcolor
          });
          Graphics.setAttrs(elMarker, {
            rel: i + 1,
            'data:collapsed': collapsedSeries || ancillaryCollapsedSeries
          });
          if (collapsedSeries || ancillaryCollapsedSeries) {
            elMarker.classList.add('apexcharts-inactive-legend');
          }
          var elLegend = document.createElement('div');
          var elLegendText = document.createElement('span');
          elLegendText.classList.add('apexcharts-legend-text');
          elLegendText.innerHTML = Array.isArray(text) ? text.join(' ') : text;
          var textColor = w.config.legend.labels.useSeriesColors ? w.globals.colors[i] : Array.isArray(w.config.legend.labels.colors) ? (_w$config$legend$labe = w.config.legend.labels.colors) === null || _w$config$legend$labe === void 0 ? void 0 : _w$config$legend$labe[i] : w.config.legend.labels.colors;
          if (!textColor) {
            textColor = w.config.chart.foreColor;
          }
          elLegendText.style.color = textColor;
          elLegendText.style.fontSize = parseFloat(w.config.legend.fontSize) + 'px';
          elLegendText.style.fontWeight = w.config.legend.fontWeight;
          elLegendText.style.fontFamily = fontFamily || w.config.chart.fontFamily;
          Graphics.setAttrs(elLegendText, {
            rel: i + 1,
            i: i,
            'data:default-text': encodeURIComponent(text),
            'data:collapsed': collapsedSeries || ancillaryCollapsedSeries
          });
          elLegend.appendChild(elMarker);
          elLegend.appendChild(elLegendText);
          var coreUtils = new CoreUtils(_this.ctx);
          if (!w.config.legend.showForZeroSeries) {
            var total = coreUtils.getSeriesTotalByIndex(i);
            if (total === 0 && coreUtils.seriesHaveSameValues(i) && !coreUtils.isSeriesNull(i) && w.globals.collapsedSeriesIndices.indexOf(i) === -1 && w.globals.ancillaryCollapsedSeriesIndices.indexOf(i) === -1) {
              elLegend.classList.add('apexcharts-hidden-zero-series');
            }
          }
          if (!w.config.legend.showForNullSeries) {
            if (coreUtils.isSeriesNull(i) && w.globals.collapsedSeriesIndices.indexOf(i) === -1 && w.globals.ancillaryCollapsedSeriesIndices.indexOf(i) === -1) {
              elLegend.classList.add('apexcharts-hidden-null-series');
            }
          }
          if (legendGroups.length) {
            w.globals.seriesGroups.forEach(function (group, gi) {
              var _w$config$series$i;
              if (group.includes((_w$config$series$i = w.config.series[i]) === null || _w$config$series$i === void 0 ? void 0 : _w$config$series$i.name)) {
                w.globals.dom.elLegendWrap.appendChild(legendGroups[gi]);
                legendGroups[gi].appendChild(elLegend);
              }
            });
          } else {
            w.globals.dom.elLegendWrap.appendChild(elLegend);
          }
          w.globals.dom.elLegendWrap.classList.add("apexcharts-align-".concat(w.config.legend.horizontalAlign));
          w.globals.dom.elLegendWrap.classList.add('apx-legend-position-' + w.config.legend.position);
          elLegend.classList.add('apexcharts-legend-series');
          elLegend.style.margin = "".concat(w.config.legend.itemMargin.vertical, "px ").concat(w.config.legend.itemMargin.horizontal, "px");
          w.globals.dom.elLegendWrap.style.width = w.config.legend.width ? w.config.legend.width + 'px' : '';
          w.globals.dom.elLegendWrap.style.height = w.config.legend.height ? w.config.legend.height + 'px' : '';
          Graphics.setAttrs(elLegend, {
            rel: i + 1,
            seriesName: Utils$1.escapeString(legendNames[i]),
            'data:collapsed': collapsedSeries || ancillaryCollapsedSeries
          });
          if (collapsedSeries || ancillaryCollapsedSeries) {
            elLegend.classList.add('apexcharts-inactive-legend');
          }
          if (!w.config.legend.onItemClick.toggleDataSeries) {
            elLegend.classList.add('apexcharts-no-click');
          }
        };
        for (var i = isLegendInversed ? legendNames.length - 1 : 0; isLegendInversed ? i >= 0 : i <= legendNames.length - 1; isLegendInversed ? i-- : i++) {
          _loop(i);
        }
        w.globals.dom.elWrap.addEventListener('click', me.onLegendClick, true);
        if (w.config.legend.onItemHover.highlightDataSeries && w.config.legend.customLegendItems.length === 0) {
          w.globals.dom.elWrap.addEventListener('mousemove', me.onLegendHovered, true);
          w.globals.dom.elWrap.addEventListener('mouseout', me.onLegendHovered, true);
        }
      }
    }, {
      key: "setLegendWrapXY",
      value: function setLegendWrapXY(offsetX, offsetY) {
        var w = this.w;
        var elLegendWrap = w.globals.dom.elLegendWrap;
        var legendHeight = elLegendWrap.clientHeight;
        var x = 0;
        var y = 0;
        if (w.config.legend.position === 'bottom') {
          y = w.globals.svgHeight - Math.min(legendHeight, w.globals.svgHeight / 2) - 5;
        } else if (w.config.legend.position === 'top') {
          var dim = new Dimensions(this.ctx);
          var titleH = dim.dimHelpers.getTitleSubtitleCoords('title').height;
          var subtitleH = dim.dimHelpers.getTitleSubtitleCoords('subtitle').height;
          y = (titleH > 0 ? titleH - 10 : 0) + (subtitleH > 0 ? subtitleH - 10 : 0);
        }
        elLegendWrap.style.position = 'absolute';
        x = x + offsetX + w.config.legend.offsetX;
        y = y + offsetY + w.config.legend.offsetY;
        elLegendWrap.style.left = x + 'px';
        elLegendWrap.style.top = y + 'px';
        if (w.config.legend.position === 'right') {
          elLegendWrap.style.left = 'auto';
          elLegendWrap.style.right = 25 + w.config.legend.offsetX + 'px';
        }
        var fixedHeigthWidth = ['width', 'height'];
        fixedHeigthWidth.forEach(function (hw) {
          if (elLegendWrap.style[hw]) {
            elLegendWrap.style[hw] = parseInt(w.config.legend[hw], 10) + 'px';
          }
        });
      }
    }, {
      key: "legendAlignHorizontal",
      value: function legendAlignHorizontal() {
        var w = this.w;
        var elLegendWrap = w.globals.dom.elLegendWrap;
        elLegendWrap.style.right = 0;
        var dimensions = new Dimensions(this.ctx);
        var titleRect = dimensions.dimHelpers.getTitleSubtitleCoords('title');
        var subtitleRect = dimensions.dimHelpers.getTitleSubtitleCoords('subtitle');
        var offsetX = 20;
        var offsetY = 0;
        if (w.config.legend.position === 'top') {
          offsetY = titleRect.height + subtitleRect.height + w.config.title.margin + w.config.subtitle.margin - 10;
        }
        this.setLegendWrapXY(offsetX, offsetY);
      }
    }, {
      key: "legendAlignVertical",
      value: function legendAlignVertical() {
        var w = this.w;
        var lRect = this.legendHelpers.getLegendDimensions();
        var offsetY = 20;
        var offsetX = 0;
        if (w.config.legend.position === 'left') {
          offsetX = 20;
        }
        if (w.config.legend.position === 'right') {
          offsetX = w.globals.svgWidth - lRect.clww - 10;
        }
        this.setLegendWrapXY(offsetX, offsetY);
      }
    }, {
      key: "onLegendHovered",
      value: function onLegendHovered(e) {
        var w = this.w;
        var hoverOverLegend = e.target.classList.contains('apexcharts-legend-series') || e.target.classList.contains('apexcharts-legend-text') || e.target.classList.contains('apexcharts-legend-marker');
        if (w.config.chart.type !== 'heatmap' && !this.isBarsDistributed) {
          if (!e.target.classList.contains('apexcharts-inactive-legend') && hoverOverLegend) {
            var series = new Series(this.ctx);
            series.toggleSeriesOnHover(e, e.target);
          }
        } else {
          // for heatmap handling
          if (hoverOverLegend) {
            var seriesCnt = parseInt(e.target.getAttribute('rel'), 10) - 1;
            this.ctx.events.fireEvent('legendHover', [this.ctx, seriesCnt, this.w]);
            var _series = new Series(this.ctx);
            _series.highlightRangeInSeries(e, e.target);
          }
        }
      }
    }, {
      key: "onLegendClick",
      value: function onLegendClick(e) {
        var w = this.w;
        if (w.config.legend.customLegendItems.length) return;
        if (e.target.classList.contains('apexcharts-legend-series') || e.target.classList.contains('apexcharts-legend-text') || e.target.classList.contains('apexcharts-legend-marker')) {
          var seriesCnt = parseInt(e.target.getAttribute('rel'), 10) - 1;
          var isHidden = e.target.getAttribute('data:collapsed') === 'true';
          var legendClick = this.w.config.chart.events.legendClick;
          if (typeof legendClick === 'function') {
            legendClick(this.ctx, seriesCnt, this.w);
          }
          this.ctx.events.fireEvent('legendClick', [this.ctx, seriesCnt, this.w]);
          var markerClick = this.w.config.legend.markers.onClick;
          if (typeof markerClick === 'function' && e.target.classList.contains('apexcharts-legend-marker')) {
            markerClick(this.ctx, seriesCnt, this.w);
            this.ctx.events.fireEvent('legendMarkerClick', [this.ctx, seriesCnt, this.w]);
          }

          // for now - just prevent click on heatmap legend - and allow hover only
          var clickAllowed = w.config.chart.type !== 'treemap' && w.config.chart.type !== 'heatmap' && !this.isBarsDistributed;
          if (clickAllowed && w.config.legend.onItemClick.toggleDataSeries) {
            this.legendHelpers.toggleDataSeries(seriesCnt, isHidden);
          }
        }
      }
    }]);
    return Legend;
  }();

  var icoPan = "<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" fill=\"#000000\" height=\"24\" viewBox=\"0 0 24 24\" width=\"24\">\n    <defs>\n        <path d=\"M0 0h24v24H0z\" id=\"a\"/>\n    </defs>\n    <clipPath id=\"b\">\n        <use overflow=\"visible\" xlink:href=\"#a\"/>\n    </clipPath>\n    <path clip-path=\"url(#b)\" d=\"M23 5.5V20c0 2.2-1.8 4-4 4h-7.3c-1.08 0-2.1-.43-2.85-1.19L1 14.83s1.26-1.23 1.3-1.25c.22-.19.49-.29.79-.29.22 0 .42.06.6.16.04.01 4.31 2.46 4.31 2.46V4c0-.83.67-1.5 1.5-1.5S11 3.17 11 4v7h1V1.5c0-.83.67-1.5 1.5-1.5S15 .67 15 1.5V11h1V2.5c0-.83.67-1.5 1.5-1.5s1.5.67 1.5 1.5V11h1V5.5c0-.83.67-1.5 1.5-1.5s1.5.67 1.5 1.5z\"/>\n</svg>";

  var icoZoom = "<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"#000000\" height=\"24\" viewBox=\"0 0 24 24\" width=\"24\">\n    <path d=\"M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z\"/>\n    <path d=\"M0 0h24v24H0V0z\" fill=\"none\"/>\n    <path d=\"M12 10h-2v2H9v-2H7V9h2V7h1v2h2v1z\"/>\n</svg>";

  var icoReset = "<svg fill=\"#000000\" height=\"24\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\">\n    <path d=\"M10 20v-6h4v6h5v-8h3L12 3 2 12h3v8z\"/>\n    <path d=\"M0 0h24v24H0z\" fill=\"none\"/>\n</svg>";

  var icoZoomIn = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\">\n    <path d=\"M0 0h24v24H0z\" fill=\"none\"/>\n    <path d=\"M13 7h-2v4H7v2h4v4h2v-4h4v-2h-4V7zm-1-5C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z\"/>\n</svg>\n";

  var icoZoomOut = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\">\n    <path d=\"M0 0h24v24H0z\" fill=\"none\"/>\n    <path d=\"M7 11v2h10v-2H7zm5-9C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z\"/>\n</svg>\n";

  var icoSelect = "<svg fill=\"#6E8192\" height=\"24\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\">\n    <path d=\"M0 0h24v24H0z\" fill=\"none\"/>\n    <path d=\"M3 5h2V3c-1.1 0-2 .9-2 2zm0 8h2v-2H3v2zm4 8h2v-2H7v2zM3 9h2V7H3v2zm10-6h-2v2h2V3zm6 0v2h2c0-1.1-.9-2-2-2zM5 21v-2H3c0 1.1.9 2 2 2zm-2-4h2v-2H3v2zM9 3H7v2h2V3zm2 18h2v-2h-2v2zm8-8h2v-2h-2v2zm0 8c1.1 0 2-.9 2-2h-2v2zm0-12h2V7h-2v2zm0 8h2v-2h-2v2zm-4 4h2v-2h-2v2zm0-16h2V3h-2v2z\"/>\n</svg>";

  var icoMenu = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\"><path fill=\"none\" d=\"M0 0h24v24H0V0z\"/><path d=\"M3 18h18v-2H3v2zm0-5h18v-2H3v2zm0-7v2h18V6H3z\"/></svg>";

  /**
   * ApexCharts Toolbar Class for creating toolbar in axis based charts.
   *
   * @module Toolbar
   **/
  var Toolbar = /*#__PURE__*/function () {
    function Toolbar(ctx) {
      _classCallCheck(this, Toolbar);
      this.ctx = ctx;
      this.w = ctx.w;
      var w = this.w;
      this.ev = this.w.config.chart.events;
      this.selectedClass = 'apexcharts-selected';
      this.localeValues = this.w.globals.locale.toolbar;
      this.minX = w.globals.minX;
      this.maxX = w.globals.maxX;
    }
    _createClass(Toolbar, [{
      key: "createToolbar",
      value: function createToolbar() {
        var _this = this;
        var w = this.w;
        var createDiv = function createDiv() {
          return document.createElement('div');
        };
        var elToolbarWrap = createDiv();
        elToolbarWrap.setAttribute('class', 'apexcharts-toolbar');
        elToolbarWrap.style.top = w.config.chart.toolbar.offsetY + 'px';
        elToolbarWrap.style.right = -w.config.chart.toolbar.offsetX + 3 + 'px';
        w.globals.dom.elWrap.appendChild(elToolbarWrap);
        this.elZoom = createDiv();
        this.elZoomIn = createDiv();
        this.elZoomOut = createDiv();
        this.elPan = createDiv();
        this.elSelection = createDiv();
        this.elZoomReset = createDiv();
        this.elMenuIcon = createDiv();
        this.elMenu = createDiv();
        this.elCustomIcons = [];
        this.t = w.config.chart.toolbar.tools;
        if (Array.isArray(this.t.customIcons)) {
          for (var i = 0; i < this.t.customIcons.length; i++) {
            this.elCustomIcons.push(createDiv());
          }
        }
        var toolbarControls = [];
        var appendZoomControl = function appendZoomControl(type, el, ico) {
          var tool = type.toLowerCase();
          if (_this.t[tool] && w.config.chart.zoom.enabled) {
            toolbarControls.push({
              el: el,
              icon: typeof _this.t[tool] === 'string' ? _this.t[tool] : ico,
              title: _this.localeValues[type],
              class: "apexcharts-".concat(tool, "-icon")
            });
          }
        };
        appendZoomControl('zoomIn', this.elZoomIn, icoZoomIn);
        appendZoomControl('zoomOut', this.elZoomOut, icoZoomOut);
        var zoomSelectionCtrls = function zoomSelectionCtrls(z) {
          if (_this.t[z] && w.config.chart[z].enabled) {
            toolbarControls.push({
              el: z === 'zoom' ? _this.elZoom : _this.elSelection,
              icon: typeof _this.t[z] === 'string' ? _this.t[z] : z === 'zoom' ? icoZoom : icoSelect,
              title: _this.localeValues[z === 'zoom' ? 'selectionZoom' : 'selection'],
              class: "apexcharts-".concat(z, "-icon")
            });
          }
        };
        zoomSelectionCtrls('zoom');
        zoomSelectionCtrls('selection');
        if (this.t.pan && w.config.chart.zoom.enabled) {
          toolbarControls.push({
            el: this.elPan,
            icon: typeof this.t.pan === 'string' ? this.t.pan : icoPan,
            title: this.localeValues.pan,
            class: 'apexcharts-pan-icon'
          });
        }
        appendZoomControl('reset', this.elZoomReset, icoReset);
        if (this.t.download) {
          toolbarControls.push({
            el: this.elMenuIcon,
            icon: typeof this.t.download === 'string' ? this.t.download : icoMenu,
            title: this.localeValues.menu,
            class: 'apexcharts-menu-icon'
          });
        }
        for (var _i = 0; _i < this.elCustomIcons.length; _i++) {
          toolbarControls.push({
            el: this.elCustomIcons[_i],
            icon: this.t.customIcons[_i].icon,
            title: this.t.customIcons[_i].title,
            index: this.t.customIcons[_i].index,
            class: 'apexcharts-toolbar-custom-icon ' + this.t.customIcons[_i].class
          });
        }
        toolbarControls.forEach(function (t, index) {
          if (t.index) {
            Utils$1.moveIndexInArray(toolbarControls, index, t.index);
          }
        });
        for (var _i2 = 0; _i2 < toolbarControls.length; _i2++) {
          Graphics.setAttrs(toolbarControls[_i2].el, {
            class: toolbarControls[_i2].class,
            title: toolbarControls[_i2].title
          });
          toolbarControls[_i2].el.innerHTML = toolbarControls[_i2].icon;
          elToolbarWrap.appendChild(toolbarControls[_i2].el);
        }
        this._createHamburgerMenu(elToolbarWrap);
        if (w.globals.zoomEnabled) {
          this.elZoom.classList.add(this.selectedClass);
        } else if (w.globals.panEnabled) {
          this.elPan.classList.add(this.selectedClass);
        } else if (w.globals.selectionEnabled) {
          this.elSelection.classList.add(this.selectedClass);
        }
        this.addToolbarEventListeners();
      }
    }, {
      key: "_createHamburgerMenu",
      value: function _createHamburgerMenu(parent) {
        this.elMenuItems = [];
        parent.appendChild(this.elMenu);
        Graphics.setAttrs(this.elMenu, {
          class: 'apexcharts-menu'
        });
        var menuItems = [{
          name: 'exportSVG',
          title: this.localeValues.exportToSVG
        }, {
          name: 'exportPNG',
          title: this.localeValues.exportToPNG
        }, {
          name: 'exportCSV',
          title: this.localeValues.exportToCSV
        }];
        for (var i = 0; i < menuItems.length; i++) {
          this.elMenuItems.push(document.createElement('div'));
          this.elMenuItems[i].innerHTML = menuItems[i].title;
          Graphics.setAttrs(this.elMenuItems[i], {
            class: "apexcharts-menu-item ".concat(menuItems[i].name),
            title: menuItems[i].title
          });
          this.elMenu.appendChild(this.elMenuItems[i]);
        }
      }
    }, {
      key: "addToolbarEventListeners",
      value: function addToolbarEventListeners() {
        var _this2 = this;
        this.elZoomReset.addEventListener('click', this.handleZoomReset.bind(this));
        this.elSelection.addEventListener('click', this.toggleZoomSelection.bind(this, 'selection'));
        this.elZoom.addEventListener('click', this.toggleZoomSelection.bind(this, 'zoom'));
        this.elZoomIn.addEventListener('click', this.handleZoomIn.bind(this));
        this.elZoomOut.addEventListener('click', this.handleZoomOut.bind(this));
        this.elPan.addEventListener('click', this.togglePanning.bind(this));
        this.elMenuIcon.addEventListener('click', this.toggleMenu.bind(this));
        this.elMenuItems.forEach(function (m) {
          if (m.classList.contains('exportSVG')) {
            m.addEventListener('click', _this2.handleDownload.bind(_this2, 'svg'));
          } else if (m.classList.contains('exportPNG')) {
            m.addEventListener('click', _this2.handleDownload.bind(_this2, 'png'));
          } else if (m.classList.contains('exportCSV')) {
            m.addEventListener('click', _this2.handleDownload.bind(_this2, 'csv'));
          }
        });
        for (var i = 0; i < this.t.customIcons.length; i++) {
          this.elCustomIcons[i].addEventListener('click', this.t.customIcons[i].click.bind(this, this.ctx, this.ctx.w));
        }
      }
    }, {
      key: "toggleZoomSelection",
      value: function toggleZoomSelection(type) {
        var charts = this.ctx.getSyncedCharts();
        charts.forEach(function (ch) {
          ch.ctx.toolbar.toggleOtherControls();
          var el = type === 'selection' ? ch.ctx.toolbar.elSelection : ch.ctx.toolbar.elZoom;
          var enabledType = type === 'selection' ? 'selectionEnabled' : 'zoomEnabled';
          ch.w.globals[enabledType] = !ch.w.globals[enabledType];
          if (!el.classList.contains(ch.ctx.toolbar.selectedClass)) {
            el.classList.add(ch.ctx.toolbar.selectedClass);
          } else {
            el.classList.remove(ch.ctx.toolbar.selectedClass);
          }
        });
      }
    }, {
      key: "getToolbarIconsReference",
      value: function getToolbarIconsReference() {
        var w = this.w;
        if (!this.elZoom) {
          this.elZoom = w.globals.dom.baseEl.querySelector('.apexcharts-zoom-icon');
        }
        if (!this.elPan) {
          this.elPan = w.globals.dom.baseEl.querySelector('.apexcharts-pan-icon');
        }
        if (!this.elSelection) {
          this.elSelection = w.globals.dom.baseEl.querySelector('.apexcharts-selection-icon');
        }
      }
    }, {
      key: "enableZoomPanFromToolbar",
      value: function enableZoomPanFromToolbar(type) {
        this.toggleOtherControls();
        type === 'pan' ? this.w.globals.panEnabled = true : this.w.globals.zoomEnabled = true;
        var el = type === 'pan' ? this.elPan : this.elZoom;
        var el2 = type === 'pan' ? this.elZoom : this.elPan;
        if (el) {
          el.classList.add(this.selectedClass);
        }
        if (el2) {
          el2.classList.remove(this.selectedClass);
        }
      }
    }, {
      key: "togglePanning",
      value: function togglePanning() {
        var charts = this.ctx.getSyncedCharts();
        charts.forEach(function (ch) {
          ch.ctx.toolbar.toggleOtherControls();
          ch.w.globals.panEnabled = !ch.w.globals.panEnabled;
          if (!ch.ctx.toolbar.elPan.classList.contains(ch.ctx.toolbar.selectedClass)) {
            ch.ctx.toolbar.elPan.classList.add(ch.ctx.toolbar.selectedClass);
          } else {
            ch.ctx.toolbar.elPan.classList.remove(ch.ctx.toolbar.selectedClass);
          }
        });
      }
    }, {
      key: "toggleOtherControls",
      value: function toggleOtherControls() {
        var _this3 = this;
        var w = this.w;
        w.globals.panEnabled = false;
        w.globals.zoomEnabled = false;
        w.globals.selectionEnabled = false;
        this.getToolbarIconsReference();
        var toggleEls = [this.elPan, this.elSelection, this.elZoom];
        toggleEls.forEach(function (el) {
          if (el) {
            el.classList.remove(_this3.selectedClass);
          }
        });
      }
    }, {
      key: "handleZoomIn",
      value: function handleZoomIn() {
        var w = this.w;
        if (w.globals.isRangeBar) {
          this.minX = w.globals.minY;
          this.maxX = w.globals.maxY;
        }
        var centerX = (this.minX + this.maxX) / 2;
        var newMinX = (this.minX + centerX) / 2;
        var newMaxX = (this.maxX + centerX) / 2;
        var newMinXMaxX = this._getNewMinXMaxX(newMinX, newMaxX);
        if (!w.globals.disableZoomIn) {
          this.zoomUpdateOptions(newMinXMaxX.minX, newMinXMaxX.maxX);
        }
      }
    }, {
      key: "handleZoomOut",
      value: function handleZoomOut() {
        var w = this.w;
        if (w.globals.isRangeBar) {
          this.minX = w.globals.minY;
          this.maxX = w.globals.maxY;
        }

        // avoid zooming out beyond 1000 which may result in NaN values being printed on x-axis
        if (w.config.xaxis.type === 'datetime' && new Date(this.minX).getUTCFullYear() < 1000) {
          return;
        }
        var centerX = (this.minX + this.maxX) / 2;
        var newMinX = this.minX - (centerX - this.minX);
        var newMaxX = this.maxX - (centerX - this.maxX);
        var newMinXMaxX = this._getNewMinXMaxX(newMinX, newMaxX);
        if (!w.globals.disableZoomOut) {
          this.zoomUpdateOptions(newMinXMaxX.minX, newMinXMaxX.maxX);
        }
      }
    }, {
      key: "_getNewMinXMaxX",
      value: function _getNewMinXMaxX(newMinX, newMaxX) {
        var shouldFloor = this.w.config.xaxis.convertedCatToNumeric;
        return {
          minX: shouldFloor ? Math.floor(newMinX) : newMinX,
          maxX: shouldFloor ? Math.floor(newMaxX) : newMaxX
        };
      }
    }, {
      key: "zoomUpdateOptions",
      value: function zoomUpdateOptions(newMinX, newMaxX) {
        var w = this.w;
        if (newMinX === undefined && newMaxX === undefined) {
          this.handleZoomReset();
          return;
        }
        if (w.config.xaxis.convertedCatToNumeric) {
          // in category charts, avoid zooming out beyond min and max
          if (newMinX < 1) {
            newMinX = 1;
            newMaxX = w.globals.dataPoints;
          }
          if (newMaxX - newMinX < 2) {
            return;
          }
        }
        var xaxis = {
          min: newMinX,
          max: newMaxX
        };
        var beforeZoomRange = this.getBeforeZoomRange(xaxis);
        if (beforeZoomRange) {
          xaxis = beforeZoomRange.xaxis;
        }
        var options = {
          xaxis: xaxis
        };
        var yaxis = Utils$1.clone(w.globals.initialConfig.yaxis);
        if (!w.config.chart.group) {
          // if chart in a group, prevent yaxis update here
          // fix issue #650
          options.yaxis = yaxis;
        }
        this.w.globals.zoomed = true;
        this.ctx.updateHelpers._updateOptions(options, false, this.w.config.chart.animations.dynamicAnimation.enabled);
        this.zoomCallback(xaxis, yaxis);
      }
    }, {
      key: "zoomCallback",
      value: function zoomCallback(xaxis, yaxis) {
        if (typeof this.ev.zoomed === 'function') {
          this.ev.zoomed(this.ctx, {
            xaxis: xaxis,
            yaxis: yaxis
          });
          this.ctx.events.fireEvent('zoomed', {
            xaxis: xaxis,
            yaxis: yaxis
          });
        }
      }
    }, {
      key: "getBeforeZoomRange",
      value: function getBeforeZoomRange(xaxis, yaxis) {
        var newRange = null;
        if (typeof this.ev.beforeZoom === 'function') {
          newRange = this.ev.beforeZoom(this, {
            xaxis: xaxis,
            yaxis: yaxis
          });
        }
        return newRange;
      }
    }, {
      key: "toggleMenu",
      value: function toggleMenu() {
        var _this4 = this;
        window.setTimeout(function () {
          if (_this4.elMenu.classList.contains('apexcharts-menu-open')) {
            _this4.elMenu.classList.remove('apexcharts-menu-open');
          } else {
            _this4.elMenu.classList.add('apexcharts-menu-open');
          }
        }, 0);
      }
    }, {
      key: "handleDownload",
      value: function handleDownload(type) {
        var w = this.w;
        var exprt = new Exports(this.ctx);
        switch (type) {
          case 'svg':
            exprt.exportToSVG(this.ctx);
            break;
          case 'png':
            exprt.exportToPng(this.ctx);
            break;
          case 'csv':
            exprt.exportToCSV({
              series: w.config.series,
              columnDelimiter: w.config.chart.toolbar.export.csv.columnDelimiter
            });
            break;
        }
      }
    }, {
      key: "handleZoomReset",
      value: function handleZoomReset(e) {
        var charts = this.ctx.getSyncedCharts();
        charts.forEach(function (ch) {
          var w = ch.w;

          // forget lastXAxis min/max as reset button isn't resetting the x-axis completely if zoomX is called before
          w.globals.lastXAxis.min = w.globals.initialConfig.xaxis.min;
          w.globals.lastXAxis.max = w.globals.initialConfig.xaxis.max;
          ch.updateHelpers.revertDefaultAxisMinMax();
          if (typeof w.config.chart.events.beforeResetZoom === 'function') {
            // here, user get an option to control xaxis and yaxis when resetZoom is called
            // at this point, whatever is returned from w.config.chart.events.beforeResetZoom
            // is set as the new xaxis/yaxis min/max
            var resetZoomRange = w.config.chart.events.beforeResetZoom(ch, w);
            if (resetZoomRange) {
              ch.updateHelpers.revertDefaultAxisMinMax(resetZoomRange);
            }
          }
          if (typeof w.config.chart.events.zoomed === 'function') {
            ch.ctx.toolbar.zoomCallback({
              min: w.config.xaxis.min,
              max: w.config.xaxis.max
            });
          }
          w.globals.zoomed = false;

          // if user has some series collapsed before hitting zoom reset button,
          // those series should stay collapsed
          var series = ch.ctx.series.emptyCollapsedSeries(Utils$1.clone(w.globals.initialSeries));
          ch.updateHelpers._updateSeries(series, w.config.chart.animations.dynamicAnimation.enabled);
        });
      }
    }, {
      key: "destroy",
      value: function destroy() {
        this.elZoom = null;
        this.elZoomIn = null;
        this.elZoomOut = null;
        this.elPan = null;
        this.elSelection = null;
        this.elZoomReset = null;
        this.elMenuIcon = null;
      }
    }]);
    return Toolbar;
  }();

  /**
   * ApexCharts Zoom Class for handling zooming and panning on axes based charts.
   *
   * @module ZoomPanSelection
   **/
  var ZoomPanSelection = /*#__PURE__*/function (_Toolbar) {
    _inherits(ZoomPanSelection, _Toolbar);
    var _super = _createSuper(ZoomPanSelection);
    function ZoomPanSelection(ctx) {
      var _this;
      _classCallCheck(this, ZoomPanSelection);
      _this = _super.call(this, ctx);
      _this.ctx = ctx;
      _this.w = ctx.w;
      _this.dragged = false;
      _this.graphics = new Graphics(_this.ctx);
      _this.eventList = ['mousedown', 'mouseleave', 'mousemove', 'touchstart', 'touchmove', 'mouseup', 'touchend', 'wheel'];
      _this.clientX = 0;
      _this.clientY = 0;
      _this.startX = 0;
      _this.endX = 0;
      _this.dragX = 0;
      _this.startY = 0;
      _this.endY = 0;
      _this.dragY = 0;
      _this.moveDirection = 'none';
      _this.debounceTimer = null;
      _this.debounceDelay = 100;
      _this.wheelDelay = 400;
      return _this;
    }
    _createClass(ZoomPanSelection, [{
      key: "init",
      value: function init(_ref) {
        var _this2 = this;
        var xyRatios = _ref.xyRatios;
        var w = this.w;
        var me = this;
        this.xyRatios = xyRatios;
        this.zoomRect = this.graphics.drawRect(0, 0, 0, 0);
        this.selectionRect = this.graphics.drawRect(0, 0, 0, 0);
        this.gridRect = w.globals.dom.baseEl.querySelector('.apexcharts-grid');
        this.constraints = new Box(0, 0, w.globals.gridWidth, w.globals.gridHeight);
        this.zoomRect.node.classList.add('apexcharts-zoom-rect');
        this.selectionRect.node.classList.add('apexcharts-selection-rect');
        w.globals.dom.Paper.add(this.zoomRect);
        w.globals.dom.Paper.add(this.selectionRect);
        if (w.config.chart.selection.type === 'x') {
          this.slDraggableRect = this.selectionRect.draggable({
            minX: 0,
            minY: 0,
            maxX: w.globals.gridWidth,
            maxY: w.globals.gridHeight
          }).on('dragmove.namespace', this.selectionDragging.bind(this, 'dragging'));
        } else if (w.config.chart.selection.type === 'y') {
          this.slDraggableRect = this.selectionRect.draggable({
            minX: 0,
            maxX: w.globals.gridWidth
          }).on('dragmove.namespace', this.selectionDragging.bind(this, 'dragging'));
        } else {
          this.slDraggableRect = this.selectionRect.draggable().on('dragmove.namespace', this.selectionDragging.bind(this, 'dragging'));
        }
        this.preselectedSelection();
        this.hoverArea = w.globals.dom.baseEl.querySelector("".concat(w.globals.chartClass, " .apexcharts-svg"));
        this.hoverArea.classList.add('apexcharts-zoomable');
        this.eventList.forEach(function (event) {
          _this2.hoverArea.addEventListener(event, me.svgMouseEvents.bind(me, xyRatios), {
            capture: false,
            passive: true
          });
        });
        if (w.config.chart.zoom.enabled && w.config.chart.zoom.allowMouseWheelZoom) {
          this.hoverArea.addEventListener('wheel', me.mouseWheelEvent.bind(me), {
            capture: false,
            passive: false
          });
        }
      }

      // remove the event listeners which were previously added on hover area
    }, {
      key: "destroy",
      value: function destroy() {
        if (this.slDraggableRect) {
          this.slDraggableRect.draggable(false);
          this.slDraggableRect.off();
          this.selectionRect.off();
        }
        this.selectionRect = null;
        this.zoomRect = null;
        this.gridRect = null;
      }
    }, {
      key: "svgMouseEvents",
      value: function svgMouseEvents(xyRatios, e) {
        var w = this.w;
        var toolbar = this.ctx.toolbar;
        var zoomtype = w.globals.zoomEnabled ? w.config.chart.zoom.type : w.config.chart.selection.type;
        var autoSelected = w.config.chart.toolbar.autoSelected;
        if (e.shiftKey) {
          this.shiftWasPressed = true;
          toolbar.enableZoomPanFromToolbar(autoSelected === 'pan' ? 'zoom' : 'pan');
        } else {
          if (this.shiftWasPressed) {
            toolbar.enableZoomPanFromToolbar(autoSelected);
            this.shiftWasPressed = false;
          }
        }
        if (!e.target) return;
        var tc = e.target.classList;
        var pc;
        if (e.target.parentNode && e.target.parentNode !== null) {
          pc = e.target.parentNode.classList;
        }
        var falsePositives = tc.contains('apexcharts-legend-marker') || tc.contains('apexcharts-legend-text') || pc && pc.contains('apexcharts-toolbar');
        if (falsePositives) return;
        this.clientX = e.type === 'touchmove' || e.type === 'touchstart' ? e.touches[0].clientX : e.type === 'touchend' ? e.changedTouches[0].clientX : e.clientX;
        this.clientY = e.type === 'touchmove' || e.type === 'touchstart' ? e.touches[0].clientY : e.type === 'touchend' ? e.changedTouches[0].clientY : e.clientY;
        if (e.type === 'mousedown' && e.which === 1 || e.type === 'touchstart') {
          var gridRectDim = this.gridRect.getBoundingClientRect();
          this.startX = this.clientX - gridRectDim.left - w.globals.barPadForNumericAxis;
          this.startY = this.clientY - gridRectDim.top;
          this.dragged = false;
          this.w.globals.mousedown = true;
        }
        if (e.type === 'mousemove' && e.which === 1 || e.type === 'touchmove') {
          this.dragged = true;
          if (w.globals.panEnabled) {
            w.globals.selection = null;
            if (this.w.globals.mousedown) {
              this.panDragging({
                context: this,
                zoomtype: zoomtype,
                xyRatios: xyRatios
              });
            }
          } else {
            if (this.w.globals.mousedown && w.globals.zoomEnabled || this.w.globals.mousedown && w.globals.selectionEnabled) {
              this.selection = this.selectionDrawing({
                context: this,
                zoomtype: zoomtype
              });
            }
          }
        }
        if (e.type === 'mouseup' || e.type === 'touchend' || e.type === 'mouseleave') {
          this.handleMouseUp({
            zoomtype: zoomtype
          });
        }
        this.makeSelectionRectDraggable();
      }
    }, {
      key: "handleMouseUp",
      value: function handleMouseUp(_ref2) {
        var _this$gridRect;
        var zoomtype = _ref2.zoomtype,
          isResized = _ref2.isResized;
        var w = this.w;
        // we will be calling getBoundingClientRect on each mousedown/mousemove/mouseup
        var gridRectDim = (_this$gridRect = this.gridRect) === null || _this$gridRect === void 0 ? void 0 : _this$gridRect.getBoundingClientRect();
        if (gridRectDim && (this.w.globals.mousedown || isResized)) {
          // user released the drag, now do all the calculations
          this.endX = this.clientX - gridRectDim.left - w.globals.barPadForNumericAxis;
          this.endY = this.clientY - gridRectDim.top;
          this.dragX = Math.abs(this.endX - this.startX);
          this.dragY = Math.abs(this.endY - this.startY);
          if (w.globals.zoomEnabled || w.globals.selectionEnabled) {
            this.selectionDrawn({
              context: this,
              zoomtype: zoomtype
            });
          }

          // if (w.globals.panEnabled && w.config.xaxis.convertedCatToNumeric) {
          //   this.delayedPanScrolled()
          // }
        }
        if (w.globals.zoomEnabled) {
          this.hideSelectionRect(this.selectionRect);
        }
        this.dragged = false;
        this.w.globals.mousedown = false;
      }
    }, {
      key: "mouseWheelEvent",
      value: function mouseWheelEvent(e) {
        var _this3 = this;
        var w = this.w;
        e.preventDefault();
        var now = Date.now();

        // Execute immediately if it's the first action or enough time has passed
        if (now - w.globals.lastWheelExecution > this.wheelDelay) {
          this.executeMouseWheelZoom(e);
          w.globals.lastWheelExecution = now;
        }
        if (this.debounceTimer) clearTimeout(this.debounceTimer);
        this.debounceTimer = setTimeout(function () {
          if (now - w.globals.lastWheelExecution > _this3.wheelDelay) {
            _this3.executeMouseWheelZoom(e);
            w.globals.lastWheelExecution = now;
          }
        }, this.debounceDelay);
      }
    }, {
      key: "executeMouseWheelZoom",
      value: function executeMouseWheelZoom(e) {
        var _this$gridRect2;
        var w = this.w;
        this.minX = w.globals.isRangeBar ? w.globals.minY : w.globals.minX;
        this.maxX = w.globals.isRangeBar ? w.globals.maxY : w.globals.maxX;

        // Calculate the relative position of the mouse on the chart
        var gridRectDim = (_this$gridRect2 = this.gridRect) === null || _this$gridRect2 === void 0 ? void 0 : _this$gridRect2.getBoundingClientRect();
        if (!gridRectDim) return;
        var mouseX = (e.clientX - gridRectDim.left) / gridRectDim.width;
        var currentMinX = this.minX;
        var currentMaxX = this.maxX;
        var totalX = currentMaxX - currentMinX;

        // Determine zoom factor
        var zoomFactorIn = 0.5;
        var zoomFactorOut = 1.5;
        var zoomRange;
        var newMinX, newMaxX;
        if (e.deltaY < 0) {
          // Zoom In
          zoomRange = zoomFactorIn * totalX;
          var midPoint = currentMinX + mouseX * totalX;
          newMinX = midPoint - zoomRange / 2;
          newMaxX = midPoint + zoomRange / 2;
        } else {
          // Zoom Out
          zoomRange = zoomFactorOut * totalX;
          newMinX = currentMinX - zoomRange / 2;
          newMaxX = currentMaxX + zoomRange / 2;
        }

        // Constrain within original chart bounds
        if (!w.globals.isRangeBar) {
          newMinX = Math.max(newMinX, w.globals.initialMinX);
          newMaxX = Math.min(newMaxX, w.globals.initialMaxX);

          // Ensure minimum range
          var minRange = (w.globals.initialMaxX - w.globals.initialMinX) * 0.01;
          if (newMaxX - newMinX < minRange) {
            var _midPoint = (newMinX + newMaxX) / 2;
            newMinX = _midPoint - minRange / 2;
            newMaxX = _midPoint + minRange / 2;
          }
        }
        var newMinXMaxX = this._getNewMinXMaxX(newMinX, newMaxX);

        // Apply zoom if valid
        if (!isNaN(newMinXMaxX.minX) && !isNaN(newMinXMaxX.maxX)) {
          this.zoomUpdateOptions(newMinXMaxX.minX, newMinXMaxX.maxX);
        }
      }
    }, {
      key: "makeSelectionRectDraggable",
      value: function makeSelectionRectDraggable() {
        var _this4 = this;
        var w = this.w;
        if (!this.selectionRect) return;
        var rectDim = this.selectionRect.node.getBoundingClientRect();
        if (rectDim.width > 0 && rectDim.height > 0) {
          this.selectionRect.select(false).resize(false);
          this.selectionRect.select({
            createRot: function createRot() {},
            updateRot: function updateRot() {},
            createHandle: function createHandle(group, p, index, pointArr, handleName) {
              if (handleName === 'l' || handleName === 'r') return group.circle(8).css({
                'stroke-width': 1,
                stroke: '#333',
                fill: '#fff'
              });
              return group.circle(0);
            },
            updateHandle: function updateHandle(group, p) {
              return group.center(p[0], p[1]);
            }
          }).resize().on('resize', function () {
            var zoomtype = w.globals.zoomEnabled ? w.config.chart.zoom.type : w.config.chart.selection.type;
            _this4.handleMouseUp({
              zoomtype: zoomtype,
              isResized: true
            });
          });
        }
      }
    }, {
      key: "preselectedSelection",
      value: function preselectedSelection() {
        var w = this.w;
        var xyRatios = this.xyRatios;
        if (!w.globals.zoomEnabled) {
          if (typeof w.globals.selection !== 'undefined' && w.globals.selection !== null) {
            this.drawSelectionRect(_objectSpread2(_objectSpread2({}, w.globals.selection), {}, {
              translateX: w.globals.translateX,
              translateY: w.globals.translateY
            }));
          } else {
            if (w.config.chart.selection.xaxis.min !== undefined && w.config.chart.selection.xaxis.max !== undefined) {
              var x = (w.config.chart.selection.xaxis.min - w.globals.minX) / xyRatios.xRatio;
              var width = w.globals.gridWidth - (w.globals.maxX - w.config.chart.selection.xaxis.max) / xyRatios.xRatio - x;
              if (w.globals.isRangeBar) {
                // rangebars put datetime data in y axis
                x = (w.config.chart.selection.xaxis.min - w.globals.yAxisScale[0].niceMin) / xyRatios.invertedYRatio;
                width = (w.config.chart.selection.xaxis.max - w.config.chart.selection.xaxis.min) / xyRatios.invertedYRatio;
              }
              var selectionRect = {
                x: x,
                y: 0,
                width: width,
                height: w.globals.gridHeight,
                translateX: w.globals.translateX,
                translateY: w.globals.translateY,
                selectionEnabled: true
              };
              this.drawSelectionRect(selectionRect);
              this.makeSelectionRectDraggable();
              if (typeof w.config.chart.events.selection === 'function') {
                w.config.chart.events.selection(this.ctx, {
                  xaxis: {
                    min: w.config.chart.selection.xaxis.min,
                    max: w.config.chart.selection.xaxis.max
                  },
                  yaxis: {}
                });
              }
            }
          }
        }
      }
    }, {
      key: "drawSelectionRect",
      value: function drawSelectionRect(_ref3) {
        var x = _ref3.x,
          y = _ref3.y,
          width = _ref3.width,
          height = _ref3.height,
          _ref3$translateX = _ref3.translateX,
          translateX = _ref3$translateX === void 0 ? 0 : _ref3$translateX,
          _ref3$translateY = _ref3.translateY,
          translateY = _ref3$translateY === void 0 ? 0 : _ref3$translateY;
        var w = this.w;
        var zoomRect = this.zoomRect;
        var selectionRect = this.selectionRect;
        if (this.dragged || w.globals.selection !== null) {
          var scalingAttrs = {
            transform: 'translate(' + translateX + ', ' + translateY + ')'
          };

          // change styles based on zoom or selection
          // zoom is Enabled and user has dragged, so draw blue rect
          if (w.globals.zoomEnabled && this.dragged) {
            if (width < 0) width = 1; // fixes apexcharts.js#1168
            zoomRect.attr({
              x: x,
              y: y,
              width: width,
              height: height,
              fill: w.config.chart.zoom.zoomedArea.fill.color,
              'fill-opacity': w.config.chart.zoom.zoomedArea.fill.opacity,
              stroke: w.config.chart.zoom.zoomedArea.stroke.color,
              'stroke-width': w.config.chart.zoom.zoomedArea.stroke.width,
              'stroke-opacity': w.config.chart.zoom.zoomedArea.stroke.opacity
            });
            Graphics.setAttrs(zoomRect.node, scalingAttrs);
          }

          // selection is enabled
          if (w.globals.selectionEnabled) {
            selectionRect.attr({
              x: x,
              y: y,
              width: width > 0 ? width : 0,
              height: height > 0 ? height : 0,
              fill: w.config.chart.selection.fill.color,
              'fill-opacity': w.config.chart.selection.fill.opacity,
              stroke: w.config.chart.selection.stroke.color,
              'stroke-width': w.config.chart.selection.stroke.width,
              'stroke-dasharray': w.config.chart.selection.stroke.dashArray,
              'stroke-opacity': w.config.chart.selection.stroke.opacity
            });
            Graphics.setAttrs(selectionRect.node, scalingAttrs);
          }
        }
      }
    }, {
      key: "hideSelectionRect",
      value: function hideSelectionRect(rect) {
        if (rect) {
          rect.attr({
            x: 0,
            y: 0,
            width: 0,
            height: 0
          });
        }
      }
    }, {
      key: "selectionDrawing",
      value: function selectionDrawing(_ref4) {
        var context = _ref4.context,
          zoomtype = _ref4.zoomtype;
        var w = this.w;
        var me = context;
        var gridRectDim = this.gridRect.getBoundingClientRect();
        var startX = me.startX - 1;
        var startY = me.startY;
        var inversedX = false;
        var inversedY = false;
        var left = me.clientX - gridRectDim.left - w.globals.barPadForNumericAxis;
        var top = me.clientY - gridRectDim.top;
        var selectionWidth = left - startX;
        var selectionHeight = top - startY;
        var selectionRect = {
          translateX: w.globals.translateX,
          translateY: w.globals.translateY
        };
        if (Math.abs(selectionWidth + startX) > w.globals.gridWidth) {
          // user dragged the mouse outside drawing area to the right
          selectionWidth = w.globals.gridWidth - startX;
        } else if (left < 0) {
          // user dragged the mouse outside drawing area to the left
          selectionWidth = startX;
        }

        // inverse selection X
        if (startX > left) {
          inversedX = true;
          selectionWidth = Math.abs(selectionWidth);
        }

        // inverse selection Y
        if (startY > top) {
          inversedY = true;
          selectionHeight = Math.abs(selectionHeight);
        }
        if (zoomtype === 'x') {
          selectionRect = {
            x: inversedX ? startX - selectionWidth : startX,
            y: 0,
            width: selectionWidth,
            height: w.globals.gridHeight
          };
        } else if (zoomtype === 'y') {
          selectionRect = {
            x: 0,
            y: inversedY ? startY - selectionHeight : startY,
            width: w.globals.gridWidth,
            height: selectionHeight
          };
        } else {
          selectionRect = {
            x: inversedX ? startX - selectionWidth : startX,
            y: inversedY ? startY - selectionHeight : startY,
            width: selectionWidth,
            height: selectionHeight
          };
        }
        selectionRect = _objectSpread2(_objectSpread2({}, selectionRect), {}, {
          translateX: w.globals.translateX,
          translateY: w.globals.translateY
        });
        me.drawSelectionRect(selectionRect);
        me.selectionDragging('resizing');
        return selectionRect;
      }
    }, {
      key: "selectionDragging",
      value: function selectionDragging(type, e) {
        var _this5 = this;
        var w = this.w;
        if (!e) return;
        e.preventDefault();
        var _e$detail = e.detail,
          handler = _e$detail.handler,
          box = _e$detail.box;
        var x = box.x,
          y = box.y;
        if (x < this.constraints.x) {
          x = this.constraints.x;
        }
        if (y < this.constraints.y) {
          y = this.constraints.y;
        }
        if (box.x2 > this.constraints.x2) {
          x = this.constraints.x2 - box.w;
        }
        if (box.y2 > this.constraints.y2) {
          y = this.constraints.y2 - box.h;
        }
        handler.move(x, y);
        var xyRatios = this.xyRatios;
        var selRect = this.selectionRect;
        var timerInterval = 0;
        if (type === 'resizing') {
          timerInterval = 30;
        }

        // update selection when selection rect is dragged
        var getSelAttr = function getSelAttr(attr) {
          return parseFloat(selRect.node.getAttribute(attr));
        };
        var draggedProps = {
          x: getSelAttr('x'),
          y: getSelAttr('y'),
          width: getSelAttr('width'),
          height: getSelAttr('height')
        };
        w.globals.selection = draggedProps;
        // update selection ends

        if (typeof w.config.chart.events.selection === 'function' && w.globals.selectionEnabled) {
          // a small debouncer is required when resizing to avoid freezing the chart
          clearTimeout(this.w.globals.selectionResizeTimer);
          this.w.globals.selectionResizeTimer = window.setTimeout(function () {
            var gridRectDim = _this5.gridRect.getBoundingClientRect();
            var selectionRect = selRect.node.getBoundingClientRect();
            var minX, maxX, minY, maxY;
            if (!w.globals.isRangeBar) {
              // normal XY charts
              minX = w.globals.xAxisScale.niceMin + (selectionRect.left - gridRectDim.left) * xyRatios.xRatio;
              maxX = w.globals.xAxisScale.niceMin + (selectionRect.right - gridRectDim.left) * xyRatios.xRatio;
              minY = w.globals.yAxisScale[0].niceMin + (gridRectDim.bottom - selectionRect.bottom) * xyRatios.yRatio[0];
              maxY = w.globals.yAxisScale[0].niceMax - (selectionRect.top - gridRectDim.top) * xyRatios.yRatio[0];
            } else {
              // rangeBars use y for datetime
              minX = w.globals.yAxisScale[0].niceMin + (selectionRect.left - gridRectDim.left) * xyRatios.invertedYRatio;
              maxX = w.globals.yAxisScale[0].niceMin + (selectionRect.right - gridRectDim.left) * xyRatios.invertedYRatio;
              minY = 0;
              maxY = 1;
            }
            var xyAxis = {
              xaxis: {
                min: minX,
                max: maxX
              },
              yaxis: {
                min: minY,
                max: maxY
              }
            };
            w.config.chart.events.selection(_this5.ctx, xyAxis);
            if (w.config.chart.brush.enabled && w.config.chart.events.brushScrolled !== undefined) {
              w.config.chart.events.brushScrolled(_this5.ctx, xyAxis);
            }
          }, timerInterval);
        }
      }
    }, {
      key: "selectionDrawn",
      value: function selectionDrawn(_ref5) {
        var context = _ref5.context,
          zoomtype = _ref5.zoomtype;
        var w = this.w;
        var me = context;
        var xyRatios = this.xyRatios;
        var toolbar = this.ctx.toolbar;

        // Use boundingRect for final selection area
        var selRect = w.globals.zoomEnabled ? me.zoomRect.node.getBoundingClientRect() : me.selectionRect.node.getBoundingClientRect();
        var gridRectDim = me.gridRect.getBoundingClientRect();

        // Local coords in the chart's grid
        var localStartX = selRect.left - gridRectDim.left - w.globals.barPadForNumericAxis;
        var localEndX = selRect.right - gridRectDim.left - w.globals.barPadForNumericAxis;
        var localStartY = selRect.top - gridRectDim.top;
        var localEndY = selRect.bottom - gridRectDim.top;

        // Convert those local coords to actual data values
        var xLowestValue, xHighestValue;
        if (!w.globals.isRangeBar) {
          xLowestValue = w.globals.xAxisScale.niceMin + localStartX * xyRatios.xRatio;
          xHighestValue = w.globals.xAxisScale.niceMin + localEndX * xyRatios.xRatio;
        } else {
          xLowestValue = w.globals.yAxisScale[0].niceMin + localStartX * xyRatios.invertedYRatio;
          xHighestValue = w.globals.yAxisScale[0].niceMin + localEndX * xyRatios.invertedYRatio;
        }

        // For Y values, pick from the first y-axis, but handle multi-axis
        var yHighestValue = [];
        var yLowestValue = [];
        w.config.yaxis.forEach(function (yaxe, index) {
          // pick whichever series is mapped to this y-axis
          var seriesIndex = w.globals.seriesYAxisMap[index][0];
          var highestVal = w.globals.yAxisScale[index].niceMax - xyRatios.yRatio[seriesIndex] * localStartY;
          var lowestVal = w.globals.yAxisScale[index].niceMax - xyRatios.yRatio[seriesIndex] * localEndY;
          yHighestValue.push(highestVal);
          yLowestValue.push(lowestVal);
        });

        // Only apply if user actually dragged far enough to consider it a selection
        if (me.dragged && (me.dragX > 10 || me.dragY > 10) && xLowestValue !== xHighestValue) {
          if (w.globals.zoomEnabled) {
            var yaxis = Utils$1.clone(w.globals.initialConfig.yaxis);
            var xaxis = Utils$1.clone(w.globals.initialConfig.xaxis);
            w.globals.zoomed = true;
            if (w.config.xaxis.convertedCatToNumeric) {
              xLowestValue = Math.floor(xLowestValue);
              xHighestValue = Math.floor(xHighestValue);
              if (xLowestValue < 1) {
                xLowestValue = 1;
                xHighestValue = w.globals.dataPoints;
              }
              if (xHighestValue - xLowestValue < 2) {
                xHighestValue = xLowestValue + 1;
              }
            }
            if (zoomtype === 'xy' || zoomtype === 'x') {
              xaxis = {
                min: xLowestValue,
                max: xHighestValue
              };
            }
            if (zoomtype === 'xy' || zoomtype === 'y') {
              yaxis.forEach(function (yaxe, index) {
                yaxis[index].min = yLowestValue[index];
                yaxis[index].max = yHighestValue[index];
              });
            }
            if (toolbar) {
              var beforeZoomRange = toolbar.getBeforeZoomRange(xaxis, yaxis);
              if (beforeZoomRange) {
                xaxis = beforeZoomRange.xaxis ? beforeZoomRange.xaxis : xaxis;
                yaxis = beforeZoomRange.yaxis ? beforeZoomRange.yaxis : yaxis;
              }
            }
            var options = {
              xaxis: xaxis
            };
            if (!w.config.chart.group) {
              // if chart in a group, prevent yaxis update here
              // fix issue #650
              options.yaxis = yaxis;
            }
            me.ctx.updateHelpers._updateOptions(options, false, me.w.config.chart.animations.dynamicAnimation.enabled);
            if (typeof w.config.chart.events.zoomed === 'function') {
              toolbar.zoomCallback(xaxis, yaxis);
            }
          } else if (w.globals.selectionEnabled) {
            var _yaxis = null;
            var _xaxis = null;
            _xaxis = {
              min: xLowestValue,
              max: xHighestValue
            };
            if (zoomtype === 'xy' || zoomtype === 'y') {
              _yaxis = Utils$1.clone(w.config.yaxis);
              _yaxis.forEach(function (yaxe, index) {
                _yaxis[index].min = yLowestValue[index];
                _yaxis[index].max = yHighestValue[index];
              });
            }
            w.globals.selection = me.selection;
            if (typeof w.config.chart.events.selection === 'function') {
              w.config.chart.events.selection(me.ctx, {
                xaxis: _xaxis,
                yaxis: _yaxis
              });
            }
          }
        }
      }
    }, {
      key: "panDragging",
      value: function panDragging(_ref6) {
        var context = _ref6.context;
        var w = this.w;
        var me = context;

        // check to make sure there is data to compare against
        if (typeof w.globals.lastClientPosition.x !== 'undefined') {
          // get the change from last position to this position
          var deltaX = w.globals.lastClientPosition.x - me.clientX;
          var deltaY = w.globals.lastClientPosition.y - me.clientY;

          // check which direction had the highest amplitude
          if (Math.abs(deltaX) > Math.abs(deltaY) && deltaX > 0) {
            this.moveDirection = 'left';
          } else if (Math.abs(deltaX) > Math.abs(deltaY) && deltaX < 0) {
            this.moveDirection = 'right';
          } else if (Math.abs(deltaY) > Math.abs(deltaX) && deltaY > 0) {
            this.moveDirection = 'up';
          } else if (Math.abs(deltaY) > Math.abs(deltaX) && deltaY < 0) {
            this.moveDirection = 'down';
          }
        }

        // set the new last position to the current for next time (to get the position of drag)
        w.globals.lastClientPosition = {
          x: me.clientX,
          y: me.clientY
        };
        var xLowestValue = w.globals.isRangeBar ? w.globals.minY : w.globals.minX;
        var xHighestValue = w.globals.isRangeBar ? w.globals.maxY : w.globals.maxX;

        // removed delayedPanScrolled as it doesn't seem to cause bugs anymore in convertedCatToNumeric
        // if (!w.config.xaxis.convertedCatToNumeric) {
        me.panScrolled(xLowestValue, xHighestValue);
        // }
      }

      // delayedPanScrolled() {
      //   const w = this.w

      //   let newMinX = w.globals.minX
      //   let newMaxX = w.globals.maxX
      //   const centerX = (w.globals.maxX - w.globals.minX) / 2

      //   if (this.moveDirection === 'left') {
      //     newMinX = w.globals.minX + centerX
      //     newMaxX = w.globals.maxX + centerX
      //   } else if (this.moveDirection === 'right') {
      //     newMinX = w.globals.minX - centerX
      //     newMaxX = w.globals.maxX - centerX
      //   }

      //   newMinX = Math.floor(newMinX)
      //   newMaxX = Math.floor(newMaxX)
      //   this.updateScrolledChart(
      //     { xaxis: { min: newMinX, max: newMaxX } },
      //     newMinX,
      //     newMaxX
      //   )
      // }
    }, {
      key: "panScrolled",
      value: function panScrolled(xLowestValue, xHighestValue) {
        var w = this.w;
        var xyRatios = this.xyRatios;
        var yaxis = Utils$1.clone(w.globals.initialConfig.yaxis);
        var xRatio = xyRatios.xRatio;
        var minX = w.globals.minX;
        var maxX = w.globals.maxX;
        if (w.globals.isRangeBar) {
          xRatio = xyRatios.invertedYRatio;
          minX = w.globals.minY;
          maxX = w.globals.maxY;
        }
        if (this.moveDirection === 'left') {
          xLowestValue = minX + w.globals.gridWidth / 15 * xRatio;
          xHighestValue = maxX + w.globals.gridWidth / 15 * xRatio;
        } else if (this.moveDirection === 'right') {
          xLowestValue = minX - w.globals.gridWidth / 15 * xRatio;
          xHighestValue = maxX - w.globals.gridWidth / 15 * xRatio;
        }
        if (!w.globals.isRangeBar) {
          if (xLowestValue < w.globals.initialMinX || xHighestValue > w.globals.initialMaxX) {
            xLowestValue = minX;
            xHighestValue = maxX;
          }
        }
        var xaxis = {
          min: xLowestValue,
          max: xHighestValue
        };
        var options = {
          xaxis: xaxis
        };
        if (!w.config.chart.group) {
          // if chart in a group, prevent yaxis update here
          // fix issue #650
          options.yaxis = yaxis;
        }
        this.updateScrolledChart(options, xLowestValue, xHighestValue);
      }
    }, {
      key: "updateScrolledChart",
      value: function updateScrolledChart(options, xLowestValue, xHighestValue) {
        var w = this.w;
        this.ctx.updateHelpers._updateOptions(options, false, false);
        if (typeof w.config.chart.events.scrolled === 'function') {
          var args = {
            xaxis: {
              min: xLowestValue,
              max: xHighestValue
            }
          };
          w.config.chart.events.scrolled(this.ctx, args);
          this.ctx.events.fireEvent('scrolled', args);
        }
      }
    }]);
    return ZoomPanSelection;
  }(Toolbar);

  /**
   * ApexCharts Tooltip.Utils Class to support Tooltip functionality.
   *
   * @module Tooltip.Utils
   **/
  var Utils = /*#__PURE__*/function () {
    function Utils(tooltipContext) {
      _classCallCheck(this, Utils);
      this.w = tooltipContext.w;
      this.ttCtx = tooltipContext;
      this.ctx = tooltipContext.ctx;
    }

    /**
     ** When hovering over series, you need to capture which series is being hovered on.
     ** This function will return both capturedseries index as well as inner index of that series
     * @memberof Utils
     * @param {object}
     * - hoverArea = the rect on which user hovers
     * - elGrid = dimensions of the hover rect (it can be different than hoverarea)
     */
    _createClass(Utils, [{
      key: "getNearestValues",
      value: function getNearestValues(_ref) {
        var hoverArea = _ref.hoverArea,
          elGrid = _ref.elGrid,
          clientX = _ref.clientX,
          clientY = _ref.clientY;
        var w = this.w;
        var seriesBound = elGrid.getBoundingClientRect();
        var hoverWidth = seriesBound.width;
        var hoverHeight = seriesBound.height;
        var xDivisor = hoverWidth / (w.globals.dataPoints - 1);
        var yDivisor = hoverHeight / w.globals.dataPoints;
        var hasBars = this.hasBars();
        if ((w.globals.comboCharts || hasBars) && !w.config.xaxis.convertedCatToNumeric) {
          xDivisor = hoverWidth / w.globals.dataPoints;
        }
        var hoverX = clientX - seriesBound.left - w.globals.barPadForNumericAxis;
        var hoverY = clientY - seriesBound.top;
        var notInRect = hoverX < 0 || hoverY < 0 || hoverX > hoverWidth || hoverY > hoverHeight;
        if (notInRect) {
          hoverArea.classList.remove('hovering-zoom');
          hoverArea.classList.remove('hovering-pan');
        } else {
          if (w.globals.zoomEnabled) {
            hoverArea.classList.remove('hovering-pan');
            hoverArea.classList.add('hovering-zoom');
          } else if (w.globals.panEnabled) {
            hoverArea.classList.remove('hovering-zoom');
            hoverArea.classList.add('hovering-pan');
          }
        }
        var j = Math.round(hoverX / xDivisor);
        var jHorz = Math.floor(hoverY / yDivisor);
        if (hasBars && !w.config.xaxis.convertedCatToNumeric) {
          j = Math.ceil(hoverX / xDivisor);
          j = j - 1;
        }
        var capturedSeries = null;
        var closest = null;
        var seriesXValArr = w.globals.seriesXvalues.map(function (seriesXVal) {
          return seriesXVal.filter(function (s) {
            return Utils$1.isNumber(s);
          });
        });
        var seriesYValArr = w.globals.seriesYvalues.map(function (seriesYVal) {
          return seriesYVal.filter(function (s) {
            return Utils$1.isNumber(s);
          });
        });

        // if X axis type is not category and tooltip is not shared, then we need to find the cursor position and get the nearest value
        if (w.globals.isXNumeric) {
          // Change origin of cursor position so that we can compute the relative nearest point to the cursor on our chart
          // we only need to scale because all points are relative to the bounds.left and bounds.top => origin is virtually (0, 0)
          var chartGridEl = this.ttCtx.getElGrid();
          var chartGridElBoundingRect = chartGridEl.getBoundingClientRect();
          var transformedHoverX = hoverX * (chartGridElBoundingRect.width / hoverWidth);
          var transformedHoverY = hoverY * (chartGridElBoundingRect.height / hoverHeight);
          closest = this.closestInMultiArray(transformedHoverX, transformedHoverY, seriesXValArr, seriesYValArr);
          capturedSeries = closest.index;
          j = closest.j;
          if (capturedSeries !== null && w.globals.hasNullValues) {
            // initial push, it should be a little smaller than the 1st val
            seriesXValArr = w.globals.seriesXvalues[capturedSeries];
            closest = this.closestInArray(transformedHoverX, seriesXValArr);
            j = closest.j;
          }
        }
        w.globals.capturedSeriesIndex = capturedSeries === null ? -1 : capturedSeries;
        if (!j || j < 1) j = 0;
        if (w.globals.isBarHorizontal) {
          w.globals.capturedDataPointIndex = jHorz;
        } else {
          w.globals.capturedDataPointIndex = j;
        }
        return {
          capturedSeries: capturedSeries,
          j: w.globals.isBarHorizontal ? jHorz : j,
          hoverX: hoverX,
          hoverY: hoverY
        };
      }
    }, {
      key: "getFirstActiveXArray",
      value: function getFirstActiveXArray(Xarrays) {
        var w = this.w;
        var activeIndex = 0;
        var firstActiveSeriesIndex = Xarrays.map(function (xarr, index) {
          return xarr.length > 0 ? index : -1;
        });
        for (var a = 0; a < firstActiveSeriesIndex.length; a++) {
          if (firstActiveSeriesIndex[a] !== -1 && w.globals.collapsedSeriesIndices.indexOf(a) === -1 && w.globals.ancillaryCollapsedSeriesIndices.indexOf(a) === -1) {
            activeIndex = firstActiveSeriesIndex[a];
            break;
          }
        }
        return activeIndex;
      }
    }, {
      key: "closestInMultiArray",
      value: function closestInMultiArray(hoverX, hoverY, Xarrays, Yarrays) {
        var w = this.w;

        // Determine which series are active (not collapsed)
        var isActiveSeries = function isActiveSeries(seriesIndex) {
          return w.globals.collapsedSeriesIndices.indexOf(seriesIndex) === -1 && w.globals.ancillaryCollapsedSeriesIndices.indexOf(seriesIndex) === -1;
        };
        var closestDist = Infinity;
        var closestSeriesIndex = null;
        var closestPointIndex = null;

        // Iterate through all series and points to find the closest (x,y) to (hoverX, hoverY)
        for (var i = 0; i < Xarrays.length; i++) {
          if (!isActiveSeries(i)) {
            continue;
          }
          var xArr = Xarrays[i];
          var yArr = Yarrays[i];
          var len = Math.min(xArr.length, yArr.length);
          for (var j = 0; j < len; j++) {
            var xVal = xArr[j];
            var distX = hoverX - xVal;
            var dist = Math.sqrt(distX * distX);
            if (!w.globals.allSeriesHasEqualX) {
              var yVal = yArr[j];
              var distY = hoverY - yVal;
              dist = Math.sqrt(distX * distX + distY * distY);
            }
            if (dist < closestDist) {
              closestDist = dist;
              closestSeriesIndex = i;
              closestPointIndex = j;
            }
          }
        }
        return {
          index: closestSeriesIndex,
          j: closestPointIndex
        };
      }
    }, {
      key: "closestInArray",
      value: function closestInArray(val, arr) {
        var curr = arr[0];
        var currIndex = null;
        var diff = Math.abs(val - curr);
        for (var i = 0; i < arr.length; i++) {
          var newdiff = Math.abs(val - arr[i]);
          if (newdiff < diff) {
            diff = newdiff;
            currIndex = i;
          }
        }
        return {
          j: currIndex
        };
      }

      /**
       * When there are multiple series, it is possible to have different x values for each series.
       * But it may be possible in those multiple series, that there is same x value for 2 or more
       * series.
       * @memberof Utils
       * @param {int}
       * - j = is the inner index of series -> (series[i][j])
       * @return {bool}
       */
    }, {
      key: "isXoverlap",
      value: function isXoverlap(j) {
        var w = this.w;
        var xSameForAllSeriesJArr = [];
        var seriesX = w.globals.seriesX.filter(function (s) {
          return typeof s[0] !== 'undefined';
        });
        if (seriesX.length > 0) {
          for (var i = 0; i < seriesX.length - 1; i++) {
            if (typeof seriesX[i][j] !== 'undefined' && typeof seriesX[i + 1][j] !== 'undefined') {
              if (seriesX[i][j] !== seriesX[i + 1][j]) {
                xSameForAllSeriesJArr.push('unEqual');
              }
            }
          }
        }
        if (xSameForAllSeriesJArr.length === 0) {
          return true;
        }
        return false;
      }
    }, {
      key: "isInitialSeriesSameLen",
      value: function isInitialSeriesSameLen() {
        var sameLen = true;
        var initialSeries = this.w.globals.initialSeries;
        for (var i = 0; i < initialSeries.length - 1; i++) {
          if (initialSeries[i].data.length !== initialSeries[i + 1].data.length) {
            sameLen = false;
            break;
          }
        }
        return sameLen;
      }
    }, {
      key: "getBarsHeight",
      value: function getBarsHeight(allbars) {
        var bars = _toConsumableArray(allbars);
        var totalHeight = bars.reduce(function (acc, bar) {
          return acc + bar.getBBox().height;
        }, 0);
        return totalHeight;
      }
    }, {
      key: "getElMarkers",
      value: function getElMarkers(capturedSeries) {
        // The selector .apexcharts-series-markers-wrap > * includes marker groups for which the
        // .apexcharts-series-markers class is not added due to null values or discrete markers
        if (typeof capturedSeries == 'number') {
          return this.w.globals.dom.baseEl.querySelectorAll(".apexcharts-series[data\\:realIndex='".concat(capturedSeries, "'] .apexcharts-series-markers-wrap > *"));
        }
        return this.w.globals.dom.baseEl.querySelectorAll('.apexcharts-series-markers-wrap > *');
      }
    }, {
      key: "getAllMarkers",
      value: function getAllMarkers() {
        var _this = this;
        var filterCollapsed = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
        // first get all marker parents. This parent class contains series-index
        // which helps to sort the markers as they are dynamic
        var markersWraps = this.w.globals.dom.baseEl.querySelectorAll('.apexcharts-series-markers-wrap');
        markersWraps = _toConsumableArray(markersWraps);
        if (filterCollapsed) {
          markersWraps = markersWraps.filter(function (m) {
            var realIndex = Number(m.getAttribute('data:realIndex'));
            return _this.w.globals.collapsedSeriesIndices.indexOf(realIndex) === -1;
          });
        }
        markersWraps.sort(function (a, b) {
          var indexA = Number(a.getAttribute('data:realIndex'));
          var indexB = Number(b.getAttribute('data:realIndex'));
          return indexB < indexA ? 1 : indexB > indexA ? -1 : 0;
        });
        var markers = [];
        markersWraps.forEach(function (m) {
          markers.push(m.querySelector('.apexcharts-marker'));
        });
        return markers;
      }
    }, {
      key: "hasMarkers",
      value: function hasMarkers(capturedSeries) {
        var markers = this.getElMarkers(capturedSeries);
        return markers.length > 0;
      }
    }, {
      key: "getPathFromPoint",
      value: function getPathFromPoint(point, size) {
        var cx = Number(point.getAttribute('cx'));
        var cy = Number(point.getAttribute('cy'));
        var shape = point.getAttribute('shape');
        return new Graphics(this.ctx).getMarkerPath(cx, cy, shape, size);
      }
    }, {
      key: "getElBars",
      value: function getElBars() {
        return this.w.globals.dom.baseEl.querySelectorAll('.apexcharts-bar-series,  .apexcharts-candlestick-series, .apexcharts-boxPlot-series, .apexcharts-rangebar-series');
      }
    }, {
      key: "hasBars",
      value: function hasBars() {
        var bars = this.getElBars();
        return bars.length > 0;
      }
    }, {
      key: "getHoverMarkerSize",
      value: function getHoverMarkerSize(index) {
        var w = this.w;
        var hoverSize = w.config.markers.hover.size;
        if (hoverSize === undefined) {
          hoverSize = w.globals.markers.size[index] + w.config.markers.hover.sizeOffset;
        }
        return hoverSize;
      }
    }, {
      key: "toggleAllTooltipSeriesGroups",
      value: function toggleAllTooltipSeriesGroups(state) {
        var w = this.w;
        var ttCtx = this.ttCtx;
        if (ttCtx.allTooltipSeriesGroups.length === 0) {
          ttCtx.allTooltipSeriesGroups = w.globals.dom.baseEl.querySelectorAll('.apexcharts-tooltip-series-group');
        }
        var allTooltipSeriesGroups = ttCtx.allTooltipSeriesGroups;
        for (var i = 0; i < allTooltipSeriesGroups.length; i++) {
          if (state === 'enable') {
            allTooltipSeriesGroups[i].classList.add('apexcharts-active');
            allTooltipSeriesGroups[i].style.display = w.config.tooltip.items.display;
          } else {
            allTooltipSeriesGroups[i].classList.remove('apexcharts-active');
            allTooltipSeriesGroups[i].style.display = 'none';
          }
        }
      }
    }]);
    return Utils;
  }();

  /**
   * ApexCharts Tooltip.Labels Class to draw texts on the tooltip.
   * This file deals with printing actual text on the tooltip.
   *
   * @module Tooltip.Labels
   **/
  var Labels = /*#__PURE__*/function () {
    function Labels(tooltipContext) {
      _classCallCheck(this, Labels);
      this.w = tooltipContext.w;
      this.ctx = tooltipContext.ctx;
      this.ttCtx = tooltipContext;
      this.tooltipUtil = new Utils(tooltipContext);
    }
    _createClass(Labels, [{
      key: "drawSeriesTexts",
      value: function drawSeriesTexts(_ref) {
        var _ref$shared = _ref.shared,
          shared = _ref$shared === void 0 ? true : _ref$shared,
          ttItems = _ref.ttItems,
          _ref$i = _ref.i,
          i = _ref$i === void 0 ? 0 : _ref$i,
          _ref$j = _ref.j,
          j = _ref$j === void 0 ? null : _ref$j,
          y1 = _ref.y1,
          y2 = _ref.y2,
          e = _ref.e;
        var w = this.w;
        if (w.config.tooltip.custom !== undefined) {
          this.handleCustomTooltip({
            i: i,
            j: j,
            y1: y1,
            y2: y2,
            w: w
          });
        } else {
          this.toggleActiveInactiveSeries(shared, i);
        }
        var values = this.getValuesToPrint({
          i: i,
          j: j
        });
        this.printLabels({
          i: i,
          j: j,
          values: values,
          ttItems: ttItems,
          shared: shared,
          e: e
        });

        // Re-calculate tooltip dimensions now that we have drawn the text
        var tooltipEl = this.ttCtx.getElTooltip();
        this.ttCtx.tooltipRect.ttWidth = tooltipEl.getBoundingClientRect().width;
        this.ttCtx.tooltipRect.ttHeight = tooltipEl.getBoundingClientRect().height;
      }
    }, {
      key: "printLabels",
      value: function printLabels(_ref2) {
        var _this = this;
        var i = _ref2.i,
          j = _ref2.j,
          values = _ref2.values,
          ttItems = _ref2.ttItems,
          shared = _ref2.shared,
          e = _ref2.e;
        var w = this.w;
        var val;
        var goalVals = [];
        var hasGoalValues = function hasGoalValues(gi) {
          return w.globals.seriesGoals[gi] && w.globals.seriesGoals[gi][j] && Array.isArray(w.globals.seriesGoals[gi][j]);
        };
        var xVal = values.xVal,
          zVal = values.zVal,
          xAxisTTVal = values.xAxisTTVal;
        var seriesName = '';
        var pColor = w.globals.colors[i]; // The pColor here is for the markers inside tooltip
        if (j !== null && w.config.plotOptions.bar.distributed) {
          pColor = w.globals.colors[j];
        }
        var _loop = function _loop(t, inverset) {
          var f = _this.getFormatters(i);
          seriesName = _this.getSeriesName({
            fn: f.yLbTitleFormatter,
            index: i,
            seriesIndex: i,
            j: j
          });
          if (w.config.chart.type === 'treemap') {
            seriesName = f.yLbTitleFormatter(String(w.config.series[i].data[j].x), {
              series: w.globals.series,
              seriesIndex: i,
              dataPointIndex: j,
              w: w
            });
          }
          var tIndex = w.config.tooltip.inverseOrder ? inverset : t;
          if (w.globals.axisCharts) {
            var getValBySeriesIndex = function getValBySeriesIndex(index) {
              if (w.globals.isRangeData) {
                var _w$globals$seriesRang, _w$globals$seriesRang2, _w$globals$seriesRang3, _w$globals$seriesRang4;
                return f.yLbFormatter((_w$globals$seriesRang = w.globals.seriesRangeStart) === null || _w$globals$seriesRang === void 0 ? void 0 : (_w$globals$seriesRang2 = _w$globals$seriesRang[index]) === null || _w$globals$seriesRang2 === void 0 ? void 0 : _w$globals$seriesRang2[j], {
                  series: w.globals.seriesRangeStart,
                  seriesIndex: index,
                  dataPointIndex: j,
                  w: w
                }) + ' - ' + f.yLbFormatter((_w$globals$seriesRang3 = w.globals.seriesRangeEnd) === null || _w$globals$seriesRang3 === void 0 ? void 0 : (_w$globals$seriesRang4 = _w$globals$seriesRang3[index]) === null || _w$globals$seriesRang4 === void 0 ? void 0 : _w$globals$seriesRang4[j], {
                  series: w.globals.seriesRangeEnd,
                  seriesIndex: index,
                  dataPointIndex: j,
                  w: w
                });
              }
              return f.yLbFormatter(w.globals.series[index][j], {
                series: w.globals.series,
                seriesIndex: index,
                dataPointIndex: j,
                w: w
              });
            };
            if (shared) {
              f = _this.getFormatters(tIndex);
              seriesName = _this.getSeriesName({
                fn: f.yLbTitleFormatter,
                index: tIndex,
                seriesIndex: i,
                j: j
              });
              pColor = w.globals.colors[tIndex];
              val = getValBySeriesIndex(tIndex);
              if (hasGoalValues(tIndex)) {
                goalVals = w.globals.seriesGoals[tIndex][j].map(function (goal) {
                  return {
                    attrs: goal,
                    val: f.yLbFormatter(goal.value, {
                      seriesIndex: tIndex,
                      dataPointIndex: j,
                      w: w
                    })
                  };
                });
              }
            } else {
              var _e$target;
              // get a color from a hover area (if it's a line pattern then get from a first line)
              var targetFill = e === null || e === void 0 ? void 0 : (_e$target = e.target) === null || _e$target === void 0 ? void 0 : _e$target.getAttribute('fill');
              if (targetFill) {
                if (targetFill.indexOf('url') !== -1) {
                  // pattern fill
                  if (targetFill.indexOf('Pattern') !== -1) {
                    pColor = w.globals.dom.baseEl.querySelector(targetFill.substr(4).slice(0, -1)).childNodes[0].getAttribute('stroke');
                  }
                } else {
                  pColor = targetFill;
                }
              }
              val = getValBySeriesIndex(i);
              if (hasGoalValues(i) && Array.isArray(w.globals.seriesGoals[i][j])) {
                goalVals = w.globals.seriesGoals[i][j].map(function (goal) {
                  return {
                    attrs: goal,
                    val: f.yLbFormatter(goal.value, {
                      seriesIndex: i,
                      dataPointIndex: j,
                      w: w
                    })
                  };
                });
              }
            }
          }

          // for pie / donuts
          if (j === null) {
            val = f.yLbFormatter(w.globals.series[i], _objectSpread2(_objectSpread2({}, w), {}, {
              seriesIndex: i,
              dataPointIndex: i
            }));
          }
          _this.DOMHandling({
            i: i,
            t: tIndex,
            j: j,
            ttItems: ttItems,
            values: {
              val: val,
              goalVals: goalVals,
              xVal: xVal,
              xAxisTTVal: xAxisTTVal,
              zVal: zVal
            },
            seriesName: seriesName,
            shared: shared,
            pColor: pColor
          });
        };
        for (var t = 0, inverset = w.globals.series.length - 1; t < w.globals.series.length; t++, inverset--) {
          _loop(t, inverset);
        }
      }
    }, {
      key: "getFormatters",
      value: function getFormatters(i) {
        var w = this.w;
        var yLbFormatter = w.globals.yLabelFormatters[i];
        var yLbTitleFormatter;
        if (w.globals.ttVal !== undefined) {
          if (Array.isArray(w.globals.ttVal)) {
            yLbFormatter = w.globals.ttVal[i] && w.globals.ttVal[i].formatter;
            yLbTitleFormatter = w.globals.ttVal[i] && w.globals.ttVal[i].title && w.globals.ttVal[i].title.formatter;
          } else {
            yLbFormatter = w.globals.ttVal.formatter;
            if (typeof w.globals.ttVal.title.formatter === 'function') {
              yLbTitleFormatter = w.globals.ttVal.title.formatter;
            }
          }
        } else {
          yLbTitleFormatter = w.config.tooltip.y.title.formatter;
        }
        if (typeof yLbFormatter !== 'function') {
          if (w.globals.yLabelFormatters[0]) {
            yLbFormatter = w.globals.yLabelFormatters[0];
          } else {
            yLbFormatter = function yLbFormatter(label) {
              return label;
            };
          }
        }
        if (typeof yLbTitleFormatter !== 'function') {
          yLbTitleFormatter = function yLbTitleFormatter(label) {
            // refrence used from line: 966 in Options.js
            return label ? label + ': ' : '';
          };
        }
        return {
          yLbFormatter: yLbFormatter,
          yLbTitleFormatter: yLbTitleFormatter
        };
      }
    }, {
      key: "getSeriesName",
      value: function getSeriesName(_ref3) {
        var fn = _ref3.fn,
          index = _ref3.index,
          seriesIndex = _ref3.seriesIndex,
          j = _ref3.j;
        var w = this.w;
        return fn(String(w.globals.seriesNames[index]), {
          series: w.globals.series,
          seriesIndex: seriesIndex,
          dataPointIndex: j,
          w: w
        });
      }
    }, {
      key: "DOMHandling",
      value: function DOMHandling(_ref4) {
        _ref4.i;
          var t = _ref4.t,
          j = _ref4.j,
          ttItems = _ref4.ttItems,
          values = _ref4.values,
          seriesName = _ref4.seriesName,
          shared = _ref4.shared,
          pColor = _ref4.pColor;
        var w = this.w;
        var ttCtx = this.ttCtx;
        var val = values.val,
          goalVals = values.goalVals,
          xVal = values.xVal,
          xAxisTTVal = values.xAxisTTVal,
          zVal = values.zVal;
        var ttItemsChildren = null;
        ttItemsChildren = ttItems[t].children;
        if (w.config.tooltip.fillSeriesColor) {
          ttItems[t].style.backgroundColor = pColor;
          ttItemsChildren[0].style.display = 'none';
        }
        if (ttCtx.showTooltipTitle) {
          if (ttCtx.tooltipTitle === null) {
            // get it once if null, and store it in class property
            ttCtx.tooltipTitle = w.globals.dom.baseEl.querySelector('.apexcharts-tooltip-title');
          }
          ttCtx.tooltipTitle.innerHTML = xVal;
        }

        // if xaxis tooltip is constructed, we need to replace the innerHTML
        if (ttCtx.isXAxisTooltipEnabled) {
          ttCtx.xaxisTooltipText.innerHTML = xAxisTTVal !== '' ? xAxisTTVal : xVal;
        }
        var ttYLabel = ttItems[t].querySelector('.apexcharts-tooltip-text-y-label');
        if (ttYLabel) {
          ttYLabel.innerHTML = seriesName ? seriesName : '';
        }
        var ttYVal = ttItems[t].querySelector('.apexcharts-tooltip-text-y-value');
        if (ttYVal) {
          ttYVal.innerHTML = typeof val !== 'undefined' ? val : '';
        }
        if (ttItemsChildren[0] && ttItemsChildren[0].classList.contains('apexcharts-tooltip-marker')) {
          if (w.config.tooltip.marker.fillColors && Array.isArray(w.config.tooltip.marker.fillColors)) {
            pColor = w.config.tooltip.marker.fillColors[t];
          }
          if (w.config.tooltip.fillSeriesColor) {
            ttItemsChildren[0].style.backgroundColor = pColor;
          } else {
            ttItemsChildren[0].style.color = pColor;
          }
        }
        if (!w.config.tooltip.marker.show) {
          ttItemsChildren[0].style.display = 'none';
        }
        var ttGLabel = ttItems[t].querySelector('.apexcharts-tooltip-text-goals-label');
        var ttGVal = ttItems[t].querySelector('.apexcharts-tooltip-text-goals-value');
        if (goalVals.length && w.globals.seriesGoals[t]) {
          var createGoalsHtml = function createGoalsHtml() {
            var gLabels = '<div>';
            var gVals = '<div>';
            goalVals.forEach(function (goal, gi) {
              gLabels += " <div style=\"display: flex\"><span class=\"apexcharts-tooltip-marker\" style=\"background-color: ".concat(goal.attrs.strokeColor, "; height: 3px; border-radius: 0; top: 5px;\"></span> ").concat(goal.attrs.name, "</div>");
              gVals += "<div>".concat(goal.val, "</div>");
            });
            ttGLabel.innerHTML = gLabels + "</div>";
            ttGVal.innerHTML = gVals + "</div>";
          };
          if (shared) {
            if (w.globals.seriesGoals[t][j] && Array.isArray(w.globals.seriesGoals[t][j])) {
              createGoalsHtml();
            } else {
              ttGLabel.innerHTML = '';
              ttGVal.innerHTML = '';
            }
          } else {
            createGoalsHtml();
          }
        } else {
          ttGLabel.innerHTML = '';
          ttGVal.innerHTML = '';
        }
        if (zVal !== null) {
          var ttZLabel = ttItems[t].querySelector('.apexcharts-tooltip-text-z-label');
          ttZLabel.innerHTML = w.config.tooltip.z.title;
          var ttZVal = ttItems[t].querySelector('.apexcharts-tooltip-text-z-value');
          ttZVal.innerHTML = typeof zVal !== 'undefined' ? zVal : '';
        }
        if (shared && ttItemsChildren[0]) {
          // hide when no Val or series collapsed
          if (w.config.tooltip.hideEmptySeries) {
            var ttItemMarker = ttItems[t].querySelector('.apexcharts-tooltip-marker');
            var ttItemText = ttItems[t].querySelector('.apexcharts-tooltip-text');
            if (parseFloat(val) == 0) {
              ttItemMarker.style.display = 'none';
              ttItemText.style.display = 'none';
            } else {
              ttItemMarker.style.display = 'block';
              ttItemText.style.display = 'block';
            }
          }
          if (typeof val === 'undefined' || val === null || w.globals.ancillaryCollapsedSeriesIndices.indexOf(t) > -1 || w.globals.collapsedSeriesIndices.indexOf(t) > -1 || Array.isArray(ttCtx.tConfig.enabledOnSeries) && ttCtx.tConfig.enabledOnSeries.indexOf(t) === -1) {
            ttItemsChildren[0].parentNode.style.display = 'none';
          } else {
            ttItemsChildren[0].parentNode.style.display = w.config.tooltip.items.display;
          }
        } else {
          if (Array.isArray(ttCtx.tConfig.enabledOnSeries) && ttCtx.tConfig.enabledOnSeries.indexOf(t) === -1) {
            ttItemsChildren[0].parentNode.style.display = 'none';
          }
        }
      }
    }, {
      key: "toggleActiveInactiveSeries",
      value: function toggleActiveInactiveSeries(shared, i) {
        var w = this.w;
        if (shared) {
          // make all tooltips active
          this.tooltipUtil.toggleAllTooltipSeriesGroups('enable');
        } else {
          // disable all tooltip text groups
          this.tooltipUtil.toggleAllTooltipSeriesGroups('disable');

          // enable the first tooltip text group
          var firstTooltipSeriesGroup = w.globals.dom.baseEl.querySelector(".apexcharts-tooltip-series-group-".concat(i));
          if (firstTooltipSeriesGroup) {
            firstTooltipSeriesGroup.classList.add('apexcharts-active');
            firstTooltipSeriesGroup.style.display = w.config.tooltip.items.display;
          }
        }
      }
    }, {
      key: "getValuesToPrint",
      value: function getValuesToPrint(_ref5) {
        var i = _ref5.i,
          j = _ref5.j;
        var w = this.w;
        var filteredSeriesX = this.ctx.series.filteredSeriesX();
        var xVal = '';
        var xAxisTTVal = '';
        var zVal = null;
        var val = null;
        var customFormatterOpts = {
          series: w.globals.series,
          seriesIndex: i,
          dataPointIndex: j,
          w: w
        };
        var zFormatter = w.globals.ttZFormatter;
        if (j === null) {
          val = w.globals.series[i];
        } else {
          if (w.globals.isXNumeric && w.config.chart.type !== 'treemap') {
            xVal = filteredSeriesX[i][j];
            if (filteredSeriesX[i].length === 0) {
              // a series (possibly the first one) might be collapsed, so get the next active index
              var firstActiveSeriesIndex = this.tooltipUtil.getFirstActiveXArray(filteredSeriesX);
              xVal = filteredSeriesX[firstActiveSeriesIndex][j];
            }
          } else {
            var dataFormat = new Data(this.ctx);
            if (dataFormat.isFormatXY()) {
              xVal = typeof w.config.series[i].data[j] !== 'undefined' ? w.config.series[i].data[j].x : '';
            } else {
              xVal = typeof w.globals.labels[j] !== 'undefined' ? w.globals.labels[j] : '';
            }
          }
        }
        var bufferXVal = xVal;
        if (w.globals.isXNumeric && w.config.xaxis.type === 'datetime') {
          var xFormat = new Formatters(this.ctx);
          xVal = xFormat.xLabelFormat(w.globals.ttKeyFormatter, bufferXVal, bufferXVal, {
            i: undefined,
            dateFormatter: new DateTime(this.ctx).formatDate,
            w: this.w
          });
        } else {
          if (w.globals.isBarHorizontal) {
            xVal = w.globals.yLabelFormatters[0](bufferXVal, customFormatterOpts);
          } else {
            xVal = w.globals.xLabelFormatter(bufferXVal, customFormatterOpts);
          }
        }

        // override default x-axis formatter with tooltip formatter
        if (w.config.tooltip.x.formatter !== undefined) {
          xVal = w.globals.ttKeyFormatter(bufferXVal, customFormatterOpts);
        }
        if (w.globals.seriesZ.length > 0 && w.globals.seriesZ[i].length > 0) {
          zVal = zFormatter(w.globals.seriesZ[i][j], w);
        }
        if (typeof w.config.xaxis.tooltip.formatter === 'function') {
          xAxisTTVal = w.globals.xaxisTooltipFormatter(bufferXVal, customFormatterOpts);
        } else {
          xAxisTTVal = xVal;
        }
        return {
          val: Array.isArray(val) ? val.join(' ') : val,
          xVal: Array.isArray(xVal) ? xVal.join(' ') : xVal,
          xAxisTTVal: Array.isArray(xAxisTTVal) ? xAxisTTVal.join(' ') : xAxisTTVal,
          zVal: zVal
        };
      }
    }, {
      key: "handleCustomTooltip",
      value: function handleCustomTooltip(_ref6) {
        var i = _ref6.i,
          j = _ref6.j,
          y1 = _ref6.y1,
          y2 = _ref6.y2,
          w = _ref6.w;
        var tooltipEl = this.ttCtx.getElTooltip();
        var fn = w.config.tooltip.custom;
        if (Array.isArray(fn) && fn[i]) {
          fn = fn[i];
        }
        var customTooltip = fn({
          ctx: this.ctx,
          series: w.globals.series,
          seriesIndex: i,
          dataPointIndex: j,
          y1: y1,
          y2: y2,
          w: w
        });
        if (typeof customTooltip === 'string' || typeof customTooltip === 'number') {
          tooltipEl.innerHTML = customTooltip;
        } else if (customTooltip instanceof Element || typeof customTooltip.nodeName === 'string') {
          tooltipEl.innerHTML = '';
          tooltipEl.appendChild(customTooltip.cloneNode(true));
        }
      }
    }]);
    return Labels;
  }();

  /**
   * ApexCharts Tooltip.Position Class to move the tooltip based on x and y position.
   *
   * @module Tooltip.Position
   **/
  var Position = /*#__PURE__*/function () {
    function Position(tooltipContext) {
      _classCallCheck(this, Position);
      this.ttCtx = tooltipContext;
      this.ctx = tooltipContext.ctx;
      this.w = tooltipContext.w;
    }

    /**
     * This will move the crosshair (the vertical/horz line that moves along with mouse)
     * Along with this, this function also calls the xaxisMove function
     * @memberof Position
     * @param {int} - cx = point's x position, wherever point's x is, you need to move crosshair
     */
    _createClass(Position, [{
      key: "moveXCrosshairs",
      value: function moveXCrosshairs(cx) {
        var j = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
        var ttCtx = this.ttCtx;
        var w = this.w;
        var xcrosshairs = ttCtx.getElXCrosshairs();
        var x = cx - ttCtx.xcrosshairsWidth / 2;
        var tickAmount = w.globals.labels.slice().length;
        if (j !== null) {
          x = w.globals.gridWidth / tickAmount * j;
        }
        if (xcrosshairs !== null && !w.globals.isBarHorizontal) {
          xcrosshairs.setAttribute('x', x);
          xcrosshairs.setAttribute('x1', x);
          xcrosshairs.setAttribute('x2', x);
          xcrosshairs.setAttribute('y2', w.globals.gridHeight);
          xcrosshairs.classList.add('apexcharts-active');
        }
        if (x < 0) {
          x = 0;
        }
        if (x > w.globals.gridWidth) {
          x = w.globals.gridWidth;
        }
        if (ttCtx.isXAxisTooltipEnabled) {
          var tx = x;
          if (w.config.xaxis.crosshairs.width === 'tickWidth' || w.config.xaxis.crosshairs.width === 'barWidth') {
            tx = x + ttCtx.xcrosshairsWidth / 2;
          }
          this.moveXAxisTooltip(tx);
        }
      }

      /**
       * This will move the crosshair (the vertical/horz line that moves along with mouse)
       * Along with this, this function also calls the xaxisMove function
       * @memberof Position
       * @param {int} - cx = point's x position, wherever point's x is, you need to move crosshair
       */
    }, {
      key: "moveYCrosshairs",
      value: function moveYCrosshairs(cy) {
        var ttCtx = this.ttCtx;
        if (ttCtx.ycrosshairs !== null) {
          Graphics.setAttrs(ttCtx.ycrosshairs, {
            y1: cy,
            y2: cy
          });
        }
        if (ttCtx.ycrosshairsHidden !== null) {
          Graphics.setAttrs(ttCtx.ycrosshairsHidden, {
            y1: cy,
            y2: cy
          });
        }
      }

      /**
       ** AxisTooltip is the small rectangle which appears on x axis with x value, when user moves
       * @memberof Position
       * @param {int} - cx = point's x position, wherever point's x is, you need to move
       */
    }, {
      key: "moveXAxisTooltip",
      value: function moveXAxisTooltip(cx) {
        var w = this.w;
        var ttCtx = this.ttCtx;
        if (ttCtx.xaxisTooltip !== null && ttCtx.xcrosshairsWidth !== 0) {
          ttCtx.xaxisTooltip.classList.add('apexcharts-active');
          var cy = ttCtx.xaxisOffY + w.config.xaxis.tooltip.offsetY + w.globals.translateY + 1 + w.config.xaxis.offsetY;
          var xaxisTTText = ttCtx.xaxisTooltip.getBoundingClientRect();
          var xaxisTTTextWidth = xaxisTTText.width;
          cx = cx - xaxisTTTextWidth / 2;
          if (!isNaN(cx)) {
            cx = cx + w.globals.translateX;
            var textRect = 0;
            var graphics = new Graphics(this.ctx);
            textRect = graphics.getTextRects(ttCtx.xaxisTooltipText.innerHTML);
            ttCtx.xaxisTooltipText.style.minWidth = textRect.width + 'px';
            ttCtx.xaxisTooltip.style.left = cx + 'px';
            ttCtx.xaxisTooltip.style.top = cy + 'px';
          }
        }
      }
    }, {
      key: "moveYAxisTooltip",
      value: function moveYAxisTooltip(index) {
        var w = this.w;
        var ttCtx = this.ttCtx;
        if (ttCtx.yaxisTTEls === null) {
          ttCtx.yaxisTTEls = w.globals.dom.baseEl.querySelectorAll('.apexcharts-yaxistooltip');
        }
        var ycrosshairsHiddenRectY1 = parseInt(ttCtx.ycrosshairsHidden.getAttribute('y1'), 10);
        var cy = w.globals.translateY + ycrosshairsHiddenRectY1;
        var yAxisTTRect = ttCtx.yaxisTTEls[index].getBoundingClientRect();
        var yAxisTTHeight = yAxisTTRect.height;
        var cx = w.globals.translateYAxisX[index] - 2;
        if (w.config.yaxis[index].opposite) {
          cx = cx - yAxisTTRect.width;
        }
        cy = cy - yAxisTTHeight / 2;
        if (w.globals.ignoreYAxisIndexes.indexOf(index) === -1 && cy > 0 && cy < w.globals.gridHeight) {
          ttCtx.yaxisTTEls[index].classList.add('apexcharts-active');
          ttCtx.yaxisTTEls[index].style.top = cy + 'px';
          ttCtx.yaxisTTEls[index].style.left = cx + w.config.yaxis[index].tooltip.offsetX + 'px';
        } else {
          ttCtx.yaxisTTEls[index].classList.remove('apexcharts-active');
        }
      }

      /**
       ** moves the whole tooltip by changing x, y attrs
       * @memberof Position
       * @param {int} - cx = point's x position, wherever point's x is, you need to move tooltip
       * @param {int} - cy = point's y position, wherever point's y is, you need to move tooltip
       * @param {int} - markerSize = point's size
       */
    }, {
      key: "moveTooltip",
      value: function moveTooltip(cx, cy) {
        var markerSize = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
        var w = this.w;
        var ttCtx = this.ttCtx;
        var tooltipEl = ttCtx.getElTooltip();
        var tooltipRect = ttCtx.tooltipRect;
        var pointSize = markerSize !== null ? parseFloat(markerSize) : 1;
        var x = parseFloat(cx) + pointSize + 5;
        var y = parseFloat(cy) + pointSize / 2; // - tooltipRect.ttHeight / 2

        if (x > w.globals.gridWidth / 2) {
          x = x - tooltipRect.ttWidth - pointSize - 10;
        }
        if (x > w.globals.gridWidth - tooltipRect.ttWidth - 10) {
          x = w.globals.gridWidth - tooltipRect.ttWidth;
        }
        if (x < -20) {
          x = -20;
        }
        if (w.config.tooltip.followCursor) {
          var elGrid = ttCtx.getElGrid();
          var seriesBound = elGrid.getBoundingClientRect();
          x = ttCtx.e.clientX - seriesBound.left;
          if (x > w.globals.gridWidth / 2) {
            x = x - ttCtx.tooltipRect.ttWidth;
          }
          y = ttCtx.e.clientY + w.globals.translateY - seriesBound.top;
          if (y > w.globals.gridHeight / 2) {
            y = y - ttCtx.tooltipRect.ttHeight;
          }
        } else {
          if (!w.globals.isBarHorizontal) {
            if (tooltipRect.ttHeight / 2 + y > w.globals.gridHeight) {
              y = w.globals.gridHeight - tooltipRect.ttHeight + w.globals.translateY;
            }
          }
        }
        if (!isNaN(x)) {
          x = x + w.globals.translateX;
          tooltipEl.style.left = x + 'px';
          tooltipEl.style.top = y + 'px';
        }
      }
    }, {
      key: "moveMarkers",
      value: function moveMarkers(i, j) {
        var w = this.w;
        var ttCtx = this.ttCtx;
        if (w.globals.markers.size[i] > 0) {
          var allPoints = w.globals.dom.baseEl.querySelectorAll(" .apexcharts-series[data\\:realIndex='".concat(i, "'] .apexcharts-marker"));
          for (var p = 0; p < allPoints.length; p++) {
            if (parseInt(allPoints[p].getAttribute('rel'), 10) === j) {
              ttCtx.marker.resetPointsSize();
              ttCtx.marker.enlargeCurrentPoint(j, allPoints[p]);
            }
          }
        } else {
          ttCtx.marker.resetPointsSize();
          this.moveDynamicPointOnHover(j, i);
        }
      }

      // This function is used when you need to show markers/points only on hover -
      // DIFFERENT X VALUES in multiple series
    }, {
      key: "moveDynamicPointOnHover",
      value: function moveDynamicPointOnHover(j, capturedSeries) {
        var _pointsArr$capturedSe, _pointsArr$capturedSe2;
        var w = this.w;
        var ttCtx = this.ttCtx;
        var cx = 0;
        var cy = 0;
        var graphics = new Graphics(this.ctx);
        var pointsArr = w.globals.pointsArray;
        var hoverSize = ttCtx.tooltipUtil.getHoverMarkerSize(capturedSeries);
        var serType = w.config.series[capturedSeries].type;
        if (serType && (serType === 'column' || serType === 'candlestick' || serType === 'boxPlot')) {
          // fix error mentioned in #811
          return;
        }
        cx = (_pointsArr$capturedSe = pointsArr[capturedSeries][j]) === null || _pointsArr$capturedSe === void 0 ? void 0 : _pointsArr$capturedSe[0];
        cy = ((_pointsArr$capturedSe2 = pointsArr[capturedSeries][j]) === null || _pointsArr$capturedSe2 === void 0 ? void 0 : _pointsArr$capturedSe2[1]) || 0;
        var point = w.globals.dom.baseEl.querySelector(".apexcharts-series[data\\:realIndex='".concat(capturedSeries, "'] .apexcharts-series-markers path"));
        if (point && cy < w.globals.gridHeight && cy > 0) {
          var shape = point.getAttribute('shape');
          var path = graphics.getMarkerPath(cx, cy, shape, hoverSize * 1.5);
          point.setAttribute('d', path);
        }
        this.moveXCrosshairs(cx);
        if (!ttCtx.fixedTooltip) {
          this.moveTooltip(cx, cy, hoverSize);
        }
      }

      // This function is used when you need to show markers/points only on hover -
      // SAME X VALUES in multiple series
    }, {
      key: "moveDynamicPointsOnHover",
      value: function moveDynamicPointsOnHover(j) {
        var ttCtx = this.ttCtx;
        var w = ttCtx.w;
        var cx = 0;
        var cy = 0;
        var activeSeries = 0;
        var pointsArr = w.globals.pointsArray;
        var series = new Series(this.ctx);
        var graphics = new Graphics(this.ctx);
        activeSeries = series.getActiveConfigSeriesIndex('asc', ['line', 'area', 'scatter', 'bubble']);
        var hoverSize = ttCtx.tooltipUtil.getHoverMarkerSize(activeSeries);
        if (pointsArr[activeSeries]) {
          cx = pointsArr[activeSeries][j][0];
          cy = pointsArr[activeSeries][j][1];
        }
        if (isNaN(cx)) {
          return;
        }
        var points = ttCtx.tooltipUtil.getAllMarkers();
        if (points.length) {
          for (var p = 0; p < w.globals.series.length; p++) {
            var pointArr = pointsArr[p];
            if (w.globals.comboCharts) {
              // in a combo chart, if column charts are present, markers will not match with the number of series, hence this patch to push a null value in points array
              if (typeof pointArr === 'undefined') {
                // nodelist to array
                points.splice(p, 0, null);
              }
            }
            if (pointArr && pointArr.length) {
              var pcy = pointsArr[p][j][1];
              var pcy2 = void 0;
              points[p].setAttribute('cx', cx);
              var shape = points[p].getAttribute('shape');
              if (w.config.chart.type === 'rangeArea' && !w.globals.comboCharts) {
                var rangeStartIndex = j + w.globals.series[p].length;
                pcy2 = pointsArr[p][rangeStartIndex][1];
                var pcyDiff = Math.abs(pcy - pcy2) / 2;
                pcy = pcy - pcyDiff;
              }
              if (pcy !== null && !isNaN(pcy) && pcy < w.globals.gridHeight + hoverSize && pcy + hoverSize > 0) {
                var path = graphics.getMarkerPath(cx, pcy, shape, hoverSize);
                points[p].setAttribute('d', path);
              } else {
                points[p].setAttribute('d', '');
              }
            }
          }
        }
        this.moveXCrosshairs(cx);
        if (!ttCtx.fixedTooltip) {
          this.moveTooltip(cx, cy || w.globals.gridHeight, hoverSize);
        }
      }
    }, {
      key: "moveStickyTooltipOverBars",
      value: function moveStickyTooltipOverBars(j, capturedSeries) {
        var w = this.w;
        var ttCtx = this.ttCtx;
        var barLen = w.globals.columnSeries ? w.globals.columnSeries.length : w.globals.series.length;
        if (w.config.chart.stacked) {
          barLen = w.globals.barGroups.length;
        }
        var i = barLen >= 2 && barLen % 2 === 0 ? Math.floor(barLen / 2) : Math.floor(barLen / 2) + 1;
        if (w.globals.isBarHorizontal) {
          var series = new Series(this.ctx);
          i = series.getActiveConfigSeriesIndex('desc') + 1;
        }
        var jBar = w.globals.dom.baseEl.querySelector(".apexcharts-bar-series .apexcharts-series[rel='".concat(i, "'] path[j='").concat(j, "'], .apexcharts-candlestick-series .apexcharts-series[rel='").concat(i, "'] path[j='").concat(j, "'], .apexcharts-boxPlot-series .apexcharts-series[rel='").concat(i, "'] path[j='").concat(j, "'], .apexcharts-rangebar-series .apexcharts-series[rel='").concat(i, "'] path[j='").concat(j, "']"));
        if (!jBar && typeof capturedSeries === 'number') {
          // Try with captured series index
          jBar = w.globals.dom.baseEl.querySelector(".apexcharts-bar-series .apexcharts-series[data\\:realIndex='".concat(capturedSeries, "'] path[j='").concat(j, "'],\n        .apexcharts-candlestick-series .apexcharts-series[data\\:realIndex='").concat(capturedSeries, "'] path[j='").concat(j, "'],\n        .apexcharts-boxPlot-series .apexcharts-series[data\\:realIndex='").concat(capturedSeries, "'] path[j='").concat(j, "'],\n        .apexcharts-rangebar-series .apexcharts-series[data\\:realIndex='").concat(capturedSeries, "'] path[j='").concat(j, "']"));
        }
        var bcx = jBar ? parseFloat(jBar.getAttribute('cx')) : 0;
        var bcy = jBar ? parseFloat(jBar.getAttribute('cy')) : 0;
        var bw = jBar ? parseFloat(jBar.getAttribute('barWidth')) : 0;
        var elGrid = ttCtx.getElGrid();
        var seriesBound = elGrid.getBoundingClientRect();
        var isBoxOrCandle = jBar && (jBar.classList.contains('apexcharts-candlestick-area') || jBar.classList.contains('apexcharts-boxPlot-area'));
        if (w.globals.isXNumeric) {
          if (jBar && !isBoxOrCandle) {
            bcx = bcx - (barLen % 2 !== 0 ? bw / 2 : 0);
          }
          if (jBar &&
          // fixes apexcharts.js#2354
          isBoxOrCandle) {
            bcx = bcx - bw / 2;
          }
        } else {
          if (!w.globals.isBarHorizontal) {
            bcx = ttCtx.xAxisTicksPositions[j - 1] + ttCtx.dataPointsDividedWidth / 2;
            if (isNaN(bcx)) {
              bcx = ttCtx.xAxisTicksPositions[j] - ttCtx.dataPointsDividedWidth / 2;
            }
          }
        }
        if (!w.globals.isBarHorizontal) {
          if (w.config.tooltip.followCursor) {
            bcy = ttCtx.e.clientY - seriesBound.top - ttCtx.tooltipRect.ttHeight / 2;
          } else {
            if (bcy + ttCtx.tooltipRect.ttHeight + 15 > w.globals.gridHeight) {
              bcy = w.globals.gridHeight;
            }
          }
        } else {
          bcy = bcy - ttCtx.tooltipRect.ttHeight;
        }
        if (!w.globals.isBarHorizontal) {
          this.moveXCrosshairs(bcx);
        }
        if (!ttCtx.fixedTooltip) {
          this.moveTooltip(bcx, bcy || w.globals.gridHeight);
        }
      }
    }]);
    return Position;
  }();

  /**
   * ApexCharts Tooltip.Marker Class to draw texts on the tooltip.
   * This file deals with the markers that appear near tooltip in line/area charts.
   * These markers helps the user to associate the data-points and the values
   * that are shown in the tooltip
   *
   * @module Tooltip.Marker
   **/
  var Marker = /*#__PURE__*/function () {
    function Marker(tooltipContext) {
      _classCallCheck(this, Marker);
      this.w = tooltipContext.w;
      this.ttCtx = tooltipContext;
      this.ctx = tooltipContext.ctx;
      this.tooltipPosition = new Position(tooltipContext);
    }
    _createClass(Marker, [{
      key: "drawDynamicPoints",
      value: function drawDynamicPoints() {
        var w = this.w;
        var graphics = new Graphics(this.ctx);
        var marker = new Markers(this.ctx);
        var elsSeries = w.globals.dom.baseEl.querySelectorAll('.apexcharts-series');
        elsSeries = _toConsumableArray(elsSeries);
        if (w.config.chart.stacked) {
          elsSeries.sort(function (a, b) {
            return parseFloat(a.getAttribute('data:realIndex')) - parseFloat(b.getAttribute('data:realIndex'));
          });
        }
        for (var i = 0; i < elsSeries.length; i++) {
          var pointsMain = elsSeries[i].querySelector(".apexcharts-series-markers-wrap");
          if (pointsMain !== null) {
            // it can be null as we have tooltips in donut/bar charts
            var point = void 0;
            var PointClasses = "apexcharts-marker w".concat((Math.random() + 1).toString(36).substring(4));
            if ((w.config.chart.type === 'line' || w.config.chart.type === 'area') && !w.globals.comboCharts && !w.config.tooltip.intersect) {
              PointClasses += ' no-pointer-events';
            }
            var elPointOptions = marker.getMarkerConfig({
              cssClass: PointClasses,
              seriesIndex: Number(pointsMain.getAttribute('data:realIndex')) // fixes apexcharts/apexcharts.js #1427
            });
            point = graphics.drawMarker(0, 0, elPointOptions);
            point.node.setAttribute('default-marker-size', 0);
            var elPointsG = document.createElementNS(w.globals.SVGNS, 'g');
            elPointsG.classList.add('apexcharts-series-markers');
            elPointsG.appendChild(point.node);
            pointsMain.appendChild(elPointsG);
          }
        }
      }
    }, {
      key: "enlargeCurrentPoint",
      value: function enlargeCurrentPoint(rel, point) {
        var x = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
        var y = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
        var w = this.w;
        if (w.config.chart.type !== 'bubble') {
          this.newPointSize(rel, point);
        }
        var cx = point.getAttribute('cx');
        var cy = point.getAttribute('cy');
        if (x !== null && y !== null) {
          cx = x;
          cy = y;
        }
        this.tooltipPosition.moveXCrosshairs(cx);
        if (!this.fixedTooltip) {
          if (w.config.chart.type === 'radar') {
            var elGrid = this.ttCtx.getElGrid();
            var seriesBound = elGrid.getBoundingClientRect();
            cx = this.ttCtx.e.clientX - seriesBound.left;
          }
          this.tooltipPosition.moveTooltip(cx, cy, w.config.markers.hover.size);
        }
      }
    }, {
      key: "enlargePoints",
      value: function enlargePoints(j) {
        var w = this.w;
        var me = this;
        var ttCtx = this.ttCtx;
        var col = j;
        var points = w.globals.dom.baseEl.querySelectorAll('.apexcharts-series:not(.apexcharts-series-collapsed) .apexcharts-marker');
        var newSize = w.config.markers.hover.size;
        for (var p = 0; p < points.length; p++) {
          var rel = points[p].getAttribute('rel');
          var index = points[p].getAttribute('index');
          if (newSize === undefined) {
            newSize = w.globals.markers.size[index] + w.config.markers.hover.sizeOffset;
          }
          if (col === parseInt(rel, 10)) {
            me.newPointSize(col, points[p]);
            var cx = points[p].getAttribute('cx');
            var cy = points[p].getAttribute('cy');
            me.tooltipPosition.moveXCrosshairs(cx);
            if (!ttCtx.fixedTooltip) {
              me.tooltipPosition.moveTooltip(cx, cy, newSize);
            }
          } else {
            me.oldPointSize(points[p]);
          }
        }
      }
    }, {
      key: "newPointSize",
      value: function newPointSize(rel, point) {
        var w = this.w;
        var newSize = w.config.markers.hover.size;
        var elPoint = rel === 0 ? point.parentNode.firstChild : point.parentNode.lastChild;
        if (elPoint.getAttribute('default-marker-size') !== '0') {
          var index = parseInt(elPoint.getAttribute('index'), 10);
          if (newSize === undefined) {
            newSize = w.globals.markers.size[index] + w.config.markers.hover.sizeOffset;
          }
          if (newSize < 0) {
            newSize = 0;
          }
          var path = this.ttCtx.tooltipUtil.getPathFromPoint(point, newSize);
          point.setAttribute('d', path);
        }
      }
    }, {
      key: "oldPointSize",
      value: function oldPointSize(point) {
        var size = parseFloat(point.getAttribute('default-marker-size'));
        var path = this.ttCtx.tooltipUtil.getPathFromPoint(point, size);
        point.setAttribute('d', path);
      }
    }, {
      key: "resetPointsSize",
      value: function resetPointsSize() {
        var w = this.w;
        var points = w.globals.dom.baseEl.querySelectorAll('.apexcharts-series:not(.apexcharts-series-collapsed) .apexcharts-marker');
        for (var p = 0; p < points.length; p++) {
          var size = parseFloat(points[p].getAttribute('default-marker-size'));
          if (Utils$1.isNumber(size) && size > 0) {
            var path = this.ttCtx.tooltipUtil.getPathFromPoint(points[p], size);
            points[p].setAttribute('d', path);
          } else {
            points[p].setAttribute('d', 'M0,0');
          }
        }
      }
    }]);
    return Marker;
  }();

  /**
   * ApexCharts Tooltip.Intersect Class.
   * This file deals with functions related to intersecting tooltips
   * (tooltips that appear when user hovers directly over a data-point whether)
   *
   * @module Tooltip.Intersect
   **/
  var Intersect = /*#__PURE__*/function () {
    function Intersect(tooltipContext) {
      _classCallCheck(this, Intersect);
      this.w = tooltipContext.w;
      var w = this.w;
      this.ttCtx = tooltipContext;
      this.isVerticalGroupedRangeBar = !w.globals.isBarHorizontal && w.config.chart.type === 'rangeBar' && w.config.plotOptions.bar.rangeBarGroupRows;
    }

    // a helper function to get an element's attribute value
    _createClass(Intersect, [{
      key: "getAttr",
      value: function getAttr(e, attr) {
        return parseFloat(e.target.getAttribute(attr));
      }

      // handle tooltip for heatmaps and treemaps
    }, {
      key: "handleHeatTreeTooltip",
      value: function handleHeatTreeTooltip(_ref) {
        var e = _ref.e,
          opt = _ref.opt,
          x = _ref.x,
          y = _ref.y,
          type = _ref.type;
        var ttCtx = this.ttCtx;
        var w = this.w;
        if (e.target.classList.contains("apexcharts-".concat(type, "-rect"))) {
          var i = this.getAttr(e, 'i');
          var j = this.getAttr(e, 'j');
          var cx = this.getAttr(e, 'cx');
          var cy = this.getAttr(e, 'cy');
          var width = this.getAttr(e, 'width');
          var height = this.getAttr(e, 'height');
          ttCtx.tooltipLabels.drawSeriesTexts({
            ttItems: opt.ttItems,
            i: i,
            j: j,
            shared: false,
            e: e
          });
          w.globals.capturedSeriesIndex = i;
          w.globals.capturedDataPointIndex = j;
          x = cx + ttCtx.tooltipRect.ttWidth / 2 + width;
          y = cy + ttCtx.tooltipRect.ttHeight / 2 - height / 2;
          ttCtx.tooltipPosition.moveXCrosshairs(cx + width / 2);
          if (x > w.globals.gridWidth / 2) {
            x = cx - ttCtx.tooltipRect.ttWidth / 2 + width;
          }
          if (ttCtx.w.config.tooltip.followCursor) {
            var seriesBound = w.globals.dom.elWrap.getBoundingClientRect();
            x = w.globals.clientX - seriesBound.left - (x > w.globals.gridWidth / 2 ? ttCtx.tooltipRect.ttWidth : 0);
            y = w.globals.clientY - seriesBound.top - (y > w.globals.gridHeight / 2 ? ttCtx.tooltipRect.ttHeight : 0);
          }
        }
        return {
          x: x,
          y: y
        };
      }

      /**
       * handle tooltips for line/area/scatter charts where tooltip.intersect is true
       * when user hovers over the marker directly, this function is executed
       */
    }, {
      key: "handleMarkerTooltip",
      value: function handleMarkerTooltip(_ref2) {
        var e = _ref2.e,
          opt = _ref2.opt,
          x = _ref2.x,
          y = _ref2.y;
        var w = this.w;
        var ttCtx = this.ttCtx;
        var i;
        var j;
        if (e.target.classList.contains('apexcharts-marker')) {
          var cx = parseInt(opt.paths.getAttribute('cx'), 10);
          var cy = parseInt(opt.paths.getAttribute('cy'), 10);
          var val = parseFloat(opt.paths.getAttribute('val'));
          j = parseInt(opt.paths.getAttribute('rel'), 10);
          i = parseInt(opt.paths.parentNode.parentNode.parentNode.getAttribute('rel'), 10) - 1;
          if (ttCtx.intersect) {
            var el = Utils$1.findAncestor(opt.paths, 'apexcharts-series');
            if (el) {
              i = parseInt(el.getAttribute('data:realIndex'), 10);
            }
          }
          ttCtx.tooltipLabels.drawSeriesTexts({
            ttItems: opt.ttItems,
            i: i,
            j: j,
            shared: ttCtx.showOnIntersect ? false : w.config.tooltip.shared,
            e: e
          });
          if (e.type === 'mouseup') {
            ttCtx.markerClick(e, i, j);
          }
          w.globals.capturedSeriesIndex = i;
          w.globals.capturedDataPointIndex = j;
          x = cx;
          y = cy + w.globals.translateY - ttCtx.tooltipRect.ttHeight * 1.4;
          if (ttCtx.w.config.tooltip.followCursor) {
            var elGrid = ttCtx.getElGrid();
            var seriesBound = elGrid.getBoundingClientRect();
            y = ttCtx.e.clientY + w.globals.translateY - seriesBound.top;
          }
          if (val < 0) {
            y = cy;
          }
          ttCtx.marker.enlargeCurrentPoint(j, opt.paths, x, y);
        }
        return {
          x: x,
          y: y
        };
      }

      /**
       * handle tooltips for bar/column charts
       */
    }, {
      key: "handleBarTooltip",
      value: function handleBarTooltip(_ref3) {
        var e = _ref3.e,
          opt = _ref3.opt;
        var w = this.w;
        var ttCtx = this.ttCtx;
        var tooltipEl = ttCtx.getElTooltip();
        var bx = 0;
        var x = 0;
        var y = 0;
        var i = 0;
        var strokeWidth;
        var barXY = this.getBarTooltipXY({
          e: e,
          opt: opt
        });
        if (barXY.j === null && barXY.barHeight === 0 && barXY.barWidth === 0) {
          return; // bar was not hovered and didn't receive correct coords
        }
        i = barXY.i;
        var j = barXY.j;
        w.globals.capturedSeriesIndex = i;
        w.globals.capturedDataPointIndex = j;
        if (w.globals.isBarHorizontal && ttCtx.tooltipUtil.hasBars() || !w.config.tooltip.shared) {
          x = barXY.x;
          y = barXY.y;
          strokeWidth = Array.isArray(w.config.stroke.width) ? w.config.stroke.width[i] : w.config.stroke.width;
          bx = x;
        } else {
          if (!w.globals.comboCharts && !w.config.tooltip.shared) {
            // todo: re-check this condition as it's always 0
            bx = bx / 2;
          }
        }

        // y is NaN, make it touch the bottom of grid area
        if (isNaN(y)) {
          y = w.globals.svgHeight - ttCtx.tooltipRect.ttHeight;
        }
        parseInt(opt.paths.parentNode.getAttribute('data:realIndex'), 10);
        if (x + ttCtx.tooltipRect.ttWidth > w.globals.gridWidth) {
          x = x - ttCtx.tooltipRect.ttWidth;
        } else if (x < 0) {
          x = 0;
        }
        if (ttCtx.w.config.tooltip.followCursor) {
          var elGrid = ttCtx.getElGrid();
          var seriesBound = elGrid.getBoundingClientRect();
          y = ttCtx.e.clientY - seriesBound.top;
        }

        // if tooltip is still null, querySelector
        if (ttCtx.tooltip === null) {
          ttCtx.tooltip = w.globals.dom.baseEl.querySelector('.apexcharts-tooltip');
        }
        if (!w.config.tooltip.shared) {
          if (w.globals.comboBarCount > 0) {
            ttCtx.tooltipPosition.moveXCrosshairs(bx + strokeWidth / 2);
          } else {
            ttCtx.tooltipPosition.moveXCrosshairs(bx);
          }
        }

        // move tooltip here
        if (!ttCtx.fixedTooltip && (!w.config.tooltip.shared || w.globals.isBarHorizontal && ttCtx.tooltipUtil.hasBars())) {
          y = y + w.globals.translateY - ttCtx.tooltipRect.ttHeight / 2;
          tooltipEl.style.left = x + w.globals.translateX + 'px';
          tooltipEl.style.top = y + 'px';
        }
      }
    }, {
      key: "getBarTooltipXY",
      value: function getBarTooltipXY(_ref4) {
        var _this = this;
        var e = _ref4.e,
          opt = _ref4.opt;
        var w = this.w;
        var j = null;
        var ttCtx = this.ttCtx;
        var i = 0;
        var x = 0;
        var y = 0;
        var barWidth = 0;
        var barHeight = 0;
        var cl = e.target.classList;
        if (cl.contains('apexcharts-bar-area') || cl.contains('apexcharts-candlestick-area') || cl.contains('apexcharts-boxPlot-area') || cl.contains('apexcharts-rangebar-area')) {
          var bar = e.target;
          var barRect = bar.getBoundingClientRect();
          var seriesBound = opt.elGrid.getBoundingClientRect();
          var bh = barRect.height;
          barHeight = barRect.height;
          var bw = barRect.width;
          var cx = parseInt(bar.getAttribute('cx'), 10);
          var cy = parseInt(bar.getAttribute('cy'), 10);
          barWidth = parseFloat(bar.getAttribute('barWidth'));
          var clientX = e.type === 'touchmove' ? e.touches[0].clientX : e.clientX;
          j = parseInt(bar.getAttribute('j'), 10);
          i = parseInt(bar.parentNode.getAttribute('rel'), 10) - 1;
          var y1 = bar.getAttribute('data-range-y1');
          var y2 = bar.getAttribute('data-range-y2');
          if (w.globals.comboCharts) {
            i = parseInt(bar.parentNode.getAttribute('data:realIndex'), 10);
          }
          var handleXForColumns = function handleXForColumns(x) {
            if (w.globals.isXNumeric) {
              x = cx - bw / 2;
            } else {
              if (_this.isVerticalGroupedRangeBar) {
                x = cx + bw / 2;
              } else {
                x = cx - ttCtx.dataPointsDividedWidth + bw / 2;
              }
            }
            return x;
          };
          var handleYForBars = function handleYForBars() {
            return cy - ttCtx.dataPointsDividedHeight + bh / 2 - ttCtx.tooltipRect.ttHeight / 2;
          };
          ttCtx.tooltipLabels.drawSeriesTexts({
            ttItems: opt.ttItems,
            i: i,
            j: j,
            y1: y1 ? parseInt(y1, 10) : null,
            y2: y2 ? parseInt(y2, 10) : null,
            shared: ttCtx.showOnIntersect ? false : w.config.tooltip.shared,
            e: e
          });
          if (w.config.tooltip.followCursor) {
            if (w.globals.isBarHorizontal) {
              x = clientX - seriesBound.left + 15;
              y = handleYForBars();
            } else {
              x = handleXForColumns(x);
              y = e.clientY - seriesBound.top - ttCtx.tooltipRect.ttHeight / 2 - 15;
            }
          } else {
            if (w.globals.isBarHorizontal) {
              x = cx;
              if (x < ttCtx.xyRatios.baseLineInvertedY) {
                x = cx - ttCtx.tooltipRect.ttWidth;
              }
              y = handleYForBars();
            } else {
              x = handleXForColumns(x);
              y = cy; // - ttCtx.tooltipRect.ttHeight / 2 + 10
            }
          }
        }
        return {
          x: x,
          y: y,
          barHeight: barHeight,
          barWidth: barWidth,
          i: i,
          j: j
        };
      }
    }]);
    return Intersect;
  }();

  /**
   * ApexCharts Tooltip.AxesTooltip Class.
   * This file deals with the x-axis and y-axis tooltips.
   *
   * @module Tooltip.AxesTooltip
   **/
  var AxesTooltip = /*#__PURE__*/function () {
    function AxesTooltip(tooltipContext) {
      _classCallCheck(this, AxesTooltip);
      this.w = tooltipContext.w;
      this.ttCtx = tooltipContext;
    }

    /**
     * This method adds the secondary tooltip which appears below x axis
     * @memberof Tooltip
     **/
    _createClass(AxesTooltip, [{
      key: "drawXaxisTooltip",
      value: function drawXaxisTooltip() {
        var w = this.w;
        var ttCtx = this.ttCtx;
        var isBottom = w.config.xaxis.position === 'bottom';
        ttCtx.xaxisOffY = isBottom ? w.globals.gridHeight + 1 : -w.globals.xAxisHeight - w.config.xaxis.axisTicks.height + 3;
        var tooltipCssClass = isBottom ? 'apexcharts-xaxistooltip apexcharts-xaxistooltip-bottom' : 'apexcharts-xaxistooltip apexcharts-xaxistooltip-top';
        var renderTo = w.globals.dom.elWrap;
        if (ttCtx.isXAxisTooltipEnabled) {
          var xaxisTooltip = w.globals.dom.baseEl.querySelector('.apexcharts-xaxistooltip');
          if (xaxisTooltip === null) {
            ttCtx.xaxisTooltip = document.createElement('div');
            ttCtx.xaxisTooltip.setAttribute('class', tooltipCssClass + ' apexcharts-theme-' + w.config.tooltip.theme);
            renderTo.appendChild(ttCtx.xaxisTooltip);
            ttCtx.xaxisTooltipText = document.createElement('div');
            ttCtx.xaxisTooltipText.classList.add('apexcharts-xaxistooltip-text');
            ttCtx.xaxisTooltipText.style.fontFamily = w.config.xaxis.tooltip.style.fontFamily || w.config.chart.fontFamily;
            ttCtx.xaxisTooltipText.style.fontSize = w.config.xaxis.tooltip.style.fontSize;
            ttCtx.xaxisTooltip.appendChild(ttCtx.xaxisTooltipText);
          }
        }
      }

      /**
       * This method adds the secondary tooltip which appears below x axis
       * @memberof Tooltip
       **/
    }, {
      key: "drawYaxisTooltip",
      value: function drawYaxisTooltip() {
        var w = this.w;
        var ttCtx = this.ttCtx;
        for (var i = 0; i < w.config.yaxis.length; i++) {
          var isRight = w.config.yaxis[i].opposite || w.config.yaxis[i].crosshairs.opposite;
          ttCtx.yaxisOffX = isRight ? w.globals.gridWidth + 1 : 1;
          var tooltipCssClass = isRight ? "apexcharts-yaxistooltip apexcharts-yaxistooltip-".concat(i, " apexcharts-yaxistooltip-right") : "apexcharts-yaxistooltip apexcharts-yaxistooltip-".concat(i, " apexcharts-yaxistooltip-left");
          var renderTo = w.globals.dom.elWrap;
          var yaxisTooltip = w.globals.dom.baseEl.querySelector(".apexcharts-yaxistooltip apexcharts-yaxistooltip-".concat(i));
          if (yaxisTooltip === null) {
            ttCtx.yaxisTooltip = document.createElement('div');
            ttCtx.yaxisTooltip.setAttribute('class', tooltipCssClass + ' apexcharts-theme-' + w.config.tooltip.theme);
            renderTo.appendChild(ttCtx.yaxisTooltip);
            if (i === 0) ttCtx.yaxisTooltipText = [];
            ttCtx.yaxisTooltipText[i] = document.createElement('div');
            ttCtx.yaxisTooltipText[i].classList.add('apexcharts-yaxistooltip-text');
            ttCtx.yaxisTooltip.appendChild(ttCtx.yaxisTooltipText[i]);
          }
        }
      }

      /**
       * @memberof Tooltip
       **/
    }, {
      key: "setXCrosshairWidth",
      value: function setXCrosshairWidth() {
        var w = this.w;
        var ttCtx = this.ttCtx;

        // set xcrosshairs width
        var xcrosshairs = ttCtx.getElXCrosshairs();
        ttCtx.xcrosshairsWidth = parseInt(w.config.xaxis.crosshairs.width, 10);
        if (!w.globals.comboCharts) {
          if (w.config.xaxis.crosshairs.width === 'tickWidth') {
            var count = w.globals.labels.length;
            ttCtx.xcrosshairsWidth = w.globals.gridWidth / count;
          } else if (w.config.xaxis.crosshairs.width === 'barWidth') {
            var bar = w.globals.dom.baseEl.querySelector('.apexcharts-bar-area');
            if (bar !== null) {
              var barWidth = parseFloat(bar.getAttribute('barWidth'));
              ttCtx.xcrosshairsWidth = barWidth;
            } else {
              ttCtx.xcrosshairsWidth = 1;
            }
          }
        } else {
          var _bar = w.globals.dom.baseEl.querySelector('.apexcharts-bar-area');
          if (_bar !== null && w.config.xaxis.crosshairs.width === 'barWidth') {
            var _barWidth = parseFloat(_bar.getAttribute('barWidth'));
            ttCtx.xcrosshairsWidth = _barWidth;
          } else {
            if (w.config.xaxis.crosshairs.width === 'tickWidth') {
              var _count = w.globals.labels.length;
              ttCtx.xcrosshairsWidth = w.globals.gridWidth / _count;
            }
          }
        }
        if (w.globals.isBarHorizontal) {
          ttCtx.xcrosshairsWidth = 0;
        }
        if (xcrosshairs !== null && ttCtx.xcrosshairsWidth > 0) {
          xcrosshairs.setAttribute('width', ttCtx.xcrosshairsWidth);
        }
      }
    }, {
      key: "handleYCrosshair",
      value: function handleYCrosshair() {
        var w = this.w;
        var ttCtx = this.ttCtx;

        // set ycrosshairs height
        ttCtx.ycrosshairs = w.globals.dom.baseEl.querySelector('.apexcharts-ycrosshairs');
        ttCtx.ycrosshairsHidden = w.globals.dom.baseEl.querySelector('.apexcharts-ycrosshairs-hidden');
      }
    }, {
      key: "drawYaxisTooltipText",
      value: function drawYaxisTooltipText(index, clientY, xyRatios) {
        var ttCtx = this.ttCtx;
        var w = this.w;
        var gl = w.globals;
        var yAxisSeriesArr = gl.seriesYAxisMap[index];
        if (ttCtx.yaxisTooltips[index] && yAxisSeriesArr.length > 0) {
          var lbFormatter = gl.yLabelFormatters[index];
          var elGrid = ttCtx.getElGrid();
          var seriesBound = elGrid.getBoundingClientRect();

          // We can use the index of any series referenced by the Yaxis
          // because they will all return the same value.
          var seriesIndex = yAxisSeriesArr[0];
          var translationsIndex = 0;
          if (xyRatios.yRatio.length > 1) {
            translationsIndex = seriesIndex;
          }
          var hoverY = (clientY - seriesBound.top) * xyRatios.yRatio[translationsIndex];
          var height = gl.maxYArr[seriesIndex] - gl.minYArr[seriesIndex];
          var val = gl.minYArr[seriesIndex] + (height - hoverY);
          if (w.config.yaxis[index].reversed) {
            val = gl.maxYArr[seriesIndex] - (height - hoverY);
          }
          ttCtx.tooltipPosition.moveYCrosshairs(clientY - seriesBound.top);
          ttCtx.yaxisTooltipText[index].innerHTML = lbFormatter(val);
          ttCtx.tooltipPosition.moveYAxisTooltip(index);
        }
      }
    }]);
    return AxesTooltip;
  }();

  /**
   * ApexCharts Core Tooltip Class to handle the tooltip generation.
   *
   * @module Tooltip
   **/
  var Tooltip = /*#__PURE__*/function () {
    function Tooltip(ctx) {
      _classCallCheck(this, Tooltip);
      this.ctx = ctx;
      this.w = ctx.w;
      var w = this.w;
      this.tConfig = w.config.tooltip;
      this.tooltipUtil = new Utils(this);
      this.tooltipLabels = new Labels(this);
      this.tooltipPosition = new Position(this);
      this.marker = new Marker(this);
      this.intersect = new Intersect(this);
      this.axesTooltip = new AxesTooltip(this);
      this.showOnIntersect = this.tConfig.intersect;
      this.showTooltipTitle = this.tConfig.x.show;
      this.fixedTooltip = this.tConfig.fixed.enabled;
      this.xaxisTooltip = null;
      this.yaxisTTEls = null;
      this.isBarShared = !w.globals.isBarHorizontal && this.tConfig.shared;
      this.lastHoverTime = Date.now();
    }
    _createClass(Tooltip, [{
      key: "getElTooltip",
      value: function getElTooltip(ctx) {
        if (!ctx) ctx = this;
        if (!ctx.w.globals.dom.baseEl) return null;
        return ctx.w.globals.dom.baseEl.querySelector('.apexcharts-tooltip');
      }
    }, {
      key: "getElXCrosshairs",
      value: function getElXCrosshairs() {
        return this.w.globals.dom.baseEl.querySelector('.apexcharts-xcrosshairs');
      }
    }, {
      key: "getElGrid",
      value: function getElGrid() {
        return this.w.globals.dom.baseEl.querySelector('.apexcharts-grid');
      }
    }, {
      key: "drawTooltip",
      value: function drawTooltip(xyRatios) {
        var w = this.w;
        this.xyRatios = xyRatios;
        this.isXAxisTooltipEnabled = w.config.xaxis.tooltip.enabled && w.globals.axisCharts;
        this.yaxisTooltips = w.config.yaxis.map(function (y, i) {
          return y.show && y.tooltip.enabled && w.globals.axisCharts ? true : false;
        });
        this.allTooltipSeriesGroups = [];
        if (!w.globals.axisCharts) {
          this.showTooltipTitle = false;
        }
        var tooltipEl = document.createElement('div');
        tooltipEl.classList.add('apexcharts-tooltip');
        if (w.config.tooltip.cssClass) {
          tooltipEl.classList.add(w.config.tooltip.cssClass);
        }
        tooltipEl.classList.add("apexcharts-theme-".concat(this.tConfig.theme || 'light'));
        w.globals.dom.elWrap.appendChild(tooltipEl);
        if (w.globals.axisCharts) {
          this.axesTooltip.drawXaxisTooltip();
          this.axesTooltip.drawYaxisTooltip();
          this.axesTooltip.setXCrosshairWidth();
          this.axesTooltip.handleYCrosshair();
          var xAxis = new XAxis(this.ctx);
          this.xAxisTicksPositions = xAxis.getXAxisTicksPositions();
        }

        // we forcefully set intersect true for these conditions
        if ((w.globals.comboCharts || this.tConfig.intersect || w.config.chart.type === 'rangeBar') && !this.tConfig.shared) {
          this.showOnIntersect = true;
        }
        if (w.config.markers.size === 0 || w.globals.markers.largestSize === 0) {
          // when user don't want to show points all the time, but only on when hovering on series
          this.marker.drawDynamicPoints(this);
        }

        // no visible series, exit
        if (w.globals.collapsedSeries.length === w.globals.series.length) return;
        this.dataPointsDividedHeight = w.globals.gridHeight / w.globals.dataPoints;
        this.dataPointsDividedWidth = w.globals.gridWidth / w.globals.dataPoints;
        if (this.showTooltipTitle) {
          this.tooltipTitle = document.createElement('div');
          this.tooltipTitle.classList.add('apexcharts-tooltip-title');
          this.tooltipTitle.style.fontFamily = this.tConfig.style.fontFamily || w.config.chart.fontFamily;
          this.tooltipTitle.style.fontSize = this.tConfig.style.fontSize;
          tooltipEl.appendChild(this.tooltipTitle);
        }
        var ttItemsCnt = w.globals.series.length; // whether shared or not, default is shared
        if ((w.globals.xyCharts || w.globals.comboCharts) && this.tConfig.shared) {
          if (!this.showOnIntersect) {
            ttItemsCnt = w.globals.series.length;
          } else {
            ttItemsCnt = 1;
          }
        }
        this.legendLabels = w.globals.dom.baseEl.querySelectorAll('.apexcharts-legend-text');
        this.ttItems = this.createTTElements(ttItemsCnt);
        this.addSVGEvents();
      }
    }, {
      key: "createTTElements",
      value: function createTTElements(ttItemsCnt) {
        var _this = this;
        var w = this.w;
        var ttItems = [];
        var tooltipEl = this.getElTooltip();
        var _loop = function _loop(i) {
          var gTxt = document.createElement('div');
          gTxt.classList.add('apexcharts-tooltip-series-group', "apexcharts-tooltip-series-group-".concat(i));
          gTxt.style.order = w.config.tooltip.inverseOrder ? ttItemsCnt - i : i + 1;
          var point = document.createElement('span');
          point.classList.add('apexcharts-tooltip-marker');
          if (w.config.tooltip.fillSeriesColor) {
            point.style.backgroundColor = w.globals.colors[i];
          } else {
            point.style.color = w.globals.colors[i];
          }
          var mShape = w.config.markers.shape;
          var shape = mShape;
          if (Array.isArray(mShape)) {
            shape = mShape[i];
          }
          point.setAttribute('shape', shape);
          gTxt.appendChild(point);
          var gYZ = document.createElement('div');
          gYZ.classList.add('apexcharts-tooltip-text');
          gYZ.style.fontFamily = _this.tConfig.style.fontFamily || w.config.chart.fontFamily;
          gYZ.style.fontSize = _this.tConfig.style.fontSize;
          ['y', 'goals', 'z'].forEach(function (g) {
            var gValText = document.createElement('div');
            gValText.classList.add("apexcharts-tooltip-".concat(g, "-group"));
            var txtLabel = document.createElement('span');
            txtLabel.classList.add("apexcharts-tooltip-text-".concat(g, "-label"));
            gValText.appendChild(txtLabel);
            var txtValue = document.createElement('span');
            txtValue.classList.add("apexcharts-tooltip-text-".concat(g, "-value"));
            gValText.appendChild(txtValue);
            gYZ.appendChild(gValText);
          });
          gTxt.appendChild(gYZ);
          tooltipEl.appendChild(gTxt);
          ttItems.push(gTxt);
        };
        for (var i = 0; i < ttItemsCnt; i++) {
          _loop(i);
        }
        return ttItems;
      }
    }, {
      key: "addSVGEvents",
      value: function addSVGEvents() {
        var w = this.w;
        var type = w.config.chart.type;
        var tooltipEl = this.getElTooltip();
        var commonBar = !!(type === 'bar' || type === 'candlestick' || type === 'boxPlot' || type === 'rangeBar');
        var chartWithmarkers = type === 'area' || type === 'line' || type === 'scatter' || type === 'bubble' || type === 'radar';
        var hoverArea = w.globals.dom.Paper.node;
        var elGrid = this.getElGrid();
        if (elGrid) {
          this.seriesBound = elGrid.getBoundingClientRect();
        }
        var tooltipY = [];
        var tooltipX = [];
        var seriesHoverParams = {
          hoverArea: hoverArea,
          elGrid: elGrid,
          tooltipEl: tooltipEl,
          tooltipY: tooltipY,
          tooltipX: tooltipX,
          ttItems: this.ttItems
        };
        var points;
        if (w.globals.axisCharts) {
          if (chartWithmarkers) {
            points = w.globals.dom.baseEl.querySelectorAll(".apexcharts-series[data\\:longestSeries='true'] .apexcharts-marker");
          } else if (commonBar) {
            points = w.globals.dom.baseEl.querySelectorAll('.apexcharts-series .apexcharts-bar-area, .apexcharts-series .apexcharts-candlestick-area, .apexcharts-series .apexcharts-boxPlot-area, .apexcharts-series .apexcharts-rangebar-area');
          } else if (type === 'heatmap' || type === 'treemap') {
            points = w.globals.dom.baseEl.querySelectorAll('.apexcharts-series .apexcharts-heatmap, .apexcharts-series .apexcharts-treemap');
          }
          if (points && points.length) {
            for (var p = 0; p < points.length; p++) {
              tooltipY.push(points[p].getAttribute('cy'));
              tooltipX.push(points[p].getAttribute('cx'));
            }
          }
        }
        var validSharedChartTypes = w.globals.xyCharts && !this.showOnIntersect || w.globals.comboCharts && !this.showOnIntersect || commonBar && this.tooltipUtil.hasBars() && this.tConfig.shared;
        if (validSharedChartTypes) {
          this.addPathsEventListeners([hoverArea], seriesHoverParams);
        } else if (commonBar && !w.globals.comboCharts || chartWithmarkers && this.showOnIntersect) {
          this.addDatapointEventsListeners(seriesHoverParams);
        } else if (!w.globals.axisCharts || type === 'heatmap' || type === 'treemap') {
          var seriesAll = w.globals.dom.baseEl.querySelectorAll('.apexcharts-series');
          this.addPathsEventListeners(seriesAll, seriesHoverParams);
        }
        if (this.showOnIntersect) {
          var lineAreaPoints = w.globals.dom.baseEl.querySelectorAll('.apexcharts-line-series .apexcharts-marker, .apexcharts-area-series .apexcharts-marker');
          if (lineAreaPoints.length > 0) {
            // if we find any lineSeries, addEventListeners for them
            this.addPathsEventListeners(lineAreaPoints, seriesHoverParams);
          }

          // combo charts may have bars, so add event listeners here too
          if (this.tooltipUtil.hasBars() && !this.tConfig.shared) {
            this.addDatapointEventsListeners(seriesHoverParams);
          }
        }
      }
    }, {
      key: "drawFixedTooltipRect",
      value: function drawFixedTooltipRect() {
        var w = this.w;
        var tooltipEl = this.getElTooltip();
        var tooltipRect = tooltipEl.getBoundingClientRect();
        var ttWidth = tooltipRect.width + 10;
        var ttHeight = tooltipRect.height + 10;
        var x = this.tConfig.fixed.offsetX;
        var y = this.tConfig.fixed.offsetY;
        var fixed = this.tConfig.fixed.position.toLowerCase();
        if (fixed.indexOf('right') > -1) {
          x = x + w.globals.svgWidth - ttWidth + 10;
        }
        if (fixed.indexOf('bottom') > -1) {
          y = y + w.globals.svgHeight - ttHeight - 10;
        }
        tooltipEl.style.left = x + 'px';
        tooltipEl.style.top = y + 'px';
        return {
          x: x,
          y: y,
          ttWidth: ttWidth,
          ttHeight: ttHeight
        };
      }
    }, {
      key: "addDatapointEventsListeners",
      value: function addDatapointEventsListeners(seriesHoverParams) {
        var w = this.w;
        var points = w.globals.dom.baseEl.querySelectorAll('.apexcharts-series-markers .apexcharts-marker, .apexcharts-bar-area, .apexcharts-candlestick-area, .apexcharts-boxPlot-area, .apexcharts-rangebar-area');
        this.addPathsEventListeners(points, seriesHoverParams);
      }
    }, {
      key: "addPathsEventListeners",
      value: function addPathsEventListeners(paths, opts) {
        var self = this;
        var _loop2 = function _loop2(p) {
          var extendedOpts = {
            paths: paths[p],
            tooltipEl: opts.tooltipEl,
            tooltipY: opts.tooltipY,
            tooltipX: opts.tooltipX,
            elGrid: opts.elGrid,
            hoverArea: opts.hoverArea,
            ttItems: opts.ttItems
          };
          var events = ['mousemove', 'mouseup', 'touchmove', 'mouseout', 'touchend'];
          events.map(function (ev) {
            return paths[p].addEventListener(ev, self.onSeriesHover.bind(self, extendedOpts), {
              capture: false,
              passive: true
            });
          });
        };
        for (var p = 0; p < paths.length; p++) {
          _loop2(p);
        }
      }

      /*
       ** Check to see if the tooltips should be updated based on a mouse / touch event
       */
    }, {
      key: "onSeriesHover",
      value: function onSeriesHover(opt, e) {
        var _this2 = this;
        // If a user is moving their mouse quickly, don't bother updating the tooltip every single frame

        var targetDelay = 20;
        var timeSinceLastUpdate = Date.now() - this.lastHoverTime;
        if (timeSinceLastUpdate >= targetDelay) {
          // The tooltip was last updated over 100ms ago - redraw it even if the user is still moving their
          // mouse so they get some feedback that their moves are being registered
          this.seriesHover(opt, e);
        } else {
          // The tooltip was last updated less than 100ms ago
          // Cancel any other delayed draw, so we don't show stale data
          clearTimeout(this.seriesHoverTimeout);

          // Schedule the next draw so that it happens about 100ms after the last update
          this.seriesHoverTimeout = setTimeout(function () {
            _this2.seriesHover(opt, e);
          }, targetDelay - timeSinceLastUpdate);
        }
      }

      /*
       ** The actual series hover function
       */
    }, {
      key: "seriesHover",
      value: function seriesHover(opt, e) {
        var _this3 = this;
        this.lastHoverTime = Date.now();
        var chartGroups = [];
        var w = this.w;

        // if user has more than one charts in group, we need to sync
        if (w.config.chart.group) {
          chartGroups = this.ctx.getGroupedCharts();
        }
        if (w.globals.axisCharts && (w.globals.minX === -Infinity && w.globals.maxX === Infinity || w.globals.dataPoints === 0)) {
          return;
        }
        if (chartGroups.length) {
          chartGroups.forEach(function (ch) {
            var tooltipEl = _this3.getElTooltip(ch);
            var newOpts = {
              paths: opt.paths,
              tooltipEl: tooltipEl,
              tooltipY: opt.tooltipY,
              tooltipX: opt.tooltipX,
              elGrid: opt.elGrid,
              hoverArea: opt.hoverArea,
              ttItems: ch.w.globals.tooltip.ttItems
            };

            // all the charts should have the same minX and maxX (same xaxis) for multiple tooltips to work correctly
            if (ch.w.globals.minX === _this3.w.globals.minX && ch.w.globals.maxX === _this3.w.globals.maxX) {
              ch.w.globals.tooltip.seriesHoverByContext({
                chartCtx: ch,
                ttCtx: ch.w.globals.tooltip,
                opt: newOpts,
                e: e
              });
            }
          });
        } else {
          this.seriesHoverByContext({
            chartCtx: this.ctx,
            ttCtx: this.w.globals.tooltip,
            opt: opt,
            e: e
          });
        }
      }
    }, {
      key: "seriesHoverByContext",
      value: function seriesHoverByContext(_ref) {
        var chartCtx = _ref.chartCtx,
          ttCtx = _ref.ttCtx,
          opt = _ref.opt,
          e = _ref.e;
        var w = chartCtx.w;
        var tooltipEl = this.getElTooltip(chartCtx);
        if (!tooltipEl) return;

        // tooltipRect is calculated on every mousemove, because the text is dynamic
        ttCtx.tooltipRect = {
          x: 0,
          y: 0,
          ttWidth: tooltipEl.getBoundingClientRect().width,
          ttHeight: tooltipEl.getBoundingClientRect().height
        };
        ttCtx.e = e;

        // highlight the current hovered bars
        if (ttCtx.tooltipUtil.hasBars() && !w.globals.comboCharts && !ttCtx.isBarShared) {
          if (this.tConfig.onDatasetHover.highlightDataSeries) {
            var series = new Series(chartCtx);
            series.toggleSeriesOnHover(e, e.target.parentNode);
          }
        }
        if (w.globals.axisCharts) {
          ttCtx.axisChartsTooltips({
            e: e,
            opt: opt,
            tooltipRect: ttCtx.tooltipRect
          });
        } else {
          // non-plot charts i.e pie/donut/circle
          ttCtx.nonAxisChartsTooltips({
            e: e,
            opt: opt,
            tooltipRect: ttCtx.tooltipRect
          });
        }
        if (ttCtx.fixedTooltip) {
          ttCtx.drawFixedTooltipRect();
        }
      }

      // tooltip handling for line/area/bar/columns/scatter
    }, {
      key: "axisChartsTooltips",
      value: function axisChartsTooltips(_ref2) {
        var e = _ref2.e,
          opt = _ref2.opt;
        var w = this.w;
        var x, y;
        var seriesBound = opt.elGrid.getBoundingClientRect();
        var clientX = e.type === 'touchmove' ? e.touches[0].clientX : e.clientX;
        var clientY = e.type === 'touchmove' ? e.touches[0].clientY : e.clientY;
        this.clientY = clientY;
        this.clientX = clientX;
        w.globals.capturedSeriesIndex = -1;
        w.globals.capturedDataPointIndex = -1;
        if (clientY < seriesBound.top || clientY > seriesBound.top + seriesBound.height) {
          this.handleMouseOut(opt);
          return;
        }
        if (Array.isArray(this.tConfig.enabledOnSeries) && !w.config.tooltip.shared) {
          var index = parseInt(opt.paths.getAttribute('index'), 10);
          if (this.tConfig.enabledOnSeries.indexOf(index) < 0) {
            this.handleMouseOut(opt);
            return;
          }
        }
        var tooltipEl = this.getElTooltip();
        var xcrosshairs = this.getElXCrosshairs();
        var syncedCharts = [];
        if (w.config.chart.group) {
          // we need to fallback to sticky tooltip in case charts are synced
          syncedCharts = this.ctx.getSyncedCharts();
        }
        var isStickyTooltip = w.globals.xyCharts || w.config.chart.type === 'bar' && !w.globals.isBarHorizontal && this.tooltipUtil.hasBars() && this.tConfig.shared || w.globals.comboCharts && this.tooltipUtil.hasBars();
        if (e.type === 'mousemove' || e.type === 'touchmove' || e.type === 'mouseup') {
          // there is no series to hover over
          if (w.globals.collapsedSeries.length + w.globals.ancillaryCollapsedSeries.length === w.globals.series.length) {
            return;
          }
          if (xcrosshairs !== null) {
            xcrosshairs.classList.add('apexcharts-active');
          }
          var hasYAxisTooltip = this.yaxisTooltips.filter(function (b) {
            return b === true;
          });
          if (this.ycrosshairs !== null && hasYAxisTooltip.length) {
            this.ycrosshairs.classList.add('apexcharts-active');
          }
          if (isStickyTooltip && !this.showOnIntersect || syncedCharts.length > 1) {
            this.handleStickyTooltip(e, clientX, clientY, opt);
          } else {
            if (w.config.chart.type === 'heatmap' || w.config.chart.type === 'treemap') {
              var markerXY = this.intersect.handleHeatTreeTooltip({
                e: e,
                opt: opt,
                x: x,
                y: y,
                type: w.config.chart.type
              });
              x = markerXY.x;
              y = markerXY.y;
              tooltipEl.style.left = x + 'px';
              tooltipEl.style.top = y + 'px';
            } else {
              if (this.tooltipUtil.hasBars()) {
                this.intersect.handleBarTooltip({
                  e: e,
                  opt: opt
                });
              }
              if (this.tooltipUtil.hasMarkers()) {
                // intersect - line/area/scatter/bubble
                this.intersect.handleMarkerTooltip({
                  e: e,
                  opt: opt,
                  x: x,
                  y: y
                });
              }
            }
          }
          if (this.yaxisTooltips.length) {
            for (var yt = 0; yt < w.config.yaxis.length; yt++) {
              this.axesTooltip.drawYaxisTooltipText(yt, clientY, this.xyRatios);
            }
          }
          w.globals.dom.baseEl.classList.add('apexcharts-tooltip-active');
          opt.tooltipEl.classList.add('apexcharts-active');
        } else if (e.type === 'mouseout' || e.type === 'touchend') {
          this.handleMouseOut(opt);
        }
      }

      // tooltip handling for pie/donuts
    }, {
      key: "nonAxisChartsTooltips",
      value: function nonAxisChartsTooltips(_ref3) {
        var e = _ref3.e,
          opt = _ref3.opt,
          tooltipRect = _ref3.tooltipRect;
        var w = this.w;
        var rel = opt.paths.getAttribute('rel');
        var tooltipEl = this.getElTooltip();
        var seriesBound = w.globals.dom.elWrap.getBoundingClientRect();
        if (e.type === 'mousemove' || e.type === 'touchmove') {
          w.globals.dom.baseEl.classList.add('apexcharts-tooltip-active');
          tooltipEl.classList.add('apexcharts-active');
          this.tooltipLabels.drawSeriesTexts({
            ttItems: opt.ttItems,
            i: parseInt(rel, 10) - 1,
            shared: false
          });
          var x = w.globals.clientX - seriesBound.left - tooltipRect.ttWidth / 2;
          var y = w.globals.clientY - seriesBound.top - tooltipRect.ttHeight - 10;
          tooltipEl.style.left = x + 'px';
          tooltipEl.style.top = y + 'px';
          if (w.config.legend.tooltipHoverFormatter) {
            var legendFormatter = w.config.legend.tooltipHoverFormatter;
            var i = rel - 1;
            var legendName = this.legendLabels[i].getAttribute('data:default-text');
            var text = legendFormatter(legendName, {
              seriesIndex: i,
              dataPointIndex: i,
              w: w
            });
            this.legendLabels[i].innerHTML = text;
          }
        } else if (e.type === 'mouseout' || e.type === 'touchend') {
          tooltipEl.classList.remove('apexcharts-active');
          w.globals.dom.baseEl.classList.remove('apexcharts-tooltip-active');
          if (w.config.legend.tooltipHoverFormatter) {
            this.legendLabels.forEach(function (l) {
              var defaultText = l.getAttribute('data:default-text');
              l.innerHTML = decodeURIComponent(defaultText);
            });
          }
        }
      }
    }, {
      key: "handleStickyTooltip",
      value: function handleStickyTooltip(e, clientX, clientY, opt) {
        var w = this.w;
        var capj = this.tooltipUtil.getNearestValues({
          context: this,
          hoverArea: opt.hoverArea,
          elGrid: opt.elGrid,
          clientX: clientX,
          clientY: clientY
        });
        var j = capj.j;
        var capturedSeries = capj.capturedSeries;
        if (w.globals.collapsedSeriesIndices.includes(capturedSeries)) capturedSeries = null;
        var bounds = opt.elGrid.getBoundingClientRect();
        if (capj.hoverX < 0 || capj.hoverX > bounds.width) {
          this.handleMouseOut(opt);
          return;
        }
        if (capturedSeries !== null) {
          this.handleStickyCapturedSeries(e, capturedSeries, opt, j);
        } else {
          // couldn't capture any series. check if shared X is same,
          // if yes, draw a grouped tooltip
          if (this.tooltipUtil.isXoverlap(j) || w.globals.isBarHorizontal) {
            var firstVisibleSeries = w.globals.series.findIndex(function (s, i) {
              return !w.globals.collapsedSeriesIndices.includes(i);
            });
            this.create(e, this, firstVisibleSeries, j, opt.ttItems);
          }
        }
      }
    }, {
      key: "handleStickyCapturedSeries",
      value: function handleStickyCapturedSeries(e, capturedSeries, opt, j) {
        var w = this.w;
        if (!this.tConfig.shared) {
          var ignoreNull = w.globals.series[capturedSeries][j] === null;
          if (ignoreNull) {
            this.handleMouseOut(opt);
            return;
          }
        }
        if (typeof w.globals.series[capturedSeries][j] !== 'undefined') {
          if (this.tConfig.shared && this.tooltipUtil.isXoverlap(j) && this.tooltipUtil.isInitialSeriesSameLen()) {
            this.create(e, this, capturedSeries, j, opt.ttItems);
          } else {
            this.create(e, this, capturedSeries, j, opt.ttItems, false);
          }
        } else {
          if (this.tooltipUtil.isXoverlap(j)) {
            var firstVisibleSeries = w.globals.series.findIndex(function (s, i) {
              return !w.globals.collapsedSeriesIndices.includes(i);
            });
            this.create(e, this, firstVisibleSeries, j, opt.ttItems);
          }
        }
      }
    }, {
      key: "deactivateHoverFilter",
      value: function deactivateHoverFilter() {
        var w = this.w;
        var graphics = new Graphics(this.ctx);
        var allPaths = w.globals.dom.Paper.find(".apexcharts-bar-area");
        for (var b = 0; b < allPaths.length; b++) {
          graphics.pathMouseLeave(allPaths[b]);
        }
      }
    }, {
      key: "handleMouseOut",
      value: function handleMouseOut(opt) {
        var w = this.w;
        var xcrosshairs = this.getElXCrosshairs();
        w.globals.dom.baseEl.classList.remove('apexcharts-tooltip-active');
        opt.tooltipEl.classList.remove('apexcharts-active');
        this.deactivateHoverFilter();
        if (w.config.chart.type !== 'bubble') {
          this.marker.resetPointsSize();
        }
        if (xcrosshairs !== null) {
          xcrosshairs.classList.remove('apexcharts-active');
        }
        if (this.ycrosshairs !== null) {
          this.ycrosshairs.classList.remove('apexcharts-active');
        }
        if (this.isXAxisTooltipEnabled) {
          this.xaxisTooltip.classList.remove('apexcharts-active');
        }
        if (this.yaxisTooltips.length) {
          if (this.yaxisTTEls === null) {
            this.yaxisTTEls = w.globals.dom.baseEl.querySelectorAll('.apexcharts-yaxistooltip');
          }
          for (var i = 0; i < this.yaxisTTEls.length; i++) {
            this.yaxisTTEls[i].classList.remove('apexcharts-active');
          }
        }
        if (w.config.legend.tooltipHoverFormatter) {
          this.legendLabels.forEach(function (l) {
            var defaultText = l.getAttribute('data:default-text');
            l.innerHTML = decodeURIComponent(defaultText);
          });
        }
      }
    }, {
      key: "markerClick",
      value: function markerClick(e, seriesIndex, dataPointIndex) {
        var w = this.w;
        if (typeof w.config.chart.events.markerClick === 'function') {
          w.config.chart.events.markerClick(e, this.ctx, {
            seriesIndex: seriesIndex,
            dataPointIndex: dataPointIndex,
            w: w
          });
        }
        this.ctx.events.fireEvent('markerClick', [e, this.ctx, {
          seriesIndex: seriesIndex,
          dataPointIndex: dataPointIndex,
          w: w
        }]);
      }
    }, {
      key: "create",
      value: function create(e, context, capturedSeries, j, ttItems) {
        var _w$globals$seriesRang, _w$globals$seriesRang2, _w$globals$seriesRang3, _w$globals$seriesRang4, _w$globals$seriesRang5, _w$globals$seriesRang6, _w$globals$seriesRang7, _w$globals$seriesRang8, _w$globals$seriesRang9, _w$globals$seriesRang10, _w$globals$seriesRang11, _w$globals$seriesRang12, _w$globals$seriesRang13, _w$globals$seriesRang14, _w$globals$seriesRang15, _w$globals$seriesRang16;
        var shared = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : null;
        var w = this.w;
        var ttCtx = context;
        if (e.type === 'mouseup') {
          this.markerClick(e, capturedSeries, j);
        }
        if (shared === null) shared = this.tConfig.shared;
        var hasMarkers = this.tooltipUtil.hasMarkers(capturedSeries);
        var bars = this.tooltipUtil.getElBars();
        var handlePoints = function handlePoints() {
          if (w.globals.markers.largestSize > 0) {
            ttCtx.marker.enlargePoints(j);
          } else {
            ttCtx.tooltipPosition.moveDynamicPointsOnHover(j);
          }
        };
        if (w.config.legend.tooltipHoverFormatter) {
          var legendFormatter = w.config.legend.tooltipHoverFormatter;
          var els = Array.from(this.legendLabels);

          // reset all legend values first
          els.forEach(function (l) {
            var legendName = l.getAttribute('data:default-text');
            l.innerHTML = decodeURIComponent(legendName);
          });

          // for irregular time series
          for (var i = 0; i < els.length; i++) {
            var l = els[i];
            var lsIndex = parseInt(l.getAttribute('i'), 10);
            var legendName = decodeURIComponent(l.getAttribute('data:default-text'));
            var text = legendFormatter(legendName, {
              seriesIndex: shared ? lsIndex : capturedSeries,
              dataPointIndex: j,
              w: w
            });
            if (!shared) {
              l.innerHTML = lsIndex === capturedSeries ? text : legendName;
              if (capturedSeries === lsIndex) {
                break;
              }
            } else {
              l.innerHTML = w.globals.collapsedSeriesIndices.indexOf(lsIndex) < 0 ? text : legendName;
            }
          }
        }
        var commonSeriesTextsParams = _objectSpread2(_objectSpread2({
          ttItems: ttItems,
          i: capturedSeries,
          j: j
        }, typeof ((_w$globals$seriesRang = w.globals.seriesRange) === null || _w$globals$seriesRang === void 0 ? void 0 : (_w$globals$seriesRang2 = _w$globals$seriesRang[capturedSeries]) === null || _w$globals$seriesRang2 === void 0 ? void 0 : (_w$globals$seriesRang3 = _w$globals$seriesRang2[j]) === null || _w$globals$seriesRang3 === void 0 ? void 0 : (_w$globals$seriesRang4 = _w$globals$seriesRang3.y[0]) === null || _w$globals$seriesRang4 === void 0 ? void 0 : _w$globals$seriesRang4.y1) !== 'undefined' && {
          y1: (_w$globals$seriesRang5 = w.globals.seriesRange) === null || _w$globals$seriesRang5 === void 0 ? void 0 : (_w$globals$seriesRang6 = _w$globals$seriesRang5[capturedSeries]) === null || _w$globals$seriesRang6 === void 0 ? void 0 : (_w$globals$seriesRang7 = _w$globals$seriesRang6[j]) === null || _w$globals$seriesRang7 === void 0 ? void 0 : (_w$globals$seriesRang8 = _w$globals$seriesRang7.y[0]) === null || _w$globals$seriesRang8 === void 0 ? void 0 : _w$globals$seriesRang8.y1
        }), typeof ((_w$globals$seriesRang9 = w.globals.seriesRange) === null || _w$globals$seriesRang9 === void 0 ? void 0 : (_w$globals$seriesRang10 = _w$globals$seriesRang9[capturedSeries]) === null || _w$globals$seriesRang10 === void 0 ? void 0 : (_w$globals$seriesRang11 = _w$globals$seriesRang10[j]) === null || _w$globals$seriesRang11 === void 0 ? void 0 : (_w$globals$seriesRang12 = _w$globals$seriesRang11.y[0]) === null || _w$globals$seriesRang12 === void 0 ? void 0 : _w$globals$seriesRang12.y2) !== 'undefined' && {
          y2: (_w$globals$seriesRang13 = w.globals.seriesRange) === null || _w$globals$seriesRang13 === void 0 ? void 0 : (_w$globals$seriesRang14 = _w$globals$seriesRang13[capturedSeries]) === null || _w$globals$seriesRang14 === void 0 ? void 0 : (_w$globals$seriesRang15 = _w$globals$seriesRang14[j]) === null || _w$globals$seriesRang15 === void 0 ? void 0 : (_w$globals$seriesRang16 = _w$globals$seriesRang15.y[0]) === null || _w$globals$seriesRang16 === void 0 ? void 0 : _w$globals$seriesRang16.y2
        });
        if (shared) {
          ttCtx.tooltipLabels.drawSeriesTexts(_objectSpread2(_objectSpread2({}, commonSeriesTextsParams), {}, {
            shared: this.showOnIntersect ? false : this.tConfig.shared
          }));
          if (hasMarkers) {
            handlePoints();
          } else if (this.tooltipUtil.hasBars()) {
            this.barSeriesHeight = this.tooltipUtil.getBarsHeight(bars);
            if (this.barSeriesHeight > 0) {
              // hover state, activate snap filter
              var graphics = new Graphics(this.ctx);
              var paths = w.globals.dom.Paper.find(".apexcharts-bar-area[j='".concat(j, "']"));

              // de-activate first
              this.deactivateHoverFilter();
              var points = ttCtx.tooltipUtil.getAllMarkers(true);
              if (points.length && !this.barSeriesHeight) {
                handlePoints();
              }
              ttCtx.tooltipPosition.moveStickyTooltipOverBars(j, capturedSeries);
              for (var b = 0; b < paths.length; b++) {
                graphics.pathMouseEnter(paths[b]);
              }
            }
          }
        } else {
          ttCtx.tooltipLabels.drawSeriesTexts(_objectSpread2({
            shared: false
          }, commonSeriesTextsParams));
          if (this.tooltipUtil.hasBars()) {
            ttCtx.tooltipPosition.moveStickyTooltipOverBars(j, capturedSeries);
          }
          if (hasMarkers) {
            ttCtx.tooltipPosition.moveMarkers(capturedSeries, j);
          }
        }
      }
    }]);
    return Tooltip;
  }();

  var BarDataLabels = /*#__PURE__*/function () {
    function BarDataLabels(barCtx) {
      _classCallCheck(this, BarDataLabels);
      this.w = barCtx.w;
      this.barCtx = barCtx;
      this.totalFormatter = this.w.config.plotOptions.bar.dataLabels.total.formatter;
      if (!this.totalFormatter) {
        this.totalFormatter = this.w.config.dataLabels.formatter;
      }
    }
    /** handleBarDataLabels is used to calculate the positions for the data-labels
     * It also sets the element's data attr for bars and calls drawCalculatedBarDataLabels()
     * After calculating, it also calls the function to draw data labels
     * @memberof Bar
     * @param {object} {barProps} most of the bar properties used throughout the bar
     * drawing function
     * @return {object} dataLabels node-element which you can append later
     **/
    _createClass(BarDataLabels, [{
      key: "handleBarDataLabels",
      value: function handleBarDataLabels(opts) {
        var x = opts.x,
          y = opts.y,
          y1 = opts.y1,
          y2 = opts.y2,
          i = opts.i,
          j = opts.j,
          realIndex = opts.realIndex,
          columnGroupIndex = opts.columnGroupIndex,
          series = opts.series,
          barHeight = opts.barHeight,
          barWidth = opts.barWidth,
          barXPosition = opts.barXPosition,
          barYPosition = opts.barYPosition,
          visibleSeries = opts.visibleSeries;
        var w = this.w;
        var graphics = new Graphics(this.barCtx.ctx);
        var strokeWidth = Array.isArray(this.barCtx.strokeWidth) ? this.barCtx.strokeWidth[realIndex] : this.barCtx.strokeWidth;
        var bcx;
        var bcy;
        if (w.globals.isXNumeric && !w.globals.isBarHorizontal) {
          bcx = x + parseFloat(barWidth * (visibleSeries + 1));
          bcy = y + parseFloat(barHeight * (visibleSeries + 1)) - strokeWidth;
        } else {
          bcx = x + parseFloat(barWidth * visibleSeries);
          bcy = y + parseFloat(barHeight * visibleSeries);
        }
        var dataLabels = null;
        var totalDataLabels = null;
        var dataLabelsX = x;
        var dataLabelsY = y;
        var dataLabelsPos = {};
        var dataLabelsConfig = w.config.dataLabels;
        var barDataLabelsConfig = this.barCtx.barOptions.dataLabels;
        var barTotalDataLabelsConfig = this.barCtx.barOptions.dataLabels.total;
        if (typeof barYPosition !== 'undefined' && this.barCtx.isRangeBar) {
          bcy = barYPosition;
          dataLabelsY = barYPosition;
        }
        if (typeof barXPosition !== 'undefined' && this.barCtx.isVerticalGroupedRangeBar) {
          bcx = barXPosition;
          dataLabelsX = barXPosition;
        }
        var offX = dataLabelsConfig.offsetX;
        var offY = dataLabelsConfig.offsetY;
        var textRects = {
          width: 0,
          height: 0
        };
        if (w.config.dataLabels.enabled) {
          var yLabel = w.globals.series[i][j];
          textRects = graphics.getTextRects(w.config.dataLabels.formatter ? w.config.dataLabels.formatter(yLabel, _objectSpread2(_objectSpread2({}, w), {}, {
            seriesIndex: i,
            dataPointIndex: j,
            w: w
          })) : w.globals.yLabelFormatters[0](yLabel), parseFloat(dataLabelsConfig.style.fontSize));
        }
        var params = {
          x: x,
          y: y,
          i: i,
          j: j,
          realIndex: realIndex,
          columnGroupIndex: columnGroupIndex,
          bcx: bcx,
          bcy: bcy,
          barHeight: barHeight,
          barWidth: barWidth,
          textRects: textRects,
          strokeWidth: strokeWidth,
          dataLabelsX: dataLabelsX,
          dataLabelsY: dataLabelsY,
          dataLabelsConfig: dataLabelsConfig,
          barDataLabelsConfig: barDataLabelsConfig,
          barTotalDataLabelsConfig: barTotalDataLabelsConfig,
          offX: offX,
          offY: offY
        };
        if (this.barCtx.isHorizontal) {
          dataLabelsPos = this.calculateBarsDataLabelsPosition(params);
        } else {
          dataLabelsPos = this.calculateColumnsDataLabelsPosition(params);
        }
        dataLabels = this.drawCalculatedDataLabels({
          x: dataLabelsPos.dataLabelsX,
          y: dataLabelsPos.dataLabelsY,
          val: this.barCtx.isRangeBar ? [y1, y2] : w.config.chart.stackType === '100%' ? series[realIndex][j] : w.globals.series[realIndex][j],
          i: realIndex,
          j: j,
          barWidth: barWidth,
          barHeight: barHeight,
          textRects: textRects,
          dataLabelsConfig: dataLabelsConfig
        });
        if (w.config.chart.stacked && barTotalDataLabelsConfig.enabled) {
          totalDataLabels = this.drawTotalDataLabels({
            x: dataLabelsPos.totalDataLabelsX,
            y: dataLabelsPos.totalDataLabelsY,
            barWidth: barWidth,
            barHeight: barHeight,
            realIndex: realIndex,
            textAnchor: dataLabelsPos.totalDataLabelsAnchor,
            val: this.getStackedTotalDataLabel({
              realIndex: realIndex,
              j: j
            }),
            dataLabelsConfig: dataLabelsConfig,
            barTotalDataLabelsConfig: barTotalDataLabelsConfig
          });
        }
        return {
          dataLabelsPos: dataLabelsPos,
          dataLabels: dataLabels,
          totalDataLabels: totalDataLabels
        };
      }
    }, {
      key: "getStackedTotalDataLabel",
      value: function getStackedTotalDataLabel(_ref) {
        var realIndex = _ref.realIndex,
          j = _ref.j;
        var w = this.w;
        var val = this.barCtx.stackedSeriesTotals[j];
        if (this.totalFormatter) {
          val = this.totalFormatter(val, _objectSpread2(_objectSpread2({}, w), {}, {
            seriesIndex: realIndex,
            dataPointIndex: j,
            w: w
          }));
        }
        return val;
      }
    }, {
      key: "calculateColumnsDataLabelsPosition",
      value: function calculateColumnsDataLabelsPosition(opts) {
        var _this = this;
        var w = this.w;
        var i = opts.i,
          j = opts.j,
          realIndex = opts.realIndex;
          opts.columnGroupIndex;
          var y = opts.y,
          bcx = opts.bcx,
          barWidth = opts.barWidth,
          barHeight = opts.barHeight,
          textRects = opts.textRects,
          dataLabelsX = opts.dataLabelsX,
          dataLabelsY = opts.dataLabelsY,
          dataLabelsConfig = opts.dataLabelsConfig,
          barDataLabelsConfig = opts.barDataLabelsConfig,
          barTotalDataLabelsConfig = opts.barTotalDataLabelsConfig,
          strokeWidth = opts.strokeWidth,
          offX = opts.offX,
          offY = opts.offY;
        var totalDataLabelsY;
        var totalDataLabelsX;
        var totalDataLabelsAnchor = 'middle';
        var totalDataLabelsBcx = bcx;
        barHeight = Math.abs(barHeight);
        var vertical = w.config.plotOptions.bar.dataLabels.orientation === 'vertical';
        var _this$barCtx$barHelpe = this.barCtx.barHelpers.getZeroValueEncounters({
            i: i,
            j: j
          }),
          zeroEncounters = _this$barCtx$barHelpe.zeroEncounters;
        bcx = bcx - strokeWidth / 2;
        var dataPointsDividedWidth = w.globals.gridWidth / w.globals.dataPoints;
        if (this.barCtx.isVerticalGroupedRangeBar) {
          dataLabelsX += barWidth / 2;
        } else {
          if (w.globals.isXNumeric) {
            dataLabelsX = bcx - barWidth / 2 + offX;
          } else {
            dataLabelsX = bcx - dataPointsDividedWidth + barWidth / 2 + offX;
          }
          if (!w.config.chart.stacked && zeroEncounters > 0 && w.config.plotOptions.bar.hideZeroBarsWhenGrouped) {
            dataLabelsX -= barWidth * zeroEncounters;
          }
        }
        if (vertical) {
          var offsetDLX = 2;
          dataLabelsX = dataLabelsX + textRects.height / 2 - strokeWidth / 2 - offsetDLX;
        }
        var valIsNegative = w.globals.series[i][j] < 0;
        var newY = y;
        if (this.barCtx.isReversed) {
          newY = y + (valIsNegative ? barHeight : -barHeight);
        }
        switch (barDataLabelsConfig.position) {
          case 'center':
            if (vertical) {
              if (valIsNegative) {
                dataLabelsY = newY - barHeight / 2 + offY;
              } else {
                dataLabelsY = newY + barHeight / 2 - offY;
              }
            } else {
              if (valIsNegative) {
                dataLabelsY = newY - barHeight / 2 + textRects.height / 2 + offY;
              } else {
                dataLabelsY = newY + barHeight / 2 + textRects.height / 2 - offY;
              }
            }
            break;
          case 'bottom':
            if (vertical) {
              if (valIsNegative) {
                dataLabelsY = newY - barHeight + offY;
              } else {
                dataLabelsY = newY + barHeight - offY;
              }
            } else {
              if (valIsNegative) {
                dataLabelsY = newY - barHeight + textRects.height + strokeWidth + offY;
              } else {
                dataLabelsY = newY + barHeight - textRects.height / 2 + strokeWidth - offY;
              }
            }
            break;
          case 'top':
            if (vertical) {
              if (valIsNegative) {
                dataLabelsY = newY + offY;
              } else {
                dataLabelsY = newY - offY;
              }
            } else {
              if (valIsNegative) {
                dataLabelsY = newY - textRects.height / 2 - offY;
              } else {
                dataLabelsY = newY + textRects.height + offY;
              }
            }
            break;
        }
        var lowestPrevY = newY;
        w.globals.seriesGroups.forEach(function (sg) {
          var _this$barCtx$sg$join;
          (_this$barCtx$sg$join = _this.barCtx[sg.join(',')]) === null || _this$barCtx$sg$join === void 0 ? void 0 : _this$barCtx$sg$join.prevY.forEach(function (arr) {
            if (valIsNegative) {
              lowestPrevY = Math.max(arr[j], lowestPrevY);
            } else {
              lowestPrevY = Math.min(arr[j], lowestPrevY);
            }
          });
        });
        if (this.barCtx.lastActiveBarSerieIndex === realIndex && barTotalDataLabelsConfig.enabled) {
          var ADDITIONAL_OFFY = 18;
          var graphics = new Graphics(this.barCtx.ctx);
          var totalLabeltextRects = graphics.getTextRects(this.getStackedTotalDataLabel({
            realIndex: realIndex,
            j: j
          }), dataLabelsConfig.fontSize);
          if (valIsNegative) {
            totalDataLabelsY = lowestPrevY - totalLabeltextRects.height / 2 - offY - barTotalDataLabelsConfig.offsetY + ADDITIONAL_OFFY;
          } else {
            totalDataLabelsY = lowestPrevY + totalLabeltextRects.height + offY + barTotalDataLabelsConfig.offsetY - ADDITIONAL_OFFY;
          }

          // width divided into equal parts
          var xDivision = dataPointsDividedWidth;
          totalDataLabelsX = totalDataLabelsBcx + (w.globals.isXNumeric ? -barWidth * w.globals.barGroups.length / 2 : w.globals.barGroups.length * barWidth / 2 - (w.globals.barGroups.length - 1) * barWidth - xDivision) + barTotalDataLabelsConfig.offsetX;
        }
        if (!w.config.chart.stacked) {
          if (dataLabelsY < 0) {
            dataLabelsY = 0 + strokeWidth;
          } else if (dataLabelsY + textRects.height / 3 > w.globals.gridHeight) {
            dataLabelsY = w.globals.gridHeight - strokeWidth;
          }
        }
        return {
          bcx: bcx,
          bcy: y,
          dataLabelsX: dataLabelsX,
          dataLabelsY: dataLabelsY,
          totalDataLabelsX: totalDataLabelsX,
          totalDataLabelsY: totalDataLabelsY,
          totalDataLabelsAnchor: totalDataLabelsAnchor
        };
      }
    }, {
      key: "calculateBarsDataLabelsPosition",
      value: function calculateBarsDataLabelsPosition(opts) {
        var _this2 = this;
        var w = this.w;
        var x = opts.x,
          i = opts.i,
          j = opts.j,
          realIndex = opts.realIndex,
          bcy = opts.bcy,
          barHeight = opts.barHeight,
          barWidth = opts.barWidth,
          textRects = opts.textRects,
          dataLabelsX = opts.dataLabelsX,
          strokeWidth = opts.strokeWidth,
          dataLabelsConfig = opts.dataLabelsConfig,
          barDataLabelsConfig = opts.barDataLabelsConfig,
          barTotalDataLabelsConfig = opts.barTotalDataLabelsConfig,
          offX = opts.offX,
          offY = opts.offY;
        var dataPointsDividedHeight = w.globals.gridHeight / w.globals.dataPoints;
        var _this$barCtx$barHelpe2 = this.barCtx.barHelpers.getZeroValueEncounters({
            i: i,
            j: j
          }),
          zeroEncounters = _this$barCtx$barHelpe2.zeroEncounters;
        barWidth = Math.abs(barWidth);
        var dataLabelsY = bcy - (this.barCtx.isRangeBar ? 0 : dataPointsDividedHeight) + barHeight / 2 + textRects.height / 2 + offY - 3;
        if (!w.config.chart.stacked && zeroEncounters > 0 && w.config.plotOptions.bar.hideZeroBarsWhenGrouped) {
          dataLabelsY -= barHeight * zeroEncounters;
        }
        var totalDataLabelsX;
        var totalDataLabelsY;
        var totalDataLabelsAnchor = 'start';
        var valIsNegative = w.globals.series[i][j] < 0;
        var newX = x;
        if (this.barCtx.isReversed) {
          newX = x + (valIsNegative ? -barWidth : barWidth);
          totalDataLabelsAnchor = valIsNegative ? 'start' : 'end';
        }
        switch (barDataLabelsConfig.position) {
          case 'center':
            if (valIsNegative) {
              dataLabelsX = newX + barWidth / 2 - offX;
            } else {
              dataLabelsX = Math.max(textRects.width / 2, newX - barWidth / 2) + offX;
            }
            break;
          case 'bottom':
            if (valIsNegative) {
              dataLabelsX = newX + barWidth - strokeWidth - offX;
            } else {
              dataLabelsX = newX - barWidth + strokeWidth + offX;
            }
            break;
          case 'top':
            if (valIsNegative) {
              dataLabelsX = newX - strokeWidth - offX;
            } else {
              dataLabelsX = newX - strokeWidth + offX;
            }
            break;
        }
        var lowestPrevX = newX;
        w.globals.seriesGroups.forEach(function (sg) {
          var _this2$barCtx$sg$join;
          (_this2$barCtx$sg$join = _this2.barCtx[sg.join(',')]) === null || _this2$barCtx$sg$join === void 0 ? void 0 : _this2$barCtx$sg$join.prevX.forEach(function (arr) {
            if (valIsNegative) {
              lowestPrevX = Math.min(arr[j], lowestPrevX);
            } else {
              lowestPrevX = Math.max(arr[j], lowestPrevX);
            }
          });
        });
        if (this.barCtx.lastActiveBarSerieIndex === realIndex && barTotalDataLabelsConfig.enabled) {
          var graphics = new Graphics(this.barCtx.ctx);
          var totalLabeltextRects = graphics.getTextRects(this.getStackedTotalDataLabel({
            realIndex: realIndex,
            j: j
          }), dataLabelsConfig.fontSize);
          if (valIsNegative) {
            totalDataLabelsX = lowestPrevX - strokeWidth - offX - barTotalDataLabelsConfig.offsetX;
            totalDataLabelsAnchor = 'end';
          } else {
            totalDataLabelsX = lowestPrevX + offX + barTotalDataLabelsConfig.offsetX + (this.barCtx.isReversed ? -(barWidth + strokeWidth) : strokeWidth);
          }
          totalDataLabelsY = dataLabelsY - textRects.height / 2 + totalLabeltextRects.height / 2 + barTotalDataLabelsConfig.offsetY + strokeWidth;
          if (w.globals.barGroups.length > 1) {
            totalDataLabelsY = totalDataLabelsY - w.globals.barGroups.length / 2 * (barHeight / 2);
          }
        }
        if (!w.config.chart.stacked) {
          if (dataLabelsConfig.textAnchor === 'start') {
            if (dataLabelsX - textRects.width < 0) {
              dataLabelsX = valIsNegative ? textRects.width + strokeWidth : strokeWidth;
            } else if (dataLabelsX + textRects.width > w.globals.gridWidth) {
              dataLabelsX = valIsNegative ? w.globals.gridWidth - strokeWidth : w.globals.gridWidth - textRects.width - strokeWidth;
            }
          } else if (dataLabelsConfig.textAnchor === 'middle') {
            if (dataLabelsX - textRects.width / 2 < 0) {
              dataLabelsX = textRects.width / 2 + strokeWidth;
            } else if (dataLabelsX + textRects.width / 2 > w.globals.gridWidth) {
              dataLabelsX = w.globals.gridWidth - textRects.width / 2 - strokeWidth;
            }
          } else if (dataLabelsConfig.textAnchor === 'end') {
            if (dataLabelsX < 1) {
              dataLabelsX = textRects.width + strokeWidth;
            } else if (dataLabelsX + 1 > w.globals.gridWidth) {
              dataLabelsX = w.globals.gridWidth - textRects.width - strokeWidth;
            }
          }
        }
        return {
          bcx: x,
          bcy: bcy,
          dataLabelsX: dataLabelsX,
          dataLabelsY: dataLabelsY,
          totalDataLabelsX: totalDataLabelsX,
          totalDataLabelsY: totalDataLabelsY,
          totalDataLabelsAnchor: totalDataLabelsAnchor
        };
      }
    }, {
      key: "drawCalculatedDataLabels",
      value: function drawCalculatedDataLabels(_ref2) {
        var x = _ref2.x,
          y = _ref2.y,
          val = _ref2.val,
          i = _ref2.i,
          j = _ref2.j,
          textRects = _ref2.textRects,
          barHeight = _ref2.barHeight,
          barWidth = _ref2.barWidth,
          dataLabelsConfig = _ref2.dataLabelsConfig;
        var w = this.w;
        var rotate = 'rotate(0)';
        if (w.config.plotOptions.bar.dataLabels.orientation === 'vertical') rotate = "rotate(-90, ".concat(x, ", ").concat(y, ")");
        var dataLabels = new DataLabels(this.barCtx.ctx);
        var graphics = new Graphics(this.barCtx.ctx);
        var formatter = dataLabelsConfig.formatter;
        var elDataLabelsWrap = null;
        var isSeriesNotCollapsed = w.globals.collapsedSeriesIndices.indexOf(i) > -1;
        if (dataLabelsConfig.enabled && !isSeriesNotCollapsed) {
          elDataLabelsWrap = graphics.group({
            class: 'apexcharts-data-labels',
            transform: rotate
          });
          var text = '';
          if (typeof val !== 'undefined') {
            text = formatter(val, _objectSpread2(_objectSpread2({}, w), {}, {
              seriesIndex: i,
              dataPointIndex: j,
              w: w
            }));
          }
          if (!val && w.config.plotOptions.bar.hideZeroBarsWhenGrouped) {
            text = '';
          }
          var valIsNegative = w.globals.series[i][j] < 0;
          var position = w.config.plotOptions.bar.dataLabels.position;
          if (w.config.plotOptions.bar.dataLabels.orientation === 'vertical') {
            if (position === 'top') {
              if (valIsNegative) dataLabelsConfig.textAnchor = 'end';else dataLabelsConfig.textAnchor = 'start';
            }
            if (position === 'center') {
              dataLabelsConfig.textAnchor = 'middle';
            }
            if (position === 'bottom') {
              if (valIsNegative) dataLabelsConfig.textAnchor = 'end';else dataLabelsConfig.textAnchor = 'start';
            }
          }
          if (this.barCtx.isRangeBar && this.barCtx.barOptions.dataLabels.hideOverflowingLabels) {
            // hide the datalabel if it cannot fit into the rect
            var txRect = graphics.getTextRects(text, parseFloat(dataLabelsConfig.style.fontSize));
            if (barWidth < txRect.width) {
              text = '';
            }
          }
          if (w.config.chart.stacked && this.barCtx.barOptions.dataLabels.hideOverflowingLabels) {
            // if there is not enough space to draw the label in the bar/column rect, check hideOverflowingLabels property to prevent overflowing on wrong rect
            // Note: This issue is only seen in stacked charts
            if (this.barCtx.isHorizontal) {
              if (textRects.width / 1.6 > Math.abs(barWidth)) {
                text = '';
              }
            } else {
              if (textRects.height / 1.6 > Math.abs(barHeight)) {
                text = '';
              }
            }
          }
          var modifiedDataLabelsConfig = _objectSpread2({}, dataLabelsConfig);
          if (this.barCtx.isHorizontal) {
            if (val < 0) {
              if (dataLabelsConfig.textAnchor === 'start') {
                modifiedDataLabelsConfig.textAnchor = 'end';
              } else if (dataLabelsConfig.textAnchor === 'end') {
                modifiedDataLabelsConfig.textAnchor = 'start';
              }
            }
          }
          dataLabels.plotDataLabelsText({
            x: x,
            y: y,
            text: text,
            i: i,
            j: j,
            parent: elDataLabelsWrap,
            dataLabelsConfig: modifiedDataLabelsConfig,
            alwaysDrawDataLabel: true,
            offsetCorrection: true
          });
        }
        return elDataLabelsWrap;
      }
    }, {
      key: "drawTotalDataLabels",
      value: function drawTotalDataLabels(_ref3) {
        var x = _ref3.x,
          y = _ref3.y,
          val = _ref3.val,
          realIndex = _ref3.realIndex,
          textAnchor = _ref3.textAnchor,
          barTotalDataLabelsConfig = _ref3.barTotalDataLabelsConfig;
        this.w;
        var graphics = new Graphics(this.barCtx.ctx);
        var totalDataLabelText;
        if (barTotalDataLabelsConfig.enabled && typeof x !== 'undefined' && typeof y !== 'undefined' && this.barCtx.lastActiveBarSerieIndex === realIndex) {
          totalDataLabelText = graphics.drawText({
            x: x,
            y: y,
            foreColor: barTotalDataLabelsConfig.style.color,
            text: val,
            textAnchor: textAnchor,
            fontFamily: barTotalDataLabelsConfig.style.fontFamily,
            fontSize: barTotalDataLabelsConfig.style.fontSize,
            fontWeight: barTotalDataLabelsConfig.style.fontWeight
          });
        }
        return totalDataLabelText;
      }
    }]);
    return BarDataLabels;
  }();

  var Helpers$1 = /*#__PURE__*/function () {
    function Helpers(barCtx) {
      _classCallCheck(this, Helpers);
      this.w = barCtx.w;
      this.barCtx = barCtx;
    }
    _createClass(Helpers, [{
      key: "initVariables",
      value: function initVariables(series) {
        var w = this.w;
        this.barCtx.series = series;
        this.barCtx.totalItems = 0;
        this.barCtx.seriesLen = 0;
        this.barCtx.visibleI = -1; // visible Series
        this.barCtx.visibleItems = 1; // number of visible bars after user zoomed in/out

        for (var sl = 0; sl < series.length; sl++) {
          if (series[sl].length > 0) {
            this.barCtx.seriesLen = this.barCtx.seriesLen + 1;
            this.barCtx.totalItems += series[sl].length;
          }
          if (w.globals.isXNumeric) {
            // get max visible items
            for (var _j = 0; _j < series[sl].length; _j++) {
              if (w.globals.seriesX[sl][_j] > w.globals.minX && w.globals.seriesX[sl][_j] < w.globals.maxX) {
                this.barCtx.visibleItems++;
              }
            }
          } else {
            this.barCtx.visibleItems = w.globals.dataPoints;
          }
        }
        this.arrBorderRadius = this.createBorderRadiusArr(w.globals.series);
        if (Utils$1.isSafari()) {
          // https://github.com/apexcharts/apexcharts.js/issues/4996
          // to temporarily fix the above issue, border radius is disabled
          this.arrBorderRadius = this.arrBorderRadius.map(function (brArr) {
            return brArr.map(function (_) {
              return 'none';
            });
          });
        }
        if (this.barCtx.seriesLen === 0) {
          // A small adjustment when combo charts are used
          this.barCtx.seriesLen = 1;
        }
        this.barCtx.zeroSerieses = [];
        if (!w.globals.comboCharts) {
          this.checkZeroSeries({
            series: series
          });
        }
      }
    }, {
      key: "initialPositions",
      value: function initialPositions(realIndex) {
        var w = this.w;
        var x, y, yDivision, xDivision, barHeight, barWidth, zeroH, zeroW;
        var dataPoints = w.globals.dataPoints;
        if (this.barCtx.isRangeBar) {
          // timeline rangebar chart
          dataPoints = w.globals.labels.length;
        }
        var seriesLen = this.barCtx.seriesLen;
        if (w.config.plotOptions.bar.rangeBarGroupRows) {
          seriesLen = 1;
        }
        if (this.barCtx.isHorizontal) {
          // height divided into equal parts
          yDivision = w.globals.gridHeight / dataPoints;
          barHeight = yDivision / seriesLen;
          if (w.globals.isXNumeric) {
            yDivision = w.globals.gridHeight / this.barCtx.totalItems;
            barHeight = yDivision / this.barCtx.seriesLen;
          }
          barHeight = barHeight * parseInt(this.barCtx.barOptions.barHeight, 10) / 100;
          if (String(this.barCtx.barOptions.barHeight).indexOf('%') === -1) {
            barHeight = parseInt(this.barCtx.barOptions.barHeight, 10);
          }
          zeroW = this.barCtx.baseLineInvertedY + w.globals.padHorizontal + (this.barCtx.isReversed ? w.globals.gridWidth : 0) - (this.barCtx.isReversed ? this.barCtx.baseLineInvertedY * 2 : 0);
          if (this.barCtx.isFunnel) {
            zeroW = w.globals.gridWidth / 2;
          }
          y = (yDivision - barHeight * this.barCtx.seriesLen) / 2;
        } else {
          // width divided into equal parts
          xDivision = w.globals.gridWidth / this.barCtx.visibleItems;
          if (w.config.xaxis.convertedCatToNumeric) {
            xDivision = w.globals.gridWidth / w.globals.dataPoints;
          }
          barWidth = xDivision / seriesLen * parseInt(this.barCtx.barOptions.columnWidth, 10) / 100;
          if (w.globals.isXNumeric) {
            // max barwidth should be equal to minXDiff to avoid overlap
            var xRatio = this.barCtx.xRatio;
            if (w.globals.minXDiff && w.globals.minXDiff !== 0.5 && w.globals.minXDiff / xRatio > 0) {
              xDivision = w.globals.minXDiff / xRatio;
            }
            barWidth = xDivision / seriesLen * parseInt(this.barCtx.barOptions.columnWidth, 10) / 100;
            if (barWidth < 1) {
              barWidth = 1;
            }
          }
          if (String(this.barCtx.barOptions.columnWidth).indexOf('%') === -1) {
            barWidth = parseInt(this.barCtx.barOptions.columnWidth, 10);
          }
          zeroH = w.globals.gridHeight - this.barCtx.baseLineY[this.barCtx.translationsIndex] - (this.barCtx.isReversed ? w.globals.gridHeight : 0) + (this.barCtx.isReversed ? this.barCtx.baseLineY[this.barCtx.translationsIndex] * 2 : 0);
          if (w.globals.isXNumeric) {
            var xForNumericX = this.barCtx.getBarXForNumericXAxis({
              x: x,
              j: 0,
              realIndex: realIndex,
              barWidth: barWidth
            });
            x = xForNumericX.x;
          } else {
            x = w.globals.padHorizontal + Utils$1.noExponents(xDivision - barWidth * this.barCtx.seriesLen) / 2;
          }
        }
        w.globals.barHeight = barHeight;
        w.globals.barWidth = barWidth;
        return {
          x: x,
          y: y,
          yDivision: yDivision,
          xDivision: xDivision,
          barHeight: barHeight,
          barWidth: barWidth,
          zeroH: zeroH,
          zeroW: zeroW
        };
      }
    }, {
      key: "initializeStackedPrevVars",
      value: function initializeStackedPrevVars(ctx) {
        var w = ctx.w;
        w.globals.seriesGroups.forEach(function (group) {
          if (!ctx[group]) ctx[group] = {};
          ctx[group].prevY = [];
          ctx[group].prevX = [];
          ctx[group].prevYF = [];
          ctx[group].prevXF = [];
          ctx[group].prevYVal = [];
          ctx[group].prevXVal = [];
        });
      }
    }, {
      key: "initializeStackedXYVars",
      value: function initializeStackedXYVars(ctx) {
        var w = ctx.w;
        w.globals.seriesGroups.forEach(function (group) {
          if (!ctx[group]) ctx[group] = {};
          ctx[group].xArrj = [];
          ctx[group].xArrjF = [];
          ctx[group].xArrjVal = [];
          ctx[group].yArrj = [];
          ctx[group].yArrjF = [];
          ctx[group].yArrjVal = [];
        });
      }
    }, {
      key: "getPathFillColor",
      value: function getPathFillColor(series, i, j, realIndex) {
        var _w$config$series$i$da, _w$config$series$i$da2, _w$config$series$i$da3, _w$config$series$i$da4;
        var w = this.w;
        var fill = this.barCtx.ctx.fill;
        var fillColor = null;
        var seriesNumber = this.barCtx.barOptions.distributed ? j : i;
        var useRangeColor = false;
        if (this.barCtx.barOptions.colors.ranges.length > 0) {
          var colorRange = this.barCtx.barOptions.colors.ranges;
          colorRange.map(function (range) {
            if (series[i][j] >= range.from && series[i][j] <= range.to) {
              fillColor = range.color;
              useRangeColor = true;
            }
          });
        }
        var pathFill = fill.fillPath({
          seriesNumber: this.barCtx.barOptions.distributed ? seriesNumber : realIndex,
          dataPointIndex: j,
          color: fillColor,
          value: series[i][j],
          fillConfig: (_w$config$series$i$da = w.config.series[i].data[j]) === null || _w$config$series$i$da === void 0 ? void 0 : _w$config$series$i$da.fill,
          fillType: (_w$config$series$i$da2 = w.config.series[i].data[j]) !== null && _w$config$series$i$da2 !== void 0 && (_w$config$series$i$da3 = _w$config$series$i$da2.fill) !== null && _w$config$series$i$da3 !== void 0 && _w$config$series$i$da3.type ? (_w$config$series$i$da4 = w.config.series[i].data[j]) === null || _w$config$series$i$da4 === void 0 ? void 0 : _w$config$series$i$da4.fill.type : Array.isArray(w.config.fill.type) ? w.config.fill.type[realIndex] : w.config.fill.type
        });
        return {
          color: pathFill,
          useRangeColor: useRangeColor
        };
      }
    }, {
      key: "getStrokeWidth",
      value: function getStrokeWidth(i, j, realIndex) {
        var strokeWidth = 0;
        var w = this.w;
        if (typeof this.barCtx.series[i][j] === 'undefined' || this.barCtx.series[i][j] === null || w.config.chart.type === 'bar' && !this.barCtx.series[i][j]) {
          this.barCtx.isNullValue = true;
        } else {
          this.barCtx.isNullValue = false;
        }
        if (w.config.stroke.show) {
          if (!this.barCtx.isNullValue) {
            strokeWidth = Array.isArray(this.barCtx.strokeWidth) ? this.barCtx.strokeWidth[realIndex] : this.barCtx.strokeWidth;
          }
        }
        return strokeWidth;
      }
    }, {
      key: "createBorderRadiusArr",
      value: function createBorderRadiusArr(series) {
        var _series$;
        var w = this.w;
        var alwaysApplyRadius = !this.w.config.chart.stacked || w.config.plotOptions.bar.borderRadius <= 0;
        var numSeries = series.length;
        var numColumns = ((_series$ = series[0]) === null || _series$ === void 0 ? void 0 : _series$.length) | 0;
        var output = Array.from({
          length: numSeries
        }, function () {
          return Array(numColumns).fill(alwaysApplyRadius ? 'top' : 'none');
        });
        if (alwaysApplyRadius) return output;
        for (var _j2 = 0; _j2 < numColumns; _j2++) {
          var positiveIndices = [];
          var negativeIndices = [];
          var nonZeroCount = 0;

          // Collect positive and negative indices
          for (var i = 0; i < numSeries; i++) {
            var value = series[i][_j2];
            if (value > 0) {
              positiveIndices.push(i);
              nonZeroCount++;
            } else if (value < 0) {
              negativeIndices.push(i);
              nonZeroCount++;
            }
          }
          if (positiveIndices.length > 0 && negativeIndices.length === 0) {
            // Only positive values in this column
            if (positiveIndices.length === 1) {
              // Single positive value
              output[positiveIndices[0]][_j2] = 'both';
            } else {
              // Multiple positive values
              var firstPositiveIndex = positiveIndices[0];
              var lastPositiveIndex = positiveIndices[positiveIndices.length - 1];
              var _iterator = _createForOfIteratorHelper(positiveIndices),
                _step;
              try {
                for (_iterator.s(); !(_step = _iterator.n()).done;) {
                  var _i2 = _step.value;
                  if (_i2 === firstPositiveIndex) {
                    output[_i2][_j2] = 'bottom';
                  } else if (_i2 === lastPositiveIndex) {
                    output[_i2][_j2] = 'top';
                  } else {
                    output[_i2][_j2] = 'none';
                  }
                }
              } catch (err) {
                _iterator.e(err);
              } finally {
                _iterator.f();
              }
            }
          } else if (negativeIndices.length > 0 && positiveIndices.length === 0) {
            // Only negative values in this column
            if (negativeIndices.length === 1) {
              // Single negative value
              output[negativeIndices[0]][_j2] = 'both';
            } else {
              // Multiple negative values
              var highestNegativeIndex = Math.max.apply(Math, negativeIndices);
              var lowestNegativeIndex = Math.min.apply(Math, negativeIndices);
              var _iterator2 = _createForOfIteratorHelper(negativeIndices),
                _step2;
              try {
                for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                  var _i3 = _step2.value;
                  if (_i3 === highestNegativeIndex) {
                    output[_i3][_j2] = 'bottom'; // Closest to axis
                  } else if (_i3 === lowestNegativeIndex) {
                    output[_i3][_j2] = 'top'; // Farthest from axis
                  } else {
                    output[_i3][_j2] = 'none';
                  }
                }
              } catch (err) {
                _iterator2.e(err);
              } finally {
                _iterator2.f();
              }
            }
          } else if (positiveIndices.length > 0 && negativeIndices.length > 0) {
            // Mixed positive and negative values
            // Assign 'top' to the last positive bar
            var _lastPositiveIndex = positiveIndices[positiveIndices.length - 1];
            var _iterator3 = _createForOfIteratorHelper(positiveIndices),
              _step3;
            try {
              for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
                var _i4 = _step3.value;
                if (_i4 === _lastPositiveIndex) {
                  output[_i4][_j2] = 'top';
                } else {
                  output[_i4][_j2] = 'none';
                }
              }
              // Assign 'bottom' to the highest negative index (closest to axis)
            } catch (err) {
              _iterator3.e(err);
            } finally {
              _iterator3.f();
            }
            var _highestNegativeIndex = Math.max.apply(Math, negativeIndices);
            var _iterator4 = _createForOfIteratorHelper(negativeIndices),
              _step4;
            try {
              for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
                var _i5 = _step4.value;
                if (_i5 === _highestNegativeIndex) {
                  output[_i5][_j2] = 'bottom';
                } else {
                  output[_i5][_j2] = 'none';
                }
              }
            } catch (err) {
              _iterator4.e(err);
            } finally {
              _iterator4.f();
            }
          } else if (nonZeroCount === 1) {
            // Only one non-zero value (either positive or negative)
            var index = positiveIndices[0] || negativeIndices[0];
            output[index][_j2] = 'both';
          }
        }
        return output;
      }
    }, {
      key: "barBackground",
      value: function barBackground(_ref) {
        var j = _ref.j,
          i = _ref.i,
          x1 = _ref.x1,
          x2 = _ref.x2,
          y1 = _ref.y1,
          y2 = _ref.y2,
          elSeries = _ref.elSeries;
        var w = this.w;
        var graphics = new Graphics(this.barCtx.ctx);
        var sr = new Series(this.barCtx.ctx);
        var activeSeriesIndex = sr.getActiveConfigSeriesIndex();
        if (this.barCtx.barOptions.colors.backgroundBarColors.length > 0 && activeSeriesIndex === i) {
          if (j >= this.barCtx.barOptions.colors.backgroundBarColors.length) {
            j %= this.barCtx.barOptions.colors.backgroundBarColors.length;
          }
          var bcolor = this.barCtx.barOptions.colors.backgroundBarColors[j];
          var rect = graphics.drawRect(typeof x1 !== 'undefined' ? x1 : 0, typeof y1 !== 'undefined' ? y1 : 0, typeof x2 !== 'undefined' ? x2 : w.globals.gridWidth, typeof y2 !== 'undefined' ? y2 : w.globals.gridHeight, this.barCtx.barOptions.colors.backgroundBarRadius, bcolor, this.barCtx.barOptions.colors.backgroundBarOpacity);
          elSeries.add(rect);
          rect.node.classList.add('apexcharts-backgroundBar');
        }
      }
    }, {
      key: "getColumnPaths",
      value: function getColumnPaths(_ref2) {
        var _w$config$series$real;
        var barWidth = _ref2.barWidth,
          barXPosition = _ref2.barXPosition,
          y1 = _ref2.y1,
          y2 = _ref2.y2,
          strokeWidth = _ref2.strokeWidth,
          isReversed = _ref2.isReversed,
          series = _ref2.series,
          seriesGroup = _ref2.seriesGroup,
          realIndex = _ref2.realIndex,
          i = _ref2.i,
          j = _ref2.j,
          w = _ref2.w;
        var graphics = new Graphics(this.barCtx.ctx);
        strokeWidth = Array.isArray(strokeWidth) ? strokeWidth[realIndex] : strokeWidth;
        if (!strokeWidth) strokeWidth = 0;
        var bW = barWidth;
        var bXP = barXPosition;
        if ((_w$config$series$real = w.config.series[realIndex].data[j]) !== null && _w$config$series$real !== void 0 && _w$config$series$real.columnWidthOffset) {
          bXP = barXPosition - w.config.series[realIndex].data[j].columnWidthOffset / 2;
          bW = barWidth + w.config.series[realIndex].data[j].columnWidthOffset;
        }

        // Center the stroke on the coordinates
        var strokeCenter = strokeWidth / 2;
        var x1 = bXP + strokeCenter;
        var x2 = bXP + bW - strokeCenter;
        var direction = (series[i][j] >= 0 ? 1 : -1) * (isReversed ? -1 : 1);

        // append tiny pixels to avoid exponentials (which cause issues in border-radius)
        y1 += 0.001 - strokeCenter * direction;
        y2 += 0.001 + strokeCenter * direction;
        var pathTo = graphics.move(x1, y1);
        var pathFrom = graphics.move(x1, y1);
        var sl = graphics.line(x2, y1);
        if (w.globals.previousPaths.length > 0) {
          pathFrom = this.barCtx.getPreviousPath(realIndex, j, false);
        }
        pathTo = pathTo + graphics.line(x1, y2) + graphics.line(x2, y2) + sl + (w.config.plotOptions.bar.borderRadiusApplication === 'around' || this.arrBorderRadius[realIndex][j] === 'both' ? ' Z' : ' z');

        // the lines in pathFrom are repeated to equal it to the points of pathTo
        // this is to avoid weird animation (bug in svg.js)
        pathFrom = pathFrom + graphics.line(x1, y1) + sl + sl + sl + sl + sl + graphics.line(x1, y1) + (w.config.plotOptions.bar.borderRadiusApplication === 'around' || this.arrBorderRadius[realIndex][j] === 'both' ? ' Z' : ' z');
        if (this.arrBorderRadius[realIndex][j] !== 'none') {
          pathTo = graphics.roundPathCorners(pathTo, w.config.plotOptions.bar.borderRadius);
        }
        if (w.config.chart.stacked) {
          var _ctx = this.barCtx;
          _ctx = this.barCtx[seriesGroup];
          _ctx.yArrj.push(y2 - strokeCenter * direction);
          _ctx.yArrjF.push(Math.abs(y1 - y2 + strokeWidth * direction));
          _ctx.yArrjVal.push(this.barCtx.series[i][j]);
        }
        return {
          pathTo: pathTo,
          pathFrom: pathFrom
        };
      }
    }, {
      key: "getBarpaths",
      value: function getBarpaths(_ref3) {
        var _w$config$series$real2;
        var barYPosition = _ref3.barYPosition,
          barHeight = _ref3.barHeight,
          x1 = _ref3.x1,
          x2 = _ref3.x2,
          strokeWidth = _ref3.strokeWidth,
          isReversed = _ref3.isReversed,
          series = _ref3.series,
          seriesGroup = _ref3.seriesGroup,
          realIndex = _ref3.realIndex,
          i = _ref3.i,
          j = _ref3.j,
          w = _ref3.w;
        var graphics = new Graphics(this.barCtx.ctx);
        strokeWidth = Array.isArray(strokeWidth) ? strokeWidth[realIndex] : strokeWidth;
        if (!strokeWidth) strokeWidth = 0;
        var bYP = barYPosition;
        var bH = barHeight;
        if ((_w$config$series$real2 = w.config.series[realIndex].data[j]) !== null && _w$config$series$real2 !== void 0 && _w$config$series$real2.barHeightOffset) {
          bYP = barYPosition - w.config.series[realIndex].data[j].barHeightOffset / 2;
          bH = barHeight + w.config.series[realIndex].data[j].barHeightOffset;
        }

        // Center the stroke on the coordinates
        var strokeCenter = strokeWidth / 2;
        var y1 = bYP + strokeCenter;
        var y2 = bYP + bH - strokeCenter;
        var direction = (series[i][j] >= 0 ? 1 : -1) * (isReversed ? -1 : 1);

        // append tiny pixels to avoid exponentials (which cause issues in border-radius)
        x1 += 0.001 + strokeCenter * direction;
        x2 += 0.001 - strokeCenter * direction;
        var pathTo = graphics.move(x1, y1);
        var pathFrom = graphics.move(x1, y1);
        if (w.globals.previousPaths.length > 0) {
          pathFrom = this.barCtx.getPreviousPath(realIndex, j, false);
        }
        var sl = graphics.line(x1, y2);
        pathTo = pathTo + graphics.line(x2, y1) + graphics.line(x2, y2) + sl + (w.config.plotOptions.bar.borderRadiusApplication === 'around' || this.arrBorderRadius[realIndex][j] === 'both' ? ' Z' : ' z');
        pathFrom = pathFrom + graphics.line(x1, y1) + sl + sl + sl + sl + sl + graphics.line(x1, y1) + (w.config.plotOptions.bar.borderRadiusApplication === 'around' || this.arrBorderRadius[realIndex][j] === 'both' ? ' Z' : ' z');
        if (this.arrBorderRadius[realIndex][j] !== 'none') {
          pathTo = graphics.roundPathCorners(pathTo, w.config.plotOptions.bar.borderRadius);
        }
        if (w.config.chart.stacked) {
          var _ctx = this.barCtx;
          _ctx = this.barCtx[seriesGroup];
          _ctx.xArrj.push(x2 + strokeCenter * direction);
          _ctx.xArrjF.push(Math.abs(x1 - x2 - strokeWidth * direction));
          _ctx.xArrjVal.push(this.barCtx.series[i][j]);
        }
        return {
          pathTo: pathTo,
          pathFrom: pathFrom
        };
      }
    }, {
      key: "checkZeroSeries",
      value: function checkZeroSeries(_ref4) {
        var series = _ref4.series;
        var w = this.w;
        for (var zs = 0; zs < series.length; zs++) {
          var total = 0;
          for (var zsj = 0; zsj < series[w.globals.maxValsInArrayIndex].length; zsj++) {
            total += series[zs][zsj];
          }
          if (total === 0) {
            this.barCtx.zeroSerieses.push(zs);
          }
        }
      }
    }, {
      key: "getXForValue",
      value: function getXForValue(value, zeroW) {
        var zeroPositionForNull = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
        var xForVal = zeroPositionForNull ? zeroW : null;
        if (typeof value !== 'undefined' && value !== null) {
          xForVal = zeroW + value / this.barCtx.invertedYRatio - (this.barCtx.isReversed ? value / this.barCtx.invertedYRatio : 0) * 2;
        }
        return xForVal;
      }
    }, {
      key: "getYForValue",
      value: function getYForValue(value, zeroH, translationsIndex) {
        var zeroPositionForNull = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;
        var yForVal = zeroPositionForNull ? zeroH : null;
        if (typeof value !== 'undefined' && value !== null) {
          yForVal = zeroH - value / this.barCtx.yRatio[translationsIndex] + (this.barCtx.isReversed ? value / this.barCtx.yRatio[translationsIndex] : 0) * 2;
        }
        return yForVal;
      }
    }, {
      key: "getGoalValues",
      value: function getGoalValues(type, zeroW, zeroH, i, j, translationsIndex) {
        var _this = this;
        var w = this.w;
        var goals = [];
        var pushGoal = function pushGoal(value, attrs) {
          var _goals$push;
          goals.push((_goals$push = {}, _defineProperty(_goals$push, type, type === 'x' ? _this.getXForValue(value, zeroW, false) : _this.getYForValue(value, zeroH, translationsIndex, false)), _defineProperty(_goals$push, "attrs", attrs), _goals$push));
        };
        if (w.globals.seriesGoals[i] && w.globals.seriesGoals[i][j] && Array.isArray(w.globals.seriesGoals[i][j])) {
          w.globals.seriesGoals[i][j].forEach(function (goal) {
            pushGoal(goal.value, goal);
          });
        }
        if (this.barCtx.barOptions.isDumbbell && w.globals.seriesRange.length) {
          var colors = this.barCtx.barOptions.dumbbellColors ? this.barCtx.barOptions.dumbbellColors : w.globals.colors;
          var commonAttrs = {
            strokeHeight: type === 'x' ? 0 : w.globals.markers.size[i],
            strokeWidth: type === 'x' ? w.globals.markers.size[i] : 0,
            strokeDashArray: 0,
            strokeLineCap: 'round',
            strokeColor: Array.isArray(colors[i]) ? colors[i][0] : colors[i]
          };
          pushGoal(w.globals.seriesRangeStart[i][j], commonAttrs);
          pushGoal(w.globals.seriesRangeEnd[i][j], _objectSpread2(_objectSpread2({}, commonAttrs), {}, {
            strokeColor: Array.isArray(colors[i]) ? colors[i][1] : colors[i]
          }));
        }
        return goals;
      }
    }, {
      key: "drawGoalLine",
      value: function drawGoalLine(_ref5) {
        var barXPosition = _ref5.barXPosition,
          barYPosition = _ref5.barYPosition,
          goalX = _ref5.goalX,
          goalY = _ref5.goalY,
          barWidth = _ref5.barWidth,
          barHeight = _ref5.barHeight;
        var graphics = new Graphics(this.barCtx.ctx);
        var lineGroup = graphics.group({
          className: 'apexcharts-bar-goals-groups'
        });
        lineGroup.node.classList.add('apexcharts-element-hidden');
        this.barCtx.w.globals.delayedElements.push({
          el: lineGroup.node
        });
        lineGroup.attr('clip-path', "url(#gridRectMarkerMask".concat(this.barCtx.w.globals.cuid, ")"));
        var line = null;
        if (this.barCtx.isHorizontal) {
          if (Array.isArray(goalX)) {
            goalX.forEach(function (goal) {
              // Need a tiny margin of 1 each side so goals don't disappear at extremeties
              if (goal.x >= -1 && goal.x <= graphics.w.globals.gridWidth + 1) {
                var sHeight = typeof goal.attrs.strokeHeight !== 'undefined' ? goal.attrs.strokeHeight : barHeight / 2;
                var y = barYPosition + sHeight + barHeight / 2;
                line = graphics.drawLine(goal.x, y - sHeight * 2, goal.x, y, goal.attrs.strokeColor ? goal.attrs.strokeColor : undefined, goal.attrs.strokeDashArray, goal.attrs.strokeWidth ? goal.attrs.strokeWidth : 2, goal.attrs.strokeLineCap);
                lineGroup.add(line);
              }
            });
          }
        } else {
          if (Array.isArray(goalY)) {
            goalY.forEach(function (goal) {
              // Need a tiny margin of 1 each side so goals don't disappear at extremeties
              if (goal.y >= -1 && goal.y <= graphics.w.globals.gridHeight + 1) {
                var sWidth = typeof goal.attrs.strokeWidth !== 'undefined' ? goal.attrs.strokeWidth : barWidth / 2;
                var x = barXPosition + sWidth + barWidth / 2;
                line = graphics.drawLine(x - sWidth * 2, goal.y, x, goal.y, goal.attrs.strokeColor ? goal.attrs.strokeColor : undefined, goal.attrs.strokeDashArray, goal.attrs.strokeHeight ? goal.attrs.strokeHeight : 2, goal.attrs.strokeLineCap);
                lineGroup.add(line);
              }
            });
          }
        }
        return lineGroup;
      }
    }, {
      key: "drawBarShadow",
      value: function drawBarShadow(_ref6) {
        var prevPaths = _ref6.prevPaths,
          currPaths = _ref6.currPaths,
          color = _ref6.color;
        var w = this.w;
        var prevX2 = prevPaths.x,
          prevX1 = prevPaths.x1,
          prevY1 = prevPaths.barYPosition;
        var currX2 = currPaths.x,
          currX1 = currPaths.x1,
          currY1 = currPaths.barYPosition;
        var prevY2 = prevY1 + currPaths.barHeight;
        var graphics = new Graphics(this.barCtx.ctx);
        var utils = new Utils$1();
        var shadowPath = graphics.move(prevX1, prevY2) + graphics.line(prevX2, prevY2) + graphics.line(currX2, currY1) + graphics.line(currX1, currY1) + graphics.line(prevX1, prevY2) + (w.config.plotOptions.bar.borderRadiusApplication === 'around' || this.arrBorderRadius[realIndex][j] === 'both' ? ' Z' : ' z');
        return graphics.drawPath({
          d: shadowPath,
          fill: utils.shadeColor(0.5, Utils$1.rgb2hex(color)),
          stroke: 'none',
          strokeWidth: 0,
          fillOpacity: 1,
          classes: 'apexcharts-bar-shadow apexcharts-decoration-element'
        });
      }
    }, {
      key: "getZeroValueEncounters",
      value: function getZeroValueEncounters(_ref7) {
        var _w$globals$columnSeri;
        var i = _ref7.i,
          j = _ref7.j;
        var w = this.w;
        var nonZeroColumns = 0;
        var zeroEncounters = 0;
        var seriesIndices = w.config.plotOptions.bar.horizontal ? w.globals.series.map(function (_, _i) {
          return _i;
        }) : ((_w$globals$columnSeri = w.globals.columnSeries) === null || _w$globals$columnSeri === void 0 ? void 0 : _w$globals$columnSeri.i.map(function (_i) {
          return _i;
        })) || [];
        seriesIndices.forEach(function (_si) {
          var val = w.globals.seriesPercent[_si][j];
          if (val) {
            nonZeroColumns++;
          }
          if (_si < i && val === 0) {
            zeroEncounters++;
          }
        });
        return {
          nonZeroColumns: nonZeroColumns,
          zeroEncounters: zeroEncounters
        };
      }
    }, {
      key: "getGroupIndex",
      value: function getGroupIndex(seriesIndex) {
        var w = this.w;
        // groupIndex is the index of group buckets (group1, group2, ...)
        var groupIndex = w.globals.seriesGroups.findIndex(function (group) {
          return (
            // w.config.series[i].name may be undefined, so use
            // w.globals.seriesNames[i], which has default names for those
            // series. w.globals.seriesGroups[] uses the same default naming.
            group.indexOf(w.globals.seriesNames[seriesIndex]) > -1
          );
        });
        // We need the column groups to be indexable as 0,1,2,... for their
        // positioning relative to each other.
        var cGI = this.barCtx.columnGroupIndices;
        var columnGroupIndex = cGI.indexOf(groupIndex);
        if (columnGroupIndex < 0) {
          cGI.push(groupIndex);
          columnGroupIndex = cGI.length - 1;
        }
        return {
          groupIndex: groupIndex,
          columnGroupIndex: columnGroupIndex
        };
      }
    }]);
    return Helpers;
  }();

  /**
   * ApexCharts Bar Class responsible for drawing both Columns and Bars.
   *
   * @module Bar
   **/
  var Bar = /*#__PURE__*/function () {
    function Bar(ctx, xyRatios) {
      _classCallCheck(this, Bar);
      this.ctx = ctx;
      this.w = ctx.w;
      var w = this.w;
      this.barOptions = w.config.plotOptions.bar;
      this.isHorizontal = this.barOptions.horizontal;
      this.strokeWidth = w.config.stroke.width;
      this.isNullValue = false;
      this.isRangeBar = w.globals.seriesRange.length && this.isHorizontal;
      this.isVerticalGroupedRangeBar = !w.globals.isBarHorizontal && w.globals.seriesRange.length && w.config.plotOptions.bar.rangeBarGroupRows;
      this.isFunnel = this.barOptions.isFunnel;
      this.xyRatios = xyRatios;
      if (this.xyRatios !== null) {
        this.xRatio = xyRatios.xRatio;
        this.yRatio = xyRatios.yRatio;
        this.invertedXRatio = xyRatios.invertedXRatio;
        this.invertedYRatio = xyRatios.invertedYRatio;
        this.baseLineY = xyRatios.baseLineY;
        this.baseLineInvertedY = xyRatios.baseLineInvertedY;
      }
      this.yaxisIndex = 0;
      this.translationsIndex = 0;
      this.seriesLen = 0;
      this.pathArr = [];
      var ser = new Series(this.ctx);
      this.lastActiveBarSerieIndex = ser.getActiveConfigSeriesIndex('desc', ['bar', 'column']);
      this.columnGroupIndices = [];
      var barSeriesIndices = ser.getBarSeriesIndices();
      var coreUtils = new CoreUtils(this.ctx);
      this.stackedSeriesTotals = coreUtils.getStackedSeriesTotals(this.w.config.series.map(function (s, i) {
        return barSeriesIndices.indexOf(i) === -1 ? i : -1;
      }).filter(function (s) {
        return s !== -1;
      }));
      this.barHelpers = new Helpers$1(this);
    }

    /** primary draw method which is called on bar object
     * @memberof Bar
     * @param {array} series - user supplied series values
     * @param {int} seriesIndex - the index by which series will be drawn on the svg
     * @return {node} element which is supplied to parent chart draw method for appending
     **/
    _createClass(Bar, [{
      key: "draw",
      value: function draw(series, seriesIndex) {
        var w = this.w;
        var graphics = new Graphics(this.ctx);
        var coreUtils = new CoreUtils(this.ctx, w);
        series = coreUtils.getLogSeries(series);
        this.series = series;
        this.yRatio = coreUtils.getLogYRatios(this.yRatio);
        this.barHelpers.initVariables(series);
        var ret = graphics.group({
          class: 'apexcharts-bar-series apexcharts-plot-series'
        });
        if (w.config.dataLabels.enabled) {
          if (this.totalItems > this.barOptions.dataLabels.maxItems) {
            console.warn('WARNING: DataLabels are enabled but there are too many to display. This may cause performance issue when rendering - ApexCharts');
          }
        }
        for (var i = 0, bc = 0; i < series.length; i++, bc++) {
          var x = void 0,
            y = void 0,
            xDivision = void 0,
            // xDivision is the GRIDWIDTH divided by number of datapoints (columns)
            yDivision = void 0,
            // yDivision is the GRIDHEIGHT divided by number of datapoints (bars)
            zeroH = void 0,
            // zeroH is the baseline where 0 meets y axis
            zeroW = void 0; // zeroW is the baseline where 0 meets x axis

          var yArrj = []; // hold y values of current iterating series
          var xArrj = []; // hold x values of current iterating series

          var realIndex = w.globals.comboCharts ? seriesIndex[i] : i;
          var _this$barHelpers$getG = this.barHelpers.getGroupIndex(realIndex),
            columnGroupIndex = _this$barHelpers$getG.columnGroupIndex;

          // el to which series will be drawn
          var elSeries = graphics.group({
            class: "apexcharts-series",
            rel: i + 1,
            seriesName: Utils$1.escapeString(w.globals.seriesNames[realIndex]),
            'data:realIndex': realIndex
          });
          this.ctx.series.addCollapsedClassToSeries(elSeries, realIndex);
          if (series[i].length > 0) {
            this.visibleI = this.visibleI + 1;
          }
          var barHeight = 0;
          var barWidth = 0;
          if (this.yRatio.length > 1) {
            this.yaxisIndex = w.globals.seriesYAxisReverseMap[realIndex];
            this.translationsIndex = realIndex;
          }
          var translationsIndex = this.translationsIndex;
          this.isReversed = w.config.yaxis[this.yaxisIndex] && w.config.yaxis[this.yaxisIndex].reversed;
          var initPositions = this.barHelpers.initialPositions(realIndex);
          y = initPositions.y;
          barHeight = initPositions.barHeight;
          yDivision = initPositions.yDivision;
          zeroW = initPositions.zeroW;
          x = initPositions.x;
          barWidth = initPositions.barWidth;
          xDivision = initPositions.xDivision;
          zeroH = initPositions.zeroH;
          if (!this.isHorizontal) {
            xArrj.push(x + barWidth / 2);
          }

          // eldatalabels
          var elDataLabelsWrap = graphics.group({
            class: 'apexcharts-datalabels',
            'data:realIndex': realIndex
          });
          w.globals.delayedElements.push({
            el: elDataLabelsWrap.node
          });
          elDataLabelsWrap.node.classList.add('apexcharts-element-hidden');
          var elGoalsMarkers = graphics.group({
            class: 'apexcharts-bar-goals-markers'
          });
          var elBarShadows = graphics.group({
            class: 'apexcharts-bar-shadows'
          });
          w.globals.delayedElements.push({
            el: elBarShadows.node
          });
          elBarShadows.node.classList.add('apexcharts-element-hidden');
          for (var j = 0; j < series[i].length; j++) {
            var strokeWidth = this.barHelpers.getStrokeWidth(i, j, realIndex);
            var paths = null;
            var pathsParams = {
              indexes: {
                i: i,
                j: j,
                realIndex: realIndex,
                translationsIndex: translationsIndex,
                bc: bc
              },
              x: x,
              y: y,
              strokeWidth: strokeWidth,
              elSeries: elSeries
            };
            if (this.isHorizontal) {
              paths = this.drawBarPaths(_objectSpread2(_objectSpread2({}, pathsParams), {}, {
                barHeight: barHeight,
                zeroW: zeroW,
                yDivision: yDivision
              }));
              barWidth = this.series[i][j] / this.invertedYRatio;
            } else {
              paths = this.drawColumnPaths(_objectSpread2(_objectSpread2({}, pathsParams), {}, {
                xDivision: xDivision,
                barWidth: barWidth,
                zeroH: zeroH
              }));
              barHeight = this.series[i][j] / this.yRatio[translationsIndex];
            }
            var pathFill = this.barHelpers.getPathFillColor(series, i, j, realIndex);
            if (this.isFunnel && this.barOptions.isFunnel3d && this.pathArr.length && j > 0) {
              var _pathFill$color;
              var barShadow = this.barHelpers.drawBarShadow({
                color: typeof pathFill.color === 'string' && ((_pathFill$color = pathFill.color) === null || _pathFill$color === void 0 ? void 0 : _pathFill$color.indexOf('url')) === -1 ? pathFill.color : Utils$1.hexToRgba(w.globals.colors[i]),
                prevPaths: this.pathArr[this.pathArr.length - 1],
                currPaths: paths
              });
              elBarShadows.add(barShadow);
              if (w.config.chart.dropShadow.enabled) {
                var filters = new Filters(this.ctx);
                filters.dropShadow(barShadow, w.config.chart.dropShadow, realIndex);
              }
            }
            this.pathArr.push(paths);
            var barGoalLine = this.barHelpers.drawGoalLine({
              barXPosition: paths.barXPosition,
              barYPosition: paths.barYPosition,
              goalX: paths.goalX,
              goalY: paths.goalY,
              barHeight: barHeight,
              barWidth: barWidth
            });
            if (barGoalLine) {
              elGoalsMarkers.add(barGoalLine);
            }
            y = paths.y;
            x = paths.x;

            // push current X
            if (j > 0) {
              xArrj.push(x + barWidth / 2);
            }
            yArrj.push(y);
            this.renderSeries(_objectSpread2(_objectSpread2({
              realIndex: realIndex,
              pathFill: pathFill.color
            }, pathFill.useRangeColor ? {
              lineFill: pathFill.color
            } : {}), {}, {
              j: j,
              i: i,
              columnGroupIndex: columnGroupIndex,
              pathFrom: paths.pathFrom,
              pathTo: paths.pathTo,
              strokeWidth: strokeWidth,
              elSeries: elSeries,
              x: x,
              y: y,
              series: series,
              barHeight: Math.abs(paths.barHeight ? paths.barHeight : barHeight),
              barWidth: Math.abs(paths.barWidth ? paths.barWidth : barWidth),
              elDataLabelsWrap: elDataLabelsWrap,
              elGoalsMarkers: elGoalsMarkers,
              elBarShadows: elBarShadows,
              visibleSeries: this.visibleI,
              type: 'bar'
            }));
          }

          // push all x val arrays into main xArr
          w.globals.seriesXvalues[realIndex] = xArrj;
          w.globals.seriesYvalues[realIndex] = yArrj;
          ret.add(elSeries);
        }
        return ret;
      }
    }, {
      key: "renderSeries",
      value: function renderSeries(_ref) {
        var realIndex = _ref.realIndex,
          pathFill = _ref.pathFill,
          lineFill = _ref.lineFill,
          j = _ref.j,
          i = _ref.i,
          columnGroupIndex = _ref.columnGroupIndex,
          pathFrom = _ref.pathFrom,
          pathTo = _ref.pathTo,
          strokeWidth = _ref.strokeWidth,
          elSeries = _ref.elSeries,
          x = _ref.x,
          y = _ref.y,
          y1 = _ref.y1,
          y2 = _ref.y2,
          series = _ref.series,
          barHeight = _ref.barHeight,
          barWidth = _ref.barWidth,
          barXPosition = _ref.barXPosition,
          barYPosition = _ref.barYPosition,
          elDataLabelsWrap = _ref.elDataLabelsWrap,
          elGoalsMarkers = _ref.elGoalsMarkers,
          elBarShadows = _ref.elBarShadows,
          visibleSeries = _ref.visibleSeries,
          type = _ref.type,
          classes = _ref.classes;
        var w = this.w;
        var graphics = new Graphics(this.ctx);
        var skipDrawing = false;
        if (!lineFill) {
          // if user provided a function in colors, we need to eval here
          // Note: the position of this function logic (ex. stroke: { colors: ["",function(){}] }) i.e array index 1 depicts the realIndex/seriesIndex.
          var fetchColor = function fetchColor(i) {
            var exp = w.config.stroke.colors;
            var c;
            if (Array.isArray(exp) && exp.length > 0) {
              c = exp[i];
              if (!c) c = '';
              if (typeof c === 'function') {
                return c({
                  value: w.globals.series[i][j],
                  dataPointIndex: j,
                  w: w
                });
              }
            }
            return c;
          };
          var checkAvailableColor = typeof w.globals.stroke.colors[realIndex] === 'function' ? fetchColor(realIndex) : w.globals.stroke.colors[realIndex];

          /* fix apexcharts#341 */
          lineFill = this.barOptions.distributed ? w.globals.stroke.colors[j] : checkAvailableColor;
        }
        var barDataLabels = new BarDataLabels(this);
        var dataLabelsObj = barDataLabels.handleBarDataLabels({
          x: x,
          y: y,
          y1: y1,
          y2: y2,
          i: i,
          j: j,
          series: series,
          realIndex: realIndex,
          columnGroupIndex: columnGroupIndex,
          barHeight: barHeight,
          barWidth: barWidth,
          barXPosition: barXPosition,
          barYPosition: barYPosition,
          visibleSeries: visibleSeries
        });
        if (!w.globals.isBarHorizontal) {
          if (dataLabelsObj.dataLabelsPos.dataLabelsX + Math.max(barWidth, w.globals.barPadForNumericAxis) < 0 || dataLabelsObj.dataLabelsPos.dataLabelsX - Math.max(barWidth, w.globals.barPadForNumericAxis) > w.globals.gridWidth) {
            skipDrawing = true;
          }
        }
        if (w.config.series[i].data[j] && w.config.series[i].data[j].strokeColor) {
          lineFill = w.config.series[i].data[j].strokeColor;
        }
        if (this.isNullValue) {
          pathFill = 'none';
        }
        var delay = j / w.config.chart.animations.animateGradually.delay * (w.config.chart.animations.speed / w.globals.dataPoints) / 2.4;
        if (!skipDrawing) {
          var renderedPath = graphics.renderPaths({
            i: i,
            j: j,
            realIndex: realIndex,
            pathFrom: pathFrom,
            pathTo: pathTo,
            stroke: lineFill,
            strokeWidth: strokeWidth,
            strokeLineCap: w.config.stroke.lineCap,
            fill: pathFill,
            animationDelay: delay,
            initialSpeed: w.config.chart.animations.speed,
            dataChangeSpeed: w.config.chart.animations.dynamicAnimation.speed,
            className: "apexcharts-".concat(type, "-area ").concat(classes),
            chartType: type
          });
          renderedPath.attr('clip-path', "url(#gridRectBarMask".concat(w.globals.cuid, ")"));
          var forecast = w.config.forecastDataPoints;
          if (forecast.count > 0) {
            if (j >= w.globals.dataPoints - forecast.count) {
              renderedPath.node.setAttribute('stroke-dasharray', forecast.dashArray);
              renderedPath.node.setAttribute('stroke-width', forecast.strokeWidth);
              renderedPath.node.setAttribute('fill-opacity', forecast.fillOpacity);
            }
          }
          if (typeof y1 !== 'undefined' && typeof y2 !== 'undefined') {
            renderedPath.attr('data-range-y1', y1);
            renderedPath.attr('data-range-y2', y2);
          }
          var filters = new Filters(this.ctx);
          filters.setSelectionFilter(renderedPath, realIndex, j);
          elSeries.add(renderedPath);
          renderedPath.attr({
            cy: dataLabelsObj.dataLabelsPos.bcy,
            cx: dataLabelsObj.dataLabelsPos.bcx,
            j: j,
            val: w.globals.series[i][j],
            barHeight: barHeight,
            barWidth: barWidth
          });
          if (dataLabelsObj.dataLabels !== null) {
            elDataLabelsWrap.add(dataLabelsObj.dataLabels);
          }
          if (dataLabelsObj.totalDataLabels) {
            elDataLabelsWrap.add(dataLabelsObj.totalDataLabels);
          }
          elSeries.add(elDataLabelsWrap);
          if (elGoalsMarkers) {
            elSeries.add(elGoalsMarkers);
          }
          if (elBarShadows) {
            elSeries.add(elBarShadows);
          }
        }
        return elSeries;
      }
    }, {
      key: "drawBarPaths",
      value: function drawBarPaths(_ref2) {
        var indexes = _ref2.indexes,
          barHeight = _ref2.barHeight,
          strokeWidth = _ref2.strokeWidth,
          zeroW = _ref2.zeroW,
          x = _ref2.x,
          y = _ref2.y,
          yDivision = _ref2.yDivision,
          elSeries = _ref2.elSeries;
        var w = this.w;
        var i = indexes.i;
        var j = indexes.j;
        var barYPosition;
        if (w.globals.isXNumeric) {
          y = (w.globals.seriesX[i][j] - w.globals.minX) / this.invertedXRatio - barHeight;
          barYPosition = y + barHeight * this.visibleI;
        } else {
          if (w.config.plotOptions.bar.hideZeroBarsWhenGrouped) {
            var _this$barHelpers$getZ = this.barHelpers.getZeroValueEncounters({
                i: i,
                j: j
              }),
              nonZeroColumns = _this$barHelpers$getZ.nonZeroColumns,
              zeroEncounters = _this$barHelpers$getZ.zeroEncounters;
            if (nonZeroColumns > 0) {
              barHeight = this.seriesLen * barHeight / nonZeroColumns;
            }
            barYPosition = y + barHeight * this.visibleI;
            barYPosition -= barHeight * zeroEncounters;
          } else {
            barYPosition = y + barHeight * this.visibleI;
          }
        }
        if (this.isFunnel) {
          zeroW = zeroW - (this.barHelpers.getXForValue(this.series[i][j], zeroW) - zeroW) / 2;
        }
        x = this.barHelpers.getXForValue(this.series[i][j], zeroW);
        var paths = this.barHelpers.getBarpaths({
          barYPosition: barYPosition,
          barHeight: barHeight,
          x1: zeroW,
          x2: x,
          strokeWidth: strokeWidth,
          isReversed: this.isReversed,
          series: this.series,
          realIndex: indexes.realIndex,
          i: i,
          j: j,
          w: w
        });
        if (!w.globals.isXNumeric) {
          y = y + yDivision;
        }
        this.barHelpers.barBackground({
          j: j,
          i: i,
          y1: barYPosition - barHeight * this.visibleI,
          y2: barHeight * this.seriesLen,
          elSeries: elSeries
        });
        return {
          pathTo: paths.pathTo,
          pathFrom: paths.pathFrom,
          x1: zeroW,
          x: x,
          y: y,
          goalX: this.barHelpers.getGoalValues('x', zeroW, null, i, j),
          barYPosition: barYPosition,
          barHeight: barHeight
        };
      }
    }, {
      key: "drawColumnPaths",
      value: function drawColumnPaths(_ref3) {
        var indexes = _ref3.indexes,
          x = _ref3.x,
          y = _ref3.y,
          xDivision = _ref3.xDivision,
          barWidth = _ref3.barWidth,
          zeroH = _ref3.zeroH,
          strokeWidth = _ref3.strokeWidth,
          elSeries = _ref3.elSeries;
        var w = this.w;
        var realIndex = indexes.realIndex;
        var translationsIndex = indexes.translationsIndex;
        var i = indexes.i;
        var j = indexes.j;
        var bc = indexes.bc;
        var barXPosition;
        if (w.globals.isXNumeric) {
          var xForNumericX = this.getBarXForNumericXAxis({
            x: x,
            j: j,
            realIndex: realIndex,
            barWidth: barWidth
          });
          x = xForNumericX.x;
          barXPosition = xForNumericX.barXPosition;
        } else {
          if (w.config.plotOptions.bar.hideZeroBarsWhenGrouped) {
            var _this$barHelpers$getZ2 = this.barHelpers.getZeroValueEncounters({
                i: i,
                j: j
              }),
              nonZeroColumns = _this$barHelpers$getZ2.nonZeroColumns,
              zeroEncounters = _this$barHelpers$getZ2.zeroEncounters;
            if (nonZeroColumns > 0) {
              barWidth = this.seriesLen * barWidth / nonZeroColumns;
            }
            barXPosition = x + barWidth * this.visibleI;
            barXPosition -= barWidth * zeroEncounters;
          } else {
            barXPosition = x + barWidth * this.visibleI;
          }
        }
        y = this.barHelpers.getYForValue(this.series[i][j], zeroH, translationsIndex);
        var paths = this.barHelpers.getColumnPaths({
          barXPosition: barXPosition,
          barWidth: barWidth,
          y1: zeroH,
          y2: y,
          strokeWidth: strokeWidth,
          isReversed: this.isReversed,
          series: this.series,
          realIndex: realIndex,
          i: i,
          j: j,
          w: w
        });
        if (!w.globals.isXNumeric) {
          x = x + xDivision;
        }
        this.barHelpers.barBackground({
          bc: bc,
          j: j,
          i: i,
          x1: barXPosition - strokeWidth / 2 - barWidth * this.visibleI,
          x2: barWidth * this.seriesLen + strokeWidth / 2,
          elSeries: elSeries
        });
        return {
          pathTo: paths.pathTo,
          pathFrom: paths.pathFrom,
          x: x,
          y: y,
          goalY: this.barHelpers.getGoalValues('y', null, zeroH, i, j, translationsIndex),
          barXPosition: barXPosition,
          barWidth: barWidth
        };
      }
    }, {
      key: "getBarXForNumericXAxis",
      value: function getBarXForNumericXAxis(_ref4) {
        var x = _ref4.x,
          barWidth = _ref4.barWidth,
          realIndex = _ref4.realIndex,
          j = _ref4.j;
        var w = this.w;
        var sxI = realIndex;
        if (!w.globals.seriesX[realIndex].length) {
          sxI = w.globals.maxValsInArrayIndex;
        }
        if (Utils$1.isNumber(w.globals.seriesX[sxI][j])) {
          x = (w.globals.seriesX[sxI][j] - w.globals.minX) / this.xRatio - barWidth * this.seriesLen / 2;
        }
        return {
          barXPosition: x + barWidth * this.visibleI,
          x: x
        };
      }

      /** getPreviousPath is a common function for bars/columns which is used to get previous paths when data changes.
       * @memberof Bar
       * @param {int} realIndex - current iterating i
       * @param {int} j - current iterating series's j index
       * @return {string} pathFrom is the string which will be appended in animations
       **/
    }, {
      key: "getPreviousPath",
      value: function getPreviousPath(realIndex, j) {
        var w = this.w;
        var pathFrom = 'M 0 0';
        for (var pp = 0; pp < w.globals.previousPaths.length; pp++) {
          var gpp = w.globals.previousPaths[pp];
          if (gpp.paths && gpp.paths.length > 0 && parseInt(gpp.realIndex, 10) === parseInt(realIndex, 10)) {
            if (typeof w.globals.previousPaths[pp].paths[j] !== 'undefined') {
              pathFrom = w.globals.previousPaths[pp].paths[j].d;
            }
          }
        }
        return pathFrom;
      }
    }]);
    return Bar;
  }();

  /**
   * ApexCharts BarStacked Class responsible for drawing both Stacked Columns and Bars.
   *
   * @module BarStacked
   * The whole calculation for stacked bar/column is different from normal bar/column,
   * hence it makes sense to derive a new class for it extending most of the props of Parent Bar
   **/
  var BarStacked = /*#__PURE__*/function (_Bar) {
    _inherits(BarStacked, _Bar);
    var _super = _createSuper(BarStacked);
    function BarStacked() {
      _classCallCheck(this, BarStacked);
      return _super.apply(this, arguments);
    }
    _createClass(BarStacked, [{
      key: "draw",
      value: function draw(series, seriesIndex) {
        var _this = this;
        var w = this.w;
        this.graphics = new Graphics(this.ctx);
        this.bar = new Bar(this.ctx, this.xyRatios);
        var coreUtils = new CoreUtils(this.ctx, w);
        series = coreUtils.getLogSeries(series);
        this.yRatio = coreUtils.getLogYRatios(this.yRatio);
        this.barHelpers.initVariables(series);
        if (w.config.chart.stackType === '100%') {
          series = w.globals.comboCharts ? seriesIndex.map(function (_) {
            return w.globals.seriesPercent[_];
          }) : w.globals.seriesPercent.slice();
        }
        this.series = series;
        this.barHelpers.initializeStackedPrevVars(this);
        var ret = this.graphics.group({
          class: 'apexcharts-bar-series apexcharts-plot-series'
        });
        var x = 0;
        var y = 0;
        var _loop = function _loop(i, bc) {
          var xDivision = void 0; // xDivision is the GRIDWIDTH divided by number of datapoints (columns)
          var yDivision = void 0; // yDivision is the GRIDHEIGHT divided by number of datapoints (bars)
          var zeroH = void 0; // zeroH is the baseline where 0 meets y axis
          var zeroW = void 0; // zeroW is the baseline where 0 meets x axis

          var realIndex = w.globals.comboCharts ? seriesIndex[i] : i;
          var _this$barHelpers$getG = _this.barHelpers.getGroupIndex(realIndex),
            groupIndex = _this$barHelpers$getG.groupIndex,
            columnGroupIndex = _this$barHelpers$getG.columnGroupIndex;
          _this.groupCtx = _this[w.globals.seriesGroups[groupIndex]];
          var xArrValues = [];
          var yArrValues = [];
          var translationsIndex = 0;
          if (_this.yRatio.length > 1) {
            _this.yaxisIndex = w.globals.seriesYAxisReverseMap[realIndex][0];
            translationsIndex = realIndex;
          }
          _this.isReversed = w.config.yaxis[_this.yaxisIndex] && w.config.yaxis[_this.yaxisIndex].reversed;

          // el to which series will be drawn
          var elSeries = _this.graphics.group({
            class: "apexcharts-series",
            seriesName: Utils$1.escapeString(w.globals.seriesNames[realIndex]),
            rel: i + 1,
            'data:realIndex': realIndex
          });
          _this.ctx.series.addCollapsedClassToSeries(elSeries, realIndex);

          // eldatalabels
          var elDataLabelsWrap = _this.graphics.group({
            class: 'apexcharts-datalabels',
            'data:realIndex': realIndex
          });
          var elGoalsMarkers = _this.graphics.group({
            class: 'apexcharts-bar-goals-markers'
          });
          var barHeight = 0;
          var barWidth = 0;
          var initPositions = _this.initialPositions(x, y, xDivision, yDivision, zeroH, zeroW, translationsIndex);
          y = initPositions.y;
          barHeight = initPositions.barHeight;
          yDivision = initPositions.yDivision;
          zeroW = initPositions.zeroW;
          x = initPositions.x;
          barWidth = initPositions.barWidth;
          xDivision = initPositions.xDivision;
          zeroH = initPositions.zeroH;
          w.globals.barHeight = barHeight;
          w.globals.barWidth = barWidth;
          _this.barHelpers.initializeStackedXYVars(_this);

          // where all stack bar disappear after collapsing the first series
          if (_this.groupCtx.prevY.length === 1 && _this.groupCtx.prevY[0].every(function (val) {
            return isNaN(val);
          })) {
            _this.groupCtx.prevY[0] = _this.groupCtx.prevY[0].map(function () {
              return zeroH;
            });
            _this.groupCtx.prevYF[0] = _this.groupCtx.prevYF[0].map(function () {
              return 0;
            });
          }
          for (var j = 0; j < w.globals.dataPoints; j++) {
            var strokeWidth = _this.barHelpers.getStrokeWidth(i, j, realIndex);
            var commonPathOpts = {
              indexes: {
                i: i,
                j: j,
                realIndex: realIndex,
                translationsIndex: translationsIndex,
                bc: bc
              },
              strokeWidth: strokeWidth,
              x: x,
              y: y,
              elSeries: elSeries,
              columnGroupIndex: columnGroupIndex,
              seriesGroup: w.globals.seriesGroups[groupIndex]
            };
            var paths = null;
            if (_this.isHorizontal) {
              paths = _this.drawStackedBarPaths(_objectSpread2(_objectSpread2({}, commonPathOpts), {}, {
                zeroW: zeroW,
                barHeight: barHeight,
                yDivision: yDivision
              }));
              barWidth = _this.series[i][j] / _this.invertedYRatio;
            } else {
              paths = _this.drawStackedColumnPaths(_objectSpread2(_objectSpread2({}, commonPathOpts), {}, {
                xDivision: xDivision,
                barWidth: barWidth,
                zeroH: zeroH
              }));
              barHeight = _this.series[i][j] / _this.yRatio[translationsIndex];
            }
            var barGoalLine = _this.barHelpers.drawGoalLine({
              barXPosition: paths.barXPosition,
              barYPosition: paths.barYPosition,
              goalX: paths.goalX,
              goalY: paths.goalY,
              barHeight: barHeight,
              barWidth: barWidth
            });
            if (barGoalLine) {
              elGoalsMarkers.add(barGoalLine);
            }
            y = paths.y;
            x = paths.x;
            xArrValues.push(x);
            yArrValues.push(y);
            var pathFill = _this.barHelpers.getPathFillColor(series, i, j, realIndex);
            var classes = '';
            var flipClass = w.globals.isBarHorizontal ? 'apexcharts-flip-x' : 'apexcharts-flip-y';
            if (_this.barHelpers.arrBorderRadius[realIndex][j] === 'bottom' && w.globals.series[realIndex][j] > 0 || _this.barHelpers.arrBorderRadius[realIndex][j] === 'top' && w.globals.series[realIndex][j] < 0) {
              classes = flipClass;
            }
            elSeries = _this.renderSeries(_objectSpread2(_objectSpread2({
              realIndex: realIndex,
              pathFill: pathFill.color
            }, pathFill.useRangeColor ? {
              lineFill: pathFill.color
            } : {}), {}, {
              j: j,
              i: i,
              columnGroupIndex: columnGroupIndex,
              pathFrom: paths.pathFrom,
              pathTo: paths.pathTo,
              strokeWidth: strokeWidth,
              elSeries: elSeries,
              x: x,
              y: y,
              series: series,
              barHeight: barHeight,
              barWidth: barWidth,
              elDataLabelsWrap: elDataLabelsWrap,
              elGoalsMarkers: elGoalsMarkers,
              type: 'bar',
              visibleSeries: columnGroupIndex,
              classes: classes
            }));
          }

          // push all x val arrays into main xArr
          w.globals.seriesXvalues[realIndex] = xArrValues;
          w.globals.seriesYvalues[realIndex] = yArrValues;

          // push all current y values array to main PrevY Array
          _this.groupCtx.prevY.push(_this.groupCtx.yArrj);
          _this.groupCtx.prevYF.push(_this.groupCtx.yArrjF);
          _this.groupCtx.prevYVal.push(_this.groupCtx.yArrjVal);
          _this.groupCtx.prevX.push(_this.groupCtx.xArrj);
          _this.groupCtx.prevXF.push(_this.groupCtx.xArrjF);
          _this.groupCtx.prevXVal.push(_this.groupCtx.xArrjVal);
          ret.add(elSeries);
        };
        for (var i = 0, bc = 0; i < series.length; i++, bc++) {
          _loop(i, bc);
        }
        return ret;
      }
    }, {
      key: "initialPositions",
      value: function initialPositions(x, y