# ast-kit [![npm](https://img.shields.io/npm/v/ast-kit.svg)](https://npmjs.com/package/ast-kit) [![JSR](https://jsr.io/badges/@sxzz/ast-kit)](https://jsr.io/@sxzz/ast-kit) [![Unit Test](https://github.com/sxzz/ast-kit/actions/workflows/unit-test.yml/badge.svg)](https://github.com/sxzz/ast-kit/actions/workflows/unit-test.yml) [![codecov](https://codecov.io/gh/sxzz/ast-kit/graph/badge.svg?token=MHTCPNMZAK)](https://codecov.io/gh/sxzz/ast-kit)

A toolkit for easy Babel AST generation and manipulation.

[📖 API Reference](https://jsr.io/@sxzz/ast-kit/doc)

## Features

- **😇 Easy to Use**: Parse and resolve Babel AST with a straightforward API.
- **🦾 Type-Friendly**: Built in TypeScript with complete type definitions.
- **💯 Coverage**: 100% test coverage.
- **🪶 Lightweight**: Tree-shakable with only two dependencies.

## Install

```bash
npm i ast-kit
```

Requires Node.js 16.14.0 or higher.

## AST Explorer

You can explore your code's AST using the [AST Explorer](https://ast.sxzz.moe/).

## Sponsors

<p align="center">
  <a href="https://cdn.jsdelivr.net/gh/sxzz/sponsors/sponsors.svg">
    <img src='https://cdn.jsdelivr.net/gh/sxzz/sponsors/sponsors.svg'/>
  </a>
</p>

## License

[MIT](./LICENSE) License © 2023-PRESENT [三咲智子](https://github.com/sxzz)
