type Presets = 'softwares' | 'products' | 'general' | 'brands' | 'abbreviates';
declare const DICT_FOLDER: string;
declare const IGNORE_KEY = "@case-police-ignore";
declare const DISABLE_KEY = "@case-police-disable";
declare const IGNORE_REGEX: RegExp;
declare const UTF8_RANGE = "[\u0080-\uFFFF]";
declare function buildRegex(dictionary: Record<string, string>): RegExp;
declare function replaceCore(code: string, dict: Record<string, string>, ignore?: string[], output?: (code: string, index: number, from: string, to: string) => void, regex?: RegExp): string | undefined;
declare function replace(code: string, id: string, _dict?: Record<string, string>, regex?: RegExp, _ignore?: string[]): Promise<string | undefined>;
declare function resolvePreset(preset: string): Promise<{}>;
declare function loadAllPresets(): Promise<any>;
declare function loadDictPresets(preset: string): Promise<{}>;

export { DICT_FOLDER, DISABLE_KEY, IGNORE_KEY, IGNORE_REGEX, Presets, UTF8_RANGE, buildRegex, loadAllPresets, loadDictPresets, replace, replaceCore, resolvePreset };
