"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _isStandardSyntaxAtRule = _interopRequireDefault(require("../../utils/isStandardSyntaxAtRule.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
var ruleName = "at-rule-name-case";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expected: function expected(actual, _expected) {
    return "Expected \"".concat(actual, "\" to be \"").concat(_expected, "\"");
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/at-rule-name-case/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, _secondary, context) {
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["lower", "upper"]
    });
    if (!validOptions) {
      return;
    }

    /** @type {'lower' | 'upper'} */
    var expectation = primary;
    root.walkAtRules(function (atRule) {
      if (!(0, _isStandardSyntaxAtRule["default"])(atRule)) {
        return;
      }
      var name = atRule.name;
      var expectedName = expectation === "lower" ? name.toLowerCase() : name.toUpperCase();
      if (name === expectedName) {
        return;
      }
      if (context.fix) {
        atRule.name = expectedName;
        return;
      }
      (0, _report["default"])({
        message: messages.expected(name, expectedName),
        node: atRule,
        ruleName: ruleName,
        result: result
      });
    });
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;