"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _atRuleNameSpaceChecker = _interopRequireDefault(require("../atRuleNameSpaceChecker.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
var _whitespaceChecker = _interopRequireDefault(require("../../utils/whitespaceChecker.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
var ruleName = "at-rule-name-newline-after";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expectedAfter: function expectedAfter(name) {
    return "Expected newline after at-rule name \"".concat(name, "\"");
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/at-rule-name-newline-after/README.md"
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary) {
  var checker = (0, _whitespaceChecker["default"])("newline", primary, messages);
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["always", "always-multi-line"]
    });
    if (!validOptions) {
      return;
    }
    (0, _atRuleNameSpaceChecker["default"])({
      root: root,
      result: result,
      locationChecker: checker.afterOneOnly,
      checkedRuleName: ruleName
    });
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;