"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _hasBlock = _interopRequireDefault(require("../../utils/hasBlock.js"));
var _isStandardSyntaxAtRule = _interopRequireDefault(require("../../utils/isStandardSyntaxAtRule.js"));
var _nextNonCommentNode = _interopRequireDefault(require("../../utils/nextNonCommentNode.js"));
var _rawNodeString = _interopRequireDefault(require("../../utils/rawNodeString.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
var _whitespaceChecker = _interopRequireDefault(require("../../utils/whitespaceChecker.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
var ruleName = "at-rule-semicolon-newline-after";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expectedAfter: function expectedAfter() {
    return "Expected newline after \";\"";
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/at-rule-semicolon-newline-after/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, _secondary, context) {
  var checker = (0, _whitespaceChecker["default"])("newline", primary, messages);
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["always"]
    });
    if (!validOptions) {
      return;
    }
    root.walkAtRules(function (atRule) {
      var nextNode = atRule.next();
      if (!nextNode) {
        return;
      }
      if ((0, _hasBlock["default"])(atRule)) {
        return;
      }
      if (!(0, _isStandardSyntaxAtRule["default"])(atRule)) {
        return;
      }

      // Allow an end-of-line comment
      var nodeToCheck = (0, _nextNonCommentNode["default"])(nextNode);
      if (!nodeToCheck) {
        return;
      }
      checker.afterOneOnly({
        source: (0, _rawNodeString["default"])(nodeToCheck),
        index: -1,
        err: function err(msg) {
          if (context.fix) {
            nodeToCheck.raws.before = context.newline + nodeToCheck.raws.before;
          } else {
            (0, _report["default"])({
              message: msg,
              node: atRule,
              index: atRule.toString().length + 1,
              result: result,
              ruleName: ruleName
            });
          }
        }
      });
    });
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;