"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _hasBlock = _interopRequireDefault(require("../../utils/hasBlock.js"));
var _isStandardSyntaxAtRule = _interopRequireDefault(require("../../utils/isStandardSyntaxAtRule.js"));
var _rawNodeString = _interopRequireDefault(require("../../utils/rawNodeString.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
var _whitespaceChecker = _interopRequireDefault(require("../../utils/whitespaceChecker.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
var ruleName = "at-rule-semicolon-space-before";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expectedBefore: function expectedBefore() {
    return "Expected single space before \";\"";
  },
  rejectedBefore: function rejectedBefore() {
    return "Unexpected whitespace before \";\"";
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/at-rule-semicolon-space-before/README.md"
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary) {
  var checker = (0, _whitespaceChecker["default"])("space", primary, messages);
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["always", "never"]
    });
    if (!validOptions) {
      return;
    }
    root.walkAtRules(function (atRule) {
      if ((0, _hasBlock["default"])(atRule)) {
        return;
      }
      if (!(0, _isStandardSyntaxAtRule["default"])(atRule)) {
        return;
      }
      var nodeString = (0, _rawNodeString["default"])(atRule);
      checker.before({
        source: nodeString,
        index: nodeString.length,
        err: function err(m) {
          (0, _report["default"])({
            message: m,
            node: atRule,
            index: nodeString.length - 1,
            result: result,
            ruleName: ruleName
          });
        }
      });
    });
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;