"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = atRuleNameSpaceChecker;
var _isStandardSyntaxAtRule = _interopRequireDefault(require("../utils/isStandardSyntaxAtRule.js"));
var _report = _interopRequireDefault(require("../utils/report.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
/**
 * @param {{
 *   root: import('postcss').Root,
 *   locationChecker: (opts: { source: string, index: number, err: (msg: string) => void, errTarget: string }) => void,
 *   result: import('stylelint').PostcssResult,
 *   checkedRuleName: string,
 *   fix?: ((atRule: import('postcss').AtRule) => void) | null,
 * }} options
 */
function atRuleNameSpaceChecker(options) {
  options.root.walkAtRules(function (atRule) {
    if (!(0, _isStandardSyntaxAtRule["default"])(atRule)) {
      return;
    }
    checkColon("@".concat(atRule.name).concat(atRule.raws.afterName || "").concat(atRule.params), atRule.name.length, atRule);
  });

  /**
   * @param {string} source
   * @param {number} index
   * @param {import('postcss').AtRule} node
   */
  function checkColon(source, index, node) {
    options.locationChecker({
      source: source,
      index: index,
      err: function err(m) {
        if (options.fix) {
          options.fix(node);
          return;
        }
        (0, _report["default"])({
          message: m,
          node: node,
          index: index,
          result: options.result,
          ruleName: options.checkedRuleName
        });
      },
      errTarget: "@".concat(node.name)
    });
  }
}