"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _addEmptyLineAfter = _interopRequireDefault(require("../../utils/addEmptyLineAfter.js"));
var _blockString = _interopRequireDefault(require("../../utils/blockString.js"));
var _hasBlock = _interopRequireDefault(require("../../utils/hasBlock.js"));
var _hasEmptyBlock = _interopRequireDefault(require("../../utils/hasEmptyBlock.js"));
var _hasEmptyLine = _interopRequireDefault(require("../../utils/hasEmptyLine.js"));
var _isSingleLineString = _interopRequireDefault(require("../../utils/isSingleLineString.js"));
var _optionsMatches = _interopRequireDefault(require("../../utils/optionsMatches.js"));
var _removeEmptyLinesAfter = _interopRequireDefault(require("../../utils/removeEmptyLinesAfter.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var ruleName = "block-closing-brace-empty-line-before";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expected: "Expected empty line before closing brace",
  rejected: "Unexpected empty line before closing brace"
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/block-closing-brace-empty-line-before/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, secondaryOptions, context) {
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["always-multi-line", "never"]
    }, {
      actual: secondaryOptions,
      possible: {
        except: ["after-closing-brace"]
      },
      optional: true
    });
    if (!validOptions) {
      return;
    }

    // Check both kinds of statements: rules and at-rules
    root.walkRules(check);
    root.walkAtRules(check);

    /**
    	 * @param {import('postcss').Rule | import('postcss').AtRule} statement
    	 */
    function check(statement) {
      // Return early if blockless or has empty block
      if (!(0, _hasBlock["default"])(statement) || (0, _hasEmptyBlock["default"])(statement)) {
        return;
      }

      // Get whitespace after ""}", ignoring extra semicolon
      var before = (statement.raws.after || "").replace(/;+/, "");

      // Calculate index
      var statementString = statement.toString();
      var index = statementString.length - 1;
      if (statementString[index - 1] === "\r") {
        index -= 1;
      }

      // Set expectation
      var expectEmptyLineBefore = function () {
        var childNodeTypes = statement.nodes.map(function (item) {
          return item.type;
        });

        // Reverse the primary options if `after-closing-brace` is set
        if ((0, _optionsMatches["default"])(secondaryOptions, "except", "after-closing-brace") && statement.type === "atrule" && !childNodeTypes.includes("decl")) {
          return primary === "never";
        }
        return primary === "always-multi-line" && !(0, _isSingleLineString["default"])((0, _blockString["default"])(statement));
      }();

      // Check for at least one empty line
      var hasEmptyLineBefore = (0, _hasEmptyLine["default"])(before);

      // Return if the expectation is met
      if (expectEmptyLineBefore === hasEmptyLineBefore) {
        return;
      }
      if (context.fix) {
        var newline = context.newline;
        if (_typeof(newline) !== "string") {
          return;
        }
        if (expectEmptyLineBefore) {
          (0, _addEmptyLineAfter["default"])(statement, newline);
        } else {
          (0, _removeEmptyLinesAfter["default"])(statement, newline);
        }
        return;
      }
      var message = expectEmptyLineBefore ? messages.expected : messages.rejected;
      (0, _report["default"])({
        message: message,
        result: result,
        ruleName: ruleName,
        node: statement,
        index: index
      });
    }
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;